# AAMfP: a simple (Personal) Kanban metrics spreadsheet #
Copyright © 2017, 2018, 2019 Marco Bresciani.	

[![Creative Commons 
License](https://i.creativecommons.org/l/by-sa/4.0/88x31.png)](http://creativecommons.org/licenses/by-sa/4.0/)
*AAMfP: a simple (Personal) Kanban metrics spreadsheet* by *[Marco
Bresciani](https://bitbucket.org/marcobresciani/aamfp)* is licensed
under a [Creative Commons Attribution-ShareAlike 4.0 International
License](http://creativecommons.org/licenses/by-sa/4.0/).

![Free Cultural
Works](https://freedomdefined.org/upload/6/63/CCBYSA_black.png)
This is a freely licensed work, as explained in the [Definition of Free
Cultural Works](https://freedomdefined.org/Licenses).

Feel free to open an
[issue](https://bitbucket.org/marcobresciani/aamfp/issues) for bugs,
enhancements, proposals or tasks following the [Contributor Covenant
Code of Conduct](https://www.contributor-covenant.org/). For further
questions or requests, let's keep in touch:
 
 * [@AAMfP@fosstodon.org](https://fosstodon.org/@AAMfP) on the
   [Mastodon](https://en.wikipedia.org/wiki/Mastodon_(software))
   federated social network.
 * **AAMfP_** user (ring:2e5e3ab18b487d096464ed0a0b2c2af468a8838a) on
   the [GNU Jami](https://jami.net) (former GNU Ring, former SFLphone)
   distributed communication platform.

**[Kanban One](https://www.kanbanone.com)** is an online tool with the
features of this spreadsheet.

---

## Download ##
Current version is **v.13.0.0 'GSB84'**. See
[Downloads](https://bitbucket.org/marcobresciani/aamfp/downloads/).

For versions history see the
[Changelog](https://bitbucket.org/marcobresciani/aamfp/src/tip/CHANGELOG.md)
file.

---

## Intro ##
Improve your daily workflow with this
[LibreOffice](https://www.libreoffice.org/) Calc spreadsheet using the
concepts of [Personal Kanban](http://personalkanban.com/pk/) and
applying some flow metrics as described in the book [Actionable Agile
Metrics for Predictability](https://leanpub.com/actionableagilemetrics)
(and compatible with [Actionable Agile™
Analytics](https://www.actionableagile.com/) tool).

### Visualize your work ###
The project also contains contains PDF and ODG (LibreOffice Draw)
versions of an [A3 format](https://en.wikipedia.org/wiki/ISO_216)
printable Personal Kanban board with **Backlog**, **Next**,
**In-progress** and **Done** columns. Feel free to use it to visualize
your work items!

This Kanban board uses **Unifont** by Unifoundry for text purposes.
`Copyright (C) 1998-2018 Roman Czyborra, Paul Hardy, Qianqian Fang,
Andrew Miller, Johnnie Weaver, David Corbett, et al. License GPLv2+: GNU
GPL version 2 or later <http://gnu.org/licenses/gpl.html> with the GNU
Font Embedding Exception.`

### Limit your work-in-progress ###
Remember to add your WIP limit to each of the columns in the board
above, to be sure to properly apply Kanban concepts and obtain real
improvements.

----

## Usage ##
> Complete, detailed usage instructions and data explanations can be
found in the [Usage](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md)
file.

Briefly: the only sheet you need to work on is the
[WorkItems](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#WorkItems)
sheet where you need to add, for each work item, the dates when such
work items have changed state. **CoS** (Class of Service) and **WIT**
(Work Item Type) column values are not mandatory.

Please note that
[WorkItems](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#WorkItems)
sheet already contains some data. Those are example data to show you how
to use and write them. Feel free to remove them.

*While bug [#6](https://bitbucket.org/marcobresciani/aamfp/issues/6/)
is open*, when a work item has to be dropped/cancelled/abandoned/… for
any reason, you have to write such cancellation date in all remaining
columns cells and also write the same date in the **Deleted** column.
With this, the work item will be properly identified as deleted.

> In order to have correct metrics, chart, and data *you* have to keep
the *Workitems* sheet rows in the correct order. Specifically, select
the table and apply the following sorting criteria (all crescent order):
**Done**, **In-progress**, **Next**, **Deadline**, **Backlog**, **ID**.
Once the columns are ordered in this way, you can scroll all other
sheets where you can find the metrics and charts properly computed and
rendered.

**Deadline** column value is optional and the content is automatically
and conditionally formatted. Deadline is:
 * *today*, red cell;
 * *this week*, orange cell;
 * *this month*, yellow cell;
 * *next month*, green cell.
 * *expired completed activity*, red text.

The whole [WorkItems](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#WorkItems)
sheet is compatible with [Actionable Agile™
Analytics](https://www.actionableagile.com/) tool (see [Format for Data
File](https://www.actionableagile.com/format-data-file/)): simply export
[WorkItems](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#WorkItems)
sheet as CSV (select comma (**,**) as cell separator and quotes (**"**)
for fields) and then import it in the tool.

----

## References ##
For **Kanban** method starts from here:
[What is Kanban | Lean Kanban](https://leankanban.com/project/wkanban/)
and the [Essential Kanban Condensed 
Guide](https://leankanban.com/guide/).

For **Personal Kanban** starts from here: [Map your work, control your
life: Personal Kanban](http://personalkanban.com/pk/)
and [Personal Kanban: The Book | Personal
Kanban](http://personalkanban.com/pk/book/).

For more details and explanations on metrics please see the book
[Actionable Agile Metrics for
Predictability](https://leanpub.com/actionableagilemetrics) by Vacanti,
Daniel S..

**[Kanban One](https://www.kanbanone.com)** is an online tool with the
features of this spreadsheet.

## Thanks ##
Thanks to (in appearing order):

* [Gavi](https://bitbucket.org/classicPintus/) for having solved bug
[#1](https://bitbucket.org/marcobresciani/aamfp/issues/1/wrong-cfd-counting)
and for creating **[Kanban One](https://www.kanbanone.com)** together
with Francesco.

* [Samuele Accordini](https://it.linkedin.com/in/samueleaccordini) for
citing this spreadsheet in his LinkedIn article (in Italian) [Personal
Kanban: il trainer del
tempo](https://www.linkedin.com/pulse/personal-kanban-il-trainer-del-tempo-samuele-accordini).

* [Rudiger Wolf](https://bitbucket.org/rnwolf/) for having creating his
  [Pandas Agile Metrics](https://github.com/rnwolf/pandas_agile_metrics)
  project "Inspired by https://bitbucket.org/marcobresciani/aamfp/".

----

Copyright © 2017, 2018, 2019 Marco Bresciani.	

[![Creative Commons 
License](https://i.creativecommons.org/l/by-sa/4.0/88x31.png)](http://creativecommons.org/licenses/by-sa/4.0/)
AAMfP: a simple (Personal) Kanban metrics spreadsheet by [Marco
Bresciani](https://bitbucket.org/marcobresciani/aamfp) is licensed under
a [Creative Commons Attribution-ShareAlike 4.0 International
License](http://creativecommons.org/licenses/by-sa/4.0/).

![Free Cultural
Works](https://freedomdefined.org/upload/6/63/CCBYSA_black.png)
This is a freely licensed work, as explained in the [Definition of Free
Cultural Works](https://freedomdefined.org/Licenses).
