# AAMfP: a simple (Personal) Kanban metrics spreadsheet #
Copyright  2017, 2018 Marco Bresciani.	

![Creative Commons License](https://i.creativecommons.org/l/by-sa/4.0/80x15.png) *AAMfP: a simple (Personal) Kanban metrics spreadsheet* by *Marco Bresciani* is licensed under a [Creative Commons Attribution-ShareAlike 4.0 International License](http://creativecommons.org/licenses/by-sa/4.0/).

---

**DOWNLOAD** *v.10.0.0* (in [zip](https://bitbucket.org/marcobresciani/aamfp/get/v.10.0.0.zip), [tar.gz](https://bitbucket.org/marcobresciani/aamfp/get/v.10.0.0.tar.gz) or [tar.bz2](https://bitbucket.org/marcobresciani/aamfp/get/v.10.0.0.tar.bz2) format)

or find older versions and other download options from the [Downloads](https://bitbucket.org/marcobresciani/aamfp/downloads/) menu.

---

## Intro ##
Improve your daily work and activities with this LibreOffice Calc spreadsheet using the concepts of "Personal Kanban" and applying some flow metrics as described in the book *Actionable Agile Metrics for Predictability* (and compatible with ActionableAgile Analytics tool).

## Usage ##
**Complete, detailed usage instructions can be found at the [How to Use AAMfP](https://bitbucket.org/marcobresciani/aamfp/wiki/Usage%20Instructions) page.**

Briefly: the only sheet you need to modify is the "Activities" sheet where you need to add, for each activity, the dates when such activities have changed state. CoS (Class of Service) and WIT (Work Item Type) column values are not mandatory.

When an activity has to be dropped/cancelled/abandoned/&hellip; for any reason, you just have to write such cancellation date in all remaining columns cells and also write the same date in the "Deleted" column. With this, the activity will be properly identified as deleted.

In order to have correct metrics, chart, and data you have to keep the "Activities" sheet rows in the correct order. Specifically, sorting criteria are all following (crescent) ordered columns: "Done", "In-progress", "Next", "Deadline", "Backlog", "ID". Once the column are ordered in this way, you can scroll all other sheets where you can find the metrics and charts.

"Deadline" column value is optional and the content is conditionally formatted. Deadline is: today, red cell; this week, orange cell; this month, yellow cell; next month, green cell. Expired completed activity, red text.

The whole "Activities" sheet is compatible with ActionableAgile Analitycs tool (see [Format for Data File](https://www.actionableagile.com/format-data-file/)): simply export "Activities" sheet as CSV (select comma (**,**) as cell separator and quotes for *Name*s that contain commas) and then import it in the tool. 	

### Visualize your work ###
The project also contains contains a PDF and ODG (LibreOffice Draw) version of an A3 printable Personal Kanban board with "Backlog", "Next", "In-progress" (with "Blocked" area) and "Done" columns.

### Limit your work-in-progress ###
Remember to add your WIP limit to each of the columns in the board above, to be sure to properly apply Kanban concepts and obtain real improvements.

## History	##
See wiki [Home](https://bitbucket.org/marcobresciani/aamfp/wiki/Home) page for version history details. 

## Contributions ##
Ideas, contributions, issues, enhancements, ... are all welcome, following the [Contributor Covenant Code of Conduct](https://bitbucket.org/marcobresciani/aamfp/wiki/Contributor%20Covenant%20Code%20of%20Conduct) policies.

## References ##
For the **Kanban** method starts from here: https://leankanban.com/project/wkanban/ and the Essential Kanban Condensed Guide https://leankanban.com/guide/.

For **Personal Kanban** starts from here: http://personalkanban.com/pk/ and the reference book http://personalkanban.com/pk/book/.

For more details on metrics read the book *Actionable Agile Metrics for Predictability* by Vacanti, Daniel S. here https://leanpub.com/actionableagilemetrics.