
/* Python wrapper functions auto-generated by pidl */
#include <Python.h>
#include "includes.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "autoconf/librpc/gen_ndr/ndr_nbt.h"
#include "autoconf/librpc/gen_ndr/ndr_nbt_c.h"

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/security.h"
staticforward PyTypeObject nbt_name_Type;
staticforward PyTypeObject nbt_name_question_Type;
staticforward PyTypeObject nbt_rdata_address_Type;
staticforward PyTypeObject nbt_rdata_netbios_Type;
staticforward PyTypeObject nbt_statistics_Type;
staticforward PyTypeObject nbt_status_name_Type;
staticforward PyTypeObject nbt_rdata_status_Type;
staticforward PyTypeObject nbt_rdata_data_Type;
staticforward PyTypeObject nbt_res_rec_Type;
staticforward PyTypeObject nbt_name_packet_Type;
staticforward PyTypeObject smb_trans_body_Type;
staticforward PyTypeObject dgram_smb_packet_Type;
staticforward PyTypeObject dgram_message_Type;
staticforward PyTypeObject nbt_dgram_packet_Type;
staticforward PyTypeObject nbt_sockaddr_Type;
staticforward PyTypeObject NETLOGON_SAM_LOGON_REQUEST_Type;
staticforward PyTypeObject NETLOGON_LOGON_REQUEST_Type;
staticforward PyTypeObject NETLOGON_SAM_LOGON_RESPONSE_NT40_Type;
staticforward PyTypeObject NETLOGON_SAM_LOGON_RESPONSE_Type;
staticforward PyTypeObject NETLOGON_SAM_LOGON_RESPONSE_EX_Type;
staticforward PyTypeObject nbt_netlogon_query_for_pdc_Type;
staticforward PyTypeObject nbt_netlogon_response_from_pdc_Type;
staticforward PyTypeObject nbt_netlogon_response2_Type;
staticforward PyTypeObject nbt_db_change_info_Type;
staticforward PyTypeObject NETLOGON_DB_CHANGE_Type;
staticforward PyTypeObject nbt_netlogon_packet_Type;
staticforward PyTypeObject nbt_browse_host_announcement_Type;
staticforward PyTypeObject nbt_browse_announcement_request_Type;
staticforward PyTypeObject nbt_browse_election_request_Type;
staticforward PyTypeObject nbt_browse_backup_list_request_Type;
staticforward PyTypeObject nbt_browse_backup_list_response_Type;
staticforward PyTypeObject nbt_browse_become_backup_Type;
staticforward PyTypeObject nbt_browse_domain_announcement_Type;
staticforward PyTypeObject nbt_browse_master_announcement_Type;
staticforward PyTypeObject nbt_browse_reset_state_Type;
staticforward PyTypeObject nbt_browse_local_master_announcement_Type;
staticforward PyTypeObject nbt_browse_packet_Type;
staticforward PyTypeObject nbt_InterfaceType;

void initnbt(void);static PyTypeObject *GUID_Type;
static PyTypeObject *dom_sid_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *Object_Type;

static PyObject *py_nbt_name_get_name(PyObject *obj, void *closure)
{
	struct nbt_name *object = (struct nbt_name *)pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = PyString_FromStringOrNULL(object->name);
	return py_name;
}

static int py_nbt_name_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name *object = (struct nbt_name *)pytalloc_get_ptr(py_obj);
	object->name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_nbt_name_get_scope(PyObject *obj, void *closure)
{
	struct nbt_name *object = (struct nbt_name *)pytalloc_get_ptr(obj);
	PyObject *py_scope;
	py_scope = PyString_FromStringOrNULL(object->scope);
	return py_scope;
}

static int py_nbt_name_set_scope(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name *object = (struct nbt_name *)pytalloc_get_ptr(py_obj);
	object->scope = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_nbt_name_get_type(PyObject *obj, void *closure)
{
	struct nbt_name *object = (struct nbt_name *)pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyInt_FromLong(object->type);
	return py_type;
}

static int py_nbt_name_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name *object = (struct nbt_name *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyGetSetDef py_nbt_name_getsetters[] = {
	{ discard_const_p(char, "name"), py_nbt_name_get_name, py_nbt_name_set_name },
	{ discard_const_p(char, "scope"), py_nbt_name_get_scope, py_nbt_name_set_scope },
	{ discard_const_p(char, "type"), py_nbt_name_get_type, py_nbt_name_set_type },
	{ NULL }
};

static PyObject *py_nbt_name_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_name, type);
}

static PyObject *py_nbt_name_ndr_pack(PyObject *py_obj)
{
	struct nbt_name *object = (struct nbt_name *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_nbt_name);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_nbt_name_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct nbt_name *object = (struct nbt_name *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_name);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_name);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_nbt_name_ndr_print(PyObject *py_obj)
{
	struct nbt_name *object = (struct nbt_name *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_nbt_name, "nbt_name", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_nbt_name_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_nbt_name_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_nbt_name_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_nbt_name_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject nbt_name_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.name",
	.tp_getset = py_nbt_name_getsetters,
	.tp_methods = py_nbt_name_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_name_new,
};


static PyObject *py_nbt_name_question_get_name(PyObject *obj, void *closure)
{
	struct nbt_name_question *object = (struct nbt_name_question *)pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(&nbt_name_Type, pytalloc_get_mem_ctx(obj), &object->name);
	return py_name;
}

static int py_nbt_name_question_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_question *object = (struct nbt_name_question *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&nbt_name_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->name = *(struct nbt_name *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_nbt_name_question_get_question_type(PyObject *obj, void *closure)
{
	struct nbt_name_question *object = (struct nbt_name_question *)pytalloc_get_ptr(obj);
	PyObject *py_question_type;
	py_question_type = PyInt_FromLong(object->question_type);
	return py_question_type;
}

static int py_nbt_name_question_set_question_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_question *object = (struct nbt_name_question *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->question_type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->question_type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_nbt_name_question_get_question_class(PyObject *obj, void *closure)
{
	struct nbt_name_question *object = (struct nbt_name_question *)pytalloc_get_ptr(obj);
	PyObject *py_question_class;
	py_question_class = PyInt_FromLong(object->question_class);
	return py_question_class;
}

static int py_nbt_name_question_set_question_class(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_question *object = (struct nbt_name_question *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->question_class = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->question_class = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyGetSetDef py_nbt_name_question_getsetters[] = {
	{ discard_const_p(char, "name"), py_nbt_name_question_get_name, py_nbt_name_question_set_name },
	{ discard_const_p(char, "question_type"), py_nbt_name_question_get_question_type, py_nbt_name_question_set_question_type },
	{ discard_const_p(char, "question_class"), py_nbt_name_question_get_question_class, py_nbt_name_question_set_question_class },
	{ NULL }
};

static PyObject *py_nbt_name_question_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_name_question, type);
}


static PyTypeObject nbt_name_question_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.name_question",
	.tp_getset = py_nbt_name_question_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_name_question_new,
};


static PyObject *py_nbt_rdata_address_get_nb_flags(PyObject *obj, void *closure)
{
	struct nbt_rdata_address *object = (struct nbt_rdata_address *)pytalloc_get_ptr(obj);
	PyObject *py_nb_flags;
	py_nb_flags = PyInt_FromLong(object->nb_flags);
	return py_nb_flags;
}

static int py_nbt_rdata_address_set_nb_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_rdata_address *object = (struct nbt_rdata_address *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->nb_flags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->nb_flags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_nbt_rdata_address_get_ipaddr(PyObject *obj, void *closure)
{
	struct nbt_rdata_address *object = (struct nbt_rdata_address *)pytalloc_get_ptr(obj);
	PyObject *py_ipaddr;
	py_ipaddr = PyString_FromStringOrNULL(object->ipaddr);
	return py_ipaddr;
}

static int py_nbt_rdata_address_set_ipaddr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_rdata_address *object = (struct nbt_rdata_address *)pytalloc_get_ptr(py_obj);
	object->ipaddr = PyString_AS_STRING(value);
	return 0;
}

static PyGetSetDef py_nbt_rdata_address_getsetters[] = {
	{ discard_const_p(char, "nb_flags"), py_nbt_rdata_address_get_nb_flags, py_nbt_rdata_address_set_nb_flags },
	{ discard_const_p(char, "ipaddr"), py_nbt_rdata_address_get_ipaddr, py_nbt_rdata_address_set_ipaddr },
	{ NULL }
};

static PyObject *py_nbt_rdata_address_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_rdata_address, type);
}


static PyTypeObject nbt_rdata_address_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.rdata_address",
	.tp_getset = py_nbt_rdata_address_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_rdata_address_new,
};


static PyObject *py_nbt_rdata_netbios_get_length(PyObject *obj, void *closure)
{
	struct nbt_rdata_netbios *object = (struct nbt_rdata_netbios *)pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_nbt_rdata_netbios_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_rdata_netbios *object = (struct nbt_rdata_netbios *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_rdata_netbios_get_addresses(PyObject *obj, void *closure)
{
	struct nbt_rdata_netbios *object = (struct nbt_rdata_netbios *)pytalloc_get_ptr(obj);
	PyObject *py_addresses;
	py_addresses = PyList_New(object->length / 6);
	if (py_addresses == NULL) {
		return NULL;
	}
	{
		int addresses_cntr_0;
		for (addresses_cntr_0 = 0; addresses_cntr_0 < object->length / 6; addresses_cntr_0++) {
			PyObject *py_addresses_0;
			py_addresses_0 = pytalloc_reference_ex(&nbt_rdata_address_Type, object->addresses, &object->addresses[addresses_cntr_0]);
			PyList_SetItem(py_addresses, addresses_cntr_0, py_addresses_0);
		}
	}
	return py_addresses;
}

static int py_nbt_rdata_netbios_set_addresses(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_rdata_netbios *object = (struct nbt_rdata_netbios *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int addresses_cntr_0;
		object->addresses = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->addresses, PyList_GET_SIZE(value));
		if (!object->addresses) { return -1;; }
		talloc_set_name_const(object->addresses, "ARRAY: object->addresses");
		for (addresses_cntr_0 = 0; addresses_cntr_0 < PyList_GET_SIZE(value); addresses_cntr_0++) {
			PY_CHECK_TYPE(&nbt_rdata_address_Type, PyList_GET_ITEM(value, addresses_cntr_0), return -1;);
			if (talloc_reference(object->addresses, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, addresses_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->addresses[addresses_cntr_0] = *(struct nbt_rdata_address *)pytalloc_get_ptr(PyList_GET_ITEM(value, addresses_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_nbt_rdata_netbios_getsetters[] = {
	{ discard_const_p(char, "length"), py_nbt_rdata_netbios_get_length, py_nbt_rdata_netbios_set_length },
	{ discard_const_p(char, "addresses"), py_nbt_rdata_netbios_get_addresses, py_nbt_rdata_netbios_set_addresses },
	{ NULL }
};

static PyObject *py_nbt_rdata_netbios_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_rdata_netbios, type);
}


static PyTypeObject nbt_rdata_netbios_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.rdata_netbios",
	.tp_getset = py_nbt_rdata_netbios_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_rdata_netbios_new,
};


static PyObject *py_nbt_statistics_get_unit_id(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(obj);
	PyObject *py_unit_id;
	py_unit_id = PyList_New(6);
	if (py_unit_id == NULL) {
		return NULL;
	}
	{
		int unit_id_cntr_0;
		for (unit_id_cntr_0 = 0; unit_id_cntr_0 < 6; unit_id_cntr_0++) {
			PyObject *py_unit_id_0;
			py_unit_id_0 = PyInt_FromLong(object->unit_id[unit_id_cntr_0]);
			PyList_SetItem(py_unit_id, unit_id_cntr_0, py_unit_id_0);
		}
	}
	return py_unit_id;
}

static int py_nbt_statistics_set_unit_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int unit_id_cntr_0;
		for (unit_id_cntr_0 = 0; unit_id_cntr_0 < PyList_GET_SIZE(value); unit_id_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, unit_id_cntr_0), return -1;);
			object->unit_id[unit_id_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, unit_id_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_nbt_statistics_get_jumpers(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(obj);
	PyObject *py_jumpers;
	py_jumpers = PyInt_FromLong(object->jumpers);
	return py_jumpers;
}

static int py_nbt_statistics_set_jumpers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->jumpers = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_statistics_get_test_result(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(obj);
	PyObject *py_test_result;
	py_test_result = PyInt_FromLong(object->test_result);
	return py_test_result;
}

static int py_nbt_statistics_set_test_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->test_result = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_statistics_get_version_number(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(obj);
	PyObject *py_version_number;
	py_version_number = PyInt_FromLong(object->version_number);
	return py_version_number;
}

static int py_nbt_statistics_set_version_number(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->version_number = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_statistics_get_period_of_statistics(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(obj);
	PyObject *py_period_of_statistics;
	py_period_of_statistics = PyInt_FromLong(object->period_of_statistics);
	return py_period_of_statistics;
}

static int py_nbt_statistics_set_period_of_statistics(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->period_of_statistics = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_statistics_get_number_of_crcs(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(obj);
	PyObject *py_number_of_crcs;
	py_number_of_crcs = PyInt_FromLong(object->number_of_crcs);
	return py_number_of_crcs;
}

static int py_nbt_statistics_set_number_of_crcs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->number_of_crcs = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_statistics_get_number_alignment_errors(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(obj);
	PyObject *py_number_alignment_errors;
	py_number_alignment_errors = PyInt_FromLong(object->number_alignment_errors);
	return py_number_alignment_errors;
}

static int py_nbt_statistics_set_number_alignment_errors(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->number_alignment_errors = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_statistics_get_number_of_collisions(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(obj);
	PyObject *py_number_of_collisions;
	py_number_of_collisions = PyInt_FromLong(object->number_of_collisions);
	return py_number_of_collisions;
}

static int py_nbt_statistics_set_number_of_collisions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->number_of_collisions = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_statistics_get_number_send_aborts(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(obj);
	PyObject *py_number_send_aborts;
	py_number_send_aborts = PyInt_FromLong(object->number_send_aborts);
	return py_number_send_aborts;
}

static int py_nbt_statistics_set_number_send_aborts(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->number_send_aborts = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_statistics_get_number_good_sends(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(obj);
	PyObject *py_number_good_sends;
	py_number_good_sends = PyInt_FromLong(object->number_good_sends);
	return py_number_good_sends;
}

static int py_nbt_statistics_set_number_good_sends(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->number_good_sends = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_statistics_get_number_good_receives(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(obj);
	PyObject *py_number_good_receives;
	py_number_good_receives = PyInt_FromLong(object->number_good_receives);
	return py_number_good_receives;
}

static int py_nbt_statistics_set_number_good_receives(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->number_good_receives = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_statistics_get_number_retransmits(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(obj);
	PyObject *py_number_retransmits;
	py_number_retransmits = PyInt_FromLong(object->number_retransmits);
	return py_number_retransmits;
}

static int py_nbt_statistics_set_number_retransmits(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->number_retransmits = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_statistics_get_number_no_resource_conditions(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(obj);
	PyObject *py_number_no_resource_conditions;
	py_number_no_resource_conditions = PyInt_FromLong(object->number_no_resource_conditions);
	return py_number_no_resource_conditions;
}

static int py_nbt_statistics_set_number_no_resource_conditions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->number_no_resource_conditions = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_statistics_get_number_free_command_blocks(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(obj);
	PyObject *py_number_free_command_blocks;
	py_number_free_command_blocks = PyInt_FromLong(object->number_free_command_blocks);
	return py_number_free_command_blocks;
}

static int py_nbt_statistics_set_number_free_command_blocks(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->number_free_command_blocks = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_statistics_get_total_number_command_blocks(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(obj);
	PyObject *py_total_number_command_blocks;
	py_total_number_command_blocks = PyInt_FromLong(object->total_number_command_blocks);
	return py_total_number_command_blocks;
}

static int py_nbt_statistics_set_total_number_command_blocks(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->total_number_command_blocks = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_statistics_get_max_total_number_command_blocks(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(obj);
	PyObject *py_max_total_number_command_blocks;
	py_max_total_number_command_blocks = PyInt_FromLong(object->max_total_number_command_blocks);
	return py_max_total_number_command_blocks;
}

static int py_nbt_statistics_set_max_total_number_command_blocks(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->max_total_number_command_blocks = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_statistics_get_number_pending_sessions(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(obj);
	PyObject *py_number_pending_sessions;
	py_number_pending_sessions = PyInt_FromLong(object->number_pending_sessions);
	return py_number_pending_sessions;
}

static int py_nbt_statistics_set_number_pending_sessions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->number_pending_sessions = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_statistics_get_max_number_pending_sessions(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(obj);
	PyObject *py_max_number_pending_sessions;
	py_max_number_pending_sessions = PyInt_FromLong(object->max_number_pending_sessions);
	return py_max_number_pending_sessions;
}

static int py_nbt_statistics_set_max_number_pending_sessions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->max_number_pending_sessions = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_statistics_get_max_total_sessions_possible(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(obj);
	PyObject *py_max_total_sessions_possible;
	py_max_total_sessions_possible = PyInt_FromLong(object->max_total_sessions_possible);
	return py_max_total_sessions_possible;
}

static int py_nbt_statistics_set_max_total_sessions_possible(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->max_total_sessions_possible = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_statistics_get_session_data_packet_size(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(obj);
	PyObject *py_session_data_packet_size;
	py_session_data_packet_size = PyInt_FromLong(object->session_data_packet_size);
	return py_session_data_packet_size;
}

static int py_nbt_statistics_set_session_data_packet_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = (struct nbt_statistics *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->session_data_packet_size = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_nbt_statistics_getsetters[] = {
	{ discard_const_p(char, "unit_id"), py_nbt_statistics_get_unit_id, py_nbt_statistics_set_unit_id },
	{ discard_const_p(char, "jumpers"), py_nbt_statistics_get_jumpers, py_nbt_statistics_set_jumpers },
	{ discard_const_p(char, "test_result"), py_nbt_statistics_get_test_result, py_nbt_statistics_set_test_result },
	{ discard_const_p(char, "version_number"), py_nbt_statistics_get_version_number, py_nbt_statistics_set_version_number },
	{ discard_const_p(char, "period_of_statistics"), py_nbt_statistics_get_period_of_statistics, py_nbt_statistics_set_period_of_statistics },
	{ discard_const_p(char, "number_of_crcs"), py_nbt_statistics_get_number_of_crcs, py_nbt_statistics_set_number_of_crcs },
	{ discard_const_p(char, "number_alignment_errors"), py_nbt_statistics_get_number_alignment_errors, py_nbt_statistics_set_number_alignment_errors },
	{ discard_const_p(char, "number_of_collisions"), py_nbt_statistics_get_number_of_collisions, py_nbt_statistics_set_number_of_collisions },
	{ discard_const_p(char, "number_send_aborts"), py_nbt_statistics_get_number_send_aborts, py_nbt_statistics_set_number_send_aborts },
	{ discard_const_p(char, "number_good_sends"), py_nbt_statistics_get_number_good_sends, py_nbt_statistics_set_number_good_sends },
	{ discard_const_p(char, "number_good_receives"), py_nbt_statistics_get_number_good_receives, py_nbt_statistics_set_number_good_receives },
	{ discard_const_p(char, "number_retransmits"), py_nbt_statistics_get_number_retransmits, py_nbt_statistics_set_number_retransmits },
	{ discard_const_p(char, "number_no_resource_conditions"), py_nbt_statistics_get_number_no_resource_conditions, py_nbt_statistics_set_number_no_resource_conditions },
	{ discard_const_p(char, "number_free_command_blocks"), py_nbt_statistics_get_number_free_command_blocks, py_nbt_statistics_set_number_free_command_blocks },
	{ discard_const_p(char, "total_number_command_blocks"), py_nbt_statistics_get_total_number_command_blocks, py_nbt_statistics_set_total_number_command_blocks },
	{ discard_const_p(char, "max_total_number_command_blocks"), py_nbt_statistics_get_max_total_number_command_blocks, py_nbt_statistics_set_max_total_number_command_blocks },
	{ discard_const_p(char, "number_pending_sessions"), py_nbt_statistics_get_number_pending_sessions, py_nbt_statistics_set_number_pending_sessions },
	{ discard_const_p(char, "max_number_pending_sessions"), py_nbt_statistics_get_max_number_pending_sessions, py_nbt_statistics_set_max_number_pending_sessions },
	{ discard_const_p(char, "max_total_sessions_possible"), py_nbt_statistics_get_max_total_sessions_possible, py_nbt_statistics_set_max_total_sessions_possible },
	{ discard_const_p(char, "session_data_packet_size"), py_nbt_statistics_get_session_data_packet_size, py_nbt_statistics_set_session_data_packet_size },
	{ NULL }
};

static PyObject *py_nbt_statistics_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_statistics, type);
}


static PyTypeObject nbt_statistics_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.statistics",
	.tp_getset = py_nbt_statistics_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_statistics_new,
};


static PyObject *py_nbt_status_name_get_name(PyObject *obj, void *closure)
{
	struct nbt_status_name *object = (struct nbt_status_name *)pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
	}
	return py_name;
}

static int py_nbt_status_name_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_status_name *object = (struct nbt_status_name *)pytalloc_get_ptr(py_obj);
	if (PyUnicode_Check(value)) {
		object->name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	} else if (PyString_Check(value)) {
		object->name = PyString_AS_STRING(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_nbt_status_name_get_type(PyObject *obj, void *closure)
{
	struct nbt_status_name *object = (struct nbt_status_name *)pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyInt_FromLong(object->type);
	return py_type;
}

static int py_nbt_status_name_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_status_name *object = (struct nbt_status_name *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_nbt_status_name_get_nb_flags(PyObject *obj, void *closure)
{
	struct nbt_status_name *object = (struct nbt_status_name *)pytalloc_get_ptr(obj);
	PyObject *py_nb_flags;
	py_nb_flags = PyInt_FromLong(object->nb_flags);
	return py_nb_flags;
}

static int py_nbt_status_name_set_nb_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_status_name *object = (struct nbt_status_name *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->nb_flags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->nb_flags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyGetSetDef py_nbt_status_name_getsetters[] = {
	{ discard_const_p(char, "name"), py_nbt_status_name_get_name, py_nbt_status_name_set_name },
	{ discard_const_p(char, "type"), py_nbt_status_name_get_type, py_nbt_status_name_set_type },
	{ discard_const_p(char, "nb_flags"), py_nbt_status_name_get_nb_flags, py_nbt_status_name_set_nb_flags },
	{ NULL }
};

static PyObject *py_nbt_status_name_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_status_name, type);
}


static PyTypeObject nbt_status_name_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.status_name",
	.tp_getset = py_nbt_status_name_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_status_name_new,
};


static PyObject *py_nbt_rdata_status_get_length(PyObject *obj, void *closure)
{
	struct nbt_rdata_status *object = (struct nbt_rdata_status *)pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_nbt_rdata_status_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_rdata_status *object = (struct nbt_rdata_status *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_rdata_status_get_num_names(PyObject *obj, void *closure)
{
	struct nbt_rdata_status *object = (struct nbt_rdata_status *)pytalloc_get_ptr(obj);
	PyObject *py_num_names;
	py_num_names = PyInt_FromLong(object->num_names);
	return py_num_names;
}

static int py_nbt_rdata_status_set_num_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_rdata_status *object = (struct nbt_rdata_status *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_names = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_rdata_status_get_names(PyObject *obj, void *closure)
{
	struct nbt_rdata_status *object = (struct nbt_rdata_status *)pytalloc_get_ptr(obj);
	PyObject *py_names;
	py_names = PyList_New(object->num_names);
	if (py_names == NULL) {
		return NULL;
	}
	{
		int names_cntr_0;
		for (names_cntr_0 = 0; names_cntr_0 < object->num_names; names_cntr_0++) {
			PyObject *py_names_0;
			py_names_0 = pytalloc_reference_ex(&nbt_status_name_Type, object->names, &object->names[names_cntr_0]);
			PyList_SetItem(py_names, names_cntr_0, py_names_0);
		}
	}
	return py_names;
}

static int py_nbt_rdata_status_set_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_rdata_status *object = (struct nbt_rdata_status *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int names_cntr_0;
		object->names = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->names, PyList_GET_SIZE(value));
		if (!object->names) { return -1;; }
		talloc_set_name_const(object->names, "ARRAY: object->names");
		for (names_cntr_0 = 0; names_cntr_0 < PyList_GET_SIZE(value); names_cntr_0++) {
			PY_CHECK_TYPE(&nbt_status_name_Type, PyList_GET_ITEM(value, names_cntr_0), return -1;);
			if (talloc_reference(object->names, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, names_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->names[names_cntr_0] = *(struct nbt_status_name *)pytalloc_get_ptr(PyList_GET_ITEM(value, names_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_nbt_rdata_status_get_statistics(PyObject *obj, void *closure)
{
	struct nbt_rdata_status *object = (struct nbt_rdata_status *)pytalloc_get_ptr(obj);
	PyObject *py_statistics;
	py_statistics = pytalloc_reference_ex(&nbt_statistics_Type, pytalloc_get_mem_ctx(obj), &object->statistics);
	return py_statistics;
}

static int py_nbt_rdata_status_set_statistics(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_rdata_status *object = (struct nbt_rdata_status *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&nbt_statistics_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->statistics = *(struct nbt_statistics *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_nbt_rdata_status_getsetters[] = {
	{ discard_const_p(char, "length"), py_nbt_rdata_status_get_length, py_nbt_rdata_status_set_length },
	{ discard_const_p(char, "num_names"), py_nbt_rdata_status_get_num_names, py_nbt_rdata_status_set_num_names },
	{ discard_const_p(char, "names"), py_nbt_rdata_status_get_names, py_nbt_rdata_status_set_names },
	{ discard_const_p(char, "statistics"), py_nbt_rdata_status_get_statistics, py_nbt_rdata_status_set_statistics },
	{ NULL }
};

static PyObject *py_nbt_rdata_status_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_rdata_status, type);
}


static PyTypeObject nbt_rdata_status_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.rdata_status",
	.tp_getset = py_nbt_rdata_status_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_rdata_status_new,
};


static PyObject *py_nbt_rdata_data_get_length(PyObject *obj, void *closure)
{
	struct nbt_rdata_data *object = (struct nbt_rdata_data *)pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_nbt_rdata_data_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_rdata_data *object = (struct nbt_rdata_data *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_rdata_data_get_data(PyObject *obj, void *closure)
{
	struct nbt_rdata_data *object = (struct nbt_rdata_data *)pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyList_New(object->length);
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < object->length; data_cntr_0++) {
			PyObject *py_data_0;
			py_data_0 = PyInt_FromLong(object->data[data_cntr_0]);
			PyList_SetItem(py_data, data_cntr_0, py_data_0);
		}
	}
	return py_data;
}

static int py_nbt_rdata_data_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_rdata_data *object = (struct nbt_rdata_data *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int data_cntr_0;
		object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
		if (!object->data) { return -1;; }
		talloc_set_name_const(object->data, "ARRAY: object->data");
		for (data_cntr_0 = 0; data_cntr_0 < PyList_GET_SIZE(value); data_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, data_cntr_0), return -1;);
			object->data[data_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, data_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_nbt_rdata_data_getsetters[] = {
	{ discard_const_p(char, "length"), py_nbt_rdata_data_get_length, py_nbt_rdata_data_set_length },
	{ discard_const_p(char, "data"), py_nbt_rdata_data_get_data, py_nbt_rdata_data_set_data },
	{ NULL }
};

static PyObject *py_nbt_rdata_data_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_rdata_data, type);
}


static PyTypeObject nbt_rdata_data_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.rdata_data",
	.tp_getset = py_nbt_rdata_data_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_rdata_data_new,
};

PyObject *py_import_nbt_rdata(TALLOC_CTX *mem_ctx, int level, union nbt_rdata *in)
{
	PyObject *ret;

	switch (level) {
		case NBT_QTYPE_NETBIOS:
			ret = pytalloc_reference_ex(&nbt_rdata_netbios_Type, mem_ctx, &in->netbios);
			return ret;

		case NBT_QTYPE_STATUS:
			ret = pytalloc_reference_ex(&nbt_rdata_status_Type, mem_ctx, &in->status);
			return ret;

		default:
			ret = pytalloc_reference_ex(&nbt_rdata_data_Type, mem_ctx, &in->data);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union nbt_rdata *py_export_nbt_rdata(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union nbt_rdata *ret = talloc_zero(mem_ctx, union nbt_rdata);
	switch (level) {
		case NBT_QTYPE_NETBIOS:
			PY_CHECK_TYPE(&nbt_rdata_netbios_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->netbios = *(struct nbt_rdata_netbios *)pytalloc_get_ptr(in);
			break;

		case NBT_QTYPE_STATUS:
			PY_CHECK_TYPE(&nbt_rdata_status_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->status = *(struct nbt_rdata_status *)pytalloc_get_ptr(in);
			break;

		default:
			PY_CHECK_TYPE(&nbt_rdata_data_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->data = *(struct nbt_rdata_data *)pytalloc_get_ptr(in);
			break;

	}

	return ret;
}


static PyObject *py_nbt_res_rec_get_name(PyObject *obj, void *closure)
{
	struct nbt_res_rec *object = (struct nbt_res_rec *)pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(&nbt_name_Type, pytalloc_get_mem_ctx(obj), &object->name);
	return py_name;
}

static int py_nbt_res_rec_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_res_rec *object = (struct nbt_res_rec *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&nbt_name_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->name = *(struct nbt_name *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_nbt_res_rec_get_rr_type(PyObject *obj, void *closure)
{
	struct nbt_res_rec *object = (struct nbt_res_rec *)pytalloc_get_ptr(obj);
	PyObject *py_rr_type;
	py_rr_type = PyInt_FromLong(object->rr_type);
	return py_rr_type;
}

static int py_nbt_res_rec_set_rr_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_res_rec *object = (struct nbt_res_rec *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->rr_type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->rr_type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_nbt_res_rec_get_rr_class(PyObject *obj, void *closure)
{
	struct nbt_res_rec *object = (struct nbt_res_rec *)pytalloc_get_ptr(obj);
	PyObject *py_rr_class;
	py_rr_class = PyInt_FromLong(object->rr_class);
	return py_rr_class;
}

static int py_nbt_res_rec_set_rr_class(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_res_rec *object = (struct nbt_res_rec *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->rr_class = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->rr_class = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_nbt_res_rec_get_ttl(PyObject *obj, void *closure)
{
	struct nbt_res_rec *object = (struct nbt_res_rec *)pytalloc_get_ptr(obj);
	PyObject *py_ttl;
	py_ttl = PyInt_FromLong(object->ttl);
	return py_ttl;
}

static int py_nbt_res_rec_set_ttl(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_res_rec *object = (struct nbt_res_rec *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ttl = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_res_rec_get_rdata(PyObject *obj, void *closure)
{
	struct nbt_res_rec *object = (struct nbt_res_rec *)pytalloc_get_ptr(obj);
	PyObject *py_rdata;
	py_rdata = py_import_nbt_rdata(pytalloc_get_mem_ctx(obj), object->rr_type, &object->rdata);
	if (py_rdata == NULL) {
		return NULL;
	}
	return py_rdata;
}

static int py_nbt_res_rec_set_rdata(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_res_rec *object = (struct nbt_res_rec *)pytalloc_get_ptr(py_obj);
	{
		union nbt_rdata *rdata_switch_0;
		rdata_switch_0 = py_export_nbt_rdata(pytalloc_get_mem_ctx(py_obj), object->rr_type, value);
		if (rdata_switch_0 == NULL) {
			return -1;
		}
		object->rdata = *rdata_switch_0;
	}
	return 0;
}

static PyGetSetDef py_nbt_res_rec_getsetters[] = {
	{ discard_const_p(char, "name"), py_nbt_res_rec_get_name, py_nbt_res_rec_set_name },
	{ discard_const_p(char, "rr_type"), py_nbt_res_rec_get_rr_type, py_nbt_res_rec_set_rr_type },
	{ discard_const_p(char, "rr_class"), py_nbt_res_rec_get_rr_class, py_nbt_res_rec_set_rr_class },
	{ discard_const_p(char, "ttl"), py_nbt_res_rec_get_ttl, py_nbt_res_rec_set_ttl },
	{ discard_const_p(char, "rdata"), py_nbt_res_rec_get_rdata, py_nbt_res_rec_set_rdata },
	{ NULL }
};

static PyObject *py_nbt_res_rec_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_res_rec, type);
}


static PyTypeObject nbt_res_rec_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.res_rec",
	.tp_getset = py_nbt_res_rec_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_res_rec_new,
};


static PyObject *py_nbt_name_packet_get_name_trn_id(PyObject *obj, void *closure)
{
	struct nbt_name_packet *object = (struct nbt_name_packet *)pytalloc_get_ptr(obj);
	PyObject *py_name_trn_id;
	py_name_trn_id = PyInt_FromLong(object->name_trn_id);
	return py_name_trn_id;
}

static int py_nbt_name_packet_set_name_trn_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_packet *object = (struct nbt_name_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->name_trn_id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_name_packet_get_operation(PyObject *obj, void *closure)
{
	struct nbt_name_packet *object = (struct nbt_name_packet *)pytalloc_get_ptr(obj);
	PyObject *py_operation;
	py_operation = PyInt_FromLong(object->operation);
	return py_operation;
}

static int py_nbt_name_packet_set_operation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_packet *object = (struct nbt_name_packet *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->operation = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->operation = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_nbt_name_packet_get_qdcount(PyObject *obj, void *closure)
{
	struct nbt_name_packet *object = (struct nbt_name_packet *)pytalloc_get_ptr(obj);
	PyObject *py_qdcount;
	py_qdcount = PyInt_FromLong(object->qdcount);
	return py_qdcount;
}

static int py_nbt_name_packet_set_qdcount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_packet *object = (struct nbt_name_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->qdcount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_name_packet_get_ancount(PyObject *obj, void *closure)
{
	struct nbt_name_packet *object = (struct nbt_name_packet *)pytalloc_get_ptr(obj);
	PyObject *py_ancount;
	py_ancount = PyInt_FromLong(object->ancount);
	return py_ancount;
}

static int py_nbt_name_packet_set_ancount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_packet *object = (struct nbt_name_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ancount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_name_packet_get_nscount(PyObject *obj, void *closure)
{
	struct nbt_name_packet *object = (struct nbt_name_packet *)pytalloc_get_ptr(obj);
	PyObject *py_nscount;
	py_nscount = PyInt_FromLong(object->nscount);
	return py_nscount;
}

static int py_nbt_name_packet_set_nscount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_packet *object = (struct nbt_name_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->nscount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_name_packet_get_arcount(PyObject *obj, void *closure)
{
	struct nbt_name_packet *object = (struct nbt_name_packet *)pytalloc_get_ptr(obj);
	PyObject *py_arcount;
	py_arcount = PyInt_FromLong(object->arcount);
	return py_arcount;
}

static int py_nbt_name_packet_set_arcount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_packet *object = (struct nbt_name_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->arcount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_name_packet_get_questions(PyObject *obj, void *closure)
{
	struct nbt_name_packet *object = (struct nbt_name_packet *)pytalloc_get_ptr(obj);
	PyObject *py_questions;
	py_questions = PyList_New(object->qdcount);
	if (py_questions == NULL) {
		return NULL;
	}
	{
		int questions_cntr_0;
		for (questions_cntr_0 = 0; questions_cntr_0 < object->qdcount; questions_cntr_0++) {
			PyObject *py_questions_0;
			py_questions_0 = pytalloc_reference_ex(&nbt_name_question_Type, object->questions, &object->questions[questions_cntr_0]);
			PyList_SetItem(py_questions, questions_cntr_0, py_questions_0);
		}
	}
	return py_questions;
}

static int py_nbt_name_packet_set_questions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_packet *object = (struct nbt_name_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int questions_cntr_0;
		object->questions = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->questions, PyList_GET_SIZE(value));
		if (!object->questions) { return -1;; }
		talloc_set_name_const(object->questions, "ARRAY: object->questions");
		for (questions_cntr_0 = 0; questions_cntr_0 < PyList_GET_SIZE(value); questions_cntr_0++) {
			PY_CHECK_TYPE(&nbt_name_question_Type, PyList_GET_ITEM(value, questions_cntr_0), return -1;);
			if (talloc_reference(object->questions, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, questions_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->questions[questions_cntr_0] = *(struct nbt_name_question *)pytalloc_get_ptr(PyList_GET_ITEM(value, questions_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_nbt_name_packet_get_answers(PyObject *obj, void *closure)
{
	struct nbt_name_packet *object = (struct nbt_name_packet *)pytalloc_get_ptr(obj);
	PyObject *py_answers;
	py_answers = PyList_New(object->ancount);
	if (py_answers == NULL) {
		return NULL;
	}
	{
		int answers_cntr_0;
		for (answers_cntr_0 = 0; answers_cntr_0 < object->ancount; answers_cntr_0++) {
			PyObject *py_answers_0;
			py_answers_0 = pytalloc_reference_ex(&nbt_res_rec_Type, object->answers, &object->answers[answers_cntr_0]);
			PyList_SetItem(py_answers, answers_cntr_0, py_answers_0);
		}
	}
	return py_answers;
}

static int py_nbt_name_packet_set_answers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_packet *object = (struct nbt_name_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int answers_cntr_0;
		object->answers = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->answers, PyList_GET_SIZE(value));
		if (!object->answers) { return -1;; }
		talloc_set_name_const(object->answers, "ARRAY: object->answers");
		for (answers_cntr_0 = 0; answers_cntr_0 < PyList_GET_SIZE(value); answers_cntr_0++) {
			PY_CHECK_TYPE(&nbt_res_rec_Type, PyList_GET_ITEM(value, answers_cntr_0), return -1;);
			if (talloc_reference(object->answers, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, answers_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->answers[answers_cntr_0] = *(struct nbt_res_rec *)pytalloc_get_ptr(PyList_GET_ITEM(value, answers_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_nbt_name_packet_get_nsrecs(PyObject *obj, void *closure)
{
	struct nbt_name_packet *object = (struct nbt_name_packet *)pytalloc_get_ptr(obj);
	PyObject *py_nsrecs;
	py_nsrecs = PyList_New(object->nscount);
	if (py_nsrecs == NULL) {
		return NULL;
	}
	{
		int nsrecs_cntr_0;
		for (nsrecs_cntr_0 = 0; nsrecs_cntr_0 < object->nscount; nsrecs_cntr_0++) {
			PyObject *py_nsrecs_0;
			py_nsrecs_0 = pytalloc_reference_ex(&nbt_res_rec_Type, object->nsrecs, &object->nsrecs[nsrecs_cntr_0]);
			PyList_SetItem(py_nsrecs, nsrecs_cntr_0, py_nsrecs_0);
		}
	}
	return py_nsrecs;
}

static int py_nbt_name_packet_set_nsrecs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_packet *object = (struct nbt_name_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int nsrecs_cntr_0;
		object->nsrecs = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->nsrecs, PyList_GET_SIZE(value));
		if (!object->nsrecs) { return -1;; }
		talloc_set_name_const(object->nsrecs, "ARRAY: object->nsrecs");
		for (nsrecs_cntr_0 = 0; nsrecs_cntr_0 < PyList_GET_SIZE(value); nsrecs_cntr_0++) {
			PY_CHECK_TYPE(&nbt_res_rec_Type, PyList_GET_ITEM(value, nsrecs_cntr_0), return -1;);
			if (talloc_reference(object->nsrecs, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, nsrecs_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->nsrecs[nsrecs_cntr_0] = *(struct nbt_res_rec *)pytalloc_get_ptr(PyList_GET_ITEM(value, nsrecs_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_nbt_name_packet_get_additional(PyObject *obj, void *closure)
{
	struct nbt_name_packet *object = (struct nbt_name_packet *)pytalloc_get_ptr(obj);
	PyObject *py_additional;
	py_additional = PyList_New(object->arcount);
	if (py_additional == NULL) {
		return NULL;
	}
	{
		int additional_cntr_0;
		for (additional_cntr_0 = 0; additional_cntr_0 < object->arcount; additional_cntr_0++) {
			PyObject *py_additional_0;
			py_additional_0 = pytalloc_reference_ex(&nbt_res_rec_Type, object->additional, &object->additional[additional_cntr_0]);
			PyList_SetItem(py_additional, additional_cntr_0, py_additional_0);
		}
	}
	return py_additional;
}

static int py_nbt_name_packet_set_additional(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_packet *object = (struct nbt_name_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int additional_cntr_0;
		object->additional = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->additional, PyList_GET_SIZE(value));
		if (!object->additional) { return -1;; }
		talloc_set_name_const(object->additional, "ARRAY: object->additional");
		for (additional_cntr_0 = 0; additional_cntr_0 < PyList_GET_SIZE(value); additional_cntr_0++) {
			PY_CHECK_TYPE(&nbt_res_rec_Type, PyList_GET_ITEM(value, additional_cntr_0), return -1;);
			if (talloc_reference(object->additional, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, additional_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->additional[additional_cntr_0] = *(struct nbt_res_rec *)pytalloc_get_ptr(PyList_GET_ITEM(value, additional_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_nbt_name_packet_get_padding(PyObject *obj, void *closure)
{
	struct nbt_name_packet *object = (struct nbt_name_packet *)pytalloc_get_ptr(obj);
	PyObject *py_padding;
	py_padding = PyString_FromStringAndSize((char *)(object->padding).data, (object->padding).length);
	return py_padding;
}

static int py_nbt_name_packet_set_padding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_packet *object = (struct nbt_name_packet *)pytalloc_get_ptr(py_obj);
	object->padding = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_nbt_name_packet_getsetters[] = {
	{ discard_const_p(char, "name_trn_id"), py_nbt_name_packet_get_name_trn_id, py_nbt_name_packet_set_name_trn_id },
	{ discard_const_p(char, "operation"), py_nbt_name_packet_get_operation, py_nbt_name_packet_set_operation },
	{ discard_const_p(char, "qdcount"), py_nbt_name_packet_get_qdcount, py_nbt_name_packet_set_qdcount },
	{ discard_const_p(char, "ancount"), py_nbt_name_packet_get_ancount, py_nbt_name_packet_set_ancount },
	{ discard_const_p(char, "nscount"), py_nbt_name_packet_get_nscount, py_nbt_name_packet_set_nscount },
	{ discard_const_p(char, "arcount"), py_nbt_name_packet_get_arcount, py_nbt_name_packet_set_arcount },
	{ discard_const_p(char, "questions"), py_nbt_name_packet_get_questions, py_nbt_name_packet_set_questions },
	{ discard_const_p(char, "answers"), py_nbt_name_packet_get_answers, py_nbt_name_packet_set_answers },
	{ discard_const_p(char, "nsrecs"), py_nbt_name_packet_get_nsrecs, py_nbt_name_packet_set_nsrecs },
	{ discard_const_p(char, "additional"), py_nbt_name_packet_get_additional, py_nbt_name_packet_set_additional },
	{ discard_const_p(char, "padding"), py_nbt_name_packet_get_padding, py_nbt_name_packet_set_padding },
	{ NULL }
};

static PyObject *py_nbt_name_packet_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_name_packet, type);
}

static PyObject *py_nbt_name_packet_ndr_pack(PyObject *py_obj)
{
	struct nbt_name_packet *object = (struct nbt_name_packet *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_nbt_name_packet);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_nbt_name_packet_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct nbt_name_packet *object = (struct nbt_name_packet *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_name_packet);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_name_packet);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_nbt_name_packet_ndr_print(PyObject *py_obj)
{
	struct nbt_name_packet *object = (struct nbt_name_packet *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_nbt_name_packet, "nbt_name_packet", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_nbt_name_packet_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_nbt_name_packet_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_nbt_name_packet_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_nbt_name_packet_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject nbt_name_packet_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.name_packet",
	.tp_getset = py_nbt_name_packet_getsetters,
	.tp_methods = py_nbt_name_packet_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_name_packet_new,
};


static PyObject *py_smb_trans_body_get_wct(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(obj);
	PyObject *py_wct;
	py_wct = PyInt_FromLong(object->wct);
	return py_wct;
}

static int py_smb_trans_body_set_wct(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->wct = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_smb_trans_body_get_total_param_count(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(obj);
	PyObject *py_total_param_count;
	py_total_param_count = PyInt_FromLong(object->total_param_count);
	return py_total_param_count;
}

static int py_smb_trans_body_set_total_param_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->total_param_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_smb_trans_body_get_total_data_count(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(obj);
	PyObject *py_total_data_count;
	py_total_data_count = PyInt_FromLong(object->total_data_count);
	return py_total_data_count;
}

static int py_smb_trans_body_set_total_data_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->total_data_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_smb_trans_body_get_max_param_count(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(obj);
	PyObject *py_max_param_count;
	py_max_param_count = PyInt_FromLong(object->max_param_count);
	return py_max_param_count;
}

static int py_smb_trans_body_set_max_param_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->max_param_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_smb_trans_body_get_max_data_count(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(obj);
	PyObject *py_max_data_count;
	py_max_data_count = PyInt_FromLong(object->max_data_count);
	return py_max_data_count;
}

static int py_smb_trans_body_set_max_data_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->max_data_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_smb_trans_body_get_max_setup_count(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(obj);
	PyObject *py_max_setup_count;
	py_max_setup_count = PyInt_FromLong(object->max_setup_count);
	return py_max_setup_count;
}

static int py_smb_trans_body_set_max_setup_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->max_setup_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_smb_trans_body_get_pad(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(obj);
	PyObject *py_pad;
	py_pad = PyInt_FromLong(object->pad);
	return py_pad;
}

static int py_smb_trans_body_set_pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pad = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_smb_trans_body_get_trans_flags(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(obj);
	PyObject *py_trans_flags;
	py_trans_flags = PyInt_FromLong(object->trans_flags);
	return py_trans_flags;
}

static int py_smb_trans_body_set_trans_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->trans_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_smb_trans_body_get_timeout(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(obj);
	PyObject *py_timeout;
	py_timeout = PyInt_FromLong(object->timeout);
	return py_timeout;
}

static int py_smb_trans_body_set_timeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->timeout = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_smb_trans_body_get_reserved(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyInt_FromLong(object->reserved);
	return py_reserved;
}

static int py_smb_trans_body_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->reserved = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_smb_trans_body_get_param_count(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(obj);
	PyObject *py_param_count;
	py_param_count = PyInt_FromLong(object->param_count);
	return py_param_count;
}

static int py_smb_trans_body_set_param_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->param_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_smb_trans_body_get_param_offset(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(obj);
	PyObject *py_param_offset;
	py_param_offset = PyInt_FromLong(object->param_offset);
	return py_param_offset;
}

static int py_smb_trans_body_set_param_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->param_offset = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_smb_trans_body_get_data_count(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(obj);
	PyObject *py_data_count;
	py_data_count = PyInt_FromLong(object->data_count);
	return py_data_count;
}

static int py_smb_trans_body_set_data_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->data_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_smb_trans_body_get_data_offset(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(obj);
	PyObject *py_data_offset;
	py_data_offset = PyInt_FromLong(object->data_offset);
	return py_data_offset;
}

static int py_smb_trans_body_set_data_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->data_offset = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_smb_trans_body_get_setup_count(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(obj);
	PyObject *py_setup_count;
	py_setup_count = PyInt_FromLong(object->setup_count);
	return py_setup_count;
}

static int py_smb_trans_body_set_setup_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->setup_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_smb_trans_body_get_pad2(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(obj);
	PyObject *py_pad2;
	py_pad2 = PyInt_FromLong(object->pad2);
	return py_pad2;
}

static int py_smb_trans_body_set_pad2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pad2 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_smb_trans_body_get_opcode(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(obj);
	PyObject *py_opcode;
	py_opcode = PyInt_FromLong(object->opcode);
	return py_opcode;
}

static int py_smb_trans_body_set_opcode(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->opcode = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_smb_trans_body_get_priority(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(obj);
	PyObject *py_priority;
	py_priority = PyInt_FromLong(object->priority);
	return py_priority;
}

static int py_smb_trans_body_set_priority(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->priority = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_smb_trans_body_get__class(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(obj);
	PyObject *py__class;
	py__class = PyInt_FromLong(object->_class);
	return py__class;
}

static int py_smb_trans_body_set__class(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->_class = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_smb_trans_body_get_byte_count(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(obj);
	PyObject *py_byte_count;
	py_byte_count = PyInt_FromLong(object->byte_count);
	return py_byte_count;
}

static int py_smb_trans_body_set_byte_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->byte_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_smb_trans_body_get_mailslot_name(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(obj);
	PyObject *py_mailslot_name;
	py_mailslot_name = PyString_FromStringOrNULL(object->mailslot_name);
	return py_mailslot_name;
}

static int py_smb_trans_body_set_mailslot_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(py_obj);
	object->mailslot_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_smb_trans_body_get_data(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyString_FromStringAndSize((char *)(object->data).data, (object->data).length);
	return py_data;
}

static int py_smb_trans_body_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = (struct smb_trans_body *)pytalloc_get_ptr(py_obj);
	object->data = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_smb_trans_body_getsetters[] = {
	{ discard_const_p(char, "wct"), py_smb_trans_body_get_wct, py_smb_trans_body_set_wct },
	{ discard_const_p(char, "total_param_count"), py_smb_trans_body_get_total_param_count, py_smb_trans_body_set_total_param_count },
	{ discard_const_p(char, "total_data_count"), py_smb_trans_body_get_total_data_count, py_smb_trans_body_set_total_data_count },
	{ discard_const_p(char, "max_param_count"), py_smb_trans_body_get_max_param_count, py_smb_trans_body_set_max_param_count },
	{ discard_const_p(char, "max_data_count"), py_smb_trans_body_get_max_data_count, py_smb_trans_body_set_max_data_count },
	{ discard_const_p(char, "max_setup_count"), py_smb_trans_body_get_max_setup_count, py_smb_trans_body_set_max_setup_count },
	{ discard_const_p(char, "pad"), py_smb_trans_body_get_pad, py_smb_trans_body_set_pad },
	{ discard_const_p(char, "trans_flags"), py_smb_trans_body_get_trans_flags, py_smb_trans_body_set_trans_flags },
	{ discard_const_p(char, "timeout"), py_smb_trans_body_get_timeout, py_smb_trans_body_set_timeout },
	{ discard_const_p(char, "reserved"), py_smb_trans_body_get_reserved, py_smb_trans_body_set_reserved },
	{ discard_const_p(char, "param_count"), py_smb_trans_body_get_param_count, py_smb_trans_body_set_param_count },
	{ discard_const_p(char, "param_offset"), py_smb_trans_body_get_param_offset, py_smb_trans_body_set_param_offset },
	{ discard_const_p(char, "data_count"), py_smb_trans_body_get_data_count, py_smb_trans_body_set_data_count },
	{ discard_const_p(char, "data_offset"), py_smb_trans_body_get_data_offset, py_smb_trans_body_set_data_offset },
	{ discard_const_p(char, "setup_count"), py_smb_trans_body_get_setup_count, py_smb_trans_body_set_setup_count },
	{ discard_const_p(char, "pad2"), py_smb_trans_body_get_pad2, py_smb_trans_body_set_pad2 },
	{ discard_const_p(char, "opcode"), py_smb_trans_body_get_opcode, py_smb_trans_body_set_opcode },
	{ discard_const_p(char, "priority"), py_smb_trans_body_get_priority, py_smb_trans_body_set_priority },
	{ discard_const_p(char, "_class"), py_smb_trans_body_get__class, py_smb_trans_body_set__class },
	{ discard_const_p(char, "byte_count"), py_smb_trans_body_get_byte_count, py_smb_trans_body_set_byte_count },
	{ discard_const_p(char, "mailslot_name"), py_smb_trans_body_get_mailslot_name, py_smb_trans_body_set_mailslot_name },
	{ discard_const_p(char, "data"), py_smb_trans_body_get_data, py_smb_trans_body_set_data },
	{ NULL }
};

static PyObject *py_smb_trans_body_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smb_trans_body, type);
}


static PyTypeObject smb_trans_body_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.smb_trans_body",
	.tp_getset = py_smb_trans_body_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_smb_trans_body_new,
};

PyObject *py_import_smb_body(TALLOC_CTX *mem_ctx, int level, union smb_body *in)
{
	PyObject *ret;

	switch (level) {
		case SMB_TRANSACTION:
			ret = pytalloc_reference_ex(&smb_trans_body_Type, mem_ctx, &in->trans);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union smb_body *py_export_smb_body(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union smb_body *ret = talloc_zero(mem_ctx, union smb_body);
	switch (level) {
		case SMB_TRANSACTION:
			PY_CHECK_TYPE(&smb_trans_body_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->trans = *(struct smb_trans_body *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_dgram_smb_packet_get_smb_command(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(obj);
	PyObject *py_smb_command;
	py_smb_command = PyInt_FromLong(object->smb_command);
	return py_smb_command;
}

static int py_dgram_smb_packet_set_smb_command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->smb_command = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->smb_command = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_dgram_smb_packet_get_err_class(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(obj);
	PyObject *py_err_class;
	py_err_class = PyInt_FromLong(object->err_class);
	return py_err_class;
}

static int py_dgram_smb_packet_set_err_class(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->err_class = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dgram_smb_packet_get_pad(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(obj);
	PyObject *py_pad;
	py_pad = PyInt_FromLong(object->pad);
	return py_pad;
}

static int py_dgram_smb_packet_set_pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pad = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dgram_smb_packet_get_err_code(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(obj);
	PyObject *py_err_code;
	py_err_code = PyInt_FromLong(object->err_code);
	return py_err_code;
}

static int py_dgram_smb_packet_set_err_code(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->err_code = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dgram_smb_packet_get_flags(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_dgram_smb_packet_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dgram_smb_packet_get_flags2(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(obj);
	PyObject *py_flags2;
	py_flags2 = PyInt_FromLong(object->flags2);
	return py_flags2;
}

static int py_dgram_smb_packet_set_flags2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags2 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dgram_smb_packet_get_pid_high(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(obj);
	PyObject *py_pid_high;
	py_pid_high = PyInt_FromLong(object->pid_high);
	return py_pid_high;
}

static int py_dgram_smb_packet_set_pid_high(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pid_high = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dgram_smb_packet_get_signature(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(obj);
	PyObject *py_signature;
	py_signature = PyList_New(8);
	if (py_signature == NULL) {
		return NULL;
	}
	{
		int signature_cntr_0;
		for (signature_cntr_0 = 0; signature_cntr_0 < 8; signature_cntr_0++) {
			PyObject *py_signature_0;
			py_signature_0 = PyInt_FromLong(object->signature[signature_cntr_0]);
			PyList_SetItem(py_signature, signature_cntr_0, py_signature_0);
		}
	}
	return py_signature;
}

static int py_dgram_smb_packet_set_signature(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int signature_cntr_0;
		for (signature_cntr_0 = 0; signature_cntr_0 < PyList_GET_SIZE(value); signature_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, signature_cntr_0), return -1;);
			object->signature[signature_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, signature_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_dgram_smb_packet_get_reserved(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyInt_FromLong(object->reserved);
	return py_reserved;
}

static int py_dgram_smb_packet_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->reserved = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dgram_smb_packet_get_tid(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(obj);
	PyObject *py_tid;
	py_tid = PyInt_FromLong(object->tid);
	return py_tid;
}

static int py_dgram_smb_packet_set_tid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->tid = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dgram_smb_packet_get_pid(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(obj);
	PyObject *py_pid;
	py_pid = PyInt_FromLong(object->pid);
	return py_pid;
}

static int py_dgram_smb_packet_set_pid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pid = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dgram_smb_packet_get_vuid(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(obj);
	PyObject *py_vuid;
	py_vuid = PyInt_FromLong(object->vuid);
	return py_vuid;
}

static int py_dgram_smb_packet_set_vuid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->vuid = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dgram_smb_packet_get_mid(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(obj);
	PyObject *py_mid;
	py_mid = PyInt_FromLong(object->mid);
	return py_mid;
}

static int py_dgram_smb_packet_set_mid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->mid = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dgram_smb_packet_get_body(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(obj);
	PyObject *py_body;
	py_body = py_import_smb_body(pytalloc_get_mem_ctx(obj), object->smb_command, &object->body);
	if (py_body == NULL) {
		return NULL;
	}
	return py_body;
}

static int py_dgram_smb_packet_set_body(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(py_obj);
	{
		union smb_body *body_switch_0;
		body_switch_0 = py_export_smb_body(pytalloc_get_mem_ctx(py_obj), object->smb_command, value);
		if (body_switch_0 == NULL) {
			return -1;
		}
		object->body = *body_switch_0;
	}
	return 0;
}

static PyGetSetDef py_dgram_smb_packet_getsetters[] = {
	{ discard_const_p(char, "smb_command"), py_dgram_smb_packet_get_smb_command, py_dgram_smb_packet_set_smb_command },
	{ discard_const_p(char, "err_class"), py_dgram_smb_packet_get_err_class, py_dgram_smb_packet_set_err_class },
	{ discard_const_p(char, "pad"), py_dgram_smb_packet_get_pad, py_dgram_smb_packet_set_pad },
	{ discard_const_p(char, "err_code"), py_dgram_smb_packet_get_err_code, py_dgram_smb_packet_set_err_code },
	{ discard_const_p(char, "flags"), py_dgram_smb_packet_get_flags, py_dgram_smb_packet_set_flags },
	{ discard_const_p(char, "flags2"), py_dgram_smb_packet_get_flags2, py_dgram_smb_packet_set_flags2 },
	{ discard_const_p(char, "pid_high"), py_dgram_smb_packet_get_pid_high, py_dgram_smb_packet_set_pid_high },
	{ discard_const_p(char, "signature"), py_dgram_smb_packet_get_signature, py_dgram_smb_packet_set_signature },
	{ discard_const_p(char, "reserved"), py_dgram_smb_packet_get_reserved, py_dgram_smb_packet_set_reserved },
	{ discard_const_p(char, "tid"), py_dgram_smb_packet_get_tid, py_dgram_smb_packet_set_tid },
	{ discard_const_p(char, "pid"), py_dgram_smb_packet_get_pid, py_dgram_smb_packet_set_pid },
	{ discard_const_p(char, "vuid"), py_dgram_smb_packet_get_vuid, py_dgram_smb_packet_set_vuid },
	{ discard_const_p(char, "mid"), py_dgram_smb_packet_get_mid, py_dgram_smb_packet_set_mid },
	{ discard_const_p(char, "body"), py_dgram_smb_packet_get_body, py_dgram_smb_packet_set_body },
	{ NULL }
};

static PyObject *py_dgram_smb_packet_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dgram_smb_packet, type);
}

static PyObject *py_dgram_smb_packet_ndr_pack(PyObject *py_obj)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dgram_smb_packet);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dgram_smb_packet_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dgram_smb_packet);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dgram_smb_packet);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dgram_smb_packet_ndr_print(PyObject *py_obj)
{
	struct dgram_smb_packet *object = (struct dgram_smb_packet *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dgram_smb_packet, "dgram_smb_packet", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dgram_smb_packet_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dgram_smb_packet_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dgram_smb_packet_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dgram_smb_packet_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dgram_smb_packet_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.dgram_smb_packet",
	.tp_getset = py_dgram_smb_packet_getsetters,
	.tp_methods = py_dgram_smb_packet_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dgram_smb_packet_new,
};

PyObject *py_import_dgram_message_body(TALLOC_CTX *mem_ctx, int level, union dgram_message_body *in)
{
	PyObject *ret;

	switch (level) {
		case DGRAM_SMB:
			ret = pytalloc_reference_ex(&dgram_smb_packet_Type, mem_ctx, &in->smb);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union dgram_message_body *py_export_dgram_message_body(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union dgram_message_body *ret = talloc_zero(mem_ctx, union dgram_message_body);
	switch (level) {
		case DGRAM_SMB:
			PY_CHECK_TYPE(&dgram_smb_packet_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->smb = *(struct dgram_smb_packet *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_dgram_message_get_length(PyObject *obj, void *closure)
{
	struct dgram_message *object = (struct dgram_message *)pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_dgram_message_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_message *object = (struct dgram_message *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dgram_message_get_offset(PyObject *obj, void *closure)
{
	struct dgram_message *object = (struct dgram_message *)pytalloc_get_ptr(obj);
	PyObject *py_offset;
	py_offset = PyInt_FromLong(object->offset);
	return py_offset;
}

static int py_dgram_message_set_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_message *object = (struct dgram_message *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->offset = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dgram_message_get_source_name(PyObject *obj, void *closure)
{
	struct dgram_message *object = (struct dgram_message *)pytalloc_get_ptr(obj);
	PyObject *py_source_name;
	py_source_name = pytalloc_reference_ex(&nbt_name_Type, pytalloc_get_mem_ctx(obj), &object->source_name);
	return py_source_name;
}

static int py_dgram_message_set_source_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_message *object = (struct dgram_message *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&nbt_name_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->source_name = *(struct nbt_name *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_dgram_message_get_dest_name(PyObject *obj, void *closure)
{
	struct dgram_message *object = (struct dgram_message *)pytalloc_get_ptr(obj);
	PyObject *py_dest_name;
	py_dest_name = pytalloc_reference_ex(&nbt_name_Type, pytalloc_get_mem_ctx(obj), &object->dest_name);
	return py_dest_name;
}

static int py_dgram_message_set_dest_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_message *object = (struct dgram_message *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&nbt_name_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dest_name = *(struct nbt_name *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_dgram_message_get_dgram_body_type(PyObject *obj, void *closure)
{
	struct dgram_message *object = (struct dgram_message *)pytalloc_get_ptr(obj);
	PyObject *py_dgram_body_type;
	py_dgram_body_type = PyInt_FromLong(object->dgram_body_type);
	return py_dgram_body_type;
}

static int py_dgram_message_set_dgram_body_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_message *object = (struct dgram_message *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dgram_body_type = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dgram_message_get_body(PyObject *obj, void *closure)
{
	struct dgram_message *object = (struct dgram_message *)pytalloc_get_ptr(obj);
	PyObject *py_body;
	py_body = py_import_dgram_message_body(pytalloc_get_mem_ctx(obj), object->dgram_body_type, &object->body);
	if (py_body == NULL) {
		return NULL;
	}
	return py_body;
}

static int py_dgram_message_set_body(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_message *object = (struct dgram_message *)pytalloc_get_ptr(py_obj);
	{
		union dgram_message_body *body_switch_0;
		body_switch_0 = py_export_dgram_message_body(pytalloc_get_mem_ctx(py_obj), object->dgram_body_type, value);
		if (body_switch_0 == NULL) {
			return -1;
		}
		object->body = *body_switch_0;
	}
	return 0;
}

static PyGetSetDef py_dgram_message_getsetters[] = {
	{ discard_const_p(char, "length"), py_dgram_message_get_length, py_dgram_message_set_length },
	{ discard_const_p(char, "offset"), py_dgram_message_get_offset, py_dgram_message_set_offset },
	{ discard_const_p(char, "source_name"), py_dgram_message_get_source_name, py_dgram_message_set_source_name },
	{ discard_const_p(char, "dest_name"), py_dgram_message_get_dest_name, py_dgram_message_set_dest_name },
	{ discard_const_p(char, "dgram_body_type"), py_dgram_message_get_dgram_body_type, py_dgram_message_set_dgram_body_type },
	{ discard_const_p(char, "body"), py_dgram_message_get_body, py_dgram_message_set_body },
	{ NULL }
};

static PyObject *py_dgram_message_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dgram_message, type);
}


static PyTypeObject dgram_message_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.dgram_message",
	.tp_getset = py_dgram_message_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dgram_message_new,
};

PyObject *py_import_dgram_data(TALLOC_CTX *mem_ctx, int level, union dgram_data *in)
{
	PyObject *ret;

	switch (level) {
		case DGRAM_DIRECT_UNIQUE:
			ret = pytalloc_reference_ex(&dgram_message_Type, mem_ctx, &in->msg);
			return ret;

		case DGRAM_DIRECT_GROUP:
			ret = pytalloc_reference_ex(&dgram_message_Type, mem_ctx, &in->msg);
			return ret;

		case DGRAM_BCAST:
			ret = pytalloc_reference_ex(&dgram_message_Type, mem_ctx, &in->msg);
			return ret;

		case DGRAM_ERROR:
			ret = PyInt_FromLong(in->error);
			return ret;

		case DGRAM_QUERY:
			ret = pytalloc_reference_ex(&nbt_name_Type, mem_ctx, &in->dest_name);
			return ret;

		case DGRAM_QUERY_POSITIVE:
			ret = pytalloc_reference_ex(&nbt_name_Type, mem_ctx, &in->dest_name);
			return ret;

		case DGRAM_QUERY_NEGATIVE:
			ret = pytalloc_reference_ex(&nbt_name_Type, mem_ctx, &in->dest_name);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union dgram_data *py_export_dgram_data(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union dgram_data *ret = talloc_zero(mem_ctx, union dgram_data);
	switch (level) {
		case DGRAM_DIRECT_UNIQUE:
			PY_CHECK_TYPE(&dgram_message_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->msg = *(struct dgram_message *)pytalloc_get_ptr(in);
			break;

		case DGRAM_DIRECT_GROUP:
			PY_CHECK_TYPE(&dgram_message_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->msg = *(struct dgram_message *)pytalloc_get_ptr(in);
			break;

		case DGRAM_BCAST:
			PY_CHECK_TYPE(&dgram_message_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->msg = *(struct dgram_message *)pytalloc_get_ptr(in);
			break;

		case DGRAM_ERROR:
			if (PyLong_Check(in)) {
				ret->error = PyLong_AsLongLong(in);
			} else if (PyInt_Check(in)) {
				ret->error = PyInt_AsLong(in);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
				  PyInt_Type.tp_name, PyLong_Type.tp_name);
				talloc_free(ret); return NULL;
			}
			break;

		case DGRAM_QUERY:
			PY_CHECK_TYPE(&nbt_name_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->dest_name = *(struct nbt_name *)pytalloc_get_ptr(in);
			break;

		case DGRAM_QUERY_POSITIVE:
			PY_CHECK_TYPE(&nbt_name_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->dest_name = *(struct nbt_name *)pytalloc_get_ptr(in);
			break;

		case DGRAM_QUERY_NEGATIVE:
			PY_CHECK_TYPE(&nbt_name_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->dest_name = *(struct nbt_name *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_nbt_dgram_packet_get_msg_type(PyObject *obj, void *closure)
{
	struct nbt_dgram_packet *object = (struct nbt_dgram_packet *)pytalloc_get_ptr(obj);
	PyObject *py_msg_type;
	py_msg_type = PyInt_FromLong(object->msg_type);
	return py_msg_type;
}

static int py_nbt_dgram_packet_set_msg_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_dgram_packet *object = (struct nbt_dgram_packet *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->msg_type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->msg_type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_nbt_dgram_packet_get_flags(PyObject *obj, void *closure)
{
	struct nbt_dgram_packet *object = (struct nbt_dgram_packet *)pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_nbt_dgram_packet_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_dgram_packet *object = (struct nbt_dgram_packet *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->flags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->flags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_nbt_dgram_packet_get_dgram_id(PyObject *obj, void *closure)
{
	struct nbt_dgram_packet *object = (struct nbt_dgram_packet *)pytalloc_get_ptr(obj);
	PyObject *py_dgram_id;
	py_dgram_id = PyInt_FromLong(object->dgram_id);
	return py_dgram_id;
}

static int py_nbt_dgram_packet_set_dgram_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_dgram_packet *object = (struct nbt_dgram_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dgram_id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_dgram_packet_get_src_addr(PyObject *obj, void *closure)
{
	struct nbt_dgram_packet *object = (struct nbt_dgram_packet *)pytalloc_get_ptr(obj);
	PyObject *py_src_addr;
	py_src_addr = PyString_FromStringOrNULL(object->src_addr);
	return py_src_addr;
}

static int py_nbt_dgram_packet_set_src_addr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_dgram_packet *object = (struct nbt_dgram_packet *)pytalloc_get_ptr(py_obj);
	object->src_addr = PyString_AS_STRING(value);
	return 0;
}

static PyObject *py_nbt_dgram_packet_get_src_port(PyObject *obj, void *closure)
{
	struct nbt_dgram_packet *object = (struct nbt_dgram_packet *)pytalloc_get_ptr(obj);
	PyObject *py_src_port;
	py_src_port = PyInt_FromLong(object->src_port);
	return py_src_port;
}

static int py_nbt_dgram_packet_set_src_port(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_dgram_packet *object = (struct nbt_dgram_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->src_port = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_dgram_packet_get_data(PyObject *obj, void *closure)
{
	struct nbt_dgram_packet *object = (struct nbt_dgram_packet *)pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = py_import_dgram_data(pytalloc_get_mem_ctx(obj), object->msg_type, &object->data);
	if (py_data == NULL) {
		return NULL;
	}
	return py_data;
}

static int py_nbt_dgram_packet_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_dgram_packet *object = (struct nbt_dgram_packet *)pytalloc_get_ptr(py_obj);
	{
		union dgram_data *data_switch_0;
		data_switch_0 = py_export_dgram_data(pytalloc_get_mem_ctx(py_obj), object->msg_type, value);
		if (data_switch_0 == NULL) {
			return -1;
		}
		object->data = *data_switch_0;
	}
	return 0;
}

static PyGetSetDef py_nbt_dgram_packet_getsetters[] = {
	{ discard_const_p(char, "msg_type"), py_nbt_dgram_packet_get_msg_type, py_nbt_dgram_packet_set_msg_type },
	{ discard_const_p(char, "flags"), py_nbt_dgram_packet_get_flags, py_nbt_dgram_packet_set_flags },
	{ discard_const_p(char, "dgram_id"), py_nbt_dgram_packet_get_dgram_id, py_nbt_dgram_packet_set_dgram_id },
	{ discard_const_p(char, "src_addr"), py_nbt_dgram_packet_get_src_addr, py_nbt_dgram_packet_set_src_addr },
	{ discard_const_p(char, "src_port"), py_nbt_dgram_packet_get_src_port, py_nbt_dgram_packet_set_src_port },
	{ discard_const_p(char, "data"), py_nbt_dgram_packet_get_data, py_nbt_dgram_packet_set_data },
	{ NULL }
};

static PyObject *py_nbt_dgram_packet_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_dgram_packet, type);
}

static PyObject *py_nbt_dgram_packet_ndr_pack(PyObject *py_obj)
{
	struct nbt_dgram_packet *object = (struct nbt_dgram_packet *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_nbt_dgram_packet);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_nbt_dgram_packet_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct nbt_dgram_packet *object = (struct nbt_dgram_packet *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_dgram_packet);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_dgram_packet);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_nbt_dgram_packet_ndr_print(PyObject *py_obj)
{
	struct nbt_dgram_packet *object = (struct nbt_dgram_packet *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_nbt_dgram_packet, "nbt_dgram_packet", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_nbt_dgram_packet_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_nbt_dgram_packet_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_nbt_dgram_packet_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_nbt_dgram_packet_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject nbt_dgram_packet_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.dgram_packet",
	.tp_getset = py_nbt_dgram_packet_getsetters,
	.tp_methods = py_nbt_dgram_packet_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_dgram_packet_new,
};


static PyObject *py_nbt_sockaddr_get_sockaddr_family(PyObject *obj, void *closure)
{
	struct nbt_sockaddr *object = (struct nbt_sockaddr *)pytalloc_get_ptr(obj);
	PyObject *py_sockaddr_family;
	py_sockaddr_family = PyInt_FromLong(object->sockaddr_family);
	return py_sockaddr_family;
}

static int py_nbt_sockaddr_set_sockaddr_family(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_sockaddr *object = (struct nbt_sockaddr *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sockaddr_family = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_sockaddr_get_pdc_ip(PyObject *obj, void *closure)
{
	struct nbt_sockaddr *object = (struct nbt_sockaddr *)pytalloc_get_ptr(obj);
	PyObject *py_pdc_ip;
	py_pdc_ip = PyString_FromStringOrNULL(object->pdc_ip);
	return py_pdc_ip;
}

static int py_nbt_sockaddr_set_pdc_ip(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_sockaddr *object = (struct nbt_sockaddr *)pytalloc_get_ptr(py_obj);
	object->pdc_ip = PyString_AS_STRING(value);
	return 0;
}

static PyObject *py_nbt_sockaddr_get_remaining(PyObject *obj, void *closure)
{
	struct nbt_sockaddr *object = (struct nbt_sockaddr *)pytalloc_get_ptr(obj);
	PyObject *py_remaining;
	py_remaining = PyString_FromStringAndSize((char *)(object->remaining).data, (object->remaining).length);
	return py_remaining;
}

static int py_nbt_sockaddr_set_remaining(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_sockaddr *object = (struct nbt_sockaddr *)pytalloc_get_ptr(py_obj);
	object->remaining = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_nbt_sockaddr_getsetters[] = {
	{ discard_const_p(char, "sockaddr_family"), py_nbt_sockaddr_get_sockaddr_family, py_nbt_sockaddr_set_sockaddr_family },
	{ discard_const_p(char, "pdc_ip"), py_nbt_sockaddr_get_pdc_ip, py_nbt_sockaddr_set_pdc_ip },
	{ discard_const_p(char, "remaining"), py_nbt_sockaddr_get_remaining, py_nbt_sockaddr_set_remaining },
	{ NULL }
};

static PyObject *py_nbt_sockaddr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_sockaddr, type);
}

static PyObject *py_nbt_sockaddr_ndr_pack(PyObject *py_obj)
{
	struct nbt_sockaddr *object = (struct nbt_sockaddr *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_nbt_sockaddr);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_nbt_sockaddr_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct nbt_sockaddr *object = (struct nbt_sockaddr *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_sockaddr);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_sockaddr);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_nbt_sockaddr_ndr_print(PyObject *py_obj)
{
	struct nbt_sockaddr *object = (struct nbt_sockaddr *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_nbt_sockaddr, "nbt_sockaddr", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_nbt_sockaddr_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_nbt_sockaddr_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_nbt_sockaddr_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_nbt_sockaddr_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject nbt_sockaddr_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.sockaddr",
	.tp_getset = py_nbt_sockaddr_getsetters,
	.tp_methods = py_nbt_sockaddr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_sockaddr_new,
};


static PyObject *py_NETLOGON_SAM_LOGON_REQUEST_get_request_count(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = (struct NETLOGON_SAM_LOGON_REQUEST *)pytalloc_get_ptr(obj);
	PyObject *py_request_count;
	py_request_count = PyInt_FromLong(object->request_count);
	return py_request_count;
}

static int py_NETLOGON_SAM_LOGON_REQUEST_set_request_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = (struct NETLOGON_SAM_LOGON_REQUEST *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->request_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_REQUEST_get_computer_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = (struct NETLOGON_SAM_LOGON_REQUEST *)pytalloc_get_ptr(obj);
	PyObject *py_computer_name;
	py_computer_name = PyString_FromStringOrNULL(object->computer_name);
	return py_computer_name;
}

static int py_NETLOGON_SAM_LOGON_REQUEST_set_computer_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = (struct NETLOGON_SAM_LOGON_REQUEST *)pytalloc_get_ptr(py_obj);
	object->computer_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_REQUEST_get_user_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = (struct NETLOGON_SAM_LOGON_REQUEST *)pytalloc_get_ptr(obj);
	PyObject *py_user_name;
	py_user_name = PyString_FromStringOrNULL(object->user_name);
	return py_user_name;
}

static int py_NETLOGON_SAM_LOGON_REQUEST_set_user_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = (struct NETLOGON_SAM_LOGON_REQUEST *)pytalloc_get_ptr(py_obj);
	object->user_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_REQUEST_get_mailslot_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = (struct NETLOGON_SAM_LOGON_REQUEST *)pytalloc_get_ptr(obj);
	PyObject *py_mailslot_name;
	py_mailslot_name = PyString_FromStringOrNULL(object->mailslot_name);
	return py_mailslot_name;
}

static int py_NETLOGON_SAM_LOGON_REQUEST_set_mailslot_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = (struct NETLOGON_SAM_LOGON_REQUEST *)pytalloc_get_ptr(py_obj);
	object->mailslot_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_REQUEST_get_acct_control(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = (struct NETLOGON_SAM_LOGON_REQUEST *)pytalloc_get_ptr(obj);
	PyObject *py_acct_control;
	py_acct_control = PyInt_FromLong(object->acct_control);
	return py_acct_control;
}

static int py_NETLOGON_SAM_LOGON_REQUEST_set_acct_control(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = (struct NETLOGON_SAM_LOGON_REQUEST *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->acct_control = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_REQUEST_get_sid_size(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = (struct NETLOGON_SAM_LOGON_REQUEST *)pytalloc_get_ptr(obj);
	PyObject *py_sid_size;
	py_sid_size = PyInt_FromLong(object->sid_size);
	return py_sid_size;
}

static int py_NETLOGON_SAM_LOGON_REQUEST_set_sid_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = (struct NETLOGON_SAM_LOGON_REQUEST *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sid_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_REQUEST_get__pad(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = (struct NETLOGON_SAM_LOGON_REQUEST *)pytalloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyString_FromStringAndSize((char *)(object->_pad).data, (object->_pad).length);
	return py__pad;
}

static int py_NETLOGON_SAM_LOGON_REQUEST_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = (struct NETLOGON_SAM_LOGON_REQUEST *)pytalloc_get_ptr(py_obj);
	object->_pad = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_REQUEST_get_sid(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = (struct NETLOGON_SAM_LOGON_REQUEST *)pytalloc_get_ptr(obj);
	PyObject *py_sid;
	py_sid = pytalloc_reference_ex(dom_sid_Type, pytalloc_get_mem_ctx(obj), &object->sid);
	return py_sid;
}

static int py_NETLOGON_SAM_LOGON_REQUEST_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = (struct NETLOGON_SAM_LOGON_REQUEST *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sid = *(struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_REQUEST_get_nt_version(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = (struct NETLOGON_SAM_LOGON_REQUEST *)pytalloc_get_ptr(obj);
	PyObject *py_nt_version;
	py_nt_version = PyInt_FromLong(object->nt_version);
	return py_nt_version;
}

static int py_NETLOGON_SAM_LOGON_REQUEST_set_nt_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = (struct NETLOGON_SAM_LOGON_REQUEST *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->nt_version = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->nt_version = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_REQUEST_get_lmnt_token(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = (struct NETLOGON_SAM_LOGON_REQUEST *)pytalloc_get_ptr(obj);
	PyObject *py_lmnt_token;
	py_lmnt_token = PyInt_FromLong(object->lmnt_token);
	return py_lmnt_token;
}

static int py_NETLOGON_SAM_LOGON_REQUEST_set_lmnt_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = (struct NETLOGON_SAM_LOGON_REQUEST *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->lmnt_token = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_REQUEST_get_lm20_token(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = (struct NETLOGON_SAM_LOGON_REQUEST *)pytalloc_get_ptr(obj);
	PyObject *py_lm20_token;
	py_lm20_token = PyInt_FromLong(object->lm20_token);
	return py_lm20_token;
}

static int py_NETLOGON_SAM_LOGON_REQUEST_set_lm20_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = (struct NETLOGON_SAM_LOGON_REQUEST *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->lm20_token = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_NETLOGON_SAM_LOGON_REQUEST_getsetters[] = {
	{ discard_const_p(char, "request_count"), py_NETLOGON_SAM_LOGON_REQUEST_get_request_count, py_NETLOGON_SAM_LOGON_REQUEST_set_request_count },
	{ discard_const_p(char, "computer_name"), py_NETLOGON_SAM_LOGON_REQUEST_get_computer_name, py_NETLOGON_SAM_LOGON_REQUEST_set_computer_name },
	{ discard_const_p(char, "user_name"), py_NETLOGON_SAM_LOGON_REQUEST_get_user_name, py_NETLOGON_SAM_LOGON_REQUEST_set_user_name },
	{ discard_const_p(char, "mailslot_name"), py_NETLOGON_SAM_LOGON_REQUEST_get_mailslot_name, py_NETLOGON_SAM_LOGON_REQUEST_set_mailslot_name },
	{ discard_const_p(char, "acct_control"), py_NETLOGON_SAM_LOGON_REQUEST_get_acct_control, py_NETLOGON_SAM_LOGON_REQUEST_set_acct_control },
	{ discard_const_p(char, "sid_size"), py_NETLOGON_SAM_LOGON_REQUEST_get_sid_size, py_NETLOGON_SAM_LOGON_REQUEST_set_sid_size },
	{ discard_const_p(char, "_pad"), py_NETLOGON_SAM_LOGON_REQUEST_get__pad, py_NETLOGON_SAM_LOGON_REQUEST_set__pad },
	{ discard_const_p(char, "sid"), py_NETLOGON_SAM_LOGON_REQUEST_get_sid, py_NETLOGON_SAM_LOGON_REQUEST_set_sid },
	{ discard_const_p(char, "nt_version"), py_NETLOGON_SAM_LOGON_REQUEST_get_nt_version, py_NETLOGON_SAM_LOGON_REQUEST_set_nt_version },
	{ discard_const_p(char, "lmnt_token"), py_NETLOGON_SAM_LOGON_REQUEST_get_lmnt_token, py_NETLOGON_SAM_LOGON_REQUEST_set_lmnt_token },
	{ discard_const_p(char, "lm20_token"), py_NETLOGON_SAM_LOGON_REQUEST_get_lm20_token, py_NETLOGON_SAM_LOGON_REQUEST_set_lm20_token },
	{ NULL }
};

static PyObject *py_NETLOGON_SAM_LOGON_REQUEST_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NETLOGON_SAM_LOGON_REQUEST, type);
}


static PyTypeObject NETLOGON_SAM_LOGON_REQUEST_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.NETLOGON_SAM_LOGON_REQUEST",
	.tp_getset = py_NETLOGON_SAM_LOGON_REQUEST_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_NETLOGON_SAM_LOGON_REQUEST_new,
};


static PyObject *py_NETLOGON_LOGON_REQUEST_get_computer_name(PyObject *obj, void *closure)
{
	struct NETLOGON_LOGON_REQUEST *object = (struct NETLOGON_LOGON_REQUEST *)pytalloc_get_ptr(obj);
	PyObject *py_computer_name;
	py_computer_name = PyString_FromStringOrNULL(object->computer_name);
	return py_computer_name;
}

static int py_NETLOGON_LOGON_REQUEST_set_computer_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_LOGON_REQUEST *object = (struct NETLOGON_LOGON_REQUEST *)pytalloc_get_ptr(py_obj);
	object->computer_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_LOGON_REQUEST_get_user_name(PyObject *obj, void *closure)
{
	struct NETLOGON_LOGON_REQUEST *object = (struct NETLOGON_LOGON_REQUEST *)pytalloc_get_ptr(obj);
	PyObject *py_user_name;
	py_user_name = PyString_FromStringOrNULL(object->user_name);
	return py_user_name;
}

static int py_NETLOGON_LOGON_REQUEST_set_user_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_LOGON_REQUEST *object = (struct NETLOGON_LOGON_REQUEST *)pytalloc_get_ptr(py_obj);
	object->user_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_LOGON_REQUEST_get_mailslot_name(PyObject *obj, void *closure)
{
	struct NETLOGON_LOGON_REQUEST *object = (struct NETLOGON_LOGON_REQUEST *)pytalloc_get_ptr(obj);
	PyObject *py_mailslot_name;
	py_mailslot_name = PyString_FromStringOrNULL(object->mailslot_name);
	return py_mailslot_name;
}

static int py_NETLOGON_LOGON_REQUEST_set_mailslot_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_LOGON_REQUEST *object = (struct NETLOGON_LOGON_REQUEST *)pytalloc_get_ptr(py_obj);
	object->mailslot_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_LOGON_REQUEST_get_request_count(PyObject *obj, void *closure)
{
	struct NETLOGON_LOGON_REQUEST *object = (struct NETLOGON_LOGON_REQUEST *)pytalloc_get_ptr(obj);
	PyObject *py_request_count;
	py_request_count = PyInt_FromLong(object->request_count);
	return py_request_count;
}

static int py_NETLOGON_LOGON_REQUEST_set_request_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_LOGON_REQUEST *object = (struct NETLOGON_LOGON_REQUEST *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->request_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NETLOGON_LOGON_REQUEST_get_lmnt_token(PyObject *obj, void *closure)
{
	struct NETLOGON_LOGON_REQUEST *object = (struct NETLOGON_LOGON_REQUEST *)pytalloc_get_ptr(obj);
	PyObject *py_lmnt_token;
	py_lmnt_token = PyInt_FromLong(object->lmnt_token);
	return py_lmnt_token;
}

static int py_NETLOGON_LOGON_REQUEST_set_lmnt_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_LOGON_REQUEST *object = (struct NETLOGON_LOGON_REQUEST *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->lmnt_token = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NETLOGON_LOGON_REQUEST_get_lm20_token(PyObject *obj, void *closure)
{
	struct NETLOGON_LOGON_REQUEST *object = (struct NETLOGON_LOGON_REQUEST *)pytalloc_get_ptr(obj);
	PyObject *py_lm20_token;
	py_lm20_token = PyInt_FromLong(object->lm20_token);
	return py_lm20_token;
}

static int py_NETLOGON_LOGON_REQUEST_set_lm20_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_LOGON_REQUEST *object = (struct NETLOGON_LOGON_REQUEST *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->lm20_token = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_NETLOGON_LOGON_REQUEST_getsetters[] = {
	{ discard_const_p(char, "computer_name"), py_NETLOGON_LOGON_REQUEST_get_computer_name, py_NETLOGON_LOGON_REQUEST_set_computer_name },
	{ discard_const_p(char, "user_name"), py_NETLOGON_LOGON_REQUEST_get_user_name, py_NETLOGON_LOGON_REQUEST_set_user_name },
	{ discard_const_p(char, "mailslot_name"), py_NETLOGON_LOGON_REQUEST_get_mailslot_name, py_NETLOGON_LOGON_REQUEST_set_mailslot_name },
	{ discard_const_p(char, "request_count"), py_NETLOGON_LOGON_REQUEST_get_request_count, py_NETLOGON_LOGON_REQUEST_set_request_count },
	{ discard_const_p(char, "lmnt_token"), py_NETLOGON_LOGON_REQUEST_get_lmnt_token, py_NETLOGON_LOGON_REQUEST_set_lmnt_token },
	{ discard_const_p(char, "lm20_token"), py_NETLOGON_LOGON_REQUEST_get_lm20_token, py_NETLOGON_LOGON_REQUEST_set_lm20_token },
	{ NULL }
};

static PyObject *py_NETLOGON_LOGON_REQUEST_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NETLOGON_LOGON_REQUEST, type);
}


static PyTypeObject NETLOGON_LOGON_REQUEST_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.NETLOGON_LOGON_REQUEST",
	.tp_getset = py_NETLOGON_LOGON_REQUEST_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_NETLOGON_LOGON_REQUEST_new,
};


static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_command(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = (struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *)pytalloc_get_ptr(obj);
	PyObject *py_command;
	py_command = PyInt_FromLong(object->command);
	return py_command;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = (struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->command = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->command = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_pdc_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = (struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *)pytalloc_get_ptr(obj);
	PyObject *py_pdc_name;
	py_pdc_name = PyString_FromStringOrNULL(object->pdc_name);
	return py_pdc_name;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_pdc_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = (struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *)pytalloc_get_ptr(py_obj);
	object->pdc_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_user_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = (struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *)pytalloc_get_ptr(obj);
	PyObject *py_user_name;
	py_user_name = PyString_FromStringOrNULL(object->user_name);
	return py_user_name;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_user_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = (struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *)pytalloc_get_ptr(py_obj);
	object->user_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_domain_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = (struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *)pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	py_domain_name = PyString_FromStringOrNULL(object->domain_name);
	return py_domain_name;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = (struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *)pytalloc_get_ptr(py_obj);
	object->domain_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_nt_version(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = (struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *)pytalloc_get_ptr(obj);
	PyObject *py_nt_version;
	py_nt_version = PyInt_FromLong(object->nt_version);
	return py_nt_version;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_nt_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = (struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->nt_version = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->nt_version = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_lmnt_token(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = (struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *)pytalloc_get_ptr(obj);
	PyObject *py_lmnt_token;
	py_lmnt_token = PyInt_FromLong(object->lmnt_token);
	return py_lmnt_token;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_lmnt_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = (struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->lmnt_token = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_lm20_token(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = (struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *)pytalloc_get_ptr(obj);
	PyObject *py_lm20_token;
	py_lm20_token = PyInt_FromLong(object->lm20_token);
	return py_lm20_token;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_lm20_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = (struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->lm20_token = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_NETLOGON_SAM_LOGON_RESPONSE_NT40_getsetters[] = {
	{ discard_const_p(char, "command"), py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_command, py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_command },
	{ discard_const_p(char, "pdc_name"), py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_pdc_name, py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_pdc_name },
	{ discard_const_p(char, "user_name"), py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_user_name, py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_user_name },
	{ discard_const_p(char, "domain_name"), py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_domain_name, py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_domain_name },
	{ discard_const_p(char, "nt_version"), py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_nt_version, py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_nt_version },
	{ discard_const_p(char, "lmnt_token"), py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_lmnt_token, py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_lmnt_token },
	{ discard_const_p(char, "lm20_token"), py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_lm20_token, py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_lm20_token },
	{ NULL }
};

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_NT40_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NETLOGON_SAM_LOGON_RESPONSE_NT40, type);
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_NT40_ndr_pack(PyObject *py_obj)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = (struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_NETLOGON_SAM_LOGON_RESPONSE_NT40);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_NT40_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = (struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NETLOGON_SAM_LOGON_RESPONSE_NT40);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NETLOGON_SAM_LOGON_RESPONSE_NT40);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_NT40_ndr_print(PyObject *py_obj)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = (struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NETLOGON_SAM_LOGON_RESPONSE_NT40, "NETLOGON_SAM_LOGON_RESPONSE_NT40", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_NETLOGON_SAM_LOGON_RESPONSE_NT40_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_NETLOGON_SAM_LOGON_RESPONSE_NT40_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_NETLOGON_SAM_LOGON_RESPONSE_NT40_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_NETLOGON_SAM_LOGON_RESPONSE_NT40_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject NETLOGON_SAM_LOGON_RESPONSE_NT40_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.NETLOGON_SAM_LOGON_RESPONSE_NT40",
	.tp_getset = py_NETLOGON_SAM_LOGON_RESPONSE_NT40_getsetters,
	.tp_methods = py_NETLOGON_SAM_LOGON_RESPONSE_NT40_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_NETLOGON_SAM_LOGON_RESPONSE_NT40_new,
};


static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_command(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(obj);
	PyObject *py_command;
	py_command = PyInt_FromLong(object->command);
	return py_command;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->command = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->command = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_pdc_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(obj);
	PyObject *py_pdc_name;
	py_pdc_name = PyString_FromStringOrNULL(object->pdc_name);
	return py_pdc_name;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_pdc_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(py_obj);
	object->pdc_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_user_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(obj);
	PyObject *py_user_name;
	py_user_name = PyString_FromStringOrNULL(object->user_name);
	return py_user_name;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_user_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(py_obj);
	object->user_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_domain_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	py_domain_name = PyString_FromStringOrNULL(object->domain_name);
	return py_domain_name;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(py_obj);
	object->domain_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_domain_uuid(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(obj);
	PyObject *py_domain_uuid;
	py_domain_uuid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->domain_uuid);
	return py_domain_uuid;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_domain_uuid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->domain_uuid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_zero_uuid(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(obj);
	PyObject *py_zero_uuid;
	py_zero_uuid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->zero_uuid);
	return py_zero_uuid;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_zero_uuid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->zero_uuid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_forest(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(obj);
	PyObject *py_forest;
	py_forest = PyString_FromStringOrNULL(object->forest);
	return py_forest;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_forest(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(py_obj);
	object->forest = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_dns_domain(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(obj);
	PyObject *py_dns_domain;
	py_dns_domain = PyString_FromStringOrNULL(object->dns_domain);
	return py_dns_domain;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_dns_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(py_obj);
	object->dns_domain = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_pdc_dns_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(obj);
	PyObject *py_pdc_dns_name;
	py_pdc_dns_name = PyString_FromStringOrNULL(object->pdc_dns_name);
	return py_pdc_dns_name;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_pdc_dns_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(py_obj);
	object->pdc_dns_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_pdc_ip(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(obj);
	PyObject *py_pdc_ip;
	py_pdc_ip = PyString_FromStringOrNULL(object->pdc_ip);
	return py_pdc_ip;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_pdc_ip(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(py_obj);
	object->pdc_ip = PyString_AS_STRING(value);
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_server_type(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(obj);
	PyObject *py_server_type;
	py_server_type = PyInt_FromLong(object->server_type);
	return py_server_type;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_server_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->server_type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->server_type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_nt_version(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(obj);
	PyObject *py_nt_version;
	py_nt_version = PyInt_FromLong(object->nt_version);
	return py_nt_version;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_nt_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->nt_version = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->nt_version = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_lmnt_token(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(obj);
	PyObject *py_lmnt_token;
	py_lmnt_token = PyInt_FromLong(object->lmnt_token);
	return py_lmnt_token;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_lmnt_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->lmnt_token = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_lm20_token(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(obj);
	PyObject *py_lm20_token;
	py_lm20_token = PyInt_FromLong(object->lm20_token);
	return py_lm20_token;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_lm20_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->lm20_token = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_NETLOGON_SAM_LOGON_RESPONSE_getsetters[] = {
	{ discard_const_p(char, "command"), py_NETLOGON_SAM_LOGON_RESPONSE_get_command, py_NETLOGON_SAM_LOGON_RESPONSE_set_command },
	{ discard_const_p(char, "pdc_name"), py_NETLOGON_SAM_LOGON_RESPONSE_get_pdc_name, py_NETLOGON_SAM_LOGON_RESPONSE_set_pdc_name },
	{ discard_const_p(char, "user_name"), py_NETLOGON_SAM_LOGON_RESPONSE_get_user_name, py_NETLOGON_SAM_LOGON_RESPONSE_set_user_name },
	{ discard_const_p(char, "domain_name"), py_NETLOGON_SAM_LOGON_RESPONSE_get_domain_name, py_NETLOGON_SAM_LOGON_RESPONSE_set_domain_name },
	{ discard_const_p(char, "domain_uuid"), py_NETLOGON_SAM_LOGON_RESPONSE_get_domain_uuid, py_NETLOGON_SAM_LOGON_RESPONSE_set_domain_uuid },
	{ discard_const_p(char, "zero_uuid"), py_NETLOGON_SAM_LOGON_RESPONSE_get_zero_uuid, py_NETLOGON_SAM_LOGON_RESPONSE_set_zero_uuid },
	{ discard_const_p(char, "forest"), py_NETLOGON_SAM_LOGON_RESPONSE_get_forest, py_NETLOGON_SAM_LOGON_RESPONSE_set_forest },
	{ discard_const_p(char, "dns_domain"), py_NETLOGON_SAM_LOGON_RESPONSE_get_dns_domain, py_NETLOGON_SAM_LOGON_RESPONSE_set_dns_domain },
	{ discard_const_p(char, "pdc_dns_name"), py_NETLOGON_SAM_LOGON_RESPONSE_get_pdc_dns_name, py_NETLOGON_SAM_LOGON_RESPONSE_set_pdc_dns_name },
	{ discard_const_p(char, "pdc_ip"), py_NETLOGON_SAM_LOGON_RESPONSE_get_pdc_ip, py_NETLOGON_SAM_LOGON_RESPONSE_set_pdc_ip },
	{ discard_const_p(char, "server_type"), py_NETLOGON_SAM_LOGON_RESPONSE_get_server_type, py_NETLOGON_SAM_LOGON_RESPONSE_set_server_type },
	{ discard_const_p(char, "nt_version"), py_NETLOGON_SAM_LOGON_RESPONSE_get_nt_version, py_NETLOGON_SAM_LOGON_RESPONSE_set_nt_version },
	{ discard_const_p(char, "lmnt_token"), py_NETLOGON_SAM_LOGON_RESPONSE_get_lmnt_token, py_NETLOGON_SAM_LOGON_RESPONSE_set_lmnt_token },
	{ discard_const_p(char, "lm20_token"), py_NETLOGON_SAM_LOGON_RESPONSE_get_lm20_token, py_NETLOGON_SAM_LOGON_RESPONSE_set_lm20_token },
	{ NULL }
};

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NETLOGON_SAM_LOGON_RESPONSE, type);
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_ndr_pack(PyObject *py_obj)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_NETLOGON_SAM_LOGON_RESPONSE);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NETLOGON_SAM_LOGON_RESPONSE);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NETLOGON_SAM_LOGON_RESPONSE);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_ndr_print(PyObject *py_obj)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = (struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NETLOGON_SAM_LOGON_RESPONSE, "NETLOGON_SAM_LOGON_RESPONSE", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_NETLOGON_SAM_LOGON_RESPONSE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_NETLOGON_SAM_LOGON_RESPONSE_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_NETLOGON_SAM_LOGON_RESPONSE_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_NETLOGON_SAM_LOGON_RESPONSE_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject NETLOGON_SAM_LOGON_RESPONSE_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.NETLOGON_SAM_LOGON_RESPONSE",
	.tp_getset = py_NETLOGON_SAM_LOGON_RESPONSE_getsetters,
	.tp_methods = py_NETLOGON_SAM_LOGON_RESPONSE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_NETLOGON_SAM_LOGON_RESPONSE_new,
};


static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_command(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(obj);
	PyObject *py_command;
	py_command = PyInt_FromLong(object->command);
	return py_command;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->command = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->command = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_sbz(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(obj);
	PyObject *py_sbz;
	py_sbz = PyInt_FromLong(object->sbz);
	return py_sbz;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_sbz(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sbz = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_server_type(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(obj);
	PyObject *py_server_type;
	py_server_type = PyInt_FromLong(object->server_type);
	return py_server_type;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_server_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->server_type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->server_type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_domain_uuid(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(obj);
	PyObject *py_domain_uuid;
	py_domain_uuid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->domain_uuid);
	return py_domain_uuid;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_domain_uuid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->domain_uuid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_forest(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(obj);
	PyObject *py_forest;
	py_forest = PyString_FromStringOrNULL(object->forest);
	return py_forest;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_forest(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(py_obj);
	object->forest = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_dns_domain(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(obj);
	PyObject *py_dns_domain;
	py_dns_domain = PyString_FromStringOrNULL(object->dns_domain);
	return py_dns_domain;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_dns_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(py_obj);
	object->dns_domain = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_pdc_dns_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(obj);
	PyObject *py_pdc_dns_name;
	py_pdc_dns_name = PyString_FromStringOrNULL(object->pdc_dns_name);
	return py_pdc_dns_name;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_pdc_dns_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(py_obj);
	object->pdc_dns_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_domain_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	py_domain_name = PyString_FromStringOrNULL(object->domain_name);
	return py_domain_name;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(py_obj);
	object->domain_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_pdc_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(obj);
	PyObject *py_pdc_name;
	py_pdc_name = PyString_FromStringOrNULL(object->pdc_name);
	return py_pdc_name;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_pdc_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(py_obj);
	object->pdc_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_user_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(obj);
	PyObject *py_user_name;
	py_user_name = PyString_FromStringOrNULL(object->user_name);
	return py_user_name;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_user_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(py_obj);
	object->user_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_server_site(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(obj);
	PyObject *py_server_site;
	py_server_site = PyString_FromStringOrNULL(object->server_site);
	return py_server_site;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_server_site(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(py_obj);
	object->server_site = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_client_site(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(obj);
	PyObject *py_client_site;
	py_client_site = PyString_FromStringOrNULL(object->client_site);
	return py_client_site;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_client_site(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(py_obj);
	object->client_site = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_sockaddr_size(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(obj);
	PyObject *py_sockaddr_size;
	py_sockaddr_size = PyInt_FromLong(object->sockaddr_size);
	return py_sockaddr_size;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_sockaddr_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sockaddr_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_sockaddr(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(obj);
	PyObject *py_sockaddr;
	py_sockaddr = pytalloc_reference_ex(&nbt_sockaddr_Type, pytalloc_get_mem_ctx(obj), &object->sockaddr);
	return py_sockaddr;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_sockaddr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&nbt_sockaddr_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sockaddr = *(struct nbt_sockaddr *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_next_closest_site(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(obj);
	PyObject *py_next_closest_site;
	py_next_closest_site = PyString_FromStringOrNULL(object->next_closest_site);
	return py_next_closest_site;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_next_closest_site(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(py_obj);
	object->next_closest_site = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_nt_version(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(obj);
	PyObject *py_nt_version;
	py_nt_version = PyInt_FromLong(object->nt_version);
	return py_nt_version;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_nt_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->nt_version = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->nt_version = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_lmnt_token(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(obj);
	PyObject *py_lmnt_token;
	py_lmnt_token = PyInt_FromLong(object->lmnt_token);
	return py_lmnt_token;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_lmnt_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->lmnt_token = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_lm20_token(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(obj);
	PyObject *py_lm20_token;
	py_lm20_token = PyInt_FromLong(object->lm20_token);
	return py_lm20_token;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_lm20_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->lm20_token = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_NETLOGON_SAM_LOGON_RESPONSE_EX_getsetters[] = {
	{ discard_const_p(char, "command"), py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_command, py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_command },
	{ discard_const_p(char, "sbz"), py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_sbz, py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_sbz },
	{ discard_const_p(char, "server_type"), py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_server_type, py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_server_type },
	{ discard_const_p(char, "domain_uuid"), py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_domain_uuid, py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_domain_uuid },
	{ discard_const_p(char, "forest"), py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_forest, py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_forest },
	{ discard_const_p(char, "dns_domain"), py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_dns_domain, py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_dns_domain },
	{ discard_const_p(char, "pdc_dns_name"), py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_pdc_dns_name, py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_pdc_dns_name },
	{ discard_const_p(char, "domain_name"), py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_domain_name, py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_domain_name },
	{ discard_const_p(char, "pdc_name"), py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_pdc_name, py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_pdc_name },
	{ discard_const_p(char, "user_name"), py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_user_name, py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_user_name },
	{ discard_const_p(char, "server_site"), py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_server_site, py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_server_site },
	{ discard_const_p(char, "client_site"), py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_client_site, py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_client_site },
	{ discard_const_p(char, "sockaddr_size"), py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_sockaddr_size, py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_sockaddr_size },
	{ discard_const_p(char, "sockaddr"), py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_sockaddr, py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_sockaddr },
	{ discard_const_p(char, "next_closest_site"), py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_next_closest_site, py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_next_closest_site },
	{ discard_const_p(char, "nt_version"), py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_nt_version, py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_nt_version },
	{ discard_const_p(char, "lmnt_token"), py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_lmnt_token, py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_lmnt_token },
	{ discard_const_p(char, "lm20_token"), py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_lm20_token, py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_lm20_token },
	{ NULL }
};

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NETLOGON_SAM_LOGON_RESPONSE_EX, type);
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_ndr_pack(PyObject *py_obj)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_NETLOGON_SAM_LOGON_RESPONSE_EX);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NETLOGON_SAM_LOGON_RESPONSE_EX);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NETLOGON_SAM_LOGON_RESPONSE_EX);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_ndr_print(PyObject *py_obj)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = (struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NETLOGON_SAM_LOGON_RESPONSE_EX, "NETLOGON_SAM_LOGON_RESPONSE_EX", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_NETLOGON_SAM_LOGON_RESPONSE_EX_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_NETLOGON_SAM_LOGON_RESPONSE_EX_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_NETLOGON_SAM_LOGON_RESPONSE_EX_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_NETLOGON_SAM_LOGON_RESPONSE_EX_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject NETLOGON_SAM_LOGON_RESPONSE_EX_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.NETLOGON_SAM_LOGON_RESPONSE_EX",
	.tp_getset = py_NETLOGON_SAM_LOGON_RESPONSE_EX_getsetters,
	.tp_methods = py_NETLOGON_SAM_LOGON_RESPONSE_EX_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_NETLOGON_SAM_LOGON_RESPONSE_EX_new,
};


static PyObject *py_nbt_netlogon_query_for_pdc_get_computer_name(PyObject *obj, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = (struct nbt_netlogon_query_for_pdc *)pytalloc_get_ptr(obj);
	PyObject *py_computer_name;
	py_computer_name = PyString_FromStringOrNULL(object->computer_name);
	return py_computer_name;
}

static int py_nbt_netlogon_query_for_pdc_set_computer_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = (struct nbt_netlogon_query_for_pdc *)pytalloc_get_ptr(py_obj);
	object->computer_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_nbt_netlogon_query_for_pdc_get_mailslot_name(PyObject *obj, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = (struct nbt_netlogon_query_for_pdc *)pytalloc_get_ptr(obj);
	PyObject *py_mailslot_name;
	py_mailslot_name = PyString_FromStringOrNULL(object->mailslot_name);
	return py_mailslot_name;
}

static int py_nbt_netlogon_query_for_pdc_set_mailslot_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = (struct nbt_netlogon_query_for_pdc *)pytalloc_get_ptr(py_obj);
	object->mailslot_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_nbt_netlogon_query_for_pdc_get__pad(PyObject *obj, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = (struct nbt_netlogon_query_for_pdc *)pytalloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyString_FromStringAndSize((char *)(object->_pad).data, (object->_pad).length);
	return py__pad;
}

static int py_nbt_netlogon_query_for_pdc_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = (struct nbt_netlogon_query_for_pdc *)pytalloc_get_ptr(py_obj);
	object->_pad = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyObject *py_nbt_netlogon_query_for_pdc_get_unicode_name(PyObject *obj, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = (struct nbt_netlogon_query_for_pdc *)pytalloc_get_ptr(obj);
	PyObject *py_unicode_name;
	py_unicode_name = PyString_FromStringOrNULL(object->unicode_name);
	return py_unicode_name;
}

static int py_nbt_netlogon_query_for_pdc_set_unicode_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = (struct nbt_netlogon_query_for_pdc *)pytalloc_get_ptr(py_obj);
	object->unicode_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_nbt_netlogon_query_for_pdc_get_nt_version(PyObject *obj, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = (struct nbt_netlogon_query_for_pdc *)pytalloc_get_ptr(obj);
	PyObject *py_nt_version;
	py_nt_version = PyInt_FromLong(object->nt_version);
	return py_nt_version;
}

static int py_nbt_netlogon_query_for_pdc_set_nt_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = (struct nbt_netlogon_query_for_pdc *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->nt_version = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->nt_version = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_nbt_netlogon_query_for_pdc_get_lmnt_token(PyObject *obj, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = (struct nbt_netlogon_query_for_pdc *)pytalloc_get_ptr(obj);
	PyObject *py_lmnt_token;
	py_lmnt_token = PyInt_FromLong(object->lmnt_token);
	return py_lmnt_token;
}

static int py_nbt_netlogon_query_for_pdc_set_lmnt_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = (struct nbt_netlogon_query_for_pdc *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->lmnt_token = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_netlogon_query_for_pdc_get_lm20_token(PyObject *obj, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = (struct nbt_netlogon_query_for_pdc *)pytalloc_get_ptr(obj);
	PyObject *py_lm20_token;
	py_lm20_token = PyInt_FromLong(object->lm20_token);
	return py_lm20_token;
}

static int py_nbt_netlogon_query_for_pdc_set_lm20_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = (struct nbt_netlogon_query_for_pdc *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->lm20_token = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_nbt_netlogon_query_for_pdc_getsetters[] = {
	{ discard_const_p(char, "computer_name"), py_nbt_netlogon_query_for_pdc_get_computer_name, py_nbt_netlogon_query_for_pdc_set_computer_name },
	{ discard_const_p(char, "mailslot_name"), py_nbt_netlogon_query_for_pdc_get_mailslot_name, py_nbt_netlogon_query_for_pdc_set_mailslot_name },
	{ discard_const_p(char, "_pad"), py_nbt_netlogon_query_for_pdc_get__pad, py_nbt_netlogon_query_for_pdc_set__pad },
	{ discard_const_p(char, "unicode_name"), py_nbt_netlogon_query_for_pdc_get_unicode_name, py_nbt_netlogon_query_for_pdc_set_unicode_name },
	{ discard_const_p(char, "nt_version"), py_nbt_netlogon_query_for_pdc_get_nt_version, py_nbt_netlogon_query_for_pdc_set_nt_version },
	{ discard_const_p(char, "lmnt_token"), py_nbt_netlogon_query_for_pdc_get_lmnt_token, py_nbt_netlogon_query_for_pdc_set_lmnt_token },
	{ discard_const_p(char, "lm20_token"), py_nbt_netlogon_query_for_pdc_get_lm20_token, py_nbt_netlogon_query_for_pdc_set_lm20_token },
	{ NULL }
};

static PyObject *py_nbt_netlogon_query_for_pdc_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_netlogon_query_for_pdc, type);
}


static PyTypeObject nbt_netlogon_query_for_pdc_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.netlogon_query_for_pdc",
	.tp_getset = py_nbt_netlogon_query_for_pdc_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_netlogon_query_for_pdc_new,
};


static PyObject *py_nbt_netlogon_response_from_pdc_get_command(PyObject *obj, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = (struct nbt_netlogon_response_from_pdc *)pytalloc_get_ptr(obj);
	PyObject *py_command;
	py_command = PyInt_FromLong(object->command);
	return py_command;
}

static int py_nbt_netlogon_response_from_pdc_set_command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = (struct nbt_netlogon_response_from_pdc *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->command = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->command = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_nbt_netlogon_response_from_pdc_get_pdc_name(PyObject *obj, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = (struct nbt_netlogon_response_from_pdc *)pytalloc_get_ptr(obj);
	PyObject *py_pdc_name;
	py_pdc_name = PyString_FromStringOrNULL(object->pdc_name);
	return py_pdc_name;
}

static int py_nbt_netlogon_response_from_pdc_set_pdc_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = (struct nbt_netlogon_response_from_pdc *)pytalloc_get_ptr(py_obj);
	object->pdc_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_nbt_netlogon_response_from_pdc_get__pad(PyObject *obj, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = (struct nbt_netlogon_response_from_pdc *)pytalloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyString_FromStringAndSize((char *)(object->_pad).data, (object->_pad).length);
	return py__pad;
}

static int py_nbt_netlogon_response_from_pdc_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = (struct nbt_netlogon_response_from_pdc *)pytalloc_get_ptr(py_obj);
	object->_pad = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyObject *py_nbt_netlogon_response_from_pdc_get_unicode_pdc_name(PyObject *obj, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = (struct nbt_netlogon_response_from_pdc *)pytalloc_get_ptr(obj);
	PyObject *py_unicode_pdc_name;
	py_unicode_pdc_name = PyString_FromStringOrNULL(object->unicode_pdc_name);
	return py_unicode_pdc_name;
}

static int py_nbt_netlogon_response_from_pdc_set_unicode_pdc_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = (struct nbt_netlogon_response_from_pdc *)pytalloc_get_ptr(py_obj);
	object->unicode_pdc_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_nbt_netlogon_response_from_pdc_get_domain_name(PyObject *obj, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = (struct nbt_netlogon_response_from_pdc *)pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	py_domain_name = PyString_FromStringOrNULL(object->domain_name);
	return py_domain_name;
}

static int py_nbt_netlogon_response_from_pdc_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = (struct nbt_netlogon_response_from_pdc *)pytalloc_get_ptr(py_obj);
	object->domain_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_nbt_netlogon_response_from_pdc_get_nt_version(PyObject *obj, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = (struct nbt_netlogon_response_from_pdc *)pytalloc_get_ptr(obj);
	PyObject *py_nt_version;
	py_nt_version = PyInt_FromLong(object->nt_version);
	return py_nt_version;
}

static int py_nbt_netlogon_response_from_pdc_set_nt_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = (struct nbt_netlogon_response_from_pdc *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->nt_version = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->nt_version = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_nbt_netlogon_response_from_pdc_get_lmnt_token(PyObject *obj, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = (struct nbt_netlogon_response_from_pdc *)pytalloc_get_ptr(obj);
	PyObject *py_lmnt_token;
	py_lmnt_token = PyInt_FromLong(object->lmnt_token);
	return py_lmnt_token;
}

static int py_nbt_netlogon_response_from_pdc_set_lmnt_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = (struct nbt_netlogon_response_from_pdc *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->lmnt_token = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_netlogon_response_from_pdc_get_lm20_token(PyObject *obj, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = (struct nbt_netlogon_response_from_pdc *)pytalloc_get_ptr(obj);
	PyObject *py_lm20_token;
	py_lm20_token = PyInt_FromLong(object->lm20_token);
	return py_lm20_token;
}

static int py_nbt_netlogon_response_from_pdc_set_lm20_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = (struct nbt_netlogon_response_from_pdc *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->lm20_token = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_nbt_netlogon_response_from_pdc_getsetters[] = {
	{ discard_const_p(char, "command"), py_nbt_netlogon_response_from_pdc_get_command, py_nbt_netlogon_response_from_pdc_set_command },
	{ discard_const_p(char, "pdc_name"), py_nbt_netlogon_response_from_pdc_get_pdc_name, py_nbt_netlogon_response_from_pdc_set_pdc_name },
	{ discard_const_p(char, "_pad"), py_nbt_netlogon_response_from_pdc_get__pad, py_nbt_netlogon_response_from_pdc_set__pad },
	{ discard_const_p(char, "unicode_pdc_name"), py_nbt_netlogon_response_from_pdc_get_unicode_pdc_name, py_nbt_netlogon_response_from_pdc_set_unicode_pdc_name },
	{ discard_const_p(char, "domain_name"), py_nbt_netlogon_response_from_pdc_get_domain_name, py_nbt_netlogon_response_from_pdc_set_domain_name },
	{ discard_const_p(char, "nt_version"), py_nbt_netlogon_response_from_pdc_get_nt_version, py_nbt_netlogon_response_from_pdc_set_nt_version },
	{ discard_const_p(char, "lmnt_token"), py_nbt_netlogon_response_from_pdc_get_lmnt_token, py_nbt_netlogon_response_from_pdc_set_lmnt_token },
	{ discard_const_p(char, "lm20_token"), py_nbt_netlogon_response_from_pdc_get_lm20_token, py_nbt_netlogon_response_from_pdc_set_lm20_token },
	{ NULL }
};

static PyObject *py_nbt_netlogon_response_from_pdc_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_netlogon_response_from_pdc, type);
}

static PyObject *py_nbt_netlogon_response_from_pdc_ndr_pack(PyObject *py_obj)
{
	struct nbt_netlogon_response_from_pdc *object = (struct nbt_netlogon_response_from_pdc *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_nbt_netlogon_response_from_pdc);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_nbt_netlogon_response_from_pdc_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct nbt_netlogon_response_from_pdc *object = (struct nbt_netlogon_response_from_pdc *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_netlogon_response_from_pdc);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_netlogon_response_from_pdc);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_nbt_netlogon_response_from_pdc_ndr_print(PyObject *py_obj)
{
	struct nbt_netlogon_response_from_pdc *object = (struct nbt_netlogon_response_from_pdc *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_nbt_netlogon_response_from_pdc, "nbt_netlogon_response_from_pdc", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_nbt_netlogon_response_from_pdc_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_nbt_netlogon_response_from_pdc_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_nbt_netlogon_response_from_pdc_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_nbt_netlogon_response_from_pdc_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject nbt_netlogon_response_from_pdc_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.netlogon_response_from_pdc",
	.tp_getset = py_nbt_netlogon_response_from_pdc_getsetters,
	.tp_methods = py_nbt_netlogon_response_from_pdc_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_netlogon_response_from_pdc_new,
};


static PyObject *py_nbt_netlogon_response2_get_command(PyObject *obj, void *closure)
{
	struct nbt_netlogon_response2 *object = (struct nbt_netlogon_response2 *)pytalloc_get_ptr(obj);
	PyObject *py_command;
	py_command = PyInt_FromLong(object->command);
	return py_command;
}

static int py_nbt_netlogon_response2_set_command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_response2 *object = (struct nbt_netlogon_response2 *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->command = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->command = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_nbt_netlogon_response2_get_pdc_name(PyObject *obj, void *closure)
{
	struct nbt_netlogon_response2 *object = (struct nbt_netlogon_response2 *)pytalloc_get_ptr(obj);
	PyObject *py_pdc_name;
	py_pdc_name = PyString_FromStringOrNULL(object->pdc_name);
	return py_pdc_name;
}

static int py_nbt_netlogon_response2_set_pdc_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_response2 *object = (struct nbt_netlogon_response2 *)pytalloc_get_ptr(py_obj);
	object->pdc_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_nbt_netlogon_response2_get_lm20_token(PyObject *obj, void *closure)
{
	struct nbt_netlogon_response2 *object = (struct nbt_netlogon_response2 *)pytalloc_get_ptr(obj);
	PyObject *py_lm20_token;
	py_lm20_token = PyInt_FromLong(object->lm20_token);
	return py_lm20_token;
}

static int py_nbt_netlogon_response2_set_lm20_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_response2 *object = (struct nbt_netlogon_response2 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->lm20_token = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_nbt_netlogon_response2_getsetters[] = {
	{ discard_const_p(char, "command"), py_nbt_netlogon_response2_get_command, py_nbt_netlogon_response2_set_command },
	{ discard_const_p(char, "pdc_name"), py_nbt_netlogon_response2_get_pdc_name, py_nbt_netlogon_response2_set_pdc_name },
	{ discard_const_p(char, "lm20_token"), py_nbt_netlogon_response2_get_lm20_token, py_nbt_netlogon_response2_set_lm20_token },
	{ NULL }
};

static PyObject *py_nbt_netlogon_response2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_netlogon_response2, type);
}

static PyObject *py_nbt_netlogon_response2_ndr_pack(PyObject *py_obj)
{
	struct nbt_netlogon_response2 *object = (struct nbt_netlogon_response2 *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_nbt_netlogon_response2);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_nbt_netlogon_response2_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct nbt_netlogon_response2 *object = (struct nbt_netlogon_response2 *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_netlogon_response2);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_netlogon_response2);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_nbt_netlogon_response2_ndr_print(PyObject *py_obj)
{
	struct nbt_netlogon_response2 *object = (struct nbt_netlogon_response2 *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_nbt_netlogon_response2, "nbt_netlogon_response2", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_nbt_netlogon_response2_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_nbt_netlogon_response2_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_nbt_netlogon_response2_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_nbt_netlogon_response2_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject nbt_netlogon_response2_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.netlogon_response2",
	.tp_getset = py_nbt_netlogon_response2_getsetters,
	.tp_methods = py_nbt_netlogon_response2_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_netlogon_response2_new,
};


static PyObject *py_nbt_db_change_info_get_db_index(PyObject *obj, void *closure)
{
	struct nbt_db_change_info *object = (struct nbt_db_change_info *)pytalloc_get_ptr(obj);
	PyObject *py_db_index;
	py_db_index = PyInt_FromLong(object->db_index);
	return py_db_index;
}

static int py_nbt_db_change_info_set_db_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_db_change_info *object = (struct nbt_db_change_info *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->db_index = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->db_index = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_nbt_db_change_info_get_serial(PyObject *obj, void *closure)
{
	struct nbt_db_change_info *object = (struct nbt_db_change_info *)pytalloc_get_ptr(obj);
	PyObject *py_serial;
	py_serial = PyLong_FromLongLong(object->serial);
	return py_serial;
}

static int py_nbt_db_change_info_set_serial(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_db_change_info *object = (struct nbt_db_change_info *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->serial = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->serial = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_nbt_db_change_info_get_timestamp(PyObject *obj, void *closure)
{
	struct nbt_db_change_info *object = (struct nbt_db_change_info *)pytalloc_get_ptr(obj);
	PyObject *py_timestamp;
	py_timestamp = PyLong_FromLongLong(object->timestamp);
	return py_timestamp;
}

static int py_nbt_db_change_info_set_timestamp(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_db_change_info *object = (struct nbt_db_change_info *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->timestamp = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->timestamp = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyGetSetDef py_nbt_db_change_info_getsetters[] = {
	{ discard_const_p(char, "db_index"), py_nbt_db_change_info_get_db_index, py_nbt_db_change_info_set_db_index },
	{ discard_const_p(char, "serial"), py_nbt_db_change_info_get_serial, py_nbt_db_change_info_set_serial },
	{ discard_const_p(char, "timestamp"), py_nbt_db_change_info_get_timestamp, py_nbt_db_change_info_set_timestamp },
	{ NULL }
};

static PyObject *py_nbt_db_change_info_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_db_change_info, type);
}


static PyTypeObject nbt_db_change_info_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.db_change_info",
	.tp_getset = py_nbt_db_change_info_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_db_change_info_new,
};


static PyObject *py_NETLOGON_DB_CHANGE_get_serial_lo(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(obj);
	PyObject *py_serial_lo;
	py_serial_lo = PyInt_FromLong(object->serial_lo);
	return py_serial_lo;
}

static int py_NETLOGON_DB_CHANGE_set_serial_lo(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->serial_lo = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_timestamp(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(obj);
	PyObject *py_timestamp;
	py_timestamp = PyInt_FromLong(object->timestamp);
	return py_timestamp;
}

static int py_NETLOGON_DB_CHANGE_set_timestamp(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->timestamp = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_pulse(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(obj);
	PyObject *py_pulse;
	py_pulse = PyInt_FromLong(object->pulse);
	return py_pulse;
}

static int py_NETLOGON_DB_CHANGE_set_pulse(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pulse = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_random(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(obj);
	PyObject *py_random;
	py_random = PyInt_FromLong(object->random);
	return py_random;
}

static int py_NETLOGON_DB_CHANGE_set_random(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->random = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_pdc_name(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(obj);
	PyObject *py_pdc_name;
	py_pdc_name = PyString_FromStringOrNULL(object->pdc_name);
	return py_pdc_name;
}

static int py_NETLOGON_DB_CHANGE_set_pdc_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(py_obj);
	object->pdc_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_domain(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(obj);
	PyObject *py_domain;
	py_domain = PyString_FromStringOrNULL(object->domain);
	return py_domain;
}

static int py_NETLOGON_DB_CHANGE_set_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(py_obj);
	object->domain = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get__pad(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyString_FromStringAndSize((char *)(object->_pad).data, (object->_pad).length);
	return py__pad;
}

static int py_NETLOGON_DB_CHANGE_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(py_obj);
	object->_pad = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_unicode_pdc_name(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(obj);
	PyObject *py_unicode_pdc_name;
	py_unicode_pdc_name = PyString_FromStringOrNULL(object->unicode_pdc_name);
	return py_unicode_pdc_name;
}

static int py_NETLOGON_DB_CHANGE_set_unicode_pdc_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(py_obj);
	object->unicode_pdc_name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_unicode_domain(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(obj);
	PyObject *py_unicode_domain;
	py_unicode_domain = PyString_FromStringOrNULL(object->unicode_domain);
	return py_unicode_domain;
}

static int py_NETLOGON_DB_CHANGE_set_unicode_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(py_obj);
	object->unicode_domain = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_db_count(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(obj);
	PyObject *py_db_count;
	py_db_count = PyInt_FromLong(object->db_count);
	return py_db_count;
}

static int py_NETLOGON_DB_CHANGE_set_db_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->db_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_dbchange(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(obj);
	PyObject *py_dbchange;
	py_dbchange = PyList_New(object->db_count);
	if (py_dbchange == NULL) {
		return NULL;
	}
	{
		int dbchange_cntr_0;
		for (dbchange_cntr_0 = 0; dbchange_cntr_0 < object->db_count; dbchange_cntr_0++) {
			PyObject *py_dbchange_0;
			py_dbchange_0 = pytalloc_reference_ex(&nbt_db_change_info_Type, object->dbchange, &object->dbchange[dbchange_cntr_0]);
			PyList_SetItem(py_dbchange, dbchange_cntr_0, py_dbchange_0);
		}
	}
	return py_dbchange;
}

static int py_NETLOGON_DB_CHANGE_set_dbchange(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int dbchange_cntr_0;
		object->dbchange = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->dbchange, PyList_GET_SIZE(value));
		if (!object->dbchange) { return -1;; }
		talloc_set_name_const(object->dbchange, "ARRAY: object->dbchange");
		for (dbchange_cntr_0 = 0; dbchange_cntr_0 < PyList_GET_SIZE(value); dbchange_cntr_0++) {
			PY_CHECK_TYPE(&nbt_db_change_info_Type, PyList_GET_ITEM(value, dbchange_cntr_0), return -1;);
			if (talloc_reference(object->dbchange, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, dbchange_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->dbchange[dbchange_cntr_0] = *(struct nbt_db_change_info *)pytalloc_get_ptr(PyList_GET_ITEM(value, dbchange_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_sid_size(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(obj);
	PyObject *py_sid_size;
	py_sid_size = PyInt_FromLong(object->sid_size);
	return py_sid_size;
}

static int py_NETLOGON_DB_CHANGE_set_sid_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sid_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_sid(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(obj);
	PyObject *py_sid;
	py_sid = pytalloc_reference_ex(dom_sid_Type, pytalloc_get_mem_ctx(obj), &object->sid);
	return py_sid;
}

static int py_NETLOGON_DB_CHANGE_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sid = *(struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_message_format_version(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(obj);
	PyObject *py_message_format_version;
	py_message_format_version = PyInt_FromLong(object->message_format_version);
	return py_message_format_version;
}

static int py_NETLOGON_DB_CHANGE_set_message_format_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->message_format_version = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_message_token(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(obj);
	PyObject *py_message_token;
	py_message_token = PyInt_FromLong(object->message_token);
	return py_message_token;
}

static int py_NETLOGON_DB_CHANGE_set_message_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = (struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->message_token = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_NETLOGON_DB_CHANGE_getsetters[] = {
	{ discard_const_p(char, "serial_lo"), py_NETLOGON_DB_CHANGE_get_serial_lo, py_NETLOGON_DB_CHANGE_set_serial_lo },
	{ discard_const_p(char, "timestamp"), py_NETLOGON_DB_CHANGE_get_timestamp, py_NETLOGON_DB_CHANGE_set_timestamp },
	{ discard_const_p(char, "pulse"), py_NETLOGON_DB_CHANGE_get_pulse, py_NETLOGON_DB_CHANGE_set_pulse },
	{ discard_const_p(char, "random"), py_NETLOGON_DB_CHANGE_get_random, py_NETLOGON_DB_CHANGE_set_random },
	{ discard_const_p(char, "pdc_name"), py_NETLOGON_DB_CHANGE_get_pdc_name, py_NETLOGON_DB_CHANGE_set_pdc_name },
	{ discard_const_p(char, "domain"), py_NETLOGON_DB_CHANGE_get_domain, py_NETLOGON_DB_CHANGE_set_domain },
	{ discard_const_p(char, "_pad"), py_NETLOGON_DB_CHANGE_get__pad, py_NETLOGON_DB_CHANGE_set__pad },
	{ discard_const_p(char, "unicode_pdc_name"), py_NETLOGON_DB_CHANGE_get_unicode_pdc_name, py_NETLOGON_DB_CHANGE_set_unicode_pdc_name },
	{ discard_const_p(char, "unicode_domain"), py_NETLOGON_DB_CHANGE_get_unicode_domain, py_NETLOGON_DB_CHANGE_set_unicode_domain },
	{ discard_const_p(char, "db_count"), py_NETLOGON_DB_CHANGE_get_db_count, py_NETLOGON_DB_CHANGE_set_db_count },
	{ discard_const_p(char, "dbchange"), py_NETLOGON_DB_CHANGE_get_dbchange, py_NETLOGON_DB_CHANGE_set_dbchange },
	{ discard_const_p(char, "sid_size"), py_NETLOGON_DB_CHANGE_get_sid_size, py_NETLOGON_DB_CHANGE_set_sid_size },
	{ discard_const_p(char, "sid"), py_NETLOGON_DB_CHANGE_get_sid, py_NETLOGON_DB_CHANGE_set_sid },
	{ discard_const_p(char, "message_format_version"), py_NETLOGON_DB_CHANGE_get_message_format_version, py_NETLOGON_DB_CHANGE_set_message_format_version },
	{ discard_const_p(char, "message_token"), py_NETLOGON_DB_CHANGE_get_message_token, py_NETLOGON_DB_CHANGE_set_message_token },
	{ NULL }
};

static PyObject *py_NETLOGON_DB_CHANGE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NETLOGON_DB_CHANGE, type);
}


static PyTypeObject NETLOGON_DB_CHANGE_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.NETLOGON_DB_CHANGE",
	.tp_getset = py_NETLOGON_DB_CHANGE_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_NETLOGON_DB_CHANGE_new,
};

PyObject *py_import_nbt_netlogon_request(TALLOC_CTX *mem_ctx, int level, union nbt_netlogon_request *in)
{
	PyObject *ret;

	switch (level) {
		case LOGON_REQUEST:
			ret = pytalloc_reference_ex(&NETLOGON_LOGON_REQUEST_Type, mem_ctx, &in->logon0);
			return ret;

		case LOGON_SAM_LOGON_REQUEST:
			ret = pytalloc_reference_ex(&NETLOGON_SAM_LOGON_REQUEST_Type, mem_ctx, &in->logon);
			return ret;

		case LOGON_PRIMARY_QUERY:
			ret = pytalloc_reference_ex(&nbt_netlogon_query_for_pdc_Type, mem_ctx, &in->pdc);
			return ret;

		case NETLOGON_ANNOUNCE_UAS:
			ret = pytalloc_reference_ex(&NETLOGON_DB_CHANGE_Type, mem_ctx, &in->uas);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union nbt_netlogon_request *py_export_nbt_netlogon_request(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union nbt_netlogon_request *ret = talloc_zero(mem_ctx, union nbt_netlogon_request);
	switch (level) {
		case LOGON_REQUEST:
			PY_CHECK_TYPE(&NETLOGON_LOGON_REQUEST_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->logon0 = *(struct NETLOGON_LOGON_REQUEST *)pytalloc_get_ptr(in);
			break;

		case LOGON_SAM_LOGON_REQUEST:
			PY_CHECK_TYPE(&NETLOGON_SAM_LOGON_REQUEST_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->logon = *(struct NETLOGON_SAM_LOGON_REQUEST *)pytalloc_get_ptr(in);
			break;

		case LOGON_PRIMARY_QUERY:
			PY_CHECK_TYPE(&nbt_netlogon_query_for_pdc_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->pdc = *(struct nbt_netlogon_query_for_pdc *)pytalloc_get_ptr(in);
			break;

		case NETLOGON_ANNOUNCE_UAS:
			PY_CHECK_TYPE(&NETLOGON_DB_CHANGE_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->uas = *(struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_nbt_netlogon_packet_get_command(PyObject *obj, void *closure)
{
	struct nbt_netlogon_packet *object = (struct nbt_netlogon_packet *)pytalloc_get_ptr(obj);
	PyObject *py_command;
	py_command = PyInt_FromLong(object->command);
	return py_command;
}

static int py_nbt_netlogon_packet_set_command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_packet *object = (struct nbt_netlogon_packet *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->command = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->command = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_nbt_netlogon_packet_get_req(PyObject *obj, void *closure)
{
	struct nbt_netlogon_packet *object = (struct nbt_netlogon_packet *)pytalloc_get_ptr(obj);
	PyObject *py_req;
	py_req = py_import_nbt_netlogon_request(pytalloc_get_mem_ctx(obj), object->command, &object->req);
	if (py_req == NULL) {
		return NULL;
	}
	return py_req;
}

static int py_nbt_netlogon_packet_set_req(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_packet *object = (struct nbt_netlogon_packet *)pytalloc_get_ptr(py_obj);
	{
		union nbt_netlogon_request *req_switch_0;
		req_switch_0 = py_export_nbt_netlogon_request(pytalloc_get_mem_ctx(py_obj), object->command, value);
		if (req_switch_0 == NULL) {
			return -1;
		}
		object->req = *req_switch_0;
	}
	return 0;
}

static PyGetSetDef py_nbt_netlogon_packet_getsetters[] = {
	{ discard_const_p(char, "command"), py_nbt_netlogon_packet_get_command, py_nbt_netlogon_packet_set_command },
	{ discard_const_p(char, "req"), py_nbt_netlogon_packet_get_req, py_nbt_netlogon_packet_set_req },
	{ NULL }
};

static PyObject *py_nbt_netlogon_packet_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_netlogon_packet, type);
}

static PyObject *py_nbt_netlogon_packet_ndr_pack(PyObject *py_obj)
{
	struct nbt_netlogon_packet *object = (struct nbt_netlogon_packet *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_nbt_netlogon_packet);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_nbt_netlogon_packet_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct nbt_netlogon_packet *object = (struct nbt_netlogon_packet *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_netlogon_packet);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_netlogon_packet);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_nbt_netlogon_packet_ndr_print(PyObject *py_obj)
{
	struct nbt_netlogon_packet *object = (struct nbt_netlogon_packet *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_nbt_netlogon_packet, "nbt_netlogon_packet", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_nbt_netlogon_packet_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_nbt_netlogon_packet_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_nbt_netlogon_packet_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_nbt_netlogon_packet_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject nbt_netlogon_packet_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.netlogon_packet",
	.tp_getset = py_nbt_netlogon_packet_getsetters,
	.tp_methods = py_nbt_netlogon_packet_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_netlogon_packet_new,
};


static PyObject *py_nbt_browse_host_announcement_get_UpdateCount(PyObject *obj, void *closure)
{
	struct nbt_browse_host_announcement *object = (struct nbt_browse_host_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_UpdateCount;
	py_UpdateCount = PyInt_FromLong(object->UpdateCount);
	return py_UpdateCount;
}

static int py_nbt_browse_host_announcement_set_UpdateCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_host_announcement *object = (struct nbt_browse_host_announcement *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->UpdateCount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_host_announcement_get_Periodicity(PyObject *obj, void *closure)
{
	struct nbt_browse_host_announcement *object = (struct nbt_browse_host_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_Periodicity;
	py_Periodicity = PyInt_FromLong(object->Periodicity);
	return py_Periodicity;
}

static int py_nbt_browse_host_announcement_set_Periodicity(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_host_announcement *object = (struct nbt_browse_host_announcement *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Periodicity = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_host_announcement_get_ServerName(PyObject *obj, void *closure)
{
	struct nbt_browse_host_announcement *object = (struct nbt_browse_host_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_ServerName;
	if (object->ServerName == NULL) {
		py_ServerName = Py_None;
		Py_INCREF(py_ServerName);
	} else {
		py_ServerName = PyUnicode_Decode(object->ServerName, strlen(object->ServerName), "utf-8", "ignore");
	}
	return py_ServerName;
}

static int py_nbt_browse_host_announcement_set_ServerName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_host_announcement *object = (struct nbt_browse_host_announcement *)pytalloc_get_ptr(py_obj);
	if (PyUnicode_Check(value)) {
		object->ServerName = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	} else if (PyString_Check(value)) {
		object->ServerName = PyString_AS_STRING(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_nbt_browse_host_announcement_get_OSMajor(PyObject *obj, void *closure)
{
	struct nbt_browse_host_announcement *object = (struct nbt_browse_host_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_OSMajor;
	py_OSMajor = PyInt_FromLong(object->OSMajor);
	return py_OSMajor;
}

static int py_nbt_browse_host_announcement_set_OSMajor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_host_announcement *object = (struct nbt_browse_host_announcement *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->OSMajor = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_host_announcement_get_OSMinor(PyObject *obj, void *closure)
{
	struct nbt_browse_host_announcement *object = (struct nbt_browse_host_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_OSMinor;
	py_OSMinor = PyInt_FromLong(object->OSMinor);
	return py_OSMinor;
}

static int py_nbt_browse_host_announcement_set_OSMinor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_host_announcement *object = (struct nbt_browse_host_announcement *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->OSMinor = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_host_announcement_get_ServerType(PyObject *obj, void *closure)
{
	struct nbt_browse_host_announcement *object = (struct nbt_browse_host_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_ServerType;
	py_ServerType = PyInt_FromLong(object->ServerType);
	return py_ServerType;
}

static int py_nbt_browse_host_announcement_set_ServerType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_host_announcement *object = (struct nbt_browse_host_announcement *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->ServerType = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->ServerType = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_nbt_browse_host_announcement_get_BroMajorVer(PyObject *obj, void *closure)
{
	struct nbt_browse_host_announcement *object = (struct nbt_browse_host_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_BroMajorVer;
	py_BroMajorVer = PyInt_FromLong(object->BroMajorVer);
	return py_BroMajorVer;
}

static int py_nbt_browse_host_announcement_set_BroMajorVer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_host_announcement *object = (struct nbt_browse_host_announcement *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->BroMajorVer = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_host_announcement_get_BroMinorVer(PyObject *obj, void *closure)
{
	struct nbt_browse_host_announcement *object = (struct nbt_browse_host_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_BroMinorVer;
	py_BroMinorVer = PyInt_FromLong(object->BroMinorVer);
	return py_BroMinorVer;
}

static int py_nbt_browse_host_announcement_set_BroMinorVer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_host_announcement *object = (struct nbt_browse_host_announcement *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->BroMinorVer = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_host_announcement_get_Signature(PyObject *obj, void *closure)
{
	struct nbt_browse_host_announcement *object = (struct nbt_browse_host_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_Signature;
	py_Signature = PyInt_FromLong(object->Signature);
	return py_Signature;
}

static int py_nbt_browse_host_announcement_set_Signature(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_host_announcement *object = (struct nbt_browse_host_announcement *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Signature = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_host_announcement_get_Comment(PyObject *obj, void *closure)
{
	struct nbt_browse_host_announcement *object = (struct nbt_browse_host_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_Comment;
	py_Comment = PyString_FromStringOrNULL(object->Comment);
	return py_Comment;
}

static int py_nbt_browse_host_announcement_set_Comment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_host_announcement *object = (struct nbt_browse_host_announcement *)pytalloc_get_ptr(py_obj);
	object->Comment = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyGetSetDef py_nbt_browse_host_announcement_getsetters[] = {
	{ discard_const_p(char, "UpdateCount"), py_nbt_browse_host_announcement_get_UpdateCount, py_nbt_browse_host_announcement_set_UpdateCount },
	{ discard_const_p(char, "Periodicity"), py_nbt_browse_host_announcement_get_Periodicity, py_nbt_browse_host_announcement_set_Periodicity },
	{ discard_const_p(char, "ServerName"), py_nbt_browse_host_announcement_get_ServerName, py_nbt_browse_host_announcement_set_ServerName },
	{ discard_const_p(char, "OSMajor"), py_nbt_browse_host_announcement_get_OSMajor, py_nbt_browse_host_announcement_set_OSMajor },
	{ discard_const_p(char, "OSMinor"), py_nbt_browse_host_announcement_get_OSMinor, py_nbt_browse_host_announcement_set_OSMinor },
	{ discard_const_p(char, "ServerType"), py_nbt_browse_host_announcement_get_ServerType, py_nbt_browse_host_announcement_set_ServerType },
	{ discard_const_p(char, "BroMajorVer"), py_nbt_browse_host_announcement_get_BroMajorVer, py_nbt_browse_host_announcement_set_BroMajorVer },
	{ discard_const_p(char, "BroMinorVer"), py_nbt_browse_host_announcement_get_BroMinorVer, py_nbt_browse_host_announcement_set_BroMinorVer },
	{ discard_const_p(char, "Signature"), py_nbt_browse_host_announcement_get_Signature, py_nbt_browse_host_announcement_set_Signature },
	{ discard_const_p(char, "Comment"), py_nbt_browse_host_announcement_get_Comment, py_nbt_browse_host_announcement_set_Comment },
	{ NULL }
};

static PyObject *py_nbt_browse_host_announcement_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_browse_host_announcement, type);
}


static PyTypeObject nbt_browse_host_announcement_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.browse_host_announcement",
	.tp_getset = py_nbt_browse_host_announcement_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_browse_host_announcement_new,
};


static PyObject *py_nbt_browse_announcement_request_get_Unused(PyObject *obj, void *closure)
{
	struct nbt_browse_announcement_request *object = (struct nbt_browse_announcement_request *)pytalloc_get_ptr(obj);
	PyObject *py_Unused;
	py_Unused = PyInt_FromLong(object->Unused);
	return py_Unused;
}

static int py_nbt_browse_announcement_request_set_Unused(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_announcement_request *object = (struct nbt_browse_announcement_request *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Unused = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_announcement_request_get_ResponseName(PyObject *obj, void *closure)
{
	struct nbt_browse_announcement_request *object = (struct nbt_browse_announcement_request *)pytalloc_get_ptr(obj);
	PyObject *py_ResponseName;
	py_ResponseName = PyString_FromStringOrNULL(object->ResponseName);
	return py_ResponseName;
}

static int py_nbt_browse_announcement_request_set_ResponseName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_announcement_request *object = (struct nbt_browse_announcement_request *)pytalloc_get_ptr(py_obj);
	object->ResponseName = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyGetSetDef py_nbt_browse_announcement_request_getsetters[] = {
	{ discard_const_p(char, "Unused"), py_nbt_browse_announcement_request_get_Unused, py_nbt_browse_announcement_request_set_Unused },
	{ discard_const_p(char, "ResponseName"), py_nbt_browse_announcement_request_get_ResponseName, py_nbt_browse_announcement_request_set_ResponseName },
	{ NULL }
};

static PyObject *py_nbt_browse_announcement_request_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_browse_announcement_request, type);
}


static PyTypeObject nbt_browse_announcement_request_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.browse_announcement_request",
	.tp_getset = py_nbt_browse_announcement_request_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_browse_announcement_request_new,
};


static PyObject *py_nbt_browse_election_request_get_Version(PyObject *obj, void *closure)
{
	struct nbt_browse_election_request *object = (struct nbt_browse_election_request *)pytalloc_get_ptr(obj);
	PyObject *py_Version;
	py_Version = PyInt_FromLong(object->Version);
	return py_Version;
}

static int py_nbt_browse_election_request_set_Version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_election_request *object = (struct nbt_browse_election_request *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Version = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_election_request_get_Criteria(PyObject *obj, void *closure)
{
	struct nbt_browse_election_request *object = (struct nbt_browse_election_request *)pytalloc_get_ptr(obj);
	PyObject *py_Criteria;
	py_Criteria = PyInt_FromLong(object->Criteria);
	return py_Criteria;
}

static int py_nbt_browse_election_request_set_Criteria(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_election_request *object = (struct nbt_browse_election_request *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Criteria = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_election_request_get_UpTime(PyObject *obj, void *closure)
{
	struct nbt_browse_election_request *object = (struct nbt_browse_election_request *)pytalloc_get_ptr(obj);
	PyObject *py_UpTime;
	py_UpTime = PyInt_FromLong(object->UpTime);
	return py_UpTime;
}

static int py_nbt_browse_election_request_set_UpTime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_election_request *object = (struct nbt_browse_election_request *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->UpTime = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_election_request_get_Reserved(PyObject *obj, void *closure)
{
	struct nbt_browse_election_request *object = (struct nbt_browse_election_request *)pytalloc_get_ptr(obj);
	PyObject *py_Reserved;
	py_Reserved = PyInt_FromLong(object->Reserved);
	return py_Reserved;
}

static int py_nbt_browse_election_request_set_Reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_election_request *object = (struct nbt_browse_election_request *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Reserved = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_election_request_get_ServerName(PyObject *obj, void *closure)
{
	struct nbt_browse_election_request *object = (struct nbt_browse_election_request *)pytalloc_get_ptr(obj);
	PyObject *py_ServerName;
	py_ServerName = PyString_FromStringOrNULL(object->ServerName);
	return py_ServerName;
}

static int py_nbt_browse_election_request_set_ServerName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_election_request *object = (struct nbt_browse_election_request *)pytalloc_get_ptr(py_obj);
	object->ServerName = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyGetSetDef py_nbt_browse_election_request_getsetters[] = {
	{ discard_const_p(char, "Version"), py_nbt_browse_election_request_get_Version, py_nbt_browse_election_request_set_Version },
	{ discard_const_p(char, "Criteria"), py_nbt_browse_election_request_get_Criteria, py_nbt_browse_election_request_set_Criteria },
	{ discard_const_p(char, "UpTime"), py_nbt_browse_election_request_get_UpTime, py_nbt_browse_election_request_set_UpTime },
	{ discard_const_p(char, "Reserved"), py_nbt_browse_election_request_get_Reserved, py_nbt_browse_election_request_set_Reserved },
	{ discard_const_p(char, "ServerName"), py_nbt_browse_election_request_get_ServerName, py_nbt_browse_election_request_set_ServerName },
	{ NULL }
};

static PyObject *py_nbt_browse_election_request_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_browse_election_request, type);
}


static PyTypeObject nbt_browse_election_request_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.browse_election_request",
	.tp_getset = py_nbt_browse_election_request_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_browse_election_request_new,
};


static PyObject *py_nbt_browse_backup_list_request_get_ReqCount(PyObject *obj, void *closure)
{
	struct nbt_browse_backup_list_request *object = (struct nbt_browse_backup_list_request *)pytalloc_get_ptr(obj);
	PyObject *py_ReqCount;
	py_ReqCount = PyInt_FromLong(object->ReqCount);
	return py_ReqCount;
}

static int py_nbt_browse_backup_list_request_set_ReqCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_backup_list_request *object = (struct nbt_browse_backup_list_request *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ReqCount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_backup_list_request_get_Token(PyObject *obj, void *closure)
{
	struct nbt_browse_backup_list_request *object = (struct nbt_browse_backup_list_request *)pytalloc_get_ptr(obj);
	PyObject *py_Token;
	py_Token = PyInt_FromLong(object->Token);
	return py_Token;
}

static int py_nbt_browse_backup_list_request_set_Token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_backup_list_request *object = (struct nbt_browse_backup_list_request *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Token = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_nbt_browse_backup_list_request_getsetters[] = {
	{ discard_const_p(char, "ReqCount"), py_nbt_browse_backup_list_request_get_ReqCount, py_nbt_browse_backup_list_request_set_ReqCount },
	{ discard_const_p(char, "Token"), py_nbt_browse_backup_list_request_get_Token, py_nbt_browse_backup_list_request_set_Token },
	{ NULL }
};

static PyObject *py_nbt_browse_backup_list_request_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_browse_backup_list_request, type);
}


static PyTypeObject nbt_browse_backup_list_request_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.browse_backup_list_request",
	.tp_getset = py_nbt_browse_backup_list_request_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_browse_backup_list_request_new,
};


static PyObject *py_nbt_browse_backup_list_response_get_BackupCount(PyObject *obj, void *closure)
{
	struct nbt_browse_backup_list_response *object = (struct nbt_browse_backup_list_response *)pytalloc_get_ptr(obj);
	PyObject *py_BackupCount;
	py_BackupCount = PyInt_FromLong(object->BackupCount);
	return py_BackupCount;
}

static int py_nbt_browse_backup_list_response_set_BackupCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_backup_list_response *object = (struct nbt_browse_backup_list_response *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->BackupCount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_backup_list_response_get_Token(PyObject *obj, void *closure)
{
	struct nbt_browse_backup_list_response *object = (struct nbt_browse_backup_list_response *)pytalloc_get_ptr(obj);
	PyObject *py_Token;
	py_Token = PyInt_FromLong(object->Token);
	return py_Token;
}

static int py_nbt_browse_backup_list_response_set_Token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_backup_list_response *object = (struct nbt_browse_backup_list_response *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Token = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_backup_list_response_get_BackupServerList(PyObject *obj, void *closure)
{
	struct nbt_browse_backup_list_response *object = (struct nbt_browse_backup_list_response *)pytalloc_get_ptr(obj);
	PyObject *py_BackupServerList;
	py_BackupServerList = PyList_New(object->BackupCount);
	if (py_BackupServerList == NULL) {
		return NULL;
	}
	{
		int BackupServerList_cntr_0;
		for (BackupServerList_cntr_0 = 0; BackupServerList_cntr_0 < object->BackupCount; BackupServerList_cntr_0++) {
			PyObject *py_BackupServerList_0;
			py_BackupServerList_0 = pytalloc_reference_ex(&nbt_name_Type, object->BackupServerList, &object->BackupServerList[BackupServerList_cntr_0]);
			PyList_SetItem(py_BackupServerList, BackupServerList_cntr_0, py_BackupServerList_0);
		}
	}
	return py_BackupServerList;
}

static int py_nbt_browse_backup_list_response_set_BackupServerList(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_backup_list_response *object = (struct nbt_browse_backup_list_response *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int BackupServerList_cntr_0;
		object->BackupServerList = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->BackupServerList, PyList_GET_SIZE(value));
		if (!object->BackupServerList) { return -1;; }
		talloc_set_name_const(object->BackupServerList, "ARRAY: object->BackupServerList");
		for (BackupServerList_cntr_0 = 0; BackupServerList_cntr_0 < PyList_GET_SIZE(value); BackupServerList_cntr_0++) {
			PY_CHECK_TYPE(&nbt_name_Type, PyList_GET_ITEM(value, BackupServerList_cntr_0), return -1;);
			if (talloc_reference(object->BackupServerList, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, BackupServerList_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->BackupServerList[BackupServerList_cntr_0] = *(struct nbt_name *)pytalloc_get_ptr(PyList_GET_ITEM(value, BackupServerList_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_nbt_browse_backup_list_response_getsetters[] = {
	{ discard_const_p(char, "BackupCount"), py_nbt_browse_backup_list_response_get_BackupCount, py_nbt_browse_backup_list_response_set_BackupCount },
	{ discard_const_p(char, "Token"), py_nbt_browse_backup_list_response_get_Token, py_nbt_browse_backup_list_response_set_Token },
	{ discard_const_p(char, "BackupServerList"), py_nbt_browse_backup_list_response_get_BackupServerList, py_nbt_browse_backup_list_response_set_BackupServerList },
	{ NULL }
};

static PyObject *py_nbt_browse_backup_list_response_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_browse_backup_list_response, type);
}


static PyTypeObject nbt_browse_backup_list_response_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.browse_backup_list_response",
	.tp_getset = py_nbt_browse_backup_list_response_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_browse_backup_list_response_new,
};


static PyObject *py_nbt_browse_become_backup_get_BrowserName(PyObject *obj, void *closure)
{
	struct nbt_browse_become_backup *object = (struct nbt_browse_become_backup *)pytalloc_get_ptr(obj);
	PyObject *py_BrowserName;
	py_BrowserName = PyString_FromStringOrNULL(object->BrowserName);
	return py_BrowserName;
}

static int py_nbt_browse_become_backup_set_BrowserName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_become_backup *object = (struct nbt_browse_become_backup *)pytalloc_get_ptr(py_obj);
	object->BrowserName = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyGetSetDef py_nbt_browse_become_backup_getsetters[] = {
	{ discard_const_p(char, "BrowserName"), py_nbt_browse_become_backup_get_BrowserName, py_nbt_browse_become_backup_set_BrowserName },
	{ NULL }
};

static PyObject *py_nbt_browse_become_backup_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_browse_become_backup, type);
}


static PyTypeObject nbt_browse_become_backup_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.browse_become_backup",
	.tp_getset = py_nbt_browse_become_backup_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_browse_become_backup_new,
};


static PyObject *py_nbt_browse_domain_announcement_get_UpdateCount(PyObject *obj, void *closure)
{
	struct nbt_browse_domain_announcement *object = (struct nbt_browse_domain_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_UpdateCount;
	py_UpdateCount = PyInt_FromLong(object->UpdateCount);
	return py_UpdateCount;
}

static int py_nbt_browse_domain_announcement_set_UpdateCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_domain_announcement *object = (struct nbt_browse_domain_announcement *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->UpdateCount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_domain_announcement_get_Periodicity(PyObject *obj, void *closure)
{
	struct nbt_browse_domain_announcement *object = (struct nbt_browse_domain_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_Periodicity;
	py_Periodicity = PyInt_FromLong(object->Periodicity);
	return py_Periodicity;
}

static int py_nbt_browse_domain_announcement_set_Periodicity(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_domain_announcement *object = (struct nbt_browse_domain_announcement *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Periodicity = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_domain_announcement_get_ServerName(PyObject *obj, void *closure)
{
	struct nbt_browse_domain_announcement *object = (struct nbt_browse_domain_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_ServerName;
	if (object->ServerName == NULL) {
		py_ServerName = Py_None;
		Py_INCREF(py_ServerName);
	} else {
		py_ServerName = PyUnicode_Decode(object->ServerName, strlen(object->ServerName), "utf-8", "ignore");
	}
	return py_ServerName;
}

static int py_nbt_browse_domain_announcement_set_ServerName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_domain_announcement *object = (struct nbt_browse_domain_announcement *)pytalloc_get_ptr(py_obj);
	if (PyUnicode_Check(value)) {
		object->ServerName = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	} else if (PyString_Check(value)) {
		object->ServerName = PyString_AS_STRING(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_nbt_browse_domain_announcement_get_OSMajor(PyObject *obj, void *closure)
{
	struct nbt_browse_domain_announcement *object = (struct nbt_browse_domain_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_OSMajor;
	py_OSMajor = PyInt_FromLong(object->OSMajor);
	return py_OSMajor;
}

static int py_nbt_browse_domain_announcement_set_OSMajor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_domain_announcement *object = (struct nbt_browse_domain_announcement *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->OSMajor = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_domain_announcement_get_OSMinor(PyObject *obj, void *closure)
{
	struct nbt_browse_domain_announcement *object = (struct nbt_browse_domain_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_OSMinor;
	py_OSMinor = PyInt_FromLong(object->OSMinor);
	return py_OSMinor;
}

static int py_nbt_browse_domain_announcement_set_OSMinor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_domain_announcement *object = (struct nbt_browse_domain_announcement *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->OSMinor = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_domain_announcement_get_ServerType(PyObject *obj, void *closure)
{
	struct nbt_browse_domain_announcement *object = (struct nbt_browse_domain_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_ServerType;
	py_ServerType = PyInt_FromLong(object->ServerType);
	return py_ServerType;
}

static int py_nbt_browse_domain_announcement_set_ServerType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_domain_announcement *object = (struct nbt_browse_domain_announcement *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->ServerType = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->ServerType = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_nbt_browse_domain_announcement_get_MysteriousField(PyObject *obj, void *closure)
{
	struct nbt_browse_domain_announcement *object = (struct nbt_browse_domain_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_MysteriousField;
	py_MysteriousField = PyInt_FromLong(object->MysteriousField);
	return py_MysteriousField;
}

static int py_nbt_browse_domain_announcement_set_MysteriousField(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_domain_announcement *object = (struct nbt_browse_domain_announcement *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->MysteriousField = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_domain_announcement_get_Comment(PyObject *obj, void *closure)
{
	struct nbt_browse_domain_announcement *object = (struct nbt_browse_domain_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_Comment;
	py_Comment = PyString_FromStringOrNULL(object->Comment);
	return py_Comment;
}

static int py_nbt_browse_domain_announcement_set_Comment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_domain_announcement *object = (struct nbt_browse_domain_announcement *)pytalloc_get_ptr(py_obj);
	object->Comment = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyGetSetDef py_nbt_browse_domain_announcement_getsetters[] = {
	{ discard_const_p(char, "UpdateCount"), py_nbt_browse_domain_announcement_get_UpdateCount, py_nbt_browse_domain_announcement_set_UpdateCount },
	{ discard_const_p(char, "Periodicity"), py_nbt_browse_domain_announcement_get_Periodicity, py_nbt_browse_domain_announcement_set_Periodicity },
	{ discard_const_p(char, "ServerName"), py_nbt_browse_domain_announcement_get_ServerName, py_nbt_browse_domain_announcement_set_ServerName },
	{ discard_const_p(char, "OSMajor"), py_nbt_browse_domain_announcement_get_OSMajor, py_nbt_browse_domain_announcement_set_OSMajor },
	{ discard_const_p(char, "OSMinor"), py_nbt_browse_domain_announcement_get_OSMinor, py_nbt_browse_domain_announcement_set_OSMinor },
	{ discard_const_p(char, "ServerType"), py_nbt_browse_domain_announcement_get_ServerType, py_nbt_browse_domain_announcement_set_ServerType },
	{ discard_const_p(char, "MysteriousField"), py_nbt_browse_domain_announcement_get_MysteriousField, py_nbt_browse_domain_announcement_set_MysteriousField },
	{ discard_const_p(char, "Comment"), py_nbt_browse_domain_announcement_get_Comment, py_nbt_browse_domain_announcement_set_Comment },
	{ NULL }
};

static PyObject *py_nbt_browse_domain_announcement_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_browse_domain_announcement, type);
}


static PyTypeObject nbt_browse_domain_announcement_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.browse_domain_announcement",
	.tp_getset = py_nbt_browse_domain_announcement_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_browse_domain_announcement_new,
};


static PyObject *py_nbt_browse_master_announcement_get_ServerName(PyObject *obj, void *closure)
{
	struct nbt_browse_master_announcement *object = (struct nbt_browse_master_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_ServerName;
	py_ServerName = PyString_FromStringOrNULL(object->ServerName);
	return py_ServerName;
}

static int py_nbt_browse_master_announcement_set_ServerName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_master_announcement *object = (struct nbt_browse_master_announcement *)pytalloc_get_ptr(py_obj);
	object->ServerName = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyGetSetDef py_nbt_browse_master_announcement_getsetters[] = {
	{ discard_const_p(char, "ServerName"), py_nbt_browse_master_announcement_get_ServerName, py_nbt_browse_master_announcement_set_ServerName },
	{ NULL }
};

static PyObject *py_nbt_browse_master_announcement_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_browse_master_announcement, type);
}


static PyTypeObject nbt_browse_master_announcement_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.browse_master_announcement",
	.tp_getset = py_nbt_browse_master_announcement_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_browse_master_announcement_new,
};


static PyObject *py_nbt_browse_reset_state_get_Command(PyObject *obj, void *closure)
{
	struct nbt_browse_reset_state *object = (struct nbt_browse_reset_state *)pytalloc_get_ptr(obj);
	PyObject *py_Command;
	py_Command = PyInt_FromLong(object->Command);
	return py_Command;
}

static int py_nbt_browse_reset_state_set_Command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_reset_state *object = (struct nbt_browse_reset_state *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Command = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_nbt_browse_reset_state_getsetters[] = {
	{ discard_const_p(char, "Command"), py_nbt_browse_reset_state_get_Command, py_nbt_browse_reset_state_set_Command },
	{ NULL }
};

static PyObject *py_nbt_browse_reset_state_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_browse_reset_state, type);
}


static PyTypeObject nbt_browse_reset_state_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.browse_reset_state",
	.tp_getset = py_nbt_browse_reset_state_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_browse_reset_state_new,
};


static PyObject *py_nbt_browse_local_master_announcement_get_UpdateCount(PyObject *obj, void *closure)
{
	struct nbt_browse_local_master_announcement *object = (struct nbt_browse_local_master_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_UpdateCount;
	py_UpdateCount = PyInt_FromLong(object->UpdateCount);
	return py_UpdateCount;
}

static int py_nbt_browse_local_master_announcement_set_UpdateCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_local_master_announcement *object = (struct nbt_browse_local_master_announcement *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->UpdateCount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_local_master_announcement_get_Periodicity(PyObject *obj, void *closure)
{
	struct nbt_browse_local_master_announcement *object = (struct nbt_browse_local_master_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_Periodicity;
	py_Periodicity = PyInt_FromLong(object->Periodicity);
	return py_Periodicity;
}

static int py_nbt_browse_local_master_announcement_set_Periodicity(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_local_master_announcement *object = (struct nbt_browse_local_master_announcement *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Periodicity = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_local_master_announcement_get_ServerName(PyObject *obj, void *closure)
{
	struct nbt_browse_local_master_announcement *object = (struct nbt_browse_local_master_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_ServerName;
	if (object->ServerName == NULL) {
		py_ServerName = Py_None;
		Py_INCREF(py_ServerName);
	} else {
		py_ServerName = PyUnicode_Decode(object->ServerName, strlen(object->ServerName), "utf-8", "ignore");
	}
	return py_ServerName;
}

static int py_nbt_browse_local_master_announcement_set_ServerName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_local_master_announcement *object = (struct nbt_browse_local_master_announcement *)pytalloc_get_ptr(py_obj);
	if (PyUnicode_Check(value)) {
		object->ServerName = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	} else if (PyString_Check(value)) {
		object->ServerName = PyString_AS_STRING(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_nbt_browse_local_master_announcement_get_OSMajor(PyObject *obj, void *closure)
{
	struct nbt_browse_local_master_announcement *object = (struct nbt_browse_local_master_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_OSMajor;
	py_OSMajor = PyInt_FromLong(object->OSMajor);
	return py_OSMajor;
}

static int py_nbt_browse_local_master_announcement_set_OSMajor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_local_master_announcement *object = (struct nbt_browse_local_master_announcement *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->OSMajor = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_local_master_announcement_get_OSMinor(PyObject *obj, void *closure)
{
	struct nbt_browse_local_master_announcement *object = (struct nbt_browse_local_master_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_OSMinor;
	py_OSMinor = PyInt_FromLong(object->OSMinor);
	return py_OSMinor;
}

static int py_nbt_browse_local_master_announcement_set_OSMinor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_local_master_announcement *object = (struct nbt_browse_local_master_announcement *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->OSMinor = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_local_master_announcement_get_ServerType(PyObject *obj, void *closure)
{
	struct nbt_browse_local_master_announcement *object = (struct nbt_browse_local_master_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_ServerType;
	py_ServerType = PyInt_FromLong(object->ServerType);
	return py_ServerType;
}

static int py_nbt_browse_local_master_announcement_set_ServerType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_local_master_announcement *object = (struct nbt_browse_local_master_announcement *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->ServerType = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->ServerType = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_nbt_browse_local_master_announcement_get_BroMajorVer(PyObject *obj, void *closure)
{
	struct nbt_browse_local_master_announcement *object = (struct nbt_browse_local_master_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_BroMajorVer;
	py_BroMajorVer = PyInt_FromLong(object->BroMajorVer);
	return py_BroMajorVer;
}

static int py_nbt_browse_local_master_announcement_set_BroMajorVer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_local_master_announcement *object = (struct nbt_browse_local_master_announcement *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->BroMajorVer = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_local_master_announcement_get_BroMinorVer(PyObject *obj, void *closure)
{
	struct nbt_browse_local_master_announcement *object = (struct nbt_browse_local_master_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_BroMinorVer;
	py_BroMinorVer = PyInt_FromLong(object->BroMinorVer);
	return py_BroMinorVer;
}

static int py_nbt_browse_local_master_announcement_set_BroMinorVer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_local_master_announcement *object = (struct nbt_browse_local_master_announcement *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->BroMinorVer = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_local_master_announcement_get_Signature(PyObject *obj, void *closure)
{
	struct nbt_browse_local_master_announcement *object = (struct nbt_browse_local_master_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_Signature;
	py_Signature = PyInt_FromLong(object->Signature);
	return py_Signature;
}

static int py_nbt_browse_local_master_announcement_set_Signature(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_local_master_announcement *object = (struct nbt_browse_local_master_announcement *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Signature = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_nbt_browse_local_master_announcement_get_Comment(PyObject *obj, void *closure)
{
	struct nbt_browse_local_master_announcement *object = (struct nbt_browse_local_master_announcement *)pytalloc_get_ptr(obj);
	PyObject *py_Comment;
	py_Comment = PyString_FromStringOrNULL(object->Comment);
	return py_Comment;
}

static int py_nbt_browse_local_master_announcement_set_Comment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_local_master_announcement *object = (struct nbt_browse_local_master_announcement *)pytalloc_get_ptr(py_obj);
	object->Comment = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyGetSetDef py_nbt_browse_local_master_announcement_getsetters[] = {
	{ discard_const_p(char, "UpdateCount"), py_nbt_browse_local_master_announcement_get_UpdateCount, py_nbt_browse_local_master_announcement_set_UpdateCount },
	{ discard_const_p(char, "Periodicity"), py_nbt_browse_local_master_announcement_get_Periodicity, py_nbt_browse_local_master_announcement_set_Periodicity },
	{ discard_const_p(char, "ServerName"), py_nbt_browse_local_master_announcement_get_ServerName, py_nbt_browse_local_master_announcement_set_ServerName },
	{ discard_const_p(char, "OSMajor"), py_nbt_browse_local_master_announcement_get_OSMajor, py_nbt_browse_local_master_announcement_set_OSMajor },
	{ discard_const_p(char, "OSMinor"), py_nbt_browse_local_master_announcement_get_OSMinor, py_nbt_browse_local_master_announcement_set_OSMinor },
	{ discard_const_p(char, "ServerType"), py_nbt_browse_local_master_announcement_get_ServerType, py_nbt_browse_local_master_announcement_set_ServerType },
	{ discard_const_p(char, "BroMajorVer"), py_nbt_browse_local_master_announcement_get_BroMajorVer, py_nbt_browse_local_master_announcement_set_BroMajorVer },
	{ discard_const_p(char, "BroMinorVer"), py_nbt_browse_local_master_announcement_get_BroMinorVer, py_nbt_browse_local_master_announcement_set_BroMinorVer },
	{ discard_const_p(char, "Signature"), py_nbt_browse_local_master_announcement_get_Signature, py_nbt_browse_local_master_announcement_set_Signature },
	{ discard_const_p(char, "Comment"), py_nbt_browse_local_master_announcement_get_Comment, py_nbt_browse_local_master_announcement_set_Comment },
	{ NULL }
};

static PyObject *py_nbt_browse_local_master_announcement_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_browse_local_master_announcement, type);
}


static PyTypeObject nbt_browse_local_master_announcement_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.browse_local_master_announcement",
	.tp_getset = py_nbt_browse_local_master_announcement_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_browse_local_master_announcement_new,
};

PyObject *py_import_nbt_browse_payload(TALLOC_CTX *mem_ctx, int level, union nbt_browse_payload *in)
{
	PyObject *ret;

	switch (level) {
		case HostAnnouncement:
			ret = pytalloc_reference_ex(&nbt_browse_host_announcement_Type, mem_ctx, &in->host_annoucement);
			return ret;

		case AnnouncementRequest:
			ret = pytalloc_reference_ex(&nbt_browse_announcement_request_Type, mem_ctx, &in->announcement_request);
			return ret;

		case Election:
			ret = pytalloc_reference_ex(&nbt_browse_election_request_Type, mem_ctx, &in->election_request);
			return ret;

		case GetBackupListReq:
			ret = pytalloc_reference_ex(&nbt_browse_backup_list_request_Type, mem_ctx, &in->backup_list_request);
			return ret;

		case GetBackupListResp:
			ret = pytalloc_reference_ex(&nbt_browse_backup_list_response_Type, mem_ctx, &in->backup_list_response);
			return ret;

		case BecomeBackup:
			ret = pytalloc_reference_ex(&nbt_browse_become_backup_Type, mem_ctx, &in->become_backup);
			return ret;

		case DomainAnnouncement:
			ret = pytalloc_reference_ex(&nbt_browse_domain_announcement_Type, mem_ctx, &in->domain_announcement);
			return ret;

		case MasterAnnouncement:
			ret = pytalloc_reference_ex(&nbt_browse_master_announcement_Type, mem_ctx, &in->master_announcement);
			return ret;

		case ResetBrowserState:
			ret = pytalloc_reference_ex(&nbt_browse_reset_state_Type, mem_ctx, &in->reset_browser_state);
			return ret;

		case LocalMasterAnnouncement:
			ret = pytalloc_reference_ex(&nbt_browse_local_master_announcement_Type, mem_ctx, &in->local_master_announcement);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union nbt_browse_payload *py_export_nbt_browse_payload(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union nbt_browse_payload *ret = talloc_zero(mem_ctx, union nbt_browse_payload);
	switch (level) {
		case HostAnnouncement:
			PY_CHECK_TYPE(&nbt_browse_host_announcement_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->host_annoucement = *(struct nbt_browse_host_announcement *)pytalloc_get_ptr(in);
			break;

		case AnnouncementRequest:
			PY_CHECK_TYPE(&nbt_browse_announcement_request_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->announcement_request = *(struct nbt_browse_announcement_request *)pytalloc_get_ptr(in);
			break;

		case Election:
			PY_CHECK_TYPE(&nbt_browse_election_request_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->election_request = *(struct nbt_browse_election_request *)pytalloc_get_ptr(in);
			break;

		case GetBackupListReq:
			PY_CHECK_TYPE(&nbt_browse_backup_list_request_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->backup_list_request = *(struct nbt_browse_backup_list_request *)pytalloc_get_ptr(in);
			break;

		case GetBackupListResp:
			PY_CHECK_TYPE(&nbt_browse_backup_list_response_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->backup_list_response = *(struct nbt_browse_backup_list_response *)pytalloc_get_ptr(in);
			break;

		case BecomeBackup:
			PY_CHECK_TYPE(&nbt_browse_become_backup_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->become_backup = *(struct nbt_browse_become_backup *)pytalloc_get_ptr(in);
			break;

		case DomainAnnouncement:
			PY_CHECK_TYPE(&nbt_browse_domain_announcement_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->domain_announcement = *(struct nbt_browse_domain_announcement *)pytalloc_get_ptr(in);
			break;

		case MasterAnnouncement:
			PY_CHECK_TYPE(&nbt_browse_master_announcement_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->master_announcement = *(struct nbt_browse_master_announcement *)pytalloc_get_ptr(in);
			break;

		case ResetBrowserState:
			PY_CHECK_TYPE(&nbt_browse_reset_state_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->reset_browser_state = *(struct nbt_browse_reset_state *)pytalloc_get_ptr(in);
			break;

		case LocalMasterAnnouncement:
			PY_CHECK_TYPE(&nbt_browse_local_master_announcement_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->local_master_announcement = *(struct nbt_browse_local_master_announcement *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_nbt_browse_packet_get_opcode(PyObject *obj, void *closure)
{
	struct nbt_browse_packet *object = (struct nbt_browse_packet *)pytalloc_get_ptr(obj);
	PyObject *py_opcode;
	py_opcode = PyInt_FromLong(object->opcode);
	return py_opcode;
}

static int py_nbt_browse_packet_set_opcode(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_packet *object = (struct nbt_browse_packet *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->opcode = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->opcode = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_nbt_browse_packet_get_payload(PyObject *obj, void *closure)
{
	struct nbt_browse_packet *object = (struct nbt_browse_packet *)pytalloc_get_ptr(obj);
	PyObject *py_payload;
	py_payload = py_import_nbt_browse_payload(pytalloc_get_mem_ctx(obj), object->opcode, &object->payload);
	if (py_payload == NULL) {
		return NULL;
	}
	return py_payload;
}

static int py_nbt_browse_packet_set_payload(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_packet *object = (struct nbt_browse_packet *)pytalloc_get_ptr(py_obj);
	{
		union nbt_browse_payload *payload_switch_0;
		payload_switch_0 = py_export_nbt_browse_payload(pytalloc_get_mem_ctx(py_obj), object->opcode, value);
		if (payload_switch_0 == NULL) {
			return -1;
		}
		object->payload = *payload_switch_0;
	}
	return 0;
}

static PyGetSetDef py_nbt_browse_packet_getsetters[] = {
	{ discard_const_p(char, "opcode"), py_nbt_browse_packet_get_opcode, py_nbt_browse_packet_set_opcode },
	{ discard_const_p(char, "payload"), py_nbt_browse_packet_get_payload, py_nbt_browse_packet_set_payload },
	{ NULL }
};

static PyObject *py_nbt_browse_packet_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_browse_packet, type);
}

static PyObject *py_nbt_browse_packet_ndr_pack(PyObject *py_obj)
{
	struct nbt_browse_packet *object = (struct nbt_browse_packet *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_nbt_browse_packet);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_nbt_browse_packet_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct nbt_browse_packet *object = (struct nbt_browse_packet *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_browse_packet);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_browse_packet);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_nbt_browse_packet_ndr_print(PyObject *py_obj)
{
	struct nbt_browse_packet *object = (struct nbt_browse_packet *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_nbt_browse_packet, "nbt_browse_packet", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_nbt_browse_packet_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_nbt_browse_packet_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_nbt_browse_packet_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_nbt_browse_packet_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject nbt_browse_packet_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.browse_packet",
	.tp_getset = py_nbt_browse_packet_getsetters,
	.tp_methods = py_nbt_browse_packet_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_nbt_browse_packet_new,
};


static bool pack_py_decode_nbt_netlogon_packet_args_in(PyObject *args, PyObject *kwargs, struct decode_nbt_netlogon_packet *r)
{
	PyObject *py_packet;
	const char *kwnames[] = {
		"packet", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:decode_nbt_netlogon_packet", discard_const_p(char *, kwnames), &py_packet)) {
		return false;
	}

	PY_CHECK_TYPE(&nbt_netlogon_packet_Type, py_packet, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_packet)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.packet = *(struct nbt_netlogon_packet *)pytalloc_get_ptr(py_packet);
	return true;
}

static PyObject *unpack_py_decode_nbt_netlogon_packet_args_out(struct decode_nbt_netlogon_packet *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	return result;
}

const struct PyNdrRpcMethodDef py_ndr_nbt_methods[] = {
	{ "decode_nbt_netlogon_packet", "S.decode_nbt_netlogon_packet(packet) -> None", (py_dcerpc_call_fn)dcerpc_decode_nbt_netlogon_packet_r, (py_data_pack_fn)pack_py_decode_nbt_netlogon_packet_args_in, (py_data_unpack_fn)unpack_py_decode_nbt_netlogon_packet_args_out, 0, &ndr_table_nbt },
	{ NULL }
};

static PyObject *interface_nbt_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_nbt);
}

#define PY_DOC_NBT "NBT messages"
static PyTypeObject nbt_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "nbt.nbt",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "nbt(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_NBT,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_nbt_new,
};

static PyMethodDef nbt_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initnbt(void)
{
	PyObject *m;
	PyObject *dep_samba_dcerpc_base;
	PyObject *dep_talloc;
	PyObject *dep_samba_dcerpc_misc;
	PyObject *dep_samba_dcerpc_security;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		return;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		return;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		return;

	dep_samba_dcerpc_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_samba_dcerpc_security == NULL)
		return;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "GUID");
	if (GUID_Type == NULL)
		return;

	dom_sid_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "dom_sid");
	if (dom_sid_Type == NULL)
		return;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		return;

	Object_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "Object");
	if (Object_Type == NULL)
		return;

	nbt_name_Type.tp_base = Object_Type;

	nbt_name_question_Type.tp_base = Object_Type;

	nbt_rdata_address_Type.tp_base = Object_Type;

	nbt_rdata_netbios_Type.tp_base = Object_Type;

	nbt_statistics_Type.tp_base = Object_Type;

	nbt_status_name_Type.tp_base = Object_Type;

	nbt_rdata_status_Type.tp_base = Object_Type;

	nbt_rdata_data_Type.tp_base = Object_Type;

	nbt_res_rec_Type.tp_base = Object_Type;

	nbt_name_packet_Type.tp_base = Object_Type;

	smb_trans_body_Type.tp_base = Object_Type;

	dgram_smb_packet_Type.tp_base = Object_Type;

	dgram_message_Type.tp_base = Object_Type;

	nbt_dgram_packet_Type.tp_base = Object_Type;

	nbt_sockaddr_Type.tp_base = Object_Type;

	NETLOGON_SAM_LOGON_REQUEST_Type.tp_base = Object_Type;

	NETLOGON_LOGON_REQUEST_Type.tp_base = Object_Type;

	NETLOGON_SAM_LOGON_RESPONSE_NT40_Type.tp_base = Object_Type;

	NETLOGON_SAM_LOGON_RESPONSE_Type.tp_base = Object_Type;

	NETLOGON_SAM_LOGON_RESPONSE_EX_Type.tp_base = Object_Type;

	nbt_netlogon_query_for_pdc_Type.tp_base = Object_Type;

	nbt_netlogon_response_from_pdc_Type.tp_base = Object_Type;

	nbt_netlogon_response2_Type.tp_base = Object_Type;

	nbt_db_change_info_Type.tp_base = Object_Type;

	NETLOGON_DB_CHANGE_Type.tp_base = Object_Type;

	nbt_netlogon_packet_Type.tp_base = Object_Type;

	nbt_browse_host_announcement_Type.tp_base = Object_Type;

	nbt_browse_announcement_request_Type.tp_base = Object_Type;

	nbt_browse_election_request_Type.tp_base = Object_Type;

	nbt_browse_backup_list_request_Type.tp_base = Object_Type;

	nbt_browse_backup_list_response_Type.tp_base = Object_Type;

	nbt_browse_become_backup_Type.tp_base = Object_Type;

	nbt_browse_domain_announcement_Type.tp_base = Object_Type;

	nbt_browse_master_announcement_Type.tp_base = Object_Type;

	nbt_browse_reset_state_Type.tp_base = Object_Type;

	nbt_browse_local_master_announcement_Type.tp_base = Object_Type;

	nbt_browse_packet_Type.tp_base = Object_Type;

	nbt_InterfaceType.tp_base = ClientConnection_Type;

	if (PyType_Ready(&nbt_name_Type) < 0)
		return;
	if (PyType_Ready(&nbt_name_question_Type) < 0)
		return;
	if (PyType_Ready(&nbt_rdata_address_Type) < 0)
		return;
	if (PyType_Ready(&nbt_rdata_netbios_Type) < 0)
		return;
	if (PyType_Ready(&nbt_statistics_Type) < 0)
		return;
	if (PyType_Ready(&nbt_status_name_Type) < 0)
		return;
	if (PyType_Ready(&nbt_rdata_status_Type) < 0)
		return;
	if (PyType_Ready(&nbt_rdata_data_Type) < 0)
		return;
	if (PyType_Ready(&nbt_res_rec_Type) < 0)
		return;
	if (PyType_Ready(&nbt_name_packet_Type) < 0)
		return;
	if (PyType_Ready(&smb_trans_body_Type) < 0)
		return;
	if (PyType_Ready(&dgram_smb_packet_Type) < 0)
		return;
	if (PyType_Ready(&dgram_message_Type) < 0)
		return;
	if (PyType_Ready(&nbt_dgram_packet_Type) < 0)
		return;
	if (PyType_Ready(&nbt_sockaddr_Type) < 0)
		return;
	if (PyType_Ready(&NETLOGON_SAM_LOGON_REQUEST_Type) < 0)
		return;
	if (PyType_Ready(&NETLOGON_LOGON_REQUEST_Type) < 0)
		return;
	if (PyType_Ready(&NETLOGON_SAM_LOGON_RESPONSE_NT40_Type) < 0)
		return;
	if (PyType_Ready(&NETLOGON_SAM_LOGON_RESPONSE_Type) < 0)
		return;
	if (PyType_Ready(&NETLOGON_SAM_LOGON_RESPONSE_EX_Type) < 0)
		return;
	if (PyType_Ready(&nbt_netlogon_query_for_pdc_Type) < 0)
		return;
	if (PyType_Ready(&nbt_netlogon_response_from_pdc_Type) < 0)
		return;
	if (PyType_Ready(&nbt_netlogon_response2_Type) < 0)
		return;
	if (PyType_Ready(&nbt_db_change_info_Type) < 0)
		return;
	if (PyType_Ready(&NETLOGON_DB_CHANGE_Type) < 0)
		return;
	if (PyType_Ready(&nbt_netlogon_packet_Type) < 0)
		return;
	if (PyType_Ready(&nbt_browse_host_announcement_Type) < 0)
		return;
	if (PyType_Ready(&nbt_browse_announcement_request_Type) < 0)
		return;
	if (PyType_Ready(&nbt_browse_election_request_Type) < 0)
		return;
	if (PyType_Ready(&nbt_browse_backup_list_request_Type) < 0)
		return;
	if (PyType_Ready(&nbt_browse_backup_list_response_Type) < 0)
		return;
	if (PyType_Ready(&nbt_browse_become_backup_Type) < 0)
		return;
	if (PyType_Ready(&nbt_browse_domain_announcement_Type) < 0)
		return;
	if (PyType_Ready(&nbt_browse_master_announcement_Type) < 0)
		return;
	if (PyType_Ready(&nbt_browse_reset_state_Type) < 0)
		return;
	if (PyType_Ready(&nbt_browse_local_master_announcement_Type) < 0)
		return;
	if (PyType_Ready(&nbt_browse_packet_Type) < 0)
		return;
	if (PyType_Ready(&nbt_InterfaceType) < 0)
		return;
	if (!PyInterface_AddNdrRpcMethods(&nbt_InterfaceType, py_ndr_nbt_methods))
		return;

#ifdef PY_NAME_PATCH
	PY_NAME_PATCH(&nbt_name_Type);
#endif
#ifdef PY_NAME_QUESTION_PATCH
	PY_NAME_QUESTION_PATCH(&nbt_name_question_Type);
#endif
#ifdef PY_RDATA_ADDRESS_PATCH
	PY_RDATA_ADDRESS_PATCH(&nbt_rdata_address_Type);
#endif
#ifdef PY_RDATA_NETBIOS_PATCH
	PY_RDATA_NETBIOS_PATCH(&nbt_rdata_netbios_Type);
#endif
#ifdef PY_STATISTICS_PATCH
	PY_STATISTICS_PATCH(&nbt_statistics_Type);
#endif
#ifdef PY_STATUS_NAME_PATCH
	PY_STATUS_NAME_PATCH(&nbt_status_name_Type);
#endif
#ifdef PY_RDATA_STATUS_PATCH
	PY_RDATA_STATUS_PATCH(&nbt_rdata_status_Type);
#endif
#ifdef PY_RDATA_DATA_PATCH
	PY_RDATA_DATA_PATCH(&nbt_rdata_data_Type);
#endif
#ifdef PY_RES_REC_PATCH
	PY_RES_REC_PATCH(&nbt_res_rec_Type);
#endif
#ifdef PY_NAME_PACKET_PATCH
	PY_NAME_PACKET_PATCH(&nbt_name_packet_Type);
#endif
#ifdef PY_SMB_TRANS_BODY_PATCH
	PY_SMB_TRANS_BODY_PATCH(&smb_trans_body_Type);
#endif
#ifdef PY_DGRAM_SMB_PACKET_PATCH
	PY_DGRAM_SMB_PACKET_PATCH(&dgram_smb_packet_Type);
#endif
#ifdef PY_DGRAM_MESSAGE_PATCH
	PY_DGRAM_MESSAGE_PATCH(&dgram_message_Type);
#endif
#ifdef PY_DGRAM_PACKET_PATCH
	PY_DGRAM_PACKET_PATCH(&nbt_dgram_packet_Type);
#endif
#ifdef PY_SOCKADDR_PATCH
	PY_SOCKADDR_PATCH(&nbt_sockaddr_Type);
#endif
#ifdef PY_NETLOGON_SAM_LOGON_REQUEST_PATCH
	PY_NETLOGON_SAM_LOGON_REQUEST_PATCH(&NETLOGON_SAM_LOGON_REQUEST_Type);
#endif
#ifdef PY_NETLOGON_LOGON_REQUEST_PATCH
	PY_NETLOGON_LOGON_REQUEST_PATCH(&NETLOGON_LOGON_REQUEST_Type);
#endif
#ifdef PY_NETLOGON_SAM_LOGON_RESPONSE_NT40_PATCH
	PY_NETLOGON_SAM_LOGON_RESPONSE_NT40_PATCH(&NETLOGON_SAM_LOGON_RESPONSE_NT40_Type);
#endif
#ifdef PY_NETLOGON_SAM_LOGON_RESPONSE_PATCH
	PY_NETLOGON_SAM_LOGON_RESPONSE_PATCH(&NETLOGON_SAM_LOGON_RESPONSE_Type);
#endif
#ifdef PY_NETLOGON_SAM_LOGON_RESPONSE_EX_PATCH
	PY_NETLOGON_SAM_LOGON_RESPONSE_EX_PATCH(&NETLOGON_SAM_LOGON_RESPONSE_EX_Type);
#endif
#ifdef PY_NETLOGON_QUERY_FOR_PDC_PATCH
	PY_NETLOGON_QUERY_FOR_PDC_PATCH(&nbt_netlogon_query_for_pdc_Type);
#endif
#ifdef PY_NETLOGON_RESPONSE_FROM_PDC_PATCH
	PY_NETLOGON_RESPONSE_FROM_PDC_PATCH(&nbt_netlogon_response_from_pdc_Type);
#endif
#ifdef PY_NETLOGON_RESPONSE2_PATCH
	PY_NETLOGON_RESPONSE2_PATCH(&nbt_netlogon_response2_Type);
#endif
#ifdef PY_DB_CHANGE_INFO_PATCH
	PY_DB_CHANGE_INFO_PATCH(&nbt_db_change_info_Type);
#endif
#ifdef PY_NETLOGON_DB_CHANGE_PATCH
	PY_NETLOGON_DB_CHANGE_PATCH(&NETLOGON_DB_CHANGE_Type);
#endif
#ifdef PY_NETLOGON_PACKET_PATCH
	PY_NETLOGON_PACKET_PATCH(&nbt_netlogon_packet_Type);
#endif
#ifdef PY_BROWSE_HOST_ANNOUNCEMENT_PATCH
	PY_BROWSE_HOST_ANNOUNCEMENT_PATCH(&nbt_browse_host_announcement_Type);
#endif
#ifdef PY_BROWSE_ANNOUNCEMENT_REQUEST_PATCH
	PY_BROWSE_ANNOUNCEMENT_REQUEST_PATCH(&nbt_browse_announcement_request_Type);
#endif
#ifdef PY_BROWSE_ELECTION_REQUEST_PATCH
	PY_BROWSE_ELECTION_REQUEST_PATCH(&nbt_browse_election_request_Type);
#endif
#ifdef PY_BROWSE_BACKUP_LIST_REQUEST_PATCH
	PY_BROWSE_BACKUP_LIST_REQUEST_PATCH(&nbt_browse_backup_list_request_Type);
#endif
#ifdef PY_BROWSE_BACKUP_LIST_RESPONSE_PATCH
	PY_BROWSE_BACKUP_LIST_RESPONSE_PATCH(&nbt_browse_backup_list_response_Type);
#endif
#ifdef PY_BROWSE_BECOME_BACKUP_PATCH
	PY_BROWSE_BECOME_BACKUP_PATCH(&nbt_browse_become_backup_Type);
#endif
#ifdef PY_BROWSE_DOMAIN_ANNOUNCEMENT_PATCH
	PY_BROWSE_DOMAIN_ANNOUNCEMENT_PATCH(&nbt_browse_domain_announcement_Type);
#endif
#ifdef PY_BROWSE_MASTER_ANNOUNCEMENT_PATCH
	PY_BROWSE_MASTER_ANNOUNCEMENT_PATCH(&nbt_browse_master_announcement_Type);
#endif
#ifdef PY_BROWSE_RESET_STATE_PATCH
	PY_BROWSE_RESET_STATE_PATCH(&nbt_browse_reset_state_Type);
#endif
#ifdef PY_BROWSE_LOCAL_MASTER_ANNOUNCEMENT_PATCH
	PY_BROWSE_LOCAL_MASTER_ANNOUNCEMENT_PATCH(&nbt_browse_local_master_announcement_Type);
#endif
#ifdef PY_BROWSE_PACKET_PATCH
	PY_BROWSE_PACKET_PATCH(&nbt_browse_packet_Type);
#endif
#ifdef PY_NBT_PATCH
	PY_NBT_PATCH(&nbt_InterfaceType);
#endif

	m = Py_InitModule3("nbt", nbt_methods, "nbt DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "NBT_RCODE_ACT", PyInt_FromLong(NBT_RCODE_ACT));
	PyModule_AddObject(m, "DGRAM_QUERY_POSITIVE", PyInt_FromLong(DGRAM_QUERY_POSITIVE));
	PyModule_AddObject(m, "NBT_DGRAM_SERVICE_PORT", PyInt_FromLong(138));
	PyModule_AddObject(m, "DGRAM_BCAST", PyInt_FromLong(DGRAM_BCAST));
	PyModule_AddObject(m, "NBT_RCODE_CFT", PyInt_FromLong(NBT_RCODE_CFT));
	PyModule_AddObject(m, "NBT_OPCODE_REFRESH", PyInt_FromLong(NBT_OPCODE_REFRESH));
	PyModule_AddObject(m, "NBT_RCODE_SVR", PyInt_FromLong(NBT_RCODE_SVR));
	PyModule_AddObject(m, "NBT_OPCODE", PyInt_FromLong(NBT_OPCODE));
	PyModule_AddObject(m, "DGRAM_ERROR_INVALID_DEST", PyInt_FromLong(DGRAM_ERROR_INVALID_DEST));
	PyModule_AddObject(m, "DGRAM_DIRECT_GROUP", PyInt_FromLong(DGRAM_DIRECT_GROUP));
	PyModule_AddObject(m, "NBT_NODE_M", PyInt_FromLong(NBT_NODE_M));
	PyModule_AddObject(m, "DGRAM_NODE_B", PyInt_FromLong(DGRAM_NODE_B));
	PyModule_AddObject(m, "DGRAM_QUERY", PyInt_FromLong(DGRAM_QUERY));
	PyModule_AddObject(m, "NETLOGON_NT_VERSION_LOCAL", PyInt_FromLong(NETLOGON_NT_VERSION_LOCAL));
	PyModule_AddObject(m, "NBT_NAME_BROWSER", PyInt_FromLong(NBT_NAME_BROWSER));
	PyModule_AddObject(m, "NBT_SERVER_NDNC", PyInt_FromLong(NBT_SERVER_NDNC));
	PyModule_AddObject(m, "NBT_SERVER_LDAP", PyInt_FromLong(NBT_SERVER_LDAP));
	PyModule_AddObject(m, "NBT_SERVER_CLOSEST", PyInt_FromLong(NBT_SERVER_CLOSEST));
	PyModule_AddObject(m, "NETLOGON_ANNOUNCE_UAS", PyInt_FromLong(NETLOGON_ANNOUNCE_UAS));
	PyModule_AddObject(m, "NBT_NM_ACTIVE", PyInt_FromLong(NBT_NM_ACTIVE));
	PyModule_AddObject(m, "NBT_FLAG_REPLY", PyInt_FromLong(NBT_FLAG_REPLY));
	PyModule_AddObject(m, "DGRAM_NODE_M", PyInt_FromLong(DGRAM_NODE_M));
	PyModule_AddObject(m, "NBT_QTYPE_STATUS", PyInt_FromLong(NBT_QTYPE_STATUS));
	PyModule_AddObject(m, "BecomeBackup", PyInt_FromLong(BecomeBackup));
	PyModule_AddObject(m, "LOGON_SAM_LOGON_REQUEST", PyInt_FromLong(LOGON_SAM_LOGON_REQUEST));
	PyModule_AddObject(m, "LOGON_SAM_LOGON_RESPONSE_EX", PyInt_FromLong(LOGON_SAM_LOGON_RESPONSE_EX));
	PyModule_AddObject(m, "DGRAM_ERROR_INVALID_SOURCE", PyInt_FromLong(DGRAM_ERROR_INVALID_SOURCE));
	PyModule_AddObject(m, "NBT_NAME_SERVICE_PORT", PyInt_FromLong(137));
	PyModule_AddObject(m, "DGRAM_ERROR", PyInt_FromLong(DGRAM_ERROR));
	PyModule_AddObject(m, "NBT_NAME_LOGON", PyInt_FromLong(NBT_NAME_LOGON));
	PyModule_AddObject(m, "NBT_OPCODE_WACK", PyInt_FromLong(NBT_OPCODE_WACK));
	PyModule_AddObject(m, "NBT_NM_DEREGISTER", PyInt_FromLong(NBT_NM_DEREGISTER));
	PyModule_AddObject(m, "NBT_FLAG_RECURSION_DESIRED", PyInt_FromLong(NBT_FLAG_RECURSION_DESIRED));
	PyModule_AddObject(m, "NETLOGON_NT_VERSION_AVOID_NT4EMUL", PyInt_FromLong(NETLOGON_NT_VERSION_AVOID_NT4EMUL));
	PyModule_AddObject(m, "NETLOGON_NT_VERSION_IP", PyInt_FromLong(NETLOGON_NT_VERSION_IP));
	PyModule_AddObject(m, "NETLOGON_NT_VERSION_5", PyInt_FromLong(NETLOGON_NT_VERSION_5));
	PyModule_AddObject(m, "NBT_OPCODE_MULTI_HOME_REG", PyInt_FromLong(NBT_OPCODE_MULTI_HOME_REG));
	PyModule_AddObject(m, "NBT_SERVER_GC", PyInt_FromLong(NBT_SERVER_GC));
	PyModule_AddObject(m, "LOGON_SAM_LOGON_RESPONSE", PyInt_FromLong(LOGON_SAM_LOGON_RESPONSE));
	PyModule_AddObject(m, "NBT_SERVER_FULL_SECRET_DOMAIN_6", PyInt_FromLong(NBT_SERVER_FULL_SECRET_DOMAIN_6));
	PyModule_AddObject(m, "NBT_NM_OWNER_TYPE", PyInt_FromLong(NBT_NM_OWNER_TYPE));
	PyModule_AddObject(m, "NBT_FLAG_RECURSION_AVAIL", PyInt_FromLong(NBT_FLAG_RECURSION_AVAIL));
	PyModule_AddObject(m, "GetBackupListResp", PyInt_FromLong(GetBackupListResp));
	PyModule_AddObject(m, "NBT_NAME_USER", PyInt_FromLong(NBT_NAME_USER));
	PyModule_AddObject(m, "NBT_SERVER_PDC", PyInt_FromLong(NBT_SERVER_PDC));
	PyModule_AddObject(m, "NBT_RCODE_IMP", PyInt_FromLong(NBT_RCODE_IMP));
	PyModule_AddObject(m, "NBT_SERVER_ADS_WEB_SERVICE", PyInt_FromLong(NBT_SERVER_ADS_WEB_SERVICE));
	PyModule_AddObject(m, "DGRAM_FLAG_FIRST", PyInt_FromLong(DGRAM_FLAG_FIRST));
	PyModule_AddObject(m, "DGRAM_NODE_NBDD", PyInt_FromLong(DGRAM_NODE_NBDD));
	PyModule_AddObject(m, "NBT_NODE_B", PyInt_FromLong(NBT_NODE_B));
	PyModule_AddObject(m, "NBT_FLAG_AUTHORITATIVE", PyInt_FromLong(NBT_FLAG_AUTHORITATIVE));
	PyModule_AddObject(m, "NBT_RCODE_RFS", PyInt_FromLong(NBT_RCODE_RFS));
	PyModule_AddObject(m, "NETLOGON_NT_VERSION_PDC", PyInt_FromLong(NETLOGON_NT_VERSION_PDC));
	PyModule_AddObject(m, "NBT_MAILSLOT_BROWSE", PyString_FromString("\\MAILSLOT\\BROWSE"));
	PyModule_AddObject(m, "NBT_SERVER_FOREST_ROOT", PyInt_FromLong(NBT_SERVER_FOREST_ROOT));
	PyModule_AddObject(m, "NBT_OPCODE_REFRESH2", PyInt_FromLong(NBT_OPCODE_REFRESH2));
	PyModule_AddObject(m, "DGRAM_FLAG_NODE_TYPE", PyInt_FromLong(DGRAM_FLAG_NODE_TYPE));
	PyModule_AddObject(m, "NBT_QTYPE_ADDRESS", PyInt_FromLong(NBT_QTYPE_ADDRESS));
	PyModule_AddObject(m, "DGRAM_DIRECT_UNIQUE", PyInt_FromLong(DGRAM_DIRECT_UNIQUE));
	PyModule_AddObject(m, "LOGON_RESPONSE2", PyInt_FromLong(LOGON_RESPONSE2));
	PyModule_AddObject(m, "DGRAM_ERROR_NAME_NOT_PRESENT", PyInt_FromLong(DGRAM_ERROR_NAME_NOT_PRESENT));
	PyModule_AddObject(m, "NBT_NODE_P", PyInt_FromLong(NBT_NODE_P));
	PyModule_AddObject(m, "NETLOGON_NT_VERSION_GC", PyInt_FromLong(NETLOGON_NT_VERSION_GC));
	PyModule_AddObject(m, "NBT_FLAG_TRUNCATION", PyInt_FromLong(NBT_FLAG_TRUNCATION));
	PyModule_AddObject(m, "NBT_OPCODE_REGISTER", PyInt_FromLong(NBT_OPCODE_REGISTER));
	PyModule_AddObject(m, "ResetBrowserState", PyInt_FromLong(ResetBrowserState));
	PyModule_AddObject(m, "NBT_SERVER_HAS_DNS_NAME", PyInt_FromLong(NBT_SERVER_HAS_DNS_NAME));
	PyModule_AddObject(m, "AnnouncementRequest", PyInt_FromLong(AnnouncementRequest));
	PyModule_AddObject(m, "NBT_OPCODE_QUERY", PyInt_FromLong(NBT_OPCODE_QUERY));
	PyModule_AddObject(m, "NBT_NAME_MASTER", PyInt_FromLong(NBT_NAME_MASTER));
	PyModule_AddObject(m, "NETLOGON_RESPONSE_FROM_PDC", PyInt_FromLong(NETLOGON_RESPONSE_FROM_PDC));
	PyModule_AddObject(m, "NBT_FLAG_BROADCAST", PyInt_FromLong(NBT_FLAG_BROADCAST));
	PyModule_AddObject(m, "MasterAnnouncement", PyInt_FromLong(MasterAnnouncement));
	PyModule_AddObject(m, "NBT_NM_GROUP", PyInt_FromLong(NBT_NM_GROUP));
	PyModule_AddObject(m, "NBT_QTYPE_NETBIOS", PyInt_FromLong(NBT_QTYPE_NETBIOS));
	PyModule_AddObject(m, "NBT_NAME_SERVER", PyInt_FromLong(NBT_NAME_SERVER));
	PyModule_AddObject(m, "NBT_SERVER_DS", PyInt_FromLong(NBT_SERVER_DS));
	PyModule_AddObject(m, "NBT_MAILSLOT_NETLOGON", PyString_FromString("\\MAILSLOT\\NET\\NETLOGON"));
	PyModule_AddObject(m, "NBT_NODE_H", PyInt_FromLong(NBT_NODE_H));
	PyModule_AddObject(m, "NETLOGON_NT_VERSION_WITH_CLOSEST_SITE", PyInt_FromLong(NETLOGON_NT_VERSION_WITH_CLOSEST_SITE));
	PyModule_AddObject(m, "NBT_NM_CONFLICT", PyInt_FromLong(NBT_NM_CONFLICT));
	PyModule_AddObject(m, "NBT_RCODE_FMT", PyInt_FromLong(NBT_RCODE_FMT));
	PyModule_AddObject(m, "NETLOGON_NT_VERSION_1", PyInt_FromLong(NETLOGON_NT_VERSION_1));
	PyModule_AddObject(m, "DGRAM_NODE_P", PyInt_FromLong(DGRAM_NODE_P));
	PyModule_AddObject(m, "NETLOGON_NT_VERSION_5EX", PyInt_FromLong(NETLOGON_NT_VERSION_5EX));
	PyModule_AddObject(m, "DGRAM_QUERY_NEGATIVE", PyInt_FromLong(DGRAM_QUERY_NEGATIVE));
	PyModule_AddObject(m, "NBT_SERVER_KDC", PyInt_FromLong(NBT_SERVER_KDC));
	PyModule_AddObject(m, "NBT_QTYPE_NAMESERVICE", PyInt_FromLong(NBT_QTYPE_NAMESERVICE));
	PyModule_AddObject(m, "NBT_NAME_CLIENT", PyInt_FromLong(NBT_NAME_CLIENT));
	PyModule_AddObject(m, "LOGON_SAM_LOGON_USER_UNKNOWN_EX", PyInt_FromLong(LOGON_SAM_LOGON_USER_UNKNOWN_EX));
	PyModule_AddObject(m, "NBT_MAILSLOT_GETDC", PyString_FromString("\\MAILSLOT\\NET\\GETDC"));
	PyModule_AddObject(m, "NBT_RCODE", PyInt_FromLong(NBT_RCODE));
	PyModule_AddObject(m, "NBT_SERVER_GOOD_TIMESERV", PyInt_FromLong(NBT_SERVER_GOOD_TIMESERV));
	PyModule_AddObject(m, "NBT_QCLASS_IP", PyInt_FromLong(NBT_QCLASS_IP));
	PyModule_AddObject(m, "NBT_SERVER_SELECT_SECRET_DOMAIN_6", PyInt_FromLong(NBT_SERVER_SELECT_SECRET_DOMAIN_6));
	PyModule_AddObject(m, "NBT_SERVER_WRITABLE", PyInt_FromLong(NBT_SERVER_WRITABLE));
	PyModule_AddObject(m, "NBT_OPCODE_RELEASE", PyInt_FromLong(NBT_OPCODE_RELEASE));
	PyModule_AddObject(m, "SMB_TRANSACTION", PyInt_FromLong(SMB_TRANSACTION));
	PyModule_AddObject(m, "NBT_RCODE_OK", PyInt_FromLong(NBT_RCODE_OK));
	PyModule_AddObject(m, "NBT_SERVER_TIMESERV", PyInt_FromLong(NBT_SERVER_TIMESERV));
	PyModule_AddObject(m, "Election", PyInt_FromLong(Election));
	PyModule_AddObject(m, "GetBackupListReq", PyInt_FromLong(GetBackupListReq));
	PyModule_AddObject(m, "NBT_NAME_PDC", PyInt_FromLong(NBT_NAME_PDC));
	PyModule_AddObject(m, "NBT_MAILSLOT_NTLOGON", PyString_FromString("\\MAILSLOT\\NET\\NTLOGON"));
	PyModule_AddObject(m, "DGRAM_FLAG_MORE", PyInt_FromLong(DGRAM_FLAG_MORE));
	PyModule_AddObject(m, "LOGON_PRIMARY_QUERY", PyInt_FromLong(LOGON_PRIMARY_QUERY));
	PyModule_AddObject(m, "NBT_NAME_MS", PyInt_FromLong(NBT_NAME_MS));
	PyModule_AddObject(m, "LOGON_SAM_LOGON_PAUSE_RESPONSE_EX", PyInt_FromLong(LOGON_SAM_LOGON_PAUSE_RESPONSE_EX));
	PyModule_AddObject(m, "NETLOGON_NT_VERSION_5EX_WITH_IP", PyInt_FromLong(NETLOGON_NT_VERSION_5EX_WITH_IP));
	PyModule_AddObject(m, "DGRAM_SMB", PyInt_FromLong(0xff534d42));
	PyModule_AddObject(m, "HostAnnouncement", PyInt_FromLong(HostAnnouncement));
	PyModule_AddObject(m, "LocalMasterAnnouncement", PyInt_FromLong(LocalMasterAnnouncement));
	PyModule_AddObject(m, "DomainAnnouncement", PyInt_FromLong(DomainAnnouncement));
	PyModule_AddObject(m, "NBT_SERVER_IS_DEFAULT_NC", PyInt_FromLong(NBT_SERVER_IS_DEFAULT_NC));
	PyModule_AddObject(m, "LOGON_SAM_LOGON_USER_UNKNOWN", PyInt_FromLong(LOGON_SAM_LOGON_USER_UNKNOWN));
	PyModule_AddObject(m, "NBT_QTYPE_NULL", PyInt_FromLong(NBT_QTYPE_NULL));
	PyModule_AddObject(m, "NBT_NM_PERMANENT", PyInt_FromLong(NBT_NM_PERMANENT));
	PyModule_AddObject(m, "LOGON_SAM_LOGON_PAUSE_RESPONSE", PyInt_FromLong(LOGON_SAM_LOGON_PAUSE_RESPONSE));
	PyModule_AddObject(m, "LOGON_REQUEST", PyInt_FromLong(LOGON_REQUEST));
	PyModule_AddObject(m, "NBT_RCODE_NAM", PyInt_FromLong(NBT_RCODE_NAM));
	Py_INCREF((PyObject *)(void *)&nbt_name_Type);
	PyModule_AddObject(m, "name", (PyObject *)(void *)&nbt_name_Type);
	Py_INCREF((PyObject *)(void *)&nbt_name_question_Type);
	PyModule_AddObject(m, "name_question", (PyObject *)(void *)&nbt_name_question_Type);
	Py_INCREF((PyObject *)(void *)&nbt_rdata_address_Type);
	PyModule_AddObject(m, "rdata_address", (PyObject *)(void *)&nbt_rdata_address_Type);
	Py_INCREF((PyObject *)(void *)&nbt_rdata_netbios_Type);
	PyModule_AddObject(m, "rdata_netbios", (PyObject *)(void *)&nbt_rdata_netbios_Type);
	Py_INCREF((PyObject *)(void *)&nbt_statistics_Type);
	PyModule_AddObject(m, "statistics", (PyObject *)(void *)&nbt_statistics_Type);
	Py_INCREF((PyObject *)(void *)&nbt_status_name_Type);
	PyModule_AddObject(m, "status_name", (PyObject *)(void *)&nbt_status_name_Type);
	Py_INCREF((PyObject *)(void *)&nbt_rdata_status_Type);
	PyModule_AddObject(m, "rdata_status", (PyObject *)(void *)&nbt_rdata_status_Type);
	Py_INCREF((PyObject *)(void *)&nbt_rdata_data_Type);
	PyModule_AddObject(m, "rdata_data", (PyObject *)(void *)&nbt_rdata_data_Type);
	Py_INCREF((PyObject *)(void *)&nbt_res_rec_Type);
	PyModule_AddObject(m, "res_rec", (PyObject *)(void *)&nbt_res_rec_Type);
	Py_INCREF((PyObject *)(void *)&nbt_name_packet_Type);
	PyModule_AddObject(m, "name_packet", (PyObject *)(void *)&nbt_name_packet_Type);
	Py_INCREF((PyObject *)(void *)&smb_trans_body_Type);
	PyModule_AddObject(m, "smb_trans_body", (PyObject *)(void *)&smb_trans_body_Type);
	Py_INCREF((PyObject *)(void *)&dgram_smb_packet_Type);
	PyModule_AddObject(m, "dgram_smb_packet", (PyObject *)(void *)&dgram_smb_packet_Type);
	Py_INCREF((PyObject *)(void *)&dgram_message_Type);
	PyModule_AddObject(m, "dgram_message", (PyObject *)(void *)&dgram_message_Type);
	Py_INCREF((PyObject *)(void *)&nbt_dgram_packet_Type);
	PyModule_AddObject(m, "dgram_packet", (PyObject *)(void *)&nbt_dgram_packet_Type);
	Py_INCREF((PyObject *)(void *)&nbt_sockaddr_Type);
	PyModule_AddObject(m, "sockaddr", (PyObject *)(void *)&nbt_sockaddr_Type);
	Py_INCREF((PyObject *)(void *)&NETLOGON_SAM_LOGON_REQUEST_Type);
	PyModule_AddObject(m, "NETLOGON_SAM_LOGON_REQUEST", (PyObject *)(void *)&NETLOGON_SAM_LOGON_REQUEST_Type);
	Py_INCREF((PyObject *)(void *)&NETLOGON_LOGON_REQUEST_Type);
	PyModule_AddObject(m, "NETLOGON_LOGON_REQUEST", (PyObject *)(void *)&NETLOGON_LOGON_REQUEST_Type);
	Py_INCREF((PyObject *)(void *)&NETLOGON_SAM_LOGON_RESPONSE_NT40_Type);
	PyModule_AddObject(m, "NETLOGON_SAM_LOGON_RESPONSE_NT40", (PyObject *)(void *)&NETLOGON_SAM_LOGON_RESPONSE_NT40_Type);
	Py_INCREF((PyObject *)(void *)&NETLOGON_SAM_LOGON_RESPONSE_Type);
	PyModule_AddObject(m, "NETLOGON_SAM_LOGON_RESPONSE", (PyObject *)(void *)&NETLOGON_SAM_LOGON_RESPONSE_Type);
	Py_INCREF((PyObject *)(void *)&NETLOGON_SAM_LOGON_RESPONSE_EX_Type);
	PyModule_AddObject(m, "NETLOGON_SAM_LOGON_RESPONSE_EX", (PyObject *)(void *)&NETLOGON_SAM_LOGON_RESPONSE_EX_Type);
	Py_INCREF((PyObject *)(void *)&nbt_netlogon_query_for_pdc_Type);
	PyModule_AddObject(m, "netlogon_query_for_pdc", (PyObject *)(void *)&nbt_netlogon_query_for_pdc_Type);
	Py_INCREF((PyObject *)(void *)&nbt_netlogon_response_from_pdc_Type);
	PyModule_AddObject(m, "netlogon_response_from_pdc", (PyObject *)(void *)&nbt_netlogon_response_from_pdc_Type);
	Py_INCREF((PyObject *)(void *)&nbt_netlogon_response2_Type);
	PyModule_AddObject(m, "netlogon_response2", (PyObject *)(void *)&nbt_netlogon_response2_Type);
	Py_INCREF((PyObject *)(void *)&nbt_db_change_info_Type);
	PyModule_AddObject(m, "db_change_info", (PyObject *)(void *)&nbt_db_change_info_Type);
	Py_INCREF((PyObject *)(void *)&NETLOGON_DB_CHANGE_Type);
	PyModule_AddObject(m, "NETLOGON_DB_CHANGE", (PyObject *)(void *)&NETLOGON_DB_CHANGE_Type);
	Py_INCREF((PyObject *)(void *)&nbt_netlogon_packet_Type);
	PyModule_AddObject(m, "netlogon_packet", (PyObject *)(void *)&nbt_netlogon_packet_Type);
	Py_INCREF((PyObject *)(void *)&nbt_browse_host_announcement_Type);
	PyModule_AddObject(m, "browse_host_announcement", (PyObject *)(void *)&nbt_browse_host_announcement_Type);
	Py_INCREF((PyObject *)(void *)&nbt_browse_announcement_request_Type);
	PyModule_AddObject(m, "browse_announcement_request", (PyObject *)(void *)&nbt_browse_announcement_request_Type);
	Py_INCREF((PyObject *)(void *)&nbt_browse_election_request_Type);
	PyModule_AddObject(m, "browse_election_request", (PyObject *)(void *)&nbt_browse_election_request_Type);
	Py_INCREF((PyObject *)(void *)&nbt_browse_backup_list_request_Type);
	PyModule_AddObject(m, "browse_backup_list_request", (PyObject *)(void *)&nbt_browse_backup_list_request_Type);
	Py_INCREF((PyObject *)(void *)&nbt_browse_backup_list_response_Type);
	PyModule_AddObject(m, "browse_backup_list_response", (PyObject *)(void *)&nbt_browse_backup_list_response_Type);
	Py_INCREF((PyObject *)(void *)&nbt_browse_become_backup_Type);
	PyModule_AddObject(m, "browse_become_backup", (PyObject *)(void *)&nbt_browse_become_backup_Type);
	Py_INCREF((PyObject *)(void *)&nbt_browse_domain_announcement_Type);
	PyModule_AddObject(m, "browse_domain_announcement", (PyObject *)(void *)&nbt_browse_domain_announcement_Type);
	Py_INCREF((PyObject *)(void *)&nbt_browse_master_announcement_Type);
	PyModule_AddObject(m, "browse_master_announcement", (PyObject *)(void *)&nbt_browse_master_announcement_Type);
	Py_INCREF((PyObject *)(void *)&nbt_browse_reset_state_Type);
	PyModule_AddObject(m, "browse_reset_state", (PyObject *)(void *)&nbt_browse_reset_state_Type);
	Py_INCREF((PyObject *)(void *)&nbt_browse_local_master_announcement_Type);
	PyModule_AddObject(m, "browse_local_master_announcement", (PyObject *)(void *)&nbt_browse_local_master_announcement_Type);
	Py_INCREF((PyObject *)(void *)&nbt_browse_packet_Type);
	PyModule_AddObject(m, "browse_packet", (PyObject *)(void *)&nbt_browse_packet_Type);
	Py_INCREF((PyObject *)(void *)&nbt_InterfaceType);
	PyModule_AddObject(m, "nbt", (PyObject *)(void *)&nbt_InterfaceType);
#ifdef PY_MOD_NBT_PATCH
	PY_MOD_NBT_PATCH(m);
#endif

}
