
/* Python wrapper functions auto-generated by pidl */
#include <Python.h>
#include "includes.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "autoconf/librpc/gen_ndr/ndr_ioctl.h"
#include "autoconf/librpc/gen_ndr/ndr_ioctl_c.h"

staticforward PyTypeObject req_resume_key_rsp_Type;
staticforward PyTypeObject srv_copychunk_Type;
staticforward PyTypeObject srv_copychunk_copy_Type;
staticforward PyTypeObject srv_copychunk_rsp_Type;
staticforward PyTypeObject device_copy_offload_descriptor_Type;
staticforward PyTypeObject storage_offload_token_Type;
staticforward PyTypeObject fsctl_offload_read_input_Type;
staticforward PyTypeObject fsctl_offload_read_output_Type;
staticforward PyTypeObject fsctl_offload_write_input_Type;
staticforward PyTypeObject fsctl_offload_write_output_Type;

void initioctl(void);static PyTypeObject *Object_Type;

static PyObject *py_req_resume_key_rsp_get_resume_key(PyObject *obj, void *closure)
{
	struct req_resume_key_rsp *object = (struct req_resume_key_rsp *)pytalloc_get_ptr(obj);
	PyObject *py_resume_key;
	py_resume_key = PyList_New(24);
	if (py_resume_key == NULL) {
		return NULL;
	}
	{
		int resume_key_cntr_0;
		for (resume_key_cntr_0 = 0; resume_key_cntr_0 < 24; resume_key_cntr_0++) {
			PyObject *py_resume_key_0;
			py_resume_key_0 = PyInt_FromLong(object->resume_key[resume_key_cntr_0]);
			PyList_SetItem(py_resume_key, resume_key_cntr_0, py_resume_key_0);
		}
	}
	return py_resume_key;
}

static int py_req_resume_key_rsp_set_resume_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct req_resume_key_rsp *object = (struct req_resume_key_rsp *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int resume_key_cntr_0;
		for (resume_key_cntr_0 = 0; resume_key_cntr_0 < PyList_GET_SIZE(value); resume_key_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, resume_key_cntr_0), return -1;);
			object->resume_key[resume_key_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, resume_key_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_req_resume_key_rsp_get_context_len(PyObject *obj, void *closure)
{
	struct req_resume_key_rsp *object = (struct req_resume_key_rsp *)pytalloc_get_ptr(obj);
	PyObject *py_context_len;
	py_context_len = PyInt_FromLong(object->context_len);
	return py_context_len;
}

static int py_req_resume_key_rsp_set_context_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct req_resume_key_rsp *object = (struct req_resume_key_rsp *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->context_len = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_req_resume_key_rsp_get_context(PyObject *obj, void *closure)
{
	struct req_resume_key_rsp *object = (struct req_resume_key_rsp *)pytalloc_get_ptr(obj);
	PyObject *py_context;
	py_context = PyList_New(4);
	if (py_context == NULL) {
		return NULL;
	}
	{
		int context_cntr_0;
		for (context_cntr_0 = 0; context_cntr_0 < 4; context_cntr_0++) {
			PyObject *py_context_0;
			py_context_0 = PyInt_FromLong(object->context[context_cntr_0]);
			PyList_SetItem(py_context, context_cntr_0, py_context_0);
		}
	}
	return py_context;
}

static int py_req_resume_key_rsp_set_context(PyObject *py_obj, PyObject *value, void *closure)
{
	struct req_resume_key_rsp *object = (struct req_resume_key_rsp *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int context_cntr_0;
		for (context_cntr_0 = 0; context_cntr_0 < PyList_GET_SIZE(value); context_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, context_cntr_0), return -1;);
			object->context[context_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, context_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_req_resume_key_rsp_getsetters[] = {
	{ discard_const_p(char, "resume_key"), py_req_resume_key_rsp_get_resume_key, py_req_resume_key_rsp_set_resume_key },
	{ discard_const_p(char, "context_len"), py_req_resume_key_rsp_get_context_len, py_req_resume_key_rsp_set_context_len },
	{ discard_const_p(char, "context"), py_req_resume_key_rsp_get_context, py_req_resume_key_rsp_set_context },
	{ NULL }
};

static PyObject *py_req_resume_key_rsp_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct req_resume_key_rsp, type);
}

static PyObject *py_req_resume_key_rsp_ndr_pack(PyObject *py_obj)
{
	struct req_resume_key_rsp *object = (struct req_resume_key_rsp *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_req_resume_key_rsp);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_req_resume_key_rsp_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct req_resume_key_rsp *object = (struct req_resume_key_rsp *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_req_resume_key_rsp);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_req_resume_key_rsp);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_req_resume_key_rsp_ndr_print(PyObject *py_obj)
{
	struct req_resume_key_rsp *object = (struct req_resume_key_rsp *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_req_resume_key_rsp, "req_resume_key_rsp", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_req_resume_key_rsp_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_req_resume_key_rsp_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_req_resume_key_rsp_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_req_resume_key_rsp_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject req_resume_key_rsp_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ioctl.req_resume_key_rsp",
	.tp_getset = py_req_resume_key_rsp_getsetters,
	.tp_methods = py_req_resume_key_rsp_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_req_resume_key_rsp_new,
};


static PyObject *py_srv_copychunk_get_source_off(PyObject *obj, void *closure)
{
	struct srv_copychunk *object = (struct srv_copychunk *)pytalloc_get_ptr(obj);
	PyObject *py_source_off;
	py_source_off = PyLong_FromLongLong(object->source_off);
	return py_source_off;
}

static int py_srv_copychunk_set_source_off(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srv_copychunk *object = (struct srv_copychunk *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->source_off = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->source_off = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_srv_copychunk_get_target_off(PyObject *obj, void *closure)
{
	struct srv_copychunk *object = (struct srv_copychunk *)pytalloc_get_ptr(obj);
	PyObject *py_target_off;
	py_target_off = PyLong_FromLongLong(object->target_off);
	return py_target_off;
}

static int py_srv_copychunk_set_target_off(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srv_copychunk *object = (struct srv_copychunk *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->target_off = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->target_off = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_srv_copychunk_get_length(PyObject *obj, void *closure)
{
	struct srv_copychunk *object = (struct srv_copychunk *)pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_srv_copychunk_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srv_copychunk *object = (struct srv_copychunk *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_srv_copychunk_get_reserved(PyObject *obj, void *closure)
{
	struct srv_copychunk *object = (struct srv_copychunk *)pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyInt_FromLong(object->reserved);
	return py_reserved;
}

static int py_srv_copychunk_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srv_copychunk *object = (struct srv_copychunk *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->reserved = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_srv_copychunk_getsetters[] = {
	{ discard_const_p(char, "source_off"), py_srv_copychunk_get_source_off, py_srv_copychunk_set_source_off },
	{ discard_const_p(char, "target_off"), py_srv_copychunk_get_target_off, py_srv_copychunk_set_target_off },
	{ discard_const_p(char, "length"), py_srv_copychunk_get_length, py_srv_copychunk_set_length },
	{ discard_const_p(char, "reserved"), py_srv_copychunk_get_reserved, py_srv_copychunk_set_reserved },
	{ NULL }
};

static PyObject *py_srv_copychunk_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srv_copychunk, type);
}


static PyTypeObject srv_copychunk_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ioctl.srv_copychunk",
	.tp_getset = py_srv_copychunk_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_srv_copychunk_new,
};


static PyObject *py_srv_copychunk_copy_get_source_key(PyObject *obj, void *closure)
{
	struct srv_copychunk_copy *object = (struct srv_copychunk_copy *)pytalloc_get_ptr(obj);
	PyObject *py_source_key;
	py_source_key = PyList_New(24);
	if (py_source_key == NULL) {
		return NULL;
	}
	{
		int source_key_cntr_0;
		for (source_key_cntr_0 = 0; source_key_cntr_0 < 24; source_key_cntr_0++) {
			PyObject *py_source_key_0;
			py_source_key_0 = PyInt_FromLong(object->source_key[source_key_cntr_0]);
			PyList_SetItem(py_source_key, source_key_cntr_0, py_source_key_0);
		}
	}
	return py_source_key;
}

static int py_srv_copychunk_copy_set_source_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srv_copychunk_copy *object = (struct srv_copychunk_copy *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int source_key_cntr_0;
		for (source_key_cntr_0 = 0; source_key_cntr_0 < PyList_GET_SIZE(value); source_key_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, source_key_cntr_0), return -1;);
			object->source_key[source_key_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, source_key_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_srv_copychunk_copy_get_chunk_count(PyObject *obj, void *closure)
{
	struct srv_copychunk_copy *object = (struct srv_copychunk_copy *)pytalloc_get_ptr(obj);
	PyObject *py_chunk_count;
	py_chunk_count = PyInt_FromLong(object->chunk_count);
	return py_chunk_count;
}

static int py_srv_copychunk_copy_set_chunk_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srv_copychunk_copy *object = (struct srv_copychunk_copy *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->chunk_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_srv_copychunk_copy_get_reserved(PyObject *obj, void *closure)
{
	struct srv_copychunk_copy *object = (struct srv_copychunk_copy *)pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyInt_FromLong(object->reserved);
	return py_reserved;
}

static int py_srv_copychunk_copy_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srv_copychunk_copy *object = (struct srv_copychunk_copy *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->reserved = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_srv_copychunk_copy_get_chunks(PyObject *obj, void *closure)
{
	struct srv_copychunk_copy *object = (struct srv_copychunk_copy *)pytalloc_get_ptr(obj);
	PyObject *py_chunks;
	py_chunks = PyList_New(object->chunk_count);
	if (py_chunks == NULL) {
		return NULL;
	}
	{
		int chunks_cntr_0;
		for (chunks_cntr_0 = 0; chunks_cntr_0 < object->chunk_count; chunks_cntr_0++) {
			PyObject *py_chunks_0;
			py_chunks_0 = pytalloc_reference_ex(&srv_copychunk_Type, object->chunks, &object->chunks[chunks_cntr_0]);
			PyList_SetItem(py_chunks, chunks_cntr_0, py_chunks_0);
		}
	}
	return py_chunks;
}

static int py_srv_copychunk_copy_set_chunks(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srv_copychunk_copy *object = (struct srv_copychunk_copy *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int chunks_cntr_0;
		object->chunks = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->chunks, PyList_GET_SIZE(value));
		if (!object->chunks) { return -1;; }
		talloc_set_name_const(object->chunks, "ARRAY: object->chunks");
		for (chunks_cntr_0 = 0; chunks_cntr_0 < PyList_GET_SIZE(value); chunks_cntr_0++) {
			PY_CHECK_TYPE(&srv_copychunk_Type, PyList_GET_ITEM(value, chunks_cntr_0), return -1;);
			if (talloc_reference(object->chunks, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, chunks_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->chunks[chunks_cntr_0] = *(struct srv_copychunk *)pytalloc_get_ptr(PyList_GET_ITEM(value, chunks_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_srv_copychunk_copy_getsetters[] = {
	{ discard_const_p(char, "source_key"), py_srv_copychunk_copy_get_source_key, py_srv_copychunk_copy_set_source_key },
	{ discard_const_p(char, "chunk_count"), py_srv_copychunk_copy_get_chunk_count, py_srv_copychunk_copy_set_chunk_count },
	{ discard_const_p(char, "reserved"), py_srv_copychunk_copy_get_reserved, py_srv_copychunk_copy_set_reserved },
	{ discard_const_p(char, "chunks"), py_srv_copychunk_copy_get_chunks, py_srv_copychunk_copy_set_chunks },
	{ NULL }
};

static PyObject *py_srv_copychunk_copy_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srv_copychunk_copy, type);
}

static PyObject *py_srv_copychunk_copy_ndr_pack(PyObject *py_obj)
{
	struct srv_copychunk_copy *object = (struct srv_copychunk_copy *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_srv_copychunk_copy);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_srv_copychunk_copy_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct srv_copychunk_copy *object = (struct srv_copychunk_copy *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_srv_copychunk_copy);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_srv_copychunk_copy);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_srv_copychunk_copy_ndr_print(PyObject *py_obj)
{
	struct srv_copychunk_copy *object = (struct srv_copychunk_copy *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_srv_copychunk_copy, "srv_copychunk_copy", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_srv_copychunk_copy_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_srv_copychunk_copy_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_srv_copychunk_copy_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_srv_copychunk_copy_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject srv_copychunk_copy_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ioctl.srv_copychunk_copy",
	.tp_getset = py_srv_copychunk_copy_getsetters,
	.tp_methods = py_srv_copychunk_copy_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_srv_copychunk_copy_new,
};


static PyObject *py_srv_copychunk_rsp_get_chunks_written(PyObject *obj, void *closure)
{
	struct srv_copychunk_rsp *object = (struct srv_copychunk_rsp *)pytalloc_get_ptr(obj);
	PyObject *py_chunks_written;
	py_chunks_written = PyInt_FromLong(object->chunks_written);
	return py_chunks_written;
}

static int py_srv_copychunk_rsp_set_chunks_written(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srv_copychunk_rsp *object = (struct srv_copychunk_rsp *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->chunks_written = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_srv_copychunk_rsp_get_chunk_bytes_written(PyObject *obj, void *closure)
{
	struct srv_copychunk_rsp *object = (struct srv_copychunk_rsp *)pytalloc_get_ptr(obj);
	PyObject *py_chunk_bytes_written;
	py_chunk_bytes_written = PyInt_FromLong(object->chunk_bytes_written);
	return py_chunk_bytes_written;
}

static int py_srv_copychunk_rsp_set_chunk_bytes_written(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srv_copychunk_rsp *object = (struct srv_copychunk_rsp *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->chunk_bytes_written = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_srv_copychunk_rsp_get_total_bytes_written(PyObject *obj, void *closure)
{
	struct srv_copychunk_rsp *object = (struct srv_copychunk_rsp *)pytalloc_get_ptr(obj);
	PyObject *py_total_bytes_written;
	py_total_bytes_written = PyInt_FromLong(object->total_bytes_written);
	return py_total_bytes_written;
}

static int py_srv_copychunk_rsp_set_total_bytes_written(PyObject *py_obj, PyObject *value, void *closure)
{
	struct srv_copychunk_rsp *object = (struct srv_copychunk_rsp *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->total_bytes_written = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_srv_copychunk_rsp_getsetters[] = {
	{ discard_const_p(char, "chunks_written"), py_srv_copychunk_rsp_get_chunks_written, py_srv_copychunk_rsp_set_chunks_written },
	{ discard_const_p(char, "chunk_bytes_written"), py_srv_copychunk_rsp_get_chunk_bytes_written, py_srv_copychunk_rsp_set_chunk_bytes_written },
	{ discard_const_p(char, "total_bytes_written"), py_srv_copychunk_rsp_get_total_bytes_written, py_srv_copychunk_rsp_set_total_bytes_written },
	{ NULL }
};

static PyObject *py_srv_copychunk_rsp_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct srv_copychunk_rsp, type);
}

static PyObject *py_srv_copychunk_rsp_ndr_pack(PyObject *py_obj)
{
	struct srv_copychunk_rsp *object = (struct srv_copychunk_rsp *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_srv_copychunk_rsp);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_srv_copychunk_rsp_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct srv_copychunk_rsp *object = (struct srv_copychunk_rsp *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_srv_copychunk_rsp);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_srv_copychunk_rsp);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_srv_copychunk_rsp_ndr_print(PyObject *py_obj)
{
	struct srv_copychunk_rsp *object = (struct srv_copychunk_rsp *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_srv_copychunk_rsp, "srv_copychunk_rsp", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_srv_copychunk_rsp_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_srv_copychunk_rsp_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_srv_copychunk_rsp_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_srv_copychunk_rsp_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject srv_copychunk_rsp_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ioctl.srv_copychunk_rsp",
	.tp_getset = py_srv_copychunk_rsp_getsetters,
	.tp_methods = py_srv_copychunk_rsp_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_srv_copychunk_rsp_new,
};


static PyObject *py_device_copy_offload_descriptor_get_version(PyObject *obj, void *closure)
{
	struct device_copy_offload_descriptor *object = (struct device_copy_offload_descriptor *)pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyInt_FromLong(object->version);
	return py_version;
}

static int py_device_copy_offload_descriptor_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct device_copy_offload_descriptor *object = (struct device_copy_offload_descriptor *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->version = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_device_copy_offload_descriptor_get_size(PyObject *obj, void *closure)
{
	struct device_copy_offload_descriptor *object = (struct device_copy_offload_descriptor *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_device_copy_offload_descriptor_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct device_copy_offload_descriptor *object = (struct device_copy_offload_descriptor *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_device_copy_offload_descriptor_get_maximum_token_lifetime(PyObject *obj, void *closure)
{
	struct device_copy_offload_descriptor *object = (struct device_copy_offload_descriptor *)pytalloc_get_ptr(obj);
	PyObject *py_maximum_token_lifetime;
	py_maximum_token_lifetime = PyInt_FromLong(object->maximum_token_lifetime);
	return py_maximum_token_lifetime;
}

static int py_device_copy_offload_descriptor_set_maximum_token_lifetime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct device_copy_offload_descriptor *object = (struct device_copy_offload_descriptor *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->maximum_token_lifetime = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_device_copy_offload_descriptor_get_default_token_lifetime(PyObject *obj, void *closure)
{
	struct device_copy_offload_descriptor *object = (struct device_copy_offload_descriptor *)pytalloc_get_ptr(obj);
	PyObject *py_default_token_lifetime;
	py_default_token_lifetime = PyInt_FromLong(object->default_token_lifetime);
	return py_default_token_lifetime;
}

static int py_device_copy_offload_descriptor_set_default_token_lifetime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct device_copy_offload_descriptor *object = (struct device_copy_offload_descriptor *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->default_token_lifetime = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_device_copy_offload_descriptor_get_maximum_xfer_size(PyObject *obj, void *closure)
{
	struct device_copy_offload_descriptor *object = (struct device_copy_offload_descriptor *)pytalloc_get_ptr(obj);
	PyObject *py_maximum_xfer_size;
	py_maximum_xfer_size = PyLong_FromLongLong(object->maximum_xfer_size);
	return py_maximum_xfer_size;
}

static int py_device_copy_offload_descriptor_set_maximum_xfer_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct device_copy_offload_descriptor *object = (struct device_copy_offload_descriptor *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->maximum_xfer_size = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->maximum_xfer_size = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_device_copy_offload_descriptor_get_optimal_xfer_count(PyObject *obj, void *closure)
{
	struct device_copy_offload_descriptor *object = (struct device_copy_offload_descriptor *)pytalloc_get_ptr(obj);
	PyObject *py_optimal_xfer_count;
	py_optimal_xfer_count = PyLong_FromLongLong(object->optimal_xfer_count);
	return py_optimal_xfer_count;
}

static int py_device_copy_offload_descriptor_set_optimal_xfer_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct device_copy_offload_descriptor *object = (struct device_copy_offload_descriptor *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->optimal_xfer_count = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->optimal_xfer_count = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_device_copy_offload_descriptor_get_maximum_data_descriptors(PyObject *obj, void *closure)
{
	struct device_copy_offload_descriptor *object = (struct device_copy_offload_descriptor *)pytalloc_get_ptr(obj);
	PyObject *py_maximum_data_descriptors;
	py_maximum_data_descriptors = PyInt_FromLong(object->maximum_data_descriptors);
	return py_maximum_data_descriptors;
}

static int py_device_copy_offload_descriptor_set_maximum_data_descriptors(PyObject *py_obj, PyObject *value, void *closure)
{
	struct device_copy_offload_descriptor *object = (struct device_copy_offload_descriptor *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->maximum_data_descriptors = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_device_copy_offload_descriptor_get_maximum_xfer_length_per_descriptor(PyObject *obj, void *closure)
{
	struct device_copy_offload_descriptor *object = (struct device_copy_offload_descriptor *)pytalloc_get_ptr(obj);
	PyObject *py_maximum_xfer_length_per_descriptor;
	py_maximum_xfer_length_per_descriptor = PyInt_FromLong(object->maximum_xfer_length_per_descriptor);
	return py_maximum_xfer_length_per_descriptor;
}

static int py_device_copy_offload_descriptor_set_maximum_xfer_length_per_descriptor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct device_copy_offload_descriptor *object = (struct device_copy_offload_descriptor *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->maximum_xfer_length_per_descriptor = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_device_copy_offload_descriptor_get_optimal_xfer_length_per_descriptor(PyObject *obj, void *closure)
{
	struct device_copy_offload_descriptor *object = (struct device_copy_offload_descriptor *)pytalloc_get_ptr(obj);
	PyObject *py_optimal_xfer_length_per_descriptor;
	py_optimal_xfer_length_per_descriptor = PyInt_FromLong(object->optimal_xfer_length_per_descriptor);
	return py_optimal_xfer_length_per_descriptor;
}

static int py_device_copy_offload_descriptor_set_optimal_xfer_length_per_descriptor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct device_copy_offload_descriptor *object = (struct device_copy_offload_descriptor *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->optimal_xfer_length_per_descriptor = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_device_copy_offload_descriptor_get_optimal_xfer_length_granularity(PyObject *obj, void *closure)
{
	struct device_copy_offload_descriptor *object = (struct device_copy_offload_descriptor *)pytalloc_get_ptr(obj);
	PyObject *py_optimal_xfer_length_granularity;
	py_optimal_xfer_length_granularity = PyInt_FromLong(object->optimal_xfer_length_granularity);
	return py_optimal_xfer_length_granularity;
}

static int py_device_copy_offload_descriptor_set_optimal_xfer_length_granularity(PyObject *py_obj, PyObject *value, void *closure)
{
	struct device_copy_offload_descriptor *object = (struct device_copy_offload_descriptor *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->optimal_xfer_length_granularity = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_device_copy_offload_descriptor_get_reserved(PyObject *obj, void *closure)
{
	struct device_copy_offload_descriptor *object = (struct device_copy_offload_descriptor *)pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyList_New(2);
	if (py_reserved == NULL) {
		return NULL;
	}
	{
		int reserved_cntr_0;
		for (reserved_cntr_0 = 0; reserved_cntr_0 < 2; reserved_cntr_0++) {
			PyObject *py_reserved_0;
			py_reserved_0 = PyInt_FromLong(object->reserved[reserved_cntr_0]);
			PyList_SetItem(py_reserved, reserved_cntr_0, py_reserved_0);
		}
	}
	return py_reserved;
}

static int py_device_copy_offload_descriptor_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct device_copy_offload_descriptor *object = (struct device_copy_offload_descriptor *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int reserved_cntr_0;
		for (reserved_cntr_0 = 0; reserved_cntr_0 < PyList_GET_SIZE(value); reserved_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, reserved_cntr_0), return -1;);
			object->reserved[reserved_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, reserved_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_device_copy_offload_descriptor_getsetters[] = {
	{ discard_const_p(char, "version"), py_device_copy_offload_descriptor_get_version, py_device_copy_offload_descriptor_set_version },
	{ discard_const_p(char, "size"), py_device_copy_offload_descriptor_get_size, py_device_copy_offload_descriptor_set_size },
	{ discard_const_p(char, "maximum_token_lifetime"), py_device_copy_offload_descriptor_get_maximum_token_lifetime, py_device_copy_offload_descriptor_set_maximum_token_lifetime },
	{ discard_const_p(char, "default_token_lifetime"), py_device_copy_offload_descriptor_get_default_token_lifetime, py_device_copy_offload_descriptor_set_default_token_lifetime },
	{ discard_const_p(char, "maximum_xfer_size"), py_device_copy_offload_descriptor_get_maximum_xfer_size, py_device_copy_offload_descriptor_set_maximum_xfer_size },
	{ discard_const_p(char, "optimal_xfer_count"), py_device_copy_offload_descriptor_get_optimal_xfer_count, py_device_copy_offload_descriptor_set_optimal_xfer_count },
	{ discard_const_p(char, "maximum_data_descriptors"), py_device_copy_offload_descriptor_get_maximum_data_descriptors, py_device_copy_offload_descriptor_set_maximum_data_descriptors },
	{ discard_const_p(char, "maximum_xfer_length_per_descriptor"), py_device_copy_offload_descriptor_get_maximum_xfer_length_per_descriptor, py_device_copy_offload_descriptor_set_maximum_xfer_length_per_descriptor },
	{ discard_const_p(char, "optimal_xfer_length_per_descriptor"), py_device_copy_offload_descriptor_get_optimal_xfer_length_per_descriptor, py_device_copy_offload_descriptor_set_optimal_xfer_length_per_descriptor },
	{ discard_const_p(char, "optimal_xfer_length_granularity"), py_device_copy_offload_descriptor_get_optimal_xfer_length_granularity, py_device_copy_offload_descriptor_set_optimal_xfer_length_granularity },
	{ discard_const_p(char, "reserved"), py_device_copy_offload_descriptor_get_reserved, py_device_copy_offload_descriptor_set_reserved },
	{ NULL }
};

static PyObject *py_device_copy_offload_descriptor_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct device_copy_offload_descriptor, type);
}

static PyObject *py_device_copy_offload_descriptor_ndr_pack(PyObject *py_obj)
{
	struct device_copy_offload_descriptor *object = (struct device_copy_offload_descriptor *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_device_copy_offload_descriptor);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_device_copy_offload_descriptor_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct device_copy_offload_descriptor *object = (struct device_copy_offload_descriptor *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_device_copy_offload_descriptor);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_device_copy_offload_descriptor);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_device_copy_offload_descriptor_ndr_print(PyObject *py_obj)
{
	struct device_copy_offload_descriptor *object = (struct device_copy_offload_descriptor *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_device_copy_offload_descriptor, "device_copy_offload_descriptor", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_device_copy_offload_descriptor_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_device_copy_offload_descriptor_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_device_copy_offload_descriptor_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_device_copy_offload_descriptor_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject device_copy_offload_descriptor_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ioctl.device_copy_offload_descriptor",
	.tp_getset = py_device_copy_offload_descriptor_getsetters,
	.tp_methods = py_device_copy_offload_descriptor_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_device_copy_offload_descriptor_new,
};


static PyObject *py_storage_offload_token_get_token_type(PyObject *obj, void *closure)
{
	struct storage_offload_token *object = (struct storage_offload_token *)pytalloc_get_ptr(obj);
	PyObject *py_token_type;
	py_token_type = PyInt_FromLong(object->token_type);
	return py_token_type;
}

static int py_storage_offload_token_set_token_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct storage_offload_token *object = (struct storage_offload_token *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->token_type = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_storage_offload_token_get_reserved(PyObject *obj, void *closure)
{
	struct storage_offload_token *object = (struct storage_offload_token *)pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyList_New(2);
	if (py_reserved == NULL) {
		return NULL;
	}
	{
		int reserved_cntr_0;
		for (reserved_cntr_0 = 0; reserved_cntr_0 < 2; reserved_cntr_0++) {
			PyObject *py_reserved_0;
			py_reserved_0 = PyInt_FromLong(object->reserved[reserved_cntr_0]);
			PyList_SetItem(py_reserved, reserved_cntr_0, py_reserved_0);
		}
	}
	return py_reserved;
}

static int py_storage_offload_token_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct storage_offload_token *object = (struct storage_offload_token *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int reserved_cntr_0;
		for (reserved_cntr_0 = 0; reserved_cntr_0 < PyList_GET_SIZE(value); reserved_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, reserved_cntr_0), return -1;);
			object->reserved[reserved_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, reserved_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_storage_offload_token_get_token_id_len(PyObject *obj, void *closure)
{
	struct storage_offload_token *object = (struct storage_offload_token *)pytalloc_get_ptr(obj);
	PyObject *py_token_id_len;
	py_token_id_len = PyInt_FromLong(object->token_id_len);
	return py_token_id_len;
}

static int py_storage_offload_token_set_token_id_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct storage_offload_token *object = (struct storage_offload_token *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->token_id_len = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_storage_offload_token_get_token(PyObject *obj, void *closure)
{
	struct storage_offload_token *object = (struct storage_offload_token *)pytalloc_get_ptr(obj);
	PyObject *py_token;
	py_token = PyList_New(object->token_id_len);
	if (py_token == NULL) {
		return NULL;
	}
	{
		int token_cntr_0;
		for (token_cntr_0 = 0; token_cntr_0 < object->token_id_len; token_cntr_0++) {
			PyObject *py_token_0;
			py_token_0 = PyInt_FromLong(object->token[token_cntr_0]);
			PyList_SetItem(py_token, token_cntr_0, py_token_0);
		}
	}
	return py_token;
}

static int py_storage_offload_token_set_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct storage_offload_token *object = (struct storage_offload_token *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int token_cntr_0;
		object->token = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->token, PyList_GET_SIZE(value));
		if (!object->token) { return -1;; }
		talloc_set_name_const(object->token, "ARRAY: object->token");
		for (token_cntr_0 = 0; token_cntr_0 < PyList_GET_SIZE(value); token_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, token_cntr_0), return -1;);
			object->token[token_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, token_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_storage_offload_token_getsetters[] = {
	{ discard_const_p(char, "token_type"), py_storage_offload_token_get_token_type, py_storage_offload_token_set_token_type },
	{ discard_const_p(char, "reserved"), py_storage_offload_token_get_reserved, py_storage_offload_token_set_reserved },
	{ discard_const_p(char, "token_id_len"), py_storage_offload_token_get_token_id_len, py_storage_offload_token_set_token_id_len },
	{ discard_const_p(char, "token"), py_storage_offload_token_get_token, py_storage_offload_token_set_token },
	{ NULL }
};

static PyObject *py_storage_offload_token_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct storage_offload_token, type);
}

static PyObject *py_storage_offload_token_ndr_pack(PyObject *py_obj)
{
	struct storage_offload_token *object = (struct storage_offload_token *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_storage_offload_token);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_storage_offload_token_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct storage_offload_token *object = (struct storage_offload_token *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_storage_offload_token);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_storage_offload_token);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_storage_offload_token_ndr_print(PyObject *py_obj)
{
	struct storage_offload_token *object = (struct storage_offload_token *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_storage_offload_token, "storage_offload_token", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_storage_offload_token_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_storage_offload_token_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_storage_offload_token_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_storage_offload_token_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject storage_offload_token_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ioctl.storage_offload_token",
	.tp_getset = py_storage_offload_token_getsetters,
	.tp_methods = py_storage_offload_token_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_storage_offload_token_new,
};


static PyObject *py_fsctl_offload_read_input_get_size(PyObject *obj, void *closure)
{
	struct fsctl_offload_read_input *object = (struct fsctl_offload_read_input *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_fsctl_offload_read_input_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct fsctl_offload_read_input *object = (struct fsctl_offload_read_input *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_fsctl_offload_read_input_get_flags(PyObject *obj, void *closure)
{
	struct fsctl_offload_read_input *object = (struct fsctl_offload_read_input *)pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_fsctl_offload_read_input_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct fsctl_offload_read_input *object = (struct fsctl_offload_read_input *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_fsctl_offload_read_input_get_token_time_to_live(PyObject *obj, void *closure)
{
	struct fsctl_offload_read_input *object = (struct fsctl_offload_read_input *)pytalloc_get_ptr(obj);
	PyObject *py_token_time_to_live;
	py_token_time_to_live = PyInt_FromLong(object->token_time_to_live);
	return py_token_time_to_live;
}

static int py_fsctl_offload_read_input_set_token_time_to_live(PyObject *py_obj, PyObject *value, void *closure)
{
	struct fsctl_offload_read_input *object = (struct fsctl_offload_read_input *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->token_time_to_live = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_fsctl_offload_read_input_get_reserved(PyObject *obj, void *closure)
{
	struct fsctl_offload_read_input *object = (struct fsctl_offload_read_input *)pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyInt_FromLong(object->reserved);
	return py_reserved;
}

static int py_fsctl_offload_read_input_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct fsctl_offload_read_input *object = (struct fsctl_offload_read_input *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->reserved = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_fsctl_offload_read_input_get_file_offset(PyObject *obj, void *closure)
{
	struct fsctl_offload_read_input *object = (struct fsctl_offload_read_input *)pytalloc_get_ptr(obj);
	PyObject *py_file_offset;
	py_file_offset = PyLong_FromLongLong(object->file_offset);
	return py_file_offset;
}

static int py_fsctl_offload_read_input_set_file_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct fsctl_offload_read_input *object = (struct fsctl_offload_read_input *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->file_offset = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->file_offset = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_fsctl_offload_read_input_get_length(PyObject *obj, void *closure)
{
	struct fsctl_offload_read_input *object = (struct fsctl_offload_read_input *)pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromLongLong(object->length);
	return py_length;
}

static int py_fsctl_offload_read_input_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct fsctl_offload_read_input *object = (struct fsctl_offload_read_input *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->length = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->length = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyGetSetDef py_fsctl_offload_read_input_getsetters[] = {
	{ discard_const_p(char, "size"), py_fsctl_offload_read_input_get_size, py_fsctl_offload_read_input_set_size },
	{ discard_const_p(char, "flags"), py_fsctl_offload_read_input_get_flags, py_fsctl_offload_read_input_set_flags },
	{ discard_const_p(char, "token_time_to_live"), py_fsctl_offload_read_input_get_token_time_to_live, py_fsctl_offload_read_input_set_token_time_to_live },
	{ discard_const_p(char, "reserved"), py_fsctl_offload_read_input_get_reserved, py_fsctl_offload_read_input_set_reserved },
	{ discard_const_p(char, "file_offset"), py_fsctl_offload_read_input_get_file_offset, py_fsctl_offload_read_input_set_file_offset },
	{ discard_const_p(char, "length"), py_fsctl_offload_read_input_get_length, py_fsctl_offload_read_input_set_length },
	{ NULL }
};

static PyObject *py_fsctl_offload_read_input_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct fsctl_offload_read_input, type);
}

static PyObject *py_fsctl_offload_read_input_ndr_pack(PyObject *py_obj)
{
	struct fsctl_offload_read_input *object = (struct fsctl_offload_read_input *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_fsctl_offload_read_input);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_fsctl_offload_read_input_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct fsctl_offload_read_input *object = (struct fsctl_offload_read_input *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_fsctl_offload_read_input);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_fsctl_offload_read_input);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_fsctl_offload_read_input_ndr_print(PyObject *py_obj)
{
	struct fsctl_offload_read_input *object = (struct fsctl_offload_read_input *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_fsctl_offload_read_input, "fsctl_offload_read_input", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_fsctl_offload_read_input_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_fsctl_offload_read_input_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_fsctl_offload_read_input_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_fsctl_offload_read_input_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject fsctl_offload_read_input_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ioctl.fsctl_offload_read_input",
	.tp_getset = py_fsctl_offload_read_input_getsetters,
	.tp_methods = py_fsctl_offload_read_input_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_fsctl_offload_read_input_new,
};


static PyObject *py_fsctl_offload_read_output_get_size(PyObject *obj, void *closure)
{
	struct fsctl_offload_read_output *object = (struct fsctl_offload_read_output *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_fsctl_offload_read_output_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct fsctl_offload_read_output *object = (struct fsctl_offload_read_output *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_fsctl_offload_read_output_get_flags(PyObject *obj, void *closure)
{
	struct fsctl_offload_read_output *object = (struct fsctl_offload_read_output *)pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_fsctl_offload_read_output_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct fsctl_offload_read_output *object = (struct fsctl_offload_read_output *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_fsctl_offload_read_output_get_xfer_length(PyObject *obj, void *closure)
{
	struct fsctl_offload_read_output *object = (struct fsctl_offload_read_output *)pytalloc_get_ptr(obj);
	PyObject *py_xfer_length;
	py_xfer_length = PyLong_FromLongLong(object->xfer_length);
	return py_xfer_length;
}

static int py_fsctl_offload_read_output_set_xfer_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct fsctl_offload_read_output *object = (struct fsctl_offload_read_output *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->xfer_length = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->xfer_length = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_fsctl_offload_read_output_get_token(PyObject *obj, void *closure)
{
	struct fsctl_offload_read_output *object = (struct fsctl_offload_read_output *)pytalloc_get_ptr(obj);
	PyObject *py_token;
	py_token = PyList_New(512);
	if (py_token == NULL) {
		return NULL;
	}
	{
		int token_cntr_0;
		for (token_cntr_0 = 0; token_cntr_0 < 512; token_cntr_0++) {
			PyObject *py_token_0;
			py_token_0 = PyInt_FromLong(object->token[token_cntr_0]);
			PyList_SetItem(py_token, token_cntr_0, py_token_0);
		}
	}
	return py_token;
}

static int py_fsctl_offload_read_output_set_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct fsctl_offload_read_output *object = (struct fsctl_offload_read_output *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int token_cntr_0;
		for (token_cntr_0 = 0; token_cntr_0 < PyList_GET_SIZE(value); token_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, token_cntr_0), return -1;);
			object->token[token_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, token_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_fsctl_offload_read_output_getsetters[] = {
	{ discard_const_p(char, "size"), py_fsctl_offload_read_output_get_size, py_fsctl_offload_read_output_set_size },
	{ discard_const_p(char, "flags"), py_fsctl_offload_read_output_get_flags, py_fsctl_offload_read_output_set_flags },
	{ discard_const_p(char, "xfer_length"), py_fsctl_offload_read_output_get_xfer_length, py_fsctl_offload_read_output_set_xfer_length },
	{ discard_const_p(char, "token"), py_fsctl_offload_read_output_get_token, py_fsctl_offload_read_output_set_token },
	{ NULL }
};

static PyObject *py_fsctl_offload_read_output_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct fsctl_offload_read_output, type);
}

static PyObject *py_fsctl_offload_read_output_ndr_pack(PyObject *py_obj)
{
	struct fsctl_offload_read_output *object = (struct fsctl_offload_read_output *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_fsctl_offload_read_output);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_fsctl_offload_read_output_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct fsctl_offload_read_output *object = (struct fsctl_offload_read_output *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_fsctl_offload_read_output);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_fsctl_offload_read_output);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_fsctl_offload_read_output_ndr_print(PyObject *py_obj)
{
	struct fsctl_offload_read_output *object = (struct fsctl_offload_read_output *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_fsctl_offload_read_output, "fsctl_offload_read_output", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_fsctl_offload_read_output_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_fsctl_offload_read_output_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_fsctl_offload_read_output_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_fsctl_offload_read_output_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject fsctl_offload_read_output_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ioctl.fsctl_offload_read_output",
	.tp_getset = py_fsctl_offload_read_output_getsetters,
	.tp_methods = py_fsctl_offload_read_output_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_fsctl_offload_read_output_new,
};


static PyObject *py_fsctl_offload_write_input_get_size(PyObject *obj, void *closure)
{
	struct fsctl_offload_write_input *object = (struct fsctl_offload_write_input *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_fsctl_offload_write_input_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct fsctl_offload_write_input *object = (struct fsctl_offload_write_input *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_fsctl_offload_write_input_get_flags(PyObject *obj, void *closure)
{
	struct fsctl_offload_write_input *object = (struct fsctl_offload_write_input *)pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_fsctl_offload_write_input_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct fsctl_offload_write_input *object = (struct fsctl_offload_write_input *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_fsctl_offload_write_input_get_file_offset(PyObject *obj, void *closure)
{
	struct fsctl_offload_write_input *object = (struct fsctl_offload_write_input *)pytalloc_get_ptr(obj);
	PyObject *py_file_offset;
	py_file_offset = PyLong_FromLongLong(object->file_offset);
	return py_file_offset;
}

static int py_fsctl_offload_write_input_set_file_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct fsctl_offload_write_input *object = (struct fsctl_offload_write_input *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->file_offset = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->file_offset = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_fsctl_offload_write_input_get_copy_length(PyObject *obj, void *closure)
{
	struct fsctl_offload_write_input *object = (struct fsctl_offload_write_input *)pytalloc_get_ptr(obj);
	PyObject *py_copy_length;
	py_copy_length = PyLong_FromLongLong(object->copy_length);
	return py_copy_length;
}

static int py_fsctl_offload_write_input_set_copy_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct fsctl_offload_write_input *object = (struct fsctl_offload_write_input *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->copy_length = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->copy_length = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_fsctl_offload_write_input_get_xfer_offset(PyObject *obj, void *closure)
{
	struct fsctl_offload_write_input *object = (struct fsctl_offload_write_input *)pytalloc_get_ptr(obj);
	PyObject *py_xfer_offset;
	py_xfer_offset = PyLong_FromLongLong(object->xfer_offset);
	return py_xfer_offset;
}

static int py_fsctl_offload_write_input_set_xfer_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct fsctl_offload_write_input *object = (struct fsctl_offload_write_input *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->xfer_offset = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->xfer_offset = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_fsctl_offload_write_input_get_token(PyObject *obj, void *closure)
{
	struct fsctl_offload_write_input *object = (struct fsctl_offload_write_input *)pytalloc_get_ptr(obj);
	PyObject *py_token;
	py_token = PyList_New(512);
	if (py_token == NULL) {
		return NULL;
	}
	{
		int token_cntr_0;
		for (token_cntr_0 = 0; token_cntr_0 < 512; token_cntr_0++) {
			PyObject *py_token_0;
			py_token_0 = PyInt_FromLong(object->token[token_cntr_0]);
			PyList_SetItem(py_token, token_cntr_0, py_token_0);
		}
	}
	return py_token;
}

static int py_fsctl_offload_write_input_set_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct fsctl_offload_write_input *object = (struct fsctl_offload_write_input *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int token_cntr_0;
		for (token_cntr_0 = 0; token_cntr_0 < PyList_GET_SIZE(value); token_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, token_cntr_0), return -1;);
			object->token[token_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, token_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_fsctl_offload_write_input_getsetters[] = {
	{ discard_const_p(char, "size"), py_fsctl_offload_write_input_get_size, py_fsctl_offload_write_input_set_size },
	{ discard_const_p(char, "flags"), py_fsctl_offload_write_input_get_flags, py_fsctl_offload_write_input_set_flags },
	{ discard_const_p(char, "file_offset"), py_fsctl_offload_write_input_get_file_offset, py_fsctl_offload_write_input_set_file_offset },
	{ discard_const_p(char, "copy_length"), py_fsctl_offload_write_input_get_copy_length, py_fsctl_offload_write_input_set_copy_length },
	{ discard_const_p(char, "xfer_offset"), py_fsctl_offload_write_input_get_xfer_offset, py_fsctl_offload_write_input_set_xfer_offset },
	{ discard_const_p(char, "token"), py_fsctl_offload_write_input_get_token, py_fsctl_offload_write_input_set_token },
	{ NULL }
};

static PyObject *py_fsctl_offload_write_input_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct fsctl_offload_write_input, type);
}

static PyObject *py_fsctl_offload_write_input_ndr_pack(PyObject *py_obj)
{
	struct fsctl_offload_write_input *object = (struct fsctl_offload_write_input *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_fsctl_offload_write_input);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_fsctl_offload_write_input_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct fsctl_offload_write_input *object = (struct fsctl_offload_write_input *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_fsctl_offload_write_input);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_fsctl_offload_write_input);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_fsctl_offload_write_input_ndr_print(PyObject *py_obj)
{
	struct fsctl_offload_write_input *object = (struct fsctl_offload_write_input *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_fsctl_offload_write_input, "fsctl_offload_write_input", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_fsctl_offload_write_input_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_fsctl_offload_write_input_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_fsctl_offload_write_input_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_fsctl_offload_write_input_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject fsctl_offload_write_input_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ioctl.fsctl_offload_write_input",
	.tp_getset = py_fsctl_offload_write_input_getsetters,
	.tp_methods = py_fsctl_offload_write_input_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_fsctl_offload_write_input_new,
};


static PyObject *py_fsctl_offload_write_output_get_size(PyObject *obj, void *closure)
{
	struct fsctl_offload_write_output *object = (struct fsctl_offload_write_output *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_fsctl_offload_write_output_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct fsctl_offload_write_output *object = (struct fsctl_offload_write_output *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_fsctl_offload_write_output_get_flags(PyObject *obj, void *closure)
{
	struct fsctl_offload_write_output *object = (struct fsctl_offload_write_output *)pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_fsctl_offload_write_output_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct fsctl_offload_write_output *object = (struct fsctl_offload_write_output *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_fsctl_offload_write_output_get_length_written(PyObject *obj, void *closure)
{
	struct fsctl_offload_write_output *object = (struct fsctl_offload_write_output *)pytalloc_get_ptr(obj);
	PyObject *py_length_written;
	py_length_written = PyLong_FromLongLong(object->length_written);
	return py_length_written;
}

static int py_fsctl_offload_write_output_set_length_written(PyObject *py_obj, PyObject *value, void *closure)
{
	struct fsctl_offload_write_output *object = (struct fsctl_offload_write_output *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->length_written = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->length_written = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyGetSetDef py_fsctl_offload_write_output_getsetters[] = {
	{ discard_const_p(char, "size"), py_fsctl_offload_write_output_get_size, py_fsctl_offload_write_output_set_size },
	{ discard_const_p(char, "flags"), py_fsctl_offload_write_output_get_flags, py_fsctl_offload_write_output_set_flags },
	{ discard_const_p(char, "length_written"), py_fsctl_offload_write_output_get_length_written, py_fsctl_offload_write_output_set_length_written },
	{ NULL }
};

static PyObject *py_fsctl_offload_write_output_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct fsctl_offload_write_output, type);
}

static PyObject *py_fsctl_offload_write_output_ndr_pack(PyObject *py_obj)
{
	struct fsctl_offload_write_output *object = (struct fsctl_offload_write_output *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_fsctl_offload_write_output);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_fsctl_offload_write_output_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct fsctl_offload_write_output *object = (struct fsctl_offload_write_output *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_fsctl_offload_write_output);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_fsctl_offload_write_output);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_fsctl_offload_write_output_ndr_print(PyObject *py_obj)
{
	struct fsctl_offload_write_output *object = (struct fsctl_offload_write_output *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_fsctl_offload_write_output, "fsctl_offload_write_output", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_fsctl_offload_write_output_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_fsctl_offload_write_output_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_fsctl_offload_write_output_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_fsctl_offload_write_output_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject fsctl_offload_write_output_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ioctl.fsctl_offload_write_output",
	.tp_getset = py_fsctl_offload_write_output_getsetters,
	.tp_methods = py_fsctl_offload_write_output_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_fsctl_offload_write_output_new,
};

static PyMethodDef ioctl_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initioctl(void)
{
	PyObject *m;
	PyObject *dep_talloc;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		return;

	Object_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "Object");
	if (Object_Type == NULL)
		return;

	req_resume_key_rsp_Type.tp_base = Object_Type;

	srv_copychunk_Type.tp_base = Object_Type;

	srv_copychunk_copy_Type.tp_base = Object_Type;

	srv_copychunk_rsp_Type.tp_base = Object_Type;

	device_copy_offload_descriptor_Type.tp_base = Object_Type;

	storage_offload_token_Type.tp_base = Object_Type;

	fsctl_offload_read_input_Type.tp_base = Object_Type;

	fsctl_offload_read_output_Type.tp_base = Object_Type;

	fsctl_offload_write_input_Type.tp_base = Object_Type;

	fsctl_offload_write_output_Type.tp_base = Object_Type;

	if (PyType_Ready(&req_resume_key_rsp_Type) < 0)
		return;
	if (PyType_Ready(&srv_copychunk_Type) < 0)
		return;
	if (PyType_Ready(&srv_copychunk_copy_Type) < 0)
		return;
	if (PyType_Ready(&srv_copychunk_rsp_Type) < 0)
		return;
	if (PyType_Ready(&device_copy_offload_descriptor_Type) < 0)
		return;
	if (PyType_Ready(&storage_offload_token_Type) < 0)
		return;
	if (PyType_Ready(&fsctl_offload_read_input_Type) < 0)
		return;
	if (PyType_Ready(&fsctl_offload_read_output_Type) < 0)
		return;
	if (PyType_Ready(&fsctl_offload_write_input_Type) < 0)
		return;
	if (PyType_Ready(&fsctl_offload_write_output_Type) < 0)
		return;
#ifdef PY_REQ_RESUME_KEY_RSP_PATCH
	PY_REQ_RESUME_KEY_RSP_PATCH(&req_resume_key_rsp_Type);
#endif
#ifdef PY_SRV_COPYCHUNK_PATCH
	PY_SRV_COPYCHUNK_PATCH(&srv_copychunk_Type);
#endif
#ifdef PY_SRV_COPYCHUNK_COPY_PATCH
	PY_SRV_COPYCHUNK_COPY_PATCH(&srv_copychunk_copy_Type);
#endif
#ifdef PY_SRV_COPYCHUNK_RSP_PATCH
	PY_SRV_COPYCHUNK_RSP_PATCH(&srv_copychunk_rsp_Type);
#endif
#ifdef PY_DEVICE_COPY_OFFLOAD_DESCRIPTOR_PATCH
	PY_DEVICE_COPY_OFFLOAD_DESCRIPTOR_PATCH(&device_copy_offload_descriptor_Type);
#endif
#ifdef PY_STORAGE_OFFLOAD_TOKEN_PATCH
	PY_STORAGE_OFFLOAD_TOKEN_PATCH(&storage_offload_token_Type);
#endif
#ifdef PY_FSCTL_OFFLOAD_READ_INPUT_PATCH
	PY_FSCTL_OFFLOAD_READ_INPUT_PATCH(&fsctl_offload_read_input_Type);
#endif
#ifdef PY_FSCTL_OFFLOAD_READ_OUTPUT_PATCH
	PY_FSCTL_OFFLOAD_READ_OUTPUT_PATCH(&fsctl_offload_read_output_Type);
#endif
#ifdef PY_FSCTL_OFFLOAD_WRITE_INPUT_PATCH
	PY_FSCTL_OFFLOAD_WRITE_INPUT_PATCH(&fsctl_offload_write_input_Type);
#endif
#ifdef PY_FSCTL_OFFLOAD_WRITE_OUTPUT_PATCH
	PY_FSCTL_OFFLOAD_WRITE_OUTPUT_PATCH(&fsctl_offload_write_output_Type);
#endif

	m = Py_InitModule3("ioctl", ioctl_methods, "ioctl DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "OFFLOAD_READ_FLAG_FILE_TOO_SMALL", PyInt_FromLong(0x00000001));
	PyModule_AddObject(m, "STORAGE_OFFLOAD_TOKEN_TYPE_ZERO_DATA", PyInt_FromLong(0x00000001));
	PyModule_AddObject(m, "OFFLOAD_READ_FLAG_ALL_ZERO_BEYOND_RANGE", PyInt_FromLong(0x00000002));
	PyModule_AddObject(m, "OFFLOAD_READ_FLAG_CANNOT_OFFLOAD_BEYOND_RANGE", PyInt_FromLong(0x00000004));
	Py_INCREF((PyObject *)(void *)&req_resume_key_rsp_Type);
	PyModule_AddObject(m, "req_resume_key_rsp", (PyObject *)(void *)&req_resume_key_rsp_Type);
	Py_INCREF((PyObject *)(void *)&srv_copychunk_Type);
	PyModule_AddObject(m, "srv_copychunk", (PyObject *)(void *)&srv_copychunk_Type);
	Py_INCREF((PyObject *)(void *)&srv_copychunk_copy_Type);
	PyModule_AddObject(m, "srv_copychunk_copy", (PyObject *)(void *)&srv_copychunk_copy_Type);
	Py_INCREF((PyObject *)(void *)&srv_copychunk_rsp_Type);
	PyModule_AddObject(m, "srv_copychunk_rsp", (PyObject *)(void *)&srv_copychunk_rsp_Type);
	Py_INCREF((PyObject *)(void *)&device_copy_offload_descriptor_Type);
	PyModule_AddObject(m, "device_copy_offload_descriptor", (PyObject *)(void *)&device_copy_offload_descriptor_Type);
	Py_INCREF((PyObject *)(void *)&storage_offload_token_Type);
	PyModule_AddObject(m, "storage_offload_token", (PyObject *)(void *)&storage_offload_token_Type);
	Py_INCREF((PyObject *)(void *)&fsctl_offload_read_input_Type);
	PyModule_AddObject(m, "fsctl_offload_read_input", (PyObject *)(void *)&fsctl_offload_read_input_Type);
	Py_INCREF((PyObject *)(void *)&fsctl_offload_read_output_Type);
	PyModule_AddObject(m, "fsctl_offload_read_output", (PyObject *)(void *)&fsctl_offload_read_output_Type);
	Py_INCREF((PyObject *)(void *)&fsctl_offload_write_input_Type);
	PyModule_AddObject(m, "fsctl_offload_write_input", (PyObject *)(void *)&fsctl_offload_write_input_Type);
	Py_INCREF((PyObject *)(void *)&fsctl_offload_write_output_Type);
	PyModule_AddObject(m, "fsctl_offload_write_output", (PyObject *)(void *)&fsctl_offload_write_output_Type);
#ifdef PY_MOD_IOCTL_PATCH
	PY_MOD_IOCTL_PATCH(m);
#endif

}
