
/* Python wrapper functions auto-generated by pidl */
#include <Python.h>
#include "includes.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "autoconf/librpc/gen_ndr/ndr_dcerpc.h"
#include "autoconf/librpc/gen_ndr/ndr_dcerpc_c.h"

#include "librpc/gen_ndr/misc.h"
staticforward PyTypeObject dcerpc_ctx_list_Type;
staticforward PyTypeObject dcerpc_bind_Type;
staticforward PyTypeObject dcerpc_empty_Type;
staticforward PyTypeObject dcerpc_request_Type;
staticforward PyTypeObject dcerpc_ack_ctx_Type;
staticforward PyTypeObject dcerpc_bind_ack_Type;
staticforward PyTypeObject dcerpc_bind_nak_versions_Type;
staticforward PyTypeObject dcerpc_bind_nak_Type;
staticforward PyTypeObject dcerpc_response_Type;
staticforward PyTypeObject dcerpc_fault_Type;
staticforward PyTypeObject dcerpc_auth_Type;
staticforward PyTypeObject dcerpc_auth3_Type;
staticforward PyTypeObject dcerpc_orphaned_Type;
staticforward PyTypeObject dcerpc_co_cancel_Type;
staticforward PyTypeObject dcerpc_cl_cancel_Type;
staticforward PyTypeObject dcerpc_cancel_ack_Type;
staticforward PyTypeObject dcerpc_fack_Type;
staticforward PyTypeObject dcerpc_ack_Type;
staticforward PyTypeObject dcerpc_ping_Type;
staticforward PyTypeObject dcerpc_shutdown_Type;
staticforward PyTypeObject dcerpc_working_Type;
staticforward PyTypeObject RTSCookie_Type;
staticforward PyTypeObject ClientAddress_Type;
staticforward PyTypeObject FlowControlAcknowledgment_Type;
staticforward PyTypeObject dcerpc_rts_cmd_ReceiveWindowSize_Type;
staticforward PyTypeObject dcerpc_rts_cmd_FlowControlAck_Type;
staticforward PyTypeObject dcerpc_rts_cmd_ConnectionTimeout_Type;
staticforward PyTypeObject dcerpc_rts_cmd_Cookie_Type;
staticforward PyTypeObject dcerpc_rts_cmd_ChannelLifetime_Type;
staticforward PyTypeObject dcerpc_rts_cmd_ClientKeepalive_Type;
staticforward PyTypeObject dcerpc_rts_cmd_Version_Type;
staticforward PyTypeObject dcerpc_rts_cmd_Empty_Type;
staticforward PyTypeObject dcerpc_rts_cmd_Padding_Type;
staticforward PyTypeObject dcerpc_rts_cmd_NegativeANCE_Type;
staticforward PyTypeObject dcerpc_rts_cmd_ANCE_Type;
staticforward PyTypeObject dcerpc_rts_cmd_ClientAddress_Type;
staticforward PyTypeObject dcerpc_rts_cmd_AssociationGroupId_Type;
staticforward PyTypeObject dcerpc_rts_cmd_Destination_Type;
staticforward PyTypeObject dcerpc_rts_cmd_PingTrafficSentNotify_Type;
staticforward PyTypeObject dcerpc_rts_cmd_Type;
staticforward PyTypeObject dcerpc_rts_Type;
staticforward PyTypeObject ncacn_packet_Type;
staticforward PyTypeObject ncadg_packet_Type;

void initdcerpc(void);static PyTypeObject *GUID_Type;
static PyTypeObject *Object_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_dcerpc_ctx_list_get_context_id(PyObject *obj, void *closure)
{
	struct dcerpc_ctx_list *object = (struct dcerpc_ctx_list *)pytalloc_get_ptr(obj);
	PyObject *py_context_id;
	py_context_id = PyInt_FromLong(object->context_id);
	return py_context_id;
}

static int py_dcerpc_ctx_list_set_context_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_ctx_list *object = (struct dcerpc_ctx_list *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->context_id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_ctx_list_get_num_transfer_syntaxes(PyObject *obj, void *closure)
{
	struct dcerpc_ctx_list *object = (struct dcerpc_ctx_list *)pytalloc_get_ptr(obj);
	PyObject *py_num_transfer_syntaxes;
	py_num_transfer_syntaxes = PyInt_FromLong(object->num_transfer_syntaxes);
	return py_num_transfer_syntaxes;
}

static int py_dcerpc_ctx_list_set_num_transfer_syntaxes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_ctx_list *object = (struct dcerpc_ctx_list *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_transfer_syntaxes = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_ctx_list_get_abstract_syntax(PyObject *obj, void *closure)
{
	struct dcerpc_ctx_list *object = (struct dcerpc_ctx_list *)pytalloc_get_ptr(obj);
	PyObject *py_abstract_syntax;
	py_abstract_syntax = pytalloc_reference_ex(ndr_syntax_id_Type, pytalloc_get_mem_ctx(obj), &object->abstract_syntax);
	return py_abstract_syntax;
}

static int py_dcerpc_ctx_list_set_abstract_syntax(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_ctx_list *object = (struct dcerpc_ctx_list *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(ndr_syntax_id_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->abstract_syntax = *(struct ndr_syntax_id *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_dcerpc_ctx_list_get_transfer_syntaxes(PyObject *obj, void *closure)
{
	struct dcerpc_ctx_list *object = (struct dcerpc_ctx_list *)pytalloc_get_ptr(obj);
	PyObject *py_transfer_syntaxes;
	py_transfer_syntaxes = PyList_New(object->num_transfer_syntaxes);
	if (py_transfer_syntaxes == NULL) {
		return NULL;
	}
	{
		int transfer_syntaxes_cntr_0;
		for (transfer_syntaxes_cntr_0 = 0; transfer_syntaxes_cntr_0 < object->num_transfer_syntaxes; transfer_syntaxes_cntr_0++) {
			PyObject *py_transfer_syntaxes_0;
			py_transfer_syntaxes_0 = pytalloc_reference_ex(ndr_syntax_id_Type, object->transfer_syntaxes, &object->transfer_syntaxes[transfer_syntaxes_cntr_0]);
			PyList_SetItem(py_transfer_syntaxes, transfer_syntaxes_cntr_0, py_transfer_syntaxes_0);
		}
	}
	return py_transfer_syntaxes;
}

static int py_dcerpc_ctx_list_set_transfer_syntaxes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_ctx_list *object = (struct dcerpc_ctx_list *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int transfer_syntaxes_cntr_0;
		object->transfer_syntaxes = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->transfer_syntaxes, PyList_GET_SIZE(value));
		if (!object->transfer_syntaxes) { return -1;; }
		talloc_set_name_const(object->transfer_syntaxes, "ARRAY: object->transfer_syntaxes");
		for (transfer_syntaxes_cntr_0 = 0; transfer_syntaxes_cntr_0 < PyList_GET_SIZE(value); transfer_syntaxes_cntr_0++) {
			PY_CHECK_TYPE(ndr_syntax_id_Type, PyList_GET_ITEM(value, transfer_syntaxes_cntr_0), return -1;);
			if (talloc_reference(object->transfer_syntaxes, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, transfer_syntaxes_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->transfer_syntaxes[transfer_syntaxes_cntr_0] = *(struct ndr_syntax_id *)pytalloc_get_ptr(PyList_GET_ITEM(value, transfer_syntaxes_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_dcerpc_ctx_list_getsetters[] = {
	{ discard_const_p(char, "context_id"), py_dcerpc_ctx_list_get_context_id, py_dcerpc_ctx_list_set_context_id },
	{ discard_const_p(char, "num_transfer_syntaxes"), py_dcerpc_ctx_list_get_num_transfer_syntaxes, py_dcerpc_ctx_list_set_num_transfer_syntaxes },
	{ discard_const_p(char, "abstract_syntax"), py_dcerpc_ctx_list_get_abstract_syntax, py_dcerpc_ctx_list_set_abstract_syntax },
	{ discard_const_p(char, "transfer_syntaxes"), py_dcerpc_ctx_list_get_transfer_syntaxes, py_dcerpc_ctx_list_set_transfer_syntaxes },
	{ NULL }
};

static PyObject *py_dcerpc_ctx_list_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_ctx_list, type);
}


static PyTypeObject dcerpc_ctx_list_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.ctx_list",
	.tp_getset = py_dcerpc_ctx_list_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_ctx_list_new,
};


static PyObject *py_dcerpc_bind_get_max_xmit_frag(PyObject *obj, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)pytalloc_get_ptr(obj);
	PyObject *py_max_xmit_frag;
	py_max_xmit_frag = PyInt_FromLong(object->max_xmit_frag);
	return py_max_xmit_frag;
}

static int py_dcerpc_bind_set_max_xmit_frag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->max_xmit_frag = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_bind_get_max_recv_frag(PyObject *obj, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)pytalloc_get_ptr(obj);
	PyObject *py_max_recv_frag;
	py_max_recv_frag = PyInt_FromLong(object->max_recv_frag);
	return py_max_recv_frag;
}

static int py_dcerpc_bind_set_max_recv_frag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->max_recv_frag = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_bind_get_assoc_group_id(PyObject *obj, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)pytalloc_get_ptr(obj);
	PyObject *py_assoc_group_id;
	py_assoc_group_id = PyInt_FromLong(object->assoc_group_id);
	return py_assoc_group_id;
}

static int py_dcerpc_bind_set_assoc_group_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->assoc_group_id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_bind_get_num_contexts(PyObject *obj, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)pytalloc_get_ptr(obj);
	PyObject *py_num_contexts;
	py_num_contexts = PyInt_FromLong(object->num_contexts);
	return py_num_contexts;
}

static int py_dcerpc_bind_set_num_contexts(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_contexts = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_bind_get_ctx_list(PyObject *obj, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)pytalloc_get_ptr(obj);
	PyObject *py_ctx_list;
	py_ctx_list = PyList_New(object->num_contexts);
	if (py_ctx_list == NULL) {
		return NULL;
	}
	{
		int ctx_list_cntr_0;
		for (ctx_list_cntr_0 = 0; ctx_list_cntr_0 < object->num_contexts; ctx_list_cntr_0++) {
			PyObject *py_ctx_list_0;
			py_ctx_list_0 = pytalloc_reference_ex(&dcerpc_ctx_list_Type, object->ctx_list, &object->ctx_list[ctx_list_cntr_0]);
			PyList_SetItem(py_ctx_list, ctx_list_cntr_0, py_ctx_list_0);
		}
	}
	return py_ctx_list;
}

static int py_dcerpc_bind_set_ctx_list(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int ctx_list_cntr_0;
		object->ctx_list = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->ctx_list, PyList_GET_SIZE(value));
		if (!object->ctx_list) { return -1;; }
		talloc_set_name_const(object->ctx_list, "ARRAY: object->ctx_list");
		for (ctx_list_cntr_0 = 0; ctx_list_cntr_0 < PyList_GET_SIZE(value); ctx_list_cntr_0++) {
			PY_CHECK_TYPE(&dcerpc_ctx_list_Type, PyList_GET_ITEM(value, ctx_list_cntr_0), return -1;);
			if (talloc_reference(object->ctx_list, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, ctx_list_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->ctx_list[ctx_list_cntr_0] = *(struct dcerpc_ctx_list *)pytalloc_get_ptr(PyList_GET_ITEM(value, ctx_list_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_dcerpc_bind_get_auth_info(PyObject *obj, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)pytalloc_get_ptr(obj);
	PyObject *py_auth_info;
	py_auth_info = PyString_FromStringAndSize((char *)(object->auth_info).data, (object->auth_info).length);
	return py_auth_info;
}

static int py_dcerpc_bind_set_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)pytalloc_get_ptr(py_obj);
	object->auth_info = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_dcerpc_bind_getsetters[] = {
	{ discard_const_p(char, "max_xmit_frag"), py_dcerpc_bind_get_max_xmit_frag, py_dcerpc_bind_set_max_xmit_frag },
	{ discard_const_p(char, "max_recv_frag"), py_dcerpc_bind_get_max_recv_frag, py_dcerpc_bind_set_max_recv_frag },
	{ discard_const_p(char, "assoc_group_id"), py_dcerpc_bind_get_assoc_group_id, py_dcerpc_bind_set_assoc_group_id },
	{ discard_const_p(char, "num_contexts"), py_dcerpc_bind_get_num_contexts, py_dcerpc_bind_set_num_contexts },
	{ discard_const_p(char, "ctx_list"), py_dcerpc_bind_get_ctx_list, py_dcerpc_bind_set_ctx_list },
	{ discard_const_p(char, "auth_info"), py_dcerpc_bind_get_auth_info, py_dcerpc_bind_set_auth_info },
	{ NULL }
};

static PyObject *py_dcerpc_bind_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_bind, type);
}

static PyObject *py_dcerpc_bind_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_bind);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_bind_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_bind);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_bind);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_bind_ndr_print(PyObject *py_obj)
{
	struct dcerpc_bind *object = (struct dcerpc_bind *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_bind, "dcerpc_bind", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_bind_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_bind_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_bind_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_bind_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_bind_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.bind",
	.tp_getset = py_dcerpc_bind_getsetters,
	.tp_methods = py_dcerpc_bind_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_bind_new,
};


static PyObject *py_dcerpc_empty_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_empty, type);
}


static PyTypeObject dcerpc_empty_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.empty",
	.tp_getset = NULL,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_empty_new,
};

PyObject *py_import_dcerpc_object(TALLOC_CTX *mem_ctx, int level, union dcerpc_object *in)
{
	PyObject *ret;

	switch (level) {
		default:
			ret = pytalloc_reference_ex(&dcerpc_empty_Type, mem_ctx, &in->empty);
			return ret;

		case LIBNDR_FLAG_OBJECT_PRESENT:
			ret = pytalloc_reference_ex(GUID_Type, mem_ctx, &in->object);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union dcerpc_object *py_export_dcerpc_object(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union dcerpc_object *ret = talloc_zero(mem_ctx, union dcerpc_object);
	switch (level) {
		default:
			PY_CHECK_TYPE(&dcerpc_empty_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->empty = *(struct dcerpc_empty *)pytalloc_get_ptr(in);
			break;

		case LIBNDR_FLAG_OBJECT_PRESENT:
			PY_CHECK_TYPE(GUID_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->object = *(struct GUID *)pytalloc_get_ptr(in);
			break;

	}

	return ret;
}


static PyObject *py_dcerpc_request_get_alloc_hint(PyObject *obj, void *closure)
{
	struct dcerpc_request *object = (struct dcerpc_request *)pytalloc_get_ptr(obj);
	PyObject *py_alloc_hint;
	py_alloc_hint = PyInt_FromLong(object->alloc_hint);
	return py_alloc_hint;
}

static int py_dcerpc_request_set_alloc_hint(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_request *object = (struct dcerpc_request *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->alloc_hint = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_request_get_context_id(PyObject *obj, void *closure)
{
	struct dcerpc_request *object = (struct dcerpc_request *)pytalloc_get_ptr(obj);
	PyObject *py_context_id;
	py_context_id = PyInt_FromLong(object->context_id);
	return py_context_id;
}

static int py_dcerpc_request_set_context_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_request *object = (struct dcerpc_request *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->context_id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_request_get_opnum(PyObject *obj, void *closure)
{
	struct dcerpc_request *object = (struct dcerpc_request *)pytalloc_get_ptr(obj);
	PyObject *py_opnum;
	py_opnum = PyInt_FromLong(object->opnum);
	return py_opnum;
}

static int py_dcerpc_request_set_opnum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_request *object = (struct dcerpc_request *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->opnum = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_request_get_object(PyObject *obj, void *closure)
{
	struct dcerpc_request *object = (struct dcerpc_request *)pytalloc_get_ptr(obj);
	PyObject *py_object;
	py_object = py_import_dcerpc_object(pytalloc_get_mem_ctx(obj), ndr->flags & LIBNDR_FLAG_OBJECT_PRESENT, &object->object);
	if (py_object == NULL) {
		return NULL;
	}
	return py_object;
}

static int py_dcerpc_request_set_object(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_request *object = (struct dcerpc_request *)pytalloc_get_ptr(py_obj);
	{
		union dcerpc_object *object_switch_0;
		object_switch_0 = py_export_dcerpc_object(pytalloc_get_mem_ctx(py_obj), ndr->flags & LIBNDR_FLAG_OBJECT_PRESENT, value);
		if (object_switch_0 == NULL) {
			return -1;
		}
		object->object = *object_switch_0;
	}
	return 0;
}

static PyObject *py_dcerpc_request_get__pad(PyObject *obj, void *closure)
{
	struct dcerpc_request *object = (struct dcerpc_request *)pytalloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyString_FromStringAndSize((char *)(object->_pad).data, (object->_pad).length);
	return py__pad;
}

static int py_dcerpc_request_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_request *object = (struct dcerpc_request *)pytalloc_get_ptr(py_obj);
	object->_pad = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyObject *py_dcerpc_request_get_stub_and_verifier(PyObject *obj, void *closure)
{
	struct dcerpc_request *object = (struct dcerpc_request *)pytalloc_get_ptr(obj);
	PyObject *py_stub_and_verifier;
	py_stub_and_verifier = PyString_FromStringAndSize((char *)(object->stub_and_verifier).data, (object->stub_and_verifier).length);
	return py_stub_and_verifier;
}

static int py_dcerpc_request_set_stub_and_verifier(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_request *object = (struct dcerpc_request *)pytalloc_get_ptr(py_obj);
	object->stub_and_verifier = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_dcerpc_request_getsetters[] = {
	{ discard_const_p(char, "alloc_hint"), py_dcerpc_request_get_alloc_hint, py_dcerpc_request_set_alloc_hint },
	{ discard_const_p(char, "context_id"), py_dcerpc_request_get_context_id, py_dcerpc_request_set_context_id },
	{ discard_const_p(char, "opnum"), py_dcerpc_request_get_opnum, py_dcerpc_request_set_opnum },
	{ discard_const_p(char, "object"), py_dcerpc_request_get_object, py_dcerpc_request_set_object },
	{ discard_const_p(char, "_pad"), py_dcerpc_request_get__pad, py_dcerpc_request_set__pad },
	{ discard_const_p(char, "stub_and_verifier"), py_dcerpc_request_get_stub_and_verifier, py_dcerpc_request_set_stub_and_verifier },
	{ NULL }
};

static PyObject *py_dcerpc_request_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_request, type);
}


static PyTypeObject dcerpc_request_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.request",
	.tp_getset = py_dcerpc_request_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_request_new,
};


static PyObject *py_dcerpc_ack_ctx_get_result(PyObject *obj, void *closure)
{
	struct dcerpc_ack_ctx *object = (struct dcerpc_ack_ctx *)pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyInt_FromLong(object->result);
	return py_result;
}

static int py_dcerpc_ack_ctx_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_ack_ctx *object = (struct dcerpc_ack_ctx *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->result = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_ack_ctx_get_reason(PyObject *obj, void *closure)
{
	struct dcerpc_ack_ctx *object = (struct dcerpc_ack_ctx *)pytalloc_get_ptr(obj);
	PyObject *py_reason;
	py_reason = PyInt_FromLong(object->reason);
	return py_reason;
}

static int py_dcerpc_ack_ctx_set_reason(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_ack_ctx *object = (struct dcerpc_ack_ctx *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->reason = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_ack_ctx_get_syntax(PyObject *obj, void *closure)
{
	struct dcerpc_ack_ctx *object = (struct dcerpc_ack_ctx *)pytalloc_get_ptr(obj);
	PyObject *py_syntax;
	py_syntax = pytalloc_reference_ex(ndr_syntax_id_Type, pytalloc_get_mem_ctx(obj), &object->syntax);
	return py_syntax;
}

static int py_dcerpc_ack_ctx_set_syntax(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_ack_ctx *object = (struct dcerpc_ack_ctx *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(ndr_syntax_id_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->syntax = *(struct ndr_syntax_id *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_dcerpc_ack_ctx_getsetters[] = {
	{ discard_const_p(char, "result"), py_dcerpc_ack_ctx_get_result, py_dcerpc_ack_ctx_set_result },
	{ discard_const_p(char, "reason"), py_dcerpc_ack_ctx_get_reason, py_dcerpc_ack_ctx_set_reason },
	{ discard_const_p(char, "syntax"), py_dcerpc_ack_ctx_get_syntax, py_dcerpc_ack_ctx_set_syntax },
	{ NULL }
};

static PyObject *py_dcerpc_ack_ctx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_ack_ctx, type);
}


static PyTypeObject dcerpc_ack_ctx_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.ack_ctx",
	.tp_getset = py_dcerpc_ack_ctx_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_ack_ctx_new,
};


static PyObject *py_dcerpc_bind_ack_get_max_xmit_frag(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)pytalloc_get_ptr(obj);
	PyObject *py_max_xmit_frag;
	py_max_xmit_frag = PyInt_FromLong(object->max_xmit_frag);
	return py_max_xmit_frag;
}

static int py_dcerpc_bind_ack_set_max_xmit_frag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->max_xmit_frag = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_bind_ack_get_max_recv_frag(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)pytalloc_get_ptr(obj);
	PyObject *py_max_recv_frag;
	py_max_recv_frag = PyInt_FromLong(object->max_recv_frag);
	return py_max_recv_frag;
}

static int py_dcerpc_bind_ack_set_max_recv_frag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->max_recv_frag = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_bind_ack_get_assoc_group_id(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)pytalloc_get_ptr(obj);
	PyObject *py_assoc_group_id;
	py_assoc_group_id = PyInt_FromLong(object->assoc_group_id);
	return py_assoc_group_id;
}

static int py_dcerpc_bind_ack_set_assoc_group_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->assoc_group_id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_bind_ack_get_secondary_address_size(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)pytalloc_get_ptr(obj);
	PyObject *py_secondary_address_size;
	py_secondary_address_size = PyInt_FromLong(object->secondary_address_size);
	return py_secondary_address_size;
}

static int py_dcerpc_bind_ack_set_secondary_address_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->secondary_address_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_bind_ack_get_secondary_address(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)pytalloc_get_ptr(obj);
	PyObject *py_secondary_address;
	if (object->secondary_address == NULL) {
		py_secondary_address = Py_None;
		Py_INCREF(py_secondary_address);
	} else {
		py_secondary_address = PyUnicode_Decode(object->secondary_address, strlen(object->secondary_address), "utf-8", "ignore");
	}
	return py_secondary_address;
}

static int py_dcerpc_bind_ack_set_secondary_address(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)pytalloc_get_ptr(py_obj);
	if (PyUnicode_Check(value)) {
		object->secondary_address = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	} else if (PyString_Check(value)) {
		object->secondary_address = PyString_AS_STRING(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_dcerpc_bind_ack_get__pad1(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)pytalloc_get_ptr(obj);
	PyObject *py__pad1;
	py__pad1 = PyString_FromStringAndSize((char *)(object->_pad1).data, (object->_pad1).length);
	return py__pad1;
}

static int py_dcerpc_bind_ack_set__pad1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)pytalloc_get_ptr(py_obj);
	object->_pad1 = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyObject *py_dcerpc_bind_ack_get_num_results(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)pytalloc_get_ptr(obj);
	PyObject *py_num_results;
	py_num_results = PyInt_FromLong(object->num_results);
	return py_num_results;
}

static int py_dcerpc_bind_ack_set_num_results(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_results = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_bind_ack_get_ctx_list(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)pytalloc_get_ptr(obj);
	PyObject *py_ctx_list;
	py_ctx_list = PyList_New(object->num_results);
	if (py_ctx_list == NULL) {
		return NULL;
	}
	{
		int ctx_list_cntr_0;
		for (ctx_list_cntr_0 = 0; ctx_list_cntr_0 < object->num_results; ctx_list_cntr_0++) {
			PyObject *py_ctx_list_0;
			py_ctx_list_0 = pytalloc_reference_ex(&dcerpc_ack_ctx_Type, object->ctx_list, &object->ctx_list[ctx_list_cntr_0]);
			PyList_SetItem(py_ctx_list, ctx_list_cntr_0, py_ctx_list_0);
		}
	}
	return py_ctx_list;
}

static int py_dcerpc_bind_ack_set_ctx_list(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int ctx_list_cntr_0;
		object->ctx_list = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->ctx_list, PyList_GET_SIZE(value));
		if (!object->ctx_list) { return -1;; }
		talloc_set_name_const(object->ctx_list, "ARRAY: object->ctx_list");
		for (ctx_list_cntr_0 = 0; ctx_list_cntr_0 < PyList_GET_SIZE(value); ctx_list_cntr_0++) {
			PY_CHECK_TYPE(&dcerpc_ack_ctx_Type, PyList_GET_ITEM(value, ctx_list_cntr_0), return -1;);
			if (talloc_reference(object->ctx_list, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, ctx_list_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->ctx_list[ctx_list_cntr_0] = *(struct dcerpc_ack_ctx *)pytalloc_get_ptr(PyList_GET_ITEM(value, ctx_list_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_dcerpc_bind_ack_get_auth_info(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)pytalloc_get_ptr(obj);
	PyObject *py_auth_info;
	py_auth_info = PyString_FromStringAndSize((char *)(object->auth_info).data, (object->auth_info).length);
	return py_auth_info;
}

static int py_dcerpc_bind_ack_set_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = (struct dcerpc_bind_ack *)pytalloc_get_ptr(py_obj);
	object->auth_info = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_dcerpc_bind_ack_getsetters[] = {
	{ discard_const_p(char, "max_xmit_frag"), py_dcerpc_bind_ack_get_max_xmit_frag, py_dcerpc_bind_ack_set_max_xmit_frag },
	{ discard_const_p(char, "max_recv_frag"), py_dcerpc_bind_ack_get_max_recv_frag, py_dcerpc_bind_ack_set_max_recv_frag },
	{ discard_const_p(char, "assoc_group_id"), py_dcerpc_bind_ack_get_assoc_group_id, py_dcerpc_bind_ack_set_assoc_group_id },
	{ discard_const_p(char, "secondary_address_size"), py_dcerpc_bind_ack_get_secondary_address_size, py_dcerpc_bind_ack_set_secondary_address_size },
	{ discard_const_p(char, "secondary_address"), py_dcerpc_bind_ack_get_secondary_address, py_dcerpc_bind_ack_set_secondary_address },
	{ discard_const_p(char, "_pad1"), py_dcerpc_bind_ack_get__pad1, py_dcerpc_bind_ack_set__pad1 },
	{ discard_const_p(char, "num_results"), py_dcerpc_bind_ack_get_num_results, py_dcerpc_bind_ack_set_num_results },
	{ discard_const_p(char, "ctx_list"), py_dcerpc_bind_ack_get_ctx_list, py_dcerpc_bind_ack_set_ctx_list },
	{ discard_const_p(char, "auth_info"), py_dcerpc_bind_ack_get_auth_info, py_dcerpc_bind_ack_set_auth_info },
	{ NULL }
};

static PyObject *py_dcerpc_bind_ack_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_bind_ack, type);
}


static PyTypeObject dcerpc_bind_ack_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.bind_ack",
	.tp_getset = py_dcerpc_bind_ack_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_bind_ack_new,
};


static PyObject *py_dcerpc_bind_nak_versions_get_num_versions(PyObject *obj, void *closure)
{
	struct dcerpc_bind_nak_versions *object = (struct dcerpc_bind_nak_versions *)pytalloc_get_ptr(obj);
	PyObject *py_num_versions;
	py_num_versions = PyInt_FromLong(object->num_versions);
	return py_num_versions;
}

static int py_dcerpc_bind_nak_versions_set_num_versions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_nak_versions *object = (struct dcerpc_bind_nak_versions *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_versions = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_bind_nak_versions_get_versions(PyObject *obj, void *closure)
{
	struct dcerpc_bind_nak_versions *object = (struct dcerpc_bind_nak_versions *)pytalloc_get_ptr(obj);
	PyObject *py_versions;
	py_versions = PyList_New(object->num_versions);
	if (py_versions == NULL) {
		return NULL;
	}
	{
		int versions_cntr_0;
		for (versions_cntr_0 = 0; versions_cntr_0 < object->num_versions; versions_cntr_0++) {
			PyObject *py_versions_0;
			py_versions_0 = PyInt_FromLong(object->versions[versions_cntr_0]);
			PyList_SetItem(py_versions, versions_cntr_0, py_versions_0);
		}
	}
	return py_versions;
}

static int py_dcerpc_bind_nak_versions_set_versions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_nak_versions *object = (struct dcerpc_bind_nak_versions *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int versions_cntr_0;
		object->versions = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->versions, PyList_GET_SIZE(value));
		if (!object->versions) { return -1;; }
		talloc_set_name_const(object->versions, "ARRAY: object->versions");
		for (versions_cntr_0 = 0; versions_cntr_0 < PyList_GET_SIZE(value); versions_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, versions_cntr_0), return -1;);
			object->versions[versions_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, versions_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_dcerpc_bind_nak_versions_getsetters[] = {
	{ discard_const_p(char, "num_versions"), py_dcerpc_bind_nak_versions_get_num_versions, py_dcerpc_bind_nak_versions_set_num_versions },
	{ discard_const_p(char, "versions"), py_dcerpc_bind_nak_versions_get_versions, py_dcerpc_bind_nak_versions_set_versions },
	{ NULL }
};

static PyObject *py_dcerpc_bind_nak_versions_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_bind_nak_versions, type);
}


static PyTypeObject dcerpc_bind_nak_versions_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.bind_nak_versions",
	.tp_getset = py_dcerpc_bind_nak_versions_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_bind_nak_versions_new,
};

PyObject *py_import_dcerpc_bind_nak_versions_ctr(TALLOC_CTX *mem_ctx, int level, union dcerpc_bind_nak_versions_ctr *in)
{
	PyObject *ret;

	switch (level) {
		case DECRPC_BIND_PROTOCOL_VERSION_NOT_SUPPORTED:
			ret = pytalloc_reference_ex(&dcerpc_bind_nak_versions_Type, mem_ctx, &in->v);
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union dcerpc_bind_nak_versions_ctr *py_export_dcerpc_bind_nak_versions_ctr(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union dcerpc_bind_nak_versions_ctr *ret = talloc_zero(mem_ctx, union dcerpc_bind_nak_versions_ctr);
	switch (level) {
		case DECRPC_BIND_PROTOCOL_VERSION_NOT_SUPPORTED:
			PY_CHECK_TYPE(&dcerpc_bind_nak_versions_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->v = *(struct dcerpc_bind_nak_versions *)pytalloc_get_ptr(in);
			break;

		default:
			break;

	}

	return ret;
}


static PyObject *py_dcerpc_bind_nak_get_reject_reason(PyObject *obj, void *closure)
{
	struct dcerpc_bind_nak *object = (struct dcerpc_bind_nak *)pytalloc_get_ptr(obj);
	PyObject *py_reject_reason;
	py_reject_reason = PyInt_FromLong(object->reject_reason);
	return py_reject_reason;
}

static int py_dcerpc_bind_nak_set_reject_reason(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_nak *object = (struct dcerpc_bind_nak *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->reject_reason = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_bind_nak_get_versions(PyObject *obj, void *closure)
{
	struct dcerpc_bind_nak *object = (struct dcerpc_bind_nak *)pytalloc_get_ptr(obj);
	PyObject *py_versions;
	py_versions = py_import_dcerpc_bind_nak_versions_ctr(pytalloc_get_mem_ctx(obj), object->reject_reason, &object->versions);
	if (py_versions == NULL) {
		return NULL;
	}
	return py_versions;
}

static int py_dcerpc_bind_nak_set_versions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_nak *object = (struct dcerpc_bind_nak *)pytalloc_get_ptr(py_obj);
	{
		union dcerpc_bind_nak_versions_ctr *versions_switch_0;
		versions_switch_0 = py_export_dcerpc_bind_nak_versions_ctr(pytalloc_get_mem_ctx(py_obj), object->reject_reason, value);
		if (versions_switch_0 == NULL) {
			return -1;
		}
		object->versions = *versions_switch_0;
	}
	return 0;
}

static PyGetSetDef py_dcerpc_bind_nak_getsetters[] = {
	{ discard_const_p(char, "reject_reason"), py_dcerpc_bind_nak_get_reject_reason, py_dcerpc_bind_nak_set_reject_reason },
	{ discard_const_p(char, "versions"), py_dcerpc_bind_nak_get_versions, py_dcerpc_bind_nak_set_versions },
	{ NULL }
};

static PyObject *py_dcerpc_bind_nak_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_bind_nak, type);
}


static PyTypeObject dcerpc_bind_nak_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.bind_nak",
	.tp_getset = py_dcerpc_bind_nak_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_bind_nak_new,
};


static PyObject *py_dcerpc_response_get_alloc_hint(PyObject *obj, void *closure)
{
	struct dcerpc_response *object = (struct dcerpc_response *)pytalloc_get_ptr(obj);
	PyObject *py_alloc_hint;
	py_alloc_hint = PyInt_FromLong(object->alloc_hint);
	return py_alloc_hint;
}

static int py_dcerpc_response_set_alloc_hint(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_response *object = (struct dcerpc_response *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->alloc_hint = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_response_get_context_id(PyObject *obj, void *closure)
{
	struct dcerpc_response *object = (struct dcerpc_response *)pytalloc_get_ptr(obj);
	PyObject *py_context_id;
	py_context_id = PyInt_FromLong(object->context_id);
	return py_context_id;
}

static int py_dcerpc_response_set_context_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_response *object = (struct dcerpc_response *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->context_id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_response_get_cancel_count(PyObject *obj, void *closure)
{
	struct dcerpc_response *object = (struct dcerpc_response *)pytalloc_get_ptr(obj);
	PyObject *py_cancel_count;
	py_cancel_count = PyInt_FromLong(object->cancel_count);
	return py_cancel_count;
}

static int py_dcerpc_response_set_cancel_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_response *object = (struct dcerpc_response *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->cancel_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_response_get__pad(PyObject *obj, void *closure)
{
	struct dcerpc_response *object = (struct dcerpc_response *)pytalloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyString_FromStringAndSize((char *)(object->_pad).data, (object->_pad).length);
	return py__pad;
}

static int py_dcerpc_response_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_response *object = (struct dcerpc_response *)pytalloc_get_ptr(py_obj);
	object->_pad = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyObject *py_dcerpc_response_get_stub_and_verifier(PyObject *obj, void *closure)
{
	struct dcerpc_response *object = (struct dcerpc_response *)pytalloc_get_ptr(obj);
	PyObject *py_stub_and_verifier;
	py_stub_and_verifier = PyString_FromStringAndSize((char *)(object->stub_and_verifier).data, (object->stub_and_verifier).length);
	return py_stub_and_verifier;
}

static int py_dcerpc_response_set_stub_and_verifier(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_response *object = (struct dcerpc_response *)pytalloc_get_ptr(py_obj);
	object->stub_and_verifier = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_dcerpc_response_getsetters[] = {
	{ discard_const_p(char, "alloc_hint"), py_dcerpc_response_get_alloc_hint, py_dcerpc_response_set_alloc_hint },
	{ discard_const_p(char, "context_id"), py_dcerpc_response_get_context_id, py_dcerpc_response_set_context_id },
	{ discard_const_p(char, "cancel_count"), py_dcerpc_response_get_cancel_count, py_dcerpc_response_set_cancel_count },
	{ discard_const_p(char, "_pad"), py_dcerpc_response_get__pad, py_dcerpc_response_set__pad },
	{ discard_const_p(char, "stub_and_verifier"), py_dcerpc_response_get_stub_and_verifier, py_dcerpc_response_set_stub_and_verifier },
	{ NULL }
};

static PyObject *py_dcerpc_response_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_response, type);
}


static PyTypeObject dcerpc_response_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.response",
	.tp_getset = py_dcerpc_response_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_response_new,
};


static PyObject *py_dcerpc_fault_get_alloc_hint(PyObject *obj, void *closure)
{
	struct dcerpc_fault *object = (struct dcerpc_fault *)pytalloc_get_ptr(obj);
	PyObject *py_alloc_hint;
	py_alloc_hint = PyInt_FromLong(object->alloc_hint);
	return py_alloc_hint;
}

static int py_dcerpc_fault_set_alloc_hint(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fault *object = (struct dcerpc_fault *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->alloc_hint = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_fault_get_context_id(PyObject *obj, void *closure)
{
	struct dcerpc_fault *object = (struct dcerpc_fault *)pytalloc_get_ptr(obj);
	PyObject *py_context_id;
	py_context_id = PyInt_FromLong(object->context_id);
	return py_context_id;
}

static int py_dcerpc_fault_set_context_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fault *object = (struct dcerpc_fault *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->context_id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_fault_get_cancel_count(PyObject *obj, void *closure)
{
	struct dcerpc_fault *object = (struct dcerpc_fault *)pytalloc_get_ptr(obj);
	PyObject *py_cancel_count;
	py_cancel_count = PyInt_FromLong(object->cancel_count);
	return py_cancel_count;
}

static int py_dcerpc_fault_set_cancel_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fault *object = (struct dcerpc_fault *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->cancel_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_fault_get_status(PyObject *obj, void *closure)
{
	struct dcerpc_fault *object = (struct dcerpc_fault *)pytalloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyInt_FromLong(object->status);
	return py_status;
}

static int py_dcerpc_fault_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fault *object = (struct dcerpc_fault *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->status = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->status = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_dcerpc_fault_get__pad(PyObject *obj, void *closure)
{
	struct dcerpc_fault *object = (struct dcerpc_fault *)pytalloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyString_FromStringAndSize((char *)(object->_pad).data, (object->_pad).length);
	return py__pad;
}

static int py_dcerpc_fault_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fault *object = (struct dcerpc_fault *)pytalloc_get_ptr(py_obj);
	object->_pad = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_dcerpc_fault_getsetters[] = {
	{ discard_const_p(char, "alloc_hint"), py_dcerpc_fault_get_alloc_hint, py_dcerpc_fault_set_alloc_hint },
	{ discard_const_p(char, "context_id"), py_dcerpc_fault_get_context_id, py_dcerpc_fault_set_context_id },
	{ discard_const_p(char, "cancel_count"), py_dcerpc_fault_get_cancel_count, py_dcerpc_fault_set_cancel_count },
	{ discard_const_p(char, "status"), py_dcerpc_fault_get_status, py_dcerpc_fault_set_status },
	{ discard_const_p(char, "_pad"), py_dcerpc_fault_get__pad, py_dcerpc_fault_set__pad },
	{ NULL }
};

static PyObject *py_dcerpc_fault_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_fault, type);
}


static PyTypeObject dcerpc_fault_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.fault",
	.tp_getset = py_dcerpc_fault_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_fault_new,
};


static PyObject *py_dcerpc_auth_get_auth_type(PyObject *obj, void *closure)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)pytalloc_get_ptr(obj);
	PyObject *py_auth_type;
	py_auth_type = PyInt_FromLong(object->auth_type);
	return py_auth_type;
}

static int py_dcerpc_auth_set_auth_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->auth_type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->auth_type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_dcerpc_auth_get_auth_level(PyObject *obj, void *closure)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)pytalloc_get_ptr(obj);
	PyObject *py_auth_level;
	py_auth_level = PyInt_FromLong(object->auth_level);
	return py_auth_level;
}

static int py_dcerpc_auth_set_auth_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->auth_level = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->auth_level = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_dcerpc_auth_get_auth_pad_length(PyObject *obj, void *closure)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)pytalloc_get_ptr(obj);
	PyObject *py_auth_pad_length;
	py_auth_pad_length = PyInt_FromLong(object->auth_pad_length);
	return py_auth_pad_length;
}

static int py_dcerpc_auth_set_auth_pad_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->auth_pad_length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_auth_get_auth_reserved(PyObject *obj, void *closure)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)pytalloc_get_ptr(obj);
	PyObject *py_auth_reserved;
	py_auth_reserved = PyInt_FromLong(object->auth_reserved);
	return py_auth_reserved;
}

static int py_dcerpc_auth_set_auth_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->auth_reserved = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_auth_get_auth_context_id(PyObject *obj, void *closure)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)pytalloc_get_ptr(obj);
	PyObject *py_auth_context_id;
	py_auth_context_id = PyInt_FromLong(object->auth_context_id);
	return py_auth_context_id;
}

static int py_dcerpc_auth_set_auth_context_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->auth_context_id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_auth_get_credentials(PyObject *obj, void *closure)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)pytalloc_get_ptr(obj);
	PyObject *py_credentials;
	py_credentials = PyString_FromStringAndSize((char *)(object->credentials).data, (object->credentials).length);
	return py_credentials;
}

static int py_dcerpc_auth_set_credentials(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)pytalloc_get_ptr(py_obj);
	object->credentials = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_dcerpc_auth_getsetters[] = {
	{ discard_const_p(char, "auth_type"), py_dcerpc_auth_get_auth_type, py_dcerpc_auth_set_auth_type },
	{ discard_const_p(char, "auth_level"), py_dcerpc_auth_get_auth_level, py_dcerpc_auth_set_auth_level },
	{ discard_const_p(char, "auth_pad_length"), py_dcerpc_auth_get_auth_pad_length, py_dcerpc_auth_set_auth_pad_length },
	{ discard_const_p(char, "auth_reserved"), py_dcerpc_auth_get_auth_reserved, py_dcerpc_auth_set_auth_reserved },
	{ discard_const_p(char, "auth_context_id"), py_dcerpc_auth_get_auth_context_id, py_dcerpc_auth_set_auth_context_id },
	{ discard_const_p(char, "credentials"), py_dcerpc_auth_get_credentials, py_dcerpc_auth_set_credentials },
	{ NULL }
};

static PyObject *py_dcerpc_auth_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_auth, type);
}

static PyObject *py_dcerpc_auth_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_auth);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_auth_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_auth);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_auth);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_auth_ndr_print(PyObject *py_obj)
{
	struct dcerpc_auth *object = (struct dcerpc_auth *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_auth, "dcerpc_auth", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_auth_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_auth_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_auth_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_auth_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_auth_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.auth",
	.tp_getset = py_dcerpc_auth_getsetters,
	.tp_methods = py_dcerpc_auth_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_auth_new,
};


static PyObject *py_dcerpc_auth3_get__pad(PyObject *obj, void *closure)
{
	struct dcerpc_auth3 *object = (struct dcerpc_auth3 *)pytalloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyInt_FromLong(object->_pad);
	return py__pad;
}

static int py_dcerpc_auth3_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_auth3 *object = (struct dcerpc_auth3 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->_pad = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_auth3_get_auth_info(PyObject *obj, void *closure)
{
	struct dcerpc_auth3 *object = (struct dcerpc_auth3 *)pytalloc_get_ptr(obj);
	PyObject *py_auth_info;
	py_auth_info = PyString_FromStringAndSize((char *)(object->auth_info).data, (object->auth_info).length);
	return py_auth_info;
}

static int py_dcerpc_auth3_set_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_auth3 *object = (struct dcerpc_auth3 *)pytalloc_get_ptr(py_obj);
	object->auth_info = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_dcerpc_auth3_getsetters[] = {
	{ discard_const_p(char, "_pad"), py_dcerpc_auth3_get__pad, py_dcerpc_auth3_set__pad },
	{ discard_const_p(char, "auth_info"), py_dcerpc_auth3_get_auth_info, py_dcerpc_auth3_set_auth_info },
	{ NULL }
};

static PyObject *py_dcerpc_auth3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_auth3, type);
}

static PyObject *py_dcerpc_auth3_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_auth3 *object = (struct dcerpc_auth3 *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_auth3);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_auth3_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_auth3 *object = (struct dcerpc_auth3 *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_auth3);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_auth3);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_auth3_ndr_print(PyObject *py_obj)
{
	struct dcerpc_auth3 *object = (struct dcerpc_auth3 *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_auth3, "dcerpc_auth3", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_auth3_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_auth3_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_auth3_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_auth3_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_auth3_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.auth3",
	.tp_getset = py_dcerpc_auth3_getsetters,
	.tp_methods = py_dcerpc_auth3_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_auth3_new,
};


static PyObject *py_dcerpc_orphaned_get__pad(PyObject *obj, void *closure)
{
	struct dcerpc_orphaned *object = (struct dcerpc_orphaned *)pytalloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyInt_FromLong(object->_pad);
	return py__pad;
}

static int py_dcerpc_orphaned_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_orphaned *object = (struct dcerpc_orphaned *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->_pad = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_orphaned_get_auth_info(PyObject *obj, void *closure)
{
	struct dcerpc_orphaned *object = (struct dcerpc_orphaned *)pytalloc_get_ptr(obj);
	PyObject *py_auth_info;
	py_auth_info = PyString_FromStringAndSize((char *)(object->auth_info).data, (object->auth_info).length);
	return py_auth_info;
}

static int py_dcerpc_orphaned_set_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_orphaned *object = (struct dcerpc_orphaned *)pytalloc_get_ptr(py_obj);
	object->auth_info = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_dcerpc_orphaned_getsetters[] = {
	{ discard_const_p(char, "_pad"), py_dcerpc_orphaned_get__pad, py_dcerpc_orphaned_set__pad },
	{ discard_const_p(char, "auth_info"), py_dcerpc_orphaned_get_auth_info, py_dcerpc_orphaned_set_auth_info },
	{ NULL }
};

static PyObject *py_dcerpc_orphaned_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_orphaned, type);
}

static PyObject *py_dcerpc_orphaned_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_orphaned *object = (struct dcerpc_orphaned *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_orphaned);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_orphaned_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_orphaned *object = (struct dcerpc_orphaned *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_orphaned);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_orphaned);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_orphaned_ndr_print(PyObject *py_obj)
{
	struct dcerpc_orphaned *object = (struct dcerpc_orphaned *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_orphaned, "dcerpc_orphaned", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_orphaned_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_orphaned_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_orphaned_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_orphaned_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_orphaned_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.orphaned",
	.tp_getset = py_dcerpc_orphaned_getsetters,
	.tp_methods = py_dcerpc_orphaned_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_orphaned_new,
};


static PyObject *py_dcerpc_co_cancel_get__pad(PyObject *obj, void *closure)
{
	struct dcerpc_co_cancel *object = (struct dcerpc_co_cancel *)pytalloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyInt_FromLong(object->_pad);
	return py__pad;
}

static int py_dcerpc_co_cancel_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_co_cancel *object = (struct dcerpc_co_cancel *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->_pad = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_co_cancel_get_auth_info(PyObject *obj, void *closure)
{
	struct dcerpc_co_cancel *object = (struct dcerpc_co_cancel *)pytalloc_get_ptr(obj);
	PyObject *py_auth_info;
	py_auth_info = PyString_FromStringAndSize((char *)(object->auth_info).data, (object->auth_info).length);
	return py_auth_info;
}

static int py_dcerpc_co_cancel_set_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_co_cancel *object = (struct dcerpc_co_cancel *)pytalloc_get_ptr(py_obj);
	object->auth_info = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_dcerpc_co_cancel_getsetters[] = {
	{ discard_const_p(char, "_pad"), py_dcerpc_co_cancel_get__pad, py_dcerpc_co_cancel_set__pad },
	{ discard_const_p(char, "auth_info"), py_dcerpc_co_cancel_get_auth_info, py_dcerpc_co_cancel_set_auth_info },
	{ NULL }
};

static PyObject *py_dcerpc_co_cancel_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_co_cancel, type);
}

static PyObject *py_dcerpc_co_cancel_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_co_cancel *object = (struct dcerpc_co_cancel *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_co_cancel);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_co_cancel_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_co_cancel *object = (struct dcerpc_co_cancel *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_co_cancel);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_co_cancel);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_co_cancel_ndr_print(PyObject *py_obj)
{
	struct dcerpc_co_cancel *object = (struct dcerpc_co_cancel *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_co_cancel, "dcerpc_co_cancel", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_co_cancel_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_co_cancel_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_co_cancel_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_co_cancel_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_co_cancel_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.co_cancel",
	.tp_getset = py_dcerpc_co_cancel_getsetters,
	.tp_methods = py_dcerpc_co_cancel_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_co_cancel_new,
};


static PyObject *py_dcerpc_cl_cancel_get_version(PyObject *obj, void *closure)
{
	struct dcerpc_cl_cancel *object = (struct dcerpc_cl_cancel *)pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyInt_FromLong(object->version);
	return py_version;
}

static int py_dcerpc_cl_cancel_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_cl_cancel *object = (struct dcerpc_cl_cancel *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->version = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_cl_cancel_get_id(PyObject *obj, void *closure)
{
	struct dcerpc_cl_cancel *object = (struct dcerpc_cl_cancel *)pytalloc_get_ptr(obj);
	PyObject *py_id;
	py_id = PyInt_FromLong(object->id);
	return py_id;
}

static int py_dcerpc_cl_cancel_set_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_cl_cancel *object = (struct dcerpc_cl_cancel *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->id = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_dcerpc_cl_cancel_getsetters[] = {
	{ discard_const_p(char, "version"), py_dcerpc_cl_cancel_get_version, py_dcerpc_cl_cancel_set_version },
	{ discard_const_p(char, "id"), py_dcerpc_cl_cancel_get_id, py_dcerpc_cl_cancel_set_id },
	{ NULL }
};

static PyObject *py_dcerpc_cl_cancel_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_cl_cancel, type);
}

static PyObject *py_dcerpc_cl_cancel_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_cl_cancel *object = (struct dcerpc_cl_cancel *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_cl_cancel);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_cl_cancel_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_cl_cancel *object = (struct dcerpc_cl_cancel *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_cl_cancel);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_cl_cancel);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_cl_cancel_ndr_print(PyObject *py_obj)
{
	struct dcerpc_cl_cancel *object = (struct dcerpc_cl_cancel *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_cl_cancel, "dcerpc_cl_cancel", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_cl_cancel_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_cl_cancel_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_cl_cancel_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_cl_cancel_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_cl_cancel_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.cl_cancel",
	.tp_getset = py_dcerpc_cl_cancel_getsetters,
	.tp_methods = py_dcerpc_cl_cancel_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_cl_cancel_new,
};


static PyObject *py_dcerpc_cancel_ack_get_version(PyObject *obj, void *closure)
{
	struct dcerpc_cancel_ack *object = (struct dcerpc_cancel_ack *)pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyInt_FromLong(object->version);
	return py_version;
}

static int py_dcerpc_cancel_ack_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_cancel_ack *object = (struct dcerpc_cancel_ack *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->version = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_cancel_ack_get_id(PyObject *obj, void *closure)
{
	struct dcerpc_cancel_ack *object = (struct dcerpc_cancel_ack *)pytalloc_get_ptr(obj);
	PyObject *py_id;
	py_id = PyInt_FromLong(object->id);
	return py_id;
}

static int py_dcerpc_cancel_ack_set_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_cancel_ack *object = (struct dcerpc_cancel_ack *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_cancel_ack_get_server_is_accepting(PyObject *obj, void *closure)
{
	struct dcerpc_cancel_ack *object = (struct dcerpc_cancel_ack *)pytalloc_get_ptr(obj);
	PyObject *py_server_is_accepting;
	py_server_is_accepting = PyInt_FromLong(object->server_is_accepting);
	return py_server_is_accepting;
}

static int py_dcerpc_cancel_ack_set_server_is_accepting(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_cancel_ack *object = (struct dcerpc_cancel_ack *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->server_is_accepting = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_dcerpc_cancel_ack_getsetters[] = {
	{ discard_const_p(char, "version"), py_dcerpc_cancel_ack_get_version, py_dcerpc_cancel_ack_set_version },
	{ discard_const_p(char, "id"), py_dcerpc_cancel_ack_get_id, py_dcerpc_cancel_ack_set_id },
	{ discard_const_p(char, "server_is_accepting"), py_dcerpc_cancel_ack_get_server_is_accepting, py_dcerpc_cancel_ack_set_server_is_accepting },
	{ NULL }
};

static PyObject *py_dcerpc_cancel_ack_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_cancel_ack, type);
}

static PyObject *py_dcerpc_cancel_ack_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_cancel_ack *object = (struct dcerpc_cancel_ack *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_cancel_ack);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_cancel_ack_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_cancel_ack *object = (struct dcerpc_cancel_ack *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_cancel_ack);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_cancel_ack);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_cancel_ack_ndr_print(PyObject *py_obj)
{
	struct dcerpc_cancel_ack *object = (struct dcerpc_cancel_ack *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_cancel_ack, "dcerpc_cancel_ack", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_cancel_ack_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_cancel_ack_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_cancel_ack_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_cancel_ack_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_cancel_ack_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.cancel_ack",
	.tp_getset = py_dcerpc_cancel_ack_getsetters,
	.tp_methods = py_dcerpc_cancel_ack_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_cancel_ack_new,
};


static PyObject *py_dcerpc_fack_get_version(PyObject *obj, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyInt_FromLong(object->version);
	return py_version;
}

static int py_dcerpc_fack_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->version = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_fack_get__pad1(PyObject *obj, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)pytalloc_get_ptr(obj);
	PyObject *py__pad1;
	py__pad1 = PyInt_FromLong(object->_pad1);
	return py__pad1;
}

static int py_dcerpc_fack_set__pad1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->_pad1 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_fack_get_window_size(PyObject *obj, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)pytalloc_get_ptr(obj);
	PyObject *py_window_size;
	py_window_size = PyInt_FromLong(object->window_size);
	return py_window_size;
}

static int py_dcerpc_fack_set_window_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->window_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_fack_get_max_tdsu(PyObject *obj, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)pytalloc_get_ptr(obj);
	PyObject *py_max_tdsu;
	py_max_tdsu = PyInt_FromLong(object->max_tdsu);
	return py_max_tdsu;
}

static int py_dcerpc_fack_set_max_tdsu(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->max_tdsu = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_fack_get_max_frag_size(PyObject *obj, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)pytalloc_get_ptr(obj);
	PyObject *py_max_frag_size;
	py_max_frag_size = PyInt_FromLong(object->max_frag_size);
	return py_max_frag_size;
}

static int py_dcerpc_fack_set_max_frag_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->max_frag_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_fack_get_serial_no(PyObject *obj, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)pytalloc_get_ptr(obj);
	PyObject *py_serial_no;
	py_serial_no = PyInt_FromLong(object->serial_no);
	return py_serial_no;
}

static int py_dcerpc_fack_set_serial_no(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->serial_no = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_fack_get_selack_size(PyObject *obj, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)pytalloc_get_ptr(obj);
	PyObject *py_selack_size;
	py_selack_size = PyInt_FromLong(object->selack_size);
	return py_selack_size;
}

static int py_dcerpc_fack_set_selack_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->selack_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_fack_get_selack(PyObject *obj, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)pytalloc_get_ptr(obj);
	PyObject *py_selack;
	py_selack = PyList_New(object->selack_size);
	if (py_selack == NULL) {
		return NULL;
	}
	{
		int selack_cntr_0;
		for (selack_cntr_0 = 0; selack_cntr_0 < object->selack_size; selack_cntr_0++) {
			PyObject *py_selack_0;
			py_selack_0 = PyInt_FromLong(object->selack[selack_cntr_0]);
			PyList_SetItem(py_selack, selack_cntr_0, py_selack_0);
		}
	}
	return py_selack;
}

static int py_dcerpc_fack_set_selack(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int selack_cntr_0;
		object->selack = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->selack, PyList_GET_SIZE(value));
		if (!object->selack) { return -1;; }
		talloc_set_name_const(object->selack, "ARRAY: object->selack");
		for (selack_cntr_0 = 0; selack_cntr_0 < PyList_GET_SIZE(value); selack_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, selack_cntr_0), return -1;);
			object->selack[selack_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, selack_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_dcerpc_fack_getsetters[] = {
	{ discard_const_p(char, "version"), py_dcerpc_fack_get_version, py_dcerpc_fack_set_version },
	{ discard_const_p(char, "_pad1"), py_dcerpc_fack_get__pad1, py_dcerpc_fack_set__pad1 },
	{ discard_const_p(char, "window_size"), py_dcerpc_fack_get_window_size, py_dcerpc_fack_set_window_size },
	{ discard_const_p(char, "max_tdsu"), py_dcerpc_fack_get_max_tdsu, py_dcerpc_fack_set_max_tdsu },
	{ discard_const_p(char, "max_frag_size"), py_dcerpc_fack_get_max_frag_size, py_dcerpc_fack_set_max_frag_size },
	{ discard_const_p(char, "serial_no"), py_dcerpc_fack_get_serial_no, py_dcerpc_fack_set_serial_no },
	{ discard_const_p(char, "selack_size"), py_dcerpc_fack_get_selack_size, py_dcerpc_fack_set_selack_size },
	{ discard_const_p(char, "selack"), py_dcerpc_fack_get_selack, py_dcerpc_fack_set_selack },
	{ NULL }
};

static PyObject *py_dcerpc_fack_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_fack, type);
}

static PyObject *py_dcerpc_fack_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_fack);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_fack_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_fack);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_fack);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_fack_ndr_print(PyObject *py_obj)
{
	struct dcerpc_fack *object = (struct dcerpc_fack *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_fack, "dcerpc_fack", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_fack_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_fack_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_fack_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_fack_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_fack_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.fack",
	.tp_getset = py_dcerpc_fack_getsetters,
	.tp_methods = py_dcerpc_fack_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_fack_new,
};


static PyObject *py_dcerpc_ack_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_ack, type);
}

static PyObject *py_dcerpc_ack_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_ack *object = (struct dcerpc_ack *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_ack);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_ack_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_ack *object = (struct dcerpc_ack *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_ack);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_ack);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_ack_ndr_print(PyObject *py_obj)
{
	struct dcerpc_ack *object = (struct dcerpc_ack *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_ack, "dcerpc_ack", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_ack_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_ack_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_ack_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_ack_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_ack_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.ack",
	.tp_getset = NULL,
	.tp_methods = py_dcerpc_ack_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_ack_new,
};


static PyObject *py_dcerpc_ping_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_ping, type);
}

static PyObject *py_dcerpc_ping_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_ping *object = (struct dcerpc_ping *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_ping);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_ping_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_ping *object = (struct dcerpc_ping *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_ping);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_ping);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_ping_ndr_print(PyObject *py_obj)
{
	struct dcerpc_ping *object = (struct dcerpc_ping *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_ping, "dcerpc_ping", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_ping_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_ping_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_ping_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_ping_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_ping_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.ping",
	.tp_getset = NULL,
	.tp_methods = py_dcerpc_ping_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_ping_new,
};


static PyObject *py_dcerpc_shutdown_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_shutdown, type);
}

static PyObject *py_dcerpc_shutdown_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_shutdown *object = (struct dcerpc_shutdown *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_shutdown);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_shutdown_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_shutdown *object = (struct dcerpc_shutdown *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_shutdown);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_shutdown);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_shutdown_ndr_print(PyObject *py_obj)
{
	struct dcerpc_shutdown *object = (struct dcerpc_shutdown *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_shutdown, "dcerpc_shutdown", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_shutdown_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_shutdown_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_shutdown_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_shutdown_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_shutdown_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.shutdown",
	.tp_getset = NULL,
	.tp_methods = py_dcerpc_shutdown_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_shutdown_new,
};


static PyObject *py_dcerpc_working_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_working, type);
}

static PyObject *py_dcerpc_working_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_working *object = (struct dcerpc_working *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_working);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_working_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_working *object = (struct dcerpc_working *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_working);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_working);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_working_ndr_print(PyObject *py_obj)
{
	struct dcerpc_working *object = (struct dcerpc_working *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_working, "dcerpc_working", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_working_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_working_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_working_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_working_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_working_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.working",
	.tp_getset = NULL,
	.tp_methods = py_dcerpc_working_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_working_new,
};


static PyObject *py_RTSCookie_get_Cookie(PyObject *obj, void *closure)
{
	struct RTSCookie *object = (struct RTSCookie *)pytalloc_get_ptr(obj);
	PyObject *py_Cookie;
	py_Cookie = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->Cookie);
	return py_Cookie;
}

static int py_RTSCookie_set_Cookie(PyObject *py_obj, PyObject *value, void *closure)
{
	struct RTSCookie *object = (struct RTSCookie *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->Cookie = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_RTSCookie_getsetters[] = {
	{ discard_const_p(char, "Cookie"), py_RTSCookie_get_Cookie, py_RTSCookie_set_Cookie },
	{ NULL }
};

static PyObject *py_RTSCookie_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct RTSCookie, type);
}

static PyObject *py_RTSCookie_ndr_pack(PyObject *py_obj)
{
	struct RTSCookie *object = (struct RTSCookie *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_RTSCookie);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_RTSCookie_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct RTSCookie *object = (struct RTSCookie *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_RTSCookie);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_RTSCookie);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_RTSCookie_ndr_print(PyObject *py_obj)
{
	struct RTSCookie *object = (struct RTSCookie *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_RTSCookie, "RTSCookie", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_RTSCookie_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_RTSCookie_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_RTSCookie_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_RTSCookie_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject RTSCookie_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.RTSCookie",
	.tp_getset = py_RTSCookie_getsetters,
	.tp_methods = py_RTSCookie_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_RTSCookie_new,
};

PyObject *py_import_ClientAddressType(TALLOC_CTX *mem_ctx, int level, union ClientAddressType *in)
{
	PyObject *ret;

	switch (level) {
		case RTS_IPV4:
			ret = PyString_FromStringOrNULL(in->ClientAddressIPV4);
			return ret;

		case RTS_IPV6:
			ret = PyString_FromStringOrNULL(in->ClientAddressIPV6);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union ClientAddressType *py_export_ClientAddressType(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union ClientAddressType *ret = talloc_zero(mem_ctx, union ClientAddressType);
	switch (level) {
		case RTS_IPV4:
			ret->ClientAddressIPV4 = PyString_AS_STRING(in);
			break;

		case RTS_IPV6:
			ret->ClientAddressIPV6 = PyString_AsString(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_ClientAddress_get_AddressType(PyObject *obj, void *closure)
{
	struct ClientAddress *object = (struct ClientAddress *)pytalloc_get_ptr(obj);
	PyObject *py_AddressType;
	py_AddressType = PyInt_FromLong(object->AddressType);
	return py_AddressType;
}

static int py_ClientAddress_set_AddressType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ClientAddress *object = (struct ClientAddress *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->AddressType = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->AddressType = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_ClientAddress_get_ClientAddress(PyObject *obj, void *closure)
{
	struct ClientAddress *object = (struct ClientAddress *)pytalloc_get_ptr(obj);
	PyObject *py_ClientAddress;
	py_ClientAddress = py_import_ClientAddressType(pytalloc_get_mem_ctx(obj), object->AddressType, &object->ClientAddress);
	if (py_ClientAddress == NULL) {
		return NULL;
	}
	return py_ClientAddress;
}

static int py_ClientAddress_set_ClientAddress(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ClientAddress *object = (struct ClientAddress *)pytalloc_get_ptr(py_obj);
	{
		union ClientAddressType *ClientAddress_switch_0;
		ClientAddress_switch_0 = py_export_ClientAddressType(pytalloc_get_mem_ctx(py_obj), object->AddressType, value);
		if (ClientAddress_switch_0 == NULL) {
			return -1;
		}
		object->ClientAddress = *ClientAddress_switch_0;
	}
	return 0;
}

static PyObject *py_ClientAddress_get_Padding(PyObject *obj, void *closure)
{
	struct ClientAddress *object = (struct ClientAddress *)pytalloc_get_ptr(obj);
	PyObject *py_Padding;
	py_Padding = PyList_New(12);
	if (py_Padding == NULL) {
		return NULL;
	}
	{
		int Padding_cntr_0;
		for (Padding_cntr_0 = 0; Padding_cntr_0 < 12; Padding_cntr_0++) {
			PyObject *py_Padding_0;
			py_Padding_0 = PyInt_FromLong(object->Padding[Padding_cntr_0]);
			PyList_SetItem(py_Padding, Padding_cntr_0, py_Padding_0);
		}
	}
	return py_Padding;
}

static int py_ClientAddress_set_Padding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ClientAddress *object = (struct ClientAddress *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Padding_cntr_0;
		for (Padding_cntr_0 = 0; Padding_cntr_0 < PyList_GET_SIZE(value); Padding_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, Padding_cntr_0), return -1;);
			object->Padding[Padding_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, Padding_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_ClientAddress_getsetters[] = {
	{ discard_const_p(char, "AddressType"), py_ClientAddress_get_AddressType, py_ClientAddress_set_AddressType },
	{ discard_const_p(char, "ClientAddress"), py_ClientAddress_get_ClientAddress, py_ClientAddress_set_ClientAddress },
	{ discard_const_p(char, "Padding"), py_ClientAddress_get_Padding, py_ClientAddress_set_Padding },
	{ NULL }
};

static PyObject *py_ClientAddress_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ClientAddress, type);
}

static PyObject *py_ClientAddress_ndr_pack(PyObject *py_obj)
{
	struct ClientAddress *object = (struct ClientAddress *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_ClientAddress);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_ClientAddress_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ClientAddress *object = (struct ClientAddress *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ClientAddress);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ClientAddress);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_ClientAddress_ndr_print(PyObject *py_obj)
{
	struct ClientAddress *object = (struct ClientAddress *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ClientAddress, "ClientAddress", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_ClientAddress_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ClientAddress_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_ClientAddress_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_ClientAddress_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ClientAddress_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.ClientAddress",
	.tp_getset = py_ClientAddress_getsetters,
	.tp_methods = py_ClientAddress_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_ClientAddress_new,
};


static PyObject *py_FlowControlAcknowledgment_get_BytesReceived(PyObject *obj, void *closure)
{
	struct FlowControlAcknowledgment *object = (struct FlowControlAcknowledgment *)pytalloc_get_ptr(obj);
	PyObject *py_BytesReceived;
	py_BytesReceived = PyInt_FromLong(object->BytesReceived);
	return py_BytesReceived;
}

static int py_FlowControlAcknowledgment_set_BytesReceived(PyObject *py_obj, PyObject *value, void *closure)
{
	struct FlowControlAcknowledgment *object = (struct FlowControlAcknowledgment *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->BytesReceived = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_FlowControlAcknowledgment_get_AvailableWindow(PyObject *obj, void *closure)
{
	struct FlowControlAcknowledgment *object = (struct FlowControlAcknowledgment *)pytalloc_get_ptr(obj);
	PyObject *py_AvailableWindow;
	py_AvailableWindow = PyInt_FromLong(object->AvailableWindow);
	return py_AvailableWindow;
}

static int py_FlowControlAcknowledgment_set_AvailableWindow(PyObject *py_obj, PyObject *value, void *closure)
{
	struct FlowControlAcknowledgment *object = (struct FlowControlAcknowledgment *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->AvailableWindow = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_FlowControlAcknowledgment_get_ChannelCookie(PyObject *obj, void *closure)
{
	struct FlowControlAcknowledgment *object = (struct FlowControlAcknowledgment *)pytalloc_get_ptr(obj);
	PyObject *py_ChannelCookie;
	py_ChannelCookie = pytalloc_reference_ex(&RTSCookie_Type, pytalloc_get_mem_ctx(obj), &object->ChannelCookie);
	return py_ChannelCookie;
}

static int py_FlowControlAcknowledgment_set_ChannelCookie(PyObject *py_obj, PyObject *value, void *closure)
{
	struct FlowControlAcknowledgment *object = (struct FlowControlAcknowledgment *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&RTSCookie_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->ChannelCookie = *(struct RTSCookie *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_FlowControlAcknowledgment_getsetters[] = {
	{ discard_const_p(char, "BytesReceived"), py_FlowControlAcknowledgment_get_BytesReceived, py_FlowControlAcknowledgment_set_BytesReceived },
	{ discard_const_p(char, "AvailableWindow"), py_FlowControlAcknowledgment_get_AvailableWindow, py_FlowControlAcknowledgment_set_AvailableWindow },
	{ discard_const_p(char, "ChannelCookie"), py_FlowControlAcknowledgment_get_ChannelCookie, py_FlowControlAcknowledgment_set_ChannelCookie },
	{ NULL }
};

static PyObject *py_FlowControlAcknowledgment_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct FlowControlAcknowledgment, type);
}

static PyObject *py_FlowControlAcknowledgment_ndr_pack(PyObject *py_obj)
{
	struct FlowControlAcknowledgment *object = (struct FlowControlAcknowledgment *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_FlowControlAcknowledgment);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_FlowControlAcknowledgment_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct FlowControlAcknowledgment *object = (struct FlowControlAcknowledgment *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_FlowControlAcknowledgment);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_FlowControlAcknowledgment);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_FlowControlAcknowledgment_ndr_print(PyObject *py_obj)
{
	struct FlowControlAcknowledgment *object = (struct FlowControlAcknowledgment *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_FlowControlAcknowledgment, "FlowControlAcknowledgment", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_FlowControlAcknowledgment_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_FlowControlAcknowledgment_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_FlowControlAcknowledgment_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_FlowControlAcknowledgment_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject FlowControlAcknowledgment_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.FlowControlAcknowledgment",
	.tp_getset = py_FlowControlAcknowledgment_getsetters,
	.tp_methods = py_FlowControlAcknowledgment_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_FlowControlAcknowledgment_new,
};


static PyObject *py_dcerpc_rts_cmd_ReceiveWindowSize_get_ReceiveWindowSize(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_ReceiveWindowSize *object = (struct dcerpc_rts_cmd_ReceiveWindowSize *)pytalloc_get_ptr(obj);
	PyObject *py_ReceiveWindowSize;
	py_ReceiveWindowSize = PyInt_FromLong(object->ReceiveWindowSize);
	return py_ReceiveWindowSize;
}

static int py_dcerpc_rts_cmd_ReceiveWindowSize_set_ReceiveWindowSize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_ReceiveWindowSize *object = (struct dcerpc_rts_cmd_ReceiveWindowSize *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ReceiveWindowSize = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_ReceiveWindowSize_getsetters[] = {
	{ discard_const_p(char, "ReceiveWindowSize"), py_dcerpc_rts_cmd_ReceiveWindowSize_get_ReceiveWindowSize, py_dcerpc_rts_cmd_ReceiveWindowSize_set_ReceiveWindowSize },
	{ NULL }
};

static PyObject *py_dcerpc_rts_cmd_ReceiveWindowSize_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_ReceiveWindowSize, type);
}

static PyObject *py_dcerpc_rts_cmd_ReceiveWindowSize_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_ReceiveWindowSize *object = (struct dcerpc_rts_cmd_ReceiveWindowSize *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_ReceiveWindowSize);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_rts_cmd_ReceiveWindowSize_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_ReceiveWindowSize *object = (struct dcerpc_rts_cmd_ReceiveWindowSize *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_ReceiveWindowSize);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_ReceiveWindowSize);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_ReceiveWindowSize_ndr_print(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_ReceiveWindowSize *object = (struct dcerpc_rts_cmd_ReceiveWindowSize *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_ReceiveWindowSize, "dcerpc_rts_cmd_ReceiveWindowSize", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_ReceiveWindowSize_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_ReceiveWindowSize_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_rts_cmd_ReceiveWindowSize_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_rts_cmd_ReceiveWindowSize_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_ReceiveWindowSize_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.rts_cmd_ReceiveWindowSize",
	.tp_getset = py_dcerpc_rts_cmd_ReceiveWindowSize_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_ReceiveWindowSize_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_rts_cmd_ReceiveWindowSize_new,
};


static PyObject *py_dcerpc_rts_cmd_FlowControlAck_get_Ack(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_FlowControlAck *object = (struct dcerpc_rts_cmd_FlowControlAck *)pytalloc_get_ptr(obj);
	PyObject *py_Ack;
	py_Ack = pytalloc_reference_ex(&FlowControlAcknowledgment_Type, pytalloc_get_mem_ctx(obj), &object->Ack);
	return py_Ack;
}

static int py_dcerpc_rts_cmd_FlowControlAck_set_Ack(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_FlowControlAck *object = (struct dcerpc_rts_cmd_FlowControlAck *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&FlowControlAcknowledgment_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->Ack = *(struct FlowControlAcknowledgment *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_FlowControlAck_getsetters[] = {
	{ discard_const_p(char, "Ack"), py_dcerpc_rts_cmd_FlowControlAck_get_Ack, py_dcerpc_rts_cmd_FlowControlAck_set_Ack },
	{ NULL }
};

static PyObject *py_dcerpc_rts_cmd_FlowControlAck_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_FlowControlAck, type);
}

static PyObject *py_dcerpc_rts_cmd_FlowControlAck_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_FlowControlAck *object = (struct dcerpc_rts_cmd_FlowControlAck *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_FlowControlAck);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_rts_cmd_FlowControlAck_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_FlowControlAck *object = (struct dcerpc_rts_cmd_FlowControlAck *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_FlowControlAck);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_FlowControlAck);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_FlowControlAck_ndr_print(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_FlowControlAck *object = (struct dcerpc_rts_cmd_FlowControlAck *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_FlowControlAck, "dcerpc_rts_cmd_FlowControlAck", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_FlowControlAck_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_FlowControlAck_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_rts_cmd_FlowControlAck_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_rts_cmd_FlowControlAck_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_FlowControlAck_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.rts_cmd_FlowControlAck",
	.tp_getset = py_dcerpc_rts_cmd_FlowControlAck_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_FlowControlAck_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_rts_cmd_FlowControlAck_new,
};


static PyObject *py_dcerpc_rts_cmd_ConnectionTimeout_get_ConnectionTimeout(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_ConnectionTimeout *object = (struct dcerpc_rts_cmd_ConnectionTimeout *)pytalloc_get_ptr(obj);
	PyObject *py_ConnectionTimeout;
	py_ConnectionTimeout = PyInt_FromLong(object->ConnectionTimeout);
	return py_ConnectionTimeout;
}

static int py_dcerpc_rts_cmd_ConnectionTimeout_set_ConnectionTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_ConnectionTimeout *object = (struct dcerpc_rts_cmd_ConnectionTimeout *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ConnectionTimeout = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_ConnectionTimeout_getsetters[] = {
	{ discard_const_p(char, "ConnectionTimeout"), py_dcerpc_rts_cmd_ConnectionTimeout_get_ConnectionTimeout, py_dcerpc_rts_cmd_ConnectionTimeout_set_ConnectionTimeout },
	{ NULL }
};

static PyObject *py_dcerpc_rts_cmd_ConnectionTimeout_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_ConnectionTimeout, type);
}

static PyObject *py_dcerpc_rts_cmd_ConnectionTimeout_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_ConnectionTimeout *object = (struct dcerpc_rts_cmd_ConnectionTimeout *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_ConnectionTimeout);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_rts_cmd_ConnectionTimeout_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_ConnectionTimeout *object = (struct dcerpc_rts_cmd_ConnectionTimeout *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_ConnectionTimeout);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_ConnectionTimeout);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_ConnectionTimeout_ndr_print(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_ConnectionTimeout *object = (struct dcerpc_rts_cmd_ConnectionTimeout *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_ConnectionTimeout, "dcerpc_rts_cmd_ConnectionTimeout", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_ConnectionTimeout_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_ConnectionTimeout_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_rts_cmd_ConnectionTimeout_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_rts_cmd_ConnectionTimeout_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_ConnectionTimeout_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.rts_cmd_ConnectionTimeout",
	.tp_getset = py_dcerpc_rts_cmd_ConnectionTimeout_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_ConnectionTimeout_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_rts_cmd_ConnectionTimeout_new,
};


static PyObject *py_dcerpc_rts_cmd_Cookie_get_Cookie(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_Cookie *object = (struct dcerpc_rts_cmd_Cookie *)pytalloc_get_ptr(obj);
	PyObject *py_Cookie;
	py_Cookie = pytalloc_reference_ex(&RTSCookie_Type, pytalloc_get_mem_ctx(obj), &object->Cookie);
	return py_Cookie;
}

static int py_dcerpc_rts_cmd_Cookie_set_Cookie(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_Cookie *object = (struct dcerpc_rts_cmd_Cookie *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&RTSCookie_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->Cookie = *(struct RTSCookie *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_Cookie_getsetters[] = {
	{ discard_const_p(char, "Cookie"), py_dcerpc_rts_cmd_Cookie_get_Cookie, py_dcerpc_rts_cmd_Cookie_set_Cookie },
	{ NULL }
};

static PyObject *py_dcerpc_rts_cmd_Cookie_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_Cookie, type);
}

static PyObject *py_dcerpc_rts_cmd_Cookie_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_Cookie *object = (struct dcerpc_rts_cmd_Cookie *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_Cookie);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_rts_cmd_Cookie_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_Cookie *object = (struct dcerpc_rts_cmd_Cookie *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_Cookie);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_Cookie);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_Cookie_ndr_print(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_Cookie *object = (struct dcerpc_rts_cmd_Cookie *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_Cookie, "dcerpc_rts_cmd_Cookie", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_Cookie_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_Cookie_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_rts_cmd_Cookie_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_rts_cmd_Cookie_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_Cookie_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.rts_cmd_Cookie",
	.tp_getset = py_dcerpc_rts_cmd_Cookie_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_Cookie_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_rts_cmd_Cookie_new,
};


static PyObject *py_dcerpc_rts_cmd_ChannelLifetime_get_ChannelLifetime(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_ChannelLifetime *object = (struct dcerpc_rts_cmd_ChannelLifetime *)pytalloc_get_ptr(obj);
	PyObject *py_ChannelLifetime;
	py_ChannelLifetime = PyInt_FromLong(object->ChannelLifetime);
	return py_ChannelLifetime;
}

static int py_dcerpc_rts_cmd_ChannelLifetime_set_ChannelLifetime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_ChannelLifetime *object = (struct dcerpc_rts_cmd_ChannelLifetime *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ChannelLifetime = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_ChannelLifetime_getsetters[] = {
	{ discard_const_p(char, "ChannelLifetime"), py_dcerpc_rts_cmd_ChannelLifetime_get_ChannelLifetime, py_dcerpc_rts_cmd_ChannelLifetime_set_ChannelLifetime },
	{ NULL }
};

static PyObject *py_dcerpc_rts_cmd_ChannelLifetime_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_ChannelLifetime, type);
}

static PyObject *py_dcerpc_rts_cmd_ChannelLifetime_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_ChannelLifetime *object = (struct dcerpc_rts_cmd_ChannelLifetime *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_ChannelLifetime);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_rts_cmd_ChannelLifetime_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_ChannelLifetime *object = (struct dcerpc_rts_cmd_ChannelLifetime *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_ChannelLifetime);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_ChannelLifetime);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_ChannelLifetime_ndr_print(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_ChannelLifetime *object = (struct dcerpc_rts_cmd_ChannelLifetime *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_ChannelLifetime, "dcerpc_rts_cmd_ChannelLifetime", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_ChannelLifetime_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_ChannelLifetime_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_rts_cmd_ChannelLifetime_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_rts_cmd_ChannelLifetime_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_ChannelLifetime_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.rts_cmd_ChannelLifetime",
	.tp_getset = py_dcerpc_rts_cmd_ChannelLifetime_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_ChannelLifetime_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_rts_cmd_ChannelLifetime_new,
};


static PyObject *py_dcerpc_rts_cmd_ClientKeepalive_get_ClientKeepalive(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_ClientKeepalive *object = (struct dcerpc_rts_cmd_ClientKeepalive *)pytalloc_get_ptr(obj);
	PyObject *py_ClientKeepalive;
	py_ClientKeepalive = PyInt_FromLong(object->ClientKeepalive);
	return py_ClientKeepalive;
}

static int py_dcerpc_rts_cmd_ClientKeepalive_set_ClientKeepalive(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_ClientKeepalive *object = (struct dcerpc_rts_cmd_ClientKeepalive *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ClientKeepalive = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_ClientKeepalive_getsetters[] = {
	{ discard_const_p(char, "ClientKeepalive"), py_dcerpc_rts_cmd_ClientKeepalive_get_ClientKeepalive, py_dcerpc_rts_cmd_ClientKeepalive_set_ClientKeepalive },
	{ NULL }
};

static PyObject *py_dcerpc_rts_cmd_ClientKeepalive_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_ClientKeepalive, type);
}

static PyObject *py_dcerpc_rts_cmd_ClientKeepalive_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_ClientKeepalive *object = (struct dcerpc_rts_cmd_ClientKeepalive *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_ClientKeepalive);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_rts_cmd_ClientKeepalive_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_ClientKeepalive *object = (struct dcerpc_rts_cmd_ClientKeepalive *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_ClientKeepalive);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_ClientKeepalive);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_ClientKeepalive_ndr_print(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_ClientKeepalive *object = (struct dcerpc_rts_cmd_ClientKeepalive *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_ClientKeepalive, "dcerpc_rts_cmd_ClientKeepalive", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_ClientKeepalive_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_ClientKeepalive_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_rts_cmd_ClientKeepalive_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_rts_cmd_ClientKeepalive_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_ClientKeepalive_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.rts_cmd_ClientKeepalive",
	.tp_getset = py_dcerpc_rts_cmd_ClientKeepalive_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_ClientKeepalive_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_rts_cmd_ClientKeepalive_new,
};


static PyObject *py_dcerpc_rts_cmd_Version_get_Version(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_Version *object = (struct dcerpc_rts_cmd_Version *)pytalloc_get_ptr(obj);
	PyObject *py_Version;
	py_Version = PyInt_FromLong(object->Version);
	return py_Version;
}

static int py_dcerpc_rts_cmd_Version_set_Version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_Version *object = (struct dcerpc_rts_cmd_Version *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Version = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_Version_getsetters[] = {
	{ discard_const_p(char, "Version"), py_dcerpc_rts_cmd_Version_get_Version, py_dcerpc_rts_cmd_Version_set_Version },
	{ NULL }
};

static PyObject *py_dcerpc_rts_cmd_Version_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_Version, type);
}

static PyObject *py_dcerpc_rts_cmd_Version_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_Version *object = (struct dcerpc_rts_cmd_Version *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_Version);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_rts_cmd_Version_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_Version *object = (struct dcerpc_rts_cmd_Version *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_Version);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_Version);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_Version_ndr_print(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_Version *object = (struct dcerpc_rts_cmd_Version *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_Version, "dcerpc_rts_cmd_Version", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_Version_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_Version_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_rts_cmd_Version_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_rts_cmd_Version_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_Version_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.rts_cmd_Version",
	.tp_getset = py_dcerpc_rts_cmd_Version_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_Version_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_rts_cmd_Version_new,
};


static PyObject *py_dcerpc_rts_cmd_Empty_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_Empty, type);
}

static PyObject *py_dcerpc_rts_cmd_Empty_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_Empty *object = (struct dcerpc_rts_cmd_Empty *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_Empty);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_rts_cmd_Empty_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_Empty *object = (struct dcerpc_rts_cmd_Empty *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_Empty);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_Empty);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_Empty_ndr_print(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_Empty *object = (struct dcerpc_rts_cmd_Empty *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_Empty, "dcerpc_rts_cmd_Empty", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_Empty_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_Empty_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_rts_cmd_Empty_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_rts_cmd_Empty_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_Empty_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.rts_cmd_Empty",
	.tp_getset = NULL,
	.tp_methods = py_dcerpc_rts_cmd_Empty_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_rts_cmd_Empty_new,
};


static PyObject *py_dcerpc_rts_cmd_Padding_get_ConformanceCount(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_Padding *object = (struct dcerpc_rts_cmd_Padding *)pytalloc_get_ptr(obj);
	PyObject *py_ConformanceCount;
	py_ConformanceCount = PyInt_FromLong(object->ConformanceCount);
	return py_ConformanceCount;
}

static int py_dcerpc_rts_cmd_Padding_set_ConformanceCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_Padding *object = (struct dcerpc_rts_cmd_Padding *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ConformanceCount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_rts_cmd_Padding_get_Padding(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_Padding *object = (struct dcerpc_rts_cmd_Padding *)pytalloc_get_ptr(obj);
	PyObject *py_Padding;
	py_Padding = PyList_New(object->ConformanceCount);
	if (py_Padding == NULL) {
		return NULL;
	}
	{
		int Padding_cntr_0;
		for (Padding_cntr_0 = 0; Padding_cntr_0 < object->ConformanceCount; Padding_cntr_0++) {
			PyObject *py_Padding_0;
			py_Padding_0 = PyInt_FromLong(object->Padding[Padding_cntr_0]);
			PyList_SetItem(py_Padding, Padding_cntr_0, py_Padding_0);
		}
	}
	return py_Padding;
}

static int py_dcerpc_rts_cmd_Padding_set_Padding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_Padding *object = (struct dcerpc_rts_cmd_Padding *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Padding_cntr_0;
		object->Padding = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->Padding, PyList_GET_SIZE(value));
		if (!object->Padding) { return -1;; }
		talloc_set_name_const(object->Padding, "ARRAY: object->Padding");
		for (Padding_cntr_0 = 0; Padding_cntr_0 < PyList_GET_SIZE(value); Padding_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, Padding_cntr_0), return -1;);
			object->Padding[Padding_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, Padding_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_Padding_getsetters[] = {
	{ discard_const_p(char, "ConformanceCount"), py_dcerpc_rts_cmd_Padding_get_ConformanceCount, py_dcerpc_rts_cmd_Padding_set_ConformanceCount },
	{ discard_const_p(char, "Padding"), py_dcerpc_rts_cmd_Padding_get_Padding, py_dcerpc_rts_cmd_Padding_set_Padding },
	{ NULL }
};

static PyObject *py_dcerpc_rts_cmd_Padding_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_Padding, type);
}

static PyObject *py_dcerpc_rts_cmd_Padding_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_Padding *object = (struct dcerpc_rts_cmd_Padding *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_Padding);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_rts_cmd_Padding_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_Padding *object = (struct dcerpc_rts_cmd_Padding *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_Padding);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_Padding);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_Padding_ndr_print(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_Padding *object = (struct dcerpc_rts_cmd_Padding *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_Padding, "dcerpc_rts_cmd_Padding", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_Padding_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_Padding_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_rts_cmd_Padding_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_rts_cmd_Padding_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_Padding_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.rts_cmd_Padding",
	.tp_getset = py_dcerpc_rts_cmd_Padding_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_Padding_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_rts_cmd_Padding_new,
};


static PyObject *py_dcerpc_rts_cmd_NegativeANCE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_NegativeANCE, type);
}

static PyObject *py_dcerpc_rts_cmd_NegativeANCE_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_NegativeANCE *object = (struct dcerpc_rts_cmd_NegativeANCE *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_NegativeANCE);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_rts_cmd_NegativeANCE_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_NegativeANCE *object = (struct dcerpc_rts_cmd_NegativeANCE *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_NegativeANCE);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_NegativeANCE);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_NegativeANCE_ndr_print(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_NegativeANCE *object = (struct dcerpc_rts_cmd_NegativeANCE *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_NegativeANCE, "dcerpc_rts_cmd_NegativeANCE", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_NegativeANCE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_NegativeANCE_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_rts_cmd_NegativeANCE_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_rts_cmd_NegativeANCE_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_NegativeANCE_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.rts_cmd_NegativeANCE",
	.tp_getset = NULL,
	.tp_methods = py_dcerpc_rts_cmd_NegativeANCE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_rts_cmd_NegativeANCE_new,
};


static PyObject *py_dcerpc_rts_cmd_ANCE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_ANCE, type);
}

static PyObject *py_dcerpc_rts_cmd_ANCE_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_ANCE *object = (struct dcerpc_rts_cmd_ANCE *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_ANCE);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_rts_cmd_ANCE_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_ANCE *object = (struct dcerpc_rts_cmd_ANCE *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_ANCE);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_ANCE);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_ANCE_ndr_print(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_ANCE *object = (struct dcerpc_rts_cmd_ANCE *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_ANCE, "dcerpc_rts_cmd_ANCE", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_ANCE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_ANCE_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_rts_cmd_ANCE_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_rts_cmd_ANCE_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_ANCE_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.rts_cmd_ANCE",
	.tp_getset = NULL,
	.tp_methods = py_dcerpc_rts_cmd_ANCE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_rts_cmd_ANCE_new,
};


static PyObject *py_dcerpc_rts_cmd_ClientAddress_get_ClientAddress(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_ClientAddress *object = (struct dcerpc_rts_cmd_ClientAddress *)pytalloc_get_ptr(obj);
	PyObject *py_ClientAddress;
	py_ClientAddress = pytalloc_reference_ex(&ClientAddress_Type, pytalloc_get_mem_ctx(obj), &object->ClientAddress);
	return py_ClientAddress;
}

static int py_dcerpc_rts_cmd_ClientAddress_set_ClientAddress(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_ClientAddress *object = (struct dcerpc_rts_cmd_ClientAddress *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&ClientAddress_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->ClientAddress = *(struct ClientAddress *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_ClientAddress_getsetters[] = {
	{ discard_const_p(char, "ClientAddress"), py_dcerpc_rts_cmd_ClientAddress_get_ClientAddress, py_dcerpc_rts_cmd_ClientAddress_set_ClientAddress },
	{ NULL }
};

static PyObject *py_dcerpc_rts_cmd_ClientAddress_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_ClientAddress, type);
}

static PyObject *py_dcerpc_rts_cmd_ClientAddress_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_ClientAddress *object = (struct dcerpc_rts_cmd_ClientAddress *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_ClientAddress);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_rts_cmd_ClientAddress_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_ClientAddress *object = (struct dcerpc_rts_cmd_ClientAddress *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_ClientAddress);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_ClientAddress);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_ClientAddress_ndr_print(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_ClientAddress *object = (struct dcerpc_rts_cmd_ClientAddress *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_ClientAddress, "dcerpc_rts_cmd_ClientAddress", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_ClientAddress_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_ClientAddress_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_rts_cmd_ClientAddress_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_rts_cmd_ClientAddress_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_ClientAddress_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.rts_cmd_ClientAddress",
	.tp_getset = py_dcerpc_rts_cmd_ClientAddress_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_ClientAddress_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_rts_cmd_ClientAddress_new,
};


static PyObject *py_dcerpc_rts_cmd_AssociationGroupId_get_AssociationGroupId(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_AssociationGroupId *object = (struct dcerpc_rts_cmd_AssociationGroupId *)pytalloc_get_ptr(obj);
	PyObject *py_AssociationGroupId;
	py_AssociationGroupId = pytalloc_reference_ex(&RTSCookie_Type, pytalloc_get_mem_ctx(obj), &object->AssociationGroupId);
	return py_AssociationGroupId;
}

static int py_dcerpc_rts_cmd_AssociationGroupId_set_AssociationGroupId(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_AssociationGroupId *object = (struct dcerpc_rts_cmd_AssociationGroupId *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&RTSCookie_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->AssociationGroupId = *(struct RTSCookie *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_AssociationGroupId_getsetters[] = {
	{ discard_const_p(char, "AssociationGroupId"), py_dcerpc_rts_cmd_AssociationGroupId_get_AssociationGroupId, py_dcerpc_rts_cmd_AssociationGroupId_set_AssociationGroupId },
	{ NULL }
};

static PyObject *py_dcerpc_rts_cmd_AssociationGroupId_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_AssociationGroupId, type);
}

static PyObject *py_dcerpc_rts_cmd_AssociationGroupId_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_AssociationGroupId *object = (struct dcerpc_rts_cmd_AssociationGroupId *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_AssociationGroupId);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_rts_cmd_AssociationGroupId_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_AssociationGroupId *object = (struct dcerpc_rts_cmd_AssociationGroupId *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_AssociationGroupId);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_AssociationGroupId);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_AssociationGroupId_ndr_print(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_AssociationGroupId *object = (struct dcerpc_rts_cmd_AssociationGroupId *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_AssociationGroupId, "dcerpc_rts_cmd_AssociationGroupId", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_AssociationGroupId_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_AssociationGroupId_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_rts_cmd_AssociationGroupId_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_rts_cmd_AssociationGroupId_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_AssociationGroupId_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.rts_cmd_AssociationGroupId",
	.tp_getset = py_dcerpc_rts_cmd_AssociationGroupId_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_AssociationGroupId_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_rts_cmd_AssociationGroupId_new,
};


static PyObject *py_dcerpc_rts_cmd_Destination_get_ForwardDestination(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_Destination *object = (struct dcerpc_rts_cmd_Destination *)pytalloc_get_ptr(obj);
	PyObject *py_ForwardDestination;
	py_ForwardDestination = PyInt_FromLong(object->ForwardDestination);
	return py_ForwardDestination;
}

static int py_dcerpc_rts_cmd_Destination_set_ForwardDestination(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_Destination *object = (struct dcerpc_rts_cmd_Destination *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->ForwardDestination = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->ForwardDestination = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_Destination_getsetters[] = {
	{ discard_const_p(char, "ForwardDestination"), py_dcerpc_rts_cmd_Destination_get_ForwardDestination, py_dcerpc_rts_cmd_Destination_set_ForwardDestination },
	{ NULL }
};

static PyObject *py_dcerpc_rts_cmd_Destination_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_Destination, type);
}

static PyObject *py_dcerpc_rts_cmd_Destination_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_Destination *object = (struct dcerpc_rts_cmd_Destination *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_Destination);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_rts_cmd_Destination_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_Destination *object = (struct dcerpc_rts_cmd_Destination *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_Destination);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_Destination);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_Destination_ndr_print(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_Destination *object = (struct dcerpc_rts_cmd_Destination *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_Destination, "dcerpc_rts_cmd_Destination", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_Destination_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_Destination_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_rts_cmd_Destination_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_rts_cmd_Destination_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_Destination_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.rts_cmd_Destination",
	.tp_getset = py_dcerpc_rts_cmd_Destination_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_Destination_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_rts_cmd_Destination_new,
};


static PyObject *py_dcerpc_rts_cmd_PingTrafficSentNotify_get_PingTrafficSent(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_PingTrafficSentNotify *object = (struct dcerpc_rts_cmd_PingTrafficSentNotify *)pytalloc_get_ptr(obj);
	PyObject *py_PingTrafficSent;
	py_PingTrafficSent = PyInt_FromLong(object->PingTrafficSent);
	return py_PingTrafficSent;
}

static int py_dcerpc_rts_cmd_PingTrafficSentNotify_set_PingTrafficSent(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_PingTrafficSentNotify *object = (struct dcerpc_rts_cmd_PingTrafficSentNotify *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->PingTrafficSent = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_PingTrafficSentNotify_getsetters[] = {
	{ discard_const_p(char, "PingTrafficSent"), py_dcerpc_rts_cmd_PingTrafficSentNotify_get_PingTrafficSent, py_dcerpc_rts_cmd_PingTrafficSentNotify_set_PingTrafficSent },
	{ NULL }
};

static PyObject *py_dcerpc_rts_cmd_PingTrafficSentNotify_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_PingTrafficSentNotify, type);
}

static PyObject *py_dcerpc_rts_cmd_PingTrafficSentNotify_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_PingTrafficSentNotify *object = (struct dcerpc_rts_cmd_PingTrafficSentNotify *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_PingTrafficSentNotify);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_rts_cmd_PingTrafficSentNotify_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_PingTrafficSentNotify *object = (struct dcerpc_rts_cmd_PingTrafficSentNotify *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_PingTrafficSentNotify);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_PingTrafficSentNotify);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_PingTrafficSentNotify_ndr_print(PyObject *py_obj)
{
	struct dcerpc_rts_cmd_PingTrafficSentNotify *object = (struct dcerpc_rts_cmd_PingTrafficSentNotify *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_PingTrafficSentNotify, "dcerpc_rts_cmd_PingTrafficSentNotify", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_PingTrafficSentNotify_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_PingTrafficSentNotify_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_rts_cmd_PingTrafficSentNotify_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_rts_cmd_PingTrafficSentNotify_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_PingTrafficSentNotify_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.rts_cmd_PingTrafficSentNotify",
	.tp_getset = py_dcerpc_rts_cmd_PingTrafficSentNotify_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_PingTrafficSentNotify_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_rts_cmd_PingTrafficSentNotify_new,
};

PyObject *py_import_dcerpc_rts_cmds(TALLOC_CTX *mem_ctx, int level, union dcerpc_rts_cmds *in)
{
	PyObject *ret;

	switch (level) {
		case 0x0:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_ReceiveWindowSize_Type, mem_ctx, &in->ReceiveWindowSize);
			return ret;

		case 0x1:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_FlowControlAck_Type, mem_ctx, &in->FlowControlAck);
			return ret;

		case 0x2:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_ConnectionTimeout_Type, mem_ctx, &in->ConnectionTimeout);
			return ret;

		case 0x3:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_Cookie_Type, mem_ctx, &in->Cookie);
			return ret;

		case 0x4:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_ChannelLifetime_Type, mem_ctx, &in->ChannelLifetime);
			return ret;

		case 0x5:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_ClientKeepalive_Type, mem_ctx, &in->ClientKeepalive);
			return ret;

		case 0x6:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_Version_Type, mem_ctx, &in->Version);
			return ret;

		case 0x7:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_Empty_Type, mem_ctx, &in->Empty);
			return ret;

		case 0x8:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_Padding_Type, mem_ctx, &in->Padding);
			return ret;

		case 0x9:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_NegativeANCE_Type, mem_ctx, &in->NegativeANCE);
			return ret;

		case 0xA:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_ANCE_Type, mem_ctx, &in->ANCE);
			return ret;

		case 0xB:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_ClientAddress_Type, mem_ctx, &in->ClientAddress);
			return ret;

		case 0xC:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_AssociationGroupId_Type, mem_ctx, &in->AssociationGroupId);
			return ret;

		case 0xD:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_Destination_Type, mem_ctx, &in->Destination);
			return ret;

		case 0xE:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_PingTrafficSentNotify_Type, mem_ctx, &in->PingTrafficSentNotify);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union dcerpc_rts_cmds *py_export_dcerpc_rts_cmds(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union dcerpc_rts_cmds *ret = talloc_zero(mem_ctx, union dcerpc_rts_cmds);
	switch (level) {
		case 0x0:
			PY_CHECK_TYPE(&dcerpc_rts_cmd_ReceiveWindowSize_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ReceiveWindowSize = *(struct dcerpc_rts_cmd_ReceiveWindowSize *)pytalloc_get_ptr(in);
			break;

		case 0x1:
			PY_CHECK_TYPE(&dcerpc_rts_cmd_FlowControlAck_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->FlowControlAck = *(struct dcerpc_rts_cmd_FlowControlAck *)pytalloc_get_ptr(in);
			break;

		case 0x2:
			PY_CHECK_TYPE(&dcerpc_rts_cmd_ConnectionTimeout_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ConnectionTimeout = *(struct dcerpc_rts_cmd_ConnectionTimeout *)pytalloc_get_ptr(in);
			break;

		case 0x3:
			PY_CHECK_TYPE(&dcerpc_rts_cmd_Cookie_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->Cookie = *(struct dcerpc_rts_cmd_Cookie *)pytalloc_get_ptr(in);
			break;

		case 0x4:
			PY_CHECK_TYPE(&dcerpc_rts_cmd_ChannelLifetime_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ChannelLifetime = *(struct dcerpc_rts_cmd_ChannelLifetime *)pytalloc_get_ptr(in);
			break;

		case 0x5:
			PY_CHECK_TYPE(&dcerpc_rts_cmd_ClientKeepalive_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ClientKeepalive = *(struct dcerpc_rts_cmd_ClientKeepalive *)pytalloc_get_ptr(in);
			break;

		case 0x6:
			PY_CHECK_TYPE(&dcerpc_rts_cmd_Version_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->Version = *(struct dcerpc_rts_cmd_Version *)pytalloc_get_ptr(in);
			break;

		case 0x7:
			PY_CHECK_TYPE(&dcerpc_rts_cmd_Empty_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->Empty = *(struct dcerpc_rts_cmd_Empty *)pytalloc_get_ptr(in);
			break;

		case 0x8:
			PY_CHECK_TYPE(&dcerpc_rts_cmd_Padding_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->Padding = *(struct dcerpc_rts_cmd_Padding *)pytalloc_get_ptr(in);
			break;

		case 0x9:
			PY_CHECK_TYPE(&dcerpc_rts_cmd_NegativeANCE_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->NegativeANCE = *(struct dcerpc_rts_cmd_NegativeANCE *)pytalloc_get_ptr(in);
			break;

		case 0xA:
			PY_CHECK_TYPE(&dcerpc_rts_cmd_ANCE_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ANCE = *(struct dcerpc_rts_cmd_ANCE *)pytalloc_get_ptr(in);
			break;

		case 0xB:
			PY_CHECK_TYPE(&dcerpc_rts_cmd_ClientAddress_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ClientAddress = *(struct dcerpc_rts_cmd_ClientAddress *)pytalloc_get_ptr(in);
			break;

		case 0xC:
			PY_CHECK_TYPE(&dcerpc_rts_cmd_AssociationGroupId_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->AssociationGroupId = *(struct dcerpc_rts_cmd_AssociationGroupId *)pytalloc_get_ptr(in);
			break;

		case 0xD:
			PY_CHECK_TYPE(&dcerpc_rts_cmd_Destination_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->Destination = *(struct dcerpc_rts_cmd_Destination *)pytalloc_get_ptr(in);
			break;

		case 0xE:
			PY_CHECK_TYPE(&dcerpc_rts_cmd_PingTrafficSentNotify_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->PingTrafficSentNotify = *(struct dcerpc_rts_cmd_PingTrafficSentNotify *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_dcerpc_rts_cmd_get_CommandType(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd *object = (struct dcerpc_rts_cmd *)pytalloc_get_ptr(obj);
	PyObject *py_CommandType;
	py_CommandType = PyInt_FromLong(object->CommandType);
	return py_CommandType;
}

static int py_dcerpc_rts_cmd_set_CommandType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd *object = (struct dcerpc_rts_cmd *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->CommandType = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_rts_cmd_get_Command(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd *object = (struct dcerpc_rts_cmd *)pytalloc_get_ptr(obj);
	PyObject *py_Command;
	py_Command = py_import_dcerpc_rts_cmds(pytalloc_get_mem_ctx(obj), object->CommandType, &object->Command);
	if (py_Command == NULL) {
		return NULL;
	}
	return py_Command;
}

static int py_dcerpc_rts_cmd_set_Command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd *object = (struct dcerpc_rts_cmd *)pytalloc_get_ptr(py_obj);
	{
		union dcerpc_rts_cmds *Command_switch_0;
		Command_switch_0 = py_export_dcerpc_rts_cmds(pytalloc_get_mem_ctx(py_obj), object->CommandType, value);
		if (Command_switch_0 == NULL) {
			return -1;
		}
		object->Command = *Command_switch_0;
	}
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_getsetters[] = {
	{ discard_const_p(char, "CommandType"), py_dcerpc_rts_cmd_get_CommandType, py_dcerpc_rts_cmd_set_CommandType },
	{ discard_const_p(char, "Command"), py_dcerpc_rts_cmd_get_Command, py_dcerpc_rts_cmd_set_Command },
	{ NULL }
};

static PyObject *py_dcerpc_rts_cmd_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd, type);
}

static PyObject *py_dcerpc_rts_cmd_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_rts_cmd *object = (struct dcerpc_rts_cmd *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_rts_cmd_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd *object = (struct dcerpc_rts_cmd *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_ndr_print(PyObject *py_obj)
{
	struct dcerpc_rts_cmd *object = (struct dcerpc_rts_cmd *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd, "dcerpc_rts_cmd", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_rts_cmd_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_rts_cmd_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.rts_cmd",
	.tp_getset = py_dcerpc_rts_cmd_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_rts_cmd_new,
};


static PyObject *py_dcerpc_rts_get_Flags(PyObject *obj, void *closure)
{
	struct dcerpc_rts *object = (struct dcerpc_rts *)pytalloc_get_ptr(obj);
	PyObject *py_Flags;
	py_Flags = PyInt_FromLong(object->Flags);
	return py_Flags;
}

static int py_dcerpc_rts_set_Flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts *object = (struct dcerpc_rts *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->Flags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->Flags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_dcerpc_rts_get_NumberOfCommands(PyObject *obj, void *closure)
{
	struct dcerpc_rts *object = (struct dcerpc_rts *)pytalloc_get_ptr(obj);
	PyObject *py_NumberOfCommands;
	py_NumberOfCommands = PyInt_FromLong(object->NumberOfCommands);
	return py_NumberOfCommands;
}

static int py_dcerpc_rts_set_NumberOfCommands(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts *object = (struct dcerpc_rts *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->NumberOfCommands = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dcerpc_rts_get_Commands(PyObject *obj, void *closure)
{
	struct dcerpc_rts *object = (struct dcerpc_rts *)pytalloc_get_ptr(obj);
	PyObject *py_Commands;
	py_Commands = PyList_New(object->NumberOfCommands);
	if (py_Commands == NULL) {
		return NULL;
	}
	{
		int Commands_cntr_0;
		for (Commands_cntr_0 = 0; Commands_cntr_0 < object->NumberOfCommands; Commands_cntr_0++) {
			PyObject *py_Commands_0;
			py_Commands_0 = pytalloc_reference_ex(&dcerpc_rts_cmd_Type, object->Commands, &object->Commands[Commands_cntr_0]);
			PyList_SetItem(py_Commands, Commands_cntr_0, py_Commands_0);
		}
	}
	return py_Commands;
}

static int py_dcerpc_rts_set_Commands(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts *object = (struct dcerpc_rts *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Commands_cntr_0;
		object->Commands = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->Commands, PyList_GET_SIZE(value));
		if (!object->Commands) { return -1;; }
		talloc_set_name_const(object->Commands, "ARRAY: object->Commands");
		for (Commands_cntr_0 = 0; Commands_cntr_0 < PyList_GET_SIZE(value); Commands_cntr_0++) {
			PY_CHECK_TYPE(&dcerpc_rts_cmd_Type, PyList_GET_ITEM(value, Commands_cntr_0), return -1;);
			if (talloc_reference(object->Commands, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, Commands_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->Commands[Commands_cntr_0] = *(struct dcerpc_rts_cmd *)pytalloc_get_ptr(PyList_GET_ITEM(value, Commands_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_dcerpc_rts_getsetters[] = {
	{ discard_const_p(char, "Flags"), py_dcerpc_rts_get_Flags, py_dcerpc_rts_set_Flags },
	{ discard_const_p(char, "NumberOfCommands"), py_dcerpc_rts_get_NumberOfCommands, py_dcerpc_rts_set_NumberOfCommands },
	{ discard_const_p(char, "Commands"), py_dcerpc_rts_get_Commands, py_dcerpc_rts_set_Commands },
	{ NULL }
};

static PyObject *py_dcerpc_rts_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts, type);
}

static PyObject *py_dcerpc_rts_ndr_pack(PyObject *py_obj)
{
	struct dcerpc_rts *object = (struct dcerpc_rts *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dcerpc_rts_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts *object = (struct dcerpc_rts *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_ndr_print(PyObject *py_obj)
{
	struct dcerpc_rts *object = (struct dcerpc_rts *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts, "dcerpc_rts", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dcerpc_rts_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dcerpc_rts_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.rts",
	.tp_getset = py_dcerpc_rts_getsetters,
	.tp_methods = py_dcerpc_rts_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_dcerpc_rts_new,
};

PyObject *py_import_dcerpc_payload(TALLOC_CTX *mem_ctx, int level, union dcerpc_payload *in)
{
	PyObject *ret;

	switch (level) {
		case DCERPC_PKT_REQUEST:
			ret = pytalloc_reference_ex(&dcerpc_request_Type, mem_ctx, &in->request);
			return ret;

		case DCERPC_PKT_PING:
			ret = pytalloc_reference_ex(&dcerpc_ping_Type, mem_ctx, &in->ping);
			return ret;

		case DCERPC_PKT_RESPONSE:
			ret = pytalloc_reference_ex(&dcerpc_response_Type, mem_ctx, &in->response);
			return ret;

		case DCERPC_PKT_FAULT:
			ret = pytalloc_reference_ex(&dcerpc_fault_Type, mem_ctx, &in->fault);
			return ret;

		case DCERPC_PKT_WORKING:
			ret = pytalloc_reference_ex(&dcerpc_working_Type, mem_ctx, &in->working);
			return ret;

		case DCERPC_PKT_NOCALL:
			ret = pytalloc_reference_ex(&dcerpc_fack_Type, mem_ctx, &in->nocall);
			return ret;

		case DCERPC_PKT_REJECT:
			ret = pytalloc_reference_ex(&dcerpc_fault_Type, mem_ctx, &in->reject);
			return ret;

		case DCERPC_PKT_ACK:
			ret = pytalloc_reference_ex(&dcerpc_ack_Type, mem_ctx, &in->ack);
			return ret;

		case DCERPC_PKT_CL_CANCEL:
			ret = pytalloc_reference_ex(&dcerpc_cl_cancel_Type, mem_ctx, &in->cl_cancel);
			return ret;

		case DCERPC_PKT_FACK:
			ret = pytalloc_reference_ex(&dcerpc_fack_Type, mem_ctx, &in->fack);
			return ret;

		case DCERPC_PKT_CANCEL_ACK:
			ret = pytalloc_reference_ex(&dcerpc_cancel_ack_Type, mem_ctx, &in->cancel_ack);
			return ret;

		case DCERPC_PKT_BIND:
			ret = pytalloc_reference_ex(&dcerpc_bind_Type, mem_ctx, &in->bind);
			return ret;

		case DCERPC_PKT_BIND_ACK:
			ret = pytalloc_reference_ex(&dcerpc_bind_ack_Type, mem_ctx, &in->bind_ack);
			return ret;

		case DCERPC_PKT_BIND_NAK:
			ret = pytalloc_reference_ex(&dcerpc_bind_nak_Type, mem_ctx, &in->bind_nak);
			return ret;

		case DCERPC_PKT_ALTER:
			ret = pytalloc_reference_ex(&dcerpc_bind_Type, mem_ctx, &in->alter);
			return ret;

		case DCERPC_PKT_ALTER_RESP:
			ret = pytalloc_reference_ex(&dcerpc_bind_ack_Type, mem_ctx, &in->alter_resp);
			return ret;

		case DCERPC_PKT_SHUTDOWN:
			ret = pytalloc_reference_ex(&dcerpc_shutdown_Type, mem_ctx, &in->shutdown);
			return ret;

		case DCERPC_PKT_CO_CANCEL:
			ret = pytalloc_reference_ex(&dcerpc_co_cancel_Type, mem_ctx, &in->co_cancel);
			return ret;

		case DCERPC_PKT_ORPHANED:
			ret = pytalloc_reference_ex(&dcerpc_orphaned_Type, mem_ctx, &in->orphaned);
			return ret;

		case DCERPC_PKT_AUTH3:
			ret = pytalloc_reference_ex(&dcerpc_auth3_Type, mem_ctx, &in->auth3);
			return ret;

		case DCERPC_PKT_RTS:
			ret = pytalloc_reference_ex(&dcerpc_rts_Type, mem_ctx, &in->rts);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union dcerpc_payload *py_export_dcerpc_payload(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union dcerpc_payload *ret = talloc_zero(mem_ctx, union dcerpc_payload);
	switch (level) {
		case DCERPC_PKT_REQUEST:
			PY_CHECK_TYPE(&dcerpc_request_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->request = *(struct dcerpc_request *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_PING:
			PY_CHECK_TYPE(&dcerpc_ping_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ping = *(struct dcerpc_ping *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_RESPONSE:
			PY_CHECK_TYPE(&dcerpc_response_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->response = *(struct dcerpc_response *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_FAULT:
			PY_CHECK_TYPE(&dcerpc_fault_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->fault = *(struct dcerpc_fault *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_WORKING:
			PY_CHECK_TYPE(&dcerpc_working_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->working = *(struct dcerpc_working *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_NOCALL:
			PY_CHECK_TYPE(&dcerpc_fack_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->nocall = *(struct dcerpc_fack *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_REJECT:
			PY_CHECK_TYPE(&dcerpc_fault_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->reject = *(struct dcerpc_fault *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_ACK:
			PY_CHECK_TYPE(&dcerpc_ack_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ack = *(struct dcerpc_ack *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_CL_CANCEL:
			PY_CHECK_TYPE(&dcerpc_cl_cancel_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->cl_cancel = *(struct dcerpc_cl_cancel *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_FACK:
			PY_CHECK_TYPE(&dcerpc_fack_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->fack = *(struct dcerpc_fack *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_CANCEL_ACK:
			PY_CHECK_TYPE(&dcerpc_cancel_ack_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->cancel_ack = *(struct dcerpc_cancel_ack *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_BIND:
			PY_CHECK_TYPE(&dcerpc_bind_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->bind = *(struct dcerpc_bind *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_BIND_ACK:
			PY_CHECK_TYPE(&dcerpc_bind_ack_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->bind_ack = *(struct dcerpc_bind_ack *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_BIND_NAK:
			PY_CHECK_TYPE(&dcerpc_bind_nak_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->bind_nak = *(struct dcerpc_bind_nak *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_ALTER:
			PY_CHECK_TYPE(&dcerpc_bind_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->alter = *(struct dcerpc_bind *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_ALTER_RESP:
			PY_CHECK_TYPE(&dcerpc_bind_ack_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->alter_resp = *(struct dcerpc_bind_ack *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_SHUTDOWN:
			PY_CHECK_TYPE(&dcerpc_shutdown_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->shutdown = *(struct dcerpc_shutdown *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_CO_CANCEL:
			PY_CHECK_TYPE(&dcerpc_co_cancel_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->co_cancel = *(struct dcerpc_co_cancel *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_ORPHANED:
			PY_CHECK_TYPE(&dcerpc_orphaned_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->orphaned = *(struct dcerpc_orphaned *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_AUTH3:
			PY_CHECK_TYPE(&dcerpc_auth3_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->auth3 = *(struct dcerpc_auth3 *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_RTS:
			PY_CHECK_TYPE(&dcerpc_rts_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->rts = *(struct dcerpc_rts *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_ncacn_packet_get_rpc_vers(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)pytalloc_get_ptr(obj);
	PyObject *py_rpc_vers;
	py_rpc_vers = PyInt_FromLong(object->rpc_vers);
	return py_rpc_vers;
}

static int py_ncacn_packet_set_rpc_vers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->rpc_vers = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncacn_packet_get_rpc_vers_minor(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)pytalloc_get_ptr(obj);
	PyObject *py_rpc_vers_minor;
	py_rpc_vers_minor = PyInt_FromLong(object->rpc_vers_minor);
	return py_rpc_vers_minor;
}

static int py_ncacn_packet_set_rpc_vers_minor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->rpc_vers_minor = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncacn_packet_get_ptype(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)pytalloc_get_ptr(obj);
	PyObject *py_ptype;
	py_ptype = PyInt_FromLong(object->ptype);
	return py_ptype;
}

static int py_ncacn_packet_set_ptype(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->ptype = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->ptype = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_ncacn_packet_get_pfc_flags(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)pytalloc_get_ptr(obj);
	PyObject *py_pfc_flags;
	py_pfc_flags = PyInt_FromLong(object->pfc_flags);
	return py_pfc_flags;
}

static int py_ncacn_packet_set_pfc_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pfc_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncacn_packet_get_drep(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)pytalloc_get_ptr(obj);
	PyObject *py_drep;
	py_drep = PyList_New(4);
	if (py_drep == NULL) {
		return NULL;
	}
	{
		int drep_cntr_0;
		for (drep_cntr_0 = 0; drep_cntr_0 < 4; drep_cntr_0++) {
			PyObject *py_drep_0;
			py_drep_0 = PyInt_FromLong(object->drep[drep_cntr_0]);
			PyList_SetItem(py_drep, drep_cntr_0, py_drep_0);
		}
	}
	return py_drep;
}

static int py_ncacn_packet_set_drep(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int drep_cntr_0;
		for (drep_cntr_0 = 0; drep_cntr_0 < PyList_GET_SIZE(value); drep_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, drep_cntr_0), return -1;);
			object->drep[drep_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, drep_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_ncacn_packet_get_frag_length(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)pytalloc_get_ptr(obj);
	PyObject *py_frag_length;
	py_frag_length = PyInt_FromLong(object->frag_length);
	return py_frag_length;
}

static int py_ncacn_packet_set_frag_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->frag_length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncacn_packet_get_auth_length(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)pytalloc_get_ptr(obj);
	PyObject *py_auth_length;
	py_auth_length = PyInt_FromLong(object->auth_length);
	return py_auth_length;
}

static int py_ncacn_packet_set_auth_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->auth_length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncacn_packet_get_call_id(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)pytalloc_get_ptr(obj);
	PyObject *py_call_id;
	py_call_id = PyInt_FromLong(object->call_id);
	return py_call_id;
}

static int py_ncacn_packet_set_call_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->call_id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncacn_packet_get_u(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)pytalloc_get_ptr(obj);
	PyObject *py_u;
	py_u = py_import_dcerpc_payload(pytalloc_get_mem_ctx(obj), object->ptype, &object->u);
	if (py_u == NULL) {
		return NULL;
	}
	return py_u;
}

static int py_ncacn_packet_set_u(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = (struct ncacn_packet *)pytalloc_get_ptr(py_obj);
	{
		union dcerpc_payload *u_switch_0;
		u_switch_0 = py_export_dcerpc_payload(pytalloc_get_mem_ctx(py_obj), object->ptype, value);
		if (u_switch_0 == NULL) {
			return -1;
		}
		object->u = *u_switch_0;
	}
	return 0;
}

static PyGetSetDef py_ncacn_packet_getsetters[] = {
	{ discard_const_p(char, "rpc_vers"), py_ncacn_packet_get_rpc_vers, py_ncacn_packet_set_rpc_vers },
	{ discard_const_p(char, "rpc_vers_minor"), py_ncacn_packet_get_rpc_vers_minor, py_ncacn_packet_set_rpc_vers_minor },
	{ discard_const_p(char, "ptype"), py_ncacn_packet_get_ptype, py_ncacn_packet_set_ptype },
	{ discard_const_p(char, "pfc_flags"), py_ncacn_packet_get_pfc_flags, py_ncacn_packet_set_pfc_flags },
	{ discard_const_p(char, "drep"), py_ncacn_packet_get_drep, py_ncacn_packet_set_drep },
	{ discard_const_p(char, "frag_length"), py_ncacn_packet_get_frag_length, py_ncacn_packet_set_frag_length },
	{ discard_const_p(char, "auth_length"), py_ncacn_packet_get_auth_length, py_ncacn_packet_set_auth_length },
	{ discard_const_p(char, "call_id"), py_ncacn_packet_get_call_id, py_ncacn_packet_set_call_id },
	{ discard_const_p(char, "u"), py_ncacn_packet_get_u, py_ncacn_packet_set_u },
	{ NULL }
};

static PyObject *py_ncacn_packet_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ncacn_packet, type);
}

static PyObject *py_ncacn_packet_ndr_pack(PyObject *py_obj)
{
	struct ncacn_packet *object = (struct ncacn_packet *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_ncacn_packet);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_ncacn_packet_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ncacn_packet *object = (struct ncacn_packet *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ncacn_packet);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ncacn_packet);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_ncacn_packet_ndr_print(PyObject *py_obj)
{
	struct ncacn_packet *object = (struct ncacn_packet *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ncacn_packet, "ncacn_packet", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_ncacn_packet_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ncacn_packet_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_ncacn_packet_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_ncacn_packet_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ncacn_packet_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.ncacn_packet",
	.tp_getset = py_ncacn_packet_getsetters,
	.tp_methods = py_ncacn_packet_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_ncacn_packet_new,
};


static PyObject *py_ncadg_packet_get_rpc_vers(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(obj);
	PyObject *py_rpc_vers;
	py_rpc_vers = PyInt_FromLong(object->rpc_vers);
	return py_rpc_vers;
}

static int py_ncadg_packet_set_rpc_vers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->rpc_vers = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_ptype(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(obj);
	PyObject *py_ptype;
	py_ptype = PyInt_FromLong(object->ptype);
	return py_ptype;
}

static int py_ncadg_packet_set_ptype(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ptype = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_pfc_flags(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(obj);
	PyObject *py_pfc_flags;
	py_pfc_flags = PyInt_FromLong(object->pfc_flags);
	return py_pfc_flags;
}

static int py_ncadg_packet_set_pfc_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pfc_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_ncadg_flags(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(obj);
	PyObject *py_ncadg_flags;
	py_ncadg_flags = PyInt_FromLong(object->ncadg_flags);
	return py_ncadg_flags;
}

static int py_ncadg_packet_set_ncadg_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ncadg_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_drep(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(obj);
	PyObject *py_drep;
	py_drep = PyList_New(3);
	if (py_drep == NULL) {
		return NULL;
	}
	{
		int drep_cntr_0;
		for (drep_cntr_0 = 0; drep_cntr_0 < 3; drep_cntr_0++) {
			PyObject *py_drep_0;
			py_drep_0 = PyInt_FromLong(object->drep[drep_cntr_0]);
			PyList_SetItem(py_drep, drep_cntr_0, py_drep_0);
		}
	}
	return py_drep;
}

static int py_ncadg_packet_set_drep(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int drep_cntr_0;
		for (drep_cntr_0 = 0; drep_cntr_0 < PyList_GET_SIZE(value); drep_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, drep_cntr_0), return -1;);
			object->drep[drep_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, drep_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_ncadg_packet_get_serial_high(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(obj);
	PyObject *py_serial_high;
	py_serial_high = PyInt_FromLong(object->serial_high);
	return py_serial_high;
}

static int py_ncadg_packet_set_serial_high(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->serial_high = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_object(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(obj);
	PyObject *py_object;
	py_object = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->object);
	return py_object;
}

static int py_ncadg_packet_set_object(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->object = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_iface(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(obj);
	PyObject *py_iface;
	py_iface = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->iface);
	return py_iface;
}

static int py_ncadg_packet_set_iface(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->iface = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_activity(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(obj);
	PyObject *py_activity;
	py_activity = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->activity);
	return py_activity;
}

static int py_ncadg_packet_set_activity(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->activity = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_server_boot(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(obj);
	PyObject *py_server_boot;
	py_server_boot = PyInt_FromLong(object->server_boot);
	return py_server_boot;
}

static int py_ncadg_packet_set_server_boot(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->server_boot = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_iface_version(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(obj);
	PyObject *py_iface_version;
	py_iface_version = PyInt_FromLong(object->iface_version);
	return py_iface_version;
}

static int py_ncadg_packet_set_iface_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->iface_version = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_seq_num(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(obj);
	PyObject *py_seq_num;
	py_seq_num = PyInt_FromLong(object->seq_num);
	return py_seq_num;
}

static int py_ncadg_packet_set_seq_num(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->seq_num = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_opnum(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(obj);
	PyObject *py_opnum;
	py_opnum = PyInt_FromLong(object->opnum);
	return py_opnum;
}

static int py_ncadg_packet_set_opnum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->opnum = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_ihint(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(obj);
	PyObject *py_ihint;
	py_ihint = PyInt_FromLong(object->ihint);
	return py_ihint;
}

static int py_ncadg_packet_set_ihint(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ihint = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_ahint(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(obj);
	PyObject *py_ahint;
	py_ahint = PyInt_FromLong(object->ahint);
	return py_ahint;
}

static int py_ncadg_packet_set_ahint(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ahint = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_len(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(obj);
	PyObject *py_len;
	py_len = PyInt_FromLong(object->len);
	return py_len;
}

static int py_ncadg_packet_set_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->len = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_fragnum(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(obj);
	PyObject *py_fragnum;
	py_fragnum = PyInt_FromLong(object->fragnum);
	return py_fragnum;
}

static int py_ncadg_packet_set_fragnum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fragnum = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_auth_proto(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(obj);
	PyObject *py_auth_proto;
	py_auth_proto = PyInt_FromLong(object->auth_proto);
	return py_auth_proto;
}

static int py_ncadg_packet_set_auth_proto(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->auth_proto = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_serial_low(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(obj);
	PyObject *py_serial_low;
	py_serial_low = PyInt_FromLong(object->serial_low);
	return py_serial_low;
}

static int py_ncadg_packet_set_serial_low(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->serial_low = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_u(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(obj);
	PyObject *py_u;
	py_u = py_import_dcerpc_payload(pytalloc_get_mem_ctx(obj), object->ptype, &object->u);
	if (py_u == NULL) {
		return NULL;
	}
	return py_u;
}

static int py_ncadg_packet_set_u(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(py_obj);
	{
		union dcerpc_payload *u_switch_0;
		u_switch_0 = py_export_dcerpc_payload(pytalloc_get_mem_ctx(py_obj), object->ptype, value);
		if (u_switch_0 == NULL) {
			return -1;
		}
		object->u = *u_switch_0;
	}
	return 0;
}

static PyGetSetDef py_ncadg_packet_getsetters[] = {
	{ discard_const_p(char, "rpc_vers"), py_ncadg_packet_get_rpc_vers, py_ncadg_packet_set_rpc_vers },
	{ discard_const_p(char, "ptype"), py_ncadg_packet_get_ptype, py_ncadg_packet_set_ptype },
	{ discard_const_p(char, "pfc_flags"), py_ncadg_packet_get_pfc_flags, py_ncadg_packet_set_pfc_flags },
	{ discard_const_p(char, "ncadg_flags"), py_ncadg_packet_get_ncadg_flags, py_ncadg_packet_set_ncadg_flags },
	{ discard_const_p(char, "drep"), py_ncadg_packet_get_drep, py_ncadg_packet_set_drep },
	{ discard_const_p(char, "serial_high"), py_ncadg_packet_get_serial_high, py_ncadg_packet_set_serial_high },
	{ discard_const_p(char, "object"), py_ncadg_packet_get_object, py_ncadg_packet_set_object },
	{ discard_const_p(char, "iface"), py_ncadg_packet_get_iface, py_ncadg_packet_set_iface },
	{ discard_const_p(char, "activity"), py_ncadg_packet_get_activity, py_ncadg_packet_set_activity },
	{ discard_const_p(char, "server_boot"), py_ncadg_packet_get_server_boot, py_ncadg_packet_set_server_boot },
	{ discard_const_p(char, "iface_version"), py_ncadg_packet_get_iface_version, py_ncadg_packet_set_iface_version },
	{ discard_const_p(char, "seq_num"), py_ncadg_packet_get_seq_num, py_ncadg_packet_set_seq_num },
	{ discard_const_p(char, "opnum"), py_ncadg_packet_get_opnum, py_ncadg_packet_set_opnum },
	{ discard_const_p(char, "ihint"), py_ncadg_packet_get_ihint, py_ncadg_packet_set_ihint },
	{ discard_const_p(char, "ahint"), py_ncadg_packet_get_ahint, py_ncadg_packet_set_ahint },
	{ discard_const_p(char, "len"), py_ncadg_packet_get_len, py_ncadg_packet_set_len },
	{ discard_const_p(char, "fragnum"), py_ncadg_packet_get_fragnum, py_ncadg_packet_set_fragnum },
	{ discard_const_p(char, "auth_proto"), py_ncadg_packet_get_auth_proto, py_ncadg_packet_set_auth_proto },
	{ discard_const_p(char, "serial_low"), py_ncadg_packet_get_serial_low, py_ncadg_packet_set_serial_low },
	{ discard_const_p(char, "u"), py_ncadg_packet_get_u, py_ncadg_packet_set_u },
	{ NULL }
};

static PyObject *py_ncadg_packet_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ncadg_packet, type);
}

static PyObject *py_ncadg_packet_ndr_pack(PyObject *py_obj)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_ncadg_packet);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_ncadg_packet_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ncadg_packet);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ncadg_packet);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_ncadg_packet_ndr_print(PyObject *py_obj)
{
	struct ncadg_packet *object = (struct ncadg_packet *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ncadg_packet, "ncadg_packet", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_ncadg_packet_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ncadg_packet_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_ncadg_packet_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_ncadg_packet_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ncadg_packet_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dcerpc.ncadg_packet",
	.tp_getset = py_ncadg_packet_getsetters,
	.tp_methods = py_ncadg_packet_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_ncadg_packet_new,
};

static PyMethodDef dcerpc_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initdcerpc(void)
{
	PyObject *m;
	PyObject *dep_talloc;
	PyObject *dep_samba_dcerpc_misc;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		return;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		return;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "GUID");
	if (GUID_Type == NULL)
		return;

	Object_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "Object");
	if (Object_Type == NULL)
		return;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		return;

	dcerpc_ctx_list_Type.tp_base = Object_Type;

	dcerpc_bind_Type.tp_base = Object_Type;

	dcerpc_empty_Type.tp_base = Object_Type;

	dcerpc_request_Type.tp_base = Object_Type;

	dcerpc_ack_ctx_Type.tp_base = Object_Type;

	dcerpc_bind_ack_Type.tp_base = Object_Type;

	dcerpc_bind_nak_versions_Type.tp_base = Object_Type;

	dcerpc_bind_nak_Type.tp_base = Object_Type;

	dcerpc_response_Type.tp_base = Object_Type;

	dcerpc_fault_Type.tp_base = Object_Type;

	dcerpc_auth_Type.tp_base = Object_Type;

	dcerpc_auth3_Type.tp_base = Object_Type;

	dcerpc_orphaned_Type.tp_base = Object_Type;

	dcerpc_co_cancel_Type.tp_base = Object_Type;

	dcerpc_cl_cancel_Type.tp_base = Object_Type;

	dcerpc_cancel_ack_Type.tp_base = Object_Type;

	dcerpc_fack_Type.tp_base = Object_Type;

	dcerpc_ack_Type.tp_base = Object_Type;

	dcerpc_ping_Type.tp_base = Object_Type;

	dcerpc_shutdown_Type.tp_base = Object_Type;

	dcerpc_working_Type.tp_base = Object_Type;

	RTSCookie_Type.tp_base = Object_Type;

	ClientAddress_Type.tp_base = Object_Type;

	FlowControlAcknowledgment_Type.tp_base = Object_Type;

	dcerpc_rts_cmd_ReceiveWindowSize_Type.tp_base = Object_Type;

	dcerpc_rts_cmd_FlowControlAck_Type.tp_base = Object_Type;

	dcerpc_rts_cmd_ConnectionTimeout_Type.tp_base = Object_Type;

	dcerpc_rts_cmd_Cookie_Type.tp_base = Object_Type;

	dcerpc_rts_cmd_ChannelLifetime_Type.tp_base = Object_Type;

	dcerpc_rts_cmd_ClientKeepalive_Type.tp_base = Object_Type;

	dcerpc_rts_cmd_Version_Type.tp_base = Object_Type;

	dcerpc_rts_cmd_Empty_Type.tp_base = Object_Type;

	dcerpc_rts_cmd_Padding_Type.tp_base = Object_Type;

	dcerpc_rts_cmd_NegativeANCE_Type.tp_base = Object_Type;

	dcerpc_rts_cmd_ANCE_Type.tp_base = Object_Type;

	dcerpc_rts_cmd_ClientAddress_Type.tp_base = Object_Type;

	dcerpc_rts_cmd_AssociationGroupId_Type.tp_base = Object_Type;

	dcerpc_rts_cmd_Destination_Type.tp_base = Object_Type;

	dcerpc_rts_cmd_PingTrafficSentNotify_Type.tp_base = Object_Type;

	dcerpc_rts_cmd_Type.tp_base = Object_Type;

	dcerpc_rts_Type.tp_base = Object_Type;

	ncacn_packet_Type.tp_base = Object_Type;

	ncadg_packet_Type.tp_base = Object_Type;

	if (PyType_Ready(&dcerpc_ctx_list_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_bind_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_empty_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_request_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_ack_ctx_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_bind_ack_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_bind_nak_versions_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_bind_nak_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_response_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_fault_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_auth_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_auth3_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_orphaned_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_co_cancel_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_cl_cancel_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_cancel_ack_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_fack_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_ack_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_ping_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_shutdown_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_working_Type) < 0)
		return;
	if (PyType_Ready(&RTSCookie_Type) < 0)
		return;
	if (PyType_Ready(&ClientAddress_Type) < 0)
		return;
	if (PyType_Ready(&FlowControlAcknowledgment_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_rts_cmd_ReceiveWindowSize_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_rts_cmd_FlowControlAck_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_rts_cmd_ConnectionTimeout_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_rts_cmd_Cookie_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_rts_cmd_ChannelLifetime_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_rts_cmd_ClientKeepalive_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_rts_cmd_Version_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_rts_cmd_Empty_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_rts_cmd_Padding_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_rts_cmd_NegativeANCE_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_rts_cmd_ANCE_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_rts_cmd_ClientAddress_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_rts_cmd_AssociationGroupId_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_rts_cmd_Destination_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_rts_cmd_PingTrafficSentNotify_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_rts_cmd_Type) < 0)
		return;
	if (PyType_Ready(&dcerpc_rts_Type) < 0)
		return;
	if (PyType_Ready(&ncacn_packet_Type) < 0)
		return;
	if (PyType_Ready(&ncadg_packet_Type) < 0)
		return;
#ifdef PY_CTX_LIST_PATCH
	PY_CTX_LIST_PATCH(&dcerpc_ctx_list_Type);
#endif
#ifdef PY_BIND_PATCH
	PY_BIND_PATCH(&dcerpc_bind_Type);
#endif
#ifdef PY_EMPTY_PATCH
	PY_EMPTY_PATCH(&dcerpc_empty_Type);
#endif
#ifdef PY_REQUEST_PATCH
	PY_REQUEST_PATCH(&dcerpc_request_Type);
#endif
#ifdef PY_ACK_CTX_PATCH
	PY_ACK_CTX_PATCH(&dcerpc_ack_ctx_Type);
#endif
#ifdef PY_BIND_ACK_PATCH
	PY_BIND_ACK_PATCH(&dcerpc_bind_ack_Type);
#endif
#ifdef PY_BIND_NAK_VERSIONS_PATCH
	PY_BIND_NAK_VERSIONS_PATCH(&dcerpc_bind_nak_versions_Type);
#endif
#ifdef PY_BIND_NAK_PATCH
	PY_BIND_NAK_PATCH(&dcerpc_bind_nak_Type);
#endif
#ifdef PY_RESPONSE_PATCH
	PY_RESPONSE_PATCH(&dcerpc_response_Type);
#endif
#ifdef PY_FAULT_PATCH
	PY_FAULT_PATCH(&dcerpc_fault_Type);
#endif
#ifdef PY_AUTH_PATCH
	PY_AUTH_PATCH(&dcerpc_auth_Type);
#endif
#ifdef PY_AUTH3_PATCH
	PY_AUTH3_PATCH(&dcerpc_auth3_Type);
#endif
#ifdef PY_ORPHANED_PATCH
	PY_ORPHANED_PATCH(&dcerpc_orphaned_Type);
#endif
#ifdef PY_CO_CANCEL_PATCH
	PY_CO_CANCEL_PATCH(&dcerpc_co_cancel_Type);
#endif
#ifdef PY_CL_CANCEL_PATCH
	PY_CL_CANCEL_PATCH(&dcerpc_cl_cancel_Type);
#endif
#ifdef PY_CANCEL_ACK_PATCH
	PY_CANCEL_ACK_PATCH(&dcerpc_cancel_ack_Type);
#endif
#ifdef PY_FACK_PATCH
	PY_FACK_PATCH(&dcerpc_fack_Type);
#endif
#ifdef PY_ACK_PATCH
	PY_ACK_PATCH(&dcerpc_ack_Type);
#endif
#ifdef PY_PING_PATCH
	PY_PING_PATCH(&dcerpc_ping_Type);
#endif
#ifdef PY_SHUTDOWN_PATCH
	PY_SHUTDOWN_PATCH(&dcerpc_shutdown_Type);
#endif
#ifdef PY_WORKING_PATCH
	PY_WORKING_PATCH(&dcerpc_working_Type);
#endif
#ifdef PY_RTSCOOKIE_PATCH
	PY_RTSCOOKIE_PATCH(&RTSCookie_Type);
#endif
#ifdef PY_CLIENTADDRESS_PATCH
	PY_CLIENTADDRESS_PATCH(&ClientAddress_Type);
#endif
#ifdef PY_FLOWCONTROLACKNOWLEDGMENT_PATCH
	PY_FLOWCONTROLACKNOWLEDGMENT_PATCH(&FlowControlAcknowledgment_Type);
#endif
#ifdef PY_RTS_CMD_RECEIVEWINDOWSIZE_PATCH
	PY_RTS_CMD_RECEIVEWINDOWSIZE_PATCH(&dcerpc_rts_cmd_ReceiveWindowSize_Type);
#endif
#ifdef PY_RTS_CMD_FLOWCONTROLACK_PATCH
	PY_RTS_CMD_FLOWCONTROLACK_PATCH(&dcerpc_rts_cmd_FlowControlAck_Type);
#endif
#ifdef PY_RTS_CMD_CONNECTIONTIMEOUT_PATCH
	PY_RTS_CMD_CONNECTIONTIMEOUT_PATCH(&dcerpc_rts_cmd_ConnectionTimeout_Type);
#endif
#ifdef PY_RTS_CMD_COOKIE_PATCH
	PY_RTS_CMD_COOKIE_PATCH(&dcerpc_rts_cmd_Cookie_Type);
#endif
#ifdef PY_RTS_CMD_CHANNELLIFETIME_PATCH
	PY_RTS_CMD_CHANNELLIFETIME_PATCH(&dcerpc_rts_cmd_ChannelLifetime_Type);
#endif
#ifdef PY_RTS_CMD_CLIENTKEEPALIVE_PATCH
	PY_RTS_CMD_CLIENTKEEPALIVE_PATCH(&dcerpc_rts_cmd_ClientKeepalive_Type);
#endif
#ifdef PY_RTS_CMD_VERSION_PATCH
	PY_RTS_CMD_VERSION_PATCH(&dcerpc_rts_cmd_Version_Type);
#endif
#ifdef PY_RTS_CMD_EMPTY_PATCH
	PY_RTS_CMD_EMPTY_PATCH(&dcerpc_rts_cmd_Empty_Type);
#endif
#ifdef PY_RTS_CMD_PADDING_PATCH
	PY_RTS_CMD_PADDING_PATCH(&dcerpc_rts_cmd_Padding_Type);
#endif
#ifdef PY_RTS_CMD_NEGATIVEANCE_PATCH
	PY_RTS_CMD_NEGATIVEANCE_PATCH(&dcerpc_rts_cmd_NegativeANCE_Type);
#endif
#ifdef PY_RTS_CMD_ANCE_PATCH
	PY_RTS_CMD_ANCE_PATCH(&dcerpc_rts_cmd_ANCE_Type);
#endif
#ifdef PY_RTS_CMD_CLIENTADDRESS_PATCH
	PY_RTS_CMD_CLIENTADDRESS_PATCH(&dcerpc_rts_cmd_ClientAddress_Type);
#endif
#ifdef PY_RTS_CMD_ASSOCIATIONGROUPID_PATCH
	PY_RTS_CMD_ASSOCIATIONGROUPID_PATCH(&dcerpc_rts_cmd_AssociationGroupId_Type);
#endif
#ifdef PY_RTS_CMD_DESTINATION_PATCH
	PY_RTS_CMD_DESTINATION_PATCH(&dcerpc_rts_cmd_Destination_Type);
#endif
#ifdef PY_RTS_CMD_PINGTRAFFICSENTNOTIFY_PATCH
	PY_RTS_CMD_PINGTRAFFICSENTNOTIFY_PATCH(&dcerpc_rts_cmd_PingTrafficSentNotify_Type);
#endif
#ifdef PY_RTS_CMD_PATCH
	PY_RTS_CMD_PATCH(&dcerpc_rts_cmd_Type);
#endif
#ifdef PY_RTS_PATCH
	PY_RTS_PATCH(&dcerpc_rts_Type);
#endif
#ifdef PY_NCACN_PACKET_PATCH
	PY_NCACN_PACKET_PATCH(&ncacn_packet_Type);
#endif
#ifdef PY_NCADG_PACKET_PATCH
	PY_NCADG_PACKET_PATCH(&ncadg_packet_Type);
#endif

	m = Py_InitModule3("dcerpc", dcerpc_methods, "dcerpc DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_PIPE_COMM_ERROR", PyInt_FromLong(DCERPC_NCA_S_FAULT_PIPE_COMM_ERROR));
	PyModule_AddObject(m, "DCERPC_AUTH_LEN_OFFSET", PyInt_FromLong(10));
	PyModule_AddObject(m, "DCERPC_REQUEST_LENGTH", PyInt_FromLong(24));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_DPA", PyInt_FromLong(DCERPC_AUTH_TYPE_DPA));
	PyModule_AddObject(m, "DCERPC_NCA_S_PROTO_ERROR", PyInt_FromLong(DCERPC_NCA_S_PROTO_ERROR));
	PyModule_AddObject(m, "DCERPC_PKT_ALTER", PyInt_FromLong(DCERPC_PKT_ALTER));
	PyModule_AddObject(m, "DCERPC_FAULT_INVALID_TAG", PyInt_FromLong(0x1c000006));
	PyModule_AddObject(m, "RTS_FLAG_OUT_CHANNEL", PyInt_FromLong(RTS_FLAG_OUT_CHANNEL));
	PyModule_AddObject(m, "FDOutProxy", PyInt_FromLong(FDOutProxy));
	PyModule_AddObject(m, "RTS_FLAG_PING", PyInt_FromLong(RTS_FLAG_PING));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_FP_OVERRFLOW", PyInt_FromLong(DCERPC_NCA_S_FAULT_FP_OVERRFLOW));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_PIPE_ORDER", PyInt_FromLong(DCERPC_NCA_S_FAULT_PIPE_ORDER));
	PyModule_AddObject(m, "DCERPC_NCA_S_INVALID_CRC", PyInt_FromLong(DCERPC_NCA_S_INVALID_CRC));
	PyModule_AddObject(m, "DCERPC_NCA_S_UNUSED_1C000011", PyInt_FromLong(DCERPC_NCA_S_UNUSED_1C000011));
	PyModule_AddObject(m, "DCERPC_NCA_S_INVALID_CHECKSUM", PyInt_FromLong(DCERPC_NCA_S_INVALID_CHECKSUM));
	PyModule_AddObject(m, "RTS_FLAG_OTHER_CMD", PyInt_FromLong(RTS_FLAG_OTHER_CMD));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_RPC_VERSION_MISMATCH", PyInt_FromLong(DCERPC_NCA_S_FAULT_RPC_VERSION_MISMATCH));
	PyModule_AddObject(m, "DCERPC_PKT_ALTER_RESP", PyInt_FromLong(DCERPC_PKT_ALTER_RESP));
	PyModule_AddObject(m, "DCERPC_NCA_S_SERVER_TOO_BUSY", PyInt_FromLong(DCERPC_NCA_S_SERVER_TOO_BUSY));
	PyModule_AddObject(m, "FDClient", PyInt_FromLong(FDClient));
	PyModule_AddObject(m, "DCERPC_PKT_FACK", PyInt_FromLong(DCERPC_PKT_FACK));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_KRB5_1", PyInt_FromLong(DCERPC_AUTH_TYPE_KRB5_1));
	PyModule_AddObject(m, "DCERPC_PKT_RTS", PyInt_FromLong(DCERPC_PKT_RTS));
	PyModule_AddObject(m, "DCERPC_PFC_FLAG_CONC_MPX", PyInt_FromLong(0x10));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_MANAGER_NOT_ENTERED", PyInt_FromLong(DCERPC_NCA_S_FAULT_MANAGER_NOT_ENTERED));
	PyModule_AddObject(m, "DCERPC_PFC_FLAG_PENDING_CANCEL", PyInt_FromLong(0x04));
	PyModule_AddObject(m, "DCERPC_PKT_CO_CANCEL", PyInt_FromLong(DCERPC_PKT_CO_CANCEL));
	PyModule_AddObject(m, "DCERPC_PKT_RESPONSE", PyInt_FromLong(DCERPC_PKT_RESPONSE));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_PIPE_MEMORY", PyInt_FromLong(DCERPC_NCA_S_FAULT_PIPE_MEMORY));
	PyModule_AddObject(m, "DCERPC_FAULT_CANT_PERFORM", PyInt_FromLong(0x000006d8));
	PyModule_AddObject(m, "DCERPC_FAULT_OP_RNG_ERROR", PyInt_FromLong(0x1c010002));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_FP_UNDERFLOW", PyInt_FromLong(DCERPC_NCA_S_FAULT_FP_UNDERFLOW));
	PyModule_AddObject(m, "DCERPC_PFC_FLAG_SUPPORT_HEADER_SIGN", PyInt_FromLong(DCERPC_PFC_FLAG_PENDING_CANCEL));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_CONTEXT_MISMATCH", PyInt_FromLong(DCERPC_NCA_S_FAULT_CONTEXT_MISMATCH));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_SCHANNEL", PyInt_FromLong(DCERPC_AUTH_TYPE_SCHANNEL));
	PyModule_AddObject(m, "DCERPC_PKT_CANCEL_ACK", PyInt_FromLong(DCERPC_PKT_CANCEL_ACK));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_UNSPEC", PyInt_FromLong(DCERPC_NCA_S_FAULT_UNSPEC));
	PyModule_AddObject(m, "DCERPC_FAULT_NDR", PyInt_FromLong(0x000006f7));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_INVALID_BOUND", PyInt_FromLong(DCERPC_NCA_S_FAULT_INVALID_BOUND));
	PyModule_AddObject(m, "DCERPC_PKT_ORPHANED", PyInt_FromLong(DCERPC_PKT_ORPHANED));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_INT_OVERFLOW", PyInt_FromLong(DCERPC_NCA_S_FAULT_INT_OVERFLOW));
	PyModule_AddObject(m, "DCERPC_PKT_REQUEST", PyInt_FromLong(DCERPC_PKT_REQUEST));
	PyModule_AddObject(m, "DCERPC_NCA_S_INVALID_PRES_CONTEXT_ID", PyInt_FromLong(DCERPC_NCA_S_INVALID_PRES_CONTEXT_ID));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_ADDR_ERROR", PyInt_FromLong(DCERPC_NCA_S_FAULT_ADDR_ERROR));
	PyModule_AddObject(m, "DCERPC_NCA_S_YOU_CRASHED", PyInt_FromLong(DCERPC_NCA_S_YOU_CRASHED));
	PyModule_AddObject(m, "RTS_FLAG_ECHO", PyInt_FromLong(RTS_FLAG_ECHO));
	PyModule_AddObject(m, "DCERPC_NCA_S_UNKNOWN_IF", PyInt_FromLong(DCERPC_NCA_S_UNKNOWN_IF));
	PyModule_AddObject(m, "RTS_FLAG_EOF", PyInt_FromLong(RTS_FLAG_EOF));
	PyModule_AddObject(m, "DCERPC_AUTH_LEVEL_DEFAULT", PyInt_FromLong(DCERPC_AUTH_LEVEL_CONNECT));
	PyModule_AddObject(m, "DCERPC_AUTH_LEVEL_CALL", PyInt_FromLong(DCERPC_AUTH_LEVEL_CALL));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_INT_DIV_BY_ZERO", PyInt_FromLong(DCERPC_NCA_S_FAULT_INT_DIV_BY_ZERO));
	PyModule_AddObject(m, "DCERPC_BIND_REASON_ASYNTAX", PyInt_FromLong(1));
	PyModule_AddObject(m, "DCERPC_NCA_S_OUT_ARGS_TOO_BIG", PyInt_FromLong(DCERPC_NCA_S_OUT_ARGS_TOO_BIG));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_PIPE_DISCIPLINE", PyInt_FromLong(DCERPC_NCA_S_FAULT_PIPE_DISCIPLINE));
	PyModule_AddObject(m, "DCERPC_PKT_REJECT", PyInt_FromLong(DCERPC_PKT_REJECT));
	PyModule_AddObject(m, "DCERPC_DREP_LE", PyInt_FromLong(0x10));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_NTLMSSP", PyInt_FromLong(DCERPC_AUTH_TYPE_NTLMSSP));
	PyModule_AddObject(m, "DCERPC_PFC_FLAG_DID_NOT_EXECUTE", PyInt_FromLong(0x20));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_NO_CLIENT_STUB", PyInt_FromLong(DCERPC_NCA_S_FAULT_NO_CLIENT_STUB));
	PyModule_AddObject(m, "DCERPC_BIND_PROVIDER_REJECT", PyInt_FromLong(2));
	PyModule_AddObject(m, "DCERPC_AUTH_LEVEL_NONE", PyInt_FromLong(DCERPC_AUTH_LEVEL_NONE));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_INVALID_TAG", PyInt_FromLong(DCERPC_NCA_S_FAULT_INVALID_TAG));
	PyModule_AddObject(m, "DCERPC_NCA_S_UNSUPPORTED_TYPE", PyInt_FromLong(DCERPC_NCA_S_UNSUPPORTED_TYPE));
	PyModule_AddObject(m, "DCERPC_PKT_BIND", PyInt_FromLong(DCERPC_PKT_BIND));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_REMOTE_COMM_FAILURE", PyInt_FromLong(DCERPC_NCA_S_FAULT_REMOTE_COMM_FAILURE));
	PyModule_AddObject(m, "DCERPC_PKT_PING", PyInt_FromLong(DCERPC_PKT_PING));
	PyModule_AddObject(m, "DCERPC_FAULT_ACCESS_DENIED", PyInt_FromLong(0x00000005));
	PyModule_AddObject(m, "DCERPC_FAULT_OTHER", PyInt_FromLong(0x00000001));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_WHO_ARE_YOU_FAILED", PyInt_FromLong(DCERPC_NCA_S_FAULT_WHO_ARE_YOU_FAILED));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_OBJECT_NOT_FOUND", PyInt_FromLong(DCERPC_NCA_S_FAULT_OBJECT_NOT_FOUND));
	PyModule_AddObject(m, "DCERPC_AUTH_LEVEL_CONNECT", PyInt_FromLong(DCERPC_AUTH_LEVEL_CONNECT));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_BAD_ACTID", PyInt_FromLong(DCERPC_NCA_S_FAULT_BAD_ACTID));
	PyModule_AddObject(m, "DCERPC_FAULT_TODO", PyInt_FromLong(0x00000042));
	PyModule_AddObject(m, "DCERPC_PKT_FAULT", PyInt_FromLong(DCERPC_PKT_FAULT));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_KRB5", PyInt_FromLong(DCERPC_AUTH_TYPE_KRB5));
	PyModule_AddObject(m, "DCERPC_PFC_FLAG_OBJECT_UUID", PyInt_FromLong(0x80));
	PyModule_AddObject(m, "DCERPC_FRAG_LEN_OFFSET", PyInt_FromLong(8));
	PyModule_AddObject(m, "DCERPC_AUTH_TRAILER_LENGTH", PyInt_FromLong(8));
	PyModule_AddObject(m, "DCERPC_PKT_CL_CANCEL", PyInt_FromLong(DCERPC_PKT_CL_CANCEL));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_CODESET_CONV_ERROR", PyInt_FromLong(DCERPC_NCA_S_FAULT_CODESET_CONV_ERROR));
	PyModule_AddObject(m, "DCERPC_RESPONSE_LENGTH", PyInt_FromLong(24));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_FP_DIV_BY_ZERO", PyInt_FromLong(DCERPC_NCA_S_FAULT_FP_DIV_BY_ZERO));
	PyModule_AddObject(m, "DCERPC_PKT_SHUTDOWN", PyInt_FromLong(DCERPC_PKT_SHUTDOWN));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_NONE", PyInt_FromLong(DCERPC_AUTH_TYPE_NONE));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_UNSPEC_REJECT", PyInt_FromLong(DCERPC_NCA_S_FAULT_UNSPEC_REJECT));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_TX_OPEN_FAILED", PyInt_FromLong(DCERPC_NCA_S_FAULT_TX_OPEN_FAILED));
	PyModule_AddObject(m, "DECRPC_BIND_PROTOCOL_VERSION_NOT_SUPPORTED", PyInt_FromLong(4));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_STRING_TOO_LARGE", PyInt_FromLong(DCERPC_NCA_S_FAULT_STRING_TOO_LARGE));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_SPNEGO", PyInt_FromLong(DCERPC_AUTH_TYPE_SPNEGO));
	PyModule_AddObject(m, "RTS_IPV6", PyInt_FromLong(RTS_IPV6));
	PyModule_AddObject(m, "DCERPC_NCA_S_OP_RNG_ERROR", PyInt_FromLong(DCERPC_NCA_S_OP_RNG_ERROR));
	PyModule_AddObject(m, "DCERPC_PKT_NOCALL", PyInt_FromLong(DCERPC_PKT_NOCALL));
	PyModule_AddObject(m, "DCERPC_AUTH_LEVEL_INTEGRITY", PyInt_FromLong(DCERPC_AUTH_LEVEL_INTEGRITY));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_MSMQ", PyInt_FromLong(DCERPC_AUTH_TYPE_MSMQ));
	PyModule_AddObject(m, "DCERPC_BIND_REASON_INVALID_AUTH_TYPE", PyInt_FromLong(8));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_NCALRPC_AS_SYSTEM", PyInt_FromLong(DCERPC_AUTH_TYPE_NCALRPC_AS_SYSTEM));
	PyModule_AddObject(m, "DCERPC_PFC_FLAG_MAYBE", PyInt_FromLong(0x40));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_CANCEL", PyInt_FromLong(DCERPC_NCA_S_FAULT_CANCEL));
	PyModule_AddObject(m, "DCERPC_AUTH_LEVEL_PACKET", PyInt_FromLong(DCERPC_AUTH_LEVEL_PACKET));
	PyModule_AddObject(m, "DCERPC_PFC_FLAG_FIRST", PyInt_FromLong(0x01));
	PyModule_AddObject(m, "DCERPC_FAULT_UNK_IF", PyInt_FromLong(0x1c010003));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_FP_ERROR", PyInt_FromLong(DCERPC_NCA_S_FAULT_FP_ERROR));
	PyModule_AddObject(m, "DCERPC_PFC_OFFSET", PyInt_FromLong(3));
	PyModule_AddObject(m, "DCERPC_PKT_BIND_NAK", PyInt_FromLong(DCERPC_PKT_BIND_NAK));
	PyModule_AddObject(m, "RTS_FLAG_NONE", PyInt_FromLong(RTS_FLAG_NONE));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_USER_DEFINED", PyInt_FromLong(DCERPC_NCA_S_FAULT_USER_DEFINED));
	PyModule_AddObject(m, "RTS_FLAG_IN_CHANNEL", PyInt_FromLong(RTS_FLAG_IN_CHANNEL));
	PyModule_AddObject(m, "DCERPC_NCA_S_UNUSED_1C00001E", PyInt_FromLong(DCERPC_NCA_S_UNUSED_1C00001E));
	PyModule_AddObject(m, "DCERPC_PKT_WORKING", PyInt_FromLong(DCERPC_PKT_WORKING));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_REMOTE_NO_MEMORY", PyInt_FromLong(DCERPC_NCA_S_FAULT_REMOTE_NO_MEMORY));
	PyModule_AddObject(m, "DCERPC_NCA_S_UNSUPPORTED_AUTHN_LEVEL", PyInt_FromLong(DCERPC_NCA_S_UNSUPPORTED_AUTHN_LEVEL));
	PyModule_AddObject(m, "RTS_FLAG_RECYCLE_CHANNEL", PyInt_FromLong(RTS_FLAG_RECYCLE_CHANNEL));
	PyModule_AddObject(m, "RTS_IPV4", PyInt_FromLong(RTS_IPV4));
	PyModule_AddObject(m, "DCERPC_FAULT_CONTEXT_MISMATCH", PyInt_FromLong(0x1c00001a));
	PyModule_AddObject(m, "DCERPC_NCA_S_WRONG_BOOT_TIME", PyInt_FromLong(DCERPC_NCA_S_WRONG_BOOT_TIME));
	PyModule_AddObject(m, "DCERPC_PKT_ACK", PyInt_FromLong(DCERPC_PKT_ACK));
	PyModule_AddObject(m, "DCERPC_NCA_S_COMM_FAILURE", PyInt_FromLong(DCERPC_NCA_S_COMM_FAILURE));
	PyModule_AddObject(m, "DCERPC_PKT_AUTH3", PyInt_FromLong(DCERPC_PKT_AUTH3));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_DIGEST", PyInt_FromLong(DCERPC_AUTH_TYPE_DIGEST));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_PIPE_CLOSED", PyInt_FromLong(DCERPC_NCA_S_FAULT_PIPE_CLOSED));
	PyModule_AddObject(m, "DCERPC_DREP_OFFSET", PyInt_FromLong(4));
	PyModule_AddObject(m, "FDInProxy", PyInt_FromLong(FDInProxy));
	PyModule_AddObject(m, "FDServer", PyInt_FromLong(FDServer));
	PyModule_AddObject(m, "DCERPC_FAULT_SEC_PKG_ERROR", PyInt_FromLong(0x00000721));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_ILL_INST", PyInt_FromLong(DCERPC_NCA_S_FAULT_ILL_INST));
	PyModule_AddObject(m, "DCERPC_PFC_FLAG_LAST", PyInt_FromLong(0x02));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_MSN", PyInt_FromLong(DCERPC_AUTH_TYPE_MSN));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_PIPE_EMPTY", PyInt_FromLong(DCERPC_NCA_S_FAULT_PIPE_EMPTY));
	PyModule_AddObject(m, "DCERPC_AUTH_LEVEL_PRIVACY", PyInt_FromLong(DCERPC_AUTH_LEVEL_PRIVACY));
	PyModule_AddObject(m, "DCERPC_PKT_BIND_ACK", PyInt_FromLong(DCERPC_PKT_BIND_ACK));
	Py_INCREF((PyObject *)(void *)&dcerpc_ctx_list_Type);
	PyModule_AddObject(m, "ctx_list", (PyObject *)(void *)&dcerpc_ctx_list_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_bind_Type);
	PyModule_AddObject(m, "bind", (PyObject *)(void *)&dcerpc_bind_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_empty_Type);
	PyModule_AddObject(m, "empty", (PyObject *)(void *)&dcerpc_empty_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_request_Type);
	PyModule_AddObject(m, "request", (PyObject *)(void *)&dcerpc_request_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_ack_ctx_Type);
	PyModule_AddObject(m, "ack_ctx", (PyObject *)(void *)&dcerpc_ack_ctx_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_bind_ack_Type);
	PyModule_AddObject(m, "bind_ack", (PyObject *)(void *)&dcerpc_bind_ack_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_bind_nak_versions_Type);
	PyModule_AddObject(m, "bind_nak_versions", (PyObject *)(void *)&dcerpc_bind_nak_versions_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_bind_nak_Type);
	PyModule_AddObject(m, "bind_nak", (PyObject *)(void *)&dcerpc_bind_nak_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_response_Type);
	PyModule_AddObject(m, "response", (PyObject *)(void *)&dcerpc_response_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_fault_Type);
	PyModule_AddObject(m, "fault", (PyObject *)(void *)&dcerpc_fault_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_auth_Type);
	PyModule_AddObject(m, "auth", (PyObject *)(void *)&dcerpc_auth_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_auth3_Type);
	PyModule_AddObject(m, "auth3", (PyObject *)(void *)&dcerpc_auth3_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_orphaned_Type);
	PyModule_AddObject(m, "orphaned", (PyObject *)(void *)&dcerpc_orphaned_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_co_cancel_Type);
	PyModule_AddObject(m, "co_cancel", (PyObject *)(void *)&dcerpc_co_cancel_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_cl_cancel_Type);
	PyModule_AddObject(m, "cl_cancel", (PyObject *)(void *)&dcerpc_cl_cancel_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_cancel_ack_Type);
	PyModule_AddObject(m, "cancel_ack", (PyObject *)(void *)&dcerpc_cancel_ack_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_fack_Type);
	PyModule_AddObject(m, "fack", (PyObject *)(void *)&dcerpc_fack_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_ack_Type);
	PyModule_AddObject(m, "ack", (PyObject *)(void *)&dcerpc_ack_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_ping_Type);
	PyModule_AddObject(m, "ping", (PyObject *)(void *)&dcerpc_ping_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_shutdown_Type);
	PyModule_AddObject(m, "shutdown", (PyObject *)(void *)&dcerpc_shutdown_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_working_Type);
	PyModule_AddObject(m, "working", (PyObject *)(void *)&dcerpc_working_Type);
	Py_INCREF((PyObject *)(void *)&RTSCookie_Type);
	PyModule_AddObject(m, "RTSCookie", (PyObject *)(void *)&RTSCookie_Type);
	Py_INCREF((PyObject *)(void *)&ClientAddress_Type);
	PyModule_AddObject(m, "ClientAddress", (PyObject *)(void *)&ClientAddress_Type);
	Py_INCREF((PyObject *)(void *)&FlowControlAcknowledgment_Type);
	PyModule_AddObject(m, "FlowControlAcknowledgment", (PyObject *)(void *)&FlowControlAcknowledgment_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_ReceiveWindowSize_Type);
	PyModule_AddObject(m, "rts_cmd_ReceiveWindowSize", (PyObject *)(void *)&dcerpc_rts_cmd_ReceiveWindowSize_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_FlowControlAck_Type);
	PyModule_AddObject(m, "rts_cmd_FlowControlAck", (PyObject *)(void *)&dcerpc_rts_cmd_FlowControlAck_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_ConnectionTimeout_Type);
	PyModule_AddObject(m, "rts_cmd_ConnectionTimeout", (PyObject *)(void *)&dcerpc_rts_cmd_ConnectionTimeout_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_Cookie_Type);
	PyModule_AddObject(m, "rts_cmd_Cookie", (PyObject *)(void *)&dcerpc_rts_cmd_Cookie_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_ChannelLifetime_Type);
	PyModule_AddObject(m, "rts_cmd_ChannelLifetime", (PyObject *)(void *)&dcerpc_rts_cmd_ChannelLifetime_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_ClientKeepalive_Type);
	PyModule_AddObject(m, "rts_cmd_ClientKeepalive", (PyObject *)(void *)&dcerpc_rts_cmd_ClientKeepalive_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_Version_Type);
	PyModule_AddObject(m, "rts_cmd_Version", (PyObject *)(void *)&dcerpc_rts_cmd_Version_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_Empty_Type);
	PyModule_AddObject(m, "rts_cmd_Empty", (PyObject *)(void *)&dcerpc_rts_cmd_Empty_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_Padding_Type);
	PyModule_AddObject(m, "rts_cmd_Padding", (PyObject *)(void *)&dcerpc_rts_cmd_Padding_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_NegativeANCE_Type);
	PyModule_AddObject(m, "rts_cmd_NegativeANCE", (PyObject *)(void *)&dcerpc_rts_cmd_NegativeANCE_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_ANCE_Type);
	PyModule_AddObject(m, "rts_cmd_ANCE", (PyObject *)(void *)&dcerpc_rts_cmd_ANCE_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_ClientAddress_Type);
	PyModule_AddObject(m, "rts_cmd_ClientAddress", (PyObject *)(void *)&dcerpc_rts_cmd_ClientAddress_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_AssociationGroupId_Type);
	PyModule_AddObject(m, "rts_cmd_AssociationGroupId", (PyObject *)(void *)&dcerpc_rts_cmd_AssociationGroupId_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_Destination_Type);
	PyModule_AddObject(m, "rts_cmd_Destination", (PyObject *)(void *)&dcerpc_rts_cmd_Destination_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_PingTrafficSentNotify_Type);
	PyModule_AddObject(m, "rts_cmd_PingTrafficSentNotify", (PyObject *)(void *)&dcerpc_rts_cmd_PingTrafficSentNotify_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_Type);
	PyModule_AddObject(m, "rts_cmd", (PyObject *)(void *)&dcerpc_rts_cmd_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_Type);
	PyModule_AddObject(m, "rts", (PyObject *)(void *)&dcerpc_rts_Type);
	Py_INCREF((PyObject *)(void *)&ncacn_packet_Type);
	PyModule_AddObject(m, "ncacn_packet", (PyObject *)(void *)&ncacn_packet_Type);
	Py_INCREF((PyObject *)(void *)&ncadg_packet_Type);
	PyModule_AddObject(m, "ncadg_packet", (PyObject *)(void *)&ncadg_packet_Type);
#ifdef PY_MOD_DCERPC_PATCH
	PY_MOD_DCERPC_PATCH(m);
#endif

}
