
/* Python wrapper functions auto-generated by pidl */
#include <Python.h>
#include "includes.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "autoconf/librpc/gen_ndr/ndr_notify.h"
#include "autoconf/librpc/gen_ndr/ndr_notify_c.h"

#include "librpc/gen_ndr/file_id.h"
#include "librpc/gen_ndr/server_id.h"
staticforward PyTypeObject notify_entry_Type;
staticforward PyTypeObject notify_entry_array_Type;
staticforward PyTypeObject notify_db_entry_Type;
staticforward PyTypeObject notify_depth_Type;
staticforward PyTypeObject notify_array_Type;
staticforward PyTypeObject notify_event_Type;
staticforward PyTypeObject notify_remote_event_Type;
staticforward PyTypeObject FILE_NOTIFY_INFORMATION_Type;

void initnotify(void);static PyTypeObject *file_id_Type;
static PyTypeObject *Object_Type;
static PyTypeObject *server_id_Type;

static PyObject *py_notify_entry_get_server(PyObject *obj, void *closure)
{
	struct notify_entry *object = (struct notify_entry *)pytalloc_get_ptr(obj);
	PyObject *py_server;
	py_server = pytalloc_reference_ex(server_id_Type, pytalloc_get_mem_ctx(obj), &object->server);
	return py_server;
}

static int py_notify_entry_set_server(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_entry *object = (struct notify_entry *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(server_id_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->server = *(struct server_id *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_notify_entry_get_filter(PyObject *obj, void *closure)
{
	struct notify_entry *object = (struct notify_entry *)pytalloc_get_ptr(obj);
	PyObject *py_filter;
	py_filter = PyInt_FromLong(object->filter);
	return py_filter;
}

static int py_notify_entry_set_filter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_entry *object = (struct notify_entry *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->filter = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_notify_entry_get_subdir_filter(PyObject *obj, void *closure)
{
	struct notify_entry *object = (struct notify_entry *)pytalloc_get_ptr(obj);
	PyObject *py_subdir_filter;
	py_subdir_filter = PyInt_FromLong(object->subdir_filter);
	return py_subdir_filter;
}

static int py_notify_entry_set_subdir_filter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_entry *object = (struct notify_entry *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->subdir_filter = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_notify_entry_get_dir_fd(PyObject *obj, void *closure)
{
	struct notify_entry *object = (struct notify_entry *)pytalloc_get_ptr(obj);
	PyObject *py_dir_fd;
	py_dir_fd = PyInt_FromLong(object->dir_fd);
	return py_dir_fd;
}

static int py_notify_entry_set_dir_fd(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_entry *object = (struct notify_entry *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dir_fd = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_notify_entry_get_dir_id(PyObject *obj, void *closure)
{
	struct notify_entry *object = (struct notify_entry *)pytalloc_get_ptr(obj);
	PyObject *py_dir_id;
	py_dir_id = pytalloc_reference_ex(file_id_Type, pytalloc_get_mem_ctx(obj), &object->dir_id);
	return py_dir_id;
}

static int py_notify_entry_set_dir_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_entry *object = (struct notify_entry *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(file_id_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dir_id = *(struct file_id *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_notify_entry_get_path(PyObject *obj, void *closure)
{
	struct notify_entry *object = (struct notify_entry *)pytalloc_get_ptr(obj);
	PyObject *py_path;
	py_path = PyString_FromStringOrNULL(object->path);
	return py_path;
}

static int py_notify_entry_set_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_entry *object = (struct notify_entry *)pytalloc_get_ptr(py_obj);
	object->path = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_notify_entry_get_path_len(PyObject *obj, void *closure)
{
	struct notify_entry *object = (struct notify_entry *)pytalloc_get_ptr(obj);
	PyObject *py_path_len;
	py_path_len = PyInt_FromLong(object->path_len);
	return py_path_len;
}

static int py_notify_entry_set_path_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_entry *object = (struct notify_entry *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->path_len = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_notify_entry_get_private_data(PyObject *obj, void *closure)
{
	struct notify_entry *object = (struct notify_entry *)pytalloc_get_ptr(obj);
	PyObject *py_private_data;
	py_private_data = pytalloc_CObject_FromTallocPtr(object->private_data);
	return py_private_data;
}

static int py_notify_entry_set_private_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_entry *object = (struct notify_entry *)pytalloc_get_ptr(py_obj);
	object->private_data = PyCObject_AsVoidPtr(value);
	return 0;
}

static PyGetSetDef py_notify_entry_getsetters[] = {
	{ discard_const_p(char, "server"), py_notify_entry_get_server, py_notify_entry_set_server },
	{ discard_const_p(char, "filter"), py_notify_entry_get_filter, py_notify_entry_set_filter },
	{ discard_const_p(char, "subdir_filter"), py_notify_entry_get_subdir_filter, py_notify_entry_set_subdir_filter },
	{ discard_const_p(char, "dir_fd"), py_notify_entry_get_dir_fd, py_notify_entry_set_dir_fd },
	{ discard_const_p(char, "dir_id"), py_notify_entry_get_dir_id, py_notify_entry_set_dir_id },
	{ discard_const_p(char, "path"), py_notify_entry_get_path, py_notify_entry_set_path },
	{ discard_const_p(char, "path_len"), py_notify_entry_get_path_len, py_notify_entry_set_path_len },
	{ discard_const_p(char, "private_data"), py_notify_entry_get_private_data, py_notify_entry_set_private_data },
	{ NULL }
};

static PyObject *py_notify_entry_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct notify_entry, type);
}

static PyObject *py_notify_entry_ndr_pack(PyObject *py_obj)
{
	struct notify_entry *object = (struct notify_entry *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_notify_entry);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_notify_entry_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct notify_entry *object = (struct notify_entry *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_notify_entry);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_notify_entry);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_notify_entry_ndr_print(PyObject *py_obj)
{
	struct notify_entry *object = (struct notify_entry *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_notify_entry, "notify_entry", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_notify_entry_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_notify_entry_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_notify_entry_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_notify_entry_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject notify_entry_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "notify.entry",
	.tp_getset = py_notify_entry_getsetters,
	.tp_methods = py_notify_entry_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_notify_entry_new,
};


static PyObject *py_notify_entry_array_get_num_entries(PyObject *obj, void *closure)
{
	struct notify_entry_array *object = (struct notify_entry_array *)pytalloc_get_ptr(obj);
	PyObject *py_num_entries;
	py_num_entries = PyInt_FromLong(object->num_entries);
	return py_num_entries;
}

static int py_notify_entry_array_set_num_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_entry_array *object = (struct notify_entry_array *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_entries = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_notify_entry_array_get_entries(PyObject *obj, void *closure)
{
	struct notify_entry_array *object = (struct notify_entry_array *)pytalloc_get_ptr(obj);
	PyObject *py_entries;
	py_entries = PyList_New(object->num_entries);
	if (py_entries == NULL) {
		return NULL;
	}
	{
		int entries_cntr_0;
		for (entries_cntr_0 = 0; entries_cntr_0 < object->num_entries; entries_cntr_0++) {
			PyObject *py_entries_0;
			py_entries_0 = pytalloc_reference_ex(&notify_entry_Type, object->entries, &object->entries[entries_cntr_0]);
			PyList_SetItem(py_entries, entries_cntr_0, py_entries_0);
		}
	}
	return py_entries;
}

static int py_notify_entry_array_set_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_entry_array *object = (struct notify_entry_array *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int entries_cntr_0;
		object->entries = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->entries, PyList_GET_SIZE(value));
		if (!object->entries) { return -1;; }
		talloc_set_name_const(object->entries, "ARRAY: object->entries");
		for (entries_cntr_0 = 0; entries_cntr_0 < PyList_GET_SIZE(value); entries_cntr_0++) {
			PY_CHECK_TYPE(&notify_entry_Type, PyList_GET_ITEM(value, entries_cntr_0), return -1;);
			if (talloc_reference(object->entries, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, entries_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->entries[entries_cntr_0] = *(struct notify_entry *)pytalloc_get_ptr(PyList_GET_ITEM(value, entries_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_notify_entry_array_getsetters[] = {
	{ discard_const_p(char, "num_entries"), py_notify_entry_array_get_num_entries, py_notify_entry_array_set_num_entries },
	{ discard_const_p(char, "entries"), py_notify_entry_array_get_entries, py_notify_entry_array_set_entries },
	{ NULL }
};

static PyObject *py_notify_entry_array_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct notify_entry_array, type);
}

static PyObject *py_notify_entry_array_ndr_pack(PyObject *py_obj)
{
	struct notify_entry_array *object = (struct notify_entry_array *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_notify_entry_array);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_notify_entry_array_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct notify_entry_array *object = (struct notify_entry_array *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_notify_entry_array);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_notify_entry_array);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_notify_entry_array_ndr_print(PyObject *py_obj)
{
	struct notify_entry_array *object = (struct notify_entry_array *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_notify_entry_array, "notify_entry_array", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_notify_entry_array_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_notify_entry_array_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_notify_entry_array_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_notify_entry_array_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject notify_entry_array_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "notify.entry_array",
	.tp_getset = py_notify_entry_array_getsetters,
	.tp_methods = py_notify_entry_array_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_notify_entry_array_new,
};


static PyObject *py_notify_db_entry_get_server(PyObject *obj, void *closure)
{
	struct notify_db_entry *object = (struct notify_db_entry *)pytalloc_get_ptr(obj);
	PyObject *py_server;
	py_server = pytalloc_reference_ex(server_id_Type, pytalloc_get_mem_ctx(obj), &object->server);
	return py_server;
}

static int py_notify_db_entry_set_server(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_db_entry *object = (struct notify_db_entry *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(server_id_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->server = *(struct server_id *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_notify_db_entry_get_filter(PyObject *obj, void *closure)
{
	struct notify_db_entry *object = (struct notify_db_entry *)pytalloc_get_ptr(obj);
	PyObject *py_filter;
	py_filter = PyInt_FromLong(object->filter);
	return py_filter;
}

static int py_notify_db_entry_set_filter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_db_entry *object = (struct notify_db_entry *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->filter = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_notify_db_entry_get_subdir_filter(PyObject *obj, void *closure)
{
	struct notify_db_entry *object = (struct notify_db_entry *)pytalloc_get_ptr(obj);
	PyObject *py_subdir_filter;
	py_subdir_filter = PyInt_FromLong(object->subdir_filter);
	return py_subdir_filter;
}

static int py_notify_db_entry_set_subdir_filter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_db_entry *object = (struct notify_db_entry *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->subdir_filter = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_notify_db_entry_get_private_data(PyObject *obj, void *closure)
{
	struct notify_db_entry *object = (struct notify_db_entry *)pytalloc_get_ptr(obj);
	PyObject *py_private_data;
	py_private_data = pytalloc_CObject_FromTallocPtr(object->private_data);
	return py_private_data;
}

static int py_notify_db_entry_set_private_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_db_entry *object = (struct notify_db_entry *)pytalloc_get_ptr(py_obj);
	object->private_data = PyCObject_AsVoidPtr(value);
	return 0;
}

static PyGetSetDef py_notify_db_entry_getsetters[] = {
	{ discard_const_p(char, "server"), py_notify_db_entry_get_server, py_notify_db_entry_set_server },
	{ discard_const_p(char, "filter"), py_notify_db_entry_get_filter, py_notify_db_entry_set_filter },
	{ discard_const_p(char, "subdir_filter"), py_notify_db_entry_get_subdir_filter, py_notify_db_entry_set_subdir_filter },
	{ discard_const_p(char, "private_data"), py_notify_db_entry_get_private_data, py_notify_db_entry_set_private_data },
	{ NULL }
};

static PyObject *py_notify_db_entry_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct notify_db_entry, type);
}

static PyObject *py_notify_db_entry_ndr_pack(PyObject *py_obj)
{
	struct notify_db_entry *object = (struct notify_db_entry *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_notify_db_entry);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_notify_db_entry_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct notify_db_entry *object = (struct notify_db_entry *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_notify_db_entry);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_notify_db_entry);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_notify_db_entry_ndr_print(PyObject *py_obj)
{
	struct notify_db_entry *object = (struct notify_db_entry *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_notify_db_entry, "notify_db_entry", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_notify_db_entry_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_notify_db_entry_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_notify_db_entry_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_notify_db_entry_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject notify_db_entry_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "notify.db_entry",
	.tp_getset = py_notify_db_entry_getsetters,
	.tp_methods = py_notify_db_entry_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_notify_db_entry_new,
};


static PyObject *py_notify_depth_get_max_mask(PyObject *obj, void *closure)
{
	struct notify_depth *object = (struct notify_depth *)pytalloc_get_ptr(obj);
	PyObject *py_max_mask;
	py_max_mask = PyInt_FromLong(object->max_mask);
	return py_max_mask;
}

static int py_notify_depth_set_max_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_depth *object = (struct notify_depth *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->max_mask = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_notify_depth_get_max_mask_subdir(PyObject *obj, void *closure)
{
	struct notify_depth *object = (struct notify_depth *)pytalloc_get_ptr(obj);
	PyObject *py_max_mask_subdir;
	py_max_mask_subdir = PyInt_FromLong(object->max_mask_subdir);
	return py_max_mask_subdir;
}

static int py_notify_depth_set_max_mask_subdir(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_depth *object = (struct notify_depth *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->max_mask_subdir = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_notify_depth_get_num_entries(PyObject *obj, void *closure)
{
	struct notify_depth *object = (struct notify_depth *)pytalloc_get_ptr(obj);
	PyObject *py_num_entries;
	py_num_entries = PyInt_FromLong(object->num_entries);
	return py_num_entries;
}

static int py_notify_depth_set_num_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_depth *object = (struct notify_depth *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_entries = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_notify_depth_get_entries(PyObject *obj, void *closure)
{
	struct notify_depth *object = (struct notify_depth *)pytalloc_get_ptr(obj);
	PyObject *py_entries;
	py_entries = PyList_New(object->num_entries);
	if (py_entries == NULL) {
		return NULL;
	}
	{
		int entries_cntr_0;
		for (entries_cntr_0 = 0; entries_cntr_0 < object->num_entries; entries_cntr_0++) {
			PyObject *py_entries_0;
			py_entries_0 = pytalloc_reference_ex(&notify_entry_Type, object->entries, &object->entries[entries_cntr_0]);
			PyList_SetItem(py_entries, entries_cntr_0, py_entries_0);
		}
	}
	return py_entries;
}

static int py_notify_depth_set_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_depth *object = (struct notify_depth *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int entries_cntr_0;
		object->entries = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->entries, PyList_GET_SIZE(value));
		if (!object->entries) { return -1;; }
		talloc_set_name_const(object->entries, "ARRAY: object->entries");
		for (entries_cntr_0 = 0; entries_cntr_0 < PyList_GET_SIZE(value); entries_cntr_0++) {
			PY_CHECK_TYPE(&notify_entry_Type, PyList_GET_ITEM(value, entries_cntr_0), return -1;);
			if (talloc_reference(object->entries, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, entries_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->entries[entries_cntr_0] = *(struct notify_entry *)pytalloc_get_ptr(PyList_GET_ITEM(value, entries_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_notify_depth_getsetters[] = {
	{ discard_const_p(char, "max_mask"), py_notify_depth_get_max_mask, py_notify_depth_set_max_mask },
	{ discard_const_p(char, "max_mask_subdir"), py_notify_depth_get_max_mask_subdir, py_notify_depth_set_max_mask_subdir },
	{ discard_const_p(char, "num_entries"), py_notify_depth_get_num_entries, py_notify_depth_set_num_entries },
	{ discard_const_p(char, "entries"), py_notify_depth_get_entries, py_notify_depth_set_entries },
	{ NULL }
};

static PyObject *py_notify_depth_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct notify_depth, type);
}


static PyTypeObject notify_depth_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "notify.depth",
	.tp_getset = py_notify_depth_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_notify_depth_new,
};


static PyObject *py_notify_array_get_num_depths(PyObject *obj, void *closure)
{
	struct notify_array *object = (struct notify_array *)pytalloc_get_ptr(obj);
	PyObject *py_num_depths;
	py_num_depths = PyInt_FromLong(object->num_depths);
	return py_num_depths;
}

static int py_notify_array_set_num_depths(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_array *object = (struct notify_array *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_depths = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_notify_array_get_depth(PyObject *obj, void *closure)
{
	struct notify_array *object = (struct notify_array *)pytalloc_get_ptr(obj);
	PyObject *py_depth;
	py_depth = PyList_New(object->num_depths);
	if (py_depth == NULL) {
		return NULL;
	}
	{
		int depth_cntr_0;
		for (depth_cntr_0 = 0; depth_cntr_0 < object->num_depths; depth_cntr_0++) {
			PyObject *py_depth_0;
			py_depth_0 = pytalloc_reference_ex(&notify_depth_Type, object->depth, &object->depth[depth_cntr_0]);
			PyList_SetItem(py_depth, depth_cntr_0, py_depth_0);
		}
	}
	return py_depth;
}

static int py_notify_array_set_depth(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_array *object = (struct notify_array *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int depth_cntr_0;
		object->depth = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->depth, PyList_GET_SIZE(value));
		if (!object->depth) { return -1;; }
		talloc_set_name_const(object->depth, "ARRAY: object->depth");
		for (depth_cntr_0 = 0; depth_cntr_0 < PyList_GET_SIZE(value); depth_cntr_0++) {
			PY_CHECK_TYPE(&notify_depth_Type, PyList_GET_ITEM(value, depth_cntr_0), return -1;);
			if (talloc_reference(object->depth, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, depth_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->depth[depth_cntr_0] = *(struct notify_depth *)pytalloc_get_ptr(PyList_GET_ITEM(value, depth_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_notify_array_getsetters[] = {
	{ discard_const_p(char, "num_depths"), py_notify_array_get_num_depths, py_notify_array_set_num_depths },
	{ discard_const_p(char, "depth"), py_notify_array_get_depth, py_notify_array_set_depth },
	{ NULL }
};

static PyObject *py_notify_array_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct notify_array, type);
}

static PyObject *py_notify_array_ndr_pack(PyObject *py_obj)
{
	struct notify_array *object = (struct notify_array *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_notify_array);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_notify_array_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct notify_array *object = (struct notify_array *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_notify_array);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_notify_array);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_notify_array_ndr_print(PyObject *py_obj)
{
	struct notify_array *object = (struct notify_array *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_notify_array, "notify_array", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_notify_array_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_notify_array_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_notify_array_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_notify_array_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject notify_array_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "notify.array",
	.tp_getset = py_notify_array_getsetters,
	.tp_methods = py_notify_array_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_notify_array_new,
};


static PyObject *py_notify_event_get_action(PyObject *obj, void *closure)
{
	struct notify_event *object = (struct notify_event *)pytalloc_get_ptr(obj);
	PyObject *py_action;
	py_action = PyInt_FromLong(object->action);
	return py_action;
}

static int py_notify_event_set_action(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_event *object = (struct notify_event *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->action = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_notify_event_get_path(PyObject *obj, void *closure)
{
	struct notify_event *object = (struct notify_event *)pytalloc_get_ptr(obj);
	PyObject *py_path;
	py_path = PyString_FromStringOrNULL(object->path);
	return py_path;
}

static int py_notify_event_set_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_event *object = (struct notify_event *)pytalloc_get_ptr(py_obj);
	object->path = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_notify_event_get_private_data(PyObject *obj, void *closure)
{
	struct notify_event *object = (struct notify_event *)pytalloc_get_ptr(obj);
	PyObject *py_private_data;
	py_private_data = pytalloc_CObject_FromTallocPtr(object->private_data);
	return py_private_data;
}

static int py_notify_event_set_private_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_event *object = (struct notify_event *)pytalloc_get_ptr(py_obj);
	object->private_data = PyCObject_AsVoidPtr(value);
	return 0;
}

static PyGetSetDef py_notify_event_getsetters[] = {
	{ discard_const_p(char, "action"), py_notify_event_get_action, py_notify_event_set_action },
	{ discard_const_p(char, "path"), py_notify_event_get_path, py_notify_event_set_path },
	{ discard_const_p(char, "private_data"), py_notify_event_get_private_data, py_notify_event_set_private_data },
	{ NULL }
};

static PyObject *py_notify_event_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct notify_event, type);
}

static PyObject *py_notify_event_ndr_pack(PyObject *py_obj)
{
	struct notify_event *object = (struct notify_event *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_notify_event);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_notify_event_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct notify_event *object = (struct notify_event *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_notify_event);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_notify_event);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_notify_event_ndr_print(PyObject *py_obj)
{
	struct notify_event *object = (struct notify_event *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_notify_event, "notify_event", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_notify_event_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_notify_event_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_notify_event_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_notify_event_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject notify_event_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "notify.event",
	.tp_getset = py_notify_event_getsetters,
	.tp_methods = py_notify_event_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_notify_event_new,
};


static PyObject *py_notify_remote_event_get_action(PyObject *obj, void *closure)
{
	struct notify_remote_event *object = (struct notify_remote_event *)pytalloc_get_ptr(obj);
	PyObject *py_action;
	py_action = PyInt_FromLong(object->action);
	return py_action;
}

static int py_notify_remote_event_set_action(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_remote_event *object = (struct notify_remote_event *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->action = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_notify_remote_event_get_filter(PyObject *obj, void *closure)
{
	struct notify_remote_event *object = (struct notify_remote_event *)pytalloc_get_ptr(obj);
	PyObject *py_filter;
	py_filter = PyInt_FromLong(object->filter);
	return py_filter;
}

static int py_notify_remote_event_set_filter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_remote_event *object = (struct notify_remote_event *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->filter = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_notify_remote_event_get_path(PyObject *obj, void *closure)
{
	struct notify_remote_event *object = (struct notify_remote_event *)pytalloc_get_ptr(obj);
	PyObject *py_path;
	py_path = PyString_FromStringOrNULL(object->path);
	return py_path;
}

static int py_notify_remote_event_set_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct notify_remote_event *object = (struct notify_remote_event *)pytalloc_get_ptr(py_obj);
	object->path = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyGetSetDef py_notify_remote_event_getsetters[] = {
	{ discard_const_p(char, "action"), py_notify_remote_event_get_action, py_notify_remote_event_set_action },
	{ discard_const_p(char, "filter"), py_notify_remote_event_get_filter, py_notify_remote_event_set_filter },
	{ discard_const_p(char, "path"), py_notify_remote_event_get_path, py_notify_remote_event_set_path },
	{ NULL }
};

static PyObject *py_notify_remote_event_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct notify_remote_event, type);
}

static PyObject *py_notify_remote_event_ndr_pack(PyObject *py_obj)
{
	struct notify_remote_event *object = (struct notify_remote_event *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_notify_remote_event);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_notify_remote_event_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct notify_remote_event *object = (struct notify_remote_event *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_notify_remote_event);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_notify_remote_event);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_notify_remote_event_ndr_print(PyObject *py_obj)
{
	struct notify_remote_event *object = (struct notify_remote_event *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_notify_remote_event, "notify_remote_event", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_notify_remote_event_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_notify_remote_event_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_notify_remote_event_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_notify_remote_event_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject notify_remote_event_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "notify.remote_event",
	.tp_getset = py_notify_remote_event_getsetters,
	.tp_methods = py_notify_remote_event_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_notify_remote_event_new,
};


static PyObject *py_FILE_NOTIFY_INFORMATION_get_NextEntryOffset(PyObject *obj, void *closure)
{
	struct FILE_NOTIFY_INFORMATION *object = (struct FILE_NOTIFY_INFORMATION *)pytalloc_get_ptr(obj);
	PyObject *py_NextEntryOffset;
	py_NextEntryOffset = PyInt_FromLong(object->NextEntryOffset);
	return py_NextEntryOffset;
}

static int py_FILE_NOTIFY_INFORMATION_set_NextEntryOffset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct FILE_NOTIFY_INFORMATION *object = (struct FILE_NOTIFY_INFORMATION *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->NextEntryOffset = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_FILE_NOTIFY_INFORMATION_get_Action(PyObject *obj, void *closure)
{
	struct FILE_NOTIFY_INFORMATION *object = (struct FILE_NOTIFY_INFORMATION *)pytalloc_get_ptr(obj);
	PyObject *py_Action;
	py_Action = PyInt_FromLong(object->Action);
	return py_Action;
}

static int py_FILE_NOTIFY_INFORMATION_set_Action(PyObject *py_obj, PyObject *value, void *closure)
{
	struct FILE_NOTIFY_INFORMATION *object = (struct FILE_NOTIFY_INFORMATION *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->Action = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->Action = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_FILE_NOTIFY_INFORMATION_get_FileNameLength(PyObject *obj, void *closure)
{
	struct FILE_NOTIFY_INFORMATION *object = (struct FILE_NOTIFY_INFORMATION *)pytalloc_get_ptr(obj);
	PyObject *py_FileNameLength;
	py_FileNameLength = PyInt_FromLong(object->FileNameLength);
	return py_FileNameLength;
}

static int py_FILE_NOTIFY_INFORMATION_set_FileNameLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct FILE_NOTIFY_INFORMATION *object = (struct FILE_NOTIFY_INFORMATION *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->FileNameLength = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_FILE_NOTIFY_INFORMATION_get_FileName1(PyObject *obj, void *closure)
{
	struct FILE_NOTIFY_INFORMATION *object = (struct FILE_NOTIFY_INFORMATION *)pytalloc_get_ptr(obj);
	PyObject *py_FileName1;
	if (object->FileName1 == NULL) {
		py_FileName1 = Py_None;
		Py_INCREF(py_FileName1);
	} else {
		py_FileName1 = PyUnicode_Decode(object->FileName1, strlen(object->FileName1), "utf-8", "ignore");
	}
	return py_FileName1;
}

static int py_FILE_NOTIFY_INFORMATION_set_FileName1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct FILE_NOTIFY_INFORMATION *object = (struct FILE_NOTIFY_INFORMATION *)pytalloc_get_ptr(py_obj);
	if (PyUnicode_Check(value)) {
		object->FileName1 = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	} else if (PyString_Check(value)) {
		object->FileName1 = PyString_AS_STRING(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
		return -1;
	}
	return 0;
}

static PyGetSetDef py_FILE_NOTIFY_INFORMATION_getsetters[] = {
	{ discard_const_p(char, "NextEntryOffset"), py_FILE_NOTIFY_INFORMATION_get_NextEntryOffset, py_FILE_NOTIFY_INFORMATION_set_NextEntryOffset },
	{ discard_const_p(char, "Action"), py_FILE_NOTIFY_INFORMATION_get_Action, py_FILE_NOTIFY_INFORMATION_set_Action },
	{ discard_const_p(char, "FileNameLength"), py_FILE_NOTIFY_INFORMATION_get_FileNameLength, py_FILE_NOTIFY_INFORMATION_set_FileNameLength },
	{ discard_const_p(char, "FileName1"), py_FILE_NOTIFY_INFORMATION_get_FileName1, py_FILE_NOTIFY_INFORMATION_set_FileName1 },
	{ NULL }
};

static PyObject *py_FILE_NOTIFY_INFORMATION_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct FILE_NOTIFY_INFORMATION, type);
}

static PyObject *py_FILE_NOTIFY_INFORMATION_ndr_pack(PyObject *py_obj)
{
	struct FILE_NOTIFY_INFORMATION *object = (struct FILE_NOTIFY_INFORMATION *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_FILE_NOTIFY_INFORMATION);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_FILE_NOTIFY_INFORMATION_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct FILE_NOTIFY_INFORMATION *object = (struct FILE_NOTIFY_INFORMATION *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_FILE_NOTIFY_INFORMATION);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_FILE_NOTIFY_INFORMATION);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_FILE_NOTIFY_INFORMATION_ndr_print(PyObject *py_obj)
{
	struct FILE_NOTIFY_INFORMATION *object = (struct FILE_NOTIFY_INFORMATION *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_FILE_NOTIFY_INFORMATION, "FILE_NOTIFY_INFORMATION", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_FILE_NOTIFY_INFORMATION_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_FILE_NOTIFY_INFORMATION_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_FILE_NOTIFY_INFORMATION_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_FILE_NOTIFY_INFORMATION_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject FILE_NOTIFY_INFORMATION_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "notify.FILE_NOTIFY_INFORMATION",
	.tp_getset = py_FILE_NOTIFY_INFORMATION_getsetters,
	.tp_methods = py_FILE_NOTIFY_INFORMATION_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_FILE_NOTIFY_INFORMATION_new,
};

static PyMethodDef notify_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initnotify(void)
{
	PyObject *m;
	PyObject *dep_samba_dcerpc_server_id;
	PyObject *dep_talloc;
	PyObject *dep_samba_dcerpc_file_id;

	dep_samba_dcerpc_server_id = PyImport_ImportModule("samba.dcerpc.server_id");
	if (dep_samba_dcerpc_server_id == NULL)
		return;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		return;

	dep_samba_dcerpc_file_id = PyImport_ImportModule("samba.dcerpc.file_id");
	if (dep_samba_dcerpc_file_id == NULL)
		return;

	file_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_file_id, "file_id");
	if (file_id_Type == NULL)
		return;

	Object_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "Object");
	if (Object_Type == NULL)
		return;

	server_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_server_id, "server_id");
	if (server_id_Type == NULL)
		return;

	notify_entry_Type.tp_base = Object_Type;

	notify_entry_array_Type.tp_base = Object_Type;

	notify_db_entry_Type.tp_base = Object_Type;

	notify_depth_Type.tp_base = Object_Type;

	notify_array_Type.tp_base = Object_Type;

	notify_event_Type.tp_base = Object_Type;

	notify_remote_event_Type.tp_base = Object_Type;

	FILE_NOTIFY_INFORMATION_Type.tp_base = Object_Type;

	if (PyType_Ready(&notify_entry_Type) < 0)
		return;
	if (PyType_Ready(&notify_entry_array_Type) < 0)
		return;
	if (PyType_Ready(&notify_db_entry_Type) < 0)
		return;
	if (PyType_Ready(&notify_depth_Type) < 0)
		return;
	if (PyType_Ready(&notify_array_Type) < 0)
		return;
	if (PyType_Ready(&notify_event_Type) < 0)
		return;
	if (PyType_Ready(&notify_remote_event_Type) < 0)
		return;
	if (PyType_Ready(&FILE_NOTIFY_INFORMATION_Type) < 0)
		return;
#ifdef PY_ENTRY_PATCH
	PY_ENTRY_PATCH(&notify_entry_Type);
#endif
#ifdef PY_ENTRY_ARRAY_PATCH
	PY_ENTRY_ARRAY_PATCH(&notify_entry_array_Type);
#endif
#ifdef PY_DB_ENTRY_PATCH
	PY_DB_ENTRY_PATCH(&notify_db_entry_Type);
#endif
#ifdef PY_DEPTH_PATCH
	PY_DEPTH_PATCH(&notify_depth_Type);
#endif
#ifdef PY_ARRAY_PATCH
	PY_ARRAY_PATCH(&notify_array_Type);
#endif
#ifdef PY_EVENT_PATCH
	PY_EVENT_PATCH(&notify_event_Type);
#endif
#ifdef PY_REMOTE_EVENT_PATCH
	PY_REMOTE_EVENT_PATCH(&notify_remote_event_Type);
#endif
#ifdef PY_FILE_NOTIFY_INFORMATION_PATCH
	PY_FILE_NOTIFY_INFORMATION_PATCH(&FILE_NOTIFY_INFORMATION_Type);
#endif

	m = Py_InitModule3("notify", notify_methods, "notify DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "FILE_ACTION_MODIFIED", PyInt_FromLong(FILE_ACTION_MODIFIED));
	PyModule_AddObject(m, "FILE_ACTION_MODIFIED_STREAM", PyInt_FromLong(FILE_ACTION_MODIFIED_STREAM));
	PyModule_AddObject(m, "FILE_ACTION_RENAMED_OLD_NAME", PyInt_FromLong(FILE_ACTION_RENAMED_OLD_NAME));
	PyModule_AddObject(m, "FILE_ACTION_ADDED_STREAM", PyInt_FromLong(FILE_ACTION_ADDED_STREAM));
	PyModule_AddObject(m, "FILE_ACTION_REMOVED_STREAM", PyInt_FromLong(FILE_ACTION_REMOVED_STREAM));
	PyModule_AddObject(m, "FILE_ACTION_RENAMED_NEW_NAME", PyInt_FromLong(FILE_ACTION_RENAMED_NEW_NAME));
	PyModule_AddObject(m, "FILE_ACTION_ADDED", PyInt_FromLong(FILE_ACTION_ADDED));
	PyModule_AddObject(m, "FILE_ACTION_REMOVED", PyInt_FromLong(FILE_ACTION_REMOVED));
	Py_INCREF((PyObject *)(void *)&notify_entry_Type);
	PyModule_AddObject(m, "entry", (PyObject *)(void *)&notify_entry_Type);
	Py_INCREF((PyObject *)(void *)&notify_entry_array_Type);
	PyModule_AddObject(m, "entry_array", (PyObject *)(void *)&notify_entry_array_Type);
	Py_INCREF((PyObject *)(void *)&notify_db_entry_Type);
	PyModule_AddObject(m, "db_entry", (PyObject *)(void *)&notify_db_entry_Type);
	Py_INCREF((PyObject *)(void *)&notify_depth_Type);
	PyModule_AddObject(m, "depth", (PyObject *)(void *)&notify_depth_Type);
	Py_INCREF((PyObject *)(void *)&notify_array_Type);
	PyModule_AddObject(m, "array", (PyObject *)(void *)&notify_array_Type);
	Py_INCREF((PyObject *)(void *)&notify_event_Type);
	PyModule_AddObject(m, "event", (PyObject *)(void *)&notify_event_Type);
	Py_INCREF((PyObject *)(void *)&notify_remote_event_Type);
	PyModule_AddObject(m, "remote_event", (PyObject *)(void *)&notify_remote_event_Type);
	Py_INCREF((PyObject *)(void *)&FILE_NOTIFY_INFORMATION_Type);
	PyModule_AddObject(m, "FILE_NOTIFY_INFORMATION", (PyObject *)(void *)&FILE_NOTIFY_INFORMATION_Type);
#ifdef PY_MOD_NOTIFY_PATCH
	PY_MOD_NOTIFY_PATCH(m);
#endif

}
