/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "autoconf/librpc/gen_ndr/ndr_ntsvcs.h"
#include "autoconf/librpc/gen_ndr/ndr_ntsvcs_c.h"

/* ntsvcs - client functions generated by pidl */

struct dcerpc_PNP_GetVersion_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_PNP_GetVersion_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_PNP_GetVersion_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct PNP_GetVersion *r)
{
	struct tevent_req *req;
	struct dcerpc_PNP_GetVersion_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_PNP_GetVersion_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_ntsvcs,
			NDR_PNP_GETVERSION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_PNP_GetVersion_r_done, req);

	return req;
}

static void dcerpc_PNP_GetVersion_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_PNP_GetVersion_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_PNP_GetVersion_r_state *state =
		tevent_req_data(req,
		struct dcerpc_PNP_GetVersion_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_PNP_GetVersion_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct PNP_GetVersion *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_ntsvcs,
			NDR_PNP_GETVERSION, mem_ctx, r);

	return status;
}

struct dcerpc_PNP_GetVersion_state {
	struct PNP_GetVersion orig;
	struct PNP_GetVersion tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_PNP_GetVersion_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_PNP_GetVersion_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      uint16_t *_version /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_PNP_GetVersion_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_PNP_GetVersion_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.version = _version;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_PNP_GetVersion_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_PNP_GetVersion_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_PNP_GetVersion_done, req);
	return req;
}

static void dcerpc_PNP_GetVersion_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_PNP_GetVersion_state *state = tevent_req_data(
		req, struct dcerpc_PNP_GetVersion_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_PNP_GetVersion_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.version = *state->tmp.out.version;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_PNP_GetVersion_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result)
{
	struct dcerpc_PNP_GetVersion_state *state = tevent_req_data(
		req, struct dcerpc_PNP_GetVersion_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_PNP_GetVersion(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       uint16_t *_version /* [out] [ref] */,
			       WERROR *result)
{
	struct PNP_GetVersion r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */
	r.out.version = _version;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_PNP_GetVersion_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_version = *r.out.version;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_PNP_ValidateDeviceInstance_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_PNP_ValidateDeviceInstance_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_PNP_ValidateDeviceInstance_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct PNP_ValidateDeviceInstance *r)
{
	struct tevent_req *req;
	struct dcerpc_PNP_ValidateDeviceInstance_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_PNP_ValidateDeviceInstance_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_ntsvcs,
			NDR_PNP_VALIDATEDEVICEINSTANCE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_PNP_ValidateDeviceInstance_r_done, req);

	return req;
}

static void dcerpc_PNP_ValidateDeviceInstance_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_PNP_ValidateDeviceInstance_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_PNP_ValidateDeviceInstance_r_state *state =
		tevent_req_data(req,
		struct dcerpc_PNP_ValidateDeviceInstance_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_PNP_ValidateDeviceInstance_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct PNP_ValidateDeviceInstance *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_ntsvcs,
			NDR_PNP_VALIDATEDEVICEINSTANCE, mem_ctx, r);

	return status;
}

struct dcerpc_PNP_ValidateDeviceInstance_state {
	struct PNP_ValidateDeviceInstance orig;
	struct PNP_ValidateDeviceInstance tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_PNP_ValidateDeviceInstance_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_PNP_ValidateDeviceInstance_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  const char *_devicepath /* [in] [charset(UTF16),ref] */,
							  uint32_t _flags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_PNP_ValidateDeviceInstance_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_PNP_ValidateDeviceInstance_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.devicepath = _devicepath;
	state->orig.in.flags = _flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_PNP_ValidateDeviceInstance_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_PNP_ValidateDeviceInstance_done, req);
	return req;
}

static void dcerpc_PNP_ValidateDeviceInstance_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_PNP_ValidateDeviceInstance_state *state = tevent_req_data(
		req, struct dcerpc_PNP_ValidateDeviceInstance_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_PNP_ValidateDeviceInstance_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_PNP_ValidateDeviceInstance_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_PNP_ValidateDeviceInstance_state *state = tevent_req_data(
		req, struct dcerpc_PNP_ValidateDeviceInstance_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_PNP_ValidateDeviceInstance(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   const char *_devicepath /* [in] [charset(UTF16),ref] */,
					   uint32_t _flags /* [in]  */,
					   WERROR *result)
{
	struct PNP_ValidateDeviceInstance r;
	NTSTATUS status;

	/* In parameters */
	r.in.devicepath = _devicepath;
	r.in.flags = _flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_PNP_ValidateDeviceInstance_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_PNP_GetDeviceList_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_PNP_GetDeviceList_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_PNP_GetDeviceList_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct PNP_GetDeviceList *r)
{
	struct tevent_req *req;
	struct dcerpc_PNP_GetDeviceList_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_PNP_GetDeviceList_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_ntsvcs,
			NDR_PNP_GETDEVICELIST, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_PNP_GetDeviceList_r_done, req);

	return req;
}

static void dcerpc_PNP_GetDeviceList_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_PNP_GetDeviceList_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_PNP_GetDeviceList_r_state *state =
		tevent_req_data(req,
		struct dcerpc_PNP_GetDeviceList_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_PNP_GetDeviceList_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct PNP_GetDeviceList *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_ntsvcs,
			NDR_PNP_GETDEVICELIST, mem_ctx, r);

	return status;
}

struct dcerpc_PNP_GetDeviceList_state {
	struct PNP_GetDeviceList orig;
	struct PNP_GetDeviceList tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_PNP_GetDeviceList_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_PNP_GetDeviceList_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 const char *_filter /* [in] [charset(UTF16),unique] */,
						 uint16_t *_buffer /* [out] [size_is(*length),ref,length_is(*length)] */,
						 uint32_t *_length /* [in,out] [ref] */,
						 uint32_t _flags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_PNP_GetDeviceList_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_PNP_GetDeviceList_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.filter = _filter;
	state->orig.in.length = _length;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.buffer = _buffer;
	state->orig.out.length = _length;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_PNP_GetDeviceList_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_PNP_GetDeviceList_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_PNP_GetDeviceList_done, req);
	return req;
}

static void dcerpc_PNP_GetDeviceList_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_PNP_GetDeviceList_state *state = tevent_req_data(
		req, struct dcerpc_PNP_GetDeviceList_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_PNP_GetDeviceList_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_buffer;
		if ((*state->tmp.out.length) > (*state->tmp.in.length)) {
			tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
			return;
		}
		_copy_len_buffer = *state->tmp.out.length;
		memcpy(state->orig.out.buffer, state->tmp.out.buffer, _copy_len_buffer * sizeof(*state->orig.out.buffer));
	}
	*state->orig.out.length = *state->tmp.out.length;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_PNP_GetDeviceList_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_PNP_GetDeviceList_state *state = tevent_req_data(
		req, struct dcerpc_PNP_GetDeviceList_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_PNP_GetDeviceList(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  const char *_filter /* [in] [charset(UTF16),unique] */,
				  uint16_t *_buffer /* [out] [size_is(*length),ref,length_is(*length)] */,
				  uint32_t *_length /* [in,out] [ref] */,
				  uint32_t _flags /* [in]  */,
				  WERROR *result)
{
	struct PNP_GetDeviceList r;
	NTSTATUS status;

	/* In parameters */
	r.in.filter = _filter;
	r.in.length = _length;
	r.in.flags = _flags;

	/* Out parameters */
	r.out.buffer = _buffer;
	r.out.length = _length;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_PNP_GetDeviceList_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_buffer;
		if ((*r.out.length) > (*r.in.length)) {
			return NT_STATUS_INVALID_NETWORK_RESPONSE;
		}
		_copy_len_buffer = *r.out.length;
		memcpy(_buffer, r.out.buffer, _copy_len_buffer * sizeof(*_buffer));
	}
	*_length = *r.out.length;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_PNP_GetDeviceListSize_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_PNP_GetDeviceListSize_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_PNP_GetDeviceListSize_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct PNP_GetDeviceListSize *r)
{
	struct tevent_req *req;
	struct dcerpc_PNP_GetDeviceListSize_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_PNP_GetDeviceListSize_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_ntsvcs,
			NDR_PNP_GETDEVICELISTSIZE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_PNP_GetDeviceListSize_r_done, req);

	return req;
}

static void dcerpc_PNP_GetDeviceListSize_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_PNP_GetDeviceListSize_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_PNP_GetDeviceListSize_r_state *state =
		tevent_req_data(req,
		struct dcerpc_PNP_GetDeviceListSize_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_PNP_GetDeviceListSize_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct PNP_GetDeviceListSize *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_ntsvcs,
			NDR_PNP_GETDEVICELISTSIZE, mem_ctx, r);

	return status;
}

struct dcerpc_PNP_GetDeviceListSize_state {
	struct PNP_GetDeviceListSize orig;
	struct PNP_GetDeviceListSize tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_PNP_GetDeviceListSize_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_PNP_GetDeviceListSize_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     const char *_devicename /* [in] [charset(UTF16),unique] */,
						     uint32_t *_size /* [out] [ref] */,
						     uint32_t _flags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_PNP_GetDeviceListSize_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_PNP_GetDeviceListSize_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.devicename = _devicename;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.size = _size;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_PNP_GetDeviceListSize_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_PNP_GetDeviceListSize_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_PNP_GetDeviceListSize_done, req);
	return req;
}

static void dcerpc_PNP_GetDeviceListSize_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_PNP_GetDeviceListSize_state *state = tevent_req_data(
		req, struct dcerpc_PNP_GetDeviceListSize_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_PNP_GetDeviceListSize_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.size = *state->tmp.out.size;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_PNP_GetDeviceListSize_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_PNP_GetDeviceListSize_state *state = tevent_req_data(
		req, struct dcerpc_PNP_GetDeviceListSize_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_PNP_GetDeviceListSize(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      const char *_devicename /* [in] [charset(UTF16),unique] */,
				      uint32_t *_size /* [out] [ref] */,
				      uint32_t _flags /* [in]  */,
				      WERROR *result)
{
	struct PNP_GetDeviceListSize r;
	NTSTATUS status;

	/* In parameters */
	r.in.devicename = _devicename;
	r.in.flags = _flags;

	/* Out parameters */
	r.out.size = _size;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_PNP_GetDeviceListSize_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_size = *r.out.size;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_PNP_GetDeviceRegProp_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_PNP_GetDeviceRegProp_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_PNP_GetDeviceRegProp_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct PNP_GetDeviceRegProp *r)
{
	struct tevent_req *req;
	struct dcerpc_PNP_GetDeviceRegProp_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_PNP_GetDeviceRegProp_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_ntsvcs,
			NDR_PNP_GETDEVICEREGPROP, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_PNP_GetDeviceRegProp_r_done, req);

	return req;
}

static void dcerpc_PNP_GetDeviceRegProp_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_PNP_GetDeviceRegProp_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_PNP_GetDeviceRegProp_r_state *state =
		tevent_req_data(req,
		struct dcerpc_PNP_GetDeviceRegProp_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_PNP_GetDeviceRegProp_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct PNP_GetDeviceRegProp *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_ntsvcs,
			NDR_PNP_GETDEVICEREGPROP, mem_ctx, r);

	return status;
}

struct dcerpc_PNP_GetDeviceRegProp_state {
	struct PNP_GetDeviceRegProp orig;
	struct PNP_GetDeviceRegProp tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_PNP_GetDeviceRegProp_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_PNP_GetDeviceRegProp_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    const char *_devicepath /* [in] [ref,charset(UTF16)] */,
						    uint32_t _property /* [in]  */,
						    enum winreg_Type *_reg_data_type /* [in,out] [ref] */,
						    uint8_t *_buffer /* [out] [length_is(*buffer_size),size_is(*buffer_size),ref] */,
						    uint32_t *_buffer_size /* [in,out] [ref] */,
						    uint32_t *_needed /* [in,out] [ref] */,
						    uint32_t _flags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_PNP_GetDeviceRegProp_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_PNP_GetDeviceRegProp_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.devicepath = _devicepath;
	state->orig.in.property = _property;
	state->orig.in.reg_data_type = _reg_data_type;
	state->orig.in.buffer_size = _buffer_size;
	state->orig.in.needed = _needed;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.reg_data_type = _reg_data_type;
	state->orig.out.buffer = _buffer;
	state->orig.out.buffer_size = _buffer_size;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_PNP_GetDeviceRegProp_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_PNP_GetDeviceRegProp_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_PNP_GetDeviceRegProp_done, req);
	return req;
}

static void dcerpc_PNP_GetDeviceRegProp_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_PNP_GetDeviceRegProp_state *state = tevent_req_data(
		req, struct dcerpc_PNP_GetDeviceRegProp_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_PNP_GetDeviceRegProp_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.reg_data_type = *state->tmp.out.reg_data_type;
	{
		size_t _copy_len_buffer;
		if ((*state->tmp.out.buffer_size) > (*state->tmp.in.buffer_size)) {
			tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
			return;
		}
		_copy_len_buffer = *state->tmp.out.buffer_size;
		memcpy(state->orig.out.buffer, state->tmp.out.buffer, _copy_len_buffer * sizeof(*state->orig.out.buffer));
	}
	*state->orig.out.buffer_size = *state->tmp.out.buffer_size;
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_PNP_GetDeviceRegProp_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_PNP_GetDeviceRegProp_state *state = tevent_req_data(
		req, struct dcerpc_PNP_GetDeviceRegProp_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_PNP_GetDeviceRegProp(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     const char *_devicepath /* [in] [ref,charset(UTF16)] */,
				     uint32_t _property /* [in]  */,
				     enum winreg_Type *_reg_data_type /* [in,out] [ref] */,
				     uint8_t *_buffer /* [out] [length_is(*buffer_size),size_is(*buffer_size),ref] */,
				     uint32_t *_buffer_size /* [in,out] [ref] */,
				     uint32_t *_needed /* [in,out] [ref] */,
				     uint32_t _flags /* [in]  */,
				     WERROR *result)
{
	struct PNP_GetDeviceRegProp r;
	NTSTATUS status;

	/* In parameters */
	r.in.devicepath = _devicepath;
	r.in.property = _property;
	r.in.reg_data_type = _reg_data_type;
	r.in.buffer_size = _buffer_size;
	r.in.needed = _needed;
	r.in.flags = _flags;

	/* Out parameters */
	r.out.reg_data_type = _reg_data_type;
	r.out.buffer = _buffer;
	r.out.buffer_size = _buffer_size;
	r.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_PNP_GetDeviceRegProp_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_reg_data_type = *r.out.reg_data_type;
	{
		size_t _copy_len_buffer;
		if ((*r.out.buffer_size) > (*r.in.buffer_size)) {
			return NT_STATUS_INVALID_NETWORK_RESPONSE;
		}
		_copy_len_buffer = *r.out.buffer_size;
		memcpy(_buffer, r.out.buffer, _copy_len_buffer * sizeof(*_buffer));
	}
	*_buffer_size = *r.out.buffer_size;
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_PNP_HwProfFlags_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_PNP_HwProfFlags_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_PNP_HwProfFlags_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct PNP_HwProfFlags *r)
{
	struct tevent_req *req;
	struct dcerpc_PNP_HwProfFlags_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_PNP_HwProfFlags_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_ntsvcs,
			NDR_PNP_HWPROFFLAGS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_PNP_HwProfFlags_r_done, req);

	return req;
}

static void dcerpc_PNP_HwProfFlags_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_PNP_HwProfFlags_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_PNP_HwProfFlags_r_state *state =
		tevent_req_data(req,
		struct dcerpc_PNP_HwProfFlags_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_PNP_HwProfFlags_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct PNP_HwProfFlags *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_ntsvcs,
			NDR_PNP_HWPROFFLAGS, mem_ctx, r);

	return status;
}

struct dcerpc_PNP_HwProfFlags_state {
	struct PNP_HwProfFlags orig;
	struct PNP_HwProfFlags tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_PNP_HwProfFlags_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_PNP_HwProfFlags_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       uint32_t _action /* [in]  */,
					       const char *_devicepath /* [in] [ref,charset(UTF16)] */,
					       uint32_t _config /* [in]  */,
					       uint32_t *_profile_flags /* [in,out] [ref] */,
					       uint16_t *_veto_type /* [in,out] [unique] */,
					       const char *_unknown5 /* [in] [unique,charset(UTF16)] */,
					       const char **_unknown5a /* [out] [unique,charset(UTF16)] */,
					       uint32_t _name_length /* [in]  */,
					       uint32_t _flags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_PNP_HwProfFlags_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_PNP_HwProfFlags_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.action = _action;
	state->orig.in.devicepath = _devicepath;
	state->orig.in.config = _config;
	state->orig.in.profile_flags = _profile_flags;
	state->orig.in.veto_type = _veto_type;
	state->orig.in.unknown5 = _unknown5;
	state->orig.in.name_length = _name_length;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.profile_flags = _profile_flags;
	state->orig.out.veto_type = _veto_type;
	state->orig.out.unknown5a = _unknown5a;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_PNP_HwProfFlags_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_PNP_HwProfFlags_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_PNP_HwProfFlags_done, req);
	return req;
}

static void dcerpc_PNP_HwProfFlags_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_PNP_HwProfFlags_state *state = tevent_req_data(
		req, struct dcerpc_PNP_HwProfFlags_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_PNP_HwProfFlags_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.profile_flags = *state->tmp.out.profile_flags;
	if (state->orig.out.veto_type && state->tmp.out.veto_type) {
		*state->orig.out.veto_type = *state->tmp.out.veto_type;
	}
	if (state->orig.out.unknown5a && state->tmp.out.unknown5a) {
		*state->orig.out.unknown5a = *state->tmp.out.unknown5a;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_PNP_HwProfFlags_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_PNP_HwProfFlags_state *state = tevent_req_data(
		req, struct dcerpc_PNP_HwProfFlags_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_PNP_HwProfFlags(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				uint32_t _action /* [in]  */,
				const char *_devicepath /* [in] [ref,charset(UTF16)] */,
				uint32_t _config /* [in]  */,
				uint32_t *_profile_flags /* [in,out] [ref] */,
				uint16_t *_veto_type /* [in,out] [unique] */,
				const char *_unknown5 /* [in] [unique,charset(UTF16)] */,
				const char **_unknown5a /* [out] [unique,charset(UTF16)] */,
				uint32_t _name_length /* [in]  */,
				uint32_t _flags /* [in]  */,
				WERROR *result)
{
	struct PNP_HwProfFlags r;
	NTSTATUS status;

	/* In parameters */
	r.in.action = _action;
	r.in.devicepath = _devicepath;
	r.in.config = _config;
	r.in.profile_flags = _profile_flags;
	r.in.veto_type = _veto_type;
	r.in.unknown5 = _unknown5;
	r.in.name_length = _name_length;
	r.in.flags = _flags;

	/* Out parameters */
	r.out.profile_flags = _profile_flags;
	r.out.veto_type = _veto_type;
	r.out.unknown5a = _unknown5a;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_PNP_HwProfFlags_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_profile_flags = *r.out.profile_flags;
	if (_veto_type && r.out.veto_type) {
		*_veto_type = *r.out.veto_type;
	}
	if (_unknown5a && r.out.unknown5a) {
		*_unknown5a = *r.out.unknown5a;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_PNP_GetHwProfInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_PNP_GetHwProfInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_PNP_GetHwProfInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct PNP_GetHwProfInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_PNP_GetHwProfInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_PNP_GetHwProfInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_ntsvcs,
			NDR_PNP_GETHWPROFINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_PNP_GetHwProfInfo_r_done, req);

	return req;
}

static void dcerpc_PNP_GetHwProfInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_PNP_GetHwProfInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_PNP_GetHwProfInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_PNP_GetHwProfInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_PNP_GetHwProfInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct PNP_GetHwProfInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_ntsvcs,
			NDR_PNP_GETHWPROFINFO, mem_ctx, r);

	return status;
}

struct dcerpc_PNP_GetHwProfInfo_state {
	struct PNP_GetHwProfInfo orig;
	struct PNP_GetHwProfInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_PNP_GetHwProfInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_PNP_GetHwProfInfo_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 uint32_t _idx /* [in]  */,
						 struct PNP_HwProfInfo *_info /* [in,out] [ref] */,
						 uint32_t _size /* [in]  */,
						 uint32_t _flags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_PNP_GetHwProfInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_PNP_GetHwProfInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.idx = _idx;
	state->orig.in.info = _info;
	state->orig.in.size = _size;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_PNP_GetHwProfInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_PNP_GetHwProfInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_PNP_GetHwProfInfo_done, req);
	return req;
}

static void dcerpc_PNP_GetHwProfInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_PNP_GetHwProfInfo_state *state = tevent_req_data(
		req, struct dcerpc_PNP_GetHwProfInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_PNP_GetHwProfInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_PNP_GetHwProfInfo_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_PNP_GetHwProfInfo_state *state = tevent_req_data(
		req, struct dcerpc_PNP_GetHwProfInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_PNP_GetHwProfInfo(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  uint32_t _idx /* [in]  */,
				  struct PNP_HwProfInfo *_info /* [in,out] [ref] */,
				  uint32_t _size /* [in]  */,
				  uint32_t _flags /* [in]  */,
				  WERROR *result)
{
	struct PNP_GetHwProfInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.idx = _idx;
	r.in.info = _info;
	r.in.size = _size;
	r.in.flags = _flags;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_PNP_GetHwProfInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

