/* header auto-generated by pidl */

#ifndef _PIDL_HEADER_srvsvc
#define _PIDL_HEADER_srvsvc

#include <stdint.h>

#include "libcli/util/ntstatus.h"

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/security.h"
#include "librpc/gen_ndr/svcctl.h"
#ifndef _HEADER_srvsvc
#define _HEADER_srvsvc

#define STYPE_TEMPORARY	( 0x40000000 )
#define STYPE_HIDDEN	( 0x80000000 )
#define SHARE_1005_CSC_POLICY_MASK	( 0x00000030 )
#define SHARE_1005_CSC_POLICY_SHIFT	( 4 )
struct srvsvc_NetCharDevInfo0 {
	const char *device;/* [charset(UTF16),unique] */
};

struct srvsvc_NetCharDevCtr0 {
	uint32_t count;
	struct srvsvc_NetCharDevInfo0 *array;/* [size_is(count),unique] */
};

struct srvsvc_NetCharDevInfo1 {
	const char *device;/* [unique,charset(UTF16)] */
	uint32_t status;
	const char *user;/* [unique,charset(UTF16)] */
	uint32_t time;
};

struct srvsvc_NetCharDevCtr1 {
	uint32_t count;
	struct srvsvc_NetCharDevInfo1 *array;/* [unique,size_is(count)] */
};

union srvsvc_NetCharDevInfo {
	struct srvsvc_NetCharDevInfo0 *info0;/* [case(0),unique] */
	struct srvsvc_NetCharDevInfo1 *info1;/* [case,unique] */
};

union srvsvc_NetCharDevCtr {
	struct srvsvc_NetCharDevCtr0 *ctr0;/* [unique,case(0)] */
	struct srvsvc_NetCharDevCtr1 *ctr1;/* [unique,case] */
};

struct srvsvc_NetCharDevInfoCtr {
	uint32_t level;
	union srvsvc_NetCharDevCtr ctr;/* [switch_is(level)] */
};

struct srvsvc_NetCharDevQInfo0 {
	const char *device;/* [unique,charset(UTF16)] */
};

struct srvsvc_NetCharDevQCtr0 {
	uint32_t count;
	struct srvsvc_NetCharDevQInfo0 *array;/* [unique,size_is(count)] */
};

struct srvsvc_NetCharDevQInfo1 {
	const char *device;/* [charset(UTF16),unique] */
	uint32_t priority;
	const char *devices;/* [charset(UTF16),unique] */
	uint32_t users;
	uint32_t num_ahead;
};

struct srvsvc_NetCharDevQCtr1 {
	uint32_t count;
	struct srvsvc_NetCharDevQInfo1 *array;/* [size_is(count),unique] */
};

union srvsvc_NetCharDevQInfo {
	struct srvsvc_NetCharDevQInfo0 *info0;/* [unique,case(0)] */
	struct srvsvc_NetCharDevQInfo1 *info1;/* [unique,case] */
};

union srvsvc_NetCharDevQCtr {
	struct srvsvc_NetCharDevQCtr0 *ctr0;/* [unique,case(0)] */
	struct srvsvc_NetCharDevQCtr1 *ctr1;/* [unique,case] */
};

struct srvsvc_NetCharDevQInfoCtr {
	uint32_t level;
	union srvsvc_NetCharDevQCtr ctr;/* [switch_is(level)] */
};

struct srvsvc_NetConnInfo0 {
	uint32_t conn_id;
};

struct srvsvc_NetConnCtr0 {
	uint32_t count;
	struct srvsvc_NetConnInfo0 *array;/* [size_is(count),unique] */
};

struct srvsvc_NetConnInfo1 {
	uint32_t conn_id;
	uint32_t conn_type;
	uint32_t num_open;
	uint32_t num_users;
	uint32_t conn_time;
	const char *user;/* [unique,charset(UTF16)] */
	const char *share;/* [unique,charset(UTF16)] */
};

struct srvsvc_NetConnCtr1 {
	uint32_t count;
	struct srvsvc_NetConnInfo1 *array;/* [size_is(count),unique] */
};

union srvsvc_NetConnCtr {
	struct srvsvc_NetConnCtr0 *ctr0;/* [case(0),unique] */
	struct srvsvc_NetConnCtr1 *ctr1;/* [case,unique] */
};

struct srvsvc_NetConnInfoCtr {
	uint32_t level;
	union srvsvc_NetConnCtr ctr;/* [switch_is(level)] */
};

struct srvsvc_NetFileInfo2 {
	uint32_t fid;
};

struct srvsvc_NetFileCtr2 {
	uint32_t count;
	struct srvsvc_NetFileInfo2 *array;/* [unique,size_is(count)] */
};

struct srvsvc_NetFileInfo3 {
	uint32_t fid;
	uint32_t permissions;
	uint32_t num_locks;
	const char *path;/* [unique,charset(UTF16)] */
	const char *user;/* [unique,charset(UTF16)] */
};

struct srvsvc_NetFileCtr3 {
	uint32_t count;
	struct srvsvc_NetFileInfo3 *array;/* [size_is(count),unique] */
};

union srvsvc_NetFileInfo {
	struct srvsvc_NetFileInfo2 *info2;/* [case(2),unique] */
	struct srvsvc_NetFileInfo3 *info3;/* [unique,case(3)] */
};

union srvsvc_NetFileCtr {
	struct srvsvc_NetFileCtr2 *ctr2;/* [unique,case(2)] */
	struct srvsvc_NetFileCtr3 *ctr3;/* [case(3),unique] */
};

struct srvsvc_NetFileInfoCtr {
	uint32_t level;
	union srvsvc_NetFileCtr ctr;/* [switch_is(level)] */
};

struct srvsvc_NetSessInfo0 {
	const char *client;/* [unique,charset(UTF16)] */
};

struct srvsvc_NetSessCtr0 {
	uint32_t count;
	struct srvsvc_NetSessInfo0 *array;/* [unique,size_is(count)] */
};

struct srvsvc_NetSessInfo1 {
	const char *client;/* [unique,charset(UTF16)] */
	const char *user;/* [unique,charset(UTF16)] */
	uint32_t num_open;
	uint32_t time;
	uint32_t idle_time;
	uint32_t user_flags;
};

struct srvsvc_NetSessCtr1 {
	uint32_t count;
	struct srvsvc_NetSessInfo1 *array;/* [unique,size_is(count)] */
};

struct srvsvc_NetSessInfo2 {
	const char *client;/* [charset(UTF16),unique] */
	const char *user;/* [unique,charset(UTF16)] */
	uint32_t num_open;
	uint32_t time;
	uint32_t idle_time;
	uint32_t user_flags;
	const char *client_type;/* [unique,charset(UTF16)] */
};

struct srvsvc_NetSessCtr2 {
	uint32_t count;
	struct srvsvc_NetSessInfo2 *array;/* [size_is(count),unique] */
};

struct srvsvc_NetSessInfo10 {
	const char *client;/* [unique,charset(UTF16)] */
	const char *user;/* [charset(UTF16),unique] */
	uint32_t time;
	uint32_t idle_time;
};

struct srvsvc_NetSessCtr10 {
	uint32_t count;
	struct srvsvc_NetSessInfo10 *array;/* [unique,size_is(count)] */
};

struct srvsvc_NetSessInfo502 {
	const char *client;/* [unique,charset(UTF16)] */
	const char *user;/* [charset(UTF16),unique] */
	uint32_t num_open;
	uint32_t time;
	uint32_t idle_time;
	uint32_t user_flags;
	const char *client_type;/* [charset(UTF16),unique] */
	const char *transport;/* [charset(UTF16),unique] */
};

struct srvsvc_NetSessCtr502 {
	uint32_t count;
	struct srvsvc_NetSessInfo502 *array;/* [unique,size_is(count)] */
};

union srvsvc_NetSessCtr {
	struct srvsvc_NetSessCtr0 *ctr0;/* [unique,case(0)] */
	struct srvsvc_NetSessCtr1 *ctr1;/* [unique,case] */
	struct srvsvc_NetSessCtr2 *ctr2;/* [unique,case(2)] */
	struct srvsvc_NetSessCtr10 *ctr10;/* [unique,case(10)] */
	struct srvsvc_NetSessCtr502 *ctr502;/* [unique,case(502)] */
};

struct srvsvc_NetSessInfoCtr {
	uint32_t level;
	union srvsvc_NetSessCtr ctr;/* [switch_is(level)] */
};

enum srvsvc_ShareType
#ifndef USE_UINT_ENUMS
 {
	STYPE_DISKTREE=(int)(0),
	STYPE_DISKTREE_TEMPORARY=(int)(STYPE_DISKTREE|STYPE_TEMPORARY),
	STYPE_DISKTREE_HIDDEN=(int)(STYPE_DISKTREE|STYPE_HIDDEN),
	STYPE_PRINTQ=(int)(1),
	STYPE_PRINTQ_TEMPORARY=(int)(STYPE_PRINTQ|STYPE_TEMPORARY),
	STYPE_PRINTQ_HIDDEN=(int)(STYPE_PRINTQ|STYPE_HIDDEN),
	STYPE_DEVICE=(int)(2),
	STYPE_DEVICE_TEMPORARY=(int)(STYPE_DEVICE|STYPE_TEMPORARY),
	STYPE_DEVICE_HIDDEN=(int)(STYPE_DEVICE|STYPE_HIDDEN),
	STYPE_IPC=(int)(3),
	STYPE_IPC_TEMPORARY=(int)(STYPE_IPC|STYPE_TEMPORARY),
	STYPE_IPC_HIDDEN=(int)(STYPE_IPC|STYPE_HIDDEN)
}
#else
 { __donnot_use_enum_srvsvc_ShareType=0x7FFFFFFF}
#define STYPE_DISKTREE ( 0 )
#define STYPE_DISKTREE_TEMPORARY ( STYPE_DISKTREE|STYPE_TEMPORARY )
#define STYPE_DISKTREE_HIDDEN ( STYPE_DISKTREE|STYPE_HIDDEN )
#define STYPE_PRINTQ ( 1 )
#define STYPE_PRINTQ_TEMPORARY ( STYPE_PRINTQ|STYPE_TEMPORARY )
#define STYPE_PRINTQ_HIDDEN ( STYPE_PRINTQ|STYPE_HIDDEN )
#define STYPE_DEVICE ( 2 )
#define STYPE_DEVICE_TEMPORARY ( STYPE_DEVICE|STYPE_TEMPORARY )
#define STYPE_DEVICE_HIDDEN ( STYPE_DEVICE|STYPE_HIDDEN )
#define STYPE_IPC ( 3 )
#define STYPE_IPC_TEMPORARY ( STYPE_IPC|STYPE_TEMPORARY )
#define STYPE_IPC_HIDDEN ( STYPE_IPC|STYPE_HIDDEN )
#endif
;

struct srvsvc_NetShareInfo0 {
	const char *name;/* [unique,charset(UTF16)] */
};

struct srvsvc_NetShareCtr0 {
	uint32_t count;
	struct srvsvc_NetShareInfo0 *array;/* [unique,size_is(count)] */
};

struct srvsvc_NetShareInfo1 {
	const char *name;/* [charset(UTF16),unique] */
	enum srvsvc_ShareType type;
	const char *comment;/* [charset(UTF16),unique] */
};

struct srvsvc_NetShareCtr1 {
	uint32_t count;
	struct srvsvc_NetShareInfo1 *array;/* [size_is(count),unique] */
};

struct srvsvc_NetShareInfo2 {
	const char *name;/* [unique,charset(UTF16)] */
	enum srvsvc_ShareType type;
	const char *comment;/* [unique,charset(UTF16)] */
	uint32_t permissions;
	uint32_t max_users;
	uint32_t current_users;
	const char *path;/* [unique,charset(UTF16)] */
	const char *password;/* [charset(UTF16),unique] */
};

struct srvsvc_NetShareCtr2 {
	uint32_t count;
	struct srvsvc_NetShareInfo2 *array;/* [unique,size_is(count)] */
};

struct srvsvc_NetShareInfo501 {
	const char *name;/* [charset(UTF16),unique] */
	enum srvsvc_ShareType type;
	const char *comment;/* [unique,charset(UTF16)] */
	uint32_t csc_policy;
};

struct srvsvc_NetShareCtr501 {
	uint32_t count;
	struct srvsvc_NetShareInfo501 *array;/* [size_is(count),unique] */
};

struct srvsvc_NetShareInfo502 {
	const char *name;/* [unique,charset(UTF16)] */
	enum srvsvc_ShareType type;
	const char *comment;/* [unique,charset(UTF16)] */
	uint32_t permissions;
	uint32_t max_users;
	uint32_t current_users;
	const char *path;/* [charset(UTF16),unique] */
	const char *password;/* [charset(UTF16),unique] */
	struct sec_desc_buf sd_buf;
};

struct srvsvc_NetShareCtr502 {
	uint32_t count;
	struct srvsvc_NetShareInfo502 *array;/* [size_is(count),unique] */
};

struct srvsvc_NetShareInfo1004 {
	const char *comment;/* [charset(UTF16),unique] */
};

struct srvsvc_NetShareCtr1004 {
	uint32_t count;
	struct srvsvc_NetShareInfo1004 *array;/* [unique,size_is(count)] */
};

/* bitmap NetShareInfo1005Flags */
#define SHARE_1005_IN_DFS ( 0x00000001 )
#define SHARE_1005_DFS_ROOT ( 0x00000002 )

struct srvsvc_NetShareInfo1005 {
	uint32_t dfs_flags;
};

struct srvsvc_NetShareCtr1005 {
	uint32_t count;
	struct srvsvc_NetShareInfo1005 *array;/* [unique,size_is(count)] */
};

struct srvsvc_NetShareInfo1006 {
	uint32_t max_users;
};

struct srvsvc_NetShareCtr1006 {
	uint32_t count;
	struct srvsvc_NetShareInfo1006 *array;/* [unique,size_is(count)] */
};

struct srvsvc_NetShareInfo1007 {
	uint32_t flags;
	const char *alternate_directory_name;/* [unique,charset(UTF16)] */
};

struct srvsvc_NetShareCtr1007 {
	uint32_t count;
	struct srvsvc_NetShareInfo1007 *array;/* [size_is(count),unique] */
};

struct srvsvc_NetShareCtr1501 {
	uint32_t count;
	struct sec_desc_buf *array;/* [size_is(count),unique] */
};

union srvsvc_NetShareInfo {
	struct srvsvc_NetShareInfo0 *info0;/* [unique,case(0)] */
	struct srvsvc_NetShareInfo1 *info1;/* [case,unique] */
	struct srvsvc_NetShareInfo2 *info2;/* [unique,case(2)] */
	struct srvsvc_NetShareInfo501 *info501;/* [case(501),unique] */
	struct srvsvc_NetShareInfo502 *info502;/* [unique,case(502)] */
	struct srvsvc_NetShareInfo1004 *info1004;/* [case(1004),unique] */
	struct srvsvc_NetShareInfo1005 *info1005;/* [case(1005),unique] */
	struct srvsvc_NetShareInfo1006 *info1006;/* [unique,case(1006)] */
	struct srvsvc_NetShareInfo1007 *info1007;/* [case(1007),unique] */
	struct sec_desc_buf *info1501;/* [case(1501),unique] */
};

union srvsvc_NetShareCtr {
	struct srvsvc_NetShareCtr0 *ctr0;/* [unique,case(0)] */
	struct srvsvc_NetShareCtr1 *ctr1;/* [unique,case] */
	struct srvsvc_NetShareCtr2 *ctr2;/* [unique,case(2)] */
	struct srvsvc_NetShareCtr501 *ctr501;/* [case(501),unique] */
	struct srvsvc_NetShareCtr502 *ctr502;/* [case(502),unique] */
	struct srvsvc_NetShareCtr1004 *ctr1004;/* [unique,case(1004)] */
	struct srvsvc_NetShareCtr1005 *ctr1005;/* [unique,case(1005)] */
	struct srvsvc_NetShareCtr1006 *ctr1006;/* [unique,case(1006)] */
	struct srvsvc_NetShareCtr1007 *ctr1007;/* [unique,case(1007)] */
	struct srvsvc_NetShareCtr1501 *ctr1501;/* [unique,case(1501)] */
};

struct srvsvc_NetShareInfoCtr {
	uint32_t level;
	union srvsvc_NetShareCtr ctr;/* [switch_is(level)] */
};

enum srvsvc_PlatformId
#ifndef USE_UINT_ENUMS
 {
	PLATFORM_ID_DOS=(int)(300),
	PLATFORM_ID_OS2=(int)(400),
	PLATFORM_ID_NT=(int)(500),
	PLATFORM_ID_OSF=(int)(600),
	PLATFORM_ID_VMS=(int)(700)
}
#else
 { __donnot_use_enum_srvsvc_PlatformId=0x7FFFFFFF}
#define PLATFORM_ID_DOS ( 300 )
#define PLATFORM_ID_OS2 ( 400 )
#define PLATFORM_ID_NT ( 500 )
#define PLATFORM_ID_OSF ( 600 )
#define PLATFORM_ID_VMS ( 700 )
#endif
;

struct srvsvc_NetSrvInfo100 {
	enum srvsvc_PlatformId platform_id;
	const char *server_name;/* [charset(UTF16),unique] */
}/* [public] */;

struct srvsvc_NetSrvInfo101 {
	enum srvsvc_PlatformId platform_id;
	const char *server_name;/* [charset(UTF16),unique] */
	uint32_t version_major;
	uint32_t version_minor;
	uint32_t server_type;
	const char *comment;/* [unique,charset(UTF16)] */
}/* [public] */;

struct srvsvc_NetSrvInfo102 {
	enum srvsvc_PlatformId platform_id;
	const char *server_name;/* [charset(UTF16),unique] */
	uint32_t version_major;
	uint32_t version_minor;
	uint32_t server_type;
	const char *comment;/* [charset(UTF16),unique] */
	uint32_t users;
	uint32_t disc;
	uint32_t hidden;
	uint32_t announce;
	uint32_t anndelta;
	uint32_t licenses;
	const char *userpath;/* [unique,charset(UTF16)] */
};

struct srvsvc_NetSrvInfo402 {
	uint32_t ulist_mtime;
	uint32_t glist_mtime;
	uint32_t alist_mtime;
	const char *alerts;/* [unique,charset(UTF16)] */
	uint32_t security;
	uint32_t numadmin;
	uint32_t lanmask;
	const char *guestaccount;/* [unique,charset(UTF16)] */
	uint32_t chdevs;
	uint32_t chdevqs;
	uint32_t chdevjobs;
	uint32_t connections;
	uint32_t shares;
	uint32_t openfiles;
	uint32_t sessopen;
	uint32_t sesssvc;
	uint32_t sessreqs;
	uint32_t opensearch;
	uint32_t activelocks;
	uint32_t numreqbufs;
	uint32_t sizereqbufs;
	uint32_t numbigbufs;
	uint32_t numfiletasks;
	uint32_t alertsched;
	uint32_t erroralert;
	uint32_t logonalert;
	uint32_t accessalert;
	uint32_t diskalert;
	uint32_t netioalert;
	uint32_t maxaudits;
	const char *srvheuristics;/* [unique,charset(UTF16)] */
};

struct srvsvc_NetSrvInfo403 {
	uint32_t ulist_mtime;
	uint32_t glist_mtime;
	uint32_t alist_mtime;
	const char *alerts;/* [charset(UTF16),unique] */
	uint32_t security;
	uint32_t numadmin;
	uint32_t lanmask;
	const char *guestaccount;/* [unique,charset(UTF16)] */
	uint32_t chdevs;
	uint32_t chdevqs;
	uint32_t chdevjobs;
	uint32_t connections;
	uint32_t shares;
	uint32_t openfiles;
	uint32_t sessopen;
	uint32_t sesssvc;
	uint32_t sessreqs;
	uint32_t opensearch;
	uint32_t activelocks;
	uint32_t numreqbufs;
	uint32_t sizereqbufs;
	uint32_t numbigbufs;
	uint32_t numfiletasks;
	uint32_t alertsched;
	uint32_t erroralert;
	uint32_t logonalert;
	uint32_t accessalert;
	uint32_t diskalert;
	uint32_t netioalert;
	uint32_t maxaudits;
	const char *srvheuristics;/* [unique,charset(UTF16)] */
	uint32_t auditedevents;
	uint32_t auditprofile;
	const char *autopath;/* [unique,charset(UTF16)] */
};

struct srvsvc_NetSrvInfo502 {
	uint32_t sessopen;
	uint32_t sesssvc;
	uint32_t opensearch;
	uint32_t sizereqbufs;
	uint32_t initworkitems;
	uint32_t maxworkitems;
	uint32_t rawworkitems;
	uint32_t irpstacksize;
	uint32_t maxrawbuflen;
	uint32_t sessusers;
	uint32_t sessconns;
	uint32_t maxpagedmemoryusage;
	uint32_t maxnonpagedmemoryusage;
	uint32_t enablesoftcompat;
	uint32_t enableforcedlogoff;
	uint32_t timesource;
	uint32_t acceptdownlevelapis;
	uint32_t lmannounce;
};

struct srvsvc_NetSrvInfo503 {
	uint32_t sessopen;
	uint32_t sesssvc;
	uint32_t opensearch;
	uint32_t sizereqbufs;
	uint32_t initworkitems;
	uint32_t maxworkitems;
	uint32_t rawworkitems;
	uint32_t irpstacksize;
	uint32_t maxrawbuflen;
	uint32_t sessusers;
	uint32_t sessconns;
	uint32_t maxpagedmemoryusage;
	uint32_t maxnonpagedmemoryusage;
	uint32_t enablesoftcompat;
	uint32_t enableforcedlogoff;
	uint32_t timesource;
	uint32_t acceptdownlevelapis;
	uint32_t lmannounce;
	const char *domain;/* [unique,charset(UTF16)] */
	uint32_t maxcopyreadlen;
	uint32_t maxcopywritelen;
	uint32_t minkeepsearch;
	uint32_t maxkeepsearch;
	uint32_t minkeepcomplsearch;
	uint32_t maxkeepcomplsearch;
	uint32_t threadcountadd;
	uint32_t numlockthreads;
	uint32_t scavtimeout;
	uint32_t minrcvqueue;
	uint32_t minfreeworkitems;
	uint32_t xactmemsize;
	uint32_t threadpriority;
	uint32_t maxmpxct;
	uint32_t oplockbreakwait;
	uint32_t oplockbreakresponsewait;
	uint32_t enableoplocks;
	uint32_t enableoplockforceclose;
	uint32_t enablefcbopens;
	uint32_t enableraw;
	uint32_t enablesharednetdrives;
	uint32_t minfreeconnections;
	uint32_t maxfreeconnections;
};

struct srvsvc_NetSrvInfo599 {
	uint32_t sessopen;
	uint32_t sesssvc;
	uint32_t opensearch;
	uint32_t sizereqbufs;
	uint32_t initworkitems;
	uint32_t maxworkitems;
	uint32_t rawworkitems;
	uint32_t irpstacksize;
	uint32_t maxrawbuflen;
	uint32_t sessusers;
	uint32_t sessconns;
	uint32_t maxpagedmemoryusage;
	uint32_t maxnonpagedmemoryusage;
	uint32_t enablesoftcompat;
	uint32_t enableforcedlogoff;
	uint32_t timesource;
	uint32_t acceptdownlevelapis;
	uint32_t lmannounce;
	const char *domain;/* [unique,charset(UTF16)] */
	uint32_t maxcopyreadlen;
	uint32_t maxcopywritelen;
	uint32_t minkeepsearch;
	uint32_t minkeepcomplsearch;
	uint32_t maxkeepcomplsearch;
	uint32_t threadcountadd;
	uint32_t numlockthreads;
	uint32_t scavtimeout;
	uint32_t minrcvqueue;
	uint32_t minfreeworkitems;
	uint32_t xactmemsize;
	uint32_t threadpriority;
	uint32_t maxmpxct;
	uint32_t oplockbreakwait;
	uint32_t oplockbreakresponsewait;
	uint32_t enableoplocks;
	uint32_t enableoplockforceclose;
	uint32_t enablefcbopens;
	uint32_t enableraw;
	uint32_t enablesharednetdrives;
	uint32_t minfreeconnections;
	uint32_t maxfreeconnections;
	uint32_t initsesstable;
	uint32_t initconntable;
	uint32_t initfiletable;
	uint32_t initsearchtable;
	uint32_t alertsched;
	uint32_t errortreshold;
	uint32_t networkerrortreshold;
	uint32_t diskspacetreshold;
	uint32_t reserved;
	uint32_t maxlinkdelay;
	uint32_t minlinkthroughput;
	uint32_t linkinfovalidtime;
	uint32_t scavqosinfoupdatetime;
	uint32_t maxworkitemidletime;
};

struct srvsvc_NetSrvInfo1005 {
	const char *comment;/* [charset(UTF16),unique] */
};

struct srvsvc_NetSrvInfo1010 {
	uint32_t disc;
};

struct srvsvc_NetSrvInfo1016 {
	uint32_t hidden;
};

struct srvsvc_NetSrvInfo1017 {
	uint32_t announce;
};

struct srvsvc_NetSrvInfo1018 {
	uint32_t anndelta;
};

struct srvsvc_NetSrvInfo1107 {
	uint32_t users;
};

struct srvsvc_NetSrvInfo1501 {
	uint32_t sessopens;
};

struct srvsvc_NetSrvInfo1502 {
	uint32_t sessvcs;
};

struct srvsvc_NetSrvInfo1503 {
	uint32_t opensearch;
};

struct srvsvc_NetSrvInfo1506 {
	uint32_t maxworkitems;
};

struct srvsvc_NetSrvInfo1509 {
	uint32_t maxrawbuflen;
};

struct srvsvc_NetSrvInfo1510 {
	uint32_t sessusers;
};

struct srvsvc_NetSrvInfo1511 {
	uint32_t sesscons;
};

struct srvsvc_NetSrvInfo1512 {
	uint32_t maxnonpagedmemoryusage;
};

struct srvsvc_NetSrvInfo1513 {
	uint32_t maxpagedmemoryusage;
};

struct srvsvc_NetSrvInfo1514 {
	uint32_t enablesoftcompat;
};

struct srvsvc_NetSrvInfo1515 {
	uint32_t enableforcedlogoff;
};

struct srvsvc_NetSrvInfo1516 {
	uint32_t timesource;
};

struct srvsvc_NetSrvInfo1518 {
	uint32_t lmannounce;
};

struct srvsvc_NetSrvInfo1520 {
	uint32_t maxcopyreadlen;
};

struct srvsvc_NetSrvInfo1521 {
	uint32_t maxcopywritelen;
};

struct srvsvc_NetSrvInfo1522 {
	uint32_t minkeepsearch;
};

struct srvsvc_NetSrvInfo1523 {
	uint32_t maxkeepsearch;
};

struct srvsvc_NetSrvInfo1524 {
	uint32_t minkeepcomplsearch;
};

struct srvsvc_NetSrvInfo1525 {
	uint32_t maxkeepcomplsearch;
};

struct srvsvc_NetSrvInfo1528 {
	uint32_t scavtimeout;
};

struct srvsvc_NetSrvInfo1529 {
	uint32_t minrcvqueue;
};

struct srvsvc_NetSrvInfo1530 {
	uint32_t minfreeworkitems;
};

struct srvsvc_NetSrvInfo1533 {
	uint32_t maxmpxct;
};

struct srvsvc_NetSrvInfo1534 {
	uint32_t oplockbreakwait;
};

struct srvsvc_NetSrvInfo1535 {
	uint32_t oplockbreakresponsewait;
};

struct srvsvc_NetSrvInfo1536 {
	uint32_t enableoplocks;
};

struct srvsvc_NetSrvInfo1537 {
	uint32_t enableoplockforceclose;
};

struct srvsvc_NetSrvInfo1538 {
	uint32_t enablefcbopens;
};

struct srvsvc_NetSrvInfo1539 {
	uint32_t enableraw;
};

struct srvsvc_NetSrvInfo1540 {
	uint32_t enablesharednetdrives;
};

struct srvsvc_NetSrvInfo1541 {
	uint32_t minfreeconnections;
};

struct srvsvc_NetSrvInfo1542 {
	uint32_t maxfreeconnections;
};

struct srvsvc_NetSrvInfo1543 {
	uint32_t initsesstable;
};

struct srvsvc_NetSrvInfo1544 {
	uint32_t initconntable;
};

struct srvsvc_NetSrvInfo1545 {
	uint32_t initfiletable;
};

struct srvsvc_NetSrvInfo1546 {
	uint32_t initsearchtable;
};

struct srvsvc_NetSrvInfo1547 {
	uint32_t alertsched;
};

struct srvsvc_NetSrvInfo1548 {
	uint32_t errortreshold;
};

struct srvsvc_NetSrvInfo1549 {
	uint32_t networkerrortreshold;
};

struct srvsvc_NetSrvInfo1550 {
	uint32_t diskspacetreshold;
};

struct srvsvc_NetSrvInfo1552 {
	uint32_t maxlinkdelay;
};

struct srvsvc_NetSrvInfo1553 {
	uint32_t minlinkthroughput;
};

struct srvsvc_NetSrvInfo1554 {
	uint32_t linkinfovalidtime;
};

struct srvsvc_NetSrvInfo1555 {
	uint32_t scavqosinfoupdatetime;
};

struct srvsvc_NetSrvInfo1556 {
	uint32_t maxworkitemidletime;
};

union srvsvc_NetSrvInfo {
	struct srvsvc_NetSrvInfo100 *info100;/* [case(100),unique] */
	struct srvsvc_NetSrvInfo101 *info101;/* [unique,case(101)] */
	struct srvsvc_NetSrvInfo102 *info102;/* [unique,case(102)] */
	struct srvsvc_NetSrvInfo402 *info402;/* [unique,case(402)] */
	struct srvsvc_NetSrvInfo403 *info403;/* [case(403),unique] */
	struct srvsvc_NetSrvInfo502 *info502;/* [case(502),unique] */
	struct srvsvc_NetSrvInfo503 *info503;/* [case(503),unique] */
	struct srvsvc_NetSrvInfo599 *info599;/* [unique,case(599)] */
	struct srvsvc_NetSrvInfo1005 *info1005;/* [unique,case(1005)] */
	struct srvsvc_NetSrvInfo1010 *info1010;/* [case(1010),unique] */
	struct srvsvc_NetSrvInfo1016 *info1016;/* [unique,case(1016)] */
	struct srvsvc_NetSrvInfo1017 *info1017;/* [case(1017),unique] */
	struct srvsvc_NetSrvInfo1018 *info1018;/* [unique,case(1018)] */
	struct srvsvc_NetSrvInfo1107 *info1107;/* [case(1107),unique] */
	struct srvsvc_NetSrvInfo1501 *info1501;/* [unique,case(1501)] */
	struct srvsvc_NetSrvInfo1502 *info1502;/* [case(1502),unique] */
	struct srvsvc_NetSrvInfo1503 *info1503;/* [unique,case(1503)] */
	struct srvsvc_NetSrvInfo1506 *info1506;/* [case(1506),unique] */
	struct srvsvc_NetSrvInfo1509 *info1509;/* [unique,case(1509)] */
	struct srvsvc_NetSrvInfo1510 *info1510;/* [unique,case(1510)] */
	struct srvsvc_NetSrvInfo1511 *info1511;/* [unique,case(1511)] */
	struct srvsvc_NetSrvInfo1512 *info1512;/* [unique,case(1512)] */
	struct srvsvc_NetSrvInfo1513 *info1513;/* [case(1513),unique] */
	struct srvsvc_NetSrvInfo1514 *info1514;/* [unique,case(1514)] */
	struct srvsvc_NetSrvInfo1515 *info1515;/* [unique,case(1515)] */
	struct srvsvc_NetSrvInfo1516 *info1516;/* [case(1516),unique] */
	struct srvsvc_NetSrvInfo1518 *info1518;/* [case(1518),unique] */
	struct srvsvc_NetSrvInfo1520 *info1520;/* [case(1520),unique] */
	struct srvsvc_NetSrvInfo1521 *info1521;/* [case(1521),unique] */
	struct srvsvc_NetSrvInfo1522 *info1522;/* [unique,case(1522)] */
	struct srvsvc_NetSrvInfo1523 *info1523;/* [case(1523),unique] */
	struct srvsvc_NetSrvInfo1524 *info1524;/* [unique,case(1524)] */
	struct srvsvc_NetSrvInfo1525 *info1525;/* [unique,case(1525)] */
	struct srvsvc_NetSrvInfo1528 *info1528;/* [case(1528),unique] */
	struct srvsvc_NetSrvInfo1529 *info1529;/* [unique,case(1529)] */
	struct srvsvc_NetSrvInfo1530 *info1530;/* [unique,case(1530)] */
	struct srvsvc_NetSrvInfo1533 *info1533;/* [case(1533),unique] */
	struct srvsvc_NetSrvInfo1534 *info1534;/* [unique,case(1534)] */
	struct srvsvc_NetSrvInfo1535 *info1535;/* [case(1535),unique] */
	struct srvsvc_NetSrvInfo1536 *info1536;/* [case(1536),unique] */
	struct srvsvc_NetSrvInfo1537 *info1537;/* [case(1537),unique] */
	struct srvsvc_NetSrvInfo1538 *info1538;/* [unique,case(1538)] */
	struct srvsvc_NetSrvInfo1539 *info1539;/* [case(1539),unique] */
	struct srvsvc_NetSrvInfo1540 *info1540;/* [unique,case(1540)] */
	struct srvsvc_NetSrvInfo1541 *info1541;/* [unique,case(1541)] */
	struct srvsvc_NetSrvInfo1542 *info1542;/* [unique,case(1542)] */
	struct srvsvc_NetSrvInfo1543 *info1543;/* [case(1543),unique] */
	struct srvsvc_NetSrvInfo1544 *info1544;/* [case(1544),unique] */
	struct srvsvc_NetSrvInfo1545 *info1545;/* [unique,case(1545)] */
	struct srvsvc_NetSrvInfo1546 *info1546;/* [unique,case(1546)] */
	struct srvsvc_NetSrvInfo1547 *info1547;/* [unique,case(1547)] */
	struct srvsvc_NetSrvInfo1548 *info1548;/* [case(1548),unique] */
	struct srvsvc_NetSrvInfo1549 *info1549;/* [unique,case(1549)] */
	struct srvsvc_NetSrvInfo1550 *info1550;/* [case(1550),unique] */
	struct srvsvc_NetSrvInfo1552 *info1552;/* [unique,case(1552)] */
	struct srvsvc_NetSrvInfo1553 *info1553;/* [unique,case(1553)] */
	struct srvsvc_NetSrvInfo1554 *info1554;/* [unique,case(1554)] */
	struct srvsvc_NetSrvInfo1555 *info1555;/* [case(1555),unique] */
	struct srvsvc_NetSrvInfo1556 *info1556;/* [unique,case(1556)] */
};

struct srvsvc_NetDiskInfo0 {
	uint32_t __disk_offset;/* [value(0)] */
	uint32_t __disk_length;/* [value(strlen(disk)+1)] */
	const char *disk;/* [charset(UTF16)] */
};

struct srvsvc_NetDiskInfo {
	uint32_t count;
	struct srvsvc_NetDiskInfo0 *disks;/* [length_is(count),size_is(count),unique] */
};

struct srvsvc_Statistics {
	uint32_t start;
	uint32_t fopens;
	uint32_t devopens;
	uint32_t jobsqueued;
	uint32_t sopens;
	uint32_t stimeouts;
	uint32_t serrorout;
	uint32_t pwerrors;
	uint32_t permerrors;
	uint32_t syserrors;
	uint32_t bytessent_low;
	uint32_t bytessent_high;
	uint32_t bytesrcvd_low;
	uint32_t bytesrcvd_high;
	uint32_t avresponse;
	uint32_t reqbufneed;
	uint32_t bigbufneed;
};

struct srvsvc_NetTransportInfo0 {
	uint32_t vcs;
	const char *name;/* [charset(UTF16),unique] */
	uint8_t *addr;/* [size_is(addr_len),unique] */
	uint32_t addr_len;
	const char *net_addr;/* [unique,charset(UTF16)] */
};

struct srvsvc_NetTransportCtr0 {
	uint32_t count;
	struct srvsvc_NetTransportInfo0 *array;/* [unique,size_is(count)] */
};

struct srvsvc_NetTransportInfo1 {
	uint32_t vcs;
	const char *name;/* [unique,charset(UTF16)] */
	uint8_t *addr;/* [unique,size_is(addr_len)] */
	uint32_t addr_len;
	const char *net_addr;/* [charset(UTF16),unique] */
	const char *domain;/* [charset(UTF16),unique] */
};

struct srvsvc_NetTransportCtr1 {
	uint32_t count;
	struct srvsvc_NetTransportInfo1 *array;/* [size_is(count),unique] */
};

struct srvsvc_NetTransportInfo2 {
	uint32_t vcs;
	const char *name;/* [charset(UTF16),unique] */
	uint8_t *addr;/* [unique,size_is(addr_len)] */
	uint32_t addr_len;
	const char *net_addr;/* [charset(UTF16),unique] */
	const char *domain;/* [charset(UTF16),unique] */
	uint32_t unknown;
};

struct srvsvc_NetTransportCtr2 {
	uint32_t count;
	struct srvsvc_NetTransportInfo2 *array;/* [unique,size_is(count)] */
};

struct srvsvc_NetTransportInfo3 {
	uint32_t vcs;
	const char *name;/* [unique,charset(UTF16)] */
	uint8_t *addr;/* [size_is(addr_len),unique] */
	uint32_t addr_len;
	const char *net_addr;/* [charset(UTF16),unique] */
	const char *domain;/* [charset(UTF16),unique] */
	uint32_t unknown1;
	uint32_t unknown2;
	uint8_t unknown3[256];
};

struct srvsvc_NetTransportCtr3 {
	uint32_t count;
	struct srvsvc_NetTransportInfo3 *array;/* [size_is(count),unique] */
};

union srvsvc_NetTransportCtr {
	struct srvsvc_NetTransportCtr0 *ctr0;/* [case(0),unique] */
	struct srvsvc_NetTransportCtr1 *ctr1;/* [case,unique] */
	struct srvsvc_NetTransportCtr2 *ctr2;/* [unique,case(2)] */
	struct srvsvc_NetTransportCtr3 *ctr3;/* [case(3),unique] */
};

struct srvsvc_NetTransportInfoCtr {
	uint32_t level;
	union srvsvc_NetTransportCtr ctr;/* [switch_is(level)] */
};

struct srvsvc_NetRemoteTODInfo {
	uint32_t elapsed;
	uint32_t msecs;
	uint32_t hours;
	uint32_t mins;
	uint32_t secs;
	uint32_t hunds;
	int32_t timezone;
	uint32_t tinterval;
	uint32_t day;
	uint32_t month;
	uint32_t year;
	uint32_t weekday;
};

union srvsvc_NetTransportInfo {
	struct srvsvc_NetTransportInfo0 info0;/* [case(0)] */
	struct srvsvc_NetTransportInfo1 info1;/* [case] */
	struct srvsvc_NetTransportInfo2 info2;/* [case(2)] */
	struct srvsvc_NetTransportInfo3 info3;/* [case(3)] */
}/* [switch_type(uint32)] */;


struct srvsvc_NetCharDevEnum {
	struct {
		const char *server_unc;/* [charset(UTF16),unique] */
		uint32_t max_buffer;
		struct srvsvc_NetCharDevInfoCtr *info_ctr;/* [ref] */
		uint32_t *resume_handle;/* [unique] */
	} in;

	struct {
		uint32_t *totalentries;/* [ref] */
		struct srvsvc_NetCharDevInfoCtr *info_ctr;/* [ref] */
		uint32_t *resume_handle;/* [unique] */
		WERROR result;
	} out;

};


struct srvsvc_NetCharDevGetInfo {
	struct {
		const char *server_unc;/* [charset(UTF16),unique] */
		const char *device_name;/* [charset(UTF16)] */
		uint32_t level;
	} in;

	struct {
		union srvsvc_NetCharDevInfo *info;/* [switch_is(level),ref] */
		WERROR result;
	} out;

};


struct srvsvc_NetCharDevControl {
	struct {
		const char *server_unc;/* [charset(UTF16),unique] */
		const char *device_name;/* [charset(UTF16)] */
		uint32_t opcode;
	} in;

	struct {
		WERROR result;
	} out;

};


struct srvsvc_NetCharDevQEnum {
	struct {
		const char *server_unc;/* [charset(UTF16),unique] */
		const char *user;/* [unique,charset(UTF16)] */
		uint32_t max_buffer;
		struct srvsvc_NetCharDevQInfoCtr *info_ctr;/* [ref] */
		uint32_t *resume_handle;/* [unique] */
	} in;

	struct {
		uint32_t *totalentries;/* [ref] */
		struct srvsvc_NetCharDevQInfoCtr *info_ctr;/* [ref] */
		uint32_t *resume_handle;/* [unique] */
		WERROR result;
	} out;

};


struct srvsvc_NetCharDevQGetInfo {
	struct {
		const char *server_unc;/* [unique,charset(UTF16)] */
		const char *queue_name;/* [charset(UTF16)] */
		const char *user;/* [charset(UTF16)] */
		uint32_t level;
	} in;

	struct {
		union srvsvc_NetCharDevQInfo *info;/* [ref,switch_is(level)] */
		WERROR result;
	} out;

};


struct srvsvc_NetCharDevQSetInfo {
	struct {
		const char *server_unc;/* [unique,charset(UTF16)] */
		const char *queue_name;/* [charset(UTF16)] */
		uint32_t level;
		union srvsvc_NetCharDevQInfo info;/* [switch_is(level)] */
		uint32_t *parm_error;/* [unique] */
	} in;

	struct {
		uint32_t *parm_error;/* [unique] */
		WERROR result;
	} out;

};


struct srvsvc_NetCharDevQPurge {
	struct {
		const char *server_unc;/* [charset(UTF16),unique] */
		const char *queue_name;/* [charset(UTF16)] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct srvsvc_NetCharDevQPurgeSelf {
	struct {
		const char *server_unc;/* [charset(UTF16),unique] */
		const char *queue_name;/* [charset(UTF16)] */
		const char *computer_name;/* [charset(UTF16)] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct srvsvc_NetConnEnum {
	struct {
		const char *server_unc;/* [charset(UTF16),unique] */
		const char *path;/* [charset(UTF16),unique] */
		uint32_t max_buffer;
		struct srvsvc_NetConnInfoCtr *info_ctr;/* [ref] */
		uint32_t *resume_handle;/* [unique] */
	} in;

	struct {
		uint32_t *totalentries;/* [ref] */
		struct srvsvc_NetConnInfoCtr *info_ctr;/* [ref] */
		uint32_t *resume_handle;/* [unique] */
		WERROR result;
	} out;

};


struct srvsvc_NetFileEnum {
	struct {
		const char *server_unc;/* [unique,charset(UTF16)] */
		const char *path;/* [unique,charset(UTF16)] */
		const char *user;/* [unique,charset(UTF16)] */
		uint32_t max_buffer;
		struct srvsvc_NetFileInfoCtr *info_ctr;/* [ref] */
		uint32_t *resume_handle;/* [unique] */
	} in;

	struct {
		uint32_t *totalentries;/* [ref] */
		struct srvsvc_NetFileInfoCtr *info_ctr;/* [ref] */
		uint32_t *resume_handle;/* [unique] */
		WERROR result;
	} out;

};


struct srvsvc_NetFileGetInfo {
	struct {
		const char *server_unc;/* [charset(UTF16),unique] */
		uint32_t fid;
		uint32_t level;
	} in;

	struct {
		union srvsvc_NetFileInfo *info;/* [switch_is(level),ref] */
		WERROR result;
	} out;

};


struct srvsvc_NetFileClose {
	struct {
		const char *server_unc;/* [unique,charset(UTF16)] */
		uint32_t fid;
	} in;

	struct {
		WERROR result;
	} out;

};


struct srvsvc_NetSessEnum {
	struct {
		const char *server_unc;/* [unique,charset(UTF16)] */
		const char *client;/* [charset(UTF16),unique] */
		const char *user;/* [unique,charset(UTF16)] */
		uint32_t max_buffer;
		struct srvsvc_NetSessInfoCtr *info_ctr;/* [ref] */
		uint32_t *resume_handle;/* [unique] */
	} in;

	struct {
		uint32_t *totalentries;/* [ref] */
		struct srvsvc_NetSessInfoCtr *info_ctr;/* [ref] */
		uint32_t *resume_handle;/* [unique] */
		WERROR result;
	} out;

};


struct srvsvc_NetSessDel {
	struct {
		const char *server_unc;/* [charset(UTF16),unique] */
		const char *client;/* [charset(UTF16),unique] */
		const char *user;/* [charset(UTF16),unique] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct srvsvc_NetShareAdd {
	struct {
		const char *server_unc;/* [charset(UTF16),unique] */
		uint32_t level;
		union srvsvc_NetShareInfo *info;/* [ref,switch_is(level)] */
		uint32_t *parm_error;/* [unique] */
	} in;

	struct {
		uint32_t *parm_error;/* [unique] */
		WERROR result;
	} out;

};


struct srvsvc_NetShareEnumAll {
	struct {
		const char *server_unc;/* [unique,charset(UTF16)] */
		uint32_t max_buffer;
		struct srvsvc_NetShareInfoCtr *info_ctr;/* [ref] */
		uint32_t *resume_handle;/* [unique] */
	} in;

	struct {
		uint32_t *totalentries;/* [ref] */
		struct srvsvc_NetShareInfoCtr *info_ctr;/* [ref] */
		uint32_t *resume_handle;/* [unique] */
		WERROR result;
	} out;

};


struct srvsvc_NetShareGetInfo {
	struct {
		const char *server_unc;/* [charset(UTF16),unique] */
		const char *share_name;/* [charset(UTF16)] */
		uint32_t level;
	} in;

	struct {
		union srvsvc_NetShareInfo *info;/* [ref,switch_is(level)] */
		WERROR result;
	} out;

};


struct srvsvc_NetShareSetInfo {
	struct {
		const char *server_unc;/* [charset(UTF16),unique] */
		const char *share_name;/* [charset(UTF16)] */
		uint32_t level;
		union srvsvc_NetShareInfo *info;/* [switch_is(level),ref] */
		uint32_t *parm_error;/* [unique] */
	} in;

	struct {
		uint32_t *parm_error;/* [unique] */
		WERROR result;
	} out;

};


struct srvsvc_NetShareDel {
	struct {
		const char *server_unc;/* [charset(UTF16),unique] */
		const char *share_name;/* [charset(UTF16)] */
		uint32_t reserved;
	} in;

	struct {
		WERROR result;
	} out;

};


struct srvsvc_NetShareDelSticky {
	struct {
		const char *server_unc;/* [charset(UTF16),unique] */
		const char *share_name;/* [charset(UTF16)] */
		uint32_t reserved;
	} in;

	struct {
		WERROR result;
	} out;

};


struct srvsvc_NetShareCheck {
	struct {
		const char *server_unc;/* [charset(UTF16),unique] */
		const char *device_name;/* [charset(UTF16)] */
	} in;

	struct {
		enum srvsvc_ShareType *type;/* [ref] */
		WERROR result;
	} out;

};


struct srvsvc_NetSrvGetInfo {
	struct {
		const char *server_unc;/* [charset(UTF16),unique] */
		uint32_t level;
	} in;

	struct {
		union srvsvc_NetSrvInfo *info;/* [switch_is(level),ref] */
		WERROR result;
	} out;

};


struct srvsvc_NetSrvSetInfo {
	struct {
		const char *server_unc;/* [charset(UTF16),unique] */
		uint32_t level;
		union srvsvc_NetSrvInfo *info;/* [ref,switch_is(level)] */
		uint32_t *parm_error;/* [unique] */
	} in;

	struct {
		uint32_t *parm_error;/* [unique] */
		WERROR result;
	} out;

};


struct srvsvc_NetDiskEnum {
	struct {
		const char *server_unc;/* [unique,charset(UTF16)] */
		uint32_t level;
		uint32_t maxlen;
		struct srvsvc_NetDiskInfo *info;/* [ref] */
		uint32_t *resume_handle;/* [unique] */
	} in;

	struct {
		uint32_t *totalentries;/* [ref] */
		struct srvsvc_NetDiskInfo *info;/* [ref] */
		uint32_t *resume_handle;/* [unique] */
		WERROR result;
	} out;

};


struct srvsvc_NetServerStatisticsGet {
	struct {
		const char *server_unc;/* [charset(UTF16),unique] */
		const char *service;/* [charset(UTF16),unique] */
		uint32_t level;
		uint32_t options;
	} in;

	struct {
		struct srvsvc_Statistics **stats;/* [ref] */
		WERROR result;
	} out;

};


struct srvsvc_NetTransportAdd {
	struct {
		const char *server_unc;/* [unique,charset(UTF16)] */
		uint32_t level;
		union srvsvc_NetTransportInfo info;/* [switch_is(level)] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct srvsvc_NetTransportEnum {
	struct {
		const char *server_unc;/* [charset(UTF16),unique] */
		uint32_t max_buffer;
		struct srvsvc_NetTransportInfoCtr *transports;/* [ref] */
		uint32_t *resume_handle;/* [unique] */
	} in;

	struct {
		uint32_t *totalentries;/* [ref] */
		struct srvsvc_NetTransportInfoCtr *transports;/* [ref] */
		uint32_t *resume_handle;/* [unique] */
		WERROR result;
	} out;

};


struct srvsvc_NetTransportDel {
	struct {
		const char *server_unc;/* [charset(UTF16),unique] */
		uint32_t level;
		struct srvsvc_NetTransportInfo0 *info0;/* [ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct srvsvc_NetRemoteTOD {
	struct {
		const char *server_unc;/* [unique,charset(UTF16)] */
	} in;

	struct {
		struct srvsvc_NetRemoteTODInfo **info;/* [ref] */
		WERROR result;
	} out;

};


struct srvsvc_NetSetServiceBits {
	struct {
		const char *server_unc;/* [unique,charset(UTF16)] */
		const char *transport;/* [charset(UTF16),unique] */
		uint32_t servicebits;
		uint32_t updateimmediately;
	} in;

	struct {
		WERROR result;
	} out;

};


struct srvsvc_NetPathType {
	struct {
		const char *server_unc;/* [unique,charset(UTF16)] */
		const char *path;/* [charset(UTF16)] */
		uint32_t pathflags;
	} in;

	struct {
		uint32_t *pathtype;/* [ref] */
		WERROR result;
	} out;

};


struct srvsvc_NetPathCanonicalize {
	struct {
		const char *server_unc;/* [unique,charset(UTF16)] */
		const char *path;/* [charset(UTF16)] */
		uint32_t maxbuf;
		const char *prefix;/* [charset(UTF16)] */
		uint32_t pathflags;
		uint32_t *pathtype;/* [ref] */
	} in;

	struct {
		uint8_t *can_path;/* [size_is(maxbuf)] */
		uint32_t *pathtype;/* [ref] */
		WERROR result;
	} out;

};


struct srvsvc_NetPathCompare {
	struct {
		const char *server_unc;/* [unique,charset(UTF16)] */
		const char *path1;/* [charset(UTF16)] */
		const char *path2;/* [charset(UTF16)] */
		uint32_t pathtype;
		uint32_t pathflags;
	} in;

	struct {
		WERROR result;
	} out;

};


struct srvsvc_NetNameValidate {
	struct {
		const char *server_unc;/* [charset(UTF16),unique] */
		const char *name;/* [charset(UTF16)] */
		uint32_t name_type;
		uint32_t flags;
	} in;

	struct {
		WERROR result;
	} out;

};


struct srvsvc_NETRPRNAMECANONICALIZE {
	struct {
		WERROR result;
	} out;

};


struct srvsvc_NetPRNameCompare {
	struct {
		const char *server_unc;/* [unique,charset(UTF16)] */
		const char *name1;/* [charset(UTF16)] */
		const char *name2;/* [charset(UTF16)] */
		uint32_t name_type;
		uint32_t flags;
	} in;

	struct {
		WERROR result;
	} out;

};


struct srvsvc_NetShareEnum {
	struct {
		const char *server_unc;/* [charset(UTF16),unique] */
		uint32_t max_buffer;
		struct srvsvc_NetShareInfoCtr *info_ctr;/* [ref] */
		uint32_t *resume_handle;/* [unique] */
	} in;

	struct {
		uint32_t *totalentries;/* [ref] */
		struct srvsvc_NetShareInfoCtr *info_ctr;/* [ref] */
		uint32_t *resume_handle;/* [unique] */
		WERROR result;
	} out;

};


struct srvsvc_NetShareDelStart {
	struct {
		const char *server_unc;/* [unique,charset(UTF16)] */
		const char *share;/* [charset(UTF16)] */
		uint32_t reserved;
	} in;

	struct {
		struct policy_handle *hnd;/* [unique] */
		WERROR result;
	} out;

};


struct srvsvc_NetShareDelCommit {
	struct {
		struct policy_handle *hnd;/* [unique] */
	} in;

	struct {
		struct policy_handle *hnd;/* [unique] */
		WERROR result;
	} out;

};


struct srvsvc_NetGetFileSecurity {
	struct {
		const char *server_unc;/* [unique,charset(UTF16)] */
		const char *share;/* [charset(UTF16),unique] */
		const char *file;/* [charset(UTF16)] */
		uint32_t securityinformation;
	} in;

	struct {
		struct sec_desc_buf **sd_buf;/* [ref] */
		WERROR result;
	} out;

};


struct srvsvc_NetSetFileSecurity {
	struct {
		const char *server_unc;/* [unique,charset(UTF16)] */
		const char *share;/* [unique,charset(UTF16)] */
		const char *file;/* [charset(UTF16)] */
		uint32_t securityinformation;
		struct sec_desc_buf *sd_buf;/* [ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct srvsvc_NetServerTransportAddEx {
	struct {
		const char *server_unc;/* [unique,charset(UTF16)] */
		uint32_t level;
		union srvsvc_NetTransportInfo info;/* [switch_is(level)] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct srvsvc_NetServerSetServiceBitsEx {
	struct {
		const char *server_unc;/* [unique,charset(UTF16)] */
		const char *emulated_server_unc;/* [charset(UTF16),unique] */
		const char *transport;/* [unique,charset(UTF16)] */
		uint32_t servicebitsofinterest;
		uint32_t servicebits;
		uint32_t updateimmediately;
	} in;

	struct {
		WERROR result;
	} out;

};


struct srvsvc_NETRDFSGETVERSION {
	struct {
		WERROR result;
	} out;

};


struct srvsvc_NETRDFSCREATELOCALPARTITION {
	struct {
		WERROR result;
	} out;

};


struct srvsvc_NETRDFSDELETELOCALPARTITION {
	struct {
		WERROR result;
	} out;

};


struct srvsvc_NETRDFSSETLOCALVOLUMESTATE {
	struct {
		WERROR result;
	} out;

};


struct srvsvc_NETRDFSSETSERVERINFO {
	struct {
		WERROR result;
	} out;

};


struct srvsvc_NETRDFSCREATEEXITPOINT {
	struct {
		WERROR result;
	} out;

};


struct srvsvc_NETRDFSDELETEEXITPOINT {
	struct {
		WERROR result;
	} out;

};


struct srvsvc_NETRDFSMODIFYPREFIX {
	struct {
		WERROR result;
	} out;

};


struct srvsvc_NETRDFSFIXLOCALVOLUME {
	struct {
		WERROR result;
	} out;

};


struct srvsvc_NETRDFSMANAGERREPORTSITEINFO {
	struct {
		WERROR result;
	} out;

};


struct srvsvc_NETRSERVERTRANSPORTDELEX {
	struct {
		WERROR result;
	} out;

};

#endif /* _HEADER_srvsvc */
#endif /* _PIDL_HEADER_srvsvc */
