
/* Python wrapper functions auto-generated by pidl */
#include <Python.h>
#include "includes.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "autoconf/librpc/gen_ndr/ndr_frsrpc.h"
#include "autoconf/librpc/gen_ndr/ndr_frsrpc_c.h"

#include "librpc/gen_ndr/misc.h"
staticforward PyTypeObject frsrpc_CommPktChunkGuidName_Type;
staticforward PyTypeObject frsrpc_CommPktGSVN_Type;
staticforward PyTypeObject frsrpc_CommPktChangeOrderCommand_Type;
staticforward PyTypeObject frsrpc_CommPktDataExtensionChecksum_Type;
staticforward PyTypeObject frsrpc_CommPktDataExtensionRetryTimeout_Type;
staticforward PyTypeObject frsrpc_CommPktCoRecordExtensionWin2k_Type;
staticforward PyTypeObject frsrpc_CommPktChangeOrderRecordExtension_Type;
staticforward PyTypeObject frsrpc_CommPktChunk_Type;
staticforward PyTypeObject frsrpc_CommPktChunkCtr_Type;
staticforward PyTypeObject frsrpc_FrsSendCommPktReq_Type;
staticforward PyTypeObject frsrpc_InterfaceType;

void initfrsrpc(void);static PyTypeObject *ClientConnection_Type;
static PyTypeObject *GUID_Type;
static PyTypeObject *Object_Type;

static PyObject *py_frsrpc_CommPktChunkGuidName_get_guid(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChunkGuidName *object = (struct frsrpc_CommPktChunkGuidName *)pytalloc_get_ptr(obj);
	PyObject *py_guid;
	py_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->guid);
	return py_guid;
}

static int py_frsrpc_CommPktChunkGuidName_set_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChunkGuidName *object = (struct frsrpc_CommPktChunkGuidName *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChunkGuidName_get_name(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChunkGuidName *object = (struct frsrpc_CommPktChunkGuidName *)pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = PyString_FromStringOrNULL(object->name);
	return py_name;
}

static int py_frsrpc_CommPktChunkGuidName_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChunkGuidName *object = (struct frsrpc_CommPktChunkGuidName *)pytalloc_get_ptr(py_obj);
	object->name = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyGetSetDef py_frsrpc_CommPktChunkGuidName_getsetters[] = {
	{ discard_const_p(char, "guid"), py_frsrpc_CommPktChunkGuidName_get_guid, py_frsrpc_CommPktChunkGuidName_set_guid },
	{ discard_const_p(char, "name"), py_frsrpc_CommPktChunkGuidName_get_name, py_frsrpc_CommPktChunkGuidName_set_name },
	{ NULL }
};

static PyObject *py_frsrpc_CommPktChunkGuidName_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct frsrpc_CommPktChunkGuidName, type);
}


static PyTypeObject frsrpc_CommPktChunkGuidName_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "frsrpc.CommPktChunkGuidName",
	.tp_getset = py_frsrpc_CommPktChunkGuidName_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_frsrpc_CommPktChunkGuidName_new,
};


static PyObject *py_frsrpc_CommPktGSVN_get_vsn(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktGSVN *object = (struct frsrpc_CommPktGSVN *)pytalloc_get_ptr(obj);
	PyObject *py_vsn;
	py_vsn = PyLong_FromLongLong(object->vsn);
	return py_vsn;
}

static int py_frsrpc_CommPktGSVN_set_vsn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktGSVN *object = (struct frsrpc_CommPktGSVN *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->vsn = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->vsn = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_CommPktGSVN_get_guid(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktGSVN *object = (struct frsrpc_CommPktGSVN *)pytalloc_get_ptr(obj);
	PyObject *py_guid;
	py_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->guid);
	return py_guid;
}

static int py_frsrpc_CommPktGSVN_set_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktGSVN *object = (struct frsrpc_CommPktGSVN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_frsrpc_CommPktGSVN_getsetters[] = {
	{ discard_const_p(char, "vsn"), py_frsrpc_CommPktGSVN_get_vsn, py_frsrpc_CommPktGSVN_set_vsn },
	{ discard_const_p(char, "guid"), py_frsrpc_CommPktGSVN_get_guid, py_frsrpc_CommPktGSVN_set_guid },
	{ NULL }
};

static PyObject *py_frsrpc_CommPktGSVN_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct frsrpc_CommPktGSVN, type);
}


static PyTypeObject frsrpc_CommPktGSVN_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "frsrpc.CommPktGSVN",
	.tp_getset = py_frsrpc_CommPktGSVN_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_frsrpc_CommPktGSVN_new,
};


static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_sequence_number(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_sequence_number;
	py_sequence_number = PyInt_FromLong(object->sequence_number);
	return py_sequence_number;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_sequence_number(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sequence_number = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_flags(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->flags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->flags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_iflags(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_iflags;
	py_iflags = PyInt_FromLong(object->iflags);
	return py_iflags;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_iflags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->iflags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->iflags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_status(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyInt_FromLong(object->status);
	return py_status;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->status = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->status = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_content_cmd(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_content_cmd;
	py_content_cmd = PyInt_FromLong(object->content_cmd);
	return py_content_cmd;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_content_cmd(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->content_cmd = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->content_cmd = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_location_cmd(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_location_cmd;
	py_location_cmd = PyInt_FromLong(object->location_cmd);
	return py_location_cmd;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_location_cmd(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->location_cmd = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->location_cmd = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_file_attributes(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_file_attributes;
	py_file_attributes = PyInt_FromLong(object->file_attributes);
	return py_file_attributes;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_file_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->file_attributes = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_file_version_number(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_file_version_number;
	py_file_version_number = PyInt_FromLong(object->file_version_number);
	return py_file_version_number;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_file_version_number(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->file_version_number = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_partern_ack_sequence_number(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_partern_ack_sequence_number;
	py_partern_ack_sequence_number = PyInt_FromLong(object->partern_ack_sequence_number);
	return py_partern_ack_sequence_number;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_partern_ack_sequence_number(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->partern_ack_sequence_number = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_not_used(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_not_used;
	py_not_used = PyInt_FromLong(object->not_used);
	return py_not_used;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_not_used(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->not_used = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_file_size(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_file_size;
	py_file_size = PyLong_FromLongLong(object->file_size);
	return py_file_size;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_file_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->file_size = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->file_size = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_file_offset(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_file_offset;
	py_file_offset = PyLong_FromLongLong(object->file_offset);
	return py_file_offset;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_file_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->file_offset = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->file_offset = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_frs_vsn(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_frs_vsn;
	py_frs_vsn = PyLong_FromLongLong(object->frs_vsn);
	return py_frs_vsn;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_frs_vsn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->frs_vsn = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->frs_vsn = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_file_usn(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_file_usn;
	py_file_usn = PyLong_FromLongLong(object->file_usn);
	return py_file_usn;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_file_usn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->file_usn = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->file_usn = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_jrnl_usn(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_jrnl_usn;
	py_jrnl_usn = PyLong_FromLongLong(object->jrnl_usn);
	return py_jrnl_usn;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_jrnl_usn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->jrnl_usn = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->jrnl_usn = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_jrnl_first_usn(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_jrnl_first_usn;
	py_jrnl_first_usn = PyLong_FromLongLong(object->jrnl_first_usn);
	return py_jrnl_first_usn;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_jrnl_first_usn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->jrnl_first_usn = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->jrnl_first_usn = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_original_replica_num(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_original_replica_num;
	py_original_replica_num = PyInt_FromLong(object->original_replica_num);
	return py_original_replica_num;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_original_replica_num(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->original_replica_num = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_new_replica_num(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_new_replica_num;
	py_new_replica_num = PyInt_FromLong(object->new_replica_num);
	return py_new_replica_num;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_new_replica_num(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->new_replica_num = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_change_order_guid(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_change_order_guid;
	py_change_order_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->change_order_guid);
	return py_change_order_guid;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_change_order_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->change_order_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_originator_guid(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_originator_guid;
	py_originator_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->originator_guid);
	return py_originator_guid;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_originator_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->originator_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_file_guid(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_file_guid;
	py_file_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->file_guid);
	return py_file_guid;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_file_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->file_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_old_parent_guid(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_old_parent_guid;
	py_old_parent_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->old_parent_guid);
	return py_old_parent_guid;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_old_parent_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->old_parent_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_new_parent_guid(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_new_parent_guid;
	py_new_parent_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->new_parent_guid);
	return py_new_parent_guid;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_new_parent_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->new_parent_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_connection_guid(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_connection_guid;
	py_connection_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->connection_guid);
	return py_connection_guid;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_connection_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->connection_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_ack_version(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_ack_version;
	py_ack_version = PyLong_FromLongLong(object->ack_version);
	return py_ack_version;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_ack_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->ack_version = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->ack_version = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_spare2ul1(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_spare2ul1;
	py_spare2ul1 = PyLong_FromLongLong(object->spare2ul1);
	return py_spare2ul1;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_spare2ul1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->spare2ul1 = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->spare2ul1 = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_spare1guid_p1(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_spare1guid_p1;
	py_spare1guid_p1 = PyLong_FromLongLong(object->spare1guid_p1);
	return py_spare1guid_p1;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_spare1guid_p1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->spare1guid_p1 = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->spare1guid_p1 = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_spare1guid_p2(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_spare1guid_p2;
	py_spare1guid_p2 = PyLong_FromLongLong(object->spare1guid_p2);
	return py_spare1guid_p2;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_spare1guid_p2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->spare1guid_p2 = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->spare1guid_p2 = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_spare2guid_p1(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_spare2guid_p1;
	py_spare2guid_p1 = PyLong_FromLongLong(object->spare2guid_p1);
	return py_spare2guid_p1;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_spare2guid_p1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->spare2guid_p1 = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->spare2guid_p1 = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_spare3guid_p2(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_spare3guid_p2;
	py_spare3guid_p2 = PyLong_FromLongLong(object->spare3guid_p2);
	return py_spare3guid_p2;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_spare3guid_p2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->spare3guid_p2 = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->spare3guid_p2 = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_spare1wcs(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_spare1wcs;
	py_spare1wcs = PyInt_FromLong(object->spare1wcs);
	return py_spare1wcs;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_spare1wcs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->spare1wcs = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_spare2wcs(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_spare2wcs;
	py_spare2wcs = PyInt_FromLong(object->spare2wcs);
	return py_spare2wcs;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_spare2wcs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->spare2wcs = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_extension(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_extension;
	py_extension = PyInt_FromLong(object->extension);
	return py_extension;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_extension(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->extension = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_spare2bin(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_spare2bin;
	py_spare2bin = PyInt_FromLong(object->spare2bin);
	return py_spare2bin;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_spare2bin(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->spare2bin = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_event_time(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_event_time;
	py_event_time = PyLong_FromLongLong(object->event_time);
	return py_event_time;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_event_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->event_time = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->event_time = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_file_name_length(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_file_name_length;
	py_file_name_length = PyInt_FromLong(object->file_name_length);
	return py_file_name_length;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_file_name_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->file_name_length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_file_name(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_file_name;
	if (object->file_name == NULL) {
		py_file_name = Py_None;
		Py_INCREF(py_file_name);
	} else {
		py_file_name = PyUnicode_Decode(object->file_name, strlen(object->file_name), "utf-8", "ignore");
	}
	return py_file_name;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_file_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	if (PyUnicode_Check(value)) {
		object->file_name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	} else if (PyString_Check(value)) {
		object->file_name = PyString_AS_STRING(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_padding1(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_padding1;
	py_padding1 = PyInt_FromLong(object->padding1);
	return py_padding1;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_padding1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->padding1 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_padding2(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_padding2;
	py_padding2 = PyInt_FromLong(object->padding2);
	return py_padding2;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_padding2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->padding2 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_padding3(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_padding3;
	py_padding3 = PyInt_FromLong(object->padding3);
	return py_padding3;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_padding3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->padding3 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderCommand_get_padding4(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(obj);
	PyObject *py_padding4;
	py_padding4 = PyInt_FromLong(object->padding4);
	return py_padding4;
}

static int py_frsrpc_CommPktChangeOrderCommand_set_padding4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderCommand *object = (struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->padding4 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_frsrpc_CommPktChangeOrderCommand_getsetters[] = {
	{ discard_const_p(char, "sequence_number"), py_frsrpc_CommPktChangeOrderCommand_get_sequence_number, py_frsrpc_CommPktChangeOrderCommand_set_sequence_number },
	{ discard_const_p(char, "flags"), py_frsrpc_CommPktChangeOrderCommand_get_flags, py_frsrpc_CommPktChangeOrderCommand_set_flags },
	{ discard_const_p(char, "iflags"), py_frsrpc_CommPktChangeOrderCommand_get_iflags, py_frsrpc_CommPktChangeOrderCommand_set_iflags },
	{ discard_const_p(char, "status"), py_frsrpc_CommPktChangeOrderCommand_get_status, py_frsrpc_CommPktChangeOrderCommand_set_status },
	{ discard_const_p(char, "content_cmd"), py_frsrpc_CommPktChangeOrderCommand_get_content_cmd, py_frsrpc_CommPktChangeOrderCommand_set_content_cmd },
	{ discard_const_p(char, "location_cmd"), py_frsrpc_CommPktChangeOrderCommand_get_location_cmd, py_frsrpc_CommPktChangeOrderCommand_set_location_cmd },
	{ discard_const_p(char, "file_attributes"), py_frsrpc_CommPktChangeOrderCommand_get_file_attributes, py_frsrpc_CommPktChangeOrderCommand_set_file_attributes },
	{ discard_const_p(char, "file_version_number"), py_frsrpc_CommPktChangeOrderCommand_get_file_version_number, py_frsrpc_CommPktChangeOrderCommand_set_file_version_number },
	{ discard_const_p(char, "partern_ack_sequence_number"), py_frsrpc_CommPktChangeOrderCommand_get_partern_ack_sequence_number, py_frsrpc_CommPktChangeOrderCommand_set_partern_ack_sequence_number },
	{ discard_const_p(char, "not_used"), py_frsrpc_CommPktChangeOrderCommand_get_not_used, py_frsrpc_CommPktChangeOrderCommand_set_not_used },
	{ discard_const_p(char, "file_size"), py_frsrpc_CommPktChangeOrderCommand_get_file_size, py_frsrpc_CommPktChangeOrderCommand_set_file_size },
	{ discard_const_p(char, "file_offset"), py_frsrpc_CommPktChangeOrderCommand_get_file_offset, py_frsrpc_CommPktChangeOrderCommand_set_file_offset },
	{ discard_const_p(char, "frs_vsn"), py_frsrpc_CommPktChangeOrderCommand_get_frs_vsn, py_frsrpc_CommPktChangeOrderCommand_set_frs_vsn },
	{ discard_const_p(char, "file_usn"), py_frsrpc_CommPktChangeOrderCommand_get_file_usn, py_frsrpc_CommPktChangeOrderCommand_set_file_usn },
	{ discard_const_p(char, "jrnl_usn"), py_frsrpc_CommPktChangeOrderCommand_get_jrnl_usn, py_frsrpc_CommPktChangeOrderCommand_set_jrnl_usn },
	{ discard_const_p(char, "jrnl_first_usn"), py_frsrpc_CommPktChangeOrderCommand_get_jrnl_first_usn, py_frsrpc_CommPktChangeOrderCommand_set_jrnl_first_usn },
	{ discard_const_p(char, "original_replica_num"), py_frsrpc_CommPktChangeOrderCommand_get_original_replica_num, py_frsrpc_CommPktChangeOrderCommand_set_original_replica_num },
	{ discard_const_p(char, "new_replica_num"), py_frsrpc_CommPktChangeOrderCommand_get_new_replica_num, py_frsrpc_CommPktChangeOrderCommand_set_new_replica_num },
	{ discard_const_p(char, "change_order_guid"), py_frsrpc_CommPktChangeOrderCommand_get_change_order_guid, py_frsrpc_CommPktChangeOrderCommand_set_change_order_guid },
	{ discard_const_p(char, "originator_guid"), py_frsrpc_CommPktChangeOrderCommand_get_originator_guid, py_frsrpc_CommPktChangeOrderCommand_set_originator_guid },
	{ discard_const_p(char, "file_guid"), py_frsrpc_CommPktChangeOrderCommand_get_file_guid, py_frsrpc_CommPktChangeOrderCommand_set_file_guid },
	{ discard_const_p(char, "old_parent_guid"), py_frsrpc_CommPktChangeOrderCommand_get_old_parent_guid, py_frsrpc_CommPktChangeOrderCommand_set_old_parent_guid },
	{ discard_const_p(char, "new_parent_guid"), py_frsrpc_CommPktChangeOrderCommand_get_new_parent_guid, py_frsrpc_CommPktChangeOrderCommand_set_new_parent_guid },
	{ discard_const_p(char, "connection_guid"), py_frsrpc_CommPktChangeOrderCommand_get_connection_guid, py_frsrpc_CommPktChangeOrderCommand_set_connection_guid },
	{ discard_const_p(char, "ack_version"), py_frsrpc_CommPktChangeOrderCommand_get_ack_version, py_frsrpc_CommPktChangeOrderCommand_set_ack_version },
	{ discard_const_p(char, "spare2ul1"), py_frsrpc_CommPktChangeOrderCommand_get_spare2ul1, py_frsrpc_CommPktChangeOrderCommand_set_spare2ul1 },
	{ discard_const_p(char, "spare1guid_p1"), py_frsrpc_CommPktChangeOrderCommand_get_spare1guid_p1, py_frsrpc_CommPktChangeOrderCommand_set_spare1guid_p1 },
	{ discard_const_p(char, "spare1guid_p2"), py_frsrpc_CommPktChangeOrderCommand_get_spare1guid_p2, py_frsrpc_CommPktChangeOrderCommand_set_spare1guid_p2 },
	{ discard_const_p(char, "spare2guid_p1"), py_frsrpc_CommPktChangeOrderCommand_get_spare2guid_p1, py_frsrpc_CommPktChangeOrderCommand_set_spare2guid_p1 },
	{ discard_const_p(char, "spare3guid_p2"), py_frsrpc_CommPktChangeOrderCommand_get_spare3guid_p2, py_frsrpc_CommPktChangeOrderCommand_set_spare3guid_p2 },
	{ discard_const_p(char, "spare1wcs"), py_frsrpc_CommPktChangeOrderCommand_get_spare1wcs, py_frsrpc_CommPktChangeOrderCommand_set_spare1wcs },
	{ discard_const_p(char, "spare2wcs"), py_frsrpc_CommPktChangeOrderCommand_get_spare2wcs, py_frsrpc_CommPktChangeOrderCommand_set_spare2wcs },
	{ discard_const_p(char, "extension"), py_frsrpc_CommPktChangeOrderCommand_get_extension, py_frsrpc_CommPktChangeOrderCommand_set_extension },
	{ discard_const_p(char, "spare2bin"), py_frsrpc_CommPktChangeOrderCommand_get_spare2bin, py_frsrpc_CommPktChangeOrderCommand_set_spare2bin },
	{ discard_const_p(char, "event_time"), py_frsrpc_CommPktChangeOrderCommand_get_event_time, py_frsrpc_CommPktChangeOrderCommand_set_event_time },
	{ discard_const_p(char, "file_name_length"), py_frsrpc_CommPktChangeOrderCommand_get_file_name_length, py_frsrpc_CommPktChangeOrderCommand_set_file_name_length },
	{ discard_const_p(char, "file_name"), py_frsrpc_CommPktChangeOrderCommand_get_file_name, py_frsrpc_CommPktChangeOrderCommand_set_file_name },
	{ discard_const_p(char, "padding1"), py_frsrpc_CommPktChangeOrderCommand_get_padding1, py_frsrpc_CommPktChangeOrderCommand_set_padding1 },
	{ discard_const_p(char, "padding2"), py_frsrpc_CommPktChangeOrderCommand_get_padding2, py_frsrpc_CommPktChangeOrderCommand_set_padding2 },
	{ discard_const_p(char, "padding3"), py_frsrpc_CommPktChangeOrderCommand_get_padding3, py_frsrpc_CommPktChangeOrderCommand_set_padding3 },
	{ discard_const_p(char, "padding4"), py_frsrpc_CommPktChangeOrderCommand_get_padding4, py_frsrpc_CommPktChangeOrderCommand_set_padding4 },
	{ NULL }
};

static PyObject *py_frsrpc_CommPktChangeOrderCommand_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct frsrpc_CommPktChangeOrderCommand, type);
}


static PyTypeObject frsrpc_CommPktChangeOrderCommand_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "frsrpc.CommPktChangeOrderCommand",
	.tp_getset = py_frsrpc_CommPktChangeOrderCommand_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_frsrpc_CommPktChangeOrderCommand_new,
};


static PyObject *py_frsrpc_CommPktDataExtensionChecksum_get_prefix_size(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktDataExtensionChecksum *object = (struct frsrpc_CommPktDataExtensionChecksum *)pytalloc_get_ptr(obj);
	PyObject *py_prefix_size;
	py_prefix_size = PyInt_FromLong(object->prefix_size);
	return py_prefix_size;
}

static int py_frsrpc_CommPktDataExtensionChecksum_set_prefix_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktDataExtensionChecksum *object = (struct frsrpc_CommPktDataExtensionChecksum *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->prefix_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktDataExtensionChecksum_get_prefix_type(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktDataExtensionChecksum *object = (struct frsrpc_CommPktDataExtensionChecksum *)pytalloc_get_ptr(obj);
	PyObject *py_prefix_type;
	py_prefix_type = PyInt_FromLong(object->prefix_type);
	return py_prefix_type;
}

static int py_frsrpc_CommPktDataExtensionChecksum_set_prefix_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktDataExtensionChecksum *object = (struct frsrpc_CommPktDataExtensionChecksum *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->prefix_type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->prefix_type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_CommPktDataExtensionChecksum_get_data(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktDataExtensionChecksum *object = (struct frsrpc_CommPktDataExtensionChecksum *)pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyList_New(16);
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < 16; data_cntr_0++) {
			PyObject *py_data_0;
			py_data_0 = PyInt_FromLong(object->data[data_cntr_0]);
			PyList_SetItem(py_data, data_cntr_0, py_data_0);
		}
	}
	return py_data;
}

static int py_frsrpc_CommPktDataExtensionChecksum_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktDataExtensionChecksum *object = (struct frsrpc_CommPktDataExtensionChecksum *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < PyList_GET_SIZE(value); data_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, data_cntr_0), return -1;);
			object->data[data_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, data_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_frsrpc_CommPktDataExtensionChecksum_getsetters[] = {
	{ discard_const_p(char, "prefix_size"), py_frsrpc_CommPktDataExtensionChecksum_get_prefix_size, py_frsrpc_CommPktDataExtensionChecksum_set_prefix_size },
	{ discard_const_p(char, "prefix_type"), py_frsrpc_CommPktDataExtensionChecksum_get_prefix_type, py_frsrpc_CommPktDataExtensionChecksum_set_prefix_type },
	{ discard_const_p(char, "data"), py_frsrpc_CommPktDataExtensionChecksum_get_data, py_frsrpc_CommPktDataExtensionChecksum_set_data },
	{ NULL }
};

static PyObject *py_frsrpc_CommPktDataExtensionChecksum_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct frsrpc_CommPktDataExtensionChecksum, type);
}


static PyTypeObject frsrpc_CommPktDataExtensionChecksum_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "frsrpc.CommPktDataExtensionChecksum",
	.tp_getset = py_frsrpc_CommPktDataExtensionChecksum_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_frsrpc_CommPktDataExtensionChecksum_new,
};


static PyObject *py_frsrpc_CommPktDataExtensionRetryTimeout_get_prefix_size(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktDataExtensionRetryTimeout *object = (struct frsrpc_CommPktDataExtensionRetryTimeout *)pytalloc_get_ptr(obj);
	PyObject *py_prefix_size;
	py_prefix_size = PyInt_FromLong(object->prefix_size);
	return py_prefix_size;
}

static int py_frsrpc_CommPktDataExtensionRetryTimeout_set_prefix_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktDataExtensionRetryTimeout *object = (struct frsrpc_CommPktDataExtensionRetryTimeout *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->prefix_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktDataExtensionRetryTimeout_get_prefix_type(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktDataExtensionRetryTimeout *object = (struct frsrpc_CommPktDataExtensionRetryTimeout *)pytalloc_get_ptr(obj);
	PyObject *py_prefix_type;
	py_prefix_type = PyInt_FromLong(object->prefix_type);
	return py_prefix_type;
}

static int py_frsrpc_CommPktDataExtensionRetryTimeout_set_prefix_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktDataExtensionRetryTimeout *object = (struct frsrpc_CommPktDataExtensionRetryTimeout *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->prefix_type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->prefix_type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_CommPktDataExtensionRetryTimeout_get_count(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktDataExtensionRetryTimeout *object = (struct frsrpc_CommPktDataExtensionRetryTimeout *)pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_frsrpc_CommPktDataExtensionRetryTimeout_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktDataExtensionRetryTimeout *object = (struct frsrpc_CommPktDataExtensionRetryTimeout *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktDataExtensionRetryTimeout_get_not_used(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktDataExtensionRetryTimeout *object = (struct frsrpc_CommPktDataExtensionRetryTimeout *)pytalloc_get_ptr(obj);
	PyObject *py_not_used;
	py_not_used = PyInt_FromLong(object->not_used);
	return py_not_used;
}

static int py_frsrpc_CommPktDataExtensionRetryTimeout_set_not_used(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktDataExtensionRetryTimeout *object = (struct frsrpc_CommPktDataExtensionRetryTimeout *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->not_used = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktDataExtensionRetryTimeout_get_first_try_time(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktDataExtensionRetryTimeout *object = (struct frsrpc_CommPktDataExtensionRetryTimeout *)pytalloc_get_ptr(obj);
	PyObject *py_first_try_time;
	py_first_try_time = PyLong_FromLongLong(object->first_try_time);
	return py_first_try_time;
}

static int py_frsrpc_CommPktDataExtensionRetryTimeout_set_first_try_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktDataExtensionRetryTimeout *object = (struct frsrpc_CommPktDataExtensionRetryTimeout *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->first_try_time = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->first_try_time = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyGetSetDef py_frsrpc_CommPktDataExtensionRetryTimeout_getsetters[] = {
	{ discard_const_p(char, "prefix_size"), py_frsrpc_CommPktDataExtensionRetryTimeout_get_prefix_size, py_frsrpc_CommPktDataExtensionRetryTimeout_set_prefix_size },
	{ discard_const_p(char, "prefix_type"), py_frsrpc_CommPktDataExtensionRetryTimeout_get_prefix_type, py_frsrpc_CommPktDataExtensionRetryTimeout_set_prefix_type },
	{ discard_const_p(char, "count"), py_frsrpc_CommPktDataExtensionRetryTimeout_get_count, py_frsrpc_CommPktDataExtensionRetryTimeout_set_count },
	{ discard_const_p(char, "not_used"), py_frsrpc_CommPktDataExtensionRetryTimeout_get_not_used, py_frsrpc_CommPktDataExtensionRetryTimeout_set_not_used },
	{ discard_const_p(char, "first_try_time"), py_frsrpc_CommPktDataExtensionRetryTimeout_get_first_try_time, py_frsrpc_CommPktDataExtensionRetryTimeout_set_first_try_time },
	{ NULL }
};

static PyObject *py_frsrpc_CommPktDataExtensionRetryTimeout_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct frsrpc_CommPktDataExtensionRetryTimeout, type);
}


static PyTypeObject frsrpc_CommPktDataExtensionRetryTimeout_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "frsrpc.CommPktDataExtensionRetryTimeout",
	.tp_getset = py_frsrpc_CommPktDataExtensionRetryTimeout_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_frsrpc_CommPktDataExtensionRetryTimeout_new,
};


static PyObject *py_frsrpc_CommPktCoRecordExtensionWin2k_get_field_size(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktCoRecordExtensionWin2k *object = (struct frsrpc_CommPktCoRecordExtensionWin2k *)pytalloc_get_ptr(obj);
	PyObject *py_field_size;
	py_field_size = PyInt_FromLong(object->field_size);
	return py_field_size;
}

static int py_frsrpc_CommPktCoRecordExtensionWin2k_set_field_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktCoRecordExtensionWin2k *object = (struct frsrpc_CommPktCoRecordExtensionWin2k *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->field_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktCoRecordExtensionWin2k_get_major(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktCoRecordExtensionWin2k *object = (struct frsrpc_CommPktCoRecordExtensionWin2k *)pytalloc_get_ptr(obj);
	PyObject *py_major;
	py_major = PyInt_FromLong(object->major);
	return py_major;
}

static int py_frsrpc_CommPktCoRecordExtensionWin2k_set_major(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktCoRecordExtensionWin2k *object = (struct frsrpc_CommPktCoRecordExtensionWin2k *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->major = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->major = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_CommPktCoRecordExtensionWin2k_get_offset_count(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktCoRecordExtensionWin2k *object = (struct frsrpc_CommPktCoRecordExtensionWin2k *)pytalloc_get_ptr(obj);
	PyObject *py_offset_count;
	py_offset_count = PyInt_FromLong(object->offset_count);
	return py_offset_count;
}

static int py_frsrpc_CommPktCoRecordExtensionWin2k_set_offset_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktCoRecordExtensionWin2k *object = (struct frsrpc_CommPktCoRecordExtensionWin2k *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->offset_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktCoRecordExtensionWin2k_get_offset(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktCoRecordExtensionWin2k *object = (struct frsrpc_CommPktCoRecordExtensionWin2k *)pytalloc_get_ptr(obj);
	PyObject *py_offset;
	py_offset = PyInt_FromLong(object->offset);
	return py_offset;
}

static int py_frsrpc_CommPktCoRecordExtensionWin2k_set_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktCoRecordExtensionWin2k *object = (struct frsrpc_CommPktCoRecordExtensionWin2k *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->offset = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktCoRecordExtensionWin2k_get_offset_last(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktCoRecordExtensionWin2k *object = (struct frsrpc_CommPktCoRecordExtensionWin2k *)pytalloc_get_ptr(obj);
	PyObject *py_offset_last;
	py_offset_last = PyInt_FromLong(object->offset_last);
	return py_offset_last;
}

static int py_frsrpc_CommPktCoRecordExtensionWin2k_set_offset_last(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktCoRecordExtensionWin2k *object = (struct frsrpc_CommPktCoRecordExtensionWin2k *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->offset_last = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktCoRecordExtensionWin2k_get_data_checksum(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktCoRecordExtensionWin2k *object = (struct frsrpc_CommPktCoRecordExtensionWin2k *)pytalloc_get_ptr(obj);
	PyObject *py_data_checksum;
	py_data_checksum = pytalloc_reference_ex(&frsrpc_CommPktDataExtensionChecksum_Type, pytalloc_get_mem_ctx(obj), &object->data_checksum);
	return py_data_checksum;
}

static int py_frsrpc_CommPktCoRecordExtensionWin2k_set_data_checksum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktCoRecordExtensionWin2k *object = (struct frsrpc_CommPktCoRecordExtensionWin2k *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&frsrpc_CommPktDataExtensionChecksum_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->data_checksum = *(struct frsrpc_CommPktDataExtensionChecksum *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_frsrpc_CommPktCoRecordExtensionWin2k_getsetters[] = {
	{ discard_const_p(char, "field_size"), py_frsrpc_CommPktCoRecordExtensionWin2k_get_field_size, py_frsrpc_CommPktCoRecordExtensionWin2k_set_field_size },
	{ discard_const_p(char, "major"), py_frsrpc_CommPktCoRecordExtensionWin2k_get_major, py_frsrpc_CommPktCoRecordExtensionWin2k_set_major },
	{ discard_const_p(char, "offset_count"), py_frsrpc_CommPktCoRecordExtensionWin2k_get_offset_count, py_frsrpc_CommPktCoRecordExtensionWin2k_set_offset_count },
	{ discard_const_p(char, "offset"), py_frsrpc_CommPktCoRecordExtensionWin2k_get_offset, py_frsrpc_CommPktCoRecordExtensionWin2k_set_offset },
	{ discard_const_p(char, "offset_last"), py_frsrpc_CommPktCoRecordExtensionWin2k_get_offset_last, py_frsrpc_CommPktCoRecordExtensionWin2k_set_offset_last },
	{ discard_const_p(char, "data_checksum"), py_frsrpc_CommPktCoRecordExtensionWin2k_get_data_checksum, py_frsrpc_CommPktCoRecordExtensionWin2k_set_data_checksum },
	{ NULL }
};

static PyObject *py_frsrpc_CommPktCoRecordExtensionWin2k_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct frsrpc_CommPktCoRecordExtensionWin2k, type);
}


static PyTypeObject frsrpc_CommPktCoRecordExtensionWin2k_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "frsrpc.CommPktCoRecordExtensionWin2k",
	.tp_getset = py_frsrpc_CommPktCoRecordExtensionWin2k_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_frsrpc_CommPktCoRecordExtensionWin2k_new,
};


static PyObject *py_frsrpc_CommPktChangeOrderRecordExtension_get_field_size(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderRecordExtension *object = (struct frsrpc_CommPktChangeOrderRecordExtension *)pytalloc_get_ptr(obj);
	PyObject *py_field_size;
	py_field_size = PyInt_FromLong(object->field_size);
	return py_field_size;
}

static int py_frsrpc_CommPktChangeOrderRecordExtension_set_field_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderRecordExtension *object = (struct frsrpc_CommPktChangeOrderRecordExtension *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->field_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderRecordExtension_get_major(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderRecordExtension *object = (struct frsrpc_CommPktChangeOrderRecordExtension *)pytalloc_get_ptr(obj);
	PyObject *py_major;
	py_major = PyInt_FromLong(object->major);
	return py_major;
}

static int py_frsrpc_CommPktChangeOrderRecordExtension_set_major(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderRecordExtension *object = (struct frsrpc_CommPktChangeOrderRecordExtension *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->major = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->major = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderRecordExtension_get_offset_count(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderRecordExtension *object = (struct frsrpc_CommPktChangeOrderRecordExtension *)pytalloc_get_ptr(obj);
	PyObject *py_offset_count;
	py_offset_count = PyInt_FromLong(object->offset_count);
	return py_offset_count;
}

static int py_frsrpc_CommPktChangeOrderRecordExtension_set_offset_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderRecordExtension *object = (struct frsrpc_CommPktChangeOrderRecordExtension *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->offset_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderRecordExtension_get_offset0(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderRecordExtension *object = (struct frsrpc_CommPktChangeOrderRecordExtension *)pytalloc_get_ptr(obj);
	PyObject *py_offset0;
	py_offset0 = PyInt_FromLong(object->offset0);
	return py_offset0;
}

static int py_frsrpc_CommPktChangeOrderRecordExtension_set_offset0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderRecordExtension *object = (struct frsrpc_CommPktChangeOrderRecordExtension *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->offset0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderRecordExtension_get_offset1(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderRecordExtension *object = (struct frsrpc_CommPktChangeOrderRecordExtension *)pytalloc_get_ptr(obj);
	PyObject *py_offset1;
	py_offset1 = PyInt_FromLong(object->offset1);
	return py_offset1;
}

static int py_frsrpc_CommPktChangeOrderRecordExtension_set_offset1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderRecordExtension *object = (struct frsrpc_CommPktChangeOrderRecordExtension *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->offset1 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderRecordExtension_get_offset_last(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderRecordExtension *object = (struct frsrpc_CommPktChangeOrderRecordExtension *)pytalloc_get_ptr(obj);
	PyObject *py_offset_last;
	py_offset_last = PyInt_FromLong(object->offset_last);
	return py_offset_last;
}

static int py_frsrpc_CommPktChangeOrderRecordExtension_set_offset_last(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderRecordExtension *object = (struct frsrpc_CommPktChangeOrderRecordExtension *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->offset_last = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderRecordExtension_get_not_used(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderRecordExtension *object = (struct frsrpc_CommPktChangeOrderRecordExtension *)pytalloc_get_ptr(obj);
	PyObject *py_not_used;
	py_not_used = PyInt_FromLong(object->not_used);
	return py_not_used;
}

static int py_frsrpc_CommPktChangeOrderRecordExtension_set_not_used(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderRecordExtension *object = (struct frsrpc_CommPktChangeOrderRecordExtension *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->not_used = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderRecordExtension_get_data_checksum(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderRecordExtension *object = (struct frsrpc_CommPktChangeOrderRecordExtension *)pytalloc_get_ptr(obj);
	PyObject *py_data_checksum;
	py_data_checksum = pytalloc_reference_ex(&frsrpc_CommPktDataExtensionChecksum_Type, pytalloc_get_mem_ctx(obj), &object->data_checksum);
	return py_data_checksum;
}

static int py_frsrpc_CommPktChangeOrderRecordExtension_set_data_checksum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderRecordExtension *object = (struct frsrpc_CommPktChangeOrderRecordExtension *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&frsrpc_CommPktDataExtensionChecksum_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->data_checksum = *(struct frsrpc_CommPktDataExtensionChecksum *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChangeOrderRecordExtension_get_data_retry_timeout(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChangeOrderRecordExtension *object = (struct frsrpc_CommPktChangeOrderRecordExtension *)pytalloc_get_ptr(obj);
	PyObject *py_data_retry_timeout;
	py_data_retry_timeout = pytalloc_reference_ex(&frsrpc_CommPktDataExtensionRetryTimeout_Type, pytalloc_get_mem_ctx(obj), &object->data_retry_timeout);
	return py_data_retry_timeout;
}

static int py_frsrpc_CommPktChangeOrderRecordExtension_set_data_retry_timeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChangeOrderRecordExtension *object = (struct frsrpc_CommPktChangeOrderRecordExtension *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&frsrpc_CommPktDataExtensionRetryTimeout_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->data_retry_timeout = *(struct frsrpc_CommPktDataExtensionRetryTimeout *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_frsrpc_CommPktChangeOrderRecordExtension_getsetters[] = {
	{ discard_const_p(char, "field_size"), py_frsrpc_CommPktChangeOrderRecordExtension_get_field_size, py_frsrpc_CommPktChangeOrderRecordExtension_set_field_size },
	{ discard_const_p(char, "major"), py_frsrpc_CommPktChangeOrderRecordExtension_get_major, py_frsrpc_CommPktChangeOrderRecordExtension_set_major },
	{ discard_const_p(char, "offset_count"), py_frsrpc_CommPktChangeOrderRecordExtension_get_offset_count, py_frsrpc_CommPktChangeOrderRecordExtension_set_offset_count },
	{ discard_const_p(char, "offset0"), py_frsrpc_CommPktChangeOrderRecordExtension_get_offset0, py_frsrpc_CommPktChangeOrderRecordExtension_set_offset0 },
	{ discard_const_p(char, "offset1"), py_frsrpc_CommPktChangeOrderRecordExtension_get_offset1, py_frsrpc_CommPktChangeOrderRecordExtension_set_offset1 },
	{ discard_const_p(char, "offset_last"), py_frsrpc_CommPktChangeOrderRecordExtension_get_offset_last, py_frsrpc_CommPktChangeOrderRecordExtension_set_offset_last },
	{ discard_const_p(char, "not_used"), py_frsrpc_CommPktChangeOrderRecordExtension_get_not_used, py_frsrpc_CommPktChangeOrderRecordExtension_set_not_used },
	{ discard_const_p(char, "data_checksum"), py_frsrpc_CommPktChangeOrderRecordExtension_get_data_checksum, py_frsrpc_CommPktChangeOrderRecordExtension_set_data_checksum },
	{ discard_const_p(char, "data_retry_timeout"), py_frsrpc_CommPktChangeOrderRecordExtension_get_data_retry_timeout, py_frsrpc_CommPktChangeOrderRecordExtension_set_data_retry_timeout },
	{ NULL }
};

static PyObject *py_frsrpc_CommPktChangeOrderRecordExtension_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct frsrpc_CommPktChangeOrderRecordExtension, type);
}


static PyTypeObject frsrpc_CommPktChangeOrderRecordExtension_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "frsrpc.CommPktChangeOrderRecordExtension",
	.tp_getset = py_frsrpc_CommPktChangeOrderRecordExtension_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_frsrpc_CommPktChangeOrderRecordExtension_new,
};

PyObject *py_import_frsrpc_CommPktChunkData(TALLOC_CTX *mem_ctx, int level, union frsrpc_CommPktChunkData *in)
{
	PyObject *ret;

	switch (level) {
		default:
			ret = PyString_FromStringAndSize((char *)(in->blob).data, (in->blob).length);
			return ret;

		case FRSRPC_COMM_PKT_CHUNK_BOP:
			ret = PyInt_FromLong(in->bop);
			return ret;

		case FRSRPC_COMM_PKT_CHUNK_COMMAND:
			ret = PyInt_FromLong(in->command);
			return ret;

		case FRSRPC_COMM_PKT_CHUNK_TO:
			ret = pytalloc_reference_ex(&frsrpc_CommPktChunkGuidName_Type, mem_ctx, &in->to);
			return ret;

		case FRSRPC_COMM_PKT_CHUNK_FROM:
			ret = pytalloc_reference_ex(&frsrpc_CommPktChunkGuidName_Type, mem_ctx, &in->from);
			return ret;

		case FRSRPC_COMM_PKT_CHUNK_REPLICA:
			ret = pytalloc_reference_ex(&frsrpc_CommPktChunkGuidName_Type, mem_ctx, &in->replica);
			return ret;

		case FRSRPC_COMM_PKT_CHUNK_CONNECTION:
			ret = pytalloc_reference_ex(&frsrpc_CommPktChunkGuidName_Type, mem_ctx, &in->connection);
			return ret;

		case FRSRPC_COMM_PKT_CHUNK_JOIN_GUID:
			ret = pytalloc_reference_ex(GUID_Type, mem_ctx, &in->join_guid);
			return ret;

		case FRSRPC_COMM_PKT_CHUNK_LAST_JOIN_TIME:
			ret = PyLong_FromLongLong(in->last_join_time);
			return ret;

		case FRSRPC_COMM_PKT_CHUNK_VVECTOR:
			ret = pytalloc_reference_ex(&frsrpc_CommPktGSVN_Type, mem_ctx, &in->vvector);
			return ret;

		case FRSRPC_COMM_PKT_CHUNK_JOIN_TIME:
			ret = PyLong_FromLongLong(in->join_time);
			return ret;

		case FRSRPC_COMM_PKT_CHUNK_REPLICA_VERSION_GUID:
			ret = pytalloc_reference_ex(GUID_Type, mem_ctx, &in->replica_version_guid);
			return ret;

		case FRSRPC_COMM_PKT_CHUNK_COMPRESSION_GUID:
			ret = pytalloc_reference_ex(GUID_Type, mem_ctx, &in->compression_guid);
			return ret;

		case FRSRPC_COMM_PKT_CHUNK_BLOCK:
			ret = PyString_FromStringAndSize((char *)(in->block).data, (in->block).length);
			return ret;

		case FRSRPC_COMM_PKT_CHUNK_BLOCK_SIZE:
			ret = PyLong_FromLongLong(in->block_size);
			return ret;

		case FRSRPC_COMM_PKT_CHUNK_FILE_SIZE:
			ret = PyLong_FromLongLong(in->file_size);
			return ret;

		case FRSRPC_COMM_PKT_CHUNK_FILE_OFFSET:
			ret = PyLong_FromLongLong(in->file_offset);
			return ret;

		case FRSRPC_COMM_PKT_CHUNK_GVSN:
			ret = pytalloc_reference_ex(&frsrpc_CommPktGSVN_Type, mem_ctx, &in->gvsn);
			return ret;

		case FRSRPC_COMM_PKT_CHUNK_CO_GUID:
			ret = pytalloc_reference_ex(GUID_Type, mem_ctx, &in->co_guid);
			return ret;

		case FRSRPC_COMM_PKT_CHUNK_CO_SEQUENCE_NUMBER:
			ret = PyInt_FromLong(in->co_sequnence_number);
			return ret;

		case FRSRPC_COMM_PKT_CHUNK_REMOTE_CO:
			ret = pytalloc_reference_ex(&frsrpc_CommPktChangeOrderCommand_Type, mem_ctx, &in->remote_co);
			return ret;

		case FRSRPC_COMM_PKT_CHUNK_CO_EXT_WIN2K:
			ret = pytalloc_reference_ex(&frsrpc_CommPktCoRecordExtensionWin2k_Type, mem_ctx, &in->co_ext_win2k);
			return ret;

		case FRSRPC_COMM_PKT_CHUNK_CO_EXTENTION_2:
			ret = pytalloc_reference_ex(&frsrpc_CommPktChangeOrderRecordExtension_Type, mem_ctx, &in->co_extension2);
			return ret;

		case FRSRPC_COMM_PKT_CHUNK_EOP:
			ret = PyInt_FromLong(in->bopend);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union frsrpc_CommPktChunkData *py_export_frsrpc_CommPktChunkData(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union frsrpc_CommPktChunkData *ret = talloc_zero(mem_ctx, union frsrpc_CommPktChunkData);
	switch (level) {
		default:
			ret->blob = data_blob_talloc(mem_ctx, PyString_AS_STRING(in), PyString_GET_SIZE(in));
			break;

		case FRSRPC_COMM_PKT_CHUNK_BOP:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->bop = PyInt_AsLong(in);
			break;

		case FRSRPC_COMM_PKT_CHUNK_COMMAND:
			if (PyLong_Check(in)) {
				ret->command = PyLong_AsLongLong(in);
			} else if (PyInt_Check(in)) {
				ret->command = PyInt_AsLong(in);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
				  PyInt_Type.tp_name, PyLong_Type.tp_name);
				talloc_free(ret); return NULL;
			}
			break;

		case FRSRPC_COMM_PKT_CHUNK_TO:
			PY_CHECK_TYPE(&frsrpc_CommPktChunkGuidName_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->to = *(struct frsrpc_CommPktChunkGuidName *)pytalloc_get_ptr(in);
			break;

		case FRSRPC_COMM_PKT_CHUNK_FROM:
			PY_CHECK_TYPE(&frsrpc_CommPktChunkGuidName_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->from = *(struct frsrpc_CommPktChunkGuidName *)pytalloc_get_ptr(in);
			break;

		case FRSRPC_COMM_PKT_CHUNK_REPLICA:
			PY_CHECK_TYPE(&frsrpc_CommPktChunkGuidName_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->replica = *(struct frsrpc_CommPktChunkGuidName *)pytalloc_get_ptr(in);
			break;

		case FRSRPC_COMM_PKT_CHUNK_CONNECTION:
			PY_CHECK_TYPE(&frsrpc_CommPktChunkGuidName_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->connection = *(struct frsrpc_CommPktChunkGuidName *)pytalloc_get_ptr(in);
			break;

		case FRSRPC_COMM_PKT_CHUNK_JOIN_GUID:
			PY_CHECK_TYPE(GUID_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->join_guid = *(struct GUID *)pytalloc_get_ptr(in);
			break;

		case FRSRPC_COMM_PKT_CHUNK_LAST_JOIN_TIME:
			if (PyLong_Check(in)) {
				ret->last_join_time = PyLong_AsLongLong(in);
			} else if (PyInt_Check(in)) {
				ret->last_join_time = PyInt_AsLong(in);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
				  PyInt_Type.tp_name, PyLong_Type.tp_name);
				talloc_free(ret); return NULL;
			}
			break;

		case FRSRPC_COMM_PKT_CHUNK_VVECTOR:
			PY_CHECK_TYPE(&frsrpc_CommPktGSVN_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->vvector = *(struct frsrpc_CommPktGSVN *)pytalloc_get_ptr(in);
			break;

		case FRSRPC_COMM_PKT_CHUNK_JOIN_TIME:
			if (PyLong_Check(in)) {
				ret->join_time = PyLong_AsLongLong(in);
			} else if (PyInt_Check(in)) {
				ret->join_time = PyInt_AsLong(in);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
				  PyInt_Type.tp_name, PyLong_Type.tp_name);
				talloc_free(ret); return NULL;
			}
			break;

		case FRSRPC_COMM_PKT_CHUNK_REPLICA_VERSION_GUID:
			PY_CHECK_TYPE(GUID_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->replica_version_guid = *(struct GUID *)pytalloc_get_ptr(in);
			break;

		case FRSRPC_COMM_PKT_CHUNK_COMPRESSION_GUID:
			PY_CHECK_TYPE(GUID_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->compression_guid = *(struct GUID *)pytalloc_get_ptr(in);
			break;

		case FRSRPC_COMM_PKT_CHUNK_BLOCK:
			ret->block = data_blob_talloc(mem_ctx, PyString_AS_STRING(in), PyString_GET_SIZE(in));
			break;

		case FRSRPC_COMM_PKT_CHUNK_BLOCK_SIZE:
			if (PyLong_Check(in)) {
				ret->block_size = PyLong_AsLongLong(in);
			} else if (PyInt_Check(in)) {
				ret->block_size = PyInt_AsLong(in);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
				  PyInt_Type.tp_name, PyLong_Type.tp_name);
				talloc_free(ret); return NULL;
			}
			break;

		case FRSRPC_COMM_PKT_CHUNK_FILE_SIZE:
			if (PyLong_Check(in)) {
				ret->file_size = PyLong_AsLongLong(in);
			} else if (PyInt_Check(in)) {
				ret->file_size = PyInt_AsLong(in);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
				  PyInt_Type.tp_name, PyLong_Type.tp_name);
				talloc_free(ret); return NULL;
			}
			break;

		case FRSRPC_COMM_PKT_CHUNK_FILE_OFFSET:
			if (PyLong_Check(in)) {
				ret->file_offset = PyLong_AsLongLong(in);
			} else if (PyInt_Check(in)) {
				ret->file_offset = PyInt_AsLong(in);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
				  PyInt_Type.tp_name, PyLong_Type.tp_name);
				talloc_free(ret); return NULL;
			}
			break;

		case FRSRPC_COMM_PKT_CHUNK_GVSN:
			PY_CHECK_TYPE(&frsrpc_CommPktGSVN_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->gvsn = *(struct frsrpc_CommPktGSVN *)pytalloc_get_ptr(in);
			break;

		case FRSRPC_COMM_PKT_CHUNK_CO_GUID:
			PY_CHECK_TYPE(GUID_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->co_guid = *(struct GUID *)pytalloc_get_ptr(in);
			break;

		case FRSRPC_COMM_PKT_CHUNK_CO_SEQUENCE_NUMBER:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->co_sequnence_number = PyInt_AsLong(in);
			break;

		case FRSRPC_COMM_PKT_CHUNK_REMOTE_CO:
			PY_CHECK_TYPE(&frsrpc_CommPktChangeOrderCommand_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->remote_co = *(struct frsrpc_CommPktChangeOrderCommand *)pytalloc_get_ptr(in);
			break;

		case FRSRPC_COMM_PKT_CHUNK_CO_EXT_WIN2K:
			PY_CHECK_TYPE(&frsrpc_CommPktCoRecordExtensionWin2k_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->co_ext_win2k = *(struct frsrpc_CommPktCoRecordExtensionWin2k *)pytalloc_get_ptr(in);
			break;

		case FRSRPC_COMM_PKT_CHUNK_CO_EXTENTION_2:
			PY_CHECK_TYPE(&frsrpc_CommPktChangeOrderRecordExtension_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->co_extension2 = *(struct frsrpc_CommPktChangeOrderRecordExtension *)pytalloc_get_ptr(in);
			break;

		case FRSRPC_COMM_PKT_CHUNK_EOP:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->bopend = PyInt_AsLong(in);
			break;

	}

	return ret;
}


static PyObject *py_frsrpc_CommPktChunk_get_type(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChunk *object = (struct frsrpc_CommPktChunk *)pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyInt_FromLong(object->type);
	return py_type;
}

static int py_frsrpc_CommPktChunk_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChunk *object = (struct frsrpc_CommPktChunk *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_CommPktChunk_get_data(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChunk *object = (struct frsrpc_CommPktChunk *)pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = py_import_frsrpc_CommPktChunkData(pytalloc_get_mem_ctx(obj), object->type, &object->data);
	if (py_data == NULL) {
		return NULL;
	}
	return py_data;
}

static int py_frsrpc_CommPktChunk_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChunk *object = (struct frsrpc_CommPktChunk *)pytalloc_get_ptr(py_obj);
	{
		union frsrpc_CommPktChunkData *data_switch_1;
		data_switch_1 = py_export_frsrpc_CommPktChunkData(pytalloc_get_mem_ctx(py_obj), object->type, value);
		if (data_switch_1 == NULL) {
			return -1;
		}
		object->data = *data_switch_1;
	}
	return 0;
}

static PyGetSetDef py_frsrpc_CommPktChunk_getsetters[] = {
	{ discard_const_p(char, "type"), py_frsrpc_CommPktChunk_get_type, py_frsrpc_CommPktChunk_set_type },
	{ discard_const_p(char, "data"), py_frsrpc_CommPktChunk_get_data, py_frsrpc_CommPktChunk_set_data },
	{ NULL }
};

static PyObject *py_frsrpc_CommPktChunk_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct frsrpc_CommPktChunk, type);
}

static PyObject *py_frsrpc_CommPktChunk_ndr_pack(PyObject *py_obj)
{
	struct frsrpc_CommPktChunk *object = (struct frsrpc_CommPktChunk *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_frsrpc_CommPktChunk);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_frsrpc_CommPktChunk_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct frsrpc_CommPktChunk *object = (struct frsrpc_CommPktChunk *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_frsrpc_CommPktChunk);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_frsrpc_CommPktChunk);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_frsrpc_CommPktChunk_ndr_print(PyObject *py_obj)
{
	struct frsrpc_CommPktChunk *object = (struct frsrpc_CommPktChunk *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_frsrpc_CommPktChunk, "frsrpc_CommPktChunk", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_frsrpc_CommPktChunk_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_frsrpc_CommPktChunk_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_frsrpc_CommPktChunk_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_frsrpc_CommPktChunk_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject frsrpc_CommPktChunk_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "frsrpc.CommPktChunk",
	.tp_getset = py_frsrpc_CommPktChunk_getsetters,
	.tp_methods = py_frsrpc_CommPktChunk_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_frsrpc_CommPktChunk_new,
};


static PyObject *py_frsrpc_CommPktChunkCtr_get_num_chunks(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChunkCtr *object = (struct frsrpc_CommPktChunkCtr *)pytalloc_get_ptr(obj);
	PyObject *py_num_chunks;
	py_num_chunks = PyInt_FromLong(object->num_chunks);
	return py_num_chunks;
}

static int py_frsrpc_CommPktChunkCtr_set_num_chunks(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChunkCtr *object = (struct frsrpc_CommPktChunkCtr *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_chunks = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_CommPktChunkCtr_get_chunks(PyObject *obj, void *closure)
{
	struct frsrpc_CommPktChunkCtr *object = (struct frsrpc_CommPktChunkCtr *)pytalloc_get_ptr(obj);
	PyObject *py_chunks;
	py_chunks = PyList_New(object->num_chunks);
	if (py_chunks == NULL) {
		return NULL;
	}
	{
		int chunks_cntr_0;
		for (chunks_cntr_0 = 0; chunks_cntr_0 < object->num_chunks; chunks_cntr_0++) {
			PyObject *py_chunks_0;
			py_chunks_0 = pytalloc_reference_ex(&frsrpc_CommPktChunk_Type, object->chunks, &object->chunks[chunks_cntr_0]);
			PyList_SetItem(py_chunks, chunks_cntr_0, py_chunks_0);
		}
	}
	return py_chunks;
}

static int py_frsrpc_CommPktChunkCtr_set_chunks(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_CommPktChunkCtr *object = (struct frsrpc_CommPktChunkCtr *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int chunks_cntr_0;
		object->chunks = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->chunks, PyList_GET_SIZE(value));
		if (!object->chunks) { return -1;; }
		talloc_set_name_const(object->chunks, "ARRAY: object->chunks");
		for (chunks_cntr_0 = 0; chunks_cntr_0 < PyList_GET_SIZE(value); chunks_cntr_0++) {
			PY_CHECK_TYPE(&frsrpc_CommPktChunk_Type, PyList_GET_ITEM(value, chunks_cntr_0), return -1;);
			if (talloc_reference(object->chunks, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, chunks_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->chunks[chunks_cntr_0] = *(struct frsrpc_CommPktChunk *)pytalloc_get_ptr(PyList_GET_ITEM(value, chunks_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_frsrpc_CommPktChunkCtr_getsetters[] = {
	{ discard_const_p(char, "num_chunks"), py_frsrpc_CommPktChunkCtr_get_num_chunks, py_frsrpc_CommPktChunkCtr_set_num_chunks },
	{ discard_const_p(char, "chunks"), py_frsrpc_CommPktChunkCtr_get_chunks, py_frsrpc_CommPktChunkCtr_set_chunks },
	{ NULL }
};

static PyObject *py_frsrpc_CommPktChunkCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct frsrpc_CommPktChunkCtr, type);
}


static PyTypeObject frsrpc_CommPktChunkCtr_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "frsrpc.CommPktChunkCtr",
	.tp_getset = py_frsrpc_CommPktChunkCtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_frsrpc_CommPktChunkCtr_new,
};


static PyObject *py_frsrpc_FrsSendCommPktReq_get_major(PyObject *obj, void *closure)
{
	struct frsrpc_FrsSendCommPktReq *object = (struct frsrpc_FrsSendCommPktReq *)pytalloc_get_ptr(obj);
	PyObject *py_major;
	py_major = PyInt_FromLong(object->major);
	return py_major;
}

static int py_frsrpc_FrsSendCommPktReq_set_major(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_FrsSendCommPktReq *object = (struct frsrpc_FrsSendCommPktReq *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->major = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->major = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_FrsSendCommPktReq_get_minor(PyObject *obj, void *closure)
{
	struct frsrpc_FrsSendCommPktReq *object = (struct frsrpc_FrsSendCommPktReq *)pytalloc_get_ptr(obj);
	PyObject *py_minor;
	py_minor = PyInt_FromLong(object->minor);
	return py_minor;
}

static int py_frsrpc_FrsSendCommPktReq_set_minor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_FrsSendCommPktReq *object = (struct frsrpc_FrsSendCommPktReq *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->minor = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->minor = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frsrpc_FrsSendCommPktReq_get_cs_id(PyObject *obj, void *closure)
{
	struct frsrpc_FrsSendCommPktReq *object = (struct frsrpc_FrsSendCommPktReq *)pytalloc_get_ptr(obj);
	PyObject *py_cs_id;
	py_cs_id = PyInt_FromLong(object->cs_id);
	return py_cs_id;
}

static int py_frsrpc_FrsSendCommPktReq_set_cs_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_FrsSendCommPktReq *object = (struct frsrpc_FrsSendCommPktReq *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->cs_id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_FrsSendCommPktReq_get_memory_len(PyObject *obj, void *closure)
{
	struct frsrpc_FrsSendCommPktReq *object = (struct frsrpc_FrsSendCommPktReq *)pytalloc_get_ptr(obj);
	PyObject *py_memory_len;
	py_memory_len = PyInt_FromLong(object->memory_len);
	return py_memory_len;
}

static int py_frsrpc_FrsSendCommPktReq_set_memory_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_FrsSendCommPktReq *object = (struct frsrpc_FrsSendCommPktReq *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->memory_len = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_FrsSendCommPktReq_get_pkt_len(PyObject *obj, void *closure)
{
	struct frsrpc_FrsSendCommPktReq *object = (struct frsrpc_FrsSendCommPktReq *)pytalloc_get_ptr(obj);
	PyObject *py_pkt_len;
	py_pkt_len = PyInt_FromLong(object->pkt_len);
	return py_pkt_len;
}

static int py_frsrpc_FrsSendCommPktReq_set_pkt_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_FrsSendCommPktReq *object = (struct frsrpc_FrsSendCommPktReq *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pkt_len = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_FrsSendCommPktReq_get_upk_len(PyObject *obj, void *closure)
{
	struct frsrpc_FrsSendCommPktReq *object = (struct frsrpc_FrsSendCommPktReq *)pytalloc_get_ptr(obj);
	PyObject *py_upk_len;
	py_upk_len = PyInt_FromLong(object->upk_len);
	return py_upk_len;
}

static int py_frsrpc_FrsSendCommPktReq_set_upk_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_FrsSendCommPktReq *object = (struct frsrpc_FrsSendCommPktReq *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->upk_len = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_FrsSendCommPktReq_get_ctr(PyObject *obj, void *closure)
{
	struct frsrpc_FrsSendCommPktReq *object = (struct frsrpc_FrsSendCommPktReq *)pytalloc_get_ptr(obj);
	PyObject *py_ctr;
	if (object->ctr == NULL) {
		py_ctr = Py_None;
		Py_INCREF(py_ctr);
	} else {
		py_ctr = pytalloc_reference_ex(&frsrpc_CommPktChunkCtr_Type, object->ctr, object->ctr);
	}
	return py_ctr;
}

static int py_frsrpc_FrsSendCommPktReq_set_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_FrsSendCommPktReq *object = (struct frsrpc_FrsSendCommPktReq *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->ctr);
	if (value == Py_None) {
		object->ctr = NULL;
	} else {
		object->ctr = NULL;
		PY_CHECK_TYPE(&frsrpc_CommPktChunkCtr_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->ctr = (struct frsrpc_CommPktChunkCtr *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_frsrpc_FrsSendCommPktReq_get_data_name(PyObject *obj, void *closure)
{
	struct frsrpc_FrsSendCommPktReq *object = (struct frsrpc_FrsSendCommPktReq *)pytalloc_get_ptr(obj);
	PyObject *py_data_name;
	py_data_name = PyInt_FromLong(object->data_name);
	return py_data_name;
}

static int py_frsrpc_FrsSendCommPktReq_set_data_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_FrsSendCommPktReq *object = (struct frsrpc_FrsSendCommPktReq *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->data_name = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frsrpc_FrsSendCommPktReq_get_data_handle(PyObject *obj, void *closure)
{
	struct frsrpc_FrsSendCommPktReq *object = (struct frsrpc_FrsSendCommPktReq *)pytalloc_get_ptr(obj);
	PyObject *py_data_handle;
	py_data_handle = PyInt_FromLong(object->data_handle);
	return py_data_handle;
}

static int py_frsrpc_FrsSendCommPktReq_set_data_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frsrpc_FrsSendCommPktReq *object = (struct frsrpc_FrsSendCommPktReq *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->data_handle = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_frsrpc_FrsSendCommPktReq_getsetters[] = {
	{ discard_const_p(char, "major"), py_frsrpc_FrsSendCommPktReq_get_major, py_frsrpc_FrsSendCommPktReq_set_major },
	{ discard_const_p(char, "minor"), py_frsrpc_FrsSendCommPktReq_get_minor, py_frsrpc_FrsSendCommPktReq_set_minor },
	{ discard_const_p(char, "cs_id"), py_frsrpc_FrsSendCommPktReq_get_cs_id, py_frsrpc_FrsSendCommPktReq_set_cs_id },
	{ discard_const_p(char, "memory_len"), py_frsrpc_FrsSendCommPktReq_get_memory_len, py_frsrpc_FrsSendCommPktReq_set_memory_len },
	{ discard_const_p(char, "pkt_len"), py_frsrpc_FrsSendCommPktReq_get_pkt_len, py_frsrpc_FrsSendCommPktReq_set_pkt_len },
	{ discard_const_p(char, "upk_len"), py_frsrpc_FrsSendCommPktReq_get_upk_len, py_frsrpc_FrsSendCommPktReq_set_upk_len },
	{ discard_const_p(char, "ctr"), py_frsrpc_FrsSendCommPktReq_get_ctr, py_frsrpc_FrsSendCommPktReq_set_ctr },
	{ discard_const_p(char, "data_name"), py_frsrpc_FrsSendCommPktReq_get_data_name, py_frsrpc_FrsSendCommPktReq_set_data_name },
	{ discard_const_p(char, "data_handle"), py_frsrpc_FrsSendCommPktReq_get_data_handle, py_frsrpc_FrsSendCommPktReq_set_data_handle },
	{ NULL }
};

static PyObject *py_frsrpc_FrsSendCommPktReq_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct frsrpc_FrsSendCommPktReq, type);
}


static PyTypeObject frsrpc_FrsSendCommPktReq_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "frsrpc.FrsSendCommPktReq",
	.tp_getset = py_frsrpc_FrsSendCommPktReq_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_frsrpc_FrsSendCommPktReq_new,
};


static bool pack_py_frsrpc_FrsSendCommPkt_args_in(PyObject *args, PyObject *kwargs, struct frsrpc_FrsSendCommPkt *r)
{
	PyObject *py_req;
	const char *kwnames[] = {
		"req", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:frsrpc_FrsSendCommPkt", discard_const_p(char *, kwnames), &py_req)) {
		return false;
	}

	PY_CHECK_TYPE(&frsrpc_FrsSendCommPktReq_Type, py_req, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_req)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.req = *(struct frsrpc_FrsSendCommPktReq *)pytalloc_get_ptr(py_req);
	return true;
}

static PyObject *unpack_py_frsrpc_FrsSendCommPkt_args_out(struct frsrpc_FrsSendCommPkt *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_frsrpc_FrsVerifyPromotionParent_args_in(PyObject *args, PyObject *kwargs, struct frsrpc_FrsVerifyPromotionParent *r)
{
	PyObject *py_parent_account;
	PyObject *py_parent_password;
	PyObject *py_replica_set_name;
	PyObject *py_replica_set_type;
	PyObject *py_partner_auth_level;
	PyObject *py___ndr_guid_size;
	const char *kwnames[] = {
		"parent_account", "parent_password", "replica_set_name", "replica_set_type", "partner_auth_level", "__ndr_guid_size", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:frsrpc_FrsVerifyPromotionParent", discard_const_p(char *, kwnames), &py_parent_account, &py_parent_password, &py_replica_set_name, &py_replica_set_type, &py_partner_auth_level, &py___ndr_guid_size)) {
		return false;
	}

	if (py_parent_account == Py_None) {
		r->in.parent_account = NULL;
	} else {
		r->in.parent_account = NULL;
		if (PyUnicode_Check(py_parent_account)) {
			r->in.parent_account = PyString_AS_STRING(PyUnicode_AsEncodedString(py_parent_account, "utf-8", "ignore"));
		} else if (PyString_Check(py_parent_account)) {
			r->in.parent_account = PyString_AS_STRING(py_parent_account);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_parent_account)->tp_name);
			return false;
		}
	}
	if (py_parent_password == Py_None) {
		r->in.parent_password = NULL;
	} else {
		r->in.parent_password = NULL;
		if (PyUnicode_Check(py_parent_password)) {
			r->in.parent_password = PyString_AS_STRING(PyUnicode_AsEncodedString(py_parent_password, "utf-8", "ignore"));
		} else if (PyString_Check(py_parent_password)) {
			r->in.parent_password = PyString_AS_STRING(py_parent_password);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_parent_password)->tp_name);
			return false;
		}
	}
	if (py_replica_set_name == Py_None) {
		r->in.replica_set_name = NULL;
	} else {
		r->in.replica_set_name = NULL;
		if (PyUnicode_Check(py_replica_set_name)) {
			r->in.replica_set_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_replica_set_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_replica_set_name)) {
			r->in.replica_set_name = PyString_AS_STRING(py_replica_set_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_replica_set_name)->tp_name);
			return false;
		}
	}
	if (py_replica_set_type == Py_None) {
		r->in.replica_set_type = NULL;
	} else {
		r->in.replica_set_type = NULL;
		if (PyUnicode_Check(py_replica_set_type)) {
			r->in.replica_set_type = PyString_AS_STRING(PyUnicode_AsEncodedString(py_replica_set_type, "utf-8", "ignore"));
		} else if (PyString_Check(py_replica_set_type)) {
			r->in.replica_set_type = PyString_AS_STRING(py_replica_set_type);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_replica_set_type)->tp_name);
			return false;
		}
	}
	if (PyLong_Check(py_partner_auth_level)) {
		r->in.partner_auth_level = PyLong_AsLongLong(py_partner_auth_level);
	} else if (PyInt_Check(py_partner_auth_level)) {
		r->in.partner_auth_level = PyInt_AsLong(py_partner_auth_level);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py___ndr_guid_size, return false;);
	r->in.__ndr_guid_size = PyInt_AsLong(py___ndr_guid_size);
	return true;
}

static PyObject *unpack_py_frsrpc_FrsVerifyPromotionParent_args_out(struct frsrpc_FrsVerifyPromotionParent *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_frsrpc_FrsStartPromotionParent_args_in(PyObject *args, PyObject *kwargs, struct frsrpc_FrsStartPromotionParent *r)
{
	PyObject *py_parent_account;
	PyObject *py_parent_password;
	PyObject *py_replica_set_name;
	PyObject *py_replica_set_type;
	PyObject *py_connection_name;
	PyObject *py_partner_name;
	PyObject *py_partner_princ_name;
	PyObject *py_partner_auth_level;
	PyObject *py___ndr_guid_size;
	PyObject *py_connection_guid;
	PyObject *py_partner_guid;
	PyObject *py_parent_guid;
	const char *kwnames[] = {
		"parent_account", "parent_password", "replica_set_name", "replica_set_type", "connection_name", "partner_name", "partner_princ_name", "partner_auth_level", "__ndr_guid_size", "connection_guid", "partner_guid", "parent_guid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOOOOOO:frsrpc_FrsStartPromotionParent", discard_const_p(char *, kwnames), &py_parent_account, &py_parent_password, &py_replica_set_name, &py_replica_set_type, &py_connection_name, &py_partner_name, &py_partner_princ_name, &py_partner_auth_level, &py___ndr_guid_size, &py_connection_guid, &py_partner_guid, &py_parent_guid)) {
		return false;
	}

	if (py_parent_account == Py_None) {
		r->in.parent_account = NULL;
	} else {
		r->in.parent_account = NULL;
		if (PyUnicode_Check(py_parent_account)) {
			r->in.parent_account = PyString_AS_STRING(PyUnicode_AsEncodedString(py_parent_account, "utf-8", "ignore"));
		} else if (PyString_Check(py_parent_account)) {
			r->in.parent_account = PyString_AS_STRING(py_parent_account);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_parent_account)->tp_name);
			return false;
		}
	}
	if (py_parent_password == Py_None) {
		r->in.parent_password = NULL;
	} else {
		r->in.parent_password = NULL;
		if (PyUnicode_Check(py_parent_password)) {
			r->in.parent_password = PyString_AS_STRING(PyUnicode_AsEncodedString(py_parent_password, "utf-8", "ignore"));
		} else if (PyString_Check(py_parent_password)) {
			r->in.parent_password = PyString_AS_STRING(py_parent_password);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_parent_password)->tp_name);
			return false;
		}
	}
	if (py_replica_set_name == Py_None) {
		r->in.replica_set_name = NULL;
	} else {
		r->in.replica_set_name = NULL;
		if (PyUnicode_Check(py_replica_set_name)) {
			r->in.replica_set_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_replica_set_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_replica_set_name)) {
			r->in.replica_set_name = PyString_AS_STRING(py_replica_set_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_replica_set_name)->tp_name);
			return false;
		}
	}
	if (py_replica_set_type == Py_None) {
		r->in.replica_set_type = NULL;
	} else {
		r->in.replica_set_type = NULL;
		if (PyUnicode_Check(py_replica_set_type)) {
			r->in.replica_set_type = PyString_AS_STRING(PyUnicode_AsEncodedString(py_replica_set_type, "utf-8", "ignore"));
		} else if (PyString_Check(py_replica_set_type)) {
			r->in.replica_set_type = PyString_AS_STRING(py_replica_set_type);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_replica_set_type)->tp_name);
			return false;
		}
	}
	if (py_connection_name == Py_None) {
		r->in.connection_name = NULL;
	} else {
		r->in.connection_name = NULL;
		if (PyUnicode_Check(py_connection_name)) {
			r->in.connection_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_connection_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_connection_name)) {
			r->in.connection_name = PyString_AS_STRING(py_connection_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_connection_name)->tp_name);
			return false;
		}
	}
	if (py_partner_name == Py_None) {
		r->in.partner_name = NULL;
	} else {
		r->in.partner_name = NULL;
		if (PyUnicode_Check(py_partner_name)) {
			r->in.partner_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_partner_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_partner_name)) {
			r->in.partner_name = PyString_AS_STRING(py_partner_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_partner_name)->tp_name);
			return false;
		}
	}
	if (py_partner_princ_name == Py_None) {
		r->in.partner_princ_name = NULL;
	} else {
		r->in.partner_princ_name = NULL;
		if (PyUnicode_Check(py_partner_princ_name)) {
			r->in.partner_princ_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_partner_princ_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_partner_princ_name)) {
			r->in.partner_princ_name = PyString_AS_STRING(py_partner_princ_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_partner_princ_name)->tp_name);
			return false;
		}
	}
	if (PyLong_Check(py_partner_auth_level)) {
		r->in.partner_auth_level = PyLong_AsLongLong(py_partner_auth_level);
	} else if (PyInt_Check(py_partner_auth_level)) {
		r->in.partner_auth_level = PyInt_AsLong(py_partner_auth_level);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py___ndr_guid_size, return false;);
	r->in.__ndr_guid_size = PyInt_AsLong(py___ndr_guid_size);
	if (py_connection_guid == Py_None) {
		r->in.connection_guid = NULL;
	} else {
		r->in.connection_guid = NULL;
		PY_CHECK_TYPE(GUID_Type, py_connection_guid, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_connection_guid)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.connection_guid = (struct GUID *)pytalloc_get_ptr(py_connection_guid);
	}
	if (py_partner_guid == Py_None) {
		r->in.partner_guid = NULL;
	} else {
		r->in.partner_guid = NULL;
		PY_CHECK_TYPE(GUID_Type, py_partner_guid, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_partner_guid)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.partner_guid = (struct GUID *)pytalloc_get_ptr(py_partner_guid);
	}
	if (py_parent_guid == Py_None) {
		r->in.parent_guid = NULL;
	} else {
		r->in.parent_guid = NULL;
		PY_CHECK_TYPE(GUID_Type, py_parent_guid, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_parent_guid)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.parent_guid = (struct GUID *)pytalloc_get_ptr(py_parent_guid);
	}
	return true;
}

static PyObject *unpack_py_frsrpc_FrsStartPromotionParent_args_out(struct frsrpc_FrsStartPromotionParent *r)
{
	PyObject *result;
	PyObject *py_parent_guid;
	if (r->out.parent_guid == NULL) {
		py_parent_guid = Py_None;
		Py_INCREF(py_parent_guid);
	} else {
		py_parent_guid = pytalloc_reference_ex(GUID_Type, r->out.parent_guid, r->out.parent_guid);
	}
	result = py_parent_guid;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_frsrpc_FrsNOP_args_in(PyObject *args, PyObject *kwargs, struct frsrpc_FrsNOP *r)
{
	const char *kwnames[] = {
		NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":frsrpc_FrsNOP", discard_const_p(char *, kwnames))) {
		return false;
	}

	return true;
}

static PyObject *unpack_py_frsrpc_FrsNOP_args_out(struct frsrpc_FrsNOP *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_frsrpc_methods[] = {
	{ "FrsSendCommPkt", "S.FrsSendCommPkt(req) -> None", (py_dcerpc_call_fn)dcerpc_frsrpc_FrsSendCommPkt_r, (py_data_pack_fn)pack_py_frsrpc_FrsSendCommPkt_args_in, (py_data_unpack_fn)unpack_py_frsrpc_FrsSendCommPkt_args_out, 0, &ndr_table_frsrpc },
	{ "FrsVerifyPromotionParent", "S.FrsVerifyPromotionParent(parent_account, parent_password, replica_set_name, replica_set_type, partner_auth_level, __ndr_guid_size) -> None", (py_dcerpc_call_fn)dcerpc_frsrpc_FrsVerifyPromotionParent_r, (py_data_pack_fn)pack_py_frsrpc_FrsVerifyPromotionParent_args_in, (py_data_unpack_fn)unpack_py_frsrpc_FrsVerifyPromotionParent_args_out, 1, &ndr_table_frsrpc },
	{ "FrsStartPromotionParent", "S.FrsStartPromotionParent(parent_account, parent_password, replica_set_name, replica_set_type, connection_name, partner_name, partner_princ_name, partner_auth_level, __ndr_guid_size, connection_guid, partner_guid, parent_guid) -> parent_guid", (py_dcerpc_call_fn)dcerpc_frsrpc_FrsStartPromotionParent_r, (py_data_pack_fn)pack_py_frsrpc_FrsStartPromotionParent_args_in, (py_data_unpack_fn)unpack_py_frsrpc_FrsStartPromotionParent_args_out, 2, &ndr_table_frsrpc },
	{ "FrsNOP", "S.FrsNOP() -> None", (py_dcerpc_call_fn)dcerpc_frsrpc_FrsNOP_r, (py_data_pack_fn)pack_py_frsrpc_FrsNOP_args_in, (py_data_unpack_fn)unpack_py_frsrpc_FrsNOP_args_out, 3, &ndr_table_frsrpc },
	{ NULL }
};

static PyObject *interface_frsrpc_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_frsrpc);
}

#define PY_DOC_FRSRPC "File Replication Service"
static PyTypeObject frsrpc_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "frsrpc.frsrpc",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "frsrpc(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_FRSRPC,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_frsrpc_new,
};

static PyMethodDef frsrpc_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initfrsrpc(void)
{
	PyObject *m;
	PyObject *dep_samba_dcerpc_misc;
	PyObject *dep_samba_dcerpc_base;
	PyObject *dep_talloc;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		return;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		return;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		return;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		return;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "GUID");
	if (GUID_Type == NULL)
		return;

	Object_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "Object");
	if (Object_Type == NULL)
		return;

	frsrpc_CommPktChunkGuidName_Type.tp_base = Object_Type;

	frsrpc_CommPktGSVN_Type.tp_base = Object_Type;

	frsrpc_CommPktChangeOrderCommand_Type.tp_base = Object_Type;

	frsrpc_CommPktDataExtensionChecksum_Type.tp_base = Object_Type;

	frsrpc_CommPktDataExtensionRetryTimeout_Type.tp_base = Object_Type;

	frsrpc_CommPktCoRecordExtensionWin2k_Type.tp_base = Object_Type;

	frsrpc_CommPktChangeOrderRecordExtension_Type.tp_base = Object_Type;

	frsrpc_CommPktChunk_Type.tp_base = Object_Type;

	frsrpc_CommPktChunkCtr_Type.tp_base = Object_Type;

	frsrpc_FrsSendCommPktReq_Type.tp_base = Object_Type;

	frsrpc_InterfaceType.tp_base = ClientConnection_Type;

	if (PyType_Ready(&frsrpc_CommPktChunkGuidName_Type) < 0)
		return;
	if (PyType_Ready(&frsrpc_CommPktGSVN_Type) < 0)
		return;
	if (PyType_Ready(&frsrpc_CommPktChangeOrderCommand_Type) < 0)
		return;
	if (PyType_Ready(&frsrpc_CommPktDataExtensionChecksum_Type) < 0)
		return;
	if (PyType_Ready(&frsrpc_CommPktDataExtensionRetryTimeout_Type) < 0)
		return;
	if (PyType_Ready(&frsrpc_CommPktCoRecordExtensionWin2k_Type) < 0)
		return;
	if (PyType_Ready(&frsrpc_CommPktChangeOrderRecordExtension_Type) < 0)
		return;
	if (PyType_Ready(&frsrpc_CommPktChunk_Type) < 0)
		return;
	if (PyType_Ready(&frsrpc_CommPktChunkCtr_Type) < 0)
		return;
	if (PyType_Ready(&frsrpc_FrsSendCommPktReq_Type) < 0)
		return;
	if (PyType_Ready(&frsrpc_InterfaceType) < 0)
		return;
	if (!PyInterface_AddNdrRpcMethods(&frsrpc_InterfaceType, py_ndr_frsrpc_methods))
		return;

#ifdef PY_COMMPKTCHUNKGUIDNAME_PATCH
	PY_COMMPKTCHUNKGUIDNAME_PATCH(&frsrpc_CommPktChunkGuidName_Type);
#endif
#ifdef PY_COMMPKTGSVN_PATCH
	PY_COMMPKTGSVN_PATCH(&frsrpc_CommPktGSVN_Type);
#endif
#ifdef PY_COMMPKTCHANGEORDERCOMMAND_PATCH
	PY_COMMPKTCHANGEORDERCOMMAND_PATCH(&frsrpc_CommPktChangeOrderCommand_Type);
#endif
#ifdef PY_COMMPKTDATAEXTENSIONCHECKSUM_PATCH
	PY_COMMPKTDATAEXTENSIONCHECKSUM_PATCH(&frsrpc_CommPktDataExtensionChecksum_Type);
#endif
#ifdef PY_COMMPKTDATAEXTENSIONRETRYTIMEOUT_PATCH
	PY_COMMPKTDATAEXTENSIONRETRYTIMEOUT_PATCH(&frsrpc_CommPktDataExtensionRetryTimeout_Type);
#endif
#ifdef PY_COMMPKTCORECORDEXTENSIONWIN2K_PATCH
	PY_COMMPKTCORECORDEXTENSIONWIN2K_PATCH(&frsrpc_CommPktCoRecordExtensionWin2k_Type);
#endif
#ifdef PY_COMMPKTCHANGEORDERRECORDEXTENSION_PATCH
	PY_COMMPKTCHANGEORDERRECORDEXTENSION_PATCH(&frsrpc_CommPktChangeOrderRecordExtension_Type);
#endif
#ifdef PY_COMMPKTCHUNK_PATCH
	PY_COMMPKTCHUNK_PATCH(&frsrpc_CommPktChunk_Type);
#endif
#ifdef PY_COMMPKTCHUNKCTR_PATCH
	PY_COMMPKTCHUNKCTR_PATCH(&frsrpc_CommPktChunkCtr_Type);
#endif
#ifdef PY_FRSSENDCOMMPKTREQ_PATCH
	PY_FRSSENDCOMMPKTREQ_PATCH(&frsrpc_FrsSendCommPktReq_Type);
#endif
#ifdef PY_FRSRPC_PATCH
	PY_FRSRPC_PATCH(&frsrpc_InterfaceType);
#endif

	m = Py_InitModule3("frsrpc", frsrpc_methods, "frsrpc DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "FRSRPC_CONTENT_REASON_DATA_TRUNCATION", PyInt_FromLong(FRSRPC_CONTENT_REASON_DATA_TRUNCATION));
	PyModule_AddObject(m, "FRSRPC_CO_IFLAG_CO_ABORT", PyInt_FromLong(FRSRPC_CO_IFLAG_CO_ABORT));
	PyModule_AddObject(m, "FRSRPC_CONTENT_REASON_BASIC_INFO_CHANGE", PyInt_FromLong(FRSRPC_CONTENT_REASON_BASIC_INFO_CHANGE));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_MAJOR_0", PyInt_FromLong(FRSRPC_COMM_PKT_MAJOR_0));
	PyModule_AddObject(m, "FRSRPC_CO_FLAG_SKIP_ORIG_REC_C", PyInt_FromLong(FRSRPC_CO_FLAG_SKIP_ORIG_REC_C));
	PyModule_AddObject(m, "FRSRPC_CO_STATUS_CO_ENTERED_LOG", PyInt_FromLong(FRSRPC_CO_STATUS_CO_ENTERED_LOG));
	PyModule_AddObject(m, "FRSRPC_CONTENT_REASON_NAMED_DATA_EXTEND", PyInt_FromLong(FRSRPC_CONTENT_REASON_NAMED_DATA_EXTEND));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_CHUNK_FILE_SIZE", PyInt_FromLong(FRSRPC_COMM_PKT_CHUNK_FILE_SIZE));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_MINOR_9", PyInt_FromLong(FRSRPC_COMM_PKT_MINOR_9));
	PyModule_AddObject(m, "FRSRPC_CONTENT_REASON_NEW_NAME", PyInt_FromLong(FRSRPC_CONTENT_REASON_NEW_NAME));
	PyModule_AddObject(m, "FRSRPC_CO_LOCATION_DIR_NO_CMD", PyInt_FromLong(FRSRPC_CO_LOCATION_DIR_NO_CMD));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_CHUNK_GVSN", PyInt_FromLong(FRSRPC_COMM_PKT_CHUNK_GVSN));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_CHUNK_BOP", PyInt_FromLong(FRSRPC_COMM_PKT_CHUNK_BOP));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_CHUNK_CO_GUID", PyInt_FromLong(FRSRPC_COMM_PKT_CHUNK_CO_GUID));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_CHUNK_JOIN_GUID", PyInt_FromLong(FRSRPC_COMM_PKT_CHUNK_JOIN_GUID));
	PyModule_AddObject(m, "FRSRPC_CO_STATUS_LOCAL_CO_STAGING_COMPLETED", PyInt_FromLong(FRSRPC_CO_STATUS_LOCAL_CO_STAGING_COMPLETED));
	PyModule_AddObject(m, "FRSRPC_CO_LOCATION_FILE_MOVEIN2", PyInt_FromLong(FRSRPC_CO_LOCATION_FILE_MOVEIN2));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_CHUNK_FROM", PyInt_FromLong(FRSRPC_COMM_PKT_CHUNK_FROM));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_MINOR_5", PyInt_FromLong(FRSRPC_COMM_PKT_MINOR_5));
	PyModule_AddObject(m, "FRSRPC_CO_LOCATION_FILE_MOVEDIR", PyInt_FromLong(FRSRPC_CO_LOCATION_FILE_MOVEDIR));
	PyModule_AddObject(m, "FRSRPC_CO_FLAG_CONTENT_CMD", PyInt_FromLong(FRSRPC_CO_FLAG_CONTENT_CMD));
	PyModule_AddObject(m, "FRSRPC_CO_IFLAG_DIR_ENUM_PENDING", PyInt_FromLong(FRSRPC_CO_IFLAG_DIR_ENUM_PENDING));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_CHUNK_CO_EXT_WIN2K", PyInt_FromLong(FRSRPC_COMM_PKT_CHUNK_CO_EXT_WIN2K));
	PyModule_AddObject(m, "FRSRPC_CO_STATUS_LOCAL_CO_STAGING_STARTED", PyInt_FromLong(FRSRPC_CO_STATUS_LOCAL_CO_STAGING_STARTED));
	PyModule_AddObject(m, "FRSRPC_CO_LOCATION_DIR_MOVEIN2", PyInt_FromLong(FRSRPC_CO_LOCATION_DIR_MOVEIN2));
	PyModule_AddObject(m, "FRSRPC_COMMAND_NEED_JOIN", PyInt_FromLong(FRSRPC_COMMAND_NEED_JOIN));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_CHUNK_REMOTE_CO", PyInt_FromLong(FRSRPC_COMM_PKT_CHUNK_REMOTE_CO));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_MINOR_6", PyInt_FromLong(FRSRPC_COMM_PKT_MINOR_6));
	PyModule_AddObject(m, "FRSRPC_CONTENT_REASON_FILE_CREATE", PyInt_FromLong(FRSRPC_CONTENT_REASON_FILE_CREATE));
	PyModule_AddObject(m, "FRSRPC_CO_LOCATION_DIR_MOVERS", PyInt_FromLong(FRSRPC_CO_LOCATION_DIR_MOVERS));
	PyModule_AddObject(m, "FRSRPC_CO_STATUS_FILE_INSTALL_COMPLETED", PyInt_FromLong(FRSRPC_CO_STATUS_FILE_INSTALL_COMPLETED));
	PyModule_AddObject(m, "FRSRPC_CO_FLAG_RETRY", PyInt_FromLong(FRSRPC_CO_FLAG_RETRY));
	PyModule_AddObject(m, "FRSRPC_CO_LOCATION_FILE_MOVEIN", PyInt_FromLong(FRSRPC_CO_LOCATION_FILE_MOVEIN));
	PyModule_AddObject(m, "FRSRPC_CO_LOCATION_FILE_MOVEOUT", PyInt_FromLong(FRSRPC_CO_LOCATION_FILE_MOVEOUT));
	PyModule_AddObject(m, "FRSRPC_CO_LOCATION_DIR_MOVEOUT", PyInt_FromLong(FRSRPC_CO_LOCATION_DIR_MOVEOUT));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_MINOR_1", PyInt_FromLong(FRSRPC_COMM_PKT_MINOR_1));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_CHUNK_LAST_JOIN_TIME", PyInt_FromLong(FRSRPC_COMM_PKT_CHUNK_LAST_JOIN_TIME));
	PyModule_AddObject(m, "FRSRPC_CO_FLAG_JUST_OID_RESET", PyInt_FromLong(FRSRPC_CO_FLAG_JUST_OID_RESET));
	PyModule_AddObject(m, "FRSRPC_CONTENT_REASON_DATA_EXTEND", PyInt_FromLong(FRSRPC_CONTENT_REASON_DATA_EXTEND));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_CHUNK_FILE_OFFSET", PyInt_FromLong(FRSRPC_COMM_PKT_CHUNK_FILE_OFFSET));
	PyModule_AddObject(m, "FRSRPC_CO_FLAG_MOVEIN_GEN", PyInt_FromLong(FRSRPC_CO_FLAG_MOVEIN_GEN));
	PyModule_AddObject(m, "FRSRPC_CO_LOCATION_FILE_CREATE", PyInt_FromLong(FRSRPC_CO_LOCATION_FILE_CREATE));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_CHUNK_CO_EXTENTION_2", PyInt_FromLong(FRSRPC_COMM_PKT_CHUNK_CO_EXTENTION_2));
	PyModule_AddObject(m, "FRSRPC_CONTENT_REASON_NAMED_DATA_TRUNCATION", PyInt_FromLong(FRSRPC_CONTENT_REASON_NAMED_DATA_TRUNCATION));
	PyModule_AddObject(m, "FRSRPC_PARENT_AUTH_LEVEL_NO_AUTHENTICATION", PyInt_FromLong(FRSRPC_PARENT_AUTH_LEVEL_NO_AUTHENTICATION));
	PyModule_AddObject(m, "FRSRPC_CO_FLAG_COMPRESSED_STAGE", PyInt_FromLong(FRSRPC_CO_FLAG_COMPRESSED_STAGE));
	PyModule_AddObject(m, "FRSRPC_CO_IFLAG_NONE", PyInt_FromLong(0x0000000));
	PyModule_AddObject(m, "FRSRPC_COMMAND_RETRY_FETCH", PyInt_FromLong(FRSRPC_COMMAND_RETRY_FETCH));
	PyModule_AddObject(m, "FRSRPC_CO_FLAG_LOCALCO", PyInt_FromLong(FRSRPC_CO_FLAG_LOCALCO));
	PyModule_AddObject(m, "FRSRPC_CO_FLAG_VV_ACTIVATED", PyInt_FromLong(FRSRPC_CO_FLAG_VV_ACTIVATED));
	PyModule_AddObject(m, "FRSRPC_COMMAND_UNJOIN_REMOTE", PyInt_FromLong(FRSRPC_COMMAND_UNJOIN_REMOTE));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_CHUNK_CONNECTION", PyInt_FromLong(FRSRPC_COMM_PKT_CHUNK_CONNECTION));
	PyModule_AddObject(m, "FRSRPC_COMMAND_JOINED", PyInt_FromLong(FRSRPC_COMMAND_JOINED));
	PyModule_AddObject(m, "FRSRPC_CO_STATUS_REMOTE_CO_STAGING_COMPLETED", PyInt_FromLong(FRSRPC_CO_STATUS_REMOTE_CO_STAGING_COMPLETED));
	PyModule_AddObject(m, "FRSRPC_CONTENT_REASON_NAMED_DATA_OVERWRITE", PyInt_FromLong(FRSRPC_CONTENT_REASON_NAMED_DATA_OVERWRITE));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_MINOR_8", PyInt_FromLong(FRSRPC_COMM_PKT_MINOR_8));
	PyModule_AddObject(m, "FRSRPC_COMMAND_REMOTE_CO_DONE", PyInt_FromLong(FRSRPC_COMMAND_REMOTE_CO_DONE));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_MINOR_2", PyInt_FromLong(FRSRPC_COMM_PKT_MINOR_2));
	PyModule_AddObject(m, "FRSRPC_CONTENT_REASON_SECURITY_CHANGE", PyInt_FromLong(FRSRPC_CONTENT_REASON_SECURITY_CHANGE));
	PyModule_AddObject(m, "FRSRPC_COMMAND_REMOTE_CO", PyInt_FromLong(FRSRPC_COMMAND_REMOTE_CO));
	PyModule_AddObject(m, "FRSRPC_CO_FLAG_MORPH_GEN_HEAD", PyInt_FromLong(FRSRPC_CO_FLAG_MORPH_GEN_HEAD));
	PyModule_AddObject(m, "FRSRPC_COMMAND_SEND_STAGE", PyInt_FromLong(FRSRPC_COMMAND_SEND_STAGE));
	PyModule_AddObject(m, "FRSRPC_CO_STATUS_DB_STATE_UPDATE_STARTED", PyInt_FromLong(FRSRPC_CO_STATUS_DB_STATE_UPDATE_STARTED));
	PyModule_AddObject(m, "FRSRPC_CO_FLAG_CONTROL", PyInt_FromLong(FRSRPC_CO_FLAG_CONTROL));
	PyModule_AddObject(m, "FRSRPC_CO_FLAG_ABORT_CO", PyInt_FromLong(FRSRPC_CO_FLAG_ABORT_CO));
	PyModule_AddObject(m, "FRSRPC_COMMAND_WJOIN_DONE", PyInt_FromLong(FRSRPC_COMMAND_WJOIN_DONE));
	PyModule_AddObject(m, "FRSRPC_CO_LOCATION_DIR_DELETE", PyInt_FromLong(FRSRPC_CO_LOCATION_DIR_DELETE));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_MINOR_3", PyInt_FromLong(FRSRPC_COMM_PKT_MINOR_3));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_CHUNK_BLOCK_SIZE", PyInt_FromLong(FRSRPC_COMM_PKT_CHUNK_BLOCK_SIZE));
	PyModule_AddObject(m, "FRSRPC_COMMAND_ABORT_FETCH", PyInt_FromLong(FRSRPC_COMMAND_ABORT_FETCH));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_CHUNK_VVECTOR", PyInt_FromLong(FRSRPC_COMM_PKT_CHUNK_VVECTOR));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_CHUNK_REPLICA", PyInt_FromLong(FRSRPC_COMM_PKT_CHUNK_REPLICA));
	PyModule_AddObject(m, "FRSRPC_CO_FLAG_VVJOIN_TO_ORIG", PyInt_FromLong(FRSRPC_CO_FLAG_VVJOIN_TO_ORIG));
	PyModule_AddObject(m, "FRSRPC_CONTENT_REASON_EA_CHANGE", PyInt_FromLong(FRSRPC_CONTENT_REASON_EA_CHANGE));
	PyModule_AddObject(m, "FRSRPC_CO_LOCATION_DIR_MOVEDIR", PyInt_FromLong(FRSRPC_CO_LOCATION_DIR_MOVEDIR));
	PyModule_AddObject(m, "FRSRPC_CO_STATUS_REQUEST_ACCEPTED_OUTBOUND_LOG", PyInt_FromLong(FRSRPC_CO_STATUS_REQUEST_ACCEPTED_OUTBOUND_LOG));
	PyModule_AddObject(m, "FRSRPC_CO_STATUS_DB_STATE_UPDATE_COMPLETED", PyInt_FromLong(FRSRPC_CO_STATUS_DB_STATE_UPDATE_COMPLETED));
	PyModule_AddObject(m, "FRSRPC_CO_LOCATION_DIR_CREATE", PyInt_FromLong(FRSRPC_CO_LOCATION_DIR_CREATE));
	PyModule_AddObject(m, "FRSRPC_CO_STATUS_CO_ABORTED", PyInt_FromLong(FRSRPC_CO_STATUS_CO_ABORTED));
	PyModule_AddObject(m, "FRSRPC_CO_STATUS_CO_RECYCLED_FOR_ENUM", PyInt_FromLong(FRSRPC_CO_STATUS_CO_RECYCLED_FOR_ENUM));
	PyModule_AddObject(m, "FRSRPC_CO_STATUS_REQUEST_OUTBOUND_PROPAGATION", PyInt_FromLong(FRSRPC_CO_STATUS_REQUEST_OUTBOUND_PROPAGATION));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_CHUNK_COMPRESSION_GUID", PyInt_FromLong(FRSRPC_COMM_PKT_CHUNK_COMPRESSION_GUID));
	PyModule_AddObject(m, "FRSRPC_CO_STATUS_FILE_INSTALL_WAIT_RETRY", PyInt_FromLong(FRSRPC_CO_STATUS_FILE_INSTALL_WAIT_RETRY));
	PyModule_AddObject(m, "FRSRPC_CO_STATUS_FILE_INSTALL_STARTED", PyInt_FromLong(FRSRPC_CO_STATUS_FILE_INSTALL_STARTED));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_CHUNK_BLOCK", PyInt_FromLong(FRSRPC_COMM_PKT_CHUNK_BLOCK));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_MINOR_4", PyInt_FromLong(FRSRPC_COMM_PKT_MINOR_4));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_CHUNK_JOIN_TIME", PyInt_FromLong(FRSRPC_COMM_PKT_CHUNK_JOIN_TIME));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_CHUNK_REPLICA_VERSION_GUID", PyInt_FromLong(FRSRPC_COMM_PKT_CHUNK_REPLICA_VERSION_GUID));
	PyModule_AddObject(m, "FRSRPC_CO_LOCATION_FILE_DELETE", PyInt_FromLong(FRSRPC_CO_LOCATION_FILE_DELETE));
	PyModule_AddObject(m, "FRSRPC_CO_LOCATION_FILE_NO_CMD", PyInt_FromLong(FRSRPC_CO_LOCATION_FILE_NO_CMD));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_MINOR_7", PyInt_FromLong(FRSRPC_COMM_PKT_MINOR_7));
	PyModule_AddObject(m, "FRSRPC_COMMAND_RECEIVING_STATE", PyInt_FromLong(FRSRPC_COMMAND_RECEIVING_STATE));
	PyModule_AddObject(m, "FRSRPC_CO_STATUS_FILE_INSTALL_RENAME_RETRYING", PyInt_FromLong(FRSRPC_CO_STATUS_FILE_INSTALL_RENAME_RETRYING));
	PyModule_AddObject(m, "FRSRPC_CO_FLAG_NEW_FILE", PyInt_FromLong(FRSRPC_CO_FLAG_NEW_FILE));
	PyModule_AddObject(m, "FRSRPC_CO_LOCATION_DIR_MOVEIN", PyInt_FromLong(FRSRPC_CO_LOCATION_DIR_MOVEIN));
	PyModule_AddObject(m, "FRSRPC_CO_FLAG_DIRECTED_CO", PyInt_FromLong(FRSRPC_CO_FLAG_DIRECTED_CO));
	PyModule_AddObject(m, "FRSRPC_PARENT_AUTH_LEVEL_ENCRYPTED_KERBEROS", PyInt_FromLong(FRSRPC_PARENT_AUTH_LEVEL_ENCRYPTED_KERBEROS));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_CHUNK_TO", PyInt_FromLong(FRSRPC_COMM_PKT_CHUNK_TO));
	PyModule_AddObject(m, "FRSRPC_CO_FLAG_OUT_OF_ORDER", PyInt_FromLong(FRSRPC_CO_FLAG_OUT_OF_ORDER));
	PyModule_AddObject(m, "FRSRPC_CO_FLAG_LOCATION_CMD", PyInt_FromLong(FRSRPC_CO_FLAG_LOCATION_CMD));
	PyModule_AddObject(m, "FRSRPC_CO_STATUS_FILE_INSTALL_RETRYING", PyInt_FromLong(FRSRPC_CO_STATUS_FILE_INSTALL_RETRYING));
	PyModule_AddObject(m, "FRSRPC_DATA_EXTENSION_MD5_CHECKSUM", PyInt_FromLong(FRSRPC_DATA_EXTENSION_MD5_CHECKSUM));
	PyModule_AddObject(m, "FRSRPC_CO_STATUS_ALLOC_STAGING_REMOTE_CO", PyInt_FromLong(FRSRPC_CO_STATUS_ALLOC_STAGING_REMOTE_CO));
	PyModule_AddObject(m, "FRSRPC_CO_LOCATION_FILE_MOVERS", PyInt_FromLong(FRSRPC_CO_LOCATION_FILE_MOVERS));
	PyModule_AddObject(m, "FRSRPC_CO_FLAG_SKIP_VV_UPDATE", PyInt_FromLong(FRSRPC_CO_FLAG_SKIP_VV_UPDATE));
	PyModule_AddObject(m, "FRSRPC_CONTENT_REASON_COMPRESSION_CHANGE", PyInt_FromLong(FRSRPC_CONTENT_REASON_COMPRESSION_CHANGE));
	PyModule_AddObject(m, "FRSRPC_CO_IFLAG_VVRETIRE_EXEC", PyInt_FromLong(FRSRPC_CO_IFLAG_VVRETIRE_EXEC));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_CHUNK_COMMAND", PyInt_FromLong(FRSRPC_COMM_PKT_CHUNK_COMMAND));
	PyModule_AddObject(m, "FRSRPC_CO_STATUS_WAIT_RETRY_LOCAL_CO_STAGING", PyInt_FromLong(FRSRPC_CO_STATUS_WAIT_RETRY_LOCAL_CO_STAGING));
	PyModule_AddObject(m, "FRSRPC_CO_RECORD_EXTENSION_VERSION_WIN2K", PyInt_FromLong(FRSRPC_CO_RECORD_EXTENSION_VERSION_WIN2K));
	PyModule_AddObject(m, "FRSRPC_DATA_EXTENSION_RETRY_TIMEOUT", PyInt_FromLong(FRSRPC_DATA_EXTENSION_RETRY_TIMEOUT));
	PyModule_AddObject(m, "FRSRPC_CONTENT_REASON_OLD_NAME", PyInt_FromLong(FRSRPC_CONTENT_REASON_OLD_NAME));
	PyModule_AddObject(m, "FRSRPC_COMMAND_START_JOIN", PyInt_FromLong(FRSRPC_COMMAND_START_JOIN));
	PyModule_AddObject(m, "FRSRPC_CONTENT_REASON_FILE_DELETE", PyInt_FromLong(FRSRPC_CONTENT_REASON_FILE_DELETE));
	PyModule_AddObject(m, "FRSRPC_CO_STATUS_ALLOC_STAGING_LOCAL_CO", PyInt_FromLong(FRSRPC_CO_STATUS_ALLOC_STAGING_LOCAL_CO));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_CHUNK_CO_SEQUENCE_NUMBER", PyInt_FromLong(FRSRPC_COMM_PKT_CHUNK_CO_SEQUENCE_NUMBER));
	PyModule_AddObject(m, "FRSRPC_CO_STATUS_WAIT_RETRY_REMOTE_CO_STAGING", PyInt_FromLong(FRSRPC_CO_STATUS_WAIT_RETRY_REMOTE_CO_STAGING));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_CHUNK_EOP", PyInt_FromLong(FRSRPC_COMM_PKT_CHUNK_EOP));
	PyModule_AddObject(m, "FRSRPC_CO_FLAG_ONLIST", PyInt_FromLong(FRSRPC_CO_FLAG_ONLIST));
	PyModule_AddObject(m, "FRSRPC_CO_RECORD_EXTENSION_VERSION_1", PyInt_FromLong(FRSRPC_CO_RECORD_EXTENSION_VERSION_1));
	PyModule_AddObject(m, "FRSRPC_CO_STATUS_FILE_INSTALL_DELETE_RETRYING", PyInt_FromLong(FRSRPC_CO_STATUS_FILE_INSTALL_DELETE_RETRYING));
	PyModule_AddObject(m, "FRSRPC_DATA_EXTENSION_TERMINATOR", PyInt_FromLong(FRSRPC_DATA_EXTENSION_TERMINATOR));
	PyModule_AddObject(m, "FRSRPC_COMM_PKT_MINOR_0", PyInt_FromLong(FRSRPC_COMM_PKT_MINOR_0));
	PyModule_AddObject(m, "FRSRPC_COMMAND_JOINING", PyInt_FromLong(FRSRPC_COMMAND_JOINING));
	PyModule_AddObject(m, "FRSRPC_CO_STATUS_REMOTE_CO_STAGING_STARTED", PyInt_FromLong(FRSRPC_CO_STATUS_REMOTE_CO_STAGING_STARTED));
	PyModule_AddObject(m, "FRSRPC_CONTENT_REASON_DATA_OVERWRITE", PyInt_FromLong(FRSRPC_CONTENT_REASON_DATA_OVERWRITE));
	PyModule_AddObject(m, "FRSRPC_CO_STATUS_FILE_INSTALL_REQUESTED", PyInt_FromLong(FRSRPC_CO_STATUS_FILE_INSTALL_REQUESTED));
	Py_INCREF((PyObject *)(void *)&frsrpc_CommPktChunkGuidName_Type);
	PyModule_AddObject(m, "CommPktChunkGuidName", (PyObject *)(void *)&frsrpc_CommPktChunkGuidName_Type);
	Py_INCREF((PyObject *)(void *)&frsrpc_CommPktGSVN_Type);
	PyModule_AddObject(m, "CommPktGSVN", (PyObject *)(void *)&frsrpc_CommPktGSVN_Type);
	Py_INCREF((PyObject *)(void *)&frsrpc_CommPktChangeOrderCommand_Type);
	PyModule_AddObject(m, "CommPktChangeOrderCommand", (PyObject *)(void *)&frsrpc_CommPktChangeOrderCommand_Type);
	Py_INCREF((PyObject *)(void *)&frsrpc_CommPktDataExtensionChecksum_Type);
	PyModule_AddObject(m, "CommPktDataExtensionChecksum", (PyObject *)(void *)&frsrpc_CommPktDataExtensionChecksum_Type);
	Py_INCREF((PyObject *)(void *)&frsrpc_CommPktDataExtensionRetryTimeout_Type);
	PyModule_AddObject(m, "CommPktDataExtensionRetryTimeout", (PyObject *)(void *)&frsrpc_CommPktDataExtensionRetryTimeout_Type);
	Py_INCREF((PyObject *)(void *)&frsrpc_CommPktCoRecordExtensionWin2k_Type);
	PyModule_AddObject(m, "CommPktCoRecordExtensionWin2k", (PyObject *)(void *)&frsrpc_CommPktCoRecordExtensionWin2k_Type);
	Py_INCREF((PyObject *)(void *)&frsrpc_CommPktChangeOrderRecordExtension_Type);
	PyModule_AddObject(m, "CommPktChangeOrderRecordExtension", (PyObject *)(void *)&frsrpc_CommPktChangeOrderRecordExtension_Type);
	Py_INCREF((PyObject *)(void *)&frsrpc_CommPktChunk_Type);
	PyModule_AddObject(m, "CommPktChunk", (PyObject *)(void *)&frsrpc_CommPktChunk_Type);
	Py_INCREF((PyObject *)(void *)&frsrpc_CommPktChunkCtr_Type);
	PyModule_AddObject(m, "CommPktChunkCtr", (PyObject *)(void *)&frsrpc_CommPktChunkCtr_Type);
	Py_INCREF((PyObject *)(void *)&frsrpc_FrsSendCommPktReq_Type);
	PyModule_AddObject(m, "FrsSendCommPktReq", (PyObject *)(void *)&frsrpc_FrsSendCommPktReq_Type);
	Py_INCREF((PyObject *)(void *)&frsrpc_InterfaceType);
	PyModule_AddObject(m, "frsrpc", (PyObject *)(void *)&frsrpc_InterfaceType);
#ifdef PY_MOD_FRSRPC_PATCH
	PY_MOD_FRSRPC_PATCH(m);
#endif

}
