/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "librpc/gen_ndr/ndr_wmi.h"
#include "librpc/gen_ndr/ndr_wmi_c.h"

/* IWbemClassObject - client functions generated by pidl */

struct dcerpc_Delete_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Delete_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Delete_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Delete *r)
{
	struct tevent_req *req;
	struct dcerpc_Delete_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Delete_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemClassObject,
			NDR_DELETE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Delete_r_done, req);

	return req;
}

static void dcerpc_Delete_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Delete_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Delete_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Delete_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Delete_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Delete *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemClassObject,
			NDR_DELETE, mem_ctx, r);

	return status;
}

struct dcerpc_Delete_state {
	struct Delete orig;
	struct Delete tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Delete_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Delete_send(TALLOC_CTX *mem_ctx,
				      struct tevent_context *ev,
				      struct dcerpc_binding_handle *h,
				      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				      struct ORPCTHIS _ORPCthis /* [in]  */,
				      const char *_wszName /* [in] [ref,charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_Delete_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Delete_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.wszName = _wszName;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_Delete_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Delete_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Delete_done, req);
	return req;
}

static void dcerpc_Delete_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Delete_state *state = tevent_req_data(
		req, struct dcerpc_Delete_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Delete_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Delete_recv(struct tevent_req *req,
			    TALLOC_CTX *mem_ctx,
			    WERROR *result)
{
	struct dcerpc_Delete_state *state = tevent_req_data(
		req, struct dcerpc_Delete_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Delete(struct dcerpc_binding_handle *h,
		       TALLOC_CTX *mem_ctx,
		       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
		       struct ORPCTHIS _ORPCthis /* [in]  */,
		       const char *_wszName /* [in] [ref,charset(UTF16)] */,
		       WERROR *result)
{
	struct Delete r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.wszName = _wszName;

	status = dcerpc_Delete_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

/* IWbemServices - client functions generated by pidl */

struct dcerpc_OpenNamespace_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_OpenNamespace_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_OpenNamespace_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct OpenNamespace *r)
{
	struct tevent_req *req;
	struct dcerpc_OpenNamespace_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_OpenNamespace_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemServices,
			NDR_OPENNAMESPACE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_OpenNamespace_r_done, req);

	return req;
}

static void dcerpc_OpenNamespace_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_OpenNamespace_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_OpenNamespace_r_state *state =
		tevent_req_data(req,
		struct dcerpc_OpenNamespace_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_OpenNamespace_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct OpenNamespace *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemServices,
			NDR_OPENNAMESPACE, mem_ctx, r);

	return status;
}

struct dcerpc_OpenNamespace_state {
	struct OpenNamespace orig;
	struct OpenNamespace tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_OpenNamespace_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_OpenNamespace_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h,
					     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					     struct ORPCTHIS _ORPCthis /* [in]  */,
					     struct BSTR _strNamespace /* [in]  */,
					     int32_t _lFlags /* [in]  */,
					     struct MInterfacePointer *_pCtx /* [in] [ref] */,
					     struct MInterfacePointer **_ppWorkingNamespace /* [in,out] [unique] */,
					     struct MInterfacePointer **_ppResult /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_OpenNamespace_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_OpenNamespace_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strNamespace = _strNamespace;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.ppWorkingNamespace = _ppWorkingNamespace;
	state->orig.in.ppResult = _ppResult;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppWorkingNamespace = _ppWorkingNamespace;
	state->orig.out.ppResult = _ppResult;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_OpenNamespace_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_OpenNamespace_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_OpenNamespace_done, req);
	return req;
}

static void dcerpc_OpenNamespace_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_OpenNamespace_state *state = tevent_req_data(
		req, struct dcerpc_OpenNamespace_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_OpenNamespace_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	if (state->orig.out.ppWorkingNamespace && state->tmp.out.ppWorkingNamespace) {
		*state->orig.out.ppWorkingNamespace = *state->tmp.out.ppWorkingNamespace;
	}
	if (state->orig.out.ppResult && state->tmp.out.ppResult) {
		*state->orig.out.ppResult = *state->tmp.out.ppResult;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_OpenNamespace_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   WERROR *result)
{
	struct dcerpc_OpenNamespace_state *state = tevent_req_data(
		req, struct dcerpc_OpenNamespace_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_OpenNamespace(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
			      struct ORPCTHIS _ORPCthis /* [in]  */,
			      struct BSTR _strNamespace /* [in]  */,
			      int32_t _lFlags /* [in]  */,
			      struct MInterfacePointer *_pCtx /* [in] [ref] */,
			      struct MInterfacePointer **_ppWorkingNamespace /* [in,out] [unique] */,
			      struct MInterfacePointer **_ppResult /* [in,out] [unique] */,
			      WERROR *result)
{
	struct OpenNamespace r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.strNamespace = _strNamespace;
	r.in.lFlags = _lFlags;
	r.in.pCtx = _pCtx;
	r.in.ppWorkingNamespace = _ppWorkingNamespace;
	r.in.ppResult = _ppResult;

	status = dcerpc_OpenNamespace_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	if (_ppWorkingNamespace && r.out.ppWorkingNamespace) {
		*_ppWorkingNamespace = *r.out.ppWorkingNamespace;
	}
	if (_ppResult && r.out.ppResult) {
		*_ppResult = *r.out.ppResult;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_CancelAsyncCall_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_CancelAsyncCall_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_CancelAsyncCall_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct CancelAsyncCall *r)
{
	struct tevent_req *req;
	struct dcerpc_CancelAsyncCall_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_CancelAsyncCall_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemServices,
			NDR_CANCELASYNCCALL, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_CancelAsyncCall_r_done, req);

	return req;
}

static void dcerpc_CancelAsyncCall_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_CancelAsyncCall_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_CancelAsyncCall_r_state *state =
		tevent_req_data(req,
		struct dcerpc_CancelAsyncCall_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_CancelAsyncCall_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct CancelAsyncCall *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemServices,
			NDR_CANCELASYNCCALL, mem_ctx, r);

	return status;
}

struct dcerpc_CancelAsyncCall_state {
	struct CancelAsyncCall orig;
	struct CancelAsyncCall tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_CancelAsyncCall_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_CancelAsyncCall_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					       struct ORPCTHIS _ORPCthis /* [in]  */,
					       struct MInterfacePointer *_pSink /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_CancelAsyncCall_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_CancelAsyncCall_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.pSink = _pSink;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_CancelAsyncCall_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_CancelAsyncCall_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_CancelAsyncCall_done, req);
	return req;
}

static void dcerpc_CancelAsyncCall_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_CancelAsyncCall_state *state = tevent_req_data(
		req, struct dcerpc_CancelAsyncCall_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_CancelAsyncCall_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_CancelAsyncCall_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_CancelAsyncCall_state *state = tevent_req_data(
		req, struct dcerpc_CancelAsyncCall_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_CancelAsyncCall(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				struct ORPCTHIS _ORPCthis /* [in]  */,
				struct MInterfacePointer *_pSink /* [in] [ref] */,
				WERROR *result)
{
	struct CancelAsyncCall r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.pSink = _pSink;

	status = dcerpc_CancelAsyncCall_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_QueryObjectSink_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_QueryObjectSink_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_QueryObjectSink_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct QueryObjectSink *r)
{
	struct tevent_req *req;
	struct dcerpc_QueryObjectSink_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_QueryObjectSink_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemServices,
			NDR_QUERYOBJECTSINK, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_QueryObjectSink_r_done, req);

	return req;
}

static void dcerpc_QueryObjectSink_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_QueryObjectSink_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_QueryObjectSink_r_state *state =
		tevent_req_data(req,
		struct dcerpc_QueryObjectSink_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_QueryObjectSink_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct QueryObjectSink *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemServices,
			NDR_QUERYOBJECTSINK, mem_ctx, r);

	return status;
}

struct dcerpc_QueryObjectSink_state {
	struct QueryObjectSink orig;
	struct QueryObjectSink tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_QueryObjectSink_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_QueryObjectSink_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					       struct ORPCTHIS _ORPCthis /* [in]  */,
					       int32_t _lFlags /* [in]  */,
					       struct MInterfacePointer **_ppResponseHandler /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_QueryObjectSink_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_QueryObjectSink_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.lFlags = _lFlags;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppResponseHandler = _ppResponseHandler;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_QueryObjectSink_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_QueryObjectSink_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_QueryObjectSink_done, req);
	return req;
}

static void dcerpc_QueryObjectSink_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_QueryObjectSink_state *state = tevent_req_data(
		req, struct dcerpc_QueryObjectSink_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_QueryObjectSink_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppResponseHandler = *state->tmp.out.ppResponseHandler;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_QueryObjectSink_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_QueryObjectSink_state *state = tevent_req_data(
		req, struct dcerpc_QueryObjectSink_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_QueryObjectSink(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				struct ORPCTHIS _ORPCthis /* [in]  */,
				int32_t _lFlags /* [in]  */,
				struct MInterfacePointer **_ppResponseHandler /* [out] [ref] */,
				WERROR *result)
{
	struct QueryObjectSink r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.lFlags = _lFlags;

	status = dcerpc_QueryObjectSink_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	*_ppResponseHandler = *r.out.ppResponseHandler;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_GetObject_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_GetObject_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_GetObject_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct GetObject *r)
{
	struct tevent_req *req;
	struct dcerpc_GetObject_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_GetObject_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemServices,
			NDR_GETOBJECT, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_GetObject_r_done, req);

	return req;
}

static void dcerpc_GetObject_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_GetObject_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_GetObject_r_state *state =
		tevent_req_data(req,
		struct dcerpc_GetObject_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_GetObject_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct GetObject *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemServices,
			NDR_GETOBJECT, mem_ctx, r);

	return status;
}

struct dcerpc_GetObject_state {
	struct GetObject orig;
	struct GetObject tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_GetObject_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_GetObject_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct dcerpc_binding_handle *h,
					 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					 struct ORPCTHIS _ORPCthis /* [in]  */,
					 struct BSTR _strObjectPath /* [in]  */,
					 int32_t _lFlags /* [in]  */,
					 struct MInterfacePointer *_pCtx /* [in] [ref] */,
					 struct MInterfacePointer **_ppObject /* [in,out] [unique] */,
					 struct MInterfacePointer **_ppCallResult /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_GetObject_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_GetObject_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strObjectPath = _strObjectPath;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.ppObject = _ppObject;
	state->orig.in.ppCallResult = _ppCallResult;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppObject = _ppObject;
	state->orig.out.ppCallResult = _ppCallResult;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_GetObject_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_GetObject_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_GetObject_done, req);
	return req;
}

static void dcerpc_GetObject_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_GetObject_state *state = tevent_req_data(
		req, struct dcerpc_GetObject_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_GetObject_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	if (state->orig.out.ppObject && state->tmp.out.ppObject) {
		*state->orig.out.ppObject = *state->tmp.out.ppObject;
	}
	if (state->orig.out.ppCallResult && state->tmp.out.ppCallResult) {
		*state->orig.out.ppCallResult = *state->tmp.out.ppCallResult;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_GetObject_recv(struct tevent_req *req,
			       TALLOC_CTX *mem_ctx,
			       WERROR *result)
{
	struct dcerpc_GetObject_state *state = tevent_req_data(
		req, struct dcerpc_GetObject_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_GetObject(struct dcerpc_binding_handle *h,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS _ORPCthis /* [in]  */,
			  struct BSTR _strObjectPath /* [in]  */,
			  int32_t _lFlags /* [in]  */,
			  struct MInterfacePointer *_pCtx /* [in] [ref] */,
			  struct MInterfacePointer **_ppObject /* [in,out] [unique] */,
			  struct MInterfacePointer **_ppCallResult /* [in,out] [unique] */,
			  WERROR *result)
{
	struct GetObject r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.strObjectPath = _strObjectPath;
	r.in.lFlags = _lFlags;
	r.in.pCtx = _pCtx;
	r.in.ppObject = _ppObject;
	r.in.ppCallResult = _ppCallResult;

	status = dcerpc_GetObject_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	if (_ppObject && r.out.ppObject) {
		*_ppObject = *r.out.ppObject;
	}
	if (_ppCallResult && r.out.ppCallResult) {
		*_ppCallResult = *r.out.ppCallResult;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_GetObjectAsync_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_GetObjectAsync_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_GetObjectAsync_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct GetObjectAsync *r)
{
	struct tevent_req *req;
	struct dcerpc_GetObjectAsync_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_GetObjectAsync_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemServices,
			NDR_GETOBJECTASYNC, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_GetObjectAsync_r_done, req);

	return req;
}

static void dcerpc_GetObjectAsync_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_GetObjectAsync_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_GetObjectAsync_r_state *state =
		tevent_req_data(req,
		struct dcerpc_GetObjectAsync_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_GetObjectAsync_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct GetObjectAsync *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemServices,
			NDR_GETOBJECTASYNC, mem_ctx, r);

	return status;
}

struct dcerpc_GetObjectAsync_state {
	struct GetObjectAsync orig;
	struct GetObjectAsync tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_GetObjectAsync_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_GetObjectAsync_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					      struct ORPCTHIS _ORPCthis /* [in]  */,
					      struct BSTR _strObjectPath /* [in]  */,
					      int32_t _lFlags /* [in]  */,
					      struct MInterfacePointer *_pCtx /* [in] [ref] */,
					      struct MInterfacePointer *_pResponseHandler /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_GetObjectAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_GetObjectAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strObjectPath = _strObjectPath;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.pResponseHandler = _pResponseHandler;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_GetObjectAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_GetObjectAsync_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_GetObjectAsync_done, req);
	return req;
}

static void dcerpc_GetObjectAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_GetObjectAsync_state *state = tevent_req_data(
		req, struct dcerpc_GetObjectAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_GetObjectAsync_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_GetObjectAsync_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result)
{
	struct dcerpc_GetObjectAsync_state *state = tevent_req_data(
		req, struct dcerpc_GetObjectAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_GetObjectAsync(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS _ORPCthis /* [in]  */,
			       struct BSTR _strObjectPath /* [in]  */,
			       int32_t _lFlags /* [in]  */,
			       struct MInterfacePointer *_pCtx /* [in] [ref] */,
			       struct MInterfacePointer *_pResponseHandler /* [in] [ref] */,
			       WERROR *result)
{
	struct GetObjectAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.strObjectPath = _strObjectPath;
	r.in.lFlags = _lFlags;
	r.in.pCtx = _pCtx;
	r.in.pResponseHandler = _pResponseHandler;

	status = dcerpc_GetObjectAsync_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_PutClass_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_PutClass_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_PutClass_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct PutClass *r)
{
	struct tevent_req *req;
	struct dcerpc_PutClass_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_PutClass_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemServices,
			NDR_PUTCLASS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_PutClass_r_done, req);

	return req;
}

static void dcerpc_PutClass_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_PutClass_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_PutClass_r_state *state =
		tevent_req_data(req,
		struct dcerpc_PutClass_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_PutClass_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct PutClass *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemServices,
			NDR_PUTCLASS, mem_ctx, r);

	return status;
}

struct dcerpc_PutClass_state {
	struct PutClass orig;
	struct PutClass tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_PutClass_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_PutClass_send(TALLOC_CTX *mem_ctx,
					struct tevent_context *ev,
					struct dcerpc_binding_handle *h,
					struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					struct ORPCTHIS _ORPCthis /* [in]  */,
					struct MInterfacePointer *_pObject /* [in] [ref] */,
					int32_t _lFlags /* [in]  */,
					struct MInterfacePointer *_pCtx /* [in] [ref] */,
					struct MInterfacePointer **_ppCallResult /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_PutClass_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_PutClass_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.pObject = _pObject;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.ppCallResult = _ppCallResult;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppCallResult = _ppCallResult;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_PutClass_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_PutClass_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_PutClass_done, req);
	return req;
}

static void dcerpc_PutClass_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_PutClass_state *state = tevent_req_data(
		req, struct dcerpc_PutClass_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_PutClass_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	if (state->orig.out.ppCallResult && state->tmp.out.ppCallResult) {
		*state->orig.out.ppCallResult = *state->tmp.out.ppCallResult;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_PutClass_recv(struct tevent_req *req,
			      TALLOC_CTX *mem_ctx,
			      WERROR *result)
{
	struct dcerpc_PutClass_state *state = tevent_req_data(
		req, struct dcerpc_PutClass_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_PutClass(struct dcerpc_binding_handle *h,
			 TALLOC_CTX *mem_ctx,
			 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
			 struct ORPCTHIS _ORPCthis /* [in]  */,
			 struct MInterfacePointer *_pObject /* [in] [ref] */,
			 int32_t _lFlags /* [in]  */,
			 struct MInterfacePointer *_pCtx /* [in] [ref] */,
			 struct MInterfacePointer **_ppCallResult /* [in,out] [unique] */,
			 WERROR *result)
{
	struct PutClass r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.pObject = _pObject;
	r.in.lFlags = _lFlags;
	r.in.pCtx = _pCtx;
	r.in.ppCallResult = _ppCallResult;

	status = dcerpc_PutClass_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	if (_ppCallResult && r.out.ppCallResult) {
		*_ppCallResult = *r.out.ppCallResult;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_PutClassAsync_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_PutClassAsync_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_PutClassAsync_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct PutClassAsync *r)
{
	struct tevent_req *req;
	struct dcerpc_PutClassAsync_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_PutClassAsync_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemServices,
			NDR_PUTCLASSASYNC, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_PutClassAsync_r_done, req);

	return req;
}

static void dcerpc_PutClassAsync_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_PutClassAsync_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_PutClassAsync_r_state *state =
		tevent_req_data(req,
		struct dcerpc_PutClassAsync_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_PutClassAsync_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct PutClassAsync *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemServices,
			NDR_PUTCLASSASYNC, mem_ctx, r);

	return status;
}

struct dcerpc_PutClassAsync_state {
	struct PutClassAsync orig;
	struct PutClassAsync tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_PutClassAsync_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_PutClassAsync_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h,
					     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					     struct ORPCTHIS _ORPCthis /* [in]  */,
					     struct MInterfacePointer *_pObject /* [in] [ref] */,
					     int32_t _lFlags /* [in]  */,
					     struct MInterfacePointer *_pCtx /* [in] [ref] */,
					     struct MInterfacePointer *_pResponseHandler /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_PutClassAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_PutClassAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.pObject = _pObject;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.pResponseHandler = _pResponseHandler;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_PutClassAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_PutClassAsync_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_PutClassAsync_done, req);
	return req;
}

static void dcerpc_PutClassAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_PutClassAsync_state *state = tevent_req_data(
		req, struct dcerpc_PutClassAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_PutClassAsync_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_PutClassAsync_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   WERROR *result)
{
	struct dcerpc_PutClassAsync_state *state = tevent_req_data(
		req, struct dcerpc_PutClassAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_PutClassAsync(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
			      struct ORPCTHIS _ORPCthis /* [in]  */,
			      struct MInterfacePointer *_pObject /* [in] [ref] */,
			      int32_t _lFlags /* [in]  */,
			      struct MInterfacePointer *_pCtx /* [in] [ref] */,
			      struct MInterfacePointer *_pResponseHandler /* [in] [ref] */,
			      WERROR *result)
{
	struct PutClassAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.pObject = _pObject;
	r.in.lFlags = _lFlags;
	r.in.pCtx = _pCtx;
	r.in.pResponseHandler = _pResponseHandler;

	status = dcerpc_PutClassAsync_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_DeleteClass_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DeleteClass_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DeleteClass_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct DeleteClass *r)
{
	struct tevent_req *req;
	struct dcerpc_DeleteClass_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DeleteClass_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemServices,
			NDR_DELETECLASS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DeleteClass_r_done, req);

	return req;
}

static void dcerpc_DeleteClass_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_DeleteClass_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_DeleteClass_r_state *state =
		tevent_req_data(req,
		struct dcerpc_DeleteClass_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DeleteClass_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct DeleteClass *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemServices,
			NDR_DELETECLASS, mem_ctx, r);

	return status;
}

struct dcerpc_DeleteClass_state {
	struct DeleteClass orig;
	struct DeleteClass tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DeleteClass_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DeleteClass_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct dcerpc_binding_handle *h,
					   struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					   struct ORPCTHIS _ORPCthis /* [in]  */,
					   struct BSTR _strClass /* [in]  */,
					   int32_t _lFlags /* [in]  */,
					   struct MInterfacePointer *_pCtx /* [in] [ref] */,
					   struct MInterfacePointer **_ppCallResult /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_DeleteClass_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DeleteClass_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strClass = _strClass;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.ppCallResult = _ppCallResult;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppCallResult = _ppCallResult;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_DeleteClass_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_DeleteClass_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DeleteClass_done, req);
	return req;
}

static void dcerpc_DeleteClass_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_DeleteClass_state *state = tevent_req_data(
		req, struct dcerpc_DeleteClass_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_DeleteClass_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	if (state->orig.out.ppCallResult && state->tmp.out.ppCallResult) {
		*state->orig.out.ppCallResult = *state->tmp.out.ppCallResult;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_DeleteClass_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 WERROR *result)
{
	struct dcerpc_DeleteClass_state *state = tevent_req_data(
		req, struct dcerpc_DeleteClass_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DeleteClass(struct dcerpc_binding_handle *h,
			    TALLOC_CTX *mem_ctx,
			    struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
			    struct ORPCTHIS _ORPCthis /* [in]  */,
			    struct BSTR _strClass /* [in]  */,
			    int32_t _lFlags /* [in]  */,
			    struct MInterfacePointer *_pCtx /* [in] [ref] */,
			    struct MInterfacePointer **_ppCallResult /* [in,out] [unique] */,
			    WERROR *result)
{
	struct DeleteClass r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.strClass = _strClass;
	r.in.lFlags = _lFlags;
	r.in.pCtx = _pCtx;
	r.in.ppCallResult = _ppCallResult;

	status = dcerpc_DeleteClass_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	if (_ppCallResult && r.out.ppCallResult) {
		*_ppCallResult = *r.out.ppCallResult;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_DeleteClassAsync_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DeleteClassAsync_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DeleteClassAsync_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct DeleteClassAsync *r)
{
	struct tevent_req *req;
	struct dcerpc_DeleteClassAsync_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DeleteClassAsync_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemServices,
			NDR_DELETECLASSASYNC, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DeleteClassAsync_r_done, req);

	return req;
}

static void dcerpc_DeleteClassAsync_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_DeleteClassAsync_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_DeleteClassAsync_r_state *state =
		tevent_req_data(req,
		struct dcerpc_DeleteClassAsync_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DeleteClassAsync_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct DeleteClassAsync *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemServices,
			NDR_DELETECLASSASYNC, mem_ctx, r);

	return status;
}

struct dcerpc_DeleteClassAsync_state {
	struct DeleteClassAsync orig;
	struct DeleteClassAsync tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DeleteClassAsync_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DeleteClassAsync_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						struct ORPCTHIS _ORPCthis /* [in]  */,
						struct BSTR _strClass /* [in]  */,
						int32_t _lFlags /* [in]  */,
						struct MInterfacePointer *_pCtx /* [in] [ref] */,
						struct MInterfacePointer *_pResponseHandler /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_DeleteClassAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DeleteClassAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strClass = _strClass;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.pResponseHandler = _pResponseHandler;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_DeleteClassAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_DeleteClassAsync_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DeleteClassAsync_done, req);
	return req;
}

static void dcerpc_DeleteClassAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_DeleteClassAsync_state *state = tevent_req_data(
		req, struct dcerpc_DeleteClassAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_DeleteClassAsync_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_DeleteClassAsync_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct dcerpc_DeleteClassAsync_state *state = tevent_req_data(
		req, struct dcerpc_DeleteClassAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DeleteClassAsync(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS _ORPCthis /* [in]  */,
				 struct BSTR _strClass /* [in]  */,
				 int32_t _lFlags /* [in]  */,
				 struct MInterfacePointer *_pCtx /* [in] [ref] */,
				 struct MInterfacePointer *_pResponseHandler /* [in] [ref] */,
				 WERROR *result)
{
	struct DeleteClassAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.strClass = _strClass;
	r.in.lFlags = _lFlags;
	r.in.pCtx = _pCtx;
	r.in.pResponseHandler = _pResponseHandler;

	status = dcerpc_DeleteClassAsync_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_CreateClassEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_CreateClassEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_CreateClassEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct CreateClassEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_CreateClassEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_CreateClassEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemServices,
			NDR_CREATECLASSENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_CreateClassEnum_r_done, req);

	return req;
}

static void dcerpc_CreateClassEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_CreateClassEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_CreateClassEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_CreateClassEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_CreateClassEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct CreateClassEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemServices,
			NDR_CREATECLASSENUM, mem_ctx, r);

	return status;
}

struct dcerpc_CreateClassEnum_state {
	struct CreateClassEnum orig;
	struct CreateClassEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_CreateClassEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_CreateClassEnum_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					       struct ORPCTHIS _ORPCthis /* [in]  */,
					       struct BSTR _strSuperclass /* [in]  */,
					       int32_t _lFlags /* [in]  */,
					       struct MInterfacePointer *_pCtx /* [in] [ref] */,
					       struct MInterfacePointer **_ppEnum /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_CreateClassEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_CreateClassEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strSuperclass = _strSuperclass;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppEnum = _ppEnum;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_CreateClassEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_CreateClassEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_CreateClassEnum_done, req);
	return req;
}

static void dcerpc_CreateClassEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_CreateClassEnum_state *state = tevent_req_data(
		req, struct dcerpc_CreateClassEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_CreateClassEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppEnum = *state->tmp.out.ppEnum;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_CreateClassEnum_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_CreateClassEnum_state *state = tevent_req_data(
		req, struct dcerpc_CreateClassEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_CreateClassEnum(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				struct ORPCTHIS _ORPCthis /* [in]  */,
				struct BSTR _strSuperclass /* [in]  */,
				int32_t _lFlags /* [in]  */,
				struct MInterfacePointer *_pCtx /* [in] [ref] */,
				struct MInterfacePointer **_ppEnum /* [out] [ref] */,
				WERROR *result)
{
	struct CreateClassEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.strSuperclass = _strSuperclass;
	r.in.lFlags = _lFlags;
	r.in.pCtx = _pCtx;

	status = dcerpc_CreateClassEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	*_ppEnum = *r.out.ppEnum;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_CreateClassEnumAsync_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_CreateClassEnumAsync_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_CreateClassEnumAsync_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct CreateClassEnumAsync *r)
{
	struct tevent_req *req;
	struct dcerpc_CreateClassEnumAsync_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_CreateClassEnumAsync_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemServices,
			NDR_CREATECLASSENUMASYNC, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_CreateClassEnumAsync_r_done, req);

	return req;
}

static void dcerpc_CreateClassEnumAsync_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_CreateClassEnumAsync_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_CreateClassEnumAsync_r_state *state =
		tevent_req_data(req,
		struct dcerpc_CreateClassEnumAsync_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_CreateClassEnumAsync_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct CreateClassEnumAsync *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemServices,
			NDR_CREATECLASSENUMASYNC, mem_ctx, r);

	return status;
}

struct dcerpc_CreateClassEnumAsync_state {
	struct CreateClassEnumAsync orig;
	struct CreateClassEnumAsync tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_CreateClassEnumAsync_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_CreateClassEnumAsync_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						    struct ORPCTHIS _ORPCthis /* [in]  */,
						    struct BSTR _strSuperclass /* [in]  */,
						    int32_t _lFlags /* [in]  */,
						    struct MInterfacePointer *_pCtx /* [in] [ref] */,
						    struct MInterfacePointer *_pResponseHandler /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_CreateClassEnumAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_CreateClassEnumAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strSuperclass = _strSuperclass;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.pResponseHandler = _pResponseHandler;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_CreateClassEnumAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_CreateClassEnumAsync_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_CreateClassEnumAsync_done, req);
	return req;
}

static void dcerpc_CreateClassEnumAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_CreateClassEnumAsync_state *state = tevent_req_data(
		req, struct dcerpc_CreateClassEnumAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_CreateClassEnumAsync_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_CreateClassEnumAsync_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_CreateClassEnumAsync_state *state = tevent_req_data(
		req, struct dcerpc_CreateClassEnumAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_CreateClassEnumAsync(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				     struct ORPCTHIS _ORPCthis /* [in]  */,
				     struct BSTR _strSuperclass /* [in]  */,
				     int32_t _lFlags /* [in]  */,
				     struct MInterfacePointer *_pCtx /* [in] [ref] */,
				     struct MInterfacePointer *_pResponseHandler /* [in] [ref] */,
				     WERROR *result)
{
	struct CreateClassEnumAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.strSuperclass = _strSuperclass;
	r.in.lFlags = _lFlags;
	r.in.pCtx = _pCtx;
	r.in.pResponseHandler = _pResponseHandler;

	status = dcerpc_CreateClassEnumAsync_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_PutInstance_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_PutInstance_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_PutInstance_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct PutInstance *r)
{
	struct tevent_req *req;
	struct dcerpc_PutInstance_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_PutInstance_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemServices,
			NDR_PUTINSTANCE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_PutInstance_r_done, req);

	return req;
}

static void dcerpc_PutInstance_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_PutInstance_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_PutInstance_r_state *state =
		tevent_req_data(req,
		struct dcerpc_PutInstance_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_PutInstance_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct PutInstance *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemServices,
			NDR_PUTINSTANCE, mem_ctx, r);

	return status;
}

struct dcerpc_PutInstance_state {
	struct PutInstance orig;
	struct PutInstance tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_PutInstance_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_PutInstance_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct dcerpc_binding_handle *h,
					   struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					   struct ORPCTHIS _ORPCthis /* [in]  */,
					   struct MInterfacePointer *_pInst /* [in] [ref] */,
					   int32_t _lFlags /* [in]  */,
					   struct MInterfacePointer *_pCtx /* [in] [ref] */,
					   struct MInterfacePointer **_ppCallResult /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_PutInstance_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_PutInstance_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.pInst = _pInst;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.ppCallResult = _ppCallResult;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppCallResult = _ppCallResult;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_PutInstance_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_PutInstance_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_PutInstance_done, req);
	return req;
}

static void dcerpc_PutInstance_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_PutInstance_state *state = tevent_req_data(
		req, struct dcerpc_PutInstance_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_PutInstance_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	if (state->orig.out.ppCallResult && state->tmp.out.ppCallResult) {
		*state->orig.out.ppCallResult = *state->tmp.out.ppCallResult;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_PutInstance_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 WERROR *result)
{
	struct dcerpc_PutInstance_state *state = tevent_req_data(
		req, struct dcerpc_PutInstance_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_PutInstance(struct dcerpc_binding_handle *h,
			    TALLOC_CTX *mem_ctx,
			    struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
			    struct ORPCTHIS _ORPCthis /* [in]  */,
			    struct MInterfacePointer *_pInst /* [in] [ref] */,
			    int32_t _lFlags /* [in]  */,
			    struct MInterfacePointer *_pCtx /* [in] [ref] */,
			    struct MInterfacePointer **_ppCallResult /* [in,out] [unique] */,
			    WERROR *result)
{
	struct PutInstance r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.pInst = _pInst;
	r.in.lFlags = _lFlags;
	r.in.pCtx = _pCtx;
	r.in.ppCallResult = _ppCallResult;

	status = dcerpc_PutInstance_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	if (_ppCallResult && r.out.ppCallResult) {
		*_ppCallResult = *r.out.ppCallResult;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_PutInstanceAsync_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_PutInstanceAsync_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_PutInstanceAsync_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct PutInstanceAsync *r)
{
	struct tevent_req *req;
	struct dcerpc_PutInstanceAsync_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_PutInstanceAsync_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemServices,
			NDR_PUTINSTANCEASYNC, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_PutInstanceAsync_r_done, req);

	return req;
}

static void dcerpc_PutInstanceAsync_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_PutInstanceAsync_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_PutInstanceAsync_r_state *state =
		tevent_req_data(req,
		struct dcerpc_PutInstanceAsync_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_PutInstanceAsync_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct PutInstanceAsync *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemServices,
			NDR_PUTINSTANCEASYNC, mem_ctx, r);

	return status;
}

struct dcerpc_PutInstanceAsync_state {
	struct PutInstanceAsync orig;
	struct PutInstanceAsync tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_PutInstanceAsync_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_PutInstanceAsync_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						struct ORPCTHIS _ORPCthis /* [in]  */,
						struct MInterfacePointer *_pInst /* [in] [ref] */,
						int32_t _lFlags /* [in]  */,
						struct MInterfacePointer *_pCtx /* [in] [ref] */,
						struct MInterfacePointer *_pResponseHandler /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_PutInstanceAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_PutInstanceAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.pInst = _pInst;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.pResponseHandler = _pResponseHandler;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_PutInstanceAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_PutInstanceAsync_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_PutInstanceAsync_done, req);
	return req;
}

static void dcerpc_PutInstanceAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_PutInstanceAsync_state *state = tevent_req_data(
		req, struct dcerpc_PutInstanceAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_PutInstanceAsync_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_PutInstanceAsync_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct dcerpc_PutInstanceAsync_state *state = tevent_req_data(
		req, struct dcerpc_PutInstanceAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_PutInstanceAsync(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS _ORPCthis /* [in]  */,
				 struct MInterfacePointer *_pInst /* [in] [ref] */,
				 int32_t _lFlags /* [in]  */,
				 struct MInterfacePointer *_pCtx /* [in] [ref] */,
				 struct MInterfacePointer *_pResponseHandler /* [in] [ref] */,
				 WERROR *result)
{
	struct PutInstanceAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.pInst = _pInst;
	r.in.lFlags = _lFlags;
	r.in.pCtx = _pCtx;
	r.in.pResponseHandler = _pResponseHandler;

	status = dcerpc_PutInstanceAsync_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_DeleteInstance_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DeleteInstance_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DeleteInstance_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct DeleteInstance *r)
{
	struct tevent_req *req;
	struct dcerpc_DeleteInstance_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DeleteInstance_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemServices,
			NDR_DELETEINSTANCE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DeleteInstance_r_done, req);

	return req;
}

static void dcerpc_DeleteInstance_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_DeleteInstance_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_DeleteInstance_r_state *state =
		tevent_req_data(req,
		struct dcerpc_DeleteInstance_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DeleteInstance_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct DeleteInstance *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemServices,
			NDR_DELETEINSTANCE, mem_ctx, r);

	return status;
}

struct dcerpc_DeleteInstance_state {
	struct DeleteInstance orig;
	struct DeleteInstance tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DeleteInstance_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DeleteInstance_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					      struct ORPCTHIS _ORPCthis /* [in]  */,
					      struct BSTR _strObjectPath /* [in]  */,
					      int32_t _lFlags /* [in]  */,
					      struct MInterfacePointer *_pCtx /* [in] [ref] */,
					      struct MInterfacePointer **_ppCallResult /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_DeleteInstance_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DeleteInstance_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strObjectPath = _strObjectPath;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.ppCallResult = _ppCallResult;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppCallResult = _ppCallResult;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_DeleteInstance_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_DeleteInstance_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DeleteInstance_done, req);
	return req;
}

static void dcerpc_DeleteInstance_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_DeleteInstance_state *state = tevent_req_data(
		req, struct dcerpc_DeleteInstance_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_DeleteInstance_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	if (state->orig.out.ppCallResult && state->tmp.out.ppCallResult) {
		*state->orig.out.ppCallResult = *state->tmp.out.ppCallResult;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_DeleteInstance_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result)
{
	struct dcerpc_DeleteInstance_state *state = tevent_req_data(
		req, struct dcerpc_DeleteInstance_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DeleteInstance(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS _ORPCthis /* [in]  */,
			       struct BSTR _strObjectPath /* [in]  */,
			       int32_t _lFlags /* [in]  */,
			       struct MInterfacePointer *_pCtx /* [in] [ref] */,
			       struct MInterfacePointer **_ppCallResult /* [in,out] [unique] */,
			       WERROR *result)
{
	struct DeleteInstance r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.strObjectPath = _strObjectPath;
	r.in.lFlags = _lFlags;
	r.in.pCtx = _pCtx;
	r.in.ppCallResult = _ppCallResult;

	status = dcerpc_DeleteInstance_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	if (_ppCallResult && r.out.ppCallResult) {
		*_ppCallResult = *r.out.ppCallResult;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_DeleteInstanceAsync_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DeleteInstanceAsync_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DeleteInstanceAsync_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct DeleteInstanceAsync *r)
{
	struct tevent_req *req;
	struct dcerpc_DeleteInstanceAsync_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DeleteInstanceAsync_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemServices,
			NDR_DELETEINSTANCEASYNC, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DeleteInstanceAsync_r_done, req);

	return req;
}

static void dcerpc_DeleteInstanceAsync_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_DeleteInstanceAsync_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_DeleteInstanceAsync_r_state *state =
		tevent_req_data(req,
		struct dcerpc_DeleteInstanceAsync_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DeleteInstanceAsync_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct DeleteInstanceAsync *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemServices,
			NDR_DELETEINSTANCEASYNC, mem_ctx, r);

	return status;
}

struct dcerpc_DeleteInstanceAsync_state {
	struct DeleteInstanceAsync orig;
	struct DeleteInstanceAsync tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DeleteInstanceAsync_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DeleteInstanceAsync_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						   struct ORPCTHIS _ORPCthis /* [in]  */,
						   struct BSTR _strObjectPath /* [in]  */,
						   int32_t _lFlags /* [in]  */,
						   struct MInterfacePointer *_pCtx /* [in] [ref] */,
						   struct MInterfacePointer *_pResponseHandler /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_DeleteInstanceAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DeleteInstanceAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strObjectPath = _strObjectPath;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.pResponseHandler = _pResponseHandler;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_DeleteInstanceAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_DeleteInstanceAsync_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DeleteInstanceAsync_done, req);
	return req;
}

static void dcerpc_DeleteInstanceAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_DeleteInstanceAsync_state *state = tevent_req_data(
		req, struct dcerpc_DeleteInstanceAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_DeleteInstanceAsync_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_DeleteInstanceAsync_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_DeleteInstanceAsync_state *state = tevent_req_data(
		req, struct dcerpc_DeleteInstanceAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DeleteInstanceAsync(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				    struct ORPCTHIS _ORPCthis /* [in]  */,
				    struct BSTR _strObjectPath /* [in]  */,
				    int32_t _lFlags /* [in]  */,
				    struct MInterfacePointer *_pCtx /* [in] [ref] */,
				    struct MInterfacePointer *_pResponseHandler /* [in] [ref] */,
				    WERROR *result)
{
	struct DeleteInstanceAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.strObjectPath = _strObjectPath;
	r.in.lFlags = _lFlags;
	r.in.pCtx = _pCtx;
	r.in.pResponseHandler = _pResponseHandler;

	status = dcerpc_DeleteInstanceAsync_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_CreateInstanceEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_CreateInstanceEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_CreateInstanceEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct CreateInstanceEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_CreateInstanceEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_CreateInstanceEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemServices,
			NDR_CREATEINSTANCEENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_CreateInstanceEnum_r_done, req);

	return req;
}

static void dcerpc_CreateInstanceEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_CreateInstanceEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_CreateInstanceEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_CreateInstanceEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_CreateInstanceEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct CreateInstanceEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemServices,
			NDR_CREATEINSTANCEENUM, mem_ctx, r);

	return status;
}

struct dcerpc_CreateInstanceEnum_state {
	struct CreateInstanceEnum orig;
	struct CreateInstanceEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_CreateInstanceEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_CreateInstanceEnum_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						  struct ORPCTHIS _ORPCthis /* [in]  */,
						  struct BSTR _strFilter /* [in]  */,
						  int32_t _lFlags /* [in]  */,
						  struct MInterfacePointer *_pCtx /* [in] [unique] */,
						  struct MInterfacePointer **_ppEnum /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_CreateInstanceEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_CreateInstanceEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strFilter = _strFilter;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppEnum = _ppEnum;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_CreateInstanceEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_CreateInstanceEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_CreateInstanceEnum_done, req);
	return req;
}

static void dcerpc_CreateInstanceEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_CreateInstanceEnum_state *state = tevent_req_data(
		req, struct dcerpc_CreateInstanceEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_CreateInstanceEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppEnum = *state->tmp.out.ppEnum;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_CreateInstanceEnum_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_CreateInstanceEnum_state *state = tevent_req_data(
		req, struct dcerpc_CreateInstanceEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_CreateInstanceEnum(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				   struct ORPCTHIS _ORPCthis /* [in]  */,
				   struct BSTR _strFilter /* [in]  */,
				   int32_t _lFlags /* [in]  */,
				   struct MInterfacePointer *_pCtx /* [in] [unique] */,
				   struct MInterfacePointer **_ppEnum /* [out] [ref] */,
				   WERROR *result)
{
	struct CreateInstanceEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.strFilter = _strFilter;
	r.in.lFlags = _lFlags;
	r.in.pCtx = _pCtx;

	status = dcerpc_CreateInstanceEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	*_ppEnum = *r.out.ppEnum;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_CreateInstanceEnumAsync_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_CreateInstanceEnumAsync_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_CreateInstanceEnumAsync_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct CreateInstanceEnumAsync *r)
{
	struct tevent_req *req;
	struct dcerpc_CreateInstanceEnumAsync_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_CreateInstanceEnumAsync_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemServices,
			NDR_CREATEINSTANCEENUMASYNC, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_CreateInstanceEnumAsync_r_done, req);

	return req;
}

static void dcerpc_CreateInstanceEnumAsync_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_CreateInstanceEnumAsync_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_CreateInstanceEnumAsync_r_state *state =
		tevent_req_data(req,
		struct dcerpc_CreateInstanceEnumAsync_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_CreateInstanceEnumAsync_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct CreateInstanceEnumAsync *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemServices,
			NDR_CREATEINSTANCEENUMASYNC, mem_ctx, r);

	return status;
}

struct dcerpc_CreateInstanceEnumAsync_state {
	struct CreateInstanceEnumAsync orig;
	struct CreateInstanceEnumAsync tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_CreateInstanceEnumAsync_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_CreateInstanceEnumAsync_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						       struct ORPCTHIS _ORPCthis /* [in]  */,
						       struct BSTR _strSuperClass /* [in]  */,
						       int32_t _lFlags /* [in]  */,
						       struct MInterfacePointer *_pCtx /* [in] [ref] */,
						       struct MInterfacePointer *_pResponseHandler /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_CreateInstanceEnumAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_CreateInstanceEnumAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strSuperClass = _strSuperClass;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.pResponseHandler = _pResponseHandler;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_CreateInstanceEnumAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_CreateInstanceEnumAsync_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_CreateInstanceEnumAsync_done, req);
	return req;
}

static void dcerpc_CreateInstanceEnumAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_CreateInstanceEnumAsync_state *state = tevent_req_data(
		req, struct dcerpc_CreateInstanceEnumAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_CreateInstanceEnumAsync_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_CreateInstanceEnumAsync_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_CreateInstanceEnumAsync_state *state = tevent_req_data(
		req, struct dcerpc_CreateInstanceEnumAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_CreateInstanceEnumAsync(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					struct ORPCTHIS _ORPCthis /* [in]  */,
					struct BSTR _strSuperClass /* [in]  */,
					int32_t _lFlags /* [in]  */,
					struct MInterfacePointer *_pCtx /* [in] [ref] */,
					struct MInterfacePointer *_pResponseHandler /* [in] [ref] */,
					WERROR *result)
{
	struct CreateInstanceEnumAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.strSuperClass = _strSuperClass;
	r.in.lFlags = _lFlags;
	r.in.pCtx = _pCtx;
	r.in.pResponseHandler = _pResponseHandler;

	status = dcerpc_CreateInstanceEnumAsync_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_ExecQuery_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_ExecQuery_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_ExecQuery_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct ExecQuery *r)
{
	struct tevent_req *req;
	struct dcerpc_ExecQuery_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_ExecQuery_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemServices,
			NDR_EXECQUERY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_ExecQuery_r_done, req);

	return req;
}

static void dcerpc_ExecQuery_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_ExecQuery_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_ExecQuery_r_state *state =
		tevent_req_data(req,
		struct dcerpc_ExecQuery_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_ExecQuery_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct ExecQuery *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemServices,
			NDR_EXECQUERY, mem_ctx, r);

	return status;
}

struct dcerpc_ExecQuery_state {
	struct ExecQuery orig;
	struct ExecQuery tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_ExecQuery_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_ExecQuery_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct dcerpc_binding_handle *h,
					 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					 struct ORPCTHIS _ORPCthis /* [in]  */,
					 struct BSTR _strQueryLanguage /* [in]  */,
					 struct BSTR _strQuery /* [in]  */,
					 int32_t _lFlags /* [in]  */,
					 struct MInterfacePointer *_pCtx /* [in] [unique] */,
					 struct MInterfacePointer **_ppEnum /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_ExecQuery_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_ExecQuery_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strQueryLanguage = _strQueryLanguage;
	state->orig.in.strQuery = _strQuery;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppEnum = _ppEnum;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_ExecQuery_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_ExecQuery_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_ExecQuery_done, req);
	return req;
}

static void dcerpc_ExecQuery_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_ExecQuery_state *state = tevent_req_data(
		req, struct dcerpc_ExecQuery_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_ExecQuery_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppEnum = *state->tmp.out.ppEnum;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_ExecQuery_recv(struct tevent_req *req,
			       TALLOC_CTX *mem_ctx,
			       WERROR *result)
{
	struct dcerpc_ExecQuery_state *state = tevent_req_data(
		req, struct dcerpc_ExecQuery_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_ExecQuery(struct dcerpc_binding_handle *h,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS _ORPCthis /* [in]  */,
			  struct BSTR _strQueryLanguage /* [in]  */,
			  struct BSTR _strQuery /* [in]  */,
			  int32_t _lFlags /* [in]  */,
			  struct MInterfacePointer *_pCtx /* [in] [unique] */,
			  struct MInterfacePointer **_ppEnum /* [out] [ref] */,
			  WERROR *result)
{
	struct ExecQuery r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.strQueryLanguage = _strQueryLanguage;
	r.in.strQuery = _strQuery;
	r.in.lFlags = _lFlags;
	r.in.pCtx = _pCtx;

	status = dcerpc_ExecQuery_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	*_ppEnum = *r.out.ppEnum;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_ExecQueryAsync_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_ExecQueryAsync_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_ExecQueryAsync_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct ExecQueryAsync *r)
{
	struct tevent_req *req;
	struct dcerpc_ExecQueryAsync_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_ExecQueryAsync_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemServices,
			NDR_EXECQUERYASYNC, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_ExecQueryAsync_r_done, req);

	return req;
}

static void dcerpc_ExecQueryAsync_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_ExecQueryAsync_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_ExecQueryAsync_r_state *state =
		tevent_req_data(req,
		struct dcerpc_ExecQueryAsync_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_ExecQueryAsync_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct ExecQueryAsync *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemServices,
			NDR_EXECQUERYASYNC, mem_ctx, r);

	return status;
}

struct dcerpc_ExecQueryAsync_state {
	struct ExecQueryAsync orig;
	struct ExecQueryAsync tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_ExecQueryAsync_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_ExecQueryAsync_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					      struct ORPCTHIS _ORPCthis /* [in]  */,
					      struct BSTR _strQueryLanguage /* [in]  */,
					      struct BSTR _strQuery /* [in]  */,
					      int32_t _lFlags /* [in]  */,
					      struct MInterfacePointer *_pCtx /* [in] [ref] */,
					      struct MInterfacePointer *_pResponseHandler /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_ExecQueryAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_ExecQueryAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strQueryLanguage = _strQueryLanguage;
	state->orig.in.strQuery = _strQuery;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.pResponseHandler = _pResponseHandler;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_ExecQueryAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_ExecQueryAsync_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_ExecQueryAsync_done, req);
	return req;
}

static void dcerpc_ExecQueryAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_ExecQueryAsync_state *state = tevent_req_data(
		req, struct dcerpc_ExecQueryAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_ExecQueryAsync_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_ExecQueryAsync_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result)
{
	struct dcerpc_ExecQueryAsync_state *state = tevent_req_data(
		req, struct dcerpc_ExecQueryAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_ExecQueryAsync(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS _ORPCthis /* [in]  */,
			       struct BSTR _strQueryLanguage /* [in]  */,
			       struct BSTR _strQuery /* [in]  */,
			       int32_t _lFlags /* [in]  */,
			       struct MInterfacePointer *_pCtx /* [in] [ref] */,
			       struct MInterfacePointer *_pResponseHandler /* [in] [ref] */,
			       WERROR *result)
{
	struct ExecQueryAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.strQueryLanguage = _strQueryLanguage;
	r.in.strQuery = _strQuery;
	r.in.lFlags = _lFlags;
	r.in.pCtx = _pCtx;
	r.in.pResponseHandler = _pResponseHandler;

	status = dcerpc_ExecQueryAsync_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_ExecNotificationQuery_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_ExecNotificationQuery_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_ExecNotificationQuery_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct ExecNotificationQuery *r)
{
	struct tevent_req *req;
	struct dcerpc_ExecNotificationQuery_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_ExecNotificationQuery_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemServices,
			NDR_EXECNOTIFICATIONQUERY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_ExecNotificationQuery_r_done, req);

	return req;
}

static void dcerpc_ExecNotificationQuery_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_ExecNotificationQuery_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_ExecNotificationQuery_r_state *state =
		tevent_req_data(req,
		struct dcerpc_ExecNotificationQuery_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_ExecNotificationQuery_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct ExecNotificationQuery *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemServices,
			NDR_EXECNOTIFICATIONQUERY, mem_ctx, r);

	return status;
}

struct dcerpc_ExecNotificationQuery_state {
	struct ExecNotificationQuery orig;
	struct ExecNotificationQuery tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_ExecNotificationQuery_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_ExecNotificationQuery_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						     struct ORPCTHIS _ORPCthis /* [in]  */,
						     struct BSTR _strQueryLanguage /* [in]  */,
						     struct BSTR _strQuery /* [in]  */,
						     int32_t _lFlags /* [in]  */,
						     struct MInterfacePointer *_pCtx /* [in] [unique] */,
						     struct MInterfacePointer **_ppEnum /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_ExecNotificationQuery_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_ExecNotificationQuery_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strQueryLanguage = _strQueryLanguage;
	state->orig.in.strQuery = _strQuery;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppEnum = _ppEnum;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_ExecNotificationQuery_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_ExecNotificationQuery_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_ExecNotificationQuery_done, req);
	return req;
}

static void dcerpc_ExecNotificationQuery_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_ExecNotificationQuery_state *state = tevent_req_data(
		req, struct dcerpc_ExecNotificationQuery_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_ExecNotificationQuery_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppEnum = *state->tmp.out.ppEnum;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_ExecNotificationQuery_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_ExecNotificationQuery_state *state = tevent_req_data(
		req, struct dcerpc_ExecNotificationQuery_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_ExecNotificationQuery(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				      struct ORPCTHIS _ORPCthis /* [in]  */,
				      struct BSTR _strQueryLanguage /* [in]  */,
				      struct BSTR _strQuery /* [in]  */,
				      int32_t _lFlags /* [in]  */,
				      struct MInterfacePointer *_pCtx /* [in] [unique] */,
				      struct MInterfacePointer **_ppEnum /* [out] [ref] */,
				      WERROR *result)
{
	struct ExecNotificationQuery r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.strQueryLanguage = _strQueryLanguage;
	r.in.strQuery = _strQuery;
	r.in.lFlags = _lFlags;
	r.in.pCtx = _pCtx;

	status = dcerpc_ExecNotificationQuery_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	*_ppEnum = *r.out.ppEnum;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_ExecNotificationQueryAsync_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_ExecNotificationQueryAsync_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_ExecNotificationQueryAsync_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct ExecNotificationQueryAsync *r)
{
	struct tevent_req *req;
	struct dcerpc_ExecNotificationQueryAsync_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_ExecNotificationQueryAsync_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemServices,
			NDR_EXECNOTIFICATIONQUERYASYNC, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_ExecNotificationQueryAsync_r_done, req);

	return req;
}

static void dcerpc_ExecNotificationQueryAsync_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_ExecNotificationQueryAsync_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_ExecNotificationQueryAsync_r_state *state =
		tevent_req_data(req,
		struct dcerpc_ExecNotificationQueryAsync_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_ExecNotificationQueryAsync_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct ExecNotificationQueryAsync *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemServices,
			NDR_EXECNOTIFICATIONQUERYASYNC, mem_ctx, r);

	return status;
}

struct dcerpc_ExecNotificationQueryAsync_state {
	struct ExecNotificationQueryAsync orig;
	struct ExecNotificationQueryAsync tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_ExecNotificationQueryAsync_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_ExecNotificationQueryAsync_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
							  struct ORPCTHIS _ORPCthis /* [in]  */,
							  struct BSTR _strQueryLanguage /* [in]  */,
							  struct BSTR _strQuery /* [in]  */,
							  int32_t _lFlags /* [in]  */,
							  struct MInterfacePointer *_pCtx /* [in] [ref] */,
							  struct MInterfacePointer *_pResponseHandler /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_ExecNotificationQueryAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_ExecNotificationQueryAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strQueryLanguage = _strQueryLanguage;
	state->orig.in.strQuery = _strQuery;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.pResponseHandler = _pResponseHandler;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_ExecNotificationQueryAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_ExecNotificationQueryAsync_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_ExecNotificationQueryAsync_done, req);
	return req;
}

static void dcerpc_ExecNotificationQueryAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_ExecNotificationQueryAsync_state *state = tevent_req_data(
		req, struct dcerpc_ExecNotificationQueryAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_ExecNotificationQueryAsync_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_ExecNotificationQueryAsync_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_ExecNotificationQueryAsync_state *state = tevent_req_data(
		req, struct dcerpc_ExecNotificationQueryAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_ExecNotificationQueryAsync(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					   struct ORPCTHIS _ORPCthis /* [in]  */,
					   struct BSTR _strQueryLanguage /* [in]  */,
					   struct BSTR _strQuery /* [in]  */,
					   int32_t _lFlags /* [in]  */,
					   struct MInterfacePointer *_pCtx /* [in] [ref] */,
					   struct MInterfacePointer *_pResponseHandler /* [in] [ref] */,
					   WERROR *result)
{
	struct ExecNotificationQueryAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.strQueryLanguage = _strQueryLanguage;
	r.in.strQuery = _strQuery;
	r.in.lFlags = _lFlags;
	r.in.pCtx = _pCtx;
	r.in.pResponseHandler = _pResponseHandler;

	status = dcerpc_ExecNotificationQueryAsync_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_ExecMethod_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_ExecMethod_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_ExecMethod_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct ExecMethod *r)
{
	struct tevent_req *req;
	struct dcerpc_ExecMethod_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_ExecMethod_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemServices,
			NDR_EXECMETHOD, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_ExecMethod_r_done, req);

	return req;
}

static void dcerpc_ExecMethod_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_ExecMethod_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_ExecMethod_r_state *state =
		tevent_req_data(req,
		struct dcerpc_ExecMethod_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_ExecMethod_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct ExecMethod *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemServices,
			NDR_EXECMETHOD, mem_ctx, r);

	return status;
}

struct dcerpc_ExecMethod_state {
	struct ExecMethod orig;
	struct ExecMethod tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_ExecMethod_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_ExecMethod_send(TALLOC_CTX *mem_ctx,
					  struct tevent_context *ev,
					  struct dcerpc_binding_handle *h,
					  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					  struct ORPCTHIS _ORPCthis /* [in]  */,
					  struct BSTR _strObjectPath /* [in]  */,
					  struct BSTR _strMethodName /* [in]  */,
					  int32_t _lFlags /* [in]  */,
					  struct MInterfacePointer *_pCtx /* [in] [unique] */,
					  struct MInterfacePointer *_pInParams /* [in] [unique] */,
					  struct MInterfacePointer **_ppOutParams /* [in,out] [unique] */,
					  struct MInterfacePointer **_ppCallResult /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_ExecMethod_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_ExecMethod_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strObjectPath = _strObjectPath;
	state->orig.in.strMethodName = _strMethodName;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.pInParams = _pInParams;
	state->orig.in.ppOutParams = _ppOutParams;
	state->orig.in.ppCallResult = _ppCallResult;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppOutParams = _ppOutParams;
	state->orig.out.ppCallResult = _ppCallResult;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_ExecMethod_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_ExecMethod_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_ExecMethod_done, req);
	return req;
}

static void dcerpc_ExecMethod_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_ExecMethod_state *state = tevent_req_data(
		req, struct dcerpc_ExecMethod_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_ExecMethod_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	if (state->orig.out.ppOutParams && state->tmp.out.ppOutParams) {
		*state->orig.out.ppOutParams = *state->tmp.out.ppOutParams;
	}
	if (state->orig.out.ppCallResult && state->tmp.out.ppCallResult) {
		*state->orig.out.ppCallResult = *state->tmp.out.ppCallResult;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_ExecMethod_recv(struct tevent_req *req,
				TALLOC_CTX *mem_ctx,
				WERROR *result)
{
	struct dcerpc_ExecMethod_state *state = tevent_req_data(
		req, struct dcerpc_ExecMethod_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_ExecMethod(struct dcerpc_binding_handle *h,
			   TALLOC_CTX *mem_ctx,
			   struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
			   struct ORPCTHIS _ORPCthis /* [in]  */,
			   struct BSTR _strObjectPath /* [in]  */,
			   struct BSTR _strMethodName /* [in]  */,
			   int32_t _lFlags /* [in]  */,
			   struct MInterfacePointer *_pCtx /* [in] [unique] */,
			   struct MInterfacePointer *_pInParams /* [in] [unique] */,
			   struct MInterfacePointer **_ppOutParams /* [in,out] [unique] */,
			   struct MInterfacePointer **_ppCallResult /* [in,out] [unique] */,
			   WERROR *result)
{
	struct ExecMethod r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.strObjectPath = _strObjectPath;
	r.in.strMethodName = _strMethodName;
	r.in.lFlags = _lFlags;
	r.in.pCtx = _pCtx;
	r.in.pInParams = _pInParams;
	r.in.ppOutParams = _ppOutParams;
	r.in.ppCallResult = _ppCallResult;

	status = dcerpc_ExecMethod_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	if (_ppOutParams && r.out.ppOutParams) {
		*_ppOutParams = *r.out.ppOutParams;
	}
	if (_ppCallResult && r.out.ppCallResult) {
		*_ppCallResult = *r.out.ppCallResult;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_ExecMethodAsync_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_ExecMethodAsync_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_ExecMethodAsync_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct ExecMethodAsync *r)
{
	struct tevent_req *req;
	struct dcerpc_ExecMethodAsync_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_ExecMethodAsync_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemServices,
			NDR_EXECMETHODASYNC, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_ExecMethodAsync_r_done, req);

	return req;
}

static void dcerpc_ExecMethodAsync_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_ExecMethodAsync_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_ExecMethodAsync_r_state *state =
		tevent_req_data(req,
		struct dcerpc_ExecMethodAsync_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_ExecMethodAsync_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct ExecMethodAsync *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemServices,
			NDR_EXECMETHODASYNC, mem_ctx, r);

	return status;
}

struct dcerpc_ExecMethodAsync_state {
	struct ExecMethodAsync orig;
	struct ExecMethodAsync tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_ExecMethodAsync_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_ExecMethodAsync_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					       struct ORPCTHIS _ORPCthis /* [in]  */,
					       struct BSTR _strObjectPath /* [in]  */,
					       struct BSTR _strMethodName /* [in]  */,
					       uint32_t _lFlags /* [in]  */,
					       struct MInterfacePointer *_pCtx /* [in] [ref] */,
					       struct MInterfacePointer *_pInParams /* [in] [ref] */,
					       struct MInterfacePointer *_pResponseHandler /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_ExecMethodAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_ExecMethodAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.strObjectPath = _strObjectPath;
	state->orig.in.strMethodName = _strMethodName;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;
	state->orig.in.pInParams = _pInParams;
	state->orig.in.pResponseHandler = _pResponseHandler;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_ExecMethodAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_ExecMethodAsync_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_ExecMethodAsync_done, req);
	return req;
}

static void dcerpc_ExecMethodAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_ExecMethodAsync_state *state = tevent_req_data(
		req, struct dcerpc_ExecMethodAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_ExecMethodAsync_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_ExecMethodAsync_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_ExecMethodAsync_state *state = tevent_req_data(
		req, struct dcerpc_ExecMethodAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_ExecMethodAsync(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				struct ORPCTHIS _ORPCthis /* [in]  */,
				struct BSTR _strObjectPath /* [in]  */,
				struct BSTR _strMethodName /* [in]  */,
				uint32_t _lFlags /* [in]  */,
				struct MInterfacePointer *_pCtx /* [in] [ref] */,
				struct MInterfacePointer *_pInParams /* [in] [ref] */,
				struct MInterfacePointer *_pResponseHandler /* [in] [ref] */,
				WERROR *result)
{
	struct ExecMethodAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.strObjectPath = _strObjectPath;
	r.in.strMethodName = _strMethodName;
	r.in.lFlags = _lFlags;
	r.in.pCtx = _pCtx;
	r.in.pInParams = _pInParams;
	r.in.pResponseHandler = _pResponseHandler;

	status = dcerpc_ExecMethodAsync_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

/* IEnumWbemClassObject - client functions generated by pidl */

struct dcerpc_Reset_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Reset_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Reset_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Reset *r)
{
	struct tevent_req *req;
	struct dcerpc_Reset_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Reset_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IEnumWbemClassObject,
			NDR_RESET, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Reset_r_done, req);

	return req;
}

static void dcerpc_Reset_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Reset_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Reset_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Reset_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Reset_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Reset *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IEnumWbemClassObject,
			NDR_RESET, mem_ctx, r);

	return status;
}

struct dcerpc_Reset_state {
	struct Reset orig;
	struct Reset tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Reset_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Reset_send(TALLOC_CTX *mem_ctx,
				     struct tevent_context *ev,
				     struct dcerpc_binding_handle *h,
				     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				     struct ORPCTHIS _ORPCthis /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_Reset_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Reset_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_Reset_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Reset_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Reset_done, req);
	return req;
}

static void dcerpc_Reset_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Reset_state *state = tevent_req_data(
		req, struct dcerpc_Reset_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Reset_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Reset_recv(struct tevent_req *req,
			   TALLOC_CTX *mem_ctx,
			   WERROR *result)
{
	struct dcerpc_Reset_state *state = tevent_req_data(
		req, struct dcerpc_Reset_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Reset(struct dcerpc_binding_handle *h,
		      TALLOC_CTX *mem_ctx,
		      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
		      struct ORPCTHIS _ORPCthis /* [in]  */,
		      WERROR *result)
{
	struct Reset r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;

	status = dcerpc_Reset_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_IEnumWbemClassObject_Next_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_IEnumWbemClassObject_Next_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_IEnumWbemClassObject_Next_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct IEnumWbemClassObject_Next *r)
{
	struct tevent_req *req;
	struct dcerpc_IEnumWbemClassObject_Next_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_IEnumWbemClassObject_Next_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IEnumWbemClassObject,
			NDR_IENUMWBEMCLASSOBJECT_NEXT, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_IEnumWbemClassObject_Next_r_done, req);

	return req;
}

static void dcerpc_IEnumWbemClassObject_Next_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_IEnumWbemClassObject_Next_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_IEnumWbemClassObject_Next_r_state *state =
		tevent_req_data(req,
		struct dcerpc_IEnumWbemClassObject_Next_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_IEnumWbemClassObject_Next_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct IEnumWbemClassObject_Next *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IEnumWbemClassObject,
			NDR_IENUMWBEMCLASSOBJECT_NEXT, mem_ctx, r);

	return status;
}

struct dcerpc_IEnumWbemClassObject_Next_state {
	struct IEnumWbemClassObject_Next orig;
	struct IEnumWbemClassObject_Next tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_IEnumWbemClassObject_Next_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_IEnumWbemClassObject_Next_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
							 struct ORPCTHIS _ORPCthis /* [in]  */,
							 int32_t _lTimeout /* [in]  */,
							 uint32_t _uCount /* [in]  */,
							 struct MInterfacePointer **_apObjects /* [out] [ref,length_is(*puReturned),size_is(uCount)] */,
							 uint32_t *_puReturned /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_IEnumWbemClassObject_Next_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_IEnumWbemClassObject_Next_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.lTimeout = _lTimeout;
	state->orig.in.uCount = _uCount;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.apObjects = _apObjects;
	state->orig.out.puReturned = _puReturned;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_IEnumWbemClassObject_Next_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_IEnumWbemClassObject_Next_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_IEnumWbemClassObject_Next_done, req);
	return req;
}

static void dcerpc_IEnumWbemClassObject_Next_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_IEnumWbemClassObject_Next_state *state = tevent_req_data(
		req, struct dcerpc_IEnumWbemClassObject_Next_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_IEnumWbemClassObject_Next_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	{
		size_t _copy_len_apObjects;
		if ((*state->tmp.out.puReturned) > (state->tmp.in.uCount)) {
			tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
			return;
		}
		_copy_len_apObjects = *state->tmp.out.puReturned;
		memcpy(state->orig.out.apObjects, state->tmp.out.apObjects, _copy_len_apObjects * sizeof(*state->orig.out.apObjects));
	}
	*state->orig.out.puReturned = *state->tmp.out.puReturned;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_IEnumWbemClassObject_Next_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_IEnumWbemClassObject_Next_state *state = tevent_req_data(
		req, struct dcerpc_IEnumWbemClassObject_Next_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_IEnumWbemClassObject_Next(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					  struct ORPCTHIS _ORPCthis /* [in]  */,
					  int32_t _lTimeout /* [in]  */,
					  uint32_t _uCount /* [in]  */,
					  struct MInterfacePointer **_apObjects /* [out] [ref,length_is(*puReturned),size_is(uCount)] */,
					  uint32_t *_puReturned /* [out] [ref] */,
					  WERROR *result)
{
	struct IEnumWbemClassObject_Next r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.lTimeout = _lTimeout;
	r.in.uCount = _uCount;

	status = dcerpc_IEnumWbemClassObject_Next_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	{
		size_t _copy_len_apObjects;
		if ((*r.out.puReturned) > (r.in.uCount)) {
			return NT_STATUS_INVALID_NETWORK_RESPONSE;
		}
		_copy_len_apObjects = *r.out.puReturned;
		memcpy(_apObjects, r.out.apObjects, _copy_len_apObjects * sizeof(*_apObjects));
	}
	*_puReturned = *r.out.puReturned;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NextAsync_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NextAsync_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NextAsync_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NextAsync *r)
{
	struct tevent_req *req;
	struct dcerpc_NextAsync_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NextAsync_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IEnumWbemClassObject,
			NDR_NEXTASYNC, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NextAsync_r_done, req);

	return req;
}

static void dcerpc_NextAsync_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NextAsync_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NextAsync_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NextAsync_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NextAsync_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NextAsync *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IEnumWbemClassObject,
			NDR_NEXTASYNC, mem_ctx, r);

	return status;
}

struct dcerpc_NextAsync_state {
	struct NextAsync orig;
	struct NextAsync tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NextAsync_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NextAsync_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct dcerpc_binding_handle *h,
					 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					 struct ORPCTHIS _ORPCthis /* [in]  */,
					 uint32_t _uCount /* [in]  */,
					 struct MInterfacePointer *_pSink /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NextAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NextAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.uCount = _uCount;
	state->orig.in.pSink = _pSink;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NextAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NextAsync_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NextAsync_done, req);
	return req;
}

static void dcerpc_NextAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NextAsync_state *state = tevent_req_data(
		req, struct dcerpc_NextAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NextAsync_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NextAsync_recv(struct tevent_req *req,
			       TALLOC_CTX *mem_ctx,
			       WERROR *result)
{
	struct dcerpc_NextAsync_state *state = tevent_req_data(
		req, struct dcerpc_NextAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NextAsync(struct dcerpc_binding_handle *h,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS _ORPCthis /* [in]  */,
			  uint32_t _uCount /* [in]  */,
			  struct MInterfacePointer *_pSink /* [in] [ref] */,
			  WERROR *result)
{
	struct NextAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.uCount = _uCount;
	r.in.pSink = _pSink;

	status = dcerpc_NextAsync_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_IEnumWbemClassObject_Clone_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_IEnumWbemClassObject_Clone_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_IEnumWbemClassObject_Clone_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct IEnumWbemClassObject_Clone *r)
{
	struct tevent_req *req;
	struct dcerpc_IEnumWbemClassObject_Clone_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_IEnumWbemClassObject_Clone_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IEnumWbemClassObject,
			NDR_IENUMWBEMCLASSOBJECT_CLONE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_IEnumWbemClassObject_Clone_r_done, req);

	return req;
}

static void dcerpc_IEnumWbemClassObject_Clone_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_IEnumWbemClassObject_Clone_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_IEnumWbemClassObject_Clone_r_state *state =
		tevent_req_data(req,
		struct dcerpc_IEnumWbemClassObject_Clone_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_IEnumWbemClassObject_Clone_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct IEnumWbemClassObject_Clone *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IEnumWbemClassObject,
			NDR_IENUMWBEMCLASSOBJECT_CLONE, mem_ctx, r);

	return status;
}

struct dcerpc_IEnumWbemClassObject_Clone_state {
	struct IEnumWbemClassObject_Clone orig;
	struct IEnumWbemClassObject_Clone tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_IEnumWbemClassObject_Clone_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_IEnumWbemClassObject_Clone_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
							  struct ORPCTHIS _ORPCthis /* [in]  */,
							  struct MInterfacePointer **_ppEnum /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_IEnumWbemClassObject_Clone_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_IEnumWbemClassObject_Clone_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppEnum = _ppEnum;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_IEnumWbemClassObject_Clone_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_IEnumWbemClassObject_Clone_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_IEnumWbemClassObject_Clone_done, req);
	return req;
}

static void dcerpc_IEnumWbemClassObject_Clone_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_IEnumWbemClassObject_Clone_state *state = tevent_req_data(
		req, struct dcerpc_IEnumWbemClassObject_Clone_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_IEnumWbemClassObject_Clone_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppEnum = *state->tmp.out.ppEnum;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_IEnumWbemClassObject_Clone_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_IEnumWbemClassObject_Clone_state *state = tevent_req_data(
		req, struct dcerpc_IEnumWbemClassObject_Clone_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_IEnumWbemClassObject_Clone(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					   struct ORPCTHIS _ORPCthis /* [in]  */,
					   struct MInterfacePointer **_ppEnum /* [out] [ref] */,
					   WERROR *result)
{
	struct IEnumWbemClassObject_Clone r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;

	status = dcerpc_IEnumWbemClassObject_Clone_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	*_ppEnum = *r.out.ppEnum;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_Skip_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Skip_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Skip_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Skip *r)
{
	struct tevent_req *req;
	struct dcerpc_Skip_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Skip_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IEnumWbemClassObject,
			NDR_SKIP, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Skip_r_done, req);

	return req;
}

static void dcerpc_Skip_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Skip_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Skip_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Skip_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Skip_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Skip *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IEnumWbemClassObject,
			NDR_SKIP, mem_ctx, r);

	return status;
}

struct dcerpc_Skip_state {
	struct Skip orig;
	struct Skip tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Skip_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Skip_send(TALLOC_CTX *mem_ctx,
				    struct tevent_context *ev,
				    struct dcerpc_binding_handle *h,
				    struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				    struct ORPCTHIS _ORPCthis /* [in]  */,
				    int32_t _lTimeout /* [in]  */,
				    uint32_t _nCount /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_Skip_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Skip_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.lTimeout = _lTimeout;
	state->orig.in.nCount = _nCount;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_Skip_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Skip_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Skip_done, req);
	return req;
}

static void dcerpc_Skip_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Skip_state *state = tevent_req_data(
		req, struct dcerpc_Skip_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Skip_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Skip_recv(struct tevent_req *req,
			  TALLOC_CTX *mem_ctx,
			  WERROR *result)
{
	struct dcerpc_Skip_state *state = tevent_req_data(
		req, struct dcerpc_Skip_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Skip(struct dcerpc_binding_handle *h,
		     TALLOC_CTX *mem_ctx,
		     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
		     struct ORPCTHIS _ORPCthis /* [in]  */,
		     int32_t _lTimeout /* [in]  */,
		     uint32_t _nCount /* [in]  */,
		     WERROR *result)
{
	struct Skip r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.lTimeout = _lTimeout;
	r.in.nCount = _nCount;

	status = dcerpc_Skip_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

/* IWbemContext - client functions generated by pidl */

struct dcerpc_Clone_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Clone_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Clone_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Clone *r)
{
	struct tevent_req *req;
	struct dcerpc_Clone_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Clone_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemContext,
			NDR_CLONE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Clone_r_done, req);

	return req;
}

static void dcerpc_Clone_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Clone_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Clone_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Clone_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Clone_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Clone *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemContext,
			NDR_CLONE, mem_ctx, r);

	return status;
}

struct dcerpc_Clone_state {
	struct Clone orig;
	struct Clone tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Clone_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Clone_send(TALLOC_CTX *mem_ctx,
				     struct tevent_context *ev,
				     struct dcerpc_binding_handle *h,
				     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				     struct ORPCTHIS _ORPCthis /* [in]  */,
				     struct MInterfacePointer **_ppNewCopy /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_Clone_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Clone_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppNewCopy = _ppNewCopy;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_Clone_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Clone_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Clone_done, req);
	return req;
}

static void dcerpc_Clone_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Clone_state *state = tevent_req_data(
		req, struct dcerpc_Clone_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Clone_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppNewCopy = *state->tmp.out.ppNewCopy;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Clone_recv(struct tevent_req *req,
			   TALLOC_CTX *mem_ctx,
			   WERROR *result)
{
	struct dcerpc_Clone_state *state = tevent_req_data(
		req, struct dcerpc_Clone_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Clone(struct dcerpc_binding_handle *h,
		      TALLOC_CTX *mem_ctx,
		      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
		      struct ORPCTHIS _ORPCthis /* [in]  */,
		      struct MInterfacePointer **_ppNewCopy /* [out] [ref] */,
		      WERROR *result)
{
	struct Clone r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;

	status = dcerpc_Clone_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	*_ppNewCopy = *r.out.ppNewCopy;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_GetNames_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_GetNames_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_GetNames_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct GetNames *r)
{
	struct tevent_req *req;
	struct dcerpc_GetNames_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_GetNames_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemContext,
			NDR_GETNAMES, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_GetNames_r_done, req);

	return req;
}

static void dcerpc_GetNames_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_GetNames_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_GetNames_r_state *state =
		tevent_req_data(req,
		struct dcerpc_GetNames_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_GetNames_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct GetNames *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemContext,
			NDR_GETNAMES, mem_ctx, r);

	return status;
}

struct dcerpc_GetNames_state {
	struct GetNames orig;
	struct GetNames tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_GetNames_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_GetNames_send(TALLOC_CTX *mem_ctx,
					struct tevent_context *ev,
					struct dcerpc_binding_handle *h,
					struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					struct ORPCTHIS _ORPCthis /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_GetNames_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_GetNames_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_GetNames_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_GetNames_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_GetNames_done, req);
	return req;
}

static void dcerpc_GetNames_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_GetNames_state *state = tevent_req_data(
		req, struct dcerpc_GetNames_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_GetNames_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_GetNames_recv(struct tevent_req *req,
			      TALLOC_CTX *mem_ctx,
			      WERROR *result)
{
	struct dcerpc_GetNames_state *state = tevent_req_data(
		req, struct dcerpc_GetNames_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_GetNames(struct dcerpc_binding_handle *h,
			 TALLOC_CTX *mem_ctx,
			 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
			 struct ORPCTHIS _ORPCthis /* [in]  */,
			 WERROR *result)
{
	struct GetNames r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;

	status = dcerpc_GetNames_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_BeginEnumeration_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_BeginEnumeration_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_BeginEnumeration_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct BeginEnumeration *r)
{
	struct tevent_req *req;
	struct dcerpc_BeginEnumeration_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_BeginEnumeration_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemContext,
			NDR_BEGINENUMERATION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_BeginEnumeration_r_done, req);

	return req;
}

static void dcerpc_BeginEnumeration_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_BeginEnumeration_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_BeginEnumeration_r_state *state =
		tevent_req_data(req,
		struct dcerpc_BeginEnumeration_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_BeginEnumeration_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct BeginEnumeration *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemContext,
			NDR_BEGINENUMERATION, mem_ctx, r);

	return status;
}

struct dcerpc_BeginEnumeration_state {
	struct BeginEnumeration orig;
	struct BeginEnumeration tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_BeginEnumeration_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_BeginEnumeration_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						struct ORPCTHIS _ORPCthis /* [in]  */,
						int32_t _lFlags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_BeginEnumeration_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_BeginEnumeration_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.lFlags = _lFlags;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_BeginEnumeration_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_BeginEnumeration_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_BeginEnumeration_done, req);
	return req;
}

static void dcerpc_BeginEnumeration_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_BeginEnumeration_state *state = tevent_req_data(
		req, struct dcerpc_BeginEnumeration_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_BeginEnumeration_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_BeginEnumeration_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct dcerpc_BeginEnumeration_state *state = tevent_req_data(
		req, struct dcerpc_BeginEnumeration_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_BeginEnumeration(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS _ORPCthis /* [in]  */,
				 int32_t _lFlags /* [in]  */,
				 WERROR *result)
{
	struct BeginEnumeration r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.lFlags = _lFlags;

	status = dcerpc_BeginEnumeration_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_Next_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Next_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Next_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Next *r)
{
	struct tevent_req *req;
	struct dcerpc_Next_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Next_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemContext,
			NDR_NEXT, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Next_r_done, req);

	return req;
}

static void dcerpc_Next_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Next_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Next_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Next_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Next_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Next *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemContext,
			NDR_NEXT, mem_ctx, r);

	return status;
}

struct dcerpc_Next_state {
	struct Next orig;
	struct Next tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Next_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Next_send(TALLOC_CTX *mem_ctx,
				    struct tevent_context *ev,
				    struct dcerpc_binding_handle *h,
				    struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				    struct ORPCTHIS _ORPCthis /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_Next_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Next_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_Next_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Next_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Next_done, req);
	return req;
}

static void dcerpc_Next_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Next_state *state = tevent_req_data(
		req, struct dcerpc_Next_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Next_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Next_recv(struct tevent_req *req,
			  TALLOC_CTX *mem_ctx,
			  WERROR *result)
{
	struct dcerpc_Next_state *state = tevent_req_data(
		req, struct dcerpc_Next_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Next(struct dcerpc_binding_handle *h,
		     TALLOC_CTX *mem_ctx,
		     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
		     struct ORPCTHIS _ORPCthis /* [in]  */,
		     WERROR *result)
{
	struct Next r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;

	status = dcerpc_Next_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_EndEnumeration_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_EndEnumeration_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_EndEnumeration_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct EndEnumeration *r)
{
	struct tevent_req *req;
	struct dcerpc_EndEnumeration_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_EndEnumeration_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemContext,
			NDR_ENDENUMERATION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_EndEnumeration_r_done, req);

	return req;
}

static void dcerpc_EndEnumeration_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_EndEnumeration_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_EndEnumeration_r_state *state =
		tevent_req_data(req,
		struct dcerpc_EndEnumeration_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_EndEnumeration_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct EndEnumeration *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemContext,
			NDR_ENDENUMERATION, mem_ctx, r);

	return status;
}

struct dcerpc_EndEnumeration_state {
	struct EndEnumeration orig;
	struct EndEnumeration tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_EndEnumeration_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_EndEnumeration_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					      struct ORPCTHIS _ORPCthis /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_EndEnumeration_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_EndEnumeration_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_EndEnumeration_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_EndEnumeration_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_EndEnumeration_done, req);
	return req;
}

static void dcerpc_EndEnumeration_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_EndEnumeration_state *state = tevent_req_data(
		req, struct dcerpc_EndEnumeration_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_EndEnumeration_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_EndEnumeration_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result)
{
	struct dcerpc_EndEnumeration_state *state = tevent_req_data(
		req, struct dcerpc_EndEnumeration_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_EndEnumeration(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS _ORPCthis /* [in]  */,
			       WERROR *result)
{
	struct EndEnumeration r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;

	status = dcerpc_EndEnumeration_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_SetValue_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_SetValue_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_SetValue_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct SetValue *r)
{
	struct tevent_req *req;
	struct dcerpc_SetValue_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_SetValue_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemContext,
			NDR_SETVALUE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_SetValue_r_done, req);

	return req;
}

static void dcerpc_SetValue_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_SetValue_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_SetValue_r_state *state =
		tevent_req_data(req,
		struct dcerpc_SetValue_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_SetValue_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct SetValue *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemContext,
			NDR_SETVALUE, mem_ctx, r);

	return status;
}

struct dcerpc_SetValue_state {
	struct SetValue orig;
	struct SetValue tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_SetValue_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_SetValue_send(TALLOC_CTX *mem_ctx,
					struct tevent_context *ev,
					struct dcerpc_binding_handle *h,
					struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					struct ORPCTHIS _ORPCthis /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_SetValue_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_SetValue_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_SetValue_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_SetValue_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_SetValue_done, req);
	return req;
}

static void dcerpc_SetValue_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_SetValue_state *state = tevent_req_data(
		req, struct dcerpc_SetValue_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_SetValue_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_SetValue_recv(struct tevent_req *req,
			      TALLOC_CTX *mem_ctx,
			      WERROR *result)
{
	struct dcerpc_SetValue_state *state = tevent_req_data(
		req, struct dcerpc_SetValue_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_SetValue(struct dcerpc_binding_handle *h,
			 TALLOC_CTX *mem_ctx,
			 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
			 struct ORPCTHIS _ORPCthis /* [in]  */,
			 WERROR *result)
{
	struct SetValue r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;

	status = dcerpc_SetValue_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_GetValue_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_GetValue_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_GetValue_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct GetValue *r)
{
	struct tevent_req *req;
	struct dcerpc_GetValue_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_GetValue_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemContext,
			NDR_GETVALUE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_GetValue_r_done, req);

	return req;
}

static void dcerpc_GetValue_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_GetValue_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_GetValue_r_state *state =
		tevent_req_data(req,
		struct dcerpc_GetValue_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_GetValue_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct GetValue *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemContext,
			NDR_GETVALUE, mem_ctx, r);

	return status;
}

struct dcerpc_GetValue_state {
	struct GetValue orig;
	struct GetValue tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_GetValue_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_GetValue_send(TALLOC_CTX *mem_ctx,
					struct tevent_context *ev,
					struct dcerpc_binding_handle *h,
					struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					struct ORPCTHIS _ORPCthis /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_GetValue_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_GetValue_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_GetValue_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_GetValue_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_GetValue_done, req);
	return req;
}

static void dcerpc_GetValue_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_GetValue_state *state = tevent_req_data(
		req, struct dcerpc_GetValue_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_GetValue_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_GetValue_recv(struct tevent_req *req,
			      TALLOC_CTX *mem_ctx,
			      WERROR *result)
{
	struct dcerpc_GetValue_state *state = tevent_req_data(
		req, struct dcerpc_GetValue_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_GetValue(struct dcerpc_binding_handle *h,
			 TALLOC_CTX *mem_ctx,
			 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
			 struct ORPCTHIS _ORPCthis /* [in]  */,
			 WERROR *result)
{
	struct GetValue r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;

	status = dcerpc_GetValue_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_DeleteValue_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DeleteValue_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DeleteValue_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct DeleteValue *r)
{
	struct tevent_req *req;
	struct dcerpc_DeleteValue_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DeleteValue_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemContext,
			NDR_DELETEVALUE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DeleteValue_r_done, req);

	return req;
}

static void dcerpc_DeleteValue_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_DeleteValue_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_DeleteValue_r_state *state =
		tevent_req_data(req,
		struct dcerpc_DeleteValue_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DeleteValue_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct DeleteValue *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemContext,
			NDR_DELETEVALUE, mem_ctx, r);

	return status;
}

struct dcerpc_DeleteValue_state {
	struct DeleteValue orig;
	struct DeleteValue tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DeleteValue_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DeleteValue_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct dcerpc_binding_handle *h,
					   struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					   struct ORPCTHIS _ORPCthis /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_DeleteValue_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DeleteValue_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_DeleteValue_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_DeleteValue_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DeleteValue_done, req);
	return req;
}

static void dcerpc_DeleteValue_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_DeleteValue_state *state = tevent_req_data(
		req, struct dcerpc_DeleteValue_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_DeleteValue_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_DeleteValue_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 WERROR *result)
{
	struct dcerpc_DeleteValue_state *state = tevent_req_data(
		req, struct dcerpc_DeleteValue_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DeleteValue(struct dcerpc_binding_handle *h,
			    TALLOC_CTX *mem_ctx,
			    struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
			    struct ORPCTHIS _ORPCthis /* [in]  */,
			    WERROR *result)
{
	struct DeleteValue r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;

	status = dcerpc_DeleteValue_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_DeleteAll_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DeleteAll_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DeleteAll_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct DeleteAll *r)
{
	struct tevent_req *req;
	struct dcerpc_DeleteAll_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DeleteAll_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemContext,
			NDR_DELETEALL, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DeleteAll_r_done, req);

	return req;
}

static void dcerpc_DeleteAll_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_DeleteAll_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_DeleteAll_r_state *state =
		tevent_req_data(req,
		struct dcerpc_DeleteAll_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DeleteAll_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct DeleteAll *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemContext,
			NDR_DELETEALL, mem_ctx, r);

	return status;
}

struct dcerpc_DeleteAll_state {
	struct DeleteAll orig;
	struct DeleteAll tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DeleteAll_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DeleteAll_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct dcerpc_binding_handle *h,
					 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					 struct ORPCTHIS _ORPCthis /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_DeleteAll_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DeleteAll_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_DeleteAll_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_DeleteAll_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DeleteAll_done, req);
	return req;
}

static void dcerpc_DeleteAll_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_DeleteAll_state *state = tevent_req_data(
		req, struct dcerpc_DeleteAll_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_DeleteAll_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_DeleteAll_recv(struct tevent_req *req,
			       TALLOC_CTX *mem_ctx,
			       WERROR *result)
{
	struct dcerpc_DeleteAll_state *state = tevent_req_data(
		req, struct dcerpc_DeleteAll_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DeleteAll(struct dcerpc_binding_handle *h,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS _ORPCthis /* [in]  */,
			  WERROR *result)
{
	struct DeleteAll r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;

	status = dcerpc_DeleteAll_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

/* IWbemLevel1Login - client functions generated by pidl */

struct dcerpc_EstablishPosition_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_EstablishPosition_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_EstablishPosition_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct EstablishPosition *r)
{
	struct tevent_req *req;
	struct dcerpc_EstablishPosition_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_EstablishPosition_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemLevel1Login,
			NDR_ESTABLISHPOSITION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_EstablishPosition_r_done, req);

	return req;
}

static void dcerpc_EstablishPosition_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_EstablishPosition_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_EstablishPosition_r_state *state =
		tevent_req_data(req,
		struct dcerpc_EstablishPosition_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_EstablishPosition_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct EstablishPosition *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemLevel1Login,
			NDR_ESTABLISHPOSITION, mem_ctx, r);

	return status;
}

struct dcerpc_EstablishPosition_state {
	struct EstablishPosition orig;
	struct EstablishPosition tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_EstablishPosition_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_EstablishPosition_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						 struct ORPCTHIS _ORPCthis /* [in]  */,
						 const char *_wszLocaleList /* [in] [unique,charset(UTF16)] */,
						 uint32_t _dwNumLocales /* [in]  */,
						 uint32_t *_reserved /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_EstablishPosition_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_EstablishPosition_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.wszLocaleList = _wszLocaleList;
	state->orig.in.dwNumLocales = _dwNumLocales;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.reserved = _reserved;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_EstablishPosition_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_EstablishPosition_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_EstablishPosition_done, req);
	return req;
}

static void dcerpc_EstablishPosition_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_EstablishPosition_state *state = tevent_req_data(
		req, struct dcerpc_EstablishPosition_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_EstablishPosition_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.reserved = *state->tmp.out.reserved;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_EstablishPosition_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_EstablishPosition_state *state = tevent_req_data(
		req, struct dcerpc_EstablishPosition_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_EstablishPosition(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				  struct ORPCTHIS _ORPCthis /* [in]  */,
				  const char *_wszLocaleList /* [in] [unique,charset(UTF16)] */,
				  uint32_t _dwNumLocales /* [in]  */,
				  uint32_t *_reserved /* [out] [ref] */,
				  WERROR *result)
{
	struct EstablishPosition r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.wszLocaleList = _wszLocaleList;
	r.in.dwNumLocales = _dwNumLocales;

	status = dcerpc_EstablishPosition_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	*_reserved = *r.out.reserved;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_RequestChallenge_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_RequestChallenge_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_RequestChallenge_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct RequestChallenge *r)
{
	struct tevent_req *req;
	struct dcerpc_RequestChallenge_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_RequestChallenge_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemLevel1Login,
			NDR_REQUESTCHALLENGE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_RequestChallenge_r_done, req);

	return req;
}

static void dcerpc_RequestChallenge_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_RequestChallenge_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_RequestChallenge_r_state *state =
		tevent_req_data(req,
		struct dcerpc_RequestChallenge_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_RequestChallenge_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct RequestChallenge *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemLevel1Login,
			NDR_REQUESTCHALLENGE, mem_ctx, r);

	return status;
}

struct dcerpc_RequestChallenge_state {
	struct RequestChallenge orig;
	struct RequestChallenge tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_RequestChallenge_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_RequestChallenge_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						struct ORPCTHIS _ORPCthis /* [in]  */,
						const char *_wszNetworkResource /* [in] [charset(UTF16),unique] */,
						const char *_wszUser /* [in] [unique,charset(UTF16)] */,
						uint8_t *_Nonce /* [out] [size_is(16),length_is(16),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_RequestChallenge_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_RequestChallenge_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.wszNetworkResource = _wszNetworkResource;
	state->orig.in.wszUser = _wszUser;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.Nonce = _Nonce;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_RequestChallenge_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_RequestChallenge_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_RequestChallenge_done, req);
	return req;
}

static void dcerpc_RequestChallenge_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_RequestChallenge_state *state = tevent_req_data(
		req, struct dcerpc_RequestChallenge_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_RequestChallenge_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	{
		size_t _copy_len_Nonce;
		_copy_len_Nonce = 16;
		memcpy(state->orig.out.Nonce, state->tmp.out.Nonce, _copy_len_Nonce * sizeof(*state->orig.out.Nonce));
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_RequestChallenge_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct dcerpc_RequestChallenge_state *state = tevent_req_data(
		req, struct dcerpc_RequestChallenge_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_RequestChallenge(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS _ORPCthis /* [in]  */,
				 const char *_wszNetworkResource /* [in] [charset(UTF16),unique] */,
				 const char *_wszUser /* [in] [unique,charset(UTF16)] */,
				 uint8_t *_Nonce /* [out] [size_is(16),length_is(16),ref] */,
				 WERROR *result)
{
	struct RequestChallenge r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.wszNetworkResource = _wszNetworkResource;
	r.in.wszUser = _wszUser;

	status = dcerpc_RequestChallenge_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	{
		size_t _copy_len_Nonce;
		_copy_len_Nonce = 16;
		memcpy(_Nonce, r.out.Nonce, _copy_len_Nonce * sizeof(*_Nonce));
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_WBEMLogin_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_WBEMLogin_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_WBEMLogin_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct WBEMLogin *r)
{
	struct tevent_req *req;
	struct dcerpc_WBEMLogin_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_WBEMLogin_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemLevel1Login,
			NDR_WBEMLOGIN, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_WBEMLogin_r_done, req);

	return req;
}

static void dcerpc_WBEMLogin_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_WBEMLogin_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_WBEMLogin_r_state *state =
		tevent_req_data(req,
		struct dcerpc_WBEMLogin_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_WBEMLogin_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct WBEMLogin *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemLevel1Login,
			NDR_WBEMLOGIN, mem_ctx, r);

	return status;
}

struct dcerpc_WBEMLogin_state {
	struct WBEMLogin orig;
	struct WBEMLogin tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_WBEMLogin_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_WBEMLogin_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct dcerpc_binding_handle *h,
					 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					 struct ORPCTHIS _ORPCthis /* [in]  */,
					 const char *_wszPreferredLocale /* [in] [unique,charset(UTF16)] */,
					 uint8_t *_AccessToken /* [in] [length_is(16),size_is(16),unique] */,
					 int32_t _lFlags /* [in]  */,
					 struct MInterfacePointer *_pCtx /* [in] [ref] */,
					 struct MInterfacePointer **_ppNamespace /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_WBEMLogin_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_WBEMLogin_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.wszPreferredLocale = _wszPreferredLocale;
	state->orig.in.AccessToken = _AccessToken;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppNamespace = _ppNamespace;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_WBEMLogin_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_WBEMLogin_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_WBEMLogin_done, req);
	return req;
}

static void dcerpc_WBEMLogin_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_WBEMLogin_state *state = tevent_req_data(
		req, struct dcerpc_WBEMLogin_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_WBEMLogin_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppNamespace = *state->tmp.out.ppNamespace;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_WBEMLogin_recv(struct tevent_req *req,
			       TALLOC_CTX *mem_ctx,
			       WERROR *result)
{
	struct dcerpc_WBEMLogin_state *state = tevent_req_data(
		req, struct dcerpc_WBEMLogin_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_WBEMLogin(struct dcerpc_binding_handle *h,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS _ORPCthis /* [in]  */,
			  const char *_wszPreferredLocale /* [in] [unique,charset(UTF16)] */,
			  uint8_t *_AccessToken /* [in] [length_is(16),size_is(16),unique] */,
			  int32_t _lFlags /* [in]  */,
			  struct MInterfacePointer *_pCtx /* [in] [ref] */,
			  struct MInterfacePointer **_ppNamespace /* [out] [ref] */,
			  WERROR *result)
{
	struct WBEMLogin r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.wszPreferredLocale = _wszPreferredLocale;
	r.in.AccessToken = _AccessToken;
	r.in.lFlags = _lFlags;
	r.in.pCtx = _pCtx;

	status = dcerpc_WBEMLogin_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	*_ppNamespace = *r.out.ppNamespace;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_NTLMLogin_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NTLMLogin_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NTLMLogin_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct NTLMLogin *r)
{
	struct tevent_req *req;
	struct dcerpc_NTLMLogin_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NTLMLogin_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemLevel1Login,
			NDR_NTLMLOGIN, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NTLMLogin_r_done, req);

	return req;
}

static void dcerpc_NTLMLogin_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_NTLMLogin_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_NTLMLogin_r_state *state =
		tevent_req_data(req,
		struct dcerpc_NTLMLogin_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NTLMLogin_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct NTLMLogin *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemLevel1Login,
			NDR_NTLMLOGIN, mem_ctx, r);

	return status;
}

struct dcerpc_NTLMLogin_state {
	struct NTLMLogin orig;
	struct NTLMLogin tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_NTLMLogin_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_NTLMLogin_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct dcerpc_binding_handle *h,
					 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					 struct ORPCTHIS _ORPCthis /* [in]  */,
					 const char *_wszNetworkResource /* [in] [unique,charset(UTF16)] */,
					 const char *_wszPreferredLocale /* [in] [charset(UTF16),unique] */,
					 int32_t _lFlags /* [in]  */,
					 struct MInterfacePointer *_pCtx /* [in] [unique] */,
					 struct MInterfacePointer **_ppNamespace /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_NTLMLogin_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_NTLMLogin_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.wszNetworkResource = _wszNetworkResource;
	state->orig.in.wszPreferredLocale = _wszPreferredLocale;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.pCtx = _pCtx;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppNamespace = _ppNamespace;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_NTLMLogin_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_NTLMLogin_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_NTLMLogin_done, req);
	return req;
}

static void dcerpc_NTLMLogin_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_NTLMLogin_state *state = tevent_req_data(
		req, struct dcerpc_NTLMLogin_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_NTLMLogin_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppNamespace = *state->tmp.out.ppNamespace;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_NTLMLogin_recv(struct tevent_req *req,
			       TALLOC_CTX *mem_ctx,
			       WERROR *result)
{
	struct dcerpc_NTLMLogin_state *state = tevent_req_data(
		req, struct dcerpc_NTLMLogin_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_NTLMLogin(struct dcerpc_binding_handle *h,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS _ORPCthis /* [in]  */,
			  const char *_wszNetworkResource /* [in] [unique,charset(UTF16)] */,
			  const char *_wszPreferredLocale /* [in] [charset(UTF16),unique] */,
			  int32_t _lFlags /* [in]  */,
			  struct MInterfacePointer *_pCtx /* [in] [unique] */,
			  struct MInterfacePointer **_ppNamespace /* [out] [ref] */,
			  WERROR *result)
{
	struct NTLMLogin r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.wszNetworkResource = _wszNetworkResource;
	r.in.wszPreferredLocale = _wszPreferredLocale;
	r.in.lFlags = _lFlags;
	r.in.pCtx = _pCtx;

	status = dcerpc_NTLMLogin_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	*_ppNamespace = *r.out.ppNamespace;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

/* IWbemWCOSmartEnum - client functions generated by pidl */

struct dcerpc_IWbemWCOSmartEnum_Next_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_IWbemWCOSmartEnum_Next_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_IWbemWCOSmartEnum_Next_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct IWbemWCOSmartEnum_Next *r)
{
	struct tevent_req *req;
	struct dcerpc_IWbemWCOSmartEnum_Next_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_IWbemWCOSmartEnum_Next_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemWCOSmartEnum,
			NDR_IWBEMWCOSMARTENUM_NEXT, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_IWbemWCOSmartEnum_Next_r_done, req);

	return req;
}

static void dcerpc_IWbemWCOSmartEnum_Next_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_IWbemWCOSmartEnum_Next_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_IWbemWCOSmartEnum_Next_r_state *state =
		tevent_req_data(req,
		struct dcerpc_IWbemWCOSmartEnum_Next_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_IWbemWCOSmartEnum_Next_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct IWbemWCOSmartEnum_Next *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemWCOSmartEnum,
			NDR_IWBEMWCOSMARTENUM_NEXT, mem_ctx, r);

	return status;
}

struct dcerpc_IWbemWCOSmartEnum_Next_state {
	struct IWbemWCOSmartEnum_Next orig;
	struct IWbemWCOSmartEnum_Next tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_IWbemWCOSmartEnum_Next_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_IWbemWCOSmartEnum_Next_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						      struct ORPCTHIS _ORPCthis /* [in]  */,
						      struct GUID *_gEWCO /* [in] [ref] */,
						      uint32_t _lTimeOut /* [in]  */,
						      uint32_t _uCount /* [in]  */,
						      uint32_t _unknown /* [in]  */,
						      struct GUID *_gWCO /* [in] [ref] */,
						      uint32_t *_puReturned /* [out] [ref] */,
						      uint32_t *_pSize /* [out] [ref] */,
						      uint8_t **_pData /* [out] [ref,size_is(,*pSize)] */)
{
	struct tevent_req *req;
	struct dcerpc_IWbemWCOSmartEnum_Next_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_IWbemWCOSmartEnum_Next_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.gEWCO = _gEWCO;
	state->orig.in.lTimeOut = _lTimeOut;
	state->orig.in.uCount = _uCount;
	state->orig.in.unknown = _unknown;
	state->orig.in.gWCO = _gWCO;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.puReturned = _puReturned;
	state->orig.out.pSize = _pSize;
	state->orig.out.pData = _pData;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_IWbemWCOSmartEnum_Next_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_IWbemWCOSmartEnum_Next_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_IWbemWCOSmartEnum_Next_done, req);
	return req;
}

static void dcerpc_IWbemWCOSmartEnum_Next_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_IWbemWCOSmartEnum_Next_state *state = tevent_req_data(
		req, struct dcerpc_IWbemWCOSmartEnum_Next_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_IWbemWCOSmartEnum_Next_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.puReturned = *state->tmp.out.puReturned;
	*state->orig.out.pSize = *state->tmp.out.pSize;
	*state->orig.out.pData = *state->tmp.out.pData;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_IWbemWCOSmartEnum_Next_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_IWbemWCOSmartEnum_Next_state *state = tevent_req_data(
		req, struct dcerpc_IWbemWCOSmartEnum_Next_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_IWbemWCOSmartEnum_Next(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				       struct ORPCTHIS _ORPCthis /* [in]  */,
				       struct GUID *_gEWCO /* [in] [ref] */,
				       uint32_t _lTimeOut /* [in]  */,
				       uint32_t _uCount /* [in]  */,
				       uint32_t _unknown /* [in]  */,
				       struct GUID *_gWCO /* [in] [ref] */,
				       uint32_t *_puReturned /* [out] [ref] */,
				       uint32_t *_pSize /* [out] [ref] */,
				       uint8_t **_pData /* [out] [ref,size_is(,*pSize)] */,
				       WERROR *result)
{
	struct IWbemWCOSmartEnum_Next r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.gEWCO = _gEWCO;
	r.in.lTimeOut = _lTimeOut;
	r.in.uCount = _uCount;
	r.in.unknown = _unknown;
	r.in.gWCO = _gWCO;

	status = dcerpc_IWbemWCOSmartEnum_Next_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	*_puReturned = *r.out.puReturned;
	*_pSize = *r.out.pSize;
	*_pData = *r.out.pData;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

/* IWbemFetchSmartEnum - client functions generated by pidl */

struct dcerpc_Fetch_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Fetch_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Fetch_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Fetch *r)
{
	struct tevent_req *req;
	struct dcerpc_Fetch_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Fetch_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemFetchSmartEnum,
			NDR_FETCH, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Fetch_r_done, req);

	return req;
}

static void dcerpc_Fetch_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Fetch_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Fetch_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Fetch_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Fetch_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Fetch *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemFetchSmartEnum,
			NDR_FETCH, mem_ctx, r);

	return status;
}

struct dcerpc_Fetch_state {
	struct Fetch orig;
	struct Fetch tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Fetch_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Fetch_send(TALLOC_CTX *mem_ctx,
				     struct tevent_context *ev,
				     struct dcerpc_binding_handle *h,
				     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				     struct ORPCTHIS _ORPCthis /* [in]  */,
				     struct MInterfacePointer **_ppEnum /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_Fetch_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Fetch_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppEnum = _ppEnum;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_Fetch_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Fetch_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Fetch_done, req);
	return req;
}

static void dcerpc_Fetch_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Fetch_state *state = tevent_req_data(
		req, struct dcerpc_Fetch_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Fetch_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppEnum = *state->tmp.out.ppEnum;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Fetch_recv(struct tevent_req *req,
			   TALLOC_CTX *mem_ctx,
			   WERROR *result)
{
	struct dcerpc_Fetch_state *state = tevent_req_data(
		req, struct dcerpc_Fetch_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Fetch(struct dcerpc_binding_handle *h,
		      TALLOC_CTX *mem_ctx,
		      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
		      struct ORPCTHIS _ORPCthis /* [in]  */,
		      struct MInterfacePointer **_ppEnum /* [out] [ref] */,
		      WERROR *result)
{
	struct Fetch r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;

	status = dcerpc_Fetch_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	*_ppEnum = *r.out.ppEnum;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_Test_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Test_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Test_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Test *r)
{
	struct tevent_req *req;
	struct dcerpc_Test_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Test_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemFetchSmartEnum,
			NDR_TEST, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Test_r_done, req);

	return req;
}

static void dcerpc_Test_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Test_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Test_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Test_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Test_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Test *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemFetchSmartEnum,
			NDR_TEST, mem_ctx, r);

	return status;
}

struct dcerpc_Test_state {
	struct Test orig;
	struct Test tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Test_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Test_send(TALLOC_CTX *mem_ctx,
				    struct tevent_context *ev,
				    struct dcerpc_binding_handle *h,
				    struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				    struct ORPCTHIS _ORPCthis /* [in]  */,
				    struct MInterfacePointer **_ppEnum /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_Test_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Test_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppEnum = _ppEnum;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_Test_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Test_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Test_done, req);
	return req;
}

static void dcerpc_Test_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Test_state *state = tevent_req_data(
		req, struct dcerpc_Test_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Test_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppEnum = *state->tmp.out.ppEnum;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Test_recv(struct tevent_req *req,
			  TALLOC_CTX *mem_ctx,
			  WERROR *result)
{
	struct dcerpc_Test_state *state = tevent_req_data(
		req, struct dcerpc_Test_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Test(struct dcerpc_binding_handle *h,
		     TALLOC_CTX *mem_ctx,
		     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
		     struct ORPCTHIS _ORPCthis /* [in]  */,
		     struct MInterfacePointer **_ppEnum /* [out] [ref] */,
		     WERROR *result)
{
	struct Test r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;

	status = dcerpc_Test_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	*_ppEnum = *r.out.ppEnum;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

/* IWbemCallResult - client functions generated by pidl */

struct dcerpc_GetResultObject_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_GetResultObject_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_GetResultObject_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct GetResultObject *r)
{
	struct tevent_req *req;
	struct dcerpc_GetResultObject_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_GetResultObject_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemCallResult,
			NDR_GETRESULTOBJECT, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_GetResultObject_r_done, req);

	return req;
}

static void dcerpc_GetResultObject_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_GetResultObject_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_GetResultObject_r_state *state =
		tevent_req_data(req,
		struct dcerpc_GetResultObject_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_GetResultObject_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct GetResultObject *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemCallResult,
			NDR_GETRESULTOBJECT, mem_ctx, r);

	return status;
}

struct dcerpc_GetResultObject_state {
	struct GetResultObject orig;
	struct GetResultObject tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_GetResultObject_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_GetResultObject_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					       struct ORPCTHIS _ORPCthis /* [in]  */,
					       int32_t _lTimeout /* [in]  */,
					       struct MInterfacePointer **_ppResultObject /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_GetResultObject_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_GetResultObject_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.lTimeout = _lTimeout;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppResultObject = _ppResultObject;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_GetResultObject_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_GetResultObject_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_GetResultObject_done, req);
	return req;
}

static void dcerpc_GetResultObject_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_GetResultObject_state *state = tevent_req_data(
		req, struct dcerpc_GetResultObject_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_GetResultObject_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppResultObject = *state->tmp.out.ppResultObject;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_GetResultObject_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_GetResultObject_state *state = tevent_req_data(
		req, struct dcerpc_GetResultObject_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_GetResultObject(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				struct ORPCTHIS _ORPCthis /* [in]  */,
				int32_t _lTimeout /* [in]  */,
				struct MInterfacePointer **_ppResultObject /* [out] [ref] */,
				WERROR *result)
{
	struct GetResultObject r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.lTimeout = _lTimeout;

	status = dcerpc_GetResultObject_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	*_ppResultObject = *r.out.ppResultObject;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_GetResultString_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_GetResultString_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_GetResultString_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct GetResultString *r)
{
	struct tevent_req *req;
	struct dcerpc_GetResultString_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_GetResultString_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemCallResult,
			NDR_GETRESULTSTRING, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_GetResultString_r_done, req);

	return req;
}

static void dcerpc_GetResultString_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_GetResultString_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_GetResultString_r_state *state =
		tevent_req_data(req,
		struct dcerpc_GetResultString_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_GetResultString_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct GetResultString *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemCallResult,
			NDR_GETRESULTSTRING, mem_ctx, r);

	return status;
}

struct dcerpc_GetResultString_state {
	struct GetResultString orig;
	struct GetResultString tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_GetResultString_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_GetResultString_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					       struct ORPCTHIS _ORPCthis /* [in]  */,
					       int32_t _lTimeout /* [in]  */,
					       struct BSTR *_pstrResultString /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_GetResultString_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_GetResultString_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.lTimeout = _lTimeout;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.pstrResultString = _pstrResultString;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_GetResultString_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_GetResultString_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_GetResultString_done, req);
	return req;
}

static void dcerpc_GetResultString_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_GetResultString_state *state = tevent_req_data(
		req, struct dcerpc_GetResultString_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_GetResultString_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.pstrResultString = *state->tmp.out.pstrResultString;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_GetResultString_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_GetResultString_state *state = tevent_req_data(
		req, struct dcerpc_GetResultString_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_GetResultString(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				struct ORPCTHIS _ORPCthis /* [in]  */,
				int32_t _lTimeout /* [in]  */,
				struct BSTR *_pstrResultString /* [out] [ref] */,
				WERROR *result)
{
	struct GetResultString r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.lTimeout = _lTimeout;

	status = dcerpc_GetResultString_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	*_pstrResultString = *r.out.pstrResultString;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_GetResultServices_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_GetResultServices_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_GetResultServices_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct GetResultServices *r)
{
	struct tevent_req *req;
	struct dcerpc_GetResultServices_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_GetResultServices_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemCallResult,
			NDR_GETRESULTSERVICES, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_GetResultServices_r_done, req);

	return req;
}

static void dcerpc_GetResultServices_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_GetResultServices_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_GetResultServices_r_state *state =
		tevent_req_data(req,
		struct dcerpc_GetResultServices_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_GetResultServices_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct GetResultServices *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemCallResult,
			NDR_GETRESULTSERVICES, mem_ctx, r);

	return status;
}

struct dcerpc_GetResultServices_state {
	struct GetResultServices orig;
	struct GetResultServices tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_GetResultServices_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_GetResultServices_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
						 struct ORPCTHIS _ORPCthis /* [in]  */,
						 int32_t _lTimeout /* [in]  */,
						 struct MInterfacePointer **_ppServices /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_GetResultServices_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_GetResultServices_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.lTimeout = _lTimeout;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.ppServices = _ppServices;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_GetResultServices_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_GetResultServices_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_GetResultServices_done, req);
	return req;
}

static void dcerpc_GetResultServices_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_GetResultServices_state *state = tevent_req_data(
		req, struct dcerpc_GetResultServices_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_GetResultServices_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.ppServices = *state->tmp.out.ppServices;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_GetResultServices_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_GetResultServices_state *state = tevent_req_data(
		req, struct dcerpc_GetResultServices_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_GetResultServices(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
				  struct ORPCTHIS _ORPCthis /* [in]  */,
				  int32_t _lTimeout /* [in]  */,
				  struct MInterfacePointer **_ppServices /* [out] [ref] */,
				  WERROR *result)
{
	struct GetResultServices r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.lTimeout = _lTimeout;

	status = dcerpc_GetResultServices_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	*_ppServices = *r.out.ppServices;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_GetCallStatus_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_GetCallStatus_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_GetCallStatus_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct GetCallStatus *r)
{
	struct tevent_req *req;
	struct dcerpc_GetCallStatus_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_GetCallStatus_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemCallResult,
			NDR_GETCALLSTATUS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_GetCallStatus_r_done, req);

	return req;
}

static void dcerpc_GetCallStatus_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_GetCallStatus_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_GetCallStatus_r_state *state =
		tevent_req_data(req,
		struct dcerpc_GetCallStatus_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_GetCallStatus_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct GetCallStatus *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemCallResult,
			NDR_GETCALLSTATUS, mem_ctx, r);

	return status;
}

struct dcerpc_GetCallStatus_state {
	struct GetCallStatus orig;
	struct GetCallStatus tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_GetCallStatus_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_GetCallStatus_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h,
					     struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					     struct ORPCTHIS _ORPCthis /* [in]  */,
					     int32_t _lTimeout /* [in]  */,
					     int32_t *_plStatus /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_GetCallStatus_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_GetCallStatus_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.lTimeout = _lTimeout;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;
	state->orig.out.plStatus = _plStatus;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_GetCallStatus_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_GetCallStatus_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_GetCallStatus_done, req);
	return req;
}

static void dcerpc_GetCallStatus_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_GetCallStatus_state *state = tevent_req_data(
		req, struct dcerpc_GetCallStatus_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_GetCallStatus_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;
	*state->orig.out.plStatus = *state->tmp.out.plStatus;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_GetCallStatus_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   WERROR *result)
{
	struct dcerpc_GetCallStatus_state *state = tevent_req_data(
		req, struct dcerpc_GetCallStatus_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_GetCallStatus(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
			      struct ORPCTHIS _ORPCthis /* [in]  */,
			      int32_t _lTimeout /* [in]  */,
			      int32_t *_plStatus /* [out] [ref] */,
			      WERROR *result)
{
	struct GetCallStatus r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.lTimeout = _lTimeout;

	status = dcerpc_GetCallStatus_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;
	*_plStatus = *r.out.plStatus;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

/* IWbemObjectSink - client functions generated by pidl */

struct dcerpc_SetStatus_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_SetStatus_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_SetStatus_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct SetStatus *r)
{
	struct tevent_req *req;
	struct dcerpc_SetStatus_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_SetStatus_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemObjectSink,
			NDR_SETSTATUS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_SetStatus_r_done, req);

	return req;
}

static void dcerpc_SetStatus_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_SetStatus_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_SetStatus_r_state *state =
		tevent_req_data(req,
		struct dcerpc_SetStatus_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_SetStatus_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct SetStatus *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemObjectSink,
			NDR_SETSTATUS, mem_ctx, r);

	return status;
}

struct dcerpc_SetStatus_state {
	struct SetStatus orig;
	struct SetStatus tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_SetStatus_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_SetStatus_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct dcerpc_binding_handle *h,
					 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					 struct ORPCTHIS _ORPCthis /* [in]  */,
					 int32_t _lFlags /* [in]  */,
					 WERROR _hResult /* [in]  */,
					 struct BSTR _strParam /* [in]  */,
					 struct MInterfacePointer *_pObjParam /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_SetStatus_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_SetStatus_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.lFlags = _lFlags;
	state->orig.in.hResult = _hResult;
	state->orig.in.strParam = _strParam;
	state->orig.in.pObjParam = _pObjParam;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_SetStatus_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_SetStatus_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_SetStatus_done, req);
	return req;
}

static void dcerpc_SetStatus_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_SetStatus_state *state = tevent_req_data(
		req, struct dcerpc_SetStatus_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_SetStatus_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_SetStatus_recv(struct tevent_req *req,
			       TALLOC_CTX *mem_ctx,
			       WERROR *result)
{
	struct dcerpc_SetStatus_state *state = tevent_req_data(
		req, struct dcerpc_SetStatus_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_SetStatus(struct dcerpc_binding_handle *h,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS _ORPCthis /* [in]  */,
			  int32_t _lFlags /* [in]  */,
			  WERROR _hResult /* [in]  */,
			  struct BSTR _strParam /* [in]  */,
			  struct MInterfacePointer *_pObjParam /* [in] [ref] */,
			  WERROR *result)
{
	struct SetStatus r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.lFlags = _lFlags;
	r.in.hResult = _hResult;
	r.in.strParam = _strParam;
	r.in.pObjParam = _pObjParam;

	status = dcerpc_SetStatus_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_Indicate_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Indicate_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Indicate_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Indicate *r)
{
	struct tevent_req *req;
	struct dcerpc_Indicate_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Indicate_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IWbemObjectSink,
			NDR_INDICATE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Indicate_r_done, req);

	return req;
}

static void dcerpc_Indicate_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Indicate_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Indicate_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Indicate_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Indicate_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Indicate *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IWbemObjectSink,
			NDR_INDICATE, mem_ctx, r);

	return status;
}

struct dcerpc_Indicate_state {
	struct Indicate orig;
	struct Indicate tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Indicate_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Indicate_send(TALLOC_CTX *mem_ctx,
					struct tevent_context *ev,
					struct dcerpc_binding_handle *h,
					struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
					struct ORPCTHIS _ORPCthis /* [in]  */,
					int32_t _lObjectCount /* [in]  */,
					struct MInterfacePointer **_apObjArray /* [in] [ref,size_is(lObjectCount)] */)
{
	struct tevent_req *req;
	struct dcerpc_Indicate_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Indicate_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.ORPCthis = _ORPCthis;
	state->orig.in.lObjectCount = _lObjectCount;
	state->orig.in.apObjArray = _apObjArray;

	/* Out parameters */
	state->orig.out.ORPCthat = _ORPCthat;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_Indicate_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Indicate_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Indicate_done, req);
	return req;
}

static void dcerpc_Indicate_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Indicate_state *state = tevent_req_data(
		req, struct dcerpc_Indicate_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Indicate_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ORPCthat = *state->tmp.out.ORPCthat;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Indicate_recv(struct tevent_req *req,
			      TALLOC_CTX *mem_ctx,
			      WERROR *result)
{
	struct dcerpc_Indicate_state *state = tevent_req_data(
		req, struct dcerpc_Indicate_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Indicate(struct dcerpc_binding_handle *h,
			 TALLOC_CTX *mem_ctx,
			 struct ORPCTHAT *_ORPCthat /* [out] [ref] */,
			 struct ORPCTHIS _ORPCthis /* [in]  */,
			 int32_t _lObjectCount /* [in]  */,
			 struct MInterfacePointer **_apObjArray /* [in] [ref,size_is(lObjectCount)] */,
			 WERROR *result)
{
	struct Indicate r;
	NTSTATUS status;

	/* In parameters */
	r.in.ORPCthis = _ORPCthis;
	r.in.lObjectCount = _lObjectCount;
	r.in.apObjArray = _apObjArray;

	status = dcerpc_Indicate_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ORPCthat = *r.out.ORPCthat;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

