/* header auto-generated by pidl */

#ifndef _PIDL_HEADER_lsarpc
#define _PIDL_HEADER_lsarpc

#include <stdint.h>

#include "libcli/util/ntstatus.h"

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/security.h"
#ifndef _HEADER_lsarpc
#define _HEADER_lsarpc

#define LSA_POLICY_ALL_ACCESS	( (STANDARD_RIGHTS_REQUIRED_ACCESS|LSA_POLICY_VIEW_LOCAL_INFORMATION|LSA_POLICY_VIEW_AUDIT_INFORMATION|LSA_POLICY_GET_PRIVATE_INFORMATION|LSA_POLICY_TRUST_ADMIN|LSA_POLICY_CREATE_ACCOUNT|LSA_POLICY_CREATE_SECRET|LSA_POLICY_CREATE_PRIVILEGE|LSA_POLICY_SET_DEFAULT_QUOTA_LIMITS|LSA_POLICY_SET_AUDIT_REQUIREMENTS|LSA_POLICY_AUDIT_LOG_ADMIN|LSA_POLICY_SERVER_ADMIN|LSA_POLICY_LOOKUP_NAMES) )
#define LSA_POLICY_READ	( (STANDARD_RIGHTS_READ_ACCESS|LSA_POLICY_VIEW_LOCAL_INFORMATION|LSA_POLICY_VIEW_AUDIT_INFORMATION|LSA_POLICY_GET_PRIVATE_INFORMATION) )
#define LSA_POLICY_WRITE	( (STANDARD_RIGHTS_READ_ACCESS|LSA_POLICY_TRUST_ADMIN|LSA_POLICY_CREATE_ACCOUNT|LSA_POLICY_CREATE_SECRET|LSA_POLICY_CREATE_PRIVILEGE|LSA_POLICY_SET_DEFAULT_QUOTA_LIMITS|LSA_POLICY_SET_AUDIT_REQUIREMENTS|LSA_POLICY_AUDIT_LOG_ADMIN|LSA_POLICY_SERVER_ADMIN) )
#define LSA_POLICY_EXECUTE	( (STANDARD_RIGHTS_EXECUTE_ACCESS|LSA_POLICY_VIEW_LOCAL_INFORMATION|LSA_POLICY_LOOKUP_NAMES) )
#define LSA_ACCOUNT_ALL_ACCESS	( (STANDARD_RIGHTS_REQUIRED_ACCESS|LSA_ACCOUNT_VIEW|LSA_ACCOUNT_ADJUST_PRIVILEGES|LSA_ACCOUNT_ADJUST_QUOTAS|LSA_ACCOUNT_ADJUST_SYSTEM_ACCESS) )
#define LSA_ACCOUNT_READ	( (STANDARD_RIGHTS_READ_ACCESS|LSA_ACCOUNT_VIEW) )
#define LSA_ACCOUNT_WRITE	( (STANDARD_RIGHTS_READ_ACCESS|LSA_ACCOUNT_ADJUST_PRIVILEGES|LSA_ACCOUNT_ADJUST_QUOTAS|LSA_ACCOUNT_ADJUST_SYSTEM_ACCESS) )
#define LSA_ACCOUNT_EXECUTE	( (STANDARD_RIGHTS_EXECUTE_ACCESS) )
#define LSA_SECRET_ALL_ACCESS	( (LSA_SECRET_QUERY_VALUE|LSA_SECRET_SET_VALUE|SEC_STD_DELETE|STANDARD_RIGHTS_READ_ACCESS|SEC_STD_WRITE_DAC|SEC_STD_WRITE_OWNER) )
#define LSA_SECRET_READ	( (LSA_SECRET_QUERY_VALUE|STANDARD_RIGHTS_READ_ACCESS) )
#define LSA_SECRET_WRITE	( (LSA_SECRET_SET_VALUE|STANDARD_RIGHTS_READ_ACCESS) )
#define LSA_SECRET_EXECUTE	( (STANDARD_RIGHTS_READ_ACCESS) )
#define LSA_TRUSTED_DOMAIN_ALL_ACCESS	( (LSA_TRUSTED_QUERY_DOMAIN_NAME|LSA_TRUSTED_QUERY_CONTROLLERS|LSA_TRUSTED_SET_CONTROLLERS|LSA_TRUSTED_QUERY_POSIX|LSA_TRUSTED_SET_POSIX|LSA_TRUSTED_SET_AUTH|LSA_TRUSTED_QUERY_AUTH|SEC_STD_DELETE|STANDARD_RIGHTS_READ_ACCESS|SEC_STD_WRITE_DAC|SEC_STD_WRITE_OWNER) )
#define LSA_TRUSTED_DOMAIN_READ	( (LSA_TRUSTED_QUERY_DOMAIN_NAME|STANDARD_RIGHTS_READ_ACCESS) )
#define LSA_TRUSTED_DOMAIN_WRITE	( (LSA_TRUSTED_SET_CONTROLLERS|LSA_TRUSTED_SET_POSIX|LSA_TRUSTED_SET_AUTH|STANDARD_RIGHTS_READ_ACCESS) )
#define LSA_TRUSTED_DOMAIN_EXECUTE	( (LSA_TRUSTED_QUERY_DOMAIN_NAME|LSA_TRUSTED_QUERY_POSIX|STANDARD_RIGHTS_READ_ACCESS) )
#define LSA_ENUM_TRUST_DOMAIN_MULTIPLIER	( 60 )
#define LSA_REF_DOMAIN_LIST_MULTIPLIER	( 32 )
#define LSA_ENUM_TRUST_DOMAIN_EX_MULTIPLIER	( 82 )
#define LSA_CLIENT_REVISION_NO_DNS	( 0x00000001 )
#define LSA_CLIENT_REVISION_DNS	( 0x00000002 )
#define LSA_LOOKUP_OPTIONS_NO_ISOLATED	( 0x80000000 )
struct lsa_String {
	uint16_t length;/* [value(2*strlen_m(string))] */
	uint16_t size;/* [value(2*strlen_m(string))] */
	const char *string;/* [unique,length_is(length/2),size_is(size/2),charset(UTF16)] */
}/* [public] */;

struct lsa_StringLarge {
	uint16_t length;/* [value(2*strlen_m(string))] */
	uint16_t size;/* [value(2*strlen_m_term(string))] */
	const char *string;/* [charset(UTF16),unique,size_is(size/2),length_is(length/2)] */
}/* [public] */;

struct lsa_Strings {
	uint32_t count;
	struct lsa_String *names;/* [size_is(count),unique] */
}/* [public] */;

struct lsa_AsciiString {
	uint16_t length;/* [value(strlen_m(string))] */
	uint16_t size;/* [value(strlen_m(string))] */
	const char *string;/* [charset(DOS),unique,size_is(size),length_is(length)] */
}/* [public] */;

struct lsa_AsciiStringLarge {
	uint16_t length;/* [value(strlen_m(string))] */
	uint16_t size;/* [value(strlen_m_term(string))] */
	const char *string;/* [charset(DOS),length_is(length),unique,size_is(size)] */
}/* [public] */;

struct lsa_BinaryString {
	uint16_t length;
	uint16_t size;
	uint16_t *array;/* [length_is(length/2),unique,size_is(size/2)] */
}/* [public] */;

struct lsa_LUID {
	uint32_t low;
	uint32_t high;
};

struct lsa_PrivEntry {
	struct lsa_StringLarge name;
	struct lsa_LUID luid;
};

struct lsa_PrivArray {
	uint32_t count;
	struct lsa_PrivEntry *privs;/* [unique,size_is(count)] */
};

struct lsa_QosInfo {
	uint32_t len;
	uint16_t impersonation_level;
	uint8_t context_mode;
	uint8_t effective_only;
};

struct lsa_ObjectAttribute {
	uint32_t len;
	uint8_t *root_dir;/* [unique] */
	const char *object_name;/* [unique,charset(UTF16)] */
	uint32_t attributes;
	struct security_descriptor *sec_desc;/* [unique] */
	struct lsa_QosInfo *sec_qos;/* [unique] */
};

/* bitmap lsa_PolicyAccessMask */
#define LSA_POLICY_VIEW_LOCAL_INFORMATION ( 0x00000001 )
#define LSA_POLICY_VIEW_AUDIT_INFORMATION ( 0x00000002 )
#define LSA_POLICY_GET_PRIVATE_INFORMATION ( 0x00000004 )
#define LSA_POLICY_TRUST_ADMIN ( 0x00000008 )
#define LSA_POLICY_CREATE_ACCOUNT ( 0x00000010 )
#define LSA_POLICY_CREATE_SECRET ( 0x00000020 )
#define LSA_POLICY_CREATE_PRIVILEGE ( 0x00000040 )
#define LSA_POLICY_SET_DEFAULT_QUOTA_LIMITS ( 0x00000080 )
#define LSA_POLICY_SET_AUDIT_REQUIREMENTS ( 0x00000100 )
#define LSA_POLICY_AUDIT_LOG_ADMIN ( 0x00000200 )
#define LSA_POLICY_SERVER_ADMIN ( 0x00000400 )
#define LSA_POLICY_LOOKUP_NAMES ( 0x00000800 )
#define LSA_POLICY_NOTIFICATION ( 0x00001000 )

/* bitmap lsa_AccountAccessMask */
#define LSA_ACCOUNT_VIEW ( 0x00000001 )
#define LSA_ACCOUNT_ADJUST_PRIVILEGES ( 0x00000002 )
#define LSA_ACCOUNT_ADJUST_QUOTAS ( 0x00000004 )
#define LSA_ACCOUNT_ADJUST_SYSTEM_ACCESS ( 0x00000008 )

/* bitmap lsa_SecretAccessMask */
#define LSA_SECRET_SET_VALUE ( 0x00000001 )
#define LSA_SECRET_QUERY_VALUE ( 0x00000002 )

/* bitmap lsa_TrustedAccessMask */
#define LSA_TRUSTED_QUERY_DOMAIN_NAME ( 0x00000001 )
#define LSA_TRUSTED_QUERY_CONTROLLERS ( 0x00000002 )
#define LSA_TRUSTED_SET_CONTROLLERS ( 0x00000004 )
#define LSA_TRUSTED_QUERY_POSIX ( 0x00000008 )
#define LSA_TRUSTED_SET_POSIX ( 0x00000010 )
#define LSA_TRUSTED_SET_AUTH ( 0x00000020 )
#define LSA_TRUSTED_QUERY_AUTH ( 0x00000040 )

struct lsa_AuditLogInfo {
	uint32_t percent_full;
	uint32_t maximum_log_size;
	uint64_t retention_time;
	uint8_t shutdown_in_progress;
	uint64_t time_to_shutdown;
	uint32_t next_audit_record;
};

enum lsa_PolicyAuditPolicy
#ifndef USE_UINT_ENUMS
 {
	LSA_AUDIT_POLICY_NONE=(int)(0),
	LSA_AUDIT_POLICY_SUCCESS=(int)(1),
	LSA_AUDIT_POLICY_FAILURE=(int)(2),
	LSA_AUDIT_POLICY_ALL=(int)((LSA_AUDIT_POLICY_SUCCESS|LSA_AUDIT_POLICY_FAILURE)),
	LSA_AUDIT_POLICY_CLEAR=(int)(4)
}
#else
 { __donnot_use_enum_lsa_PolicyAuditPolicy=0x7FFFFFFF}
#define LSA_AUDIT_POLICY_NONE ( 0 )
#define LSA_AUDIT_POLICY_SUCCESS ( 1 )
#define LSA_AUDIT_POLICY_FAILURE ( 2 )
#define LSA_AUDIT_POLICY_ALL ( (LSA_AUDIT_POLICY_SUCCESS|LSA_AUDIT_POLICY_FAILURE) )
#define LSA_AUDIT_POLICY_CLEAR ( 4 )
#endif
;

enum lsa_PolicyAuditEventType
#ifndef USE_UINT_ENUMS
 {
	LSA_AUDIT_CATEGORY_SYSTEM=(int)(0),
	LSA_AUDIT_CATEGORY_LOGON=(int)(1),
	LSA_AUDIT_CATEGORY_FILE_AND_OBJECT_ACCESS=(int)(2),
	LSA_AUDIT_CATEGORY_USE_OF_USER_RIGHTS=(int)(3),
	LSA_AUDIT_CATEGORY_PROCCESS_TRACKING=(int)(4),
	LSA_AUDIT_CATEGORY_SECURITY_POLICY_CHANGES=(int)(5),
	LSA_AUDIT_CATEGORY_ACCOUNT_MANAGEMENT=(int)(6),
	LSA_AUDIT_CATEGORY_DIRECTORY_SERVICE_ACCESS=(int)(7),
	LSA_AUDIT_CATEGORY_ACCOUNT_LOGON=(int)(8)
}
#else
 { __donnot_use_enum_lsa_PolicyAuditEventType=0x7FFFFFFF}
#define LSA_AUDIT_CATEGORY_SYSTEM ( 0 )
#define LSA_AUDIT_CATEGORY_LOGON ( 1 )
#define LSA_AUDIT_CATEGORY_FILE_AND_OBJECT_ACCESS ( 2 )
#define LSA_AUDIT_CATEGORY_USE_OF_USER_RIGHTS ( 3 )
#define LSA_AUDIT_CATEGORY_PROCCESS_TRACKING ( 4 )
#define LSA_AUDIT_CATEGORY_SECURITY_POLICY_CHANGES ( 5 )
#define LSA_AUDIT_CATEGORY_ACCOUNT_MANAGEMENT ( 6 )
#define LSA_AUDIT_CATEGORY_DIRECTORY_SERVICE_ACCESS ( 7 )
#define LSA_AUDIT_CATEGORY_ACCOUNT_LOGON ( 8 )
#endif
;

struct lsa_AuditEventsInfo {
	uint32_t auditing_mode;
	enum lsa_PolicyAuditPolicy *settings;/* [size_is(count),unique] */
	uint32_t count;
};

struct lsa_DomainInfo {
	struct lsa_StringLarge name;
	struct dom_sid2 *sid;/* [unique] */
};

struct lsa_PDAccountInfo {
	struct lsa_String name;
};

enum lsa_Role
#ifndef USE_UINT_ENUMS
 {
	LSA_ROLE_BACKUP=(int)(2),
	LSA_ROLE_PRIMARY=(int)(3)
}
#else
 { __donnot_use_enum_lsa_Role=0x7FFFFFFF}
#define LSA_ROLE_BACKUP ( 2 )
#define LSA_ROLE_PRIMARY ( 3 )
#endif
;

struct lsa_ServerRole {
	enum lsa_Role role;
};

struct lsa_ReplicaSourceInfo {
	struct lsa_String source;
	struct lsa_String account;
};

struct lsa_DefaultQuotaInfo {
	uint32_t paged_pool;
	uint32_t non_paged_pool;
	uint32_t min_wss;
	uint32_t max_wss;
	uint32_t pagefile;
	uint64_t unknown;
};

struct lsa_ModificationInfo {
	uint64_t modified_id;
	NTTIME db_create_time;
};

struct lsa_AuditFullSetInfo {
	uint8_t shutdown_on_full;
};

struct lsa_AuditFullQueryInfo {
	uint8_t shutdown_on_full;
	uint8_t log_is_full;
};

struct lsa_DnsDomainInfo {
	struct lsa_StringLarge name;
	struct lsa_StringLarge dns_domain;
	struct lsa_StringLarge dns_forest;
	struct GUID domain_guid;
	struct dom_sid2 *sid;/* [unique] */
};

enum lsa_PolicyInfo
#ifndef USE_UINT_ENUMS
 {
	LSA_POLICY_INFO_AUDIT_LOG=(int)(1),
	LSA_POLICY_INFO_AUDIT_EVENTS=(int)(2),
	LSA_POLICY_INFO_DOMAIN=(int)(3),
	LSA_POLICY_INFO_PD=(int)(4),
	LSA_POLICY_INFO_ACCOUNT_DOMAIN=(int)(5),
	LSA_POLICY_INFO_ROLE=(int)(6),
	LSA_POLICY_INFO_REPLICA=(int)(7),
	LSA_POLICY_INFO_QUOTA=(int)(8),
	LSA_POLICY_INFO_MOD=(int)(9),
	LSA_POLICY_INFO_AUDIT_FULL_SET=(int)(10),
	LSA_POLICY_INFO_AUDIT_FULL_QUERY=(int)(11),
	LSA_POLICY_INFO_DNS=(int)(12),
	LSA_POLICY_INFO_DNS_INT=(int)(13),
	LSA_POLICY_INFO_L_ACCOUNT_DOMAIN=(int)(14)
}
#else
 { __donnot_use_enum_lsa_PolicyInfo=0x7FFFFFFF}
#define LSA_POLICY_INFO_AUDIT_LOG ( 1 )
#define LSA_POLICY_INFO_AUDIT_EVENTS ( 2 )
#define LSA_POLICY_INFO_DOMAIN ( 3 )
#define LSA_POLICY_INFO_PD ( 4 )
#define LSA_POLICY_INFO_ACCOUNT_DOMAIN ( 5 )
#define LSA_POLICY_INFO_ROLE ( 6 )
#define LSA_POLICY_INFO_REPLICA ( 7 )
#define LSA_POLICY_INFO_QUOTA ( 8 )
#define LSA_POLICY_INFO_MOD ( 9 )
#define LSA_POLICY_INFO_AUDIT_FULL_SET ( 10 )
#define LSA_POLICY_INFO_AUDIT_FULL_QUERY ( 11 )
#define LSA_POLICY_INFO_DNS ( 12 )
#define LSA_POLICY_INFO_DNS_INT ( 13 )
#define LSA_POLICY_INFO_L_ACCOUNT_DOMAIN ( 14 )
#endif
;

union lsa_PolicyInformation {
	struct lsa_AuditLogInfo audit_log;/* [case(LSA_POLICY_INFO_AUDIT_LOG)] */
	struct lsa_AuditEventsInfo audit_events;/* [case(LSA_POLICY_INFO_AUDIT_EVENTS)] */
	struct lsa_DomainInfo domain;/* [case(LSA_POLICY_INFO_DOMAIN)] */
	struct lsa_PDAccountInfo pd;/* [case(LSA_POLICY_INFO_PD)] */
	struct lsa_DomainInfo account_domain;/* [case(LSA_POLICY_INFO_ACCOUNT_DOMAIN)] */
	struct lsa_ServerRole role;/* [case(LSA_POLICY_INFO_ROLE)] */
	struct lsa_ReplicaSourceInfo replica;/* [case(LSA_POLICY_INFO_REPLICA)] */
	struct lsa_DefaultQuotaInfo quota;/* [case(LSA_POLICY_INFO_QUOTA)] */
	struct lsa_ModificationInfo mod;/* [case(LSA_POLICY_INFO_MOD)] */
	struct lsa_AuditFullSetInfo auditfullset;/* [case(LSA_POLICY_INFO_AUDIT_FULL_SET)] */
	struct lsa_AuditFullQueryInfo auditfullquery;/* [case(LSA_POLICY_INFO_AUDIT_FULL_QUERY)] */
	struct lsa_DnsDomainInfo dns;/* [case(LSA_POLICY_INFO_DNS)] */
	struct lsa_DomainInfo l_account_domain;/* [case(LSA_POLICY_INFO_L_ACCOUNT_DOMAIN)] */
}/* [switch_type(uint16)] */;

struct lsa_SidPtr {
	struct dom_sid2 *sid;/* [unique] */
};

struct lsa_SidArray {
	uint32_t num_sids;/* [range(0,20480)] */
	struct lsa_SidPtr *sids;/* [size_is(num_sids),unique] */
}/* [public] */;

struct lsa_DomainList {
	uint32_t count;
	struct lsa_DomainInfo *domains;/* [size_is(count),unique] */
};

enum lsa_SidType
#ifndef USE_UINT_ENUMS
 {
	SID_NAME_USE_NONE=(int)(0),
	SID_NAME_USER=(int)(1),
	SID_NAME_DOM_GRP=(int)(2),
	SID_NAME_DOMAIN=(int)(3),
	SID_NAME_ALIAS=(int)(4),
	SID_NAME_WKN_GRP=(int)(5),
	SID_NAME_DELETED=(int)(6),
	SID_NAME_INVALID=(int)(7),
	SID_NAME_UNKNOWN=(int)(8),
	SID_NAME_COMPUTER=(int)(9)
}
#else
 { __donnot_use_enum_lsa_SidType=0x7FFFFFFF}
#define SID_NAME_USE_NONE ( 0 )
#define SID_NAME_USER ( 1 )
#define SID_NAME_DOM_GRP ( 2 )
#define SID_NAME_DOMAIN ( 3 )
#define SID_NAME_ALIAS ( 4 )
#define SID_NAME_WKN_GRP ( 5 )
#define SID_NAME_DELETED ( 6 )
#define SID_NAME_INVALID ( 7 )
#define SID_NAME_UNKNOWN ( 8 )
#define SID_NAME_COMPUTER ( 9 )
#endif
;

struct lsa_TranslatedSid {
	enum lsa_SidType sid_type;
	uint32_t rid;
	uint32_t sid_index;
};

struct lsa_TransSidArray {
	uint32_t count;/* [range(0,1000)] */
	struct lsa_TranslatedSid *sids;/* [unique,size_is(count)] */
};

struct lsa_RefDomainList {
	uint32_t count;/* [range(0,1000)] */
	struct lsa_DomainInfo *domains;/* [unique,size_is(count)] */
	uint32_t max_size;
}/* [public] */;

enum lsa_LookupNamesLevel
#ifndef USE_UINT_ENUMS
 {
	LSA_LOOKUP_NAMES_ALL=(int)(1),
	LSA_LOOKUP_NAMES_DOMAINS_ONLY=(int)(2),
	LSA_LOOKUP_NAMES_PRIMARY_DOMAIN_ONLY=(int)(3),
	LSA_LOOKUP_NAMES_UPLEVEL_TRUSTS_ONLY=(int)(4),
	LSA_LOOKUP_NAMES_FOREST_TRUSTS_ONLY=(int)(5),
	LSA_LOOKUP_NAMES_UPLEVEL_TRUSTS_ONLY2=(int)(6),
	LSA_LOOKUP_NAMES_RODC_REFERRAL_TO_FULL_DC=(int)(7)
}
#else
 { __donnot_use_enum_lsa_LookupNamesLevel=0x7FFFFFFF}
#define LSA_LOOKUP_NAMES_ALL ( 1 )
#define LSA_LOOKUP_NAMES_DOMAINS_ONLY ( 2 )
#define LSA_LOOKUP_NAMES_PRIMARY_DOMAIN_ONLY ( 3 )
#define LSA_LOOKUP_NAMES_UPLEVEL_TRUSTS_ONLY ( 4 )
#define LSA_LOOKUP_NAMES_FOREST_TRUSTS_ONLY ( 5 )
#define LSA_LOOKUP_NAMES_UPLEVEL_TRUSTS_ONLY2 ( 6 )
#define LSA_LOOKUP_NAMES_RODC_REFERRAL_TO_FULL_DC ( 7 )
#endif
;

struct lsa_TranslatedName {
	enum lsa_SidType sid_type;
	struct lsa_String name;
	uint32_t sid_index;
};

struct lsa_TransNameArray {
	uint32_t count;/* [range(0,20480)] */
	struct lsa_TranslatedName *names;/* [unique,size_is(count)] */
}/* [public] */;

struct lsa_LUIDAttribute {
	struct lsa_LUID luid;
	uint32_t attribute;
};

struct lsa_PrivilegeSet {
	uint32_t count;/* [range(0,1000)] */
	uint32_t unknown;
	struct lsa_LUIDAttribute *set;/* [size_is(count)] */
};

struct lsa_DATA_BUF {
	uint32_t length;
	uint32_t size;
	uint8_t *data;/* [size_is(size),unique,length_is(length)] */
}/* [flag(LIBNDR_PRINT_ARRAY_HEX)] */;

struct lsa_DATA_BUF2 {
	uint32_t size;/* [range(0,65536)] */
	uint8_t *data;/* [unique,size_is(size)] */
}/* [flag(LIBNDR_PRINT_ARRAY_HEX)] */;

enum lsa_TrustDomInfoEnum
#ifndef USE_UINT_ENUMS
 {
	LSA_TRUSTED_DOMAIN_INFO_NAME=(int)(1),
	LSA_TRUSTED_DOMAIN_INFO_CONTROLLERS=(int)(2),
	LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET=(int)(3),
	LSA_TRUSTED_DOMAIN_INFO_PASSWORD=(int)(4),
	LSA_TRUSTED_DOMAIN_INFO_BASIC=(int)(5),
	LSA_TRUSTED_DOMAIN_INFO_INFO_EX=(int)(6),
	LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO=(int)(7),
	LSA_TRUSTED_DOMAIN_INFO_FULL_INFO=(int)(8),
	LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO_INTERNAL=(int)(9),
	LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL=(int)(10),
	LSA_TRUSTED_DOMAIN_INFO_INFO_EX2_INTERNAL=(int)(11),
	LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_2_INTERNAL=(int)(12),
	LSA_TRUSTED_DOMAIN_SUPPORTED_ENCRYPTION_TYPES=(int)(13)
}
#else
 { __donnot_use_enum_lsa_TrustDomInfoEnum=0x7FFFFFFF}
#define LSA_TRUSTED_DOMAIN_INFO_NAME ( 1 )
#define LSA_TRUSTED_DOMAIN_INFO_CONTROLLERS ( 2 )
#define LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET ( 3 )
#define LSA_TRUSTED_DOMAIN_INFO_PASSWORD ( 4 )
#define LSA_TRUSTED_DOMAIN_INFO_BASIC ( 5 )
#define LSA_TRUSTED_DOMAIN_INFO_INFO_EX ( 6 )
#define LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO ( 7 )
#define LSA_TRUSTED_DOMAIN_INFO_FULL_INFO ( 8 )
#define LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO_INTERNAL ( 9 )
#define LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL ( 10 )
#define LSA_TRUSTED_DOMAIN_INFO_INFO_EX2_INTERNAL ( 11 )
#define LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_2_INTERNAL ( 12 )
#define LSA_TRUSTED_DOMAIN_SUPPORTED_ENCRYPTION_TYPES ( 13 )
#endif
;

/* bitmap lsa_TrustDirection */
#define LSA_TRUST_DIRECTION_INBOUND ( 0x00000001 )
#define LSA_TRUST_DIRECTION_OUTBOUND ( 0x00000002 )

enum lsa_TrustType
#ifndef USE_UINT_ENUMS
 {
	LSA_TRUST_TYPE_DOWNLEVEL=(int)(0x00000001),
	LSA_TRUST_TYPE_UPLEVEL=(int)(0x00000002),
	LSA_TRUST_TYPE_MIT=(int)(0x00000003)
}
#else
 { __donnot_use_enum_lsa_TrustType=0x7FFFFFFF}
#define LSA_TRUST_TYPE_DOWNLEVEL ( 0x00000001 )
#define LSA_TRUST_TYPE_UPLEVEL ( 0x00000002 )
#define LSA_TRUST_TYPE_MIT ( 0x00000003 )
#endif
;

/* bitmap lsa_TrustAttributes */
#define LSA_TRUST_ATTRIBUTE_NON_TRANSITIVE ( 0x00000001 )
#define LSA_TRUST_ATTRIBUTE_UPLEVEL_ONLY ( 0x00000002 )
#define LSA_TRUST_ATTRIBUTE_QUARANTINED_DOMAIN ( 0x00000004 )
#define LSA_TRUST_ATTRIBUTE_FOREST_TRANSITIVE ( 0x00000008 )
#define LSA_TRUST_ATTRIBUTE_CROSS_ORGANIZATION ( 0x00000010 )
#define LSA_TRUST_ATTRIBUTE_WITHIN_FOREST ( 0x00000020 )
#define LSA_TRUST_ATTRIBUTE_TREAT_AS_EXTERNAL ( 0x00000040 )
#define LSA_TRUST_ATTRIBUTE_USES_RC4_ENCRYPTION ( 0x00000080 )

struct lsa_TrustDomainInfoName {
	struct lsa_StringLarge netbios_name;
};

struct lsa_TrustDomainInfoControllers {
	uint32_t entries;
	struct lsa_StringLarge *netbios_names;/* [size_is(entries),unique] */
};

struct lsa_TrustDomainInfoPosixOffset {
	uint32_t posix_offset;
};

struct lsa_TrustDomainInfoPassword {
	struct lsa_DATA_BUF *password;/* [unique] */
	struct lsa_DATA_BUF *old_password;/* [unique] */
};

struct lsa_TrustDomainInfoBasic {
	struct lsa_String netbios_name;
	struct dom_sid2 *sid;/* [unique] */
};

struct lsa_TrustDomainInfoInfoEx {
	struct lsa_StringLarge domain_name;
	struct lsa_StringLarge netbios_name;
	struct dom_sid2 *sid;/* [unique] */
	uint32_t trust_direction;
	enum lsa_TrustType trust_type;
	uint32_t trust_attributes;
};

enum lsa_TrustAuthType
#ifndef USE_UINT_ENUMS
 {
	TRUST_AUTH_TYPE_NONE=(int)(0),
	TRUST_AUTH_TYPE_NT4OWF=(int)(1),
	TRUST_AUTH_TYPE_CLEAR=(int)(2),
	TRUST_AUTH_TYPE_VERSION=(int)(3)
}
#else
 { __donnot_use_enum_lsa_TrustAuthType=0x7FFFFFFF}
#define TRUST_AUTH_TYPE_NONE ( 0 )
#define TRUST_AUTH_TYPE_NT4OWF ( 1 )
#define TRUST_AUTH_TYPE_CLEAR ( 2 )
#define TRUST_AUTH_TYPE_VERSION ( 3 )
#endif
;

struct lsa_TrustDomainInfoBuffer {
	NTTIME last_update_time;
	enum lsa_TrustAuthType AuthType;
	struct lsa_DATA_BUF2 data;
};

struct lsa_TrustDomainInfoAuthInfo {
	uint32_t incoming_count;
	struct lsa_TrustDomainInfoBuffer *incoming_current_auth_info;/* [unique] */
	struct lsa_TrustDomainInfoBuffer *incoming_previous_auth_info;/* [unique] */
	uint32_t outgoing_count;
	struct lsa_TrustDomainInfoBuffer *outgoing_current_auth_info;/* [unique] */
	struct lsa_TrustDomainInfoBuffer *outgoing_previous_auth_info;/* [unique] */
}/* [public] */;

struct lsa_TrustDomainInfoFullInfo {
	struct lsa_TrustDomainInfoInfoEx info_ex;
	struct lsa_TrustDomainInfoPosixOffset posix_offset;
	struct lsa_TrustDomainInfoAuthInfo auth_info;
};

struct lsa_TrustDomainInfoAuthInfoInternal {
	struct lsa_DATA_BUF2 auth_blob;
};

struct lsa_TrustDomainInfoFullInfoInternal {
	struct lsa_TrustDomainInfoInfoEx info_ex;
	struct lsa_TrustDomainInfoPosixOffset posix_offset;
	struct lsa_TrustDomainInfoAuthInfoInternal auth_info;
};

struct lsa_TrustDomainInfoInfoEx2Internal {
	struct lsa_TrustDomainInfoInfoEx info_ex;
	uint32_t forest_trust_length;
	uint8_t *forest_trust_data;/* [unique,size_is(forest_trust_length)] */
};

struct lsa_TrustDomainInfoFullInfo2Internal {
	struct lsa_TrustDomainInfoInfoEx2Internal info;
	struct lsa_TrustDomainInfoPosixOffset posix_offset;
	struct lsa_TrustDomainInfoAuthInfo auth_info;
};

struct lsa_TrustDomainInfoSupportedEncTypes {
	uint32_t enc_types;
};

union lsa_TrustedDomainInfo {
	struct lsa_TrustDomainInfoName name;/* [case(LSA_TRUSTED_DOMAIN_INFO_NAME)] */
	struct lsa_TrustDomainInfoControllers controllers;/* [case(LSA_TRUSTED_DOMAIN_INFO_CONTROLLERS)] */
	struct lsa_TrustDomainInfoPosixOffset posix_offset;/* [case(LSA_TRUSTED_DOMAIN_INFO_POSIX_OFFSET)] */
	struct lsa_TrustDomainInfoPassword password;/* [case(LSA_TRUSTED_DOMAIN_INFO_PASSWORD)] */
	struct lsa_TrustDomainInfoBasic info_basic;/* [case(LSA_TRUSTED_DOMAIN_INFO_BASIC)] */
	struct lsa_TrustDomainInfoInfoEx info_ex;/* [case(LSA_TRUSTED_DOMAIN_INFO_INFO_EX)] */
	struct lsa_TrustDomainInfoAuthInfo auth_info;/* [case(LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO)] */
	struct lsa_TrustDomainInfoFullInfo full_info;/* [case(LSA_TRUSTED_DOMAIN_INFO_FULL_INFO)] */
	struct lsa_TrustDomainInfoAuthInfoInternal auth_info_internal;/* [case(LSA_TRUSTED_DOMAIN_INFO_AUTH_INFO_INTERNAL)] */
	struct lsa_TrustDomainInfoFullInfoInternal full_info_internal;/* [case(LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_INTERNAL)] */
	struct lsa_TrustDomainInfoInfoEx2Internal info_ex2_internal;/* [case(LSA_TRUSTED_DOMAIN_INFO_INFO_EX2_INTERNAL)] */
	struct lsa_TrustDomainInfoFullInfo2Internal full_info2_internal;/* [case(LSA_TRUSTED_DOMAIN_INFO_FULL_INFO_2_INTERNAL)] */
	struct lsa_TrustDomainInfoSupportedEncTypes enc_types;/* [case(LSA_TRUSTED_DOMAIN_SUPPORTED_ENCRYPTION_TYPES)] */
}/* [switch_type(lsa_TrustDomInfoEnum)] */;

struct lsa_DATA_BUF_PTR {
	struct lsa_DATA_BUF *buf;/* [unique] */
};

struct lsa_RightAttribute {
	const char *name;/* [charset(UTF16),unique] */
};

struct lsa_RightSet {
	uint32_t count;/* [range(0,256)] */
	struct lsa_StringLarge *names;/* [unique,size_is(count)] */
};

struct lsa_DomainListEx {
	uint32_t count;
	struct lsa_TrustDomainInfoInfoEx *domains;/* [unique,size_is(count)] */
};

/* bitmap lsa_krbAuthenticationOptions */
#define LSA_POLICY_KERBEROS_VALIDATE_CLIENT ( 0x00000080 )

struct lsa_DomainInfoKerberos {
	uint32_t authentication_options;
	uint64_t service_tkt_lifetime;
	uint64_t user_tkt_lifetime;
	uint64_t user_tkt_renewaltime;
	uint64_t clock_skew;
	uint64_t reserved;
};

struct lsa_DomainInfoEfs {
	uint32_t blob_size;
	uint8_t *efs_blob;/* [unique,size_is(blob_size)] */
};

enum lsa_DomainInfoEnum
#ifndef USE_UINT_ENUMS
 {
	LSA_DOMAIN_INFO_POLICY_EFS=(int)(2),
	LSA_DOMAIN_INFO_POLICY_KERBEROS=(int)(3)
}
#else
 { __donnot_use_enum_lsa_DomainInfoEnum=0x7FFFFFFF}
#define LSA_DOMAIN_INFO_POLICY_EFS ( 2 )
#define LSA_DOMAIN_INFO_POLICY_KERBEROS ( 3 )
#endif
;

union lsa_DomainInformationPolicy {
	struct lsa_DomainInfoEfs efs_info;/* [case(LSA_DOMAIN_INFO_POLICY_EFS)] */
	struct lsa_DomainInfoKerberos kerberos_info;/* [case(LSA_DOMAIN_INFO_POLICY_KERBEROS)] */
}/* [switch_type(uint16)] */;

struct lsa_TranslatedName2 {
	enum lsa_SidType sid_type;
	struct lsa_String name;
	uint32_t sid_index;
	uint32_t unknown;
};

struct lsa_TransNameArray2 {
	uint32_t count;/* [range(0,1000)] */
	struct lsa_TranslatedName2 *names;/* [unique,size_is(count)] */
};

enum lsa_LookupOptions
#ifndef USE_UINT_ENUMS
 {
	LSA_LOOKUP_OPTION_SEARCH_ISOLATED_NAMES=(int)(0x00000000),
	LSA_LOOKUP_OPTION_SEARCH_ISOLATED_NAMES_LOCAL=(int)(0x80000000)
}
#else
 { __donnot_use_enum_lsa_LookupOptions=0x7FFFFFFF}
#define LSA_LOOKUP_OPTION_SEARCH_ISOLATED_NAMES ( 0x00000000 )
#define LSA_LOOKUP_OPTION_SEARCH_ISOLATED_NAMES_LOCAL ( 0x80000000 )
#endif
;

enum lsa_ClientRevision
#ifndef USE_UINT_ENUMS
 {
	LSA_CLIENT_REVISION_1=(int)(0x00000001),
	LSA_CLIENT_REVISION_2=(int)(0x00000002)
}
#else
 { __donnot_use_enum_lsa_ClientRevision=0x7FFFFFFF}
#define LSA_CLIENT_REVISION_1 ( 0x00000001 )
#define LSA_CLIENT_REVISION_2 ( 0x00000002 )
#endif
;

struct lsa_TranslatedSid2 {
	enum lsa_SidType sid_type;
	uint32_t rid;
	uint32_t sid_index;
	uint32_t unknown;
};

struct lsa_TransSidArray2 {
	uint32_t count;/* [range(0,1000)] */
	struct lsa_TranslatedSid2 *sids;/* [size_is(count),unique] */
};

struct lsa_TranslatedSid3 {
	enum lsa_SidType sid_type;
	struct dom_sid2 *sid;/* [unique] */
	uint32_t sid_index;
	uint32_t flags;
};

struct lsa_TransSidArray3 {
	uint32_t count;/* [range(0,1000)] */
	struct lsa_TranslatedSid3 *sids;/* [unique,size_is(count)] */
};

struct lsa_ForestTrustBinaryData {
	uint32_t length;/* [range(0,131072)] */
	uint8_t *data;/* [size_is(length),unique] */
};

struct lsa_ForestTrustDomainInfo {
	struct dom_sid2 *domain_sid;/* [unique] */
	struct lsa_StringLarge dns_domain_name;
	struct lsa_StringLarge netbios_domain_name;
};

union lsa_ForestTrustData {
	struct lsa_StringLarge top_level_name;/* [case(LSA_FOREST_TRUST_TOP_LEVEL_NAME)] */
	struct lsa_StringLarge top_level_name_ex;/* [case(LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX)] */
	struct lsa_ForestTrustDomainInfo domain_info;/* [case(LSA_FOREST_TRUST_DOMAIN_INFO)] */
	struct lsa_ForestTrustBinaryData data;/* [default] */
}/* [switch_type(uint32)] */;

enum lsa_ForestTrustRecordType
#ifndef USE_UINT_ENUMS
 {
	LSA_FOREST_TRUST_TOP_LEVEL_NAME=(int)(0),
	LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX=(int)(1),
	LSA_FOREST_TRUST_DOMAIN_INFO=(int)(2),
	LSA_FOREST_TRUST_RECORD_TYPE_LAST=(int)(3)
}
#else
 { __donnot_use_enum_lsa_ForestTrustRecordType=0x7FFFFFFF}
#define LSA_FOREST_TRUST_TOP_LEVEL_NAME ( 0 )
#define LSA_FOREST_TRUST_TOP_LEVEL_NAME_EX ( 1 )
#define LSA_FOREST_TRUST_DOMAIN_INFO ( 2 )
#define LSA_FOREST_TRUST_RECORD_TYPE_LAST ( 3 )
#endif
;

struct lsa_ForestTrustRecord {
	uint32_t flags;
	enum lsa_ForestTrustRecordType type;
	uint64_t time;
	union lsa_ForestTrustData forest_trust_data;/* [switch_is(type)] */
};

struct lsa_ForestTrustInformation {
	uint32_t count;/* [range(0,4000)] */
	struct lsa_ForestTrustRecord **entries;/* [size_is(count),unique] */
}/* [public] */;

enum lsa_ForestTrustCollisionRecordType
#ifndef USE_UINT_ENUMS
 {
	LSA_FOREST_TRUST_COLLISION_TDO=(int)(0),
	LSA_FOREST_TRUST_COLLISION_XREF=(int)(1),
	LSA_FOREST_TRUST_COLLISION_OTHER=(int)(2)
}
#else
 { __donnot_use_enum_lsa_ForestTrustCollisionRecordType=0x7FFFFFFF}
#define LSA_FOREST_TRUST_COLLISION_TDO ( 0 )
#define LSA_FOREST_TRUST_COLLISION_XREF ( 1 )
#define LSA_FOREST_TRUST_COLLISION_OTHER ( 2 )
#endif
;

/* bitmap lsa_ForestTrustCollisionTDOFlags */
#define LSA_TLN_DISABLED_NEW ( 0x00000001 )
#define LSA_TLN_DISABLED_ADMIN ( 0x00000002 )
#define LSA_TLN_DISABLED_CONFLICT ( 0x00000004 )

/* bitmap lsa_ForestTrustCollisionXrefFlags */
#define LSA_SID_DISABLED_ADMIN ( 0x00000001 )
#define LSA_SID_DISABLED_CONFLICT ( 0x00000002 )
#define LSA_NB_DISABLED_ADMIN ( 0x00000004 )
#define LSA_NB_DISABLED_CONFLICT ( 0x00000008 )

union lsa_ForestTrustCollisionFlags {
	uint32_t flags;/* [case(LSA_FOREST_TRUST_COLLISION_TDO)] */
}/* [nodiscriminant] */;

struct lsa_ForestTrustCollisionRecord {
	uint32_t index;
	enum lsa_ForestTrustCollisionRecordType type;
	union lsa_ForestTrustCollisionFlags flags;/* [switch_is(type)] */
	struct lsa_String name;
};

struct lsa_ForestTrustCollisionInfo {
	uint32_t count;
	struct lsa_ForestTrustCollisionRecord **entries;/* [unique,size_is(count)] */
};


struct lsa_Close {
	struct {
		struct policy_handle *handle;/* [ref] */
	} in;

	struct {
		struct policy_handle *handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_Delete {
	struct {
		struct policy_handle *handle;/* [ref] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_EnumPrivs {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t max_count;
		uint32_t *resume_handle;/* [ref] */
	} in;

	struct {
		struct lsa_PrivArray *privs;/* [ref] */
		uint32_t *resume_handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_QuerySecurity {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t sec_info;
	} in;

	struct {
		struct sec_desc_buf **sdbuf;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_SetSecObj {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t sec_info;
		struct sec_desc_buf *sdbuf;/* [ref] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_ChangePassword {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_OpenPolicy {
	struct {
		uint16_t *system_name;/* [unique] */
		struct lsa_ObjectAttribute *attr;/* [ref] */
		uint32_t access_mask;
	} in;

	struct {
		struct policy_handle *handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_QueryInfoPolicy {
	struct {
		struct policy_handle *handle;/* [ref] */
		enum lsa_PolicyInfo level;
	} in;

	struct {
		union lsa_PolicyInformation **info;/* [ref,switch_is(level)] */
		NTSTATUS result;
	} out;

};


struct lsa_SetInfoPolicy {
	struct {
		struct policy_handle *handle;/* [ref] */
		enum lsa_PolicyInfo level;
		union lsa_PolicyInformation *info;/* [switch_is(level),ref] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_ClearAuditLog {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_CreateAccount {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct dom_sid2 *sid;/* [ref] */
		uint32_t access_mask;
	} in;

	struct {
		struct policy_handle *acct_handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_EnumAccounts {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t num_entries;/* [range(0,8192)] */
		uint32_t *resume_handle;/* [ref] */
	} in;

	struct {
		struct lsa_SidArray *sids;/* [ref] */
		uint32_t *resume_handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_CreateTrustedDomain {
	struct {
		struct policy_handle *policy_handle;/* [ref] */
		struct lsa_DomainInfo *info;/* [ref] */
		uint32_t access_mask;
	} in;

	struct {
		struct policy_handle *trustdom_handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_EnumTrustDom {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t max_size;
		uint32_t *resume_handle;/* [ref] */
	} in;

	struct {
		struct lsa_DomainList *domains;/* [ref] */
		uint32_t *resume_handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_LookupNames {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t num_names;/* [range(0,1000)] */
		struct lsa_String *names;/* [size_is(num_names)] */
		enum lsa_LookupNamesLevel level;
		struct lsa_TransSidArray *sids;/* [ref] */
		uint32_t *count;/* [ref] */
	} in;

	struct {
		struct lsa_RefDomainList **domains;/* [ref] */
		struct lsa_TransSidArray *sids;/* [ref] */
		uint32_t *count;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_LookupSids {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_SidArray *sids;/* [ref] */
		enum lsa_LookupNamesLevel level;
		struct lsa_TransNameArray *names;/* [ref] */
		uint32_t *count;/* [ref] */
	} in;

	struct {
		struct lsa_RefDomainList **domains;/* [ref] */
		struct lsa_TransNameArray *names;/* [ref] */
		uint32_t *count;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_CreateSecret {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_String name;
		uint32_t access_mask;
	} in;

	struct {
		struct policy_handle *sec_handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_OpenAccount {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct dom_sid2 *sid;/* [ref] */
		uint32_t access_mask;
	} in;

	struct {
		struct policy_handle *acct_handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_EnumPrivsAccount {
	struct {
		struct policy_handle *handle;/* [ref] */
	} in;

	struct {
		struct lsa_PrivilegeSet **privs;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_AddPrivilegesToAccount {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_PrivilegeSet *privs;/* [ref] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_RemovePrivilegesFromAccount {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint8_t remove_all;
		struct lsa_PrivilegeSet *privs;/* [unique] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_GetQuotasForAccount {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_SetQuotasForAccount {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_GetSystemAccessAccount {
	struct {
		struct policy_handle *handle;/* [ref] */
	} in;

	struct {
		uint32_t *access_mask;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_SetSystemAccessAccount {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t access_mask;
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_OpenTrustedDomain {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct dom_sid2 *sid;/* [ref] */
		uint32_t access_mask;
	} in;

	struct {
		struct policy_handle *trustdom_handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_QueryTrustedDomainInfo {
	struct {
		struct policy_handle *trustdom_handle;/* [ref] */
		enum lsa_TrustDomInfoEnum level;
	} in;

	struct {
		union lsa_TrustedDomainInfo **info;/* [switch_is(level),ref] */
		NTSTATUS result;
	} out;

};


struct lsa_SetInformationTrustedDomain {
	struct {
		struct policy_handle *trustdom_handle;/* [ref] */
		enum lsa_TrustDomInfoEnum level;
		union lsa_TrustedDomainInfo *info;/* [ref,switch_is(level)] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_OpenSecret {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_String name;
		uint32_t access_mask;
	} in;

	struct {
		struct policy_handle *sec_handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_SetSecret {
	struct {
		struct policy_handle *sec_handle;/* [ref] */
		struct lsa_DATA_BUF *new_val;/* [unique] */
		struct lsa_DATA_BUF *old_val;/* [unique] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_QuerySecret {
	struct {
		struct policy_handle *sec_handle;/* [ref] */
		struct lsa_DATA_BUF_PTR *new_val;/* [unique] */
		NTTIME *new_mtime;/* [unique] */
		struct lsa_DATA_BUF_PTR *old_val;/* [unique] */
		NTTIME *old_mtime;/* [unique] */
	} in;

	struct {
		struct lsa_DATA_BUF_PTR *new_val;/* [unique] */
		NTTIME *new_mtime;/* [unique] */
		struct lsa_DATA_BUF_PTR *old_val;/* [unique] */
		NTTIME *old_mtime;/* [unique] */
		NTSTATUS result;
	} out;

};


struct lsa_LookupPrivValue {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_String *name;/* [ref] */
	} in;

	struct {
		struct lsa_LUID *luid;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_LookupPrivName {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_LUID *luid;/* [ref] */
	} in;

	struct {
		struct lsa_StringLarge **name;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_LookupPrivDisplayName {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_String *name;/* [ref] */
		uint16_t language_id;
		uint16_t language_id_sys;
	} in;

	struct {
		struct lsa_StringLarge **disp_name;/* [ref] */
		uint16_t *returned_language_id;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_DeleteObject {
	struct {
		struct policy_handle *handle;/* [ref] */
	} in;

	struct {
		struct policy_handle *handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_EnumAccountsWithUserRight {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_String *name;/* [unique] */
	} in;

	struct {
		struct lsa_SidArray *sids;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_EnumAccountRights {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct dom_sid2 *sid;/* [ref] */
	} in;

	struct {
		struct lsa_RightSet *rights;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_AddAccountRights {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct dom_sid2 *sid;/* [ref] */
		struct lsa_RightSet *rights;/* [ref] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_RemoveAccountRights {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct dom_sid2 *sid;/* [ref] */
		uint8_t remove_all;
		struct lsa_RightSet *rights;/* [ref] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_QueryTrustedDomainInfoBySid {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct dom_sid2 *dom_sid;/* [ref] */
		enum lsa_TrustDomInfoEnum level;
	} in;

	struct {
		union lsa_TrustedDomainInfo **info;/* [ref,switch_is(level)] */
		NTSTATUS result;
	} out;

};


struct lsa_SetTrustedDomainInfo {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct dom_sid2 *dom_sid;/* [ref] */
		enum lsa_TrustDomInfoEnum level;
		union lsa_TrustedDomainInfo *info;/* [ref,switch_is(level)] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_DeleteTrustedDomain {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct dom_sid2 *dom_sid;/* [ref] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_StorePrivateData {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_String *name;/* [ref] */
		struct lsa_DATA_BUF *val;/* [unique] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_RetrievePrivateData {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_String *name;/* [ref] */
		struct lsa_DATA_BUF **val;/* [ref] */
	} in;

	struct {
		struct lsa_DATA_BUF **val;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_OpenPolicy2 {
	struct {
		const char *system_name;/* [charset(UTF16),unique] */
		struct lsa_ObjectAttribute *attr;/* [ref] */
		uint32_t access_mask;
	} in;

	struct {
		struct policy_handle *handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_GetUserName {
	struct {
		const char *system_name;/* [charset(UTF16),unique] */
		struct lsa_String **account_name;/* [ref] */
		struct lsa_String **authority_name;/* [unique] */
	} in;

	struct {
		struct lsa_String **account_name;/* [ref] */
		struct lsa_String **authority_name;/* [unique] */
		NTSTATUS result;
	} out;

};


struct lsa_QueryInfoPolicy2 {
	struct {
		struct policy_handle *handle;/* [ref] */
		enum lsa_PolicyInfo level;
	} in;

	struct {
		union lsa_PolicyInformation **info;/* [ref,switch_is(level)] */
		NTSTATUS result;
	} out;

};


struct lsa_SetInfoPolicy2 {
	struct {
		struct policy_handle *handle;/* [ref] */
		enum lsa_PolicyInfo level;
		union lsa_PolicyInformation *info;/* [switch_is(level),ref] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_QueryTrustedDomainInfoByName {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_String *trusted_domain;/* [ref] */
		enum lsa_TrustDomInfoEnum level;
	} in;

	struct {
		union lsa_TrustedDomainInfo **info;/* [switch_is(level),ref] */
		NTSTATUS result;
	} out;

};


struct lsa_SetTrustedDomainInfoByName {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_String *trusted_domain;/* [ref] */
		enum lsa_TrustDomInfoEnum level;
		union lsa_TrustedDomainInfo *info;/* [ref,switch_is(level)] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_EnumTrustedDomainsEx {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t max_size;
		uint32_t *resume_handle;/* [ref] */
	} in;

	struct {
		struct lsa_DomainListEx *domains;/* [ref] */
		uint32_t *resume_handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_CreateTrustedDomainEx {
	struct {
		struct policy_handle *policy_handle;/* [ref] */
		struct lsa_TrustDomainInfoInfoEx *info;/* [ref] */
		struct lsa_TrustDomainInfoAuthInfoInternal *auth_info;/* [ref] */
		uint32_t access_mask;
	} in;

	struct {
		struct policy_handle *trustdom_handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_CloseTrustedDomainEx {
	struct {
		struct policy_handle *handle;/* [ref] */
	} in;

	struct {
		struct policy_handle *handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_QueryDomainInformationPolicy {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint16_t level;
	} in;

	struct {
		union lsa_DomainInformationPolicy **info;/* [ref,switch_is(level)] */
		NTSTATUS result;
	} out;

};


struct lsa_SetDomainInformationPolicy {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint16_t level;
		union lsa_DomainInformationPolicy *info;/* [unique,switch_is(level)] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct lsa_OpenTrustedDomainByName {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_String name;
		uint32_t access_mask;
	} in;

	struct {
		struct policy_handle *trustdom_handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_TestCall {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_LookupSids2 {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_SidArray *sids;/* [ref] */
		enum lsa_LookupNamesLevel level;
		enum lsa_LookupOptions lookup_options;
		enum lsa_ClientRevision client_revision;
		struct lsa_TransNameArray2 *names;/* [ref] */
		uint32_t *count;/* [ref] */
	} in;

	struct {
		struct lsa_RefDomainList **domains;/* [ref] */
		struct lsa_TransNameArray2 *names;/* [ref] */
		uint32_t *count;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_LookupNames2 {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t num_names;/* [range(0,1000)] */
		struct lsa_String *names;/* [size_is(num_names)] */
		enum lsa_LookupNamesLevel level;
		enum lsa_LookupOptions lookup_options;
		enum lsa_ClientRevision client_revision;
		struct lsa_TransSidArray2 *sids;/* [ref] */
		uint32_t *count;/* [ref] */
	} in;

	struct {
		struct lsa_RefDomainList **domains;/* [ref] */
		struct lsa_TransSidArray2 *sids;/* [ref] */
		uint32_t *count;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_CreateTrustedDomainEx2 {
	struct {
		struct policy_handle *policy_handle;/* [ref] */
		struct lsa_TrustDomainInfoInfoEx *info;/* [ref] */
		struct lsa_TrustDomainInfoAuthInfoInternal *auth_info;/* [ref] */
		uint32_t access_mask;
	} in;

	struct {
		struct policy_handle *trustdom_handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_CREDRWRITE {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_CREDRREAD {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_CREDRENUMERATE {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_CREDRWRITEDOMAINCREDENTIALS {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_CREDRREADDOMAINCREDENTIALS {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_CREDRDELETE {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_CREDRGETTARGETINFO {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_CREDRPROFILELOADED {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_LookupNames3 {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t num_names;/* [range(0,1000)] */
		struct lsa_String *names;/* [size_is(num_names)] */
		enum lsa_LookupNamesLevel level;
		enum lsa_LookupOptions lookup_options;
		enum lsa_ClientRevision client_revision;
		struct lsa_TransSidArray3 *sids;/* [ref] */
		uint32_t *count;/* [ref] */
	} in;

	struct {
		struct lsa_RefDomainList **domains;/* [ref] */
		struct lsa_TransSidArray3 *sids;/* [ref] */
		uint32_t *count;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_CREDRGETSESSIONTYPES {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_LSARREGISTERAUDITEVENT {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_LSARGENAUDITEVENT {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_LSARUNREGISTERAUDITEVENT {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_lsaRQueryForestTrustInformation {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_String *trusted_domain_name;/* [ref] */
		uint16_t unknown;
	} in;

	struct {
		struct lsa_ForestTrustInformation **forest_trust_info;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_lsaRSetForestTrustInformation {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_StringLarge *trusted_domain_name;/* [ref] */
		uint16_t highest_record_type;
		struct lsa_ForestTrustInformation *forest_trust_info;/* [ref] */
		uint8_t check_only;
	} in;

	struct {
		struct lsa_ForestTrustCollisionInfo **collision_info;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_CREDRRENAME {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_LookupSids3 {
	struct {
		struct lsa_SidArray *sids;/* [ref] */
		enum lsa_LookupNamesLevel level;
		enum lsa_LookupOptions lookup_options;
		enum lsa_ClientRevision client_revision;
		struct lsa_TransNameArray2 *names;/* [ref] */
		uint32_t *count;/* [ref] */
	} in;

	struct {
		struct lsa_RefDomainList **domains;/* [ref] */
		struct lsa_TransNameArray2 *names;/* [ref] */
		uint32_t *count;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_LookupNames4 {
	struct {
		uint32_t num_names;/* [range(0,1000)] */
		struct lsa_String *names;/* [size_is(num_names)] */
		enum lsa_LookupNamesLevel level;
		enum lsa_LookupOptions lookup_options;
		enum lsa_ClientRevision client_revision;
		struct lsa_TransSidArray3 *sids;/* [ref] */
		uint32_t *count;/* [ref] */
	} in;

	struct {
		struct lsa_RefDomainList **domains;/* [ref] */
		struct lsa_TransSidArray3 *sids;/* [ref] */
		uint32_t *count;/* [ref] */
		NTSTATUS result;
	} out;

};


struct lsa_LSAROPENPOLICYSCE {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_LSARADTREGISTERSECURITYEVENTSOURCE {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE {
	struct {
		NTSTATUS result;
	} out;

};


struct lsa_LSARADTREPORTSECURITYEVENT {
	struct {
		NTSTATUS result;
	} out;

};

#endif /* _HEADER_lsarpc */
#endif /* _PIDL_HEADER_lsarpc */
