/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/srv_lsa.h"

static bool api_lsa_Close(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_Close *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_CLOSE];

	r = talloc(talloc_tos(), struct lsa_Close);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_Close, r);
	}

	ZERO_STRUCT(r->out);
	r->out.handle = r->in.handle;
	r->out.result = _lsa_Close(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_Close, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_Delete(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_Delete *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_DELETE];

	r = talloc(talloc_tos(), struct lsa_Delete);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_Delete, r);
	}

	r->out.result = _lsa_Delete(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_Delete, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_EnumPrivs(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_EnumPrivs *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_ENUMPRIVS];

	r = talloc(talloc_tos(), struct lsa_EnumPrivs);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumPrivs, r);
	}

	ZERO_STRUCT(r->out);
	r->out.resume_handle = r->in.resume_handle;
	r->out.privs = talloc_zero(r, struct lsa_PrivArray);
	if (r->out.privs == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_EnumPrivs(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumPrivs, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_QuerySecurity(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_QuerySecurity *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_QUERYSECURITY];

	r = talloc(talloc_tos(), struct lsa_QuerySecurity);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QuerySecurity, r);
	}

	ZERO_STRUCT(r->out);
	r->out.sdbuf = talloc_zero(r, struct sec_desc_buf *);
	if (r->out.sdbuf == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_QuerySecurity(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QuerySecurity, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_SetSecObj(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_SetSecObj *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_SETSECOBJ];

	r = talloc(talloc_tos(), struct lsa_SetSecObj);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetSecObj, r);
	}

	r->out.result = _lsa_SetSecObj(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetSecObj, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_ChangePassword(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_ChangePassword *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_CHANGEPASSWORD];

	r = talloc(talloc_tos(), struct lsa_ChangePassword);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_ChangePassword, r);
	}

	r->out.result = _lsa_ChangePassword(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_ChangePassword, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_OpenPolicy(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_OpenPolicy *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_OPENPOLICY];

	r = talloc(talloc_tos(), struct lsa_OpenPolicy);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_OpenPolicy, r);
	}

	ZERO_STRUCT(r->out);
	r->out.handle = talloc_zero(r, struct policy_handle);
	if (r->out.handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_OpenPolicy(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_OpenPolicy, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_QueryInfoPolicy(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_QueryInfoPolicy *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_QUERYINFOPOLICY];

	r = talloc(talloc_tos(), struct lsa_QueryInfoPolicy);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QueryInfoPolicy, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, union lsa_PolicyInformation *);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_QueryInfoPolicy(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QueryInfoPolicy, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_SetInfoPolicy(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_SetInfoPolicy *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_SETINFOPOLICY];

	r = talloc(talloc_tos(), struct lsa_SetInfoPolicy);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetInfoPolicy, r);
	}

	r->out.result = _lsa_SetInfoPolicy(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetInfoPolicy, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_ClearAuditLog(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_ClearAuditLog *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_CLEARAUDITLOG];

	r = talloc(talloc_tos(), struct lsa_ClearAuditLog);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_ClearAuditLog, r);
	}

	r->out.result = _lsa_ClearAuditLog(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_ClearAuditLog, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_CreateAccount(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_CreateAccount *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_CREATEACCOUNT];

	r = talloc(talloc_tos(), struct lsa_CreateAccount);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CreateAccount, r);
	}

	ZERO_STRUCT(r->out);
	r->out.acct_handle = talloc_zero(r, struct policy_handle);
	if (r->out.acct_handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_CreateAccount(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CreateAccount, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_EnumAccounts(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_EnumAccounts *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_ENUMACCOUNTS];

	r = talloc(talloc_tos(), struct lsa_EnumAccounts);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumAccounts, r);
	}

	ZERO_STRUCT(r->out);
	r->out.resume_handle = r->in.resume_handle;
	r->out.sids = talloc_zero(r, struct lsa_SidArray);
	if (r->out.sids == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_EnumAccounts(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumAccounts, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_CreateTrustedDomain(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_CreateTrustedDomain *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_CREATETRUSTEDDOMAIN];

	r = talloc(talloc_tos(), struct lsa_CreateTrustedDomain);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CreateTrustedDomain, r);
	}

	ZERO_STRUCT(r->out);
	r->out.trustdom_handle = talloc_zero(r, struct policy_handle);
	if (r->out.trustdom_handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_CreateTrustedDomain(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CreateTrustedDomain, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_EnumTrustDom(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_EnumTrustDom *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_ENUMTRUSTDOM];

	r = talloc(talloc_tos(), struct lsa_EnumTrustDom);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumTrustDom, r);
	}

	ZERO_STRUCT(r->out);
	r->out.resume_handle = r->in.resume_handle;
	r->out.domains = talloc_zero(r, struct lsa_DomainList);
	if (r->out.domains == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_EnumTrustDom(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumTrustDom, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_LookupNames(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_LookupNames *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_LOOKUPNAMES];

	r = talloc(talloc_tos(), struct lsa_LookupNames);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupNames, r);
	}

	ZERO_STRUCT(r->out);
	r->out.sids = r->in.sids;
	r->out.count = r->in.count;
	r->out.domains = talloc_zero(r, struct lsa_RefDomainList *);
	if (r->out.domains == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_LookupNames(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupNames, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_LookupSids(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_LookupSids *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_LOOKUPSIDS];

	r = talloc(talloc_tos(), struct lsa_LookupSids);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupSids, r);
	}

	ZERO_STRUCT(r->out);
	r->out.names = r->in.names;
	r->out.count = r->in.count;
	r->out.domains = talloc_zero(r, struct lsa_RefDomainList *);
	if (r->out.domains == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_LookupSids(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupSids, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_CreateSecret(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_CreateSecret *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_CREATESECRET];

	r = talloc(talloc_tos(), struct lsa_CreateSecret);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CreateSecret, r);
	}

	ZERO_STRUCT(r->out);
	r->out.sec_handle = talloc_zero(r, struct policy_handle);
	if (r->out.sec_handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_CreateSecret(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CreateSecret, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_OpenAccount(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_OpenAccount *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_OPENACCOUNT];

	r = talloc(talloc_tos(), struct lsa_OpenAccount);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_OpenAccount, r);
	}

	ZERO_STRUCT(r->out);
	r->out.acct_handle = talloc_zero(r, struct policy_handle);
	if (r->out.acct_handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_OpenAccount(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_OpenAccount, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_EnumPrivsAccount(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_EnumPrivsAccount *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_ENUMPRIVSACCOUNT];

	r = talloc(talloc_tos(), struct lsa_EnumPrivsAccount);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumPrivsAccount, r);
	}

	ZERO_STRUCT(r->out);
	r->out.privs = talloc_zero(r, struct lsa_PrivilegeSet *);
	if (r->out.privs == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_EnumPrivsAccount(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumPrivsAccount, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_AddPrivilegesToAccount(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_AddPrivilegesToAccount *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_ADDPRIVILEGESTOACCOUNT];

	r = talloc(talloc_tos(), struct lsa_AddPrivilegesToAccount);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_AddPrivilegesToAccount, r);
	}

	r->out.result = _lsa_AddPrivilegesToAccount(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_AddPrivilegesToAccount, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_RemovePrivilegesFromAccount(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_RemovePrivilegesFromAccount *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_REMOVEPRIVILEGESFROMACCOUNT];

	r = talloc(talloc_tos(), struct lsa_RemovePrivilegesFromAccount);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_RemovePrivilegesFromAccount, r);
	}

	r->out.result = _lsa_RemovePrivilegesFromAccount(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_RemovePrivilegesFromAccount, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_GetQuotasForAccount(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_GetQuotasForAccount *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_GETQUOTASFORACCOUNT];

	r = talloc(talloc_tos(), struct lsa_GetQuotasForAccount);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_GetQuotasForAccount, r);
	}

	r->out.result = _lsa_GetQuotasForAccount(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_GetQuotasForAccount, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_SetQuotasForAccount(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_SetQuotasForAccount *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_SETQUOTASFORACCOUNT];

	r = talloc(talloc_tos(), struct lsa_SetQuotasForAccount);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetQuotasForAccount, r);
	}

	r->out.result = _lsa_SetQuotasForAccount(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetQuotasForAccount, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_GetSystemAccessAccount(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_GetSystemAccessAccount *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_GETSYSTEMACCESSACCOUNT];

	r = talloc(talloc_tos(), struct lsa_GetSystemAccessAccount);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_GetSystemAccessAccount, r);
	}

	ZERO_STRUCT(r->out);
	r->out.access_mask = talloc_zero(r, uint32_t);
	if (r->out.access_mask == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_GetSystemAccessAccount(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_GetSystemAccessAccount, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_SetSystemAccessAccount(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_SetSystemAccessAccount *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_SETSYSTEMACCESSACCOUNT];

	r = talloc(talloc_tos(), struct lsa_SetSystemAccessAccount);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetSystemAccessAccount, r);
	}

	r->out.result = _lsa_SetSystemAccessAccount(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetSystemAccessAccount, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_OpenTrustedDomain(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_OpenTrustedDomain *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_OPENTRUSTEDDOMAIN];

	r = talloc(talloc_tos(), struct lsa_OpenTrustedDomain);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_OpenTrustedDomain, r);
	}

	ZERO_STRUCT(r->out);
	r->out.trustdom_handle = talloc_zero(r, struct policy_handle);
	if (r->out.trustdom_handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_OpenTrustedDomain(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_OpenTrustedDomain, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_QueryTrustedDomainInfo(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_QueryTrustedDomainInfo *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_QUERYTRUSTEDDOMAININFO];

	r = talloc(talloc_tos(), struct lsa_QueryTrustedDomainInfo);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QueryTrustedDomainInfo, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, union lsa_TrustedDomainInfo *);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_QueryTrustedDomainInfo(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QueryTrustedDomainInfo, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_SetInformationTrustedDomain(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_SetInformationTrustedDomain *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_SETINFORMATIONTRUSTEDDOMAIN];

	r = talloc(talloc_tos(), struct lsa_SetInformationTrustedDomain);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetInformationTrustedDomain, r);
	}

	r->out.result = _lsa_SetInformationTrustedDomain(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetInformationTrustedDomain, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_OpenSecret(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_OpenSecret *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_OPENSECRET];

	r = talloc(talloc_tos(), struct lsa_OpenSecret);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_OpenSecret, r);
	}

	ZERO_STRUCT(r->out);
	r->out.sec_handle = talloc_zero(r, struct policy_handle);
	if (r->out.sec_handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_OpenSecret(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_OpenSecret, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_SetSecret(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_SetSecret *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_SETSECRET];

	r = talloc(talloc_tos(), struct lsa_SetSecret);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetSecret, r);
	}

	r->out.result = _lsa_SetSecret(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetSecret, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_QuerySecret(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_QuerySecret *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_QUERYSECRET];

	r = talloc(talloc_tos(), struct lsa_QuerySecret);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QuerySecret, r);
	}

	ZERO_STRUCT(r->out);
	r->out.new_val = r->in.new_val;
	r->out.new_mtime = r->in.new_mtime;
	r->out.old_val = r->in.old_val;
	r->out.old_mtime = r->in.old_mtime;
	r->out.result = _lsa_QuerySecret(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QuerySecret, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_LookupPrivValue(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_LookupPrivValue *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_LOOKUPPRIVVALUE];

	r = talloc(talloc_tos(), struct lsa_LookupPrivValue);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupPrivValue, r);
	}

	ZERO_STRUCT(r->out);
	r->out.luid = talloc_zero(r, struct lsa_LUID);
	if (r->out.luid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_LookupPrivValue(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupPrivValue, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_LookupPrivName(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_LookupPrivName *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_LOOKUPPRIVNAME];

	r = talloc(talloc_tos(), struct lsa_LookupPrivName);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupPrivName, r);
	}

	ZERO_STRUCT(r->out);
	r->out.name = talloc_zero(r, struct lsa_StringLarge *);
	if (r->out.name == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_LookupPrivName(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupPrivName, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_LookupPrivDisplayName(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_LookupPrivDisplayName *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_LOOKUPPRIVDISPLAYNAME];

	r = talloc(talloc_tos(), struct lsa_LookupPrivDisplayName);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupPrivDisplayName, r);
	}

	ZERO_STRUCT(r->out);
	r->out.disp_name = talloc_zero(r, struct lsa_StringLarge *);
	if (r->out.disp_name == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.returned_language_id = talloc_zero(r, uint16_t);
	if (r->out.returned_language_id == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_LookupPrivDisplayName(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupPrivDisplayName, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_DeleteObject(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_DeleteObject *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_DELETEOBJECT];

	r = talloc(talloc_tos(), struct lsa_DeleteObject);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_DeleteObject, r);
	}

	ZERO_STRUCT(r->out);
	r->out.handle = r->in.handle;
	r->out.result = _lsa_DeleteObject(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_DeleteObject, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_EnumAccountsWithUserRight(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_EnumAccountsWithUserRight *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_ENUMACCOUNTSWITHUSERRIGHT];

	r = talloc(talloc_tos(), struct lsa_EnumAccountsWithUserRight);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumAccountsWithUserRight, r);
	}

	ZERO_STRUCT(r->out);
	r->out.sids = talloc_zero(r, struct lsa_SidArray);
	if (r->out.sids == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_EnumAccountsWithUserRight(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumAccountsWithUserRight, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_EnumAccountRights(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_EnumAccountRights *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_ENUMACCOUNTRIGHTS];

	r = talloc(talloc_tos(), struct lsa_EnumAccountRights);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumAccountRights, r);
	}

	ZERO_STRUCT(r->out);
	r->out.rights = talloc_zero(r, struct lsa_RightSet);
	if (r->out.rights == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_EnumAccountRights(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumAccountRights, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_AddAccountRights(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_AddAccountRights *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_ADDACCOUNTRIGHTS];

	r = talloc(talloc_tos(), struct lsa_AddAccountRights);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_AddAccountRights, r);
	}

	r->out.result = _lsa_AddAccountRights(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_AddAccountRights, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_RemoveAccountRights(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_RemoveAccountRights *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_REMOVEACCOUNTRIGHTS];

	r = talloc(talloc_tos(), struct lsa_RemoveAccountRights);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_RemoveAccountRights, r);
	}

	r->out.result = _lsa_RemoveAccountRights(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_RemoveAccountRights, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_QueryTrustedDomainInfoBySid(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_QueryTrustedDomainInfoBySid *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_QUERYTRUSTEDDOMAININFOBYSID];

	r = talloc(talloc_tos(), struct lsa_QueryTrustedDomainInfoBySid);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QueryTrustedDomainInfoBySid, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, union lsa_TrustedDomainInfo *);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_QueryTrustedDomainInfoBySid(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QueryTrustedDomainInfoBySid, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_SetTrustedDomainInfo(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_SetTrustedDomainInfo *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_SETTRUSTEDDOMAININFO];

	r = talloc(talloc_tos(), struct lsa_SetTrustedDomainInfo);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetTrustedDomainInfo, r);
	}

	r->out.result = _lsa_SetTrustedDomainInfo(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetTrustedDomainInfo, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_DeleteTrustedDomain(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_DeleteTrustedDomain *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_DELETETRUSTEDDOMAIN];

	r = talloc(talloc_tos(), struct lsa_DeleteTrustedDomain);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_DeleteTrustedDomain, r);
	}

	r->out.result = _lsa_DeleteTrustedDomain(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_DeleteTrustedDomain, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_StorePrivateData(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_StorePrivateData *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_STOREPRIVATEDATA];

	r = talloc(talloc_tos(), struct lsa_StorePrivateData);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_StorePrivateData, r);
	}

	r->out.result = _lsa_StorePrivateData(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_StorePrivateData, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_RetrievePrivateData(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_RetrievePrivateData *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_RETRIEVEPRIVATEDATA];

	r = talloc(talloc_tos(), struct lsa_RetrievePrivateData);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_RetrievePrivateData, r);
	}

	r->out.result = _lsa_RetrievePrivateData(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_RetrievePrivateData, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_OpenPolicy2(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_OpenPolicy2 *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_OPENPOLICY2];

	r = talloc(talloc_tos(), struct lsa_OpenPolicy2);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_OpenPolicy2, r);
	}

	ZERO_STRUCT(r->out);
	r->out.handle = talloc_zero(r, struct policy_handle);
	if (r->out.handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_OpenPolicy2(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_OpenPolicy2, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_GetUserName(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_GetUserName *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_GETUSERNAME];

	r = talloc(talloc_tos(), struct lsa_GetUserName);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_GetUserName, r);
	}

	ZERO_STRUCT(r->out);
	r->out.account_name = r->in.account_name;
	r->out.authority_name = r->in.authority_name;
	r->out.result = _lsa_GetUserName(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_GetUserName, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_QueryInfoPolicy2(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_QueryInfoPolicy2 *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_QUERYINFOPOLICY2];

	r = talloc(talloc_tos(), struct lsa_QueryInfoPolicy2);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QueryInfoPolicy2, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, union lsa_PolicyInformation *);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_QueryInfoPolicy2(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QueryInfoPolicy2, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_SetInfoPolicy2(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_SetInfoPolicy2 *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_SETINFOPOLICY2];

	r = talloc(talloc_tos(), struct lsa_SetInfoPolicy2);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetInfoPolicy2, r);
	}

	r->out.result = _lsa_SetInfoPolicy2(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetInfoPolicy2, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_QueryTrustedDomainInfoByName(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_QueryTrustedDomainInfoByName *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_QUERYTRUSTEDDOMAININFOBYNAME];

	r = talloc(talloc_tos(), struct lsa_QueryTrustedDomainInfoByName);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QueryTrustedDomainInfoByName, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, union lsa_TrustedDomainInfo *);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_QueryTrustedDomainInfoByName(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QueryTrustedDomainInfoByName, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_SetTrustedDomainInfoByName(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_SetTrustedDomainInfoByName *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_SETTRUSTEDDOMAININFOBYNAME];

	r = talloc(talloc_tos(), struct lsa_SetTrustedDomainInfoByName);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetTrustedDomainInfoByName, r);
	}

	r->out.result = _lsa_SetTrustedDomainInfoByName(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetTrustedDomainInfoByName, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_EnumTrustedDomainsEx(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_EnumTrustedDomainsEx *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_ENUMTRUSTEDDOMAINSEX];

	r = talloc(talloc_tos(), struct lsa_EnumTrustedDomainsEx);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumTrustedDomainsEx, r);
	}

	ZERO_STRUCT(r->out);
	r->out.resume_handle = r->in.resume_handle;
	r->out.domains = talloc_zero(r, struct lsa_DomainListEx);
	if (r->out.domains == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_EnumTrustedDomainsEx(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumTrustedDomainsEx, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_CreateTrustedDomainEx(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_CreateTrustedDomainEx *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_CREATETRUSTEDDOMAINEX];

	r = talloc(talloc_tos(), struct lsa_CreateTrustedDomainEx);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CreateTrustedDomainEx, r);
	}

	ZERO_STRUCT(r->out);
	r->out.trustdom_handle = talloc_zero(r, struct policy_handle);
	if (r->out.trustdom_handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_CreateTrustedDomainEx(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CreateTrustedDomainEx, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_CloseTrustedDomainEx(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_CloseTrustedDomainEx *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_CLOSETRUSTEDDOMAINEX];

	r = talloc(talloc_tos(), struct lsa_CloseTrustedDomainEx);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CloseTrustedDomainEx, r);
	}

	ZERO_STRUCT(r->out);
	r->out.handle = r->in.handle;
	r->out.result = _lsa_CloseTrustedDomainEx(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CloseTrustedDomainEx, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_QueryDomainInformationPolicy(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_QueryDomainInformationPolicy *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_QUERYDOMAININFORMATIONPOLICY];

	r = talloc(talloc_tos(), struct lsa_QueryDomainInformationPolicy);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QueryDomainInformationPolicy, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, union lsa_DomainInformationPolicy *);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_QueryDomainInformationPolicy(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QueryDomainInformationPolicy, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_SetDomainInformationPolicy(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_SetDomainInformationPolicy *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_SETDOMAININFORMATIONPOLICY];

	r = talloc(talloc_tos(), struct lsa_SetDomainInformationPolicy);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetDomainInformationPolicy, r);
	}

	r->out.result = _lsa_SetDomainInformationPolicy(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetDomainInformationPolicy, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_OpenTrustedDomainByName(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_OpenTrustedDomainByName *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_OPENTRUSTEDDOMAINBYNAME];

	r = talloc(talloc_tos(), struct lsa_OpenTrustedDomainByName);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_OpenTrustedDomainByName, r);
	}

	ZERO_STRUCT(r->out);
	r->out.trustdom_handle = talloc_zero(r, struct policy_handle);
	if (r->out.trustdom_handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_OpenTrustedDomainByName(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_OpenTrustedDomainByName, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_TestCall(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_TestCall *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_TESTCALL];

	r = talloc(talloc_tos(), struct lsa_TestCall);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_TestCall, r);
	}

	r->out.result = _lsa_TestCall(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_TestCall, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_LookupSids2(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_LookupSids2 *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_LOOKUPSIDS2];

	r = talloc(talloc_tos(), struct lsa_LookupSids2);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupSids2, r);
	}

	ZERO_STRUCT(r->out);
	r->out.names = r->in.names;
	r->out.count = r->in.count;
	r->out.domains = talloc_zero(r, struct lsa_RefDomainList *);
	if (r->out.domains == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_LookupSids2(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupSids2, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_LookupNames2(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_LookupNames2 *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_LOOKUPNAMES2];

	r = talloc(talloc_tos(), struct lsa_LookupNames2);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupNames2, r);
	}

	ZERO_STRUCT(r->out);
	r->out.sids = r->in.sids;
	r->out.count = r->in.count;
	r->out.domains = talloc_zero(r, struct lsa_RefDomainList *);
	if (r->out.domains == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_LookupNames2(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupNames2, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_CreateTrustedDomainEx2(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_CreateTrustedDomainEx2 *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_CREATETRUSTEDDOMAINEX2];

	r = talloc(talloc_tos(), struct lsa_CreateTrustedDomainEx2);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CreateTrustedDomainEx2, r);
	}

	ZERO_STRUCT(r->out);
	r->out.trustdom_handle = talloc_zero(r, struct policy_handle);
	if (r->out.trustdom_handle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_CreateTrustedDomainEx2(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CreateTrustedDomainEx2, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_CREDRWRITE(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_CREDRWRITE *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_CREDRWRITE];

	r = talloc(talloc_tos(), struct lsa_CREDRWRITE);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRWRITE, r);
	}

	r->out.result = _lsa_CREDRWRITE(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRWRITE, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_CREDRREAD(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_CREDRREAD *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_CREDRREAD];

	r = talloc(talloc_tos(), struct lsa_CREDRREAD);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRREAD, r);
	}

	r->out.result = _lsa_CREDRREAD(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRREAD, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_CREDRENUMERATE(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_CREDRENUMERATE *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_CREDRENUMERATE];

	r = talloc(talloc_tos(), struct lsa_CREDRENUMERATE);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRENUMERATE, r);
	}

	r->out.result = _lsa_CREDRENUMERATE(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRENUMERATE, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_CREDRWRITEDOMAINCREDENTIALS(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_CREDRWRITEDOMAINCREDENTIALS *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_CREDRWRITEDOMAINCREDENTIALS];

	r = talloc(talloc_tos(), struct lsa_CREDRWRITEDOMAINCREDENTIALS);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRWRITEDOMAINCREDENTIALS, r);
	}

	r->out.result = _lsa_CREDRWRITEDOMAINCREDENTIALS(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRWRITEDOMAINCREDENTIALS, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_CREDRREADDOMAINCREDENTIALS(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_CREDRREADDOMAINCREDENTIALS *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_CREDRREADDOMAINCREDENTIALS];

	r = talloc(talloc_tos(), struct lsa_CREDRREADDOMAINCREDENTIALS);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRREADDOMAINCREDENTIALS, r);
	}

	r->out.result = _lsa_CREDRREADDOMAINCREDENTIALS(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRREADDOMAINCREDENTIALS, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_CREDRDELETE(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_CREDRDELETE *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_CREDRDELETE];

	r = talloc(talloc_tos(), struct lsa_CREDRDELETE);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRDELETE, r);
	}

	r->out.result = _lsa_CREDRDELETE(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRDELETE, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_CREDRGETTARGETINFO(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_CREDRGETTARGETINFO *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_CREDRGETTARGETINFO];

	r = talloc(talloc_tos(), struct lsa_CREDRGETTARGETINFO);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRGETTARGETINFO, r);
	}

	r->out.result = _lsa_CREDRGETTARGETINFO(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRGETTARGETINFO, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_CREDRPROFILELOADED(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_CREDRPROFILELOADED *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_CREDRPROFILELOADED];

	r = talloc(talloc_tos(), struct lsa_CREDRPROFILELOADED);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRPROFILELOADED, r);
	}

	r->out.result = _lsa_CREDRPROFILELOADED(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRPROFILELOADED, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_LookupNames3(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_LookupNames3 *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_LOOKUPNAMES3];

	r = talloc(talloc_tos(), struct lsa_LookupNames3);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupNames3, r);
	}

	ZERO_STRUCT(r->out);
	r->out.sids = r->in.sids;
	r->out.count = r->in.count;
	r->out.domains = talloc_zero(r, struct lsa_RefDomainList *);
	if (r->out.domains == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_LookupNames3(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupNames3, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_CREDRGETSESSIONTYPES(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_CREDRGETSESSIONTYPES *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_CREDRGETSESSIONTYPES];

	r = talloc(talloc_tos(), struct lsa_CREDRGETSESSIONTYPES);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRGETSESSIONTYPES, r);
	}

	r->out.result = _lsa_CREDRGETSESSIONTYPES(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRGETSESSIONTYPES, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_LSARREGISTERAUDITEVENT(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_LSARREGISTERAUDITEVENT *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_LSARREGISTERAUDITEVENT];

	r = talloc(talloc_tos(), struct lsa_LSARREGISTERAUDITEVENT);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARREGISTERAUDITEVENT, r);
	}

	r->out.result = _lsa_LSARREGISTERAUDITEVENT(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARREGISTERAUDITEVENT, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_LSARGENAUDITEVENT(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_LSARGENAUDITEVENT *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_LSARGENAUDITEVENT];

	r = talloc(talloc_tos(), struct lsa_LSARGENAUDITEVENT);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARGENAUDITEVENT, r);
	}

	r->out.result = _lsa_LSARGENAUDITEVENT(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARGENAUDITEVENT, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_LSARUNREGISTERAUDITEVENT(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_LSARUNREGISTERAUDITEVENT *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_LSARUNREGISTERAUDITEVENT];

	r = talloc(talloc_tos(), struct lsa_LSARUNREGISTERAUDITEVENT);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARUNREGISTERAUDITEVENT, r);
	}

	r->out.result = _lsa_LSARUNREGISTERAUDITEVENT(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARUNREGISTERAUDITEVENT, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_lsaRQueryForestTrustInformation(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_lsaRQueryForestTrustInformation *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_LSARQUERYFORESTTRUSTINFORMATION];

	r = talloc(talloc_tos(), struct lsa_lsaRQueryForestTrustInformation);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_lsaRQueryForestTrustInformation, r);
	}

	ZERO_STRUCT(r->out);
	r->out.forest_trust_info = talloc_zero(r, struct lsa_ForestTrustInformation *);
	if (r->out.forest_trust_info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_lsaRQueryForestTrustInformation(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_lsaRQueryForestTrustInformation, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_LSARSETFORESTTRUSTINFORMATION(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_LSARSETFORESTTRUSTINFORMATION *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_LSARSETFORESTTRUSTINFORMATION];

	r = talloc(talloc_tos(), struct lsa_LSARSETFORESTTRUSTINFORMATION);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARSETFORESTTRUSTINFORMATION, r);
	}

	r->out.result = _lsa_LSARSETFORESTTRUSTINFORMATION(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARSETFORESTTRUSTINFORMATION, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_CREDRRENAME(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_CREDRRENAME *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_CREDRRENAME];

	r = talloc(talloc_tos(), struct lsa_CREDRRENAME);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRRENAME, r);
	}

	r->out.result = _lsa_CREDRRENAME(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRRENAME, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_LookupSids3(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_LookupSids3 *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_LOOKUPSIDS3];

	r = talloc(talloc_tos(), struct lsa_LookupSids3);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupSids3, r);
	}

	ZERO_STRUCT(r->out);
	r->out.names = r->in.names;
	r->out.count = r->in.count;
	r->out.domains = talloc_zero(r, struct lsa_RefDomainList *);
	if (r->out.domains == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_LookupSids3(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupSids3, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_LookupNames4(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_LookupNames4 *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_LOOKUPNAMES4];

	r = talloc(talloc_tos(), struct lsa_LookupNames4);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupNames4, r);
	}

	ZERO_STRUCT(r->out);
	r->out.sids = r->in.sids;
	r->out.count = r->in.count;
	r->out.domains = talloc_zero(r, struct lsa_RefDomainList *);
	if (r->out.domains == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _lsa_LookupNames4(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupNames4, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_LSAROPENPOLICYSCE(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_LSAROPENPOLICYSCE *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_LSAROPENPOLICYSCE];

	r = talloc(talloc_tos(), struct lsa_LSAROPENPOLICYSCE);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSAROPENPOLICYSCE, r);
	}

	r->out.result = _lsa_LSAROPENPOLICYSCE(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSAROPENPOLICYSCE, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_LSARADTREGISTERSECURITYEVENTSOURCE(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_LSARADTREGISTERSECURITYEVENTSOURCE *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_LSARADTREGISTERSECURITYEVENTSOURCE];

	r = talloc(talloc_tos(), struct lsa_LSARADTREGISTERSECURITYEVENTSOURCE);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARADTREGISTERSECURITYEVENTSOURCE, r);
	}

	r->out.result = _lsa_LSARADTREGISTERSECURITYEVENTSOURCE(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARADTREGISTERSECURITYEVENTSOURCE, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_LSARADTUNREGISTERSECURITYEVENTSOURCE];

	r = talloc(talloc_tos(), struct lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE, r);
	}

	r->out.result = _lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_lsa_LSARADTREPORTSECURITYEVENT(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct lsa_LSARADTREPORTSECURITYEVENT *r;

	call = &ndr_table_lsarpc.calls[NDR_LSA_LSARADTREPORTSECURITYEVENT];

	r = talloc(talloc_tos(), struct lsa_LSARADTREPORTSECURITYEVENT);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARADTREPORTSECURITYEVENT, r);
	}

	r->out.result = _lsa_LSARADTREPORTSECURITYEVENT(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARADTREPORTSECURITYEVENT, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_lsarpc_cmds[] = 
{
	{"LSA_CLOSE", NDR_LSA_CLOSE, api_lsa_Close},
	{"LSA_DELETE", NDR_LSA_DELETE, api_lsa_Delete},
	{"LSA_ENUMPRIVS", NDR_LSA_ENUMPRIVS, api_lsa_EnumPrivs},
	{"LSA_QUERYSECURITY", NDR_LSA_QUERYSECURITY, api_lsa_QuerySecurity},
	{"LSA_SETSECOBJ", NDR_LSA_SETSECOBJ, api_lsa_SetSecObj},
	{"LSA_CHANGEPASSWORD", NDR_LSA_CHANGEPASSWORD, api_lsa_ChangePassword},
	{"LSA_OPENPOLICY", NDR_LSA_OPENPOLICY, api_lsa_OpenPolicy},
	{"LSA_QUERYINFOPOLICY", NDR_LSA_QUERYINFOPOLICY, api_lsa_QueryInfoPolicy},
	{"LSA_SETINFOPOLICY", NDR_LSA_SETINFOPOLICY, api_lsa_SetInfoPolicy},
	{"LSA_CLEARAUDITLOG", NDR_LSA_CLEARAUDITLOG, api_lsa_ClearAuditLog},
	{"LSA_CREATEACCOUNT", NDR_LSA_CREATEACCOUNT, api_lsa_CreateAccount},
	{"LSA_ENUMACCOUNTS", NDR_LSA_ENUMACCOUNTS, api_lsa_EnumAccounts},
	{"LSA_CREATETRUSTEDDOMAIN", NDR_LSA_CREATETRUSTEDDOMAIN, api_lsa_CreateTrustedDomain},
	{"LSA_ENUMTRUSTDOM", NDR_LSA_ENUMTRUSTDOM, api_lsa_EnumTrustDom},
	{"LSA_LOOKUPNAMES", NDR_LSA_LOOKUPNAMES, api_lsa_LookupNames},
	{"LSA_LOOKUPSIDS", NDR_LSA_LOOKUPSIDS, api_lsa_LookupSids},
	{"LSA_CREATESECRET", NDR_LSA_CREATESECRET, api_lsa_CreateSecret},
	{"LSA_OPENACCOUNT", NDR_LSA_OPENACCOUNT, api_lsa_OpenAccount},
	{"LSA_ENUMPRIVSACCOUNT", NDR_LSA_ENUMPRIVSACCOUNT, api_lsa_EnumPrivsAccount},
	{"LSA_ADDPRIVILEGESTOACCOUNT", NDR_LSA_ADDPRIVILEGESTOACCOUNT, api_lsa_AddPrivilegesToAccount},
	{"LSA_REMOVEPRIVILEGESFROMACCOUNT", NDR_LSA_REMOVEPRIVILEGESFROMACCOUNT, api_lsa_RemovePrivilegesFromAccount},
	{"LSA_GETQUOTASFORACCOUNT", NDR_LSA_GETQUOTASFORACCOUNT, api_lsa_GetQuotasForAccount},
	{"LSA_SETQUOTASFORACCOUNT", NDR_LSA_SETQUOTASFORACCOUNT, api_lsa_SetQuotasForAccount},
	{"LSA_GETSYSTEMACCESSACCOUNT", NDR_LSA_GETSYSTEMACCESSACCOUNT, api_lsa_GetSystemAccessAccount},
	{"LSA_SETSYSTEMACCESSACCOUNT", NDR_LSA_SETSYSTEMACCESSACCOUNT, api_lsa_SetSystemAccessAccount},
	{"LSA_OPENTRUSTEDDOMAIN", NDR_LSA_OPENTRUSTEDDOMAIN, api_lsa_OpenTrustedDomain},
	{"LSA_QUERYTRUSTEDDOMAININFO", NDR_LSA_QUERYTRUSTEDDOMAININFO, api_lsa_QueryTrustedDomainInfo},
	{"LSA_SETINFORMATIONTRUSTEDDOMAIN", NDR_LSA_SETINFORMATIONTRUSTEDDOMAIN, api_lsa_SetInformationTrustedDomain},
	{"LSA_OPENSECRET", NDR_LSA_OPENSECRET, api_lsa_OpenSecret},
	{"LSA_SETSECRET", NDR_LSA_SETSECRET, api_lsa_SetSecret},
	{"LSA_QUERYSECRET", NDR_LSA_QUERYSECRET, api_lsa_QuerySecret},
	{"LSA_LOOKUPPRIVVALUE", NDR_LSA_LOOKUPPRIVVALUE, api_lsa_LookupPrivValue},
	{"LSA_LOOKUPPRIVNAME", NDR_LSA_LOOKUPPRIVNAME, api_lsa_LookupPrivName},
	{"LSA_LOOKUPPRIVDISPLAYNAME", NDR_LSA_LOOKUPPRIVDISPLAYNAME, api_lsa_LookupPrivDisplayName},
	{"LSA_DELETEOBJECT", NDR_LSA_DELETEOBJECT, api_lsa_DeleteObject},
	{"LSA_ENUMACCOUNTSWITHUSERRIGHT", NDR_LSA_ENUMACCOUNTSWITHUSERRIGHT, api_lsa_EnumAccountsWithUserRight},
	{"LSA_ENUMACCOUNTRIGHTS", NDR_LSA_ENUMACCOUNTRIGHTS, api_lsa_EnumAccountRights},
	{"LSA_ADDACCOUNTRIGHTS", NDR_LSA_ADDACCOUNTRIGHTS, api_lsa_AddAccountRights},
	{"LSA_REMOVEACCOUNTRIGHTS", NDR_LSA_REMOVEACCOUNTRIGHTS, api_lsa_RemoveAccountRights},
	{"LSA_QUERYTRUSTEDDOMAININFOBYSID", NDR_LSA_QUERYTRUSTEDDOMAININFOBYSID, api_lsa_QueryTrustedDomainInfoBySid},
	{"LSA_SETTRUSTEDDOMAININFO", NDR_LSA_SETTRUSTEDDOMAININFO, api_lsa_SetTrustedDomainInfo},
	{"LSA_DELETETRUSTEDDOMAIN", NDR_LSA_DELETETRUSTEDDOMAIN, api_lsa_DeleteTrustedDomain},
	{"LSA_STOREPRIVATEDATA", NDR_LSA_STOREPRIVATEDATA, api_lsa_StorePrivateData},
	{"LSA_RETRIEVEPRIVATEDATA", NDR_LSA_RETRIEVEPRIVATEDATA, api_lsa_RetrievePrivateData},
	{"LSA_OPENPOLICY2", NDR_LSA_OPENPOLICY2, api_lsa_OpenPolicy2},
	{"LSA_GETUSERNAME", NDR_LSA_GETUSERNAME, api_lsa_GetUserName},
	{"LSA_QUERYINFOPOLICY2", NDR_LSA_QUERYINFOPOLICY2, api_lsa_QueryInfoPolicy2},
	{"LSA_SETINFOPOLICY2", NDR_LSA_SETINFOPOLICY2, api_lsa_SetInfoPolicy2},
	{"LSA_QUERYTRUSTEDDOMAININFOBYNAME", NDR_LSA_QUERYTRUSTEDDOMAININFOBYNAME, api_lsa_QueryTrustedDomainInfoByName},
	{"LSA_SETTRUSTEDDOMAININFOBYNAME", NDR_LSA_SETTRUSTEDDOMAININFOBYNAME, api_lsa_SetTrustedDomainInfoByName},
	{"LSA_ENUMTRUSTEDDOMAINSEX", NDR_LSA_ENUMTRUSTEDDOMAINSEX, api_lsa_EnumTrustedDomainsEx},
	{"LSA_CREATETRUSTEDDOMAINEX", NDR_LSA_CREATETRUSTEDDOMAINEX, api_lsa_CreateTrustedDomainEx},
	{"LSA_CLOSETRUSTEDDOMAINEX", NDR_LSA_CLOSETRUSTEDDOMAINEX, api_lsa_CloseTrustedDomainEx},
	{"LSA_QUERYDOMAININFORMATIONPOLICY", NDR_LSA_QUERYDOMAININFORMATIONPOLICY, api_lsa_QueryDomainInformationPolicy},
	{"LSA_SETDOMAININFORMATIONPOLICY", NDR_LSA_SETDOMAININFORMATIONPOLICY, api_lsa_SetDomainInformationPolicy},
	{"LSA_OPENTRUSTEDDOMAINBYNAME", NDR_LSA_OPENTRUSTEDDOMAINBYNAME, api_lsa_OpenTrustedDomainByName},
	{"LSA_TESTCALL", NDR_LSA_TESTCALL, api_lsa_TestCall},
	{"LSA_LOOKUPSIDS2", NDR_LSA_LOOKUPSIDS2, api_lsa_LookupSids2},
	{"LSA_LOOKUPNAMES2", NDR_LSA_LOOKUPNAMES2, api_lsa_LookupNames2},
	{"LSA_CREATETRUSTEDDOMAINEX2", NDR_LSA_CREATETRUSTEDDOMAINEX2, api_lsa_CreateTrustedDomainEx2},
	{"LSA_CREDRWRITE", NDR_LSA_CREDRWRITE, api_lsa_CREDRWRITE},
	{"LSA_CREDRREAD", NDR_LSA_CREDRREAD, api_lsa_CREDRREAD},
	{"LSA_CREDRENUMERATE", NDR_LSA_CREDRENUMERATE, api_lsa_CREDRENUMERATE},
	{"LSA_CREDRWRITEDOMAINCREDENTIALS", NDR_LSA_CREDRWRITEDOMAINCREDENTIALS, api_lsa_CREDRWRITEDOMAINCREDENTIALS},
	{"LSA_CREDRREADDOMAINCREDENTIALS", NDR_LSA_CREDRREADDOMAINCREDENTIALS, api_lsa_CREDRREADDOMAINCREDENTIALS},
	{"LSA_CREDRDELETE", NDR_LSA_CREDRDELETE, api_lsa_CREDRDELETE},
	{"LSA_CREDRGETTARGETINFO", NDR_LSA_CREDRGETTARGETINFO, api_lsa_CREDRGETTARGETINFO},
	{"LSA_CREDRPROFILELOADED", NDR_LSA_CREDRPROFILELOADED, api_lsa_CREDRPROFILELOADED},
	{"LSA_LOOKUPNAMES3", NDR_LSA_LOOKUPNAMES3, api_lsa_LookupNames3},
	{"LSA_CREDRGETSESSIONTYPES", NDR_LSA_CREDRGETSESSIONTYPES, api_lsa_CREDRGETSESSIONTYPES},
	{"LSA_LSARREGISTERAUDITEVENT", NDR_LSA_LSARREGISTERAUDITEVENT, api_lsa_LSARREGISTERAUDITEVENT},
	{"LSA_LSARGENAUDITEVENT", NDR_LSA_LSARGENAUDITEVENT, api_lsa_LSARGENAUDITEVENT},
	{"LSA_LSARUNREGISTERAUDITEVENT", NDR_LSA_LSARUNREGISTERAUDITEVENT, api_lsa_LSARUNREGISTERAUDITEVENT},
	{"LSA_LSARQUERYFORESTTRUSTINFORMATION", NDR_LSA_LSARQUERYFORESTTRUSTINFORMATION, api_lsa_lsaRQueryForestTrustInformation},
	{"LSA_LSARSETFORESTTRUSTINFORMATION", NDR_LSA_LSARSETFORESTTRUSTINFORMATION, api_lsa_LSARSETFORESTTRUSTINFORMATION},
	{"LSA_CREDRRENAME", NDR_LSA_CREDRRENAME, api_lsa_CREDRRENAME},
	{"LSA_LOOKUPSIDS3", NDR_LSA_LOOKUPSIDS3, api_lsa_LookupSids3},
	{"LSA_LOOKUPNAMES4", NDR_LSA_LOOKUPNAMES4, api_lsa_LookupNames4},
	{"LSA_LSAROPENPOLICYSCE", NDR_LSA_LSAROPENPOLICYSCE, api_lsa_LSAROPENPOLICYSCE},
	{"LSA_LSARADTREGISTERSECURITYEVENTSOURCE", NDR_LSA_LSARADTREGISTERSECURITYEVENTSOURCE, api_lsa_LSARADTREGISTERSECURITYEVENTSOURCE},
	{"LSA_LSARADTUNREGISTERSECURITYEVENTSOURCE", NDR_LSA_LSARADTUNREGISTERSECURITYEVENTSOURCE, api_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE},
	{"LSA_LSARADTREPORTSECURITYEVENT", NDR_LSA_LSARADTREPORTSECURITYEVENT, api_lsa_LSARADTREPORTSECURITYEVENT},
};

void lsarpc_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_lsarpc_cmds;
	*n_fns = sizeof(api_lsarpc_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_lsarpc_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_LSA_CLOSE: {
			struct lsa_Close *r = (struct lsa_Close *)_r;
			ZERO_STRUCT(r->out);
			r->out.handle = r->in.handle;
			r->out.result = _lsa_Close(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_DELETE: {
			struct lsa_Delete *r = (struct lsa_Delete *)_r;
			r->out.result = _lsa_Delete(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_ENUMPRIVS: {
			struct lsa_EnumPrivs *r = (struct lsa_EnumPrivs *)_r;
			ZERO_STRUCT(r->out);
			r->out.resume_handle = r->in.resume_handle;
			r->out.privs = talloc_zero(mem_ctx, struct lsa_PrivArray);
			if (r->out.privs == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_EnumPrivs(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_QUERYSECURITY: {
			struct lsa_QuerySecurity *r = (struct lsa_QuerySecurity *)_r;
			ZERO_STRUCT(r->out);
			r->out.sdbuf = talloc_zero(mem_ctx, struct sec_desc_buf *);
			if (r->out.sdbuf == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_QuerySecurity(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_SETSECOBJ: {
			struct lsa_SetSecObj *r = (struct lsa_SetSecObj *)_r;
			r->out.result = _lsa_SetSecObj(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_CHANGEPASSWORD: {
			struct lsa_ChangePassword *r = (struct lsa_ChangePassword *)_r;
			r->out.result = _lsa_ChangePassword(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_OPENPOLICY: {
			struct lsa_OpenPolicy *r = (struct lsa_OpenPolicy *)_r;
			ZERO_STRUCT(r->out);
			r->out.handle = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.handle == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_OpenPolicy(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_QUERYINFOPOLICY: {
			struct lsa_QueryInfoPolicy *r = (struct lsa_QueryInfoPolicy *)_r;
			ZERO_STRUCT(r->out);
			r->out.info = talloc_zero(mem_ctx, union lsa_PolicyInformation *);
			if (r->out.info == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_QueryInfoPolicy(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_SETINFOPOLICY: {
			struct lsa_SetInfoPolicy *r = (struct lsa_SetInfoPolicy *)_r;
			r->out.result = _lsa_SetInfoPolicy(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_CLEARAUDITLOG: {
			struct lsa_ClearAuditLog *r = (struct lsa_ClearAuditLog *)_r;
			r->out.result = _lsa_ClearAuditLog(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_CREATEACCOUNT: {
			struct lsa_CreateAccount *r = (struct lsa_CreateAccount *)_r;
			ZERO_STRUCT(r->out);
			r->out.acct_handle = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.acct_handle == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_CreateAccount(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_ENUMACCOUNTS: {
			struct lsa_EnumAccounts *r = (struct lsa_EnumAccounts *)_r;
			ZERO_STRUCT(r->out);
			r->out.resume_handle = r->in.resume_handle;
			r->out.sids = talloc_zero(mem_ctx, struct lsa_SidArray);
			if (r->out.sids == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_EnumAccounts(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_CREATETRUSTEDDOMAIN: {
			struct lsa_CreateTrustedDomain *r = (struct lsa_CreateTrustedDomain *)_r;
			ZERO_STRUCT(r->out);
			r->out.trustdom_handle = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.trustdom_handle == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_CreateTrustedDomain(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_ENUMTRUSTDOM: {
			struct lsa_EnumTrustDom *r = (struct lsa_EnumTrustDom *)_r;
			ZERO_STRUCT(r->out);
			r->out.resume_handle = r->in.resume_handle;
			r->out.domains = talloc_zero(mem_ctx, struct lsa_DomainList);
			if (r->out.domains == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_EnumTrustDom(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_LOOKUPNAMES: {
			struct lsa_LookupNames *r = (struct lsa_LookupNames *)_r;
			ZERO_STRUCT(r->out);
			r->out.sids = r->in.sids;
			r->out.count = r->in.count;
			r->out.domains = talloc_zero(mem_ctx, struct lsa_RefDomainList *);
			if (r->out.domains == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_LookupNames(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_LOOKUPSIDS: {
			struct lsa_LookupSids *r = (struct lsa_LookupSids *)_r;
			ZERO_STRUCT(r->out);
			r->out.names = r->in.names;
			r->out.count = r->in.count;
			r->out.domains = talloc_zero(mem_ctx, struct lsa_RefDomainList *);
			if (r->out.domains == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_LookupSids(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_CREATESECRET: {
			struct lsa_CreateSecret *r = (struct lsa_CreateSecret *)_r;
			ZERO_STRUCT(r->out);
			r->out.sec_handle = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.sec_handle == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_CreateSecret(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_OPENACCOUNT: {
			struct lsa_OpenAccount *r = (struct lsa_OpenAccount *)_r;
			ZERO_STRUCT(r->out);
			r->out.acct_handle = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.acct_handle == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_OpenAccount(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_ENUMPRIVSACCOUNT: {
			struct lsa_EnumPrivsAccount *r = (struct lsa_EnumPrivsAccount *)_r;
			ZERO_STRUCT(r->out);
			r->out.privs = talloc_zero(mem_ctx, struct lsa_PrivilegeSet *);
			if (r->out.privs == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_EnumPrivsAccount(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_ADDPRIVILEGESTOACCOUNT: {
			struct lsa_AddPrivilegesToAccount *r = (struct lsa_AddPrivilegesToAccount *)_r;
			r->out.result = _lsa_AddPrivilegesToAccount(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_REMOVEPRIVILEGESFROMACCOUNT: {
			struct lsa_RemovePrivilegesFromAccount *r = (struct lsa_RemovePrivilegesFromAccount *)_r;
			r->out.result = _lsa_RemovePrivilegesFromAccount(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_GETQUOTASFORACCOUNT: {
			struct lsa_GetQuotasForAccount *r = (struct lsa_GetQuotasForAccount *)_r;
			r->out.result = _lsa_GetQuotasForAccount(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_SETQUOTASFORACCOUNT: {
			struct lsa_SetQuotasForAccount *r = (struct lsa_SetQuotasForAccount *)_r;
			r->out.result = _lsa_SetQuotasForAccount(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_GETSYSTEMACCESSACCOUNT: {
			struct lsa_GetSystemAccessAccount *r = (struct lsa_GetSystemAccessAccount *)_r;
			ZERO_STRUCT(r->out);
			r->out.access_mask = talloc_zero(mem_ctx, uint32_t);
			if (r->out.access_mask == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_GetSystemAccessAccount(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_SETSYSTEMACCESSACCOUNT: {
			struct lsa_SetSystemAccessAccount *r = (struct lsa_SetSystemAccessAccount *)_r;
			r->out.result = _lsa_SetSystemAccessAccount(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_OPENTRUSTEDDOMAIN: {
			struct lsa_OpenTrustedDomain *r = (struct lsa_OpenTrustedDomain *)_r;
			ZERO_STRUCT(r->out);
			r->out.trustdom_handle = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.trustdom_handle == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_OpenTrustedDomain(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_QUERYTRUSTEDDOMAININFO: {
			struct lsa_QueryTrustedDomainInfo *r = (struct lsa_QueryTrustedDomainInfo *)_r;
			ZERO_STRUCT(r->out);
			r->out.info = talloc_zero(mem_ctx, union lsa_TrustedDomainInfo *);
			if (r->out.info == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_QueryTrustedDomainInfo(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_SETINFORMATIONTRUSTEDDOMAIN: {
			struct lsa_SetInformationTrustedDomain *r = (struct lsa_SetInformationTrustedDomain *)_r;
			r->out.result = _lsa_SetInformationTrustedDomain(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_OPENSECRET: {
			struct lsa_OpenSecret *r = (struct lsa_OpenSecret *)_r;
			ZERO_STRUCT(r->out);
			r->out.sec_handle = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.sec_handle == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_OpenSecret(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_SETSECRET: {
			struct lsa_SetSecret *r = (struct lsa_SetSecret *)_r;
			r->out.result = _lsa_SetSecret(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_QUERYSECRET: {
			struct lsa_QuerySecret *r = (struct lsa_QuerySecret *)_r;
			ZERO_STRUCT(r->out);
			r->out.new_val = r->in.new_val;
			r->out.new_mtime = r->in.new_mtime;
			r->out.old_val = r->in.old_val;
			r->out.old_mtime = r->in.old_mtime;
			r->out.result = _lsa_QuerySecret(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_LOOKUPPRIVVALUE: {
			struct lsa_LookupPrivValue *r = (struct lsa_LookupPrivValue *)_r;
			ZERO_STRUCT(r->out);
			r->out.luid = talloc_zero(mem_ctx, struct lsa_LUID);
			if (r->out.luid == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_LookupPrivValue(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_LOOKUPPRIVNAME: {
			struct lsa_LookupPrivName *r = (struct lsa_LookupPrivName *)_r;
			ZERO_STRUCT(r->out);
			r->out.name = talloc_zero(mem_ctx, struct lsa_StringLarge *);
			if (r->out.name == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_LookupPrivName(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_LOOKUPPRIVDISPLAYNAME: {
			struct lsa_LookupPrivDisplayName *r = (struct lsa_LookupPrivDisplayName *)_r;
			ZERO_STRUCT(r->out);
			r->out.disp_name = talloc_zero(mem_ctx, struct lsa_StringLarge *);
			if (r->out.disp_name == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.returned_language_id = talloc_zero(mem_ctx, uint16_t);
			if (r->out.returned_language_id == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_LookupPrivDisplayName(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_DELETEOBJECT: {
			struct lsa_DeleteObject *r = (struct lsa_DeleteObject *)_r;
			ZERO_STRUCT(r->out);
			r->out.handle = r->in.handle;
			r->out.result = _lsa_DeleteObject(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_ENUMACCOUNTSWITHUSERRIGHT: {
			struct lsa_EnumAccountsWithUserRight *r = (struct lsa_EnumAccountsWithUserRight *)_r;
			ZERO_STRUCT(r->out);
			r->out.sids = talloc_zero(mem_ctx, struct lsa_SidArray);
			if (r->out.sids == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_EnumAccountsWithUserRight(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_ENUMACCOUNTRIGHTS: {
			struct lsa_EnumAccountRights *r = (struct lsa_EnumAccountRights *)_r;
			ZERO_STRUCT(r->out);
			r->out.rights = talloc_zero(mem_ctx, struct lsa_RightSet);
			if (r->out.rights == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_EnumAccountRights(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_ADDACCOUNTRIGHTS: {
			struct lsa_AddAccountRights *r = (struct lsa_AddAccountRights *)_r;
			r->out.result = _lsa_AddAccountRights(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_REMOVEACCOUNTRIGHTS: {
			struct lsa_RemoveAccountRights *r = (struct lsa_RemoveAccountRights *)_r;
			r->out.result = _lsa_RemoveAccountRights(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_QUERYTRUSTEDDOMAININFOBYSID: {
			struct lsa_QueryTrustedDomainInfoBySid *r = (struct lsa_QueryTrustedDomainInfoBySid *)_r;
			ZERO_STRUCT(r->out);
			r->out.info = talloc_zero(mem_ctx, union lsa_TrustedDomainInfo *);
			if (r->out.info == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_QueryTrustedDomainInfoBySid(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_SETTRUSTEDDOMAININFO: {
			struct lsa_SetTrustedDomainInfo *r = (struct lsa_SetTrustedDomainInfo *)_r;
			r->out.result = _lsa_SetTrustedDomainInfo(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_DELETETRUSTEDDOMAIN: {
			struct lsa_DeleteTrustedDomain *r = (struct lsa_DeleteTrustedDomain *)_r;
			r->out.result = _lsa_DeleteTrustedDomain(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_STOREPRIVATEDATA: {
			struct lsa_StorePrivateData *r = (struct lsa_StorePrivateData *)_r;
			r->out.result = _lsa_StorePrivateData(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_RETRIEVEPRIVATEDATA: {
			struct lsa_RetrievePrivateData *r = (struct lsa_RetrievePrivateData *)_r;
			r->out.result = _lsa_RetrievePrivateData(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_OPENPOLICY2: {
			struct lsa_OpenPolicy2 *r = (struct lsa_OpenPolicy2 *)_r;
			ZERO_STRUCT(r->out);
			r->out.handle = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.handle == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_OpenPolicy2(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_GETUSERNAME: {
			struct lsa_GetUserName *r = (struct lsa_GetUserName *)_r;
			ZERO_STRUCT(r->out);
			r->out.account_name = r->in.account_name;
			r->out.authority_name = r->in.authority_name;
			r->out.result = _lsa_GetUserName(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_QUERYINFOPOLICY2: {
			struct lsa_QueryInfoPolicy2 *r = (struct lsa_QueryInfoPolicy2 *)_r;
			ZERO_STRUCT(r->out);
			r->out.info = talloc_zero(mem_ctx, union lsa_PolicyInformation *);
			if (r->out.info == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_QueryInfoPolicy2(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_SETINFOPOLICY2: {
			struct lsa_SetInfoPolicy2 *r = (struct lsa_SetInfoPolicy2 *)_r;
			r->out.result = _lsa_SetInfoPolicy2(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_QUERYTRUSTEDDOMAININFOBYNAME: {
			struct lsa_QueryTrustedDomainInfoByName *r = (struct lsa_QueryTrustedDomainInfoByName *)_r;
			ZERO_STRUCT(r->out);
			r->out.info = talloc_zero(mem_ctx, union lsa_TrustedDomainInfo *);
			if (r->out.info == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_QueryTrustedDomainInfoByName(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_SETTRUSTEDDOMAININFOBYNAME: {
			struct lsa_SetTrustedDomainInfoByName *r = (struct lsa_SetTrustedDomainInfoByName *)_r;
			r->out.result = _lsa_SetTrustedDomainInfoByName(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_ENUMTRUSTEDDOMAINSEX: {
			struct lsa_EnumTrustedDomainsEx *r = (struct lsa_EnumTrustedDomainsEx *)_r;
			ZERO_STRUCT(r->out);
			r->out.resume_handle = r->in.resume_handle;
			r->out.domains = talloc_zero(mem_ctx, struct lsa_DomainListEx);
			if (r->out.domains == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_EnumTrustedDomainsEx(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_CREATETRUSTEDDOMAINEX: {
			struct lsa_CreateTrustedDomainEx *r = (struct lsa_CreateTrustedDomainEx *)_r;
			ZERO_STRUCT(r->out);
			r->out.trustdom_handle = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.trustdom_handle == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_CreateTrustedDomainEx(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_CLOSETRUSTEDDOMAINEX: {
			struct lsa_CloseTrustedDomainEx *r = (struct lsa_CloseTrustedDomainEx *)_r;
			ZERO_STRUCT(r->out);
			r->out.handle = r->in.handle;
			r->out.result = _lsa_CloseTrustedDomainEx(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_QUERYDOMAININFORMATIONPOLICY: {
			struct lsa_QueryDomainInformationPolicy *r = (struct lsa_QueryDomainInformationPolicy *)_r;
			ZERO_STRUCT(r->out);
			r->out.info = talloc_zero(mem_ctx, union lsa_DomainInformationPolicy *);
			if (r->out.info == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_QueryDomainInformationPolicy(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_SETDOMAININFORMATIONPOLICY: {
			struct lsa_SetDomainInformationPolicy *r = (struct lsa_SetDomainInformationPolicy *)_r;
			r->out.result = _lsa_SetDomainInformationPolicy(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_OPENTRUSTEDDOMAINBYNAME: {
			struct lsa_OpenTrustedDomainByName *r = (struct lsa_OpenTrustedDomainByName *)_r;
			ZERO_STRUCT(r->out);
			r->out.trustdom_handle = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.trustdom_handle == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_OpenTrustedDomainByName(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_TESTCALL: {
			struct lsa_TestCall *r = (struct lsa_TestCall *)_r;
			r->out.result = _lsa_TestCall(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_LOOKUPSIDS2: {
			struct lsa_LookupSids2 *r = (struct lsa_LookupSids2 *)_r;
			ZERO_STRUCT(r->out);
			r->out.names = r->in.names;
			r->out.count = r->in.count;
			r->out.domains = talloc_zero(mem_ctx, struct lsa_RefDomainList *);
			if (r->out.domains == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_LookupSids2(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_LOOKUPNAMES2: {
			struct lsa_LookupNames2 *r = (struct lsa_LookupNames2 *)_r;
			ZERO_STRUCT(r->out);
			r->out.sids = r->in.sids;
			r->out.count = r->in.count;
			r->out.domains = talloc_zero(mem_ctx, struct lsa_RefDomainList *);
			if (r->out.domains == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_LookupNames2(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_CREATETRUSTEDDOMAINEX2: {
			struct lsa_CreateTrustedDomainEx2 *r = (struct lsa_CreateTrustedDomainEx2 *)_r;
			ZERO_STRUCT(r->out);
			r->out.trustdom_handle = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.trustdom_handle == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_CreateTrustedDomainEx2(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_CREDRWRITE: {
			struct lsa_CREDRWRITE *r = (struct lsa_CREDRWRITE *)_r;
			r->out.result = _lsa_CREDRWRITE(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_CREDRREAD: {
			struct lsa_CREDRREAD *r = (struct lsa_CREDRREAD *)_r;
			r->out.result = _lsa_CREDRREAD(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_CREDRENUMERATE: {
			struct lsa_CREDRENUMERATE *r = (struct lsa_CREDRENUMERATE *)_r;
			r->out.result = _lsa_CREDRENUMERATE(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_CREDRWRITEDOMAINCREDENTIALS: {
			struct lsa_CREDRWRITEDOMAINCREDENTIALS *r = (struct lsa_CREDRWRITEDOMAINCREDENTIALS *)_r;
			r->out.result = _lsa_CREDRWRITEDOMAINCREDENTIALS(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_CREDRREADDOMAINCREDENTIALS: {
			struct lsa_CREDRREADDOMAINCREDENTIALS *r = (struct lsa_CREDRREADDOMAINCREDENTIALS *)_r;
			r->out.result = _lsa_CREDRREADDOMAINCREDENTIALS(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_CREDRDELETE: {
			struct lsa_CREDRDELETE *r = (struct lsa_CREDRDELETE *)_r;
			r->out.result = _lsa_CREDRDELETE(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_CREDRGETTARGETINFO: {
			struct lsa_CREDRGETTARGETINFO *r = (struct lsa_CREDRGETTARGETINFO *)_r;
			r->out.result = _lsa_CREDRGETTARGETINFO(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_CREDRPROFILELOADED: {
			struct lsa_CREDRPROFILELOADED *r = (struct lsa_CREDRPROFILELOADED *)_r;
			r->out.result = _lsa_CREDRPROFILELOADED(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_LOOKUPNAMES3: {
			struct lsa_LookupNames3 *r = (struct lsa_LookupNames3 *)_r;
			ZERO_STRUCT(r->out);
			r->out.sids = r->in.sids;
			r->out.count = r->in.count;
			r->out.domains = talloc_zero(mem_ctx, struct lsa_RefDomainList *);
			if (r->out.domains == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_LookupNames3(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_CREDRGETSESSIONTYPES: {
			struct lsa_CREDRGETSESSIONTYPES *r = (struct lsa_CREDRGETSESSIONTYPES *)_r;
			r->out.result = _lsa_CREDRGETSESSIONTYPES(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_LSARREGISTERAUDITEVENT: {
			struct lsa_LSARREGISTERAUDITEVENT *r = (struct lsa_LSARREGISTERAUDITEVENT *)_r;
			r->out.result = _lsa_LSARREGISTERAUDITEVENT(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_LSARGENAUDITEVENT: {
			struct lsa_LSARGENAUDITEVENT *r = (struct lsa_LSARGENAUDITEVENT *)_r;
			r->out.result = _lsa_LSARGENAUDITEVENT(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_LSARUNREGISTERAUDITEVENT: {
			struct lsa_LSARUNREGISTERAUDITEVENT *r = (struct lsa_LSARUNREGISTERAUDITEVENT *)_r;
			r->out.result = _lsa_LSARUNREGISTERAUDITEVENT(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_LSARQUERYFORESTTRUSTINFORMATION: {
			struct lsa_lsaRQueryForestTrustInformation *r = (struct lsa_lsaRQueryForestTrustInformation *)_r;
			ZERO_STRUCT(r->out);
			r->out.forest_trust_info = talloc_zero(mem_ctx, struct lsa_ForestTrustInformation *);
			if (r->out.forest_trust_info == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_lsaRQueryForestTrustInformation(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_LSARSETFORESTTRUSTINFORMATION: {
			struct lsa_LSARSETFORESTTRUSTINFORMATION *r = (struct lsa_LSARSETFORESTTRUSTINFORMATION *)_r;
			r->out.result = _lsa_LSARSETFORESTTRUSTINFORMATION(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_CREDRRENAME: {
			struct lsa_CREDRRENAME *r = (struct lsa_CREDRRENAME *)_r;
			r->out.result = _lsa_CREDRRENAME(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_LOOKUPSIDS3: {
			struct lsa_LookupSids3 *r = (struct lsa_LookupSids3 *)_r;
			ZERO_STRUCT(r->out);
			r->out.names = r->in.names;
			r->out.count = r->in.count;
			r->out.domains = talloc_zero(mem_ctx, struct lsa_RefDomainList *);
			if (r->out.domains == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_LookupSids3(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_LOOKUPNAMES4: {
			struct lsa_LookupNames4 *r = (struct lsa_LookupNames4 *)_r;
			ZERO_STRUCT(r->out);
			r->out.sids = r->in.sids;
			r->out.count = r->in.count;
			r->out.domains = talloc_zero(mem_ctx, struct lsa_RefDomainList *);
			if (r->out.domains == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _lsa_LookupNames4(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_LSAROPENPOLICYSCE: {
			struct lsa_LSAROPENPOLICYSCE *r = (struct lsa_LSAROPENPOLICYSCE *)_r;
			r->out.result = _lsa_LSAROPENPOLICYSCE(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_LSARADTREGISTERSECURITYEVENTSOURCE: {
			struct lsa_LSARADTREGISTERSECURITYEVENTSOURCE *r = (struct lsa_LSARADTREGISTERSECURITYEVENTSOURCE *)_r;
			r->out.result = _lsa_LSARADTREGISTERSECURITYEVENTSOURCE(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_LSARADTUNREGISTERSECURITYEVENTSOURCE: {
			struct lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE *r = (struct lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE *)_r;
			r->out.result = _lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_LSA_LSARADTREPORTSECURITYEVENT: {
			struct lsa_LSARADTREPORTSECURITYEVENT *r = (struct lsa_LSARADTREPORTSECURITYEVENT *)_r;
			r->out.result = _lsa_LSARADTREPORTSECURITYEVENT(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_lsarpc_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "lsarpc", "lsarpc", &ndr_table_lsarpc, api_lsarpc_cmds, sizeof(api_lsarpc_cmds) / sizeof(struct api_struct));
}
