/*
   Unix SMB/CIFS implementation.
   Wrap unix errno around tevent_req
   Copyright (C) Volker Lendecke 2009

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "tevent_unix.h"
#include "../replace/replace.h"

bool tevent_req_is_unix_error(struct tevent_req *req, int *perrno)
{
	enum tevent_req_state state;
	uint64_t err;

	if (!tevent_req_is_error(req, &state, &err)) {
		return false;
	}
	switch (state) {
	case TEVENT_REQ_TIMED_OUT:
		*perrno = ETIMEDOUT;
		break;
	case TEVENT_REQ_NO_MEMORY:
		*perrno = ENOMEM;
		break;
	case TEVENT_REQ_USER_ERROR:
		*perrno = err;
		break;
	default:
		*perrno = EINVAL;
		break;
	}
	return true;
}
