/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "librpc/gen_ndr/srv_netlogon.h"

static bool api_netr_LogonUasLogon(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_LogonUasLogon *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_LOGONUASLOGON];

	r = talloc(talloc_tos(), struct netr_LogonUasLogon);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_LogonUasLogon, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, struct netr_UasInfo);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_LogonUasLogon(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_LogonUasLogon, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_LogonUasLogoff(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_LogonUasLogoff *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_LOGONUASLOGOFF];

	r = talloc(talloc_tos(), struct netr_LogonUasLogoff);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_LogonUasLogoff, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, struct netr_UasLogoffInfo);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_LogonUasLogoff(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_LogonUasLogoff, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_LogonSamLogon(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_LogonSamLogon *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_LOGONSAMLOGON];

	r = talloc(talloc_tos(), struct netr_LogonSamLogon);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_LogonSamLogon, r);
	}

	ZERO_STRUCT(r->out);
	r->out.return_authenticator = r->in.return_authenticator;
	r->out.validation = talloc_zero(r, union netr_Validation);
	if (r->out.validation == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.authoritative = talloc_zero(r, uint8_t);
	if (r->out.authoritative == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_LogonSamLogon(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_LogonSamLogon, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_LogonSamLogoff(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_LogonSamLogoff *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_LOGONSAMLOGOFF];

	r = talloc(talloc_tos(), struct netr_LogonSamLogoff);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_LogonSamLogoff, r);
	}

	ZERO_STRUCT(r->out);
	r->out.return_authenticator = r->in.return_authenticator;
	r->out.result = _netr_LogonSamLogoff(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_LogonSamLogoff, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_ServerReqChallenge(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_ServerReqChallenge *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_SERVERREQCHALLENGE];

	r = talloc(talloc_tos(), struct netr_ServerReqChallenge);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_ServerReqChallenge, r);
	}

	ZERO_STRUCT(r->out);
	r->out.return_credentials = talloc_zero(r, struct netr_Credential);
	if (r->out.return_credentials == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_ServerReqChallenge(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_ServerReqChallenge, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_ServerAuthenticate(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_ServerAuthenticate *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_SERVERAUTHENTICATE];

	r = talloc(talloc_tos(), struct netr_ServerAuthenticate);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_ServerAuthenticate, r);
	}

	ZERO_STRUCT(r->out);
	r->out.return_credentials = talloc_zero(r, struct netr_Credential);
	if (r->out.return_credentials == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_ServerAuthenticate(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_ServerAuthenticate, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_ServerPasswordSet(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_ServerPasswordSet *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_SERVERPASSWORDSET];

	r = talloc(talloc_tos(), struct netr_ServerPasswordSet);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_ServerPasswordSet, r);
	}

	ZERO_STRUCT(r->out);
	r->out.return_authenticator = talloc_zero(r, struct netr_Authenticator);
	if (r->out.return_authenticator == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_ServerPasswordSet(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_ServerPasswordSet, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_DatabaseDeltas(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_DatabaseDeltas *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_DATABASEDELTAS];

	r = talloc(talloc_tos(), struct netr_DatabaseDeltas);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DatabaseDeltas, r);
	}

	ZERO_STRUCT(r->out);
	r->out.return_authenticator = r->in.return_authenticator;
	r->out.sequence_num = r->in.sequence_num;
	r->out.delta_enum_array = talloc_zero(r, struct netr_DELTA_ENUM_ARRAY *);
	if (r->out.delta_enum_array == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_DatabaseDeltas(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DatabaseDeltas, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_DatabaseSync(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_DatabaseSync *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_DATABASESYNC];

	r = talloc(talloc_tos(), struct netr_DatabaseSync);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DatabaseSync, r);
	}

	ZERO_STRUCT(r->out);
	r->out.return_authenticator = r->in.return_authenticator;
	r->out.sync_context = r->in.sync_context;
	r->out.delta_enum_array = talloc_zero(r, struct netr_DELTA_ENUM_ARRAY);
	if (r->out.delta_enum_array == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_DatabaseSync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DatabaseSync, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_AccountDeltas(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_AccountDeltas *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_ACCOUNTDELTAS];

	r = talloc(talloc_tos(), struct netr_AccountDeltas);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_AccountDeltas, r);
	}

	ZERO_STRUCT(r->out);
	r->out.return_authenticator = r->in.return_authenticator;
	r->out.buffer = talloc_zero(r, struct netr_AccountBuffer);
	if (r->out.buffer == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.count_returned = talloc_zero(r, uint32_t);
	if (r->out.count_returned == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.total_entries = talloc_zero(r, uint32_t);
	if (r->out.total_entries == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.recordid = talloc_zero(r, struct netr_UAS_INFO_0);
	if (r->out.recordid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_AccountDeltas(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_AccountDeltas, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_AccountSync(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_AccountSync *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_ACCOUNTSYNC];

	r = talloc(talloc_tos(), struct netr_AccountSync);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_AccountSync, r);
	}

	ZERO_STRUCT(r->out);
	r->out.return_authenticator = r->in.return_authenticator;
	r->out.buffer = talloc_zero(r, struct netr_AccountBuffer);
	if (r->out.buffer == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.count_returned = talloc_zero(r, uint32_t);
	if (r->out.count_returned == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.total_entries = talloc_zero(r, uint32_t);
	if (r->out.total_entries == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.next_reference = talloc_zero(r, uint32_t);
	if (r->out.next_reference == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.recordid = r->in.recordid;
	r->out.result = _netr_AccountSync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_AccountSync, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_GetDcName(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_GetDcName *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_GETDCNAME];

	r = talloc(talloc_tos(), struct netr_GetDcName);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_GetDcName, r);
	}

	ZERO_STRUCT(r->out);
	r->out.dcname = talloc_zero(r, const char *);
	if (r->out.dcname == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_GetDcName(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_GetDcName, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_LogonControl(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_LogonControl *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_LOGONCONTROL];

	r = talloc(talloc_tos(), struct netr_LogonControl);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_LogonControl, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, union netr_CONTROL_QUERY_INFORMATION);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_LogonControl(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_LogonControl, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_GetAnyDCName(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_GetAnyDCName *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_GETANYDCNAME];

	r = talloc(talloc_tos(), struct netr_GetAnyDCName);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_GetAnyDCName, r);
	}

	ZERO_STRUCT(r->out);
	r->out.dcname = talloc_zero(r, const char *);
	if (r->out.dcname == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_GetAnyDCName(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_GetAnyDCName, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_LogonControl2(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_LogonControl2 *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_LOGONCONTROL2];

	r = talloc(talloc_tos(), struct netr_LogonControl2);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_LogonControl2, r);
	}

	ZERO_STRUCT(r->out);
	r->out.query = talloc_zero(r, union netr_CONTROL_QUERY_INFORMATION);
	if (r->out.query == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_LogonControl2(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_LogonControl2, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_ServerAuthenticate2(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_ServerAuthenticate2 *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_SERVERAUTHENTICATE2];

	r = talloc(talloc_tos(), struct netr_ServerAuthenticate2);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_ServerAuthenticate2, r);
	}

	ZERO_STRUCT(r->out);
	r->out.return_credentials = talloc_zero(r, struct netr_Credential);
	if (r->out.return_credentials == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.negotiate_flags = r->in.negotiate_flags;
	r->out.result = _netr_ServerAuthenticate2(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_ServerAuthenticate2, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_DatabaseSync2(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_DatabaseSync2 *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_DATABASESYNC2];

	r = talloc(talloc_tos(), struct netr_DatabaseSync2);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DatabaseSync2, r);
	}

	ZERO_STRUCT(r->out);
	r->out.return_authenticator = r->in.return_authenticator;
	r->out.sync_context = r->in.sync_context;
	r->out.delta_enum_array = talloc_zero(r, struct netr_DELTA_ENUM_ARRAY *);
	if (r->out.delta_enum_array == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_DatabaseSync2(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DatabaseSync2, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_DatabaseRedo(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_DatabaseRedo *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_DATABASEREDO];

	r = talloc(talloc_tos(), struct netr_DatabaseRedo);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DatabaseRedo, r);
	}

	ZERO_STRUCT(r->out);
	r->out.return_authenticator = r->in.return_authenticator;
	r->out.delta_enum_array = talloc_zero(r, struct netr_DELTA_ENUM_ARRAY *);
	if (r->out.delta_enum_array == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_DatabaseRedo(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DatabaseRedo, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_LogonControl2Ex(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_LogonControl2Ex *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_LOGONCONTROL2EX];

	r = talloc(talloc_tos(), struct netr_LogonControl2Ex);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_LogonControl2Ex, r);
	}

	ZERO_STRUCT(r->out);
	r->out.query = talloc_zero(r, union netr_CONTROL_QUERY_INFORMATION);
	if (r->out.query == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_LogonControl2Ex(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_LogonControl2Ex, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_NetrEnumerateTrustedDomains(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_NetrEnumerateTrustedDomains *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_NETRENUMERATETRUSTEDDOMAINS];

	r = talloc(talloc_tos(), struct netr_NetrEnumerateTrustedDomains);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_NetrEnumerateTrustedDomains, r);
	}

	ZERO_STRUCT(r->out);
	r->out.trusted_domains_blob = talloc_zero(r, struct netr_Blob);
	if (r->out.trusted_domains_blob == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_NetrEnumerateTrustedDomains(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_NetrEnumerateTrustedDomains, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_DsRGetDCName(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_DsRGetDCName *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_DSRGETDCNAME];

	r = talloc(talloc_tos(), struct netr_DsRGetDCName);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DsRGetDCName, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, struct netr_DsRGetDCNameInfo *);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_DsRGetDCName(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DsRGetDCName, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_NETRLOGONDUMMYROUTINE1(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_NETRLOGONDUMMYROUTINE1 *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_NETRLOGONDUMMYROUTINE1];

	r = talloc(talloc_tos(), struct netr_NETRLOGONDUMMYROUTINE1);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_NETRLOGONDUMMYROUTINE1, r);
	}

	r->out.result = _netr_NETRLOGONDUMMYROUTINE1(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_NETRLOGONDUMMYROUTINE1, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_NETRLOGONSETSERVICEBITS(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_NETRLOGONSETSERVICEBITS *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_NETRLOGONSETSERVICEBITS];

	r = talloc(talloc_tos(), struct netr_NETRLOGONSETSERVICEBITS);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_NETRLOGONSETSERVICEBITS, r);
	}

	r->out.result = _netr_NETRLOGONSETSERVICEBITS(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_NETRLOGONSETSERVICEBITS, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_LogonGetTrustRid(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_LogonGetTrustRid *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_LOGONGETTRUSTRID];

	r = talloc(talloc_tos(), struct netr_LogonGetTrustRid);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_LogonGetTrustRid, r);
	}

	ZERO_STRUCT(r->out);
	r->out.rid = talloc_zero(r, uint32_t);
	if (r->out.rid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_LogonGetTrustRid(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_LogonGetTrustRid, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_NETRLOGONCOMPUTESERVERDIGEST(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_NETRLOGONCOMPUTESERVERDIGEST *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_NETRLOGONCOMPUTESERVERDIGEST];

	r = talloc(talloc_tos(), struct netr_NETRLOGONCOMPUTESERVERDIGEST);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_NETRLOGONCOMPUTESERVERDIGEST, r);
	}

	r->out.result = _netr_NETRLOGONCOMPUTESERVERDIGEST(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_NETRLOGONCOMPUTESERVERDIGEST, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_NETRLOGONCOMPUTECLIENTDIGEST(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_NETRLOGONCOMPUTECLIENTDIGEST *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_NETRLOGONCOMPUTECLIENTDIGEST];

	r = talloc(talloc_tos(), struct netr_NETRLOGONCOMPUTECLIENTDIGEST);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_NETRLOGONCOMPUTECLIENTDIGEST, r);
	}

	r->out.result = _netr_NETRLOGONCOMPUTECLIENTDIGEST(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_NETRLOGONCOMPUTECLIENTDIGEST, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_ServerAuthenticate3(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_ServerAuthenticate3 *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_SERVERAUTHENTICATE3];

	r = talloc(talloc_tos(), struct netr_ServerAuthenticate3);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_ServerAuthenticate3, r);
	}

	ZERO_STRUCT(r->out);
	r->out.credentials = r->in.credentials;
	r->out.negotiate_flags = r->in.negotiate_flags;
	r->out.rid = talloc_zero(r, uint32_t);
	if (r->out.rid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_ServerAuthenticate3(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_ServerAuthenticate3, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_DsRGetDCNameEx(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_DsRGetDCNameEx *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_DSRGETDCNAMEEX];

	r = talloc(talloc_tos(), struct netr_DsRGetDCNameEx);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DsRGetDCNameEx, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, struct netr_DsRGetDCNameInfo *);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_DsRGetDCNameEx(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DsRGetDCNameEx, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_DsRGetSiteName(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_DsRGetSiteName *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_DSRGETSITENAME];

	r = talloc(talloc_tos(), struct netr_DsRGetSiteName);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DsRGetSiteName, r);
	}

	ZERO_STRUCT(r->out);
	r->out.site = talloc_zero(r, const char *);
	if (r->out.site == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_DsRGetSiteName(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DsRGetSiteName, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_LogonGetDomainInfo(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_LogonGetDomainInfo *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_LOGONGETDOMAININFO];

	r = talloc(talloc_tos(), struct netr_LogonGetDomainInfo);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_LogonGetDomainInfo, r);
	}

	ZERO_STRUCT(r->out);
	r->out.return_authenticator = r->in.return_authenticator;
	r->out.info = talloc_zero(r, union netr_DomainInfo);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_LogonGetDomainInfo(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_LogonGetDomainInfo, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_ServerPasswordSet2(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_ServerPasswordSet2 *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_SERVERPASSWORDSET2];

	r = talloc(talloc_tos(), struct netr_ServerPasswordSet2);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_ServerPasswordSet2, r);
	}

	ZERO_STRUCT(r->out);
	r->out.return_authenticator = talloc_zero(r, struct netr_Authenticator);
	if (r->out.return_authenticator == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_ServerPasswordSet2(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_ServerPasswordSet2, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_ServerPasswordGet(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_ServerPasswordGet *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_SERVERPASSWORDGET];

	r = talloc(talloc_tos(), struct netr_ServerPasswordGet);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_ServerPasswordGet, r);
	}

	ZERO_STRUCT(r->out);
	r->out.return_authenticator = talloc_zero(r, struct netr_Authenticator);
	if (r->out.return_authenticator == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.password = talloc_zero(r, struct samr_Password);
	if (r->out.password == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_ServerPasswordGet(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_ServerPasswordGet, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_NETRLOGONSENDTOSAM(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_NETRLOGONSENDTOSAM *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_NETRLOGONSENDTOSAM];

	r = talloc(talloc_tos(), struct netr_NETRLOGONSENDTOSAM);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_NETRLOGONSENDTOSAM, r);
	}

	r->out.result = _netr_NETRLOGONSENDTOSAM(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_NETRLOGONSENDTOSAM, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_DsRAddressToSitenamesW(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_DsRAddressToSitenamesW *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_DSRADDRESSTOSITENAMESW];

	r = talloc(talloc_tos(), struct netr_DsRAddressToSitenamesW);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DsRAddressToSitenamesW, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ctr = talloc_zero(r, struct netr_DsRAddressToSitenamesWCtr *);
	if (r->out.ctr == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_DsRAddressToSitenamesW(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DsRAddressToSitenamesW, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_DsRGetDCNameEx2(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_DsRGetDCNameEx2 *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_DSRGETDCNAMEEX2];

	r = talloc(talloc_tos(), struct netr_DsRGetDCNameEx2);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DsRGetDCNameEx2, r);
	}

	ZERO_STRUCT(r->out);
	r->out.info = talloc_zero(r, struct netr_DsRGetDCNameInfo *);
	if (r->out.info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_DsRGetDCNameEx2(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DsRGetDCNameEx2, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_NETRLOGONGETTIMESERVICEPARENTDOMAIN];

	r = talloc(talloc_tos(), struct netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN, r);
	}

	r->out.result = _netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_NetrEnumerateTrustedDomainsEx(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_NetrEnumerateTrustedDomainsEx *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_NETRENUMERATETRUSTEDDOMAINSEX];

	r = talloc(talloc_tos(), struct netr_NetrEnumerateTrustedDomainsEx);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_NetrEnumerateTrustedDomainsEx, r);
	}

	ZERO_STRUCT(r->out);
	r->out.dom_trust_list = talloc_zero(r, struct netr_DomainTrustList);
	if (r->out.dom_trust_list == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_NetrEnumerateTrustedDomainsEx(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_NetrEnumerateTrustedDomainsEx, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_DsRAddressToSitenamesExW(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_DsRAddressToSitenamesExW *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_DSRADDRESSTOSITENAMESEXW];

	r = talloc(talloc_tos(), struct netr_DsRAddressToSitenamesExW);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DsRAddressToSitenamesExW, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ctr = talloc_zero(r, struct netr_DsRAddressToSitenamesExWCtr *);
	if (r->out.ctr == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_DsRAddressToSitenamesExW(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DsRAddressToSitenamesExW, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_DsrGetDcSiteCoverageW(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_DsrGetDcSiteCoverageW *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_DSRGETDCSITECOVERAGEW];

	r = talloc(talloc_tos(), struct netr_DsrGetDcSiteCoverageW);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DsrGetDcSiteCoverageW, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ctr = talloc_zero(r, struct DcSitesCtr);
	if (r->out.ctr == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_DsrGetDcSiteCoverageW(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DsrGetDcSiteCoverageW, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_LogonSamLogonEx(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_LogonSamLogonEx *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_LOGONSAMLOGONEX];

	r = talloc(talloc_tos(), struct netr_LogonSamLogonEx);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_LogonSamLogonEx, r);
	}

	ZERO_STRUCT(r->out);
	r->out.validation = talloc_zero(r, union netr_Validation);
	if (r->out.validation == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.authoritative = talloc_zero(r, uint8_t);
	if (r->out.authoritative == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.flags = r->in.flags;
	r->out.result = _netr_LogonSamLogonEx(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_LogonSamLogonEx, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_DsrEnumerateDomainTrusts(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_DsrEnumerateDomainTrusts *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_DSRENUMERATEDOMAINTRUSTS];

	r = talloc(talloc_tos(), struct netr_DsrEnumerateDomainTrusts);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DsrEnumerateDomainTrusts, r);
	}

	ZERO_STRUCT(r->out);
	r->out.trusts = talloc_zero(r, struct netr_DomainTrustList);
	if (r->out.trusts == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_DsrEnumerateDomainTrusts(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DsrEnumerateDomainTrusts, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_DsrDeregisterDNSHostRecords(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_DsrDeregisterDNSHostRecords *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_DSRDEREGISTERDNSHOSTRECORDS];

	r = talloc(talloc_tos(), struct netr_DsrDeregisterDNSHostRecords);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DsrDeregisterDNSHostRecords, r);
	}

	r->out.result = _netr_DsrDeregisterDNSHostRecords(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DsrDeregisterDNSHostRecords, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_ServerTrustPasswordsGet(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_ServerTrustPasswordsGet *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_SERVERTRUSTPASSWORDSGET];

	r = talloc(talloc_tos(), struct netr_ServerTrustPasswordsGet);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_ServerTrustPasswordsGet, r);
	}

	ZERO_STRUCT(r->out);
	r->out.return_authenticator = talloc_zero(r, struct netr_Authenticator);
	if (r->out.return_authenticator == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.password = talloc_zero(r, struct samr_Password);
	if (r->out.password == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.password2 = talloc_zero(r, struct samr_Password);
	if (r->out.password2 == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_ServerTrustPasswordsGet(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_ServerTrustPasswordsGet, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_DsRGetForestTrustInformation(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_DsRGetForestTrustInformation *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_DSRGETFORESTTRUSTINFORMATION];

	r = talloc(talloc_tos(), struct netr_DsRGetForestTrustInformation);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DsRGetForestTrustInformation, r);
	}

	ZERO_STRUCT(r->out);
	r->out.forest_trust_info = talloc_zero(r, struct lsa_ForestTrustInformation *);
	if (r->out.forest_trust_info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_DsRGetForestTrustInformation(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DsRGetForestTrustInformation, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_GetForestTrustInformation(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_GetForestTrustInformation *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_GETFORESTTRUSTINFORMATION];

	r = talloc(talloc_tos(), struct netr_GetForestTrustInformation);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_GetForestTrustInformation, r);
	}

	ZERO_STRUCT(r->out);
	r->out.return_authenticator = talloc_zero(r, struct netr_Authenticator);
	if (r->out.return_authenticator == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.forest_trust_info = talloc_zero(r, struct lsa_ForestTrustInformation *);
	if (r->out.forest_trust_info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _netr_GetForestTrustInformation(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_GetForestTrustInformation, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_LogonSamLogonWithFlags(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_LogonSamLogonWithFlags *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_LOGONSAMLOGONWITHFLAGS];

	r = talloc(talloc_tos(), struct netr_LogonSamLogonWithFlags);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_LogonSamLogonWithFlags, r);
	}

	ZERO_STRUCT(r->out);
	r->out.return_authenticator = r->in.return_authenticator;
	r->out.validation = talloc_zero(r, union netr_Validation);
	if (r->out.validation == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.authoritative = talloc_zero(r, uint8_t);
	if (r->out.authoritative == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.flags = r->in.flags;
	r->out.result = _netr_LogonSamLogonWithFlags(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_LogonSamLogonWithFlags, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_netr_NETRSERVERGETTRUSTINFO(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct netr_NETRSERVERGETTRUSTINFO *r;

	call = &ndr_table_netlogon.calls[NDR_NETR_NETRSERVERGETTRUSTINFO];

	r = talloc(talloc_tos(), struct netr_NETRSERVERGETTRUSTINFO);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_NETRSERVERGETTRUSTINFO, r);
	}

	r->out.result = _netr_NETRSERVERGETTRUSTINFO(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_NETRSERVERGETTRUSTINFO, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_netlogon_cmds[] = 
{
	{"NETR_LOGONUASLOGON", NDR_NETR_LOGONUASLOGON, api_netr_LogonUasLogon},
	{"NETR_LOGONUASLOGOFF", NDR_NETR_LOGONUASLOGOFF, api_netr_LogonUasLogoff},
	{"NETR_LOGONSAMLOGON", NDR_NETR_LOGONSAMLOGON, api_netr_LogonSamLogon},
	{"NETR_LOGONSAMLOGOFF", NDR_NETR_LOGONSAMLOGOFF, api_netr_LogonSamLogoff},
	{"NETR_SERVERREQCHALLENGE", NDR_NETR_SERVERREQCHALLENGE, api_netr_ServerReqChallenge},
	{"NETR_SERVERAUTHENTICATE", NDR_NETR_SERVERAUTHENTICATE, api_netr_ServerAuthenticate},
	{"NETR_SERVERPASSWORDSET", NDR_NETR_SERVERPASSWORDSET, api_netr_ServerPasswordSet},
	{"NETR_DATABASEDELTAS", NDR_NETR_DATABASEDELTAS, api_netr_DatabaseDeltas},
	{"NETR_DATABASESYNC", NDR_NETR_DATABASESYNC, api_netr_DatabaseSync},
	{"NETR_ACCOUNTDELTAS", NDR_NETR_ACCOUNTDELTAS, api_netr_AccountDeltas},
	{"NETR_ACCOUNTSYNC", NDR_NETR_ACCOUNTSYNC, api_netr_AccountSync},
	{"NETR_GETDCNAME", NDR_NETR_GETDCNAME, api_netr_GetDcName},
	{"NETR_LOGONCONTROL", NDR_NETR_LOGONCONTROL, api_netr_LogonControl},
	{"NETR_GETANYDCNAME", NDR_NETR_GETANYDCNAME, api_netr_GetAnyDCName},
	{"NETR_LOGONCONTROL2", NDR_NETR_LOGONCONTROL2, api_netr_LogonControl2},
	{"NETR_SERVERAUTHENTICATE2", NDR_NETR_SERVERAUTHENTICATE2, api_netr_ServerAuthenticate2},
	{"NETR_DATABASESYNC2", NDR_NETR_DATABASESYNC2, api_netr_DatabaseSync2},
	{"NETR_DATABASEREDO", NDR_NETR_DATABASEREDO, api_netr_DatabaseRedo},
	{"NETR_LOGONCONTROL2EX", NDR_NETR_LOGONCONTROL2EX, api_netr_LogonControl2Ex},
	{"NETR_NETRENUMERATETRUSTEDDOMAINS", NDR_NETR_NETRENUMERATETRUSTEDDOMAINS, api_netr_NetrEnumerateTrustedDomains},
	{"NETR_DSRGETDCNAME", NDR_NETR_DSRGETDCNAME, api_netr_DsRGetDCName},
	{"NETR_NETRLOGONDUMMYROUTINE1", NDR_NETR_NETRLOGONDUMMYROUTINE1, api_netr_NETRLOGONDUMMYROUTINE1},
	{"NETR_NETRLOGONSETSERVICEBITS", NDR_NETR_NETRLOGONSETSERVICEBITS, api_netr_NETRLOGONSETSERVICEBITS},
	{"NETR_LOGONGETTRUSTRID", NDR_NETR_LOGONGETTRUSTRID, api_netr_LogonGetTrustRid},
	{"NETR_NETRLOGONCOMPUTESERVERDIGEST", NDR_NETR_NETRLOGONCOMPUTESERVERDIGEST, api_netr_NETRLOGONCOMPUTESERVERDIGEST},
	{"NETR_NETRLOGONCOMPUTECLIENTDIGEST", NDR_NETR_NETRLOGONCOMPUTECLIENTDIGEST, api_netr_NETRLOGONCOMPUTECLIENTDIGEST},
	{"NETR_SERVERAUTHENTICATE3", NDR_NETR_SERVERAUTHENTICATE3, api_netr_ServerAuthenticate3},
	{"NETR_DSRGETDCNAMEEX", NDR_NETR_DSRGETDCNAMEEX, api_netr_DsRGetDCNameEx},
	{"NETR_DSRGETSITENAME", NDR_NETR_DSRGETSITENAME, api_netr_DsRGetSiteName},
	{"NETR_LOGONGETDOMAININFO", NDR_NETR_LOGONGETDOMAININFO, api_netr_LogonGetDomainInfo},
	{"NETR_SERVERPASSWORDSET2", NDR_NETR_SERVERPASSWORDSET2, api_netr_ServerPasswordSet2},
	{"NETR_SERVERPASSWORDGET", NDR_NETR_SERVERPASSWORDGET, api_netr_ServerPasswordGet},
	{"NETR_NETRLOGONSENDTOSAM", NDR_NETR_NETRLOGONSENDTOSAM, api_netr_NETRLOGONSENDTOSAM},
	{"NETR_DSRADDRESSTOSITENAMESW", NDR_NETR_DSRADDRESSTOSITENAMESW, api_netr_DsRAddressToSitenamesW},
	{"NETR_DSRGETDCNAMEEX2", NDR_NETR_DSRGETDCNAMEEX2, api_netr_DsRGetDCNameEx2},
	{"NETR_NETRLOGONGETTIMESERVICEPARENTDOMAIN", NDR_NETR_NETRLOGONGETTIMESERVICEPARENTDOMAIN, api_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN},
	{"NETR_NETRENUMERATETRUSTEDDOMAINSEX", NDR_NETR_NETRENUMERATETRUSTEDDOMAINSEX, api_netr_NetrEnumerateTrustedDomainsEx},
	{"NETR_DSRADDRESSTOSITENAMESEXW", NDR_NETR_DSRADDRESSTOSITENAMESEXW, api_netr_DsRAddressToSitenamesExW},
	{"NETR_DSRGETDCSITECOVERAGEW", NDR_NETR_DSRGETDCSITECOVERAGEW, api_netr_DsrGetDcSiteCoverageW},
	{"NETR_LOGONSAMLOGONEX", NDR_NETR_LOGONSAMLOGONEX, api_netr_LogonSamLogonEx},
	{"NETR_DSRENUMERATEDOMAINTRUSTS", NDR_NETR_DSRENUMERATEDOMAINTRUSTS, api_netr_DsrEnumerateDomainTrusts},
	{"NETR_DSRDEREGISTERDNSHOSTRECORDS", NDR_NETR_DSRDEREGISTERDNSHOSTRECORDS, api_netr_DsrDeregisterDNSHostRecords},
	{"NETR_SERVERTRUSTPASSWORDSGET", NDR_NETR_SERVERTRUSTPASSWORDSGET, api_netr_ServerTrustPasswordsGet},
	{"NETR_DSRGETFORESTTRUSTINFORMATION", NDR_NETR_DSRGETFORESTTRUSTINFORMATION, api_netr_DsRGetForestTrustInformation},
	{"NETR_GETFORESTTRUSTINFORMATION", NDR_NETR_GETFORESTTRUSTINFORMATION, api_netr_GetForestTrustInformation},
	{"NETR_LOGONSAMLOGONWITHFLAGS", NDR_NETR_LOGONSAMLOGONWITHFLAGS, api_netr_LogonSamLogonWithFlags},
	{"NETR_NETRSERVERGETTRUSTINFO", NDR_NETR_NETRSERVERGETTRUSTINFO, api_netr_NETRSERVERGETTRUSTINFO},
};

void netlogon_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_netlogon_cmds;
	*n_fns = sizeof(api_netlogon_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_netlogon_init(void)
{
	return rpc_pipe_register_commands(SMB_RPC_INTERFACE_VERSION, "netlogon", "netlogon", &ndr_table_netlogon.syntax_id, api_netlogon_cmds, sizeof(api_netlogon_cmds) / sizeof(struct api_struct));
}
