/* parser auto-generated by pidl */

#include "includes.h"
#include "librpc/gen_ndr/ndr_winreg.h"

#include "librpc/gen_ndr/ndr_lsa.h"
#include "librpc/gen_ndr/ndr_initshutdown.h"
#include "librpc/gen_ndr/ndr_security.h"
static enum ndr_err_code ndr_push_winreg_AccessMask(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_AccessMask(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_AccessMask(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "KEY_QUERY_VALUE", KEY_QUERY_VALUE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "KEY_SET_VALUE", KEY_SET_VALUE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "KEY_CREATE_SUB_KEY", KEY_CREATE_SUB_KEY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "KEY_ENUMERATE_SUB_KEYS", KEY_ENUMERATE_SUB_KEYS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "KEY_NOTIFY", KEY_NOTIFY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "KEY_CREATE_LINK", KEY_CREATE_LINK, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "KEY_WOW64_64KEY", KEY_WOW64_64KEY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "KEY_WOW64_32KEY", KEY_WOW64_32KEY, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_Type(struct ndr_push *ndr, int ndr_flags, enum winreg_Type r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_Type(struct ndr_pull *ndr, int ndr_flags, enum winreg_Type *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_Type(struct ndr_print *ndr, const char *name, enum winreg_Type r)
{
	const char *val = NULL;

	switch (r) {
		case REG_NONE: val = "REG_NONE"; break;
		case REG_SZ: val = "REG_SZ"; break;
		case REG_EXPAND_SZ: val = "REG_EXPAND_SZ"; break;
		case REG_BINARY: val = "REG_BINARY"; break;
		case REG_DWORD: val = "REG_DWORD"; break;
		case REG_DWORD_BIG_ENDIAN: val = "REG_DWORD_BIG_ENDIAN"; break;
		case REG_LINK: val = "REG_LINK"; break;
		case REG_MULTI_SZ: val = "REG_MULTI_SZ"; break;
		case REG_RESOURCE_LIST: val = "REG_RESOURCE_LIST"; break;
		case REG_FULL_RESOURCE_DESCRIPTOR: val = "REG_FULL_RESOURCE_DESCRIPTOR"; break;
		case REG_RESOURCE_REQUIREMENTS_LIST: val = "REG_RESOURCE_REQUIREMENTS_LIST"; break;
		case REG_QWORD: val = "REG_QWORD"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_winreg_String(struct ndr_push *ndr, int ndr_flags, const struct winreg_String *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, strlen_m_term(r->name) * 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, strlen_m_term(r->name) * 2));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->name));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->name, ndr_charset_length(r->name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_winreg_String(struct ndr_pull *ndr, int ndr_flags, struct winreg_String *r)
{
	uint32_t _ptr_name;
	TALLOC_CTX *_mem_save_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->name_len));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->name_size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, r->name);
		} else {
			r->name = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->name));
			if (ndr_get_array_length(ndr, &r->name) > ndr_get_array_size(ndr, &r->name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->name), ndr_get_array_length(ndr, &r->name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->name, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_String(struct ndr_print *ndr, const char *name, const struct winreg_String *r)
{
	ndr_print_struct(ndr, name, "winreg_String");
	ndr->depth++;
	ndr_print_uint16(ndr, "name_len", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen_m_term(r->name) * 2:r->name_len);
	ndr_print_uint16(ndr, "name_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen_m_term(r->name) * 2:r->name_size);
	ndr_print_ptr(ndr, "name", r->name);
	ndr->depth++;
	if (r->name) {
		ndr_print_string(ndr, "name", r->name);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_KeySecurityData(struct ndr_push *ndr, int ndr_flags, const struct KeySecurityData *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->data));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->len));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->data) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->len));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->data, r->len));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_KeySecurityData(struct ndr_pull *ndr, int ndr_flags, struct KeySecurityData *r)
{
	uint32_t _ptr_data;
	TALLOC_CTX *_mem_save_data_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data));
		if (_ptr_data) {
			NDR_PULL_ALLOC(ndr, r->data);
		} else {
			r->data = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->len));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->data) {
			_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->data, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->data));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->data));
			if (ndr_get_array_length(ndr, &r->data) > ndr_get_array_size(ndr, &r->data)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->data), ndr_get_array_length(ndr, &r->data));
			}
			NDR_PULL_ALLOC_N(ndr, r->data, ndr_get_array_size(ndr, &r->data));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->data, ndr_get_array_length(ndr, &r->data)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, 0);
		}
		if (r->data) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->data, r->size));
		}
		if (r->data) {
			NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->data, r->len));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_KeySecurityData(struct ndr_print *ndr, const char *name, const struct KeySecurityData *r)
{
	ndr_print_struct(ndr, name, "KeySecurityData");
	ndr->depth++;
	ndr_print_ptr(ndr, "data", r->data);
	ndr->depth++;
	if (r->data) {
		ndr_print_array_uint8(ndr, "data", r->data, r->len);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "size", r->size);
	ndr_print_uint32(ndr, "len", r->len);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_SecBuf(struct ndr_push *ndr, int ndr_flags, const struct winreg_SecBuf *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->length));
		NDR_CHECK(ndr_push_KeySecurityData(ndr, NDR_SCALARS, &r->sd));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->inherit));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_KeySecurityData(ndr, NDR_BUFFERS, &r->sd));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_SecBuf(struct ndr_pull *ndr, int ndr_flags, struct winreg_SecBuf *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_KeySecurityData(ndr, NDR_SCALARS, &r->sd));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->inherit));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_KeySecurityData(ndr, NDR_BUFFERS, &r->sd));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_SecBuf(struct ndr_print *ndr, const char *name, const struct winreg_SecBuf *r)
{
	ndr_print_struct(ndr, name, "winreg_SecBuf");
	ndr->depth++;
	ndr_print_uint32(ndr, "length", r->length);
	ndr_print_KeySecurityData(ndr, "sd", &r->sd);
	ndr_print_uint8(ndr, "inherit", r->inherit);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_CreateAction(struct ndr_push *ndr, int ndr_flags, enum winreg_CreateAction r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_CreateAction(struct ndr_pull *ndr, int ndr_flags, enum winreg_CreateAction *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_CreateAction(struct ndr_print *ndr, const char *name, enum winreg_CreateAction r)
{
	const char *val = NULL;

	switch (r) {
		case REG_ACTION_NONE: val = "REG_ACTION_NONE"; break;
		case REG_CREATED_NEW_KEY: val = "REG_CREATED_NEW_KEY"; break;
		case REG_OPENED_EXISTING_KEY: val = "REG_OPENED_EXISTING_KEY"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_winreg_StringBuf(struct ndr_push *ndr, int ndr_flags, const struct winreg_StringBuf *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, strlen_m_term_null(r->name) * 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->name));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size / 2));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, strlen_m_term_null(r->name) * 2 / 2));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->name, strlen_m_term_null(r->name) * 2 / 2, sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_StringBuf(struct ndr_pull *ndr, int ndr_flags, struct winreg_StringBuf *r)
{
	uint32_t _ptr_name;
	TALLOC_CTX *_mem_save_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, r->name);
		} else {
			r->name = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->name));
			if (ndr_get_array_length(ndr, &r->name) > ndr_get_array_size(ndr, &r->name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->name), ndr_get_array_length(ndr, &r->name));
			}
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->name, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
		}
		if (r->name) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->name, r->size / 2));
		}
		if (r->name) {
			NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->name, r->length / 2));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_StringBuf(struct ndr_print *ndr, const char *name, const struct winreg_StringBuf *r)
{
	ndr_print_struct(ndr, name, "winreg_StringBuf");
	ndr->depth++;
	ndr_print_uint16(ndr, "length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen_m_term_null(r->name) * 2:r->length);
	ndr_print_uint16(ndr, "size", r->size);
	ndr_print_ptr(ndr, "name", r->name);
	ndr->depth++;
	if (r->name) {
		ndr_print_string(ndr, "name", r->name);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_ValNameBuf(struct ndr_push *ndr, int ndr_flags, const struct winreg_ValNameBuf *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, strlen_m_term(r->name) * 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->name));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size / 2));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, strlen_m_term(r->name) * 2 / 2));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->name, strlen_m_term(r->name) * 2 / 2, sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_ValNameBuf(struct ndr_pull *ndr, int ndr_flags, struct winreg_ValNameBuf *r)
{
	uint32_t _ptr_name;
	TALLOC_CTX *_mem_save_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, r->name);
		} else {
			r->name = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->name));
			if (ndr_get_array_length(ndr, &r->name) > ndr_get_array_size(ndr, &r->name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->name), ndr_get_array_length(ndr, &r->name));
			}
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->name, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
		}
		if (r->name) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->name, r->size / 2));
		}
		if (r->name) {
			NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->name, r->length / 2));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_ValNameBuf(struct ndr_print *ndr, const char *name, const struct winreg_ValNameBuf *r)
{
	ndr_print_struct(ndr, name, "winreg_ValNameBuf");
	ndr->depth++;
	ndr_print_uint16(ndr, "length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen_m_term(r->name) * 2:r->length);
	ndr_print_uint16(ndr, "size", r->size);
	ndr_print_ptr(ndr, "name", r->name);
	ndr->depth++;
	if (r->name) {
		ndr_print_string(ndr, "name", r->name);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_KeySecurityAttribute(struct ndr_push *ndr, int ndr_flags, const struct KeySecurityAttribute *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->data_size));
		NDR_CHECK(ndr_push_KeySecurityData(ndr, NDR_SCALARS, &r->sec_data));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->inherit));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_KeySecurityData(ndr, NDR_BUFFERS, &r->sec_data));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_KeySecurityAttribute(struct ndr_pull *ndr, int ndr_flags, struct KeySecurityAttribute *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->data_size));
		NDR_CHECK(ndr_pull_KeySecurityData(ndr, NDR_SCALARS, &r->sec_data));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->inherit));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_KeySecurityData(ndr, NDR_BUFFERS, &r->sec_data));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_KeySecurityAttribute(struct ndr_print *ndr, const char *name, const struct KeySecurityAttribute *r)
{
	ndr_print_struct(ndr, name, "KeySecurityAttribute");
	ndr->depth++;
	ndr_print_uint32(ndr, "data_size", r->data_size);
	ndr_print_KeySecurityData(ndr, "sec_data", &r->sec_data);
	ndr_print_uint8(ndr, "inherit", r->inherit);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_QueryMultipleValue(struct ndr_push *ndr, int ndr_flags, const struct QueryMultipleValue *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->name));
		NDR_CHECK(ndr_push_winreg_Type(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->offset));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->length));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			NDR_CHECK(ndr_push_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->name));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_QueryMultipleValue(struct ndr_pull *ndr, int ndr_flags, struct QueryMultipleValue *r)
{
	uint32_t _ptr_name;
	TALLOC_CTX *_mem_save_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, r->name);
		} else {
			r->name = NULL;
		}
		NDR_CHECK(ndr_pull_winreg_Type(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->offset));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->length));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->name, 0);
			NDR_CHECK(ndr_pull_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_QueryMultipleValue(struct ndr_print *ndr, const char *name, const struct QueryMultipleValue *r)
{
	ndr_print_struct(ndr, name, "QueryMultipleValue");
	ndr->depth++;
	ndr_print_ptr(ndr, "name", r->name);
	ndr->depth++;
	if (r->name) {
		ndr_print_winreg_String(ndr, "name", r->name);
	}
	ndr->depth--;
	ndr_print_winreg_Type(ndr, "type", r->type);
	ndr_print_uint32(ndr, "offset", r->offset);
	ndr_print_uint32(ndr, "length", r->length);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_OpenHKCR(struct ndr_push *ndr, int flags, const struct winreg_OpenHKCR *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.system_name));
		if (r->in.system_name) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->in.system_name));
		}
		NDR_CHECK(ndr_push_winreg_AccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_OpenHKCR(struct ndr_pull *ndr, int flags, struct winreg_OpenHKCR *r)
{
	uint32_t _ptr_system_name;
	TALLOC_CTX *_mem_save_system_name_0;
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_system_name));
		if (_ptr_system_name) {
			NDR_PULL_ALLOC(ndr, r->in.system_name);
		} else {
			r->in.system_name = NULL;
		}
		if (r->in.system_name) {
			_mem_save_system_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.system_name, 0);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->in.system_name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_system_name_0, 0);
		}
		NDR_CHECK(ndr_pull_winreg_AccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_OpenHKCR(struct ndr_print *ndr, const char *name, int flags, const struct winreg_OpenHKCR *r)
{
	ndr_print_struct(ndr, name, "winreg_OpenHKCR");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_OpenHKCR");
		ndr->depth++;
		ndr_print_ptr(ndr, "system_name", r->in.system_name);
		ndr->depth++;
		if (r->in.system_name) {
			ndr_print_uint16(ndr, "system_name", *r->in.system_name);
		}
		ndr->depth--;
		ndr_print_winreg_AccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_OpenHKCR");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_OpenHKCU(struct ndr_push *ndr, int flags, const struct winreg_OpenHKCU *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.system_name));
		if (r->in.system_name) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->in.system_name));
		}
		NDR_CHECK(ndr_push_winreg_AccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_OpenHKCU(struct ndr_pull *ndr, int flags, struct winreg_OpenHKCU *r)
{
	uint32_t _ptr_system_name;
	TALLOC_CTX *_mem_save_system_name_0;
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_system_name));
		if (_ptr_system_name) {
			NDR_PULL_ALLOC(ndr, r->in.system_name);
		} else {
			r->in.system_name = NULL;
		}
		if (r->in.system_name) {
			_mem_save_system_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.system_name, 0);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->in.system_name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_system_name_0, 0);
		}
		NDR_CHECK(ndr_pull_winreg_AccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_OpenHKCU(struct ndr_print *ndr, const char *name, int flags, const struct winreg_OpenHKCU *r)
{
	ndr_print_struct(ndr, name, "winreg_OpenHKCU");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_OpenHKCU");
		ndr->depth++;
		ndr_print_ptr(ndr, "system_name", r->in.system_name);
		ndr->depth++;
		if (r->in.system_name) {
			ndr_print_uint16(ndr, "system_name", *r->in.system_name);
		}
		ndr->depth--;
		ndr_print_winreg_AccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_OpenHKCU");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_OpenHKLM(struct ndr_push *ndr, int flags, const struct winreg_OpenHKLM *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.system_name));
		if (r->in.system_name) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->in.system_name));
		}
		NDR_CHECK(ndr_push_winreg_AccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_OpenHKLM(struct ndr_pull *ndr, int flags, struct winreg_OpenHKLM *r)
{
	uint32_t _ptr_system_name;
	TALLOC_CTX *_mem_save_system_name_0;
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_system_name));
		if (_ptr_system_name) {
			NDR_PULL_ALLOC(ndr, r->in.system_name);
		} else {
			r->in.system_name = NULL;
		}
		if (r->in.system_name) {
			_mem_save_system_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.system_name, 0);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->in.system_name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_system_name_0, 0);
		}
		NDR_CHECK(ndr_pull_winreg_AccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_OpenHKLM(struct ndr_print *ndr, const char *name, int flags, const struct winreg_OpenHKLM *r)
{
	ndr_print_struct(ndr, name, "winreg_OpenHKLM");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_OpenHKLM");
		ndr->depth++;
		ndr_print_ptr(ndr, "system_name", r->in.system_name);
		ndr->depth++;
		if (r->in.system_name) {
			ndr_print_uint16(ndr, "system_name", *r->in.system_name);
		}
		ndr->depth--;
		ndr_print_winreg_AccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_OpenHKLM");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_OpenHKPD(struct ndr_push *ndr, int flags, const struct winreg_OpenHKPD *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.system_name));
		if (r->in.system_name) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->in.system_name));
		}
		NDR_CHECK(ndr_push_winreg_AccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_OpenHKPD(struct ndr_pull *ndr, int flags, struct winreg_OpenHKPD *r)
{
	uint32_t _ptr_system_name;
	TALLOC_CTX *_mem_save_system_name_0;
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_system_name));
		if (_ptr_system_name) {
			NDR_PULL_ALLOC(ndr, r->in.system_name);
		} else {
			r->in.system_name = NULL;
		}
		if (r->in.system_name) {
			_mem_save_system_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.system_name, 0);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->in.system_name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_system_name_0, 0);
		}
		NDR_CHECK(ndr_pull_winreg_AccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_OpenHKPD(struct ndr_print *ndr, const char *name, int flags, const struct winreg_OpenHKPD *r)
{
	ndr_print_struct(ndr, name, "winreg_OpenHKPD");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_OpenHKPD");
		ndr->depth++;
		ndr_print_ptr(ndr, "system_name", r->in.system_name);
		ndr->depth++;
		if (r->in.system_name) {
			ndr_print_uint16(ndr, "system_name", *r->in.system_name);
		}
		ndr->depth--;
		ndr_print_winreg_AccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_OpenHKPD");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_OpenHKU(struct ndr_push *ndr, int flags, const struct winreg_OpenHKU *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.system_name));
		if (r->in.system_name) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->in.system_name));
		}
		NDR_CHECK(ndr_push_winreg_AccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_OpenHKU(struct ndr_pull *ndr, int flags, struct winreg_OpenHKU *r)
{
	uint32_t _ptr_system_name;
	TALLOC_CTX *_mem_save_system_name_0;
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_system_name));
		if (_ptr_system_name) {
			NDR_PULL_ALLOC(ndr, r->in.system_name);
		} else {
			r->in.system_name = NULL;
		}
		if (r->in.system_name) {
			_mem_save_system_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.system_name, 0);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->in.system_name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_system_name_0, 0);
		}
		NDR_CHECK(ndr_pull_winreg_AccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_OpenHKU(struct ndr_print *ndr, const char *name, int flags, const struct winreg_OpenHKU *r)
{
	ndr_print_struct(ndr, name, "winreg_OpenHKU");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_OpenHKU");
		ndr->depth++;
		ndr_print_ptr(ndr, "system_name", r->in.system_name);
		ndr->depth++;
		if (r->in.system_name) {
			ndr_print_uint16(ndr, "system_name", *r->in.system_name);
		}
		ndr->depth--;
		ndr_print_winreg_AccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_OpenHKU");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_CloseKey(struct ndr_push *ndr, int flags, const struct winreg_CloseKey *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_CloseKey(struct ndr_pull *ndr, int flags, struct winreg_CloseKey *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.handle);
		*r->out.handle = *r->in.handle;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_CloseKey(struct ndr_print *ndr, const char *name, int flags, const struct winreg_CloseKey *r)
{
	ndr_print_struct(ndr, name, "winreg_CloseKey");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_CloseKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_CloseKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_CreateKey(struct ndr_push *ndr, int flags, const struct winreg_CreateKey *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.name));
		NDR_CHECK(ndr_push_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.keyclass));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.options));
		NDR_CHECK(ndr_push_winreg_AccessMask(ndr, NDR_SCALARS, r->in.access_mask));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.secdesc));
		if (r->in.secdesc) {
			NDR_CHECK(ndr_push_winreg_SecBuf(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.secdesc));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.action_taken));
		if (r->in.action_taken) {
			NDR_CHECK(ndr_push_winreg_CreateAction(ndr, NDR_SCALARS, *r->in.action_taken));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.new_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.new_handle));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.action_taken));
		if (r->out.action_taken) {
			NDR_CHECK(ndr_push_winreg_CreateAction(ndr, NDR_SCALARS, *r->out.action_taken));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_CreateKey(struct ndr_pull *ndr, int flags, struct winreg_CreateKey *r)
{
	uint32_t _ptr_secdesc;
	uint32_t _ptr_action_taken;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_secdesc_0;
	TALLOC_CTX *_mem_save_new_handle_0;
	TALLOC_CTX *_mem_save_action_taken_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.name));
		NDR_CHECK(ndr_pull_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.keyclass));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.options));
		NDR_CHECK(ndr_pull_winreg_AccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_secdesc));
		if (_ptr_secdesc) {
			NDR_PULL_ALLOC(ndr, r->in.secdesc);
		} else {
			r->in.secdesc = NULL;
		}
		if (r->in.secdesc) {
			_mem_save_secdesc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.secdesc, 0);
			NDR_CHECK(ndr_pull_winreg_SecBuf(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.secdesc));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_secdesc_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_action_taken));
		if (_ptr_action_taken) {
			NDR_PULL_ALLOC(ndr, r->in.action_taken);
		} else {
			r->in.action_taken = NULL;
		}
		if (r->in.action_taken) {
			_mem_save_action_taken_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.action_taken, 0);
			NDR_CHECK(ndr_pull_winreg_CreateAction(ndr, NDR_SCALARS, r->in.action_taken));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_action_taken_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.new_handle);
		ZERO_STRUCTP(r->out.new_handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.new_handle);
		}
		_mem_save_new_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.new_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.new_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_new_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_action_taken));
		if (_ptr_action_taken) {
			NDR_PULL_ALLOC(ndr, r->out.action_taken);
		} else {
			r->out.action_taken = NULL;
		}
		if (r->out.action_taken) {
			_mem_save_action_taken_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.action_taken, 0);
			NDR_CHECK(ndr_pull_winreg_CreateAction(ndr, NDR_SCALARS, r->out.action_taken));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_action_taken_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_CreateKey(struct ndr_print *ndr, const char *name, int flags, const struct winreg_CreateKey *r)
{
	ndr_print_struct(ndr, name, "winreg_CreateKey");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_CreateKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_winreg_String(ndr, "name", &r->in.name);
		ndr_print_winreg_String(ndr, "keyclass", &r->in.keyclass);
		ndr_print_uint32(ndr, "options", r->in.options);
		ndr_print_winreg_AccessMask(ndr, "access_mask", r->in.access_mask);
		ndr_print_ptr(ndr, "secdesc", r->in.secdesc);
		ndr->depth++;
		if (r->in.secdesc) {
			ndr_print_winreg_SecBuf(ndr, "secdesc", r->in.secdesc);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "action_taken", r->in.action_taken);
		ndr->depth++;
		if (r->in.action_taken) {
			ndr_print_winreg_CreateAction(ndr, "action_taken", *r->in.action_taken);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_CreateKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "new_handle", r->out.new_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "new_handle", r->out.new_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "action_taken", r->out.action_taken);
		ndr->depth++;
		if (r->out.action_taken) {
			ndr_print_winreg_CreateAction(ndr, "action_taken", *r->out.action_taken);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_DeleteKey(struct ndr_push *ndr, int flags, const struct winreg_DeleteKey *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.key));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_DeleteKey(struct ndr_pull *ndr, int flags, struct winreg_DeleteKey *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.key));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_DeleteKey(struct ndr_print *ndr, const char *name, int flags, const struct winreg_DeleteKey *r)
{
	ndr_print_struct(ndr, name, "winreg_DeleteKey");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_DeleteKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_winreg_String(ndr, "key", &r->in.key);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_DeleteKey");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_DeleteValue(struct ndr_push *ndr, int flags, const struct winreg_DeleteValue *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.value));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_DeleteValue(struct ndr_pull *ndr, int flags, struct winreg_DeleteValue *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.value));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_DeleteValue(struct ndr_print *ndr, const char *name, int flags, const struct winreg_DeleteValue *r)
{
	ndr_print_struct(ndr, name, "winreg_DeleteValue");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_DeleteValue");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_winreg_String(ndr, "value", &r->in.value);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_DeleteValue");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_EnumKey(struct ndr_push *ndr, int flags, const struct winreg_EnumKey *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.enum_index));
		if (r->in.name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winreg_StringBuf(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.keyclass));
		if (r->in.keyclass) {
			NDR_CHECK(ndr_push_winreg_StringBuf(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.keyclass));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.last_changed_time));
		if (r->in.last_changed_time) {
			NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, *r->in.last_changed_time));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winreg_StringBuf(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.keyclass));
		if (r->out.keyclass) {
			NDR_CHECK(ndr_push_winreg_StringBuf(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.keyclass));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.last_changed_time));
		if (r->out.last_changed_time) {
			NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, *r->out.last_changed_time));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_EnumKey(struct ndr_pull *ndr, int flags, struct winreg_EnumKey *r)
{
	uint32_t _ptr_keyclass;
	uint32_t _ptr_last_changed_time;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_name_0;
	TALLOC_CTX *_mem_save_keyclass_0;
	TALLOC_CTX *_mem_save_last_changed_time_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.enum_index));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.name);
		}
		_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winreg_StringBuf(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_keyclass));
		if (_ptr_keyclass) {
			NDR_PULL_ALLOC(ndr, r->in.keyclass);
		} else {
			r->in.keyclass = NULL;
		}
		if (r->in.keyclass) {
			_mem_save_keyclass_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.keyclass, 0);
			NDR_CHECK(ndr_pull_winreg_StringBuf(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.keyclass));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_keyclass_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_last_changed_time));
		if (_ptr_last_changed_time) {
			NDR_PULL_ALLOC(ndr, r->in.last_changed_time);
		} else {
			r->in.last_changed_time = NULL;
		}
		if (r->in.last_changed_time) {
			_mem_save_last_changed_time_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.last_changed_time, 0);
			NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, r->in.last_changed_time));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_last_changed_time_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.name);
		*r->out.name = *r->in.name;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.name);
		}
		_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winreg_StringBuf(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.name));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_keyclass));
		if (_ptr_keyclass) {
			NDR_PULL_ALLOC(ndr, r->out.keyclass);
		} else {
			r->out.keyclass = NULL;
		}
		if (r->out.keyclass) {
			_mem_save_keyclass_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.keyclass, 0);
			NDR_CHECK(ndr_pull_winreg_StringBuf(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.keyclass));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_keyclass_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_last_changed_time));
		if (_ptr_last_changed_time) {
			NDR_PULL_ALLOC(ndr, r->out.last_changed_time);
		} else {
			r->out.last_changed_time = NULL;
		}
		if (r->out.last_changed_time) {
			_mem_save_last_changed_time_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.last_changed_time, 0);
			NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, r->out.last_changed_time));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_last_changed_time_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_EnumKey(struct ndr_print *ndr, const char *name, int flags, const struct winreg_EnumKey *r)
{
	ndr_print_struct(ndr, name, "winreg_EnumKey");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_EnumKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "enum_index", r->in.enum_index);
		ndr_print_ptr(ndr, "name", r->in.name);
		ndr->depth++;
		ndr_print_winreg_StringBuf(ndr, "name", r->in.name);
		ndr->depth--;
		ndr_print_ptr(ndr, "keyclass", r->in.keyclass);
		ndr->depth++;
		if (r->in.keyclass) {
			ndr_print_winreg_StringBuf(ndr, "keyclass", r->in.keyclass);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "last_changed_time", r->in.last_changed_time);
		ndr->depth++;
		if (r->in.last_changed_time) {
			ndr_print_NTTIME(ndr, "last_changed_time", *r->in.last_changed_time);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_EnumKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "name", r->out.name);
		ndr->depth++;
		ndr_print_winreg_StringBuf(ndr, "name", r->out.name);
		ndr->depth--;
		ndr_print_ptr(ndr, "keyclass", r->out.keyclass);
		ndr->depth++;
		if (r->out.keyclass) {
			ndr_print_winreg_StringBuf(ndr, "keyclass", r->out.keyclass);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "last_changed_time", r->out.last_changed_time);
		ndr->depth++;
		if (r->out.last_changed_time) {
			ndr_print_NTTIME(ndr, "last_changed_time", *r->out.last_changed_time);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_EnumValue(struct ndr_push *ndr, int flags, const struct winreg_EnumValue *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.enum_index));
		if (r->in.name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winreg_ValNameBuf(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.type));
		if (r->in.type) {
			NDR_CHECK(ndr_push_winreg_Type(ndr, NDR_SCALARS, *r->in.type));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.value));
		if (r->in.value) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.size));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.length));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.value, *r->in.length));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.size));
		if (r->in.size) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.size));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.length));
		if (r->in.length) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.length));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winreg_ValNameBuf(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.type));
		if (r->out.type) {
			NDR_CHECK(ndr_push_winreg_Type(ndr, NDR_SCALARS, *r->out.type));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.value));
		if (r->out.value) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.size));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.length));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.value, *r->out.length));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.size));
		if (r->out.size) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.size));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.length));
		if (r->out.length) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.length));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_EnumValue(struct ndr_pull *ndr, int flags, struct winreg_EnumValue *r)
{
	uint32_t _ptr_type;
	uint32_t _ptr_value;
	uint32_t _ptr_size;
	uint32_t _ptr_length;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_name_0;
	TALLOC_CTX *_mem_save_type_0;
	TALLOC_CTX *_mem_save_value_0;
	TALLOC_CTX *_mem_save_size_0;
	TALLOC_CTX *_mem_save_length_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.enum_index));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.name);
		}
		_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winreg_ValNameBuf(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.name));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_type));
		if (_ptr_type) {
			NDR_PULL_ALLOC(ndr, r->in.type);
		} else {
			r->in.type = NULL;
		}
		if (r->in.type) {
			_mem_save_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.type, 0);
			NDR_CHECK(ndr_pull_winreg_Type(ndr, NDR_SCALARS, r->in.type));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_type_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_value));
		if (_ptr_value) {
			NDR_PULL_ALLOC(ndr, r->in.value);
		} else {
			r->in.value = NULL;
		}
		if (r->in.value) {
			_mem_save_value_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.value, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.value));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.value));
			if (ndr_get_array_length(ndr, &r->in.value) > ndr_get_array_size(ndr, &r->in.value)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.value), ndr_get_array_length(ndr, &r->in.value));
			}
			NDR_PULL_ALLOC_N(ndr, r->in.value, ndr_get_array_size(ndr, &r->in.value));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.value, ndr_get_array_length(ndr, &r->in.value)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_value_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_size));
		if (_ptr_size) {
			NDR_PULL_ALLOC(ndr, r->in.size);
		} else {
			r->in.size = NULL;
		}
		if (r->in.size) {
			_mem_save_size_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.size, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.size));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_size_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_length));
		if (_ptr_length) {
			NDR_PULL_ALLOC(ndr, r->in.length);
		} else {
			r->in.length = NULL;
		}
		if (r->in.length) {
			_mem_save_length_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.length, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.length));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_length_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.name);
		*r->out.name = *r->in.name;
		if (r->in.value) {
			if (r->in.size == NULL) return ndr_pull_error(ndr, NDR_ERR_INVALID_POINTER, "NULL Pointer for size_is()");
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.value, *r->in.size));
		}
		if (r->in.value) {
			if (r->in.length == NULL) return ndr_pull_error(ndr, NDR_ERR_INVALID_POINTER, "NULL Pointer for length_is()");
			NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->in.value, *r->in.length));
		}
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.name);
		}
		_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winreg_ValNameBuf(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.name));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_type));
		if (_ptr_type) {
			NDR_PULL_ALLOC(ndr, r->out.type);
		} else {
			r->out.type = NULL;
		}
		if (r->out.type) {
			_mem_save_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.type, 0);
			NDR_CHECK(ndr_pull_winreg_Type(ndr, NDR_SCALARS, r->out.type));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_type_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_value));
		if (_ptr_value) {
			NDR_PULL_ALLOC(ndr, r->out.value);
		} else {
			r->out.value = NULL;
		}
		if (r->out.value) {
			_mem_save_value_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.value, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->out.value));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->out.value));
			if (ndr_get_array_length(ndr, &r->out.value) > ndr_get_array_size(ndr, &r->out.value)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->out.value), ndr_get_array_length(ndr, &r->out.value));
			}
			NDR_PULL_ALLOC_N(ndr, r->out.value, ndr_get_array_size(ndr, &r->out.value));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.value, ndr_get_array_length(ndr, &r->out.value)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_value_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_size));
		if (_ptr_size) {
			NDR_PULL_ALLOC(ndr, r->out.size);
		} else {
			r->out.size = NULL;
		}
		if (r->out.size) {
			_mem_save_size_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.size, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.size));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_size_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_length));
		if (_ptr_length) {
			NDR_PULL_ALLOC(ndr, r->out.length);
		} else {
			r->out.length = NULL;
		}
		if (r->out.length) {
			_mem_save_length_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.length, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.length));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_length_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.value) {
			if (r->out.size == NULL) return ndr_pull_error(ndr, NDR_ERR_INVALID_POINTER, "NULL Pointer for size_is()");
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.value, *r->out.size));
		}
		if (r->out.value) {
			if (r->out.length == NULL) return ndr_pull_error(ndr, NDR_ERR_INVALID_POINTER, "NULL Pointer for length_is()");
			NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->out.value, *r->out.length));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_EnumValue(struct ndr_print *ndr, const char *name, int flags, const struct winreg_EnumValue *r)
{
	ndr_print_struct(ndr, name, "winreg_EnumValue");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_EnumValue");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "enum_index", r->in.enum_index);
		ndr_print_ptr(ndr, "name", r->in.name);
		ndr->depth++;
		ndr_print_winreg_ValNameBuf(ndr, "name", r->in.name);
		ndr->depth--;
		ndr_print_ptr(ndr, "type", r->in.type);
		ndr->depth++;
		if (r->in.type) {
			ndr_print_winreg_Type(ndr, "type", *r->in.type);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "value", r->in.value);
		ndr->depth++;
		if (r->in.value) {
			if (r->in.length == NULL) return;
			ndr_print_array_uint8(ndr, "value", r->in.value, *r->in.length);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "size", r->in.size);
		ndr->depth++;
		if (r->in.size) {
			ndr_print_uint32(ndr, "size", *r->in.size);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "length", r->in.length);
		ndr->depth++;
		if (r->in.length) {
			ndr_print_uint32(ndr, "length", *r->in.length);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_EnumValue");
		ndr->depth++;
		ndr_print_ptr(ndr, "name", r->out.name);
		ndr->depth++;
		ndr_print_winreg_ValNameBuf(ndr, "name", r->out.name);
		ndr->depth--;
		ndr_print_ptr(ndr, "type", r->out.type);
		ndr->depth++;
		if (r->out.type) {
			ndr_print_winreg_Type(ndr, "type", *r->out.type);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "value", r->out.value);
		ndr->depth++;
		if (r->out.value) {
			if (r->out.length == NULL) return;
			ndr_print_array_uint8(ndr, "value", r->out.value, *r->out.length);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "size", r->out.size);
		ndr->depth++;
		if (r->out.size) {
			ndr_print_uint32(ndr, "size", *r->out.size);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "length", r->out.length);
		ndr->depth++;
		if (r->out.length) {
			ndr_print_uint32(ndr, "length", *r->out.length);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_FlushKey(struct ndr_push *ndr, int flags, const struct winreg_FlushKey *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_FlushKey(struct ndr_pull *ndr, int flags, struct winreg_FlushKey *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_FlushKey(struct ndr_print *ndr, const char *name, int flags, const struct winreg_FlushKey *r)
{
	ndr_print_struct(ndr, name, "winreg_FlushKey");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_FlushKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_FlushKey");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_GetKeySecurity(struct ndr_push *ndr, int flags, const struct winreg_GetKeySecurity *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_security_secinfo(ndr, NDR_SCALARS, r->in.sec_info));
		if (r->in.sd == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_KeySecurityData(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sd));
	}
	if (flags & NDR_OUT) {
		if (r->out.sd == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_KeySecurityData(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sd));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_GetKeySecurity(struct ndr_pull *ndr, int flags, struct winreg_GetKeySecurity *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_sd_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_security_secinfo(ndr, NDR_SCALARS, &r->in.sec_info));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sd);
		}
		_mem_save_sd_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sd, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_KeySecurityData(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sd));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sd_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.sd);
		*r->out.sd = *r->in.sd;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sd);
		}
		_mem_save_sd_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sd, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_KeySecurityData(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.sd));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sd_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_GetKeySecurity(struct ndr_print *ndr, const char *name, int flags, const struct winreg_GetKeySecurity *r)
{
	ndr_print_struct(ndr, name, "winreg_GetKeySecurity");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_GetKeySecurity");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_security_secinfo(ndr, "sec_info", r->in.sec_info);
		ndr_print_ptr(ndr, "sd", r->in.sd);
		ndr->depth++;
		ndr_print_KeySecurityData(ndr, "sd", r->in.sd);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_GetKeySecurity");
		ndr->depth++;
		ndr_print_ptr(ndr, "sd", r->out.sd);
		ndr->depth++;
		ndr_print_KeySecurityData(ndr, "sd", r->out.sd);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_LoadKey(struct ndr_push *ndr, int flags, const struct winreg_LoadKey *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.keyname));
		if (r->in.keyname) {
			NDR_CHECK(ndr_push_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.keyname));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.filename));
		if (r->in.filename) {
			NDR_CHECK(ndr_push_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.filename));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_LoadKey(struct ndr_pull *ndr, int flags, struct winreg_LoadKey *r)
{
	uint32_t _ptr_keyname;
	uint32_t _ptr_filename;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_keyname_0;
	TALLOC_CTX *_mem_save_filename_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_keyname));
		if (_ptr_keyname) {
			NDR_PULL_ALLOC(ndr, r->in.keyname);
		} else {
			r->in.keyname = NULL;
		}
		if (r->in.keyname) {
			_mem_save_keyname_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.keyname, 0);
			NDR_CHECK(ndr_pull_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.keyname));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_keyname_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_filename));
		if (_ptr_filename) {
			NDR_PULL_ALLOC(ndr, r->in.filename);
		} else {
			r->in.filename = NULL;
		}
		if (r->in.filename) {
			_mem_save_filename_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.filename, 0);
			NDR_CHECK(ndr_pull_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.filename));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_filename_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_LoadKey(struct ndr_print *ndr, const char *name, int flags, const struct winreg_LoadKey *r)
{
	ndr_print_struct(ndr, name, "winreg_LoadKey");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_LoadKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "keyname", r->in.keyname);
		ndr->depth++;
		if (r->in.keyname) {
			ndr_print_winreg_String(ndr, "keyname", r->in.keyname);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "filename", r->in.filename);
		ndr->depth++;
		if (r->in.filename) {
			ndr_print_winreg_String(ndr, "filename", r->in.filename);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_LoadKey");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_NotifyChangeKeyValue(struct ndr_push *ndr, int flags, const struct winreg_NotifyChangeKeyValue *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in.watch_subtree));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.notify_filter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown));
		NDR_CHECK(ndr_push_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.string1));
		NDR_CHECK(ndr_push_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.string2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown2));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_NotifyChangeKeyValue(struct ndr_pull *ndr, int flags, struct winreg_NotifyChangeKeyValue *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in.watch_subtree));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.notify_filter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown));
		NDR_CHECK(ndr_pull_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.string1));
		NDR_CHECK(ndr_pull_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.string2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown2));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_NotifyChangeKeyValue(struct ndr_print *ndr, const char *name, int flags, const struct winreg_NotifyChangeKeyValue *r)
{
	ndr_print_struct(ndr, name, "winreg_NotifyChangeKeyValue");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_NotifyChangeKeyValue");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint8(ndr, "watch_subtree", r->in.watch_subtree);
		ndr_print_uint32(ndr, "notify_filter", r->in.notify_filter);
		ndr_print_uint32(ndr, "unknown", r->in.unknown);
		ndr_print_winreg_String(ndr, "string1", &r->in.string1);
		ndr_print_winreg_String(ndr, "string2", &r->in.string2);
		ndr_print_uint32(ndr, "unknown2", r->in.unknown2);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_NotifyChangeKeyValue");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_OpenKey(struct ndr_push *ndr, int flags, const struct winreg_OpenKey *r)
{
	if (flags & NDR_IN) {
		if (r->in.parent_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.parent_handle));
		NDR_CHECK(ndr_push_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.keyname));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown));
		NDR_CHECK(ndr_push_winreg_AccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_OpenKey(struct ndr_pull *ndr, int flags, struct winreg_OpenKey *r)
{
	TALLOC_CTX *_mem_save_parent_handle_0;
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.parent_handle);
		}
		_mem_save_parent_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.parent_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.parent_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_parent_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.keyname));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown));
		NDR_CHECK(ndr_pull_winreg_AccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_OpenKey(struct ndr_print *ndr, const char *name, int flags, const struct winreg_OpenKey *r)
{
	ndr_print_struct(ndr, name, "winreg_OpenKey");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_OpenKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "parent_handle", r->in.parent_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "parent_handle", r->in.parent_handle);
		ndr->depth--;
		ndr_print_winreg_String(ndr, "keyname", &r->in.keyname);
		ndr_print_uint32(ndr, "unknown", r->in.unknown);
		ndr_print_winreg_AccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_OpenKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_QueryInfoKey(struct ndr_push *ndr, int flags, const struct winreg_QueryInfoKey *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		if (r->in.classname == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.classname));
	}
	if (flags & NDR_OUT) {
		if (r->out.classname == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.classname));
		if (r->out.num_subkeys == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.num_subkeys));
		if (r->out.max_subkeylen == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.max_subkeylen));
		if (r->out.max_classlen == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.max_classlen));
		if (r->out.num_values == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.num_values));
		if (r->out.max_valnamelen == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.max_valnamelen));
		if (r->out.max_valbufsize == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.max_valbufsize));
		if (r->out.secdescsize == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.secdescsize));
		if (r->out.last_changed_time == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, *r->out.last_changed_time));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_QueryInfoKey(struct ndr_pull *ndr, int flags, struct winreg_QueryInfoKey *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_classname_0;
	TALLOC_CTX *_mem_save_num_subkeys_0;
	TALLOC_CTX *_mem_save_max_subkeylen_0;
	TALLOC_CTX *_mem_save_max_classlen_0;
	TALLOC_CTX *_mem_save_num_values_0;
	TALLOC_CTX *_mem_save_max_valnamelen_0;
	TALLOC_CTX *_mem_save_max_valbufsize_0;
	TALLOC_CTX *_mem_save_secdescsize_0;
	TALLOC_CTX *_mem_save_last_changed_time_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.classname);
		}
		_mem_save_classname_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.classname, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.classname));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_classname_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.classname);
		*r->out.classname = *r->in.classname;
		NDR_PULL_ALLOC(ndr, r->out.num_subkeys);
		ZERO_STRUCTP(r->out.num_subkeys);
		NDR_PULL_ALLOC(ndr, r->out.max_subkeylen);
		ZERO_STRUCTP(r->out.max_subkeylen);
		NDR_PULL_ALLOC(ndr, r->out.max_classlen);
		ZERO_STRUCTP(r->out.max_classlen);
		NDR_PULL_ALLOC(ndr, r->out.num_values);
		ZERO_STRUCTP(r->out.num_values);
		NDR_PULL_ALLOC(ndr, r->out.max_valnamelen);
		ZERO_STRUCTP(r->out.max_valnamelen);
		NDR_PULL_ALLOC(ndr, r->out.max_valbufsize);
		ZERO_STRUCTP(r->out.max_valbufsize);
		NDR_PULL_ALLOC(ndr, r->out.secdescsize);
		ZERO_STRUCTP(r->out.secdescsize);
		NDR_PULL_ALLOC(ndr, r->out.last_changed_time);
		ZERO_STRUCTP(r->out.last_changed_time);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.classname);
		}
		_mem_save_classname_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.classname, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.classname));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_classname_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.num_subkeys);
		}
		_mem_save_num_subkeys_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.num_subkeys, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.num_subkeys));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_num_subkeys_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.max_subkeylen);
		}
		_mem_save_max_subkeylen_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.max_subkeylen, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.max_subkeylen));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_max_subkeylen_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.max_classlen);
		}
		_mem_save_max_classlen_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.max_classlen, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.max_classlen));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_max_classlen_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.num_values);
		}
		_mem_save_num_values_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.num_values, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.num_values));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_num_values_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.max_valnamelen);
		}
		_mem_save_max_valnamelen_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.max_valnamelen, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.max_valnamelen));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_max_valnamelen_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.max_valbufsize);
		}
		_mem_save_max_valbufsize_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.max_valbufsize, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.max_valbufsize));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_max_valbufsize_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.secdescsize);
		}
		_mem_save_secdescsize_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.secdescsize, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.secdescsize));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_secdescsize_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.last_changed_time);
		}
		_mem_save_last_changed_time_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.last_changed_time, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, r->out.last_changed_time));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_last_changed_time_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_QueryInfoKey(struct ndr_print *ndr, const char *name, int flags, const struct winreg_QueryInfoKey *r)
{
	ndr_print_struct(ndr, name, "winreg_QueryInfoKey");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_QueryInfoKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "classname", r->in.classname);
		ndr->depth++;
		ndr_print_winreg_String(ndr, "classname", r->in.classname);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_QueryInfoKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "classname", r->out.classname);
		ndr->depth++;
		ndr_print_winreg_String(ndr, "classname", r->out.classname);
		ndr->depth--;
		ndr_print_ptr(ndr, "num_subkeys", r->out.num_subkeys);
		ndr->depth++;
		ndr_print_uint32(ndr, "num_subkeys", *r->out.num_subkeys);
		ndr->depth--;
		ndr_print_ptr(ndr, "max_subkeylen", r->out.max_subkeylen);
		ndr->depth++;
		ndr_print_uint32(ndr, "max_subkeylen", *r->out.max_subkeylen);
		ndr->depth--;
		ndr_print_ptr(ndr, "max_classlen", r->out.max_classlen);
		ndr->depth++;
		ndr_print_uint32(ndr, "max_classlen", *r->out.max_classlen);
		ndr->depth--;
		ndr_print_ptr(ndr, "num_values", r->out.num_values);
		ndr->depth++;
		ndr_print_uint32(ndr, "num_values", *r->out.num_values);
		ndr->depth--;
		ndr_print_ptr(ndr, "max_valnamelen", r->out.max_valnamelen);
		ndr->depth++;
		ndr_print_uint32(ndr, "max_valnamelen", *r->out.max_valnamelen);
		ndr->depth--;
		ndr_print_ptr(ndr, "max_valbufsize", r->out.max_valbufsize);
		ndr->depth++;
		ndr_print_uint32(ndr, "max_valbufsize", *r->out.max_valbufsize);
		ndr->depth--;
		ndr_print_ptr(ndr, "secdescsize", r->out.secdescsize);
		ndr->depth++;
		ndr_print_uint32(ndr, "secdescsize", *r->out.secdescsize);
		ndr->depth--;
		ndr_print_ptr(ndr, "last_changed_time", r->out.last_changed_time);
		ndr->depth++;
		ndr_print_NTTIME(ndr, "last_changed_time", *r->out.last_changed_time);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_QueryValue(struct ndr_push *ndr, int flags, const struct winreg_QueryValue *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		if (r->in.value_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.value_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.type));
		if (r->in.type) {
			NDR_CHECK(ndr_push_winreg_Type(ndr, NDR_SCALARS, *r->in.type));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.data));
		if (r->in.data) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.data_size));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.value_length));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.data, *r->in.value_length));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.data_size));
		if (r->in.data_size) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.data_size));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.value_length));
		if (r->in.value_length) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.value_length));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.type));
		if (r->out.type) {
			NDR_CHECK(ndr_push_winreg_Type(ndr, NDR_SCALARS, *r->out.type));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.data));
		if (r->out.data) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.data_size));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.value_length));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.data, *r->out.value_length));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.data_size));
		if (r->out.data_size) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.data_size));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.value_length));
		if (r->out.value_length) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.value_length));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_QueryValue(struct ndr_pull *ndr, int flags, struct winreg_QueryValue *r)
{
	uint32_t _ptr_type;
	uint32_t _ptr_data;
	uint32_t _ptr_data_size;
	uint32_t _ptr_value_length;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_value_name_0;
	TALLOC_CTX *_mem_save_type_0;
	TALLOC_CTX *_mem_save_data_0;
	TALLOC_CTX *_mem_save_data_size_0;
	TALLOC_CTX *_mem_save_value_length_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.value_name);
		}
		_mem_save_value_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.value_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.value_name));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_value_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_type));
		if (_ptr_type) {
			NDR_PULL_ALLOC(ndr, r->in.type);
		} else {
			r->in.type = NULL;
		}
		if (r->in.type) {
			_mem_save_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.type, 0);
			NDR_CHECK(ndr_pull_winreg_Type(ndr, NDR_SCALARS, r->in.type));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_type_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data));
		if (_ptr_data) {
			NDR_PULL_ALLOC(ndr, r->in.data);
		} else {
			r->in.data = NULL;
		}
		if (r->in.data) {
			_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.data, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.data));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.data));
			if (ndr_get_array_length(ndr, &r->in.data) > ndr_get_array_size(ndr, &r->in.data)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.data), ndr_get_array_length(ndr, &r->in.data));
			}
			NDR_PULL_ALLOC_N(ndr, r->in.data, ndr_get_array_size(ndr, &r->in.data));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.data, ndr_get_array_length(ndr, &r->in.data)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data_size));
		if (_ptr_data_size) {
			NDR_PULL_ALLOC(ndr, r->in.data_size);
		} else {
			r->in.data_size = NULL;
		}
		if (r->in.data_size) {
			_mem_save_data_size_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.data_size, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.data_size));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_size_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_value_length));
		if (_ptr_value_length) {
			NDR_PULL_ALLOC(ndr, r->in.value_length);
		} else {
			r->in.value_length = NULL;
		}
		if (r->in.value_length) {
			_mem_save_value_length_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.value_length, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.value_length));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_value_length_0, 0);
		}
		if (r->in.data) {
			if (r->in.data_size == NULL) return ndr_pull_error(ndr, NDR_ERR_INVALID_POINTER, "NULL Pointer for size_is()");
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.data, *r->in.data_size));
		}
		if (r->in.data) {
			if (r->in.value_length == NULL) return ndr_pull_error(ndr, NDR_ERR_INVALID_POINTER, "NULL Pointer for length_is()");
			NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->in.data, *r->in.value_length));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_type));
		if (_ptr_type) {
			NDR_PULL_ALLOC(ndr, r->out.type);
		} else {
			r->out.type = NULL;
		}
		if (r->out.type) {
			_mem_save_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.type, 0);
			NDR_CHECK(ndr_pull_winreg_Type(ndr, NDR_SCALARS, r->out.type));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_type_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data));
		if (_ptr_data) {
			NDR_PULL_ALLOC(ndr, r->out.data);
		} else {
			r->out.data = NULL;
		}
		if (r->out.data) {
			_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.data, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->out.data));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->out.data));
			if (ndr_get_array_length(ndr, &r->out.data) > ndr_get_array_size(ndr, &r->out.data)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->out.data), ndr_get_array_length(ndr, &r->out.data));
			}
			NDR_PULL_ALLOC_N(ndr, r->out.data, ndr_get_array_size(ndr, &r->out.data));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.data, ndr_get_array_length(ndr, &r->out.data)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data_size));
		if (_ptr_data_size) {
			NDR_PULL_ALLOC(ndr, r->out.data_size);
		} else {
			r->out.data_size = NULL;
		}
		if (r->out.data_size) {
			_mem_save_data_size_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.data_size, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.data_size));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_size_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_value_length));
		if (_ptr_value_length) {
			NDR_PULL_ALLOC(ndr, r->out.value_length);
		} else {
			r->out.value_length = NULL;
		}
		if (r->out.value_length) {
			_mem_save_value_length_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.value_length, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.value_length));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_value_length_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.data) {
			if (r->out.data_size == NULL) return ndr_pull_error(ndr, NDR_ERR_INVALID_POINTER, "NULL Pointer for size_is()");
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.data, *r->out.data_size));
		}
		if (r->out.data) {
			if (r->out.value_length == NULL) return ndr_pull_error(ndr, NDR_ERR_INVALID_POINTER, "NULL Pointer for length_is()");
			NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->out.data, *r->out.value_length));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_QueryValue(struct ndr_print *ndr, const char *name, int flags, const struct winreg_QueryValue *r)
{
	ndr_print_struct(ndr, name, "winreg_QueryValue");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_QueryValue");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "value_name", r->in.value_name);
		ndr->depth++;
		ndr_print_winreg_String(ndr, "value_name", r->in.value_name);
		ndr->depth--;
		ndr_print_ptr(ndr, "type", r->in.type);
		ndr->depth++;
		if (r->in.type) {
			ndr_print_winreg_Type(ndr, "type", *r->in.type);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "data", r->in.data);
		ndr->depth++;
		if (r->in.data) {
			if (r->in.value_length == NULL) return;
			ndr_print_array_uint8(ndr, "data", r->in.data, *r->in.value_length);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "data_size", r->in.data_size);
		ndr->depth++;
		if (r->in.data_size) {
			ndr_print_uint32(ndr, "data_size", *r->in.data_size);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "value_length", r->in.value_length);
		ndr->depth++;
		if (r->in.value_length) {
			ndr_print_uint32(ndr, "value_length", *r->in.value_length);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_QueryValue");
		ndr->depth++;
		ndr_print_ptr(ndr, "type", r->out.type);
		ndr->depth++;
		if (r->out.type) {
			ndr_print_winreg_Type(ndr, "type", *r->out.type);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "data", r->out.data);
		ndr->depth++;
		if (r->out.data) {
			if (r->out.value_length == NULL) return;
			ndr_print_array_uint8(ndr, "data", r->out.data, *r->out.value_length);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "data_size", r->out.data_size);
		ndr->depth++;
		if (r->out.data_size) {
			ndr_print_uint32(ndr, "data_size", *r->out.data_size);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "value_length", r->out.value_length);
		ndr->depth++;
		if (r->out.value_length) {
			ndr_print_uint32(ndr, "value_length", *r->out.value_length);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_ReplaceKey(struct ndr_push *ndr, int flags, const struct winreg_ReplaceKey *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_ReplaceKey(struct ndr_pull *ndr, int flags, struct winreg_ReplaceKey *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_ReplaceKey(struct ndr_print *ndr, const char *name, int flags, const struct winreg_ReplaceKey *r)
{
	ndr_print_struct(ndr, name, "winreg_ReplaceKey");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_ReplaceKey");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_ReplaceKey");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_RestoreKey(struct ndr_push *ndr, int flags, const struct winreg_RestoreKey *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		if (r->in.filename == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.filename));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_RestoreKey(struct ndr_pull *ndr, int flags, struct winreg_RestoreKey *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_filename_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.filename);
		}
		_mem_save_filename_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.filename, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.filename));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_filename_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_RestoreKey(struct ndr_print *ndr, const char *name, int flags, const struct winreg_RestoreKey *r)
{
	ndr_print_struct(ndr, name, "winreg_RestoreKey");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_RestoreKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "filename", r->in.filename);
		ndr->depth++;
		ndr_print_winreg_String(ndr, "filename", r->in.filename);
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_RestoreKey");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_SaveKey(struct ndr_push *ndr, int flags, const struct winreg_SaveKey *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		if (r->in.filename == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.filename));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.sec_attrib));
		if (r->in.sec_attrib) {
			NDR_CHECK(ndr_push_KeySecurityAttribute(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sec_attrib));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_SaveKey(struct ndr_pull *ndr, int flags, struct winreg_SaveKey *r)
{
	uint32_t _ptr_sec_attrib;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_filename_0;
	TALLOC_CTX *_mem_save_sec_attrib_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.filename);
		}
		_mem_save_filename_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.filename, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.filename));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_filename_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sec_attrib));
		if (_ptr_sec_attrib) {
			NDR_PULL_ALLOC(ndr, r->in.sec_attrib);
		} else {
			r->in.sec_attrib = NULL;
		}
		if (r->in.sec_attrib) {
			_mem_save_sec_attrib_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.sec_attrib, 0);
			NDR_CHECK(ndr_pull_KeySecurityAttribute(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sec_attrib));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sec_attrib_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_SaveKey(struct ndr_print *ndr, const char *name, int flags, const struct winreg_SaveKey *r)
{
	ndr_print_struct(ndr, name, "winreg_SaveKey");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_SaveKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "filename", r->in.filename);
		ndr->depth++;
		ndr_print_winreg_String(ndr, "filename", r->in.filename);
		ndr->depth--;
		ndr_print_ptr(ndr, "sec_attrib", r->in.sec_attrib);
		ndr->depth++;
		if (r->in.sec_attrib) {
			ndr_print_KeySecurityAttribute(ndr, "sec_attrib", r->in.sec_attrib);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_SaveKey");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_SetKeySecurity(struct ndr_push *ndr, int flags, const struct winreg_SetKeySecurity *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_winreg_AccessMask(ndr, NDR_SCALARS, r->in.access_mask));
		if (r->in.sd == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_KeySecurityData(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sd));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_SetKeySecurity(struct ndr_pull *ndr, int flags, struct winreg_SetKeySecurity *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_sd_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winreg_AccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sd);
		}
		_mem_save_sd_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sd, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_KeySecurityData(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sd));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sd_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_SetKeySecurity(struct ndr_print *ndr, const char *name, int flags, const struct winreg_SetKeySecurity *r)
{
	ndr_print_struct(ndr, name, "winreg_SetKeySecurity");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_SetKeySecurity");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_winreg_AccessMask(ndr, "access_mask", r->in.access_mask);
		ndr_print_ptr(ndr, "sd", r->in.sd);
		ndr->depth++;
		ndr_print_KeySecurityData(ndr, "sd", r->in.sd);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_SetKeySecurity");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_SetValue(struct ndr_push *ndr, int flags, const struct winreg_SetValue *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.name));
		NDR_CHECK(ndr_push_winreg_Type(ndr, NDR_SCALARS, r->in.type));
		if (r->in.data == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.size));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.data, r->in.size));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.size));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_SetValue(struct ndr_pull *ndr, int flags, struct winreg_SetValue *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winreg_String(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.name));
		NDR_CHECK(ndr_pull_winreg_Type(ndr, NDR_SCALARS, &r->in.type));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.data));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.data, ndr_get_array_size(ndr, &r->in.data));
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.data, ndr_get_array_size(ndr, &r->in.data)));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.size));
		if (r->in.data) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.data, r->in.size));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_SetValue(struct ndr_print *ndr, const char *name, int flags, const struct winreg_SetValue *r)
{
	ndr_print_struct(ndr, name, "winreg_SetValue");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_SetValue");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_winreg_String(ndr, "name", &r->in.name);
		ndr_print_winreg_Type(ndr, "type", r->in.type);
		ndr_print_ptr(ndr, "data", r->in.data);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "data", r->in.data, r->in.size);
		ndr->depth--;
		ndr_print_uint32(ndr, "size", r->in.size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_SetValue");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_UnLoadKey(struct ndr_push *ndr, int flags, const struct winreg_UnLoadKey *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_UnLoadKey(struct ndr_pull *ndr, int flags, struct winreg_UnLoadKey *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_UnLoadKey(struct ndr_print *ndr, const char *name, int flags, const struct winreg_UnLoadKey *r)
{
	ndr_print_struct(ndr, name, "winreg_UnLoadKey");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_UnLoadKey");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_UnLoadKey");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_InitiateSystemShutdown(struct ndr_push *ndr, int flags, const struct winreg_InitiateSystemShutdown *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.hostname));
		if (r->in.hostname) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->in.hostname));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.message));
		if (r->in.message) {
			NDR_CHECK(ndr_push_initshutdown_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.message));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.timeout));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in.force_apps));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in.do_reboot));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_InitiateSystemShutdown(struct ndr_pull *ndr, int flags, struct winreg_InitiateSystemShutdown *r)
{
	uint32_t _ptr_hostname;
	uint32_t _ptr_message;
	TALLOC_CTX *_mem_save_hostname_0;
	TALLOC_CTX *_mem_save_message_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_hostname));
		if (_ptr_hostname) {
			NDR_PULL_ALLOC(ndr, r->in.hostname);
		} else {
			r->in.hostname = NULL;
		}
		if (r->in.hostname) {
			_mem_save_hostname_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.hostname, 0);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->in.hostname));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hostname_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_message));
		if (_ptr_message) {
			NDR_PULL_ALLOC(ndr, r->in.message);
		} else {
			r->in.message = NULL;
		}
		if (r->in.message) {
			_mem_save_message_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.message, 0);
			NDR_CHECK(ndr_pull_initshutdown_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.message));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_message_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.timeout));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in.force_apps));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in.do_reboot));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_InitiateSystemShutdown(struct ndr_print *ndr, const char *name, int flags, const struct winreg_InitiateSystemShutdown *r)
{
	ndr_print_struct(ndr, name, "winreg_InitiateSystemShutdown");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_InitiateSystemShutdown");
		ndr->depth++;
		ndr_print_ptr(ndr, "hostname", r->in.hostname);
		ndr->depth++;
		if (r->in.hostname) {
			ndr_print_uint16(ndr, "hostname", *r->in.hostname);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "message", r->in.message);
		ndr->depth++;
		if (r->in.message) {
			ndr_print_initshutdown_String(ndr, "message", r->in.message);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "timeout", r->in.timeout);
		ndr_print_uint8(ndr, "force_apps", r->in.force_apps);
		ndr_print_uint8(ndr, "do_reboot", r->in.do_reboot);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_InitiateSystemShutdown");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_AbortSystemShutdown(struct ndr_push *ndr, int flags, const struct winreg_AbortSystemShutdown *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server));
		if (r->in.server) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->in.server));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_AbortSystemShutdown(struct ndr_pull *ndr, int flags, struct winreg_AbortSystemShutdown *r)
{
	uint32_t _ptr_server;
	TALLOC_CTX *_mem_save_server_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server));
		if (_ptr_server) {
			NDR_PULL_ALLOC(ndr, r->in.server);
		} else {
			r->in.server = NULL;
		}
		if (r->in.server) {
			_mem_save_server_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server, 0);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->in.server));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_AbortSystemShutdown(struct ndr_print *ndr, const char *name, int flags, const struct winreg_AbortSystemShutdown *r)
{
	ndr_print_struct(ndr, name, "winreg_AbortSystemShutdown");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_AbortSystemShutdown");
		ndr->depth++;
		ndr_print_ptr(ndr, "server", r->in.server);
		ndr->depth++;
		if (r->in.server) {
			ndr_print_uint16(ndr, "server", *r->in.server);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_AbortSystemShutdown");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_GetVersion(struct ndr_push *ndr, int flags, const struct winreg_GetVersion *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.version == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.version));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_GetVersion(struct ndr_pull *ndr, int flags, struct winreg_GetVersion *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_version_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.version);
		ZERO_STRUCTP(r->out.version);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.version);
		}
		_mem_save_version_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.version, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.version));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_version_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_GetVersion(struct ndr_print *ndr, const char *name, int flags, const struct winreg_GetVersion *r)
{
	ndr_print_struct(ndr, name, "winreg_GetVersion");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_GetVersion");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_GetVersion");
		ndr->depth++;
		ndr_print_ptr(ndr, "version", r->out.version);
		ndr->depth++;
		ndr_print_uint32(ndr, "version", *r->out.version);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_OpenHKCC(struct ndr_push *ndr, int flags, const struct winreg_OpenHKCC *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.system_name));
		if (r->in.system_name) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->in.system_name));
		}
		NDR_CHECK(ndr_push_winreg_AccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_OpenHKCC(struct ndr_pull *ndr, int flags, struct winreg_OpenHKCC *r)
{
	uint32_t _ptr_system_name;
	TALLOC_CTX *_mem_save_system_name_0;
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_system_name));
		if (_ptr_system_name) {
			NDR_PULL_ALLOC(ndr, r->in.system_name);
		} else {
			r->in.system_name = NULL;
		}
		if (r->in.system_name) {
			_mem_save_system_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.system_name, 0);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->in.system_name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_system_name_0, 0);
		}
		NDR_CHECK(ndr_pull_winreg_AccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_OpenHKCC(struct ndr_print *ndr, const char *name, int flags, const struct winreg_OpenHKCC *r)
{
	ndr_print_struct(ndr, name, "winreg_OpenHKCC");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_OpenHKCC");
		ndr->depth++;
		ndr_print_ptr(ndr, "system_name", r->in.system_name);
		ndr->depth++;
		if (r->in.system_name) {
			ndr_print_uint16(ndr, "system_name", *r->in.system_name);
		}
		ndr->depth--;
		ndr_print_winreg_AccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_OpenHKCC");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_OpenHKDD(struct ndr_push *ndr, int flags, const struct winreg_OpenHKDD *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.system_name));
		if (r->in.system_name) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->in.system_name));
		}
		NDR_CHECK(ndr_push_winreg_AccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_OpenHKDD(struct ndr_pull *ndr, int flags, struct winreg_OpenHKDD *r)
{
	uint32_t _ptr_system_name;
	TALLOC_CTX *_mem_save_system_name_0;
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_system_name));
		if (_ptr_system_name) {
			NDR_PULL_ALLOC(ndr, r->in.system_name);
		} else {
			r->in.system_name = NULL;
		}
		if (r->in.system_name) {
			_mem_save_system_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.system_name, 0);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->in.system_name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_system_name_0, 0);
		}
		NDR_CHECK(ndr_pull_winreg_AccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_OpenHKDD(struct ndr_print *ndr, const char *name, int flags, const struct winreg_OpenHKDD *r)
{
	ndr_print_struct(ndr, name, "winreg_OpenHKDD");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_OpenHKDD");
		ndr->depth++;
		ndr_print_ptr(ndr, "system_name", r->in.system_name);
		ndr->depth++;
		if (r->in.system_name) {
			ndr_print_uint16(ndr, "system_name", *r->in.system_name);
		}
		ndr->depth--;
		ndr_print_winreg_AccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_OpenHKDD");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_QueryMultipleValues(struct ndr_push *ndr, int flags, const struct winreg_QueryMultipleValues *r)
{
	uint32_t cntr_values_1;
	if (flags & NDR_IN) {
		if (r->in.key_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.key_handle));
		if (r->in.values == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_values));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_values));
		for (cntr_values_1 = 0; cntr_values_1 < r->in.num_values; cntr_values_1++) {
			NDR_CHECK(ndr_push_QueryMultipleValue(ndr, NDR_SCALARS, &r->in.values[cntr_values_1]));
		}
		for (cntr_values_1 = 0; cntr_values_1 < r->in.num_values; cntr_values_1++) {
			NDR_CHECK(ndr_push_QueryMultipleValue(ndr, NDR_BUFFERS, &r->in.values[cntr_values_1]));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_values));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.buffer));
		if (r->in.buffer) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.buffer_size));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.buffer_size));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.buffer, *r->in.buffer_size));
		}
		if (r->in.buffer_size == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.buffer_size));
	}
	if (flags & NDR_OUT) {
		if (r->out.values == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_values));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_values));
		for (cntr_values_1 = 0; cntr_values_1 < r->in.num_values; cntr_values_1++) {
			NDR_CHECK(ndr_push_QueryMultipleValue(ndr, NDR_SCALARS, &r->out.values[cntr_values_1]));
		}
		for (cntr_values_1 = 0; cntr_values_1 < r->in.num_values; cntr_values_1++) {
			NDR_CHECK(ndr_push_QueryMultipleValue(ndr, NDR_BUFFERS, &r->out.values[cntr_values_1]));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.buffer));
		if (r->out.buffer) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.buffer_size));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.buffer_size));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.buffer, *r->out.buffer_size));
		}
		if (r->out.buffer_size == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.buffer_size));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_QueryMultipleValues(struct ndr_pull *ndr, int flags, struct winreg_QueryMultipleValues *r)
{
	uint32_t cntr_values_1;
	uint32_t _ptr_buffer;
	TALLOC_CTX *_mem_save_key_handle_0;
	TALLOC_CTX *_mem_save_values_1;
	TALLOC_CTX *_mem_save_buffer_0;
	TALLOC_CTX *_mem_save_buffer_size_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.key_handle);
		}
		_mem_save_key_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.key_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.key_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_key_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.values));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.values));
		if (ndr_get_array_length(ndr, &r->in.values) > ndr_get_array_size(ndr, &r->in.values)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.values), ndr_get_array_length(ndr, &r->in.values));
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.values, ndr_get_array_size(ndr, &r->in.values));
		}
		memcpy(r->out.values, r->in.values, ndr_get_array_size(ndr, &r->in.values) * sizeof(*r->in.values));
		_mem_save_values_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.values, 0);
		for (cntr_values_1 = 0; cntr_values_1 < r->in.num_values; cntr_values_1++) {
			NDR_CHECK(ndr_pull_QueryMultipleValue(ndr, NDR_SCALARS, &r->in.values[cntr_values_1]));
		}
		for (cntr_values_1 = 0; cntr_values_1 < r->in.num_values; cntr_values_1++) {
			NDR_CHECK(ndr_pull_QueryMultipleValue(ndr, NDR_BUFFERS, &r->in.values[cntr_values_1]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_values_1, 0);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.num_values));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buffer));
		if (_ptr_buffer) {
			NDR_PULL_ALLOC(ndr, r->in.buffer);
		} else {
			r->in.buffer = NULL;
		}
		if (r->in.buffer) {
			_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.buffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.buffer));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.buffer));
			if (ndr_get_array_length(ndr, &r->in.buffer) > ndr_get_array_size(ndr, &r->in.buffer)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.buffer), ndr_get_array_length(ndr, &r->in.buffer));
			}
			NDR_PULL_ALLOC_N(ndr, r->in.buffer, ndr_get_array_size(ndr, &r->in.buffer));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.buffer, ndr_get_array_length(ndr, &r->in.buffer)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.buffer_size);
		}
		_mem_save_buffer_size_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.buffer_size, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.buffer_size));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_size_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC_N(ndr, r->out.values, r->in.num_values);
		memcpy(r->out.values, r->in.values, (r->in.num_values) * sizeof(*r->in.values));
		NDR_PULL_ALLOC(ndr, r->out.buffer_size);
		*r->out.buffer_size = *r->in.buffer_size;
		if (r->in.values) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.values, r->in.num_values));
		}
		if (r->in.values) {
			NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->in.values, r->in.num_values));
		}
		if (r->in.buffer) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.buffer, *r->in.buffer_size));
		}
		if (r->in.buffer) {
			NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->in.buffer, *r->in.buffer_size));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.values));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.values));
		if (ndr_get_array_length(ndr, &r->out.values) > ndr_get_array_size(ndr, &r->out.values)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->out.values), ndr_get_array_length(ndr, &r->out.values));
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.values, ndr_get_array_size(ndr, &r->out.values));
		}
		memcpy(r->out.values, r->in.values, ndr_get_array_size(ndr, &r->out.values) * sizeof(*r->in.values));
		_mem_save_values_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.values, 0);
		for (cntr_values_1 = 0; cntr_values_1 < r->in.num_values; cntr_values_1++) {
			NDR_CHECK(ndr_pull_QueryMultipleValue(ndr, NDR_SCALARS, &r->out.values[cntr_values_1]));
		}
		for (cntr_values_1 = 0; cntr_values_1 < r->in.num_values; cntr_values_1++) {
			NDR_CHECK(ndr_pull_QueryMultipleValue(ndr, NDR_BUFFERS, &r->out.values[cntr_values_1]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_values_1, 0);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buffer));
		if (_ptr_buffer) {
			NDR_PULL_ALLOC(ndr, r->out.buffer);
		} else {
			r->out.buffer = NULL;
		}
		if (r->out.buffer) {
			_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.buffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->out.buffer));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->out.buffer));
			if (ndr_get_array_length(ndr, &r->out.buffer) > ndr_get_array_size(ndr, &r->out.buffer)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->out.buffer), ndr_get_array_length(ndr, &r->out.buffer));
			}
			NDR_PULL_ALLOC_N(ndr, r->out.buffer, ndr_get_array_size(ndr, &r->out.buffer));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.buffer, ndr_get_array_length(ndr, &r->out.buffer)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.buffer_size);
		}
		_mem_save_buffer_size_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.buffer_size, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.buffer_size));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_size_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.values) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.values, r->in.num_values));
		}
		if (r->out.values) {
			NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->out.values, r->in.num_values));
		}
		if (r->out.buffer) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.buffer, *r->out.buffer_size));
		}
		if (r->out.buffer) {
			NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->out.buffer, *r->out.buffer_size));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_QueryMultipleValues(struct ndr_print *ndr, const char *name, int flags, const struct winreg_QueryMultipleValues *r)
{
	uint32_t cntr_values_1;
	ndr_print_struct(ndr, name, "winreg_QueryMultipleValues");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_QueryMultipleValues");
		ndr->depth++;
		ndr_print_ptr(ndr, "key_handle", r->in.key_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "key_handle", r->in.key_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "values", r->in.values);
		ndr->depth++;
		ndr->print(ndr, "%s: ARRAY(%d)", "values", (int)r->in.num_values);
		ndr->depth++;
		for (cntr_values_1=0;cntr_values_1<r->in.num_values;cntr_values_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_values_1) != -1) {
				ndr_print_QueryMultipleValue(ndr, "values", &r->in.values[cntr_values_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_uint32(ndr, "num_values", r->in.num_values);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		if (r->in.buffer) {
			ndr_print_array_uint8(ndr, "buffer", r->in.buffer, *r->in.buffer_size);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "buffer_size", r->in.buffer_size);
		ndr->depth++;
		ndr_print_uint32(ndr, "buffer_size", *r->in.buffer_size);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_QueryMultipleValues");
		ndr->depth++;
		ndr_print_ptr(ndr, "values", r->out.values);
		ndr->depth++;
		ndr->print(ndr, "%s: ARRAY(%d)", "values", (int)r->in.num_values);
		ndr->depth++;
		for (cntr_values_1=0;cntr_values_1<r->in.num_values;cntr_values_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_values_1) != -1) {
				ndr_print_QueryMultipleValue(ndr, "values", &r->out.values[cntr_values_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		if (r->out.buffer) {
			ndr_print_array_uint8(ndr, "buffer", r->out.buffer, *r->out.buffer_size);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "buffer_size", r->out.buffer_size);
		ndr->depth++;
		ndr_print_uint32(ndr, "buffer_size", *r->out.buffer_size);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_InitiateSystemShutdownEx(struct ndr_push *ndr, int flags, const struct winreg_InitiateSystemShutdownEx *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.hostname));
		if (r->in.hostname) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->in.hostname));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.message));
		if (r->in.message) {
			NDR_CHECK(ndr_push_initshutdown_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.message));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.timeout));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in.force_apps));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in.do_reboot));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.reason));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_InitiateSystemShutdownEx(struct ndr_pull *ndr, int flags, struct winreg_InitiateSystemShutdownEx *r)
{
	uint32_t _ptr_hostname;
	uint32_t _ptr_message;
	TALLOC_CTX *_mem_save_hostname_0;
	TALLOC_CTX *_mem_save_message_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_hostname));
		if (_ptr_hostname) {
			NDR_PULL_ALLOC(ndr, r->in.hostname);
		} else {
			r->in.hostname = NULL;
		}
		if (r->in.hostname) {
			_mem_save_hostname_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.hostname, 0);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->in.hostname));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hostname_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_message));
		if (_ptr_message) {
			NDR_PULL_ALLOC(ndr, r->in.message);
		} else {
			r->in.message = NULL;
		}
		if (r->in.message) {
			_mem_save_message_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.message, 0);
			NDR_CHECK(ndr_pull_initshutdown_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.message));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_message_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.timeout));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in.force_apps));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in.do_reboot));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.reason));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_InitiateSystemShutdownEx(struct ndr_print *ndr, const char *name, int flags, const struct winreg_InitiateSystemShutdownEx *r)
{
	ndr_print_struct(ndr, name, "winreg_InitiateSystemShutdownEx");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_InitiateSystemShutdownEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "hostname", r->in.hostname);
		ndr->depth++;
		if (r->in.hostname) {
			ndr_print_uint16(ndr, "hostname", *r->in.hostname);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "message", r->in.message);
		ndr->depth++;
		if (r->in.message) {
			ndr_print_initshutdown_String(ndr, "message", r->in.message);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "timeout", r->in.timeout);
		ndr_print_uint8(ndr, "force_apps", r->in.force_apps);
		ndr_print_uint8(ndr, "do_reboot", r->in.do_reboot);
		ndr_print_uint32(ndr, "reason", r->in.reason);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_InitiateSystemShutdownEx");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_SaveKeyEx(struct ndr_push *ndr, int flags, const struct winreg_SaveKeyEx *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_SaveKeyEx(struct ndr_pull *ndr, int flags, struct winreg_SaveKeyEx *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_SaveKeyEx(struct ndr_print *ndr, const char *name, int flags, const struct winreg_SaveKeyEx *r)
{
	ndr_print_struct(ndr, name, "winreg_SaveKeyEx");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_SaveKeyEx");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_SaveKeyEx");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_OpenHKPT(struct ndr_push *ndr, int flags, const struct winreg_OpenHKPT *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.system_name));
		if (r->in.system_name) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->in.system_name));
		}
		NDR_CHECK(ndr_push_winreg_AccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_OpenHKPT(struct ndr_pull *ndr, int flags, struct winreg_OpenHKPT *r)
{
	uint32_t _ptr_system_name;
	TALLOC_CTX *_mem_save_system_name_0;
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_system_name));
		if (_ptr_system_name) {
			NDR_PULL_ALLOC(ndr, r->in.system_name);
		} else {
			r->in.system_name = NULL;
		}
		if (r->in.system_name) {
			_mem_save_system_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.system_name, 0);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->in.system_name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_system_name_0, 0);
		}
		NDR_CHECK(ndr_pull_winreg_AccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_OpenHKPT(struct ndr_print *ndr, const char *name, int flags, const struct winreg_OpenHKPT *r)
{
	ndr_print_struct(ndr, name, "winreg_OpenHKPT");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_OpenHKPT");
		ndr->depth++;
		ndr_print_ptr(ndr, "system_name", r->in.system_name);
		ndr->depth++;
		if (r->in.system_name) {
			ndr_print_uint16(ndr, "system_name", *r->in.system_name);
		}
		ndr->depth--;
		ndr_print_winreg_AccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_OpenHKPT");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_OpenHKPN(struct ndr_push *ndr, int flags, const struct winreg_OpenHKPN *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.system_name));
		if (r->in.system_name) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->in.system_name));
		}
		NDR_CHECK(ndr_push_winreg_AccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_OpenHKPN(struct ndr_pull *ndr, int flags, struct winreg_OpenHKPN *r)
{
	uint32_t _ptr_system_name;
	TALLOC_CTX *_mem_save_system_name_0;
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_system_name));
		if (_ptr_system_name) {
			NDR_PULL_ALLOC(ndr, r->in.system_name);
		} else {
			r->in.system_name = NULL;
		}
		if (r->in.system_name) {
			_mem_save_system_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.system_name, 0);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->in.system_name));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_system_name_0, 0);
		}
		NDR_CHECK(ndr_pull_winreg_AccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_OpenHKPN(struct ndr_print *ndr, const char *name, int flags, const struct winreg_OpenHKPN *r)
{
	ndr_print_struct(ndr, name, "winreg_OpenHKPN");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_OpenHKPN");
		ndr->depth++;
		ndr_print_ptr(ndr, "system_name", r->in.system_name);
		ndr->depth++;
		if (r->in.system_name) {
			ndr_print_uint16(ndr, "system_name", *r->in.system_name);
		}
		ndr->depth--;
		ndr_print_winreg_AccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_OpenHKPN");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winreg_QueryMultipleValues2(struct ndr_push *ndr, int flags, const struct winreg_QueryMultipleValues2 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winreg_QueryMultipleValues2(struct ndr_pull *ndr, int flags, struct winreg_QueryMultipleValues2 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_QueryMultipleValues2(struct ndr_print *ndr, const char *name, int flags, const struct winreg_QueryMultipleValues2 *r)
{
	ndr_print_struct(ndr, name, "winreg_QueryMultipleValues2");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winreg_QueryMultipleValues2");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winreg_QueryMultipleValues2");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call winreg_calls[] = {
	{
		"winreg_OpenHKCR",
		sizeof(struct winreg_OpenHKCR),
		(ndr_push_flags_fn_t) ndr_push_winreg_OpenHKCR,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_OpenHKCR,
		(ndr_print_function_t) ndr_print_winreg_OpenHKCR,
		false,
	},
	{
		"winreg_OpenHKCU",
		sizeof(struct winreg_OpenHKCU),
		(ndr_push_flags_fn_t) ndr_push_winreg_OpenHKCU,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_OpenHKCU,
		(ndr_print_function_t) ndr_print_winreg_OpenHKCU,
		false,
	},
	{
		"winreg_OpenHKLM",
		sizeof(struct winreg_OpenHKLM),
		(ndr_push_flags_fn_t) ndr_push_winreg_OpenHKLM,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_OpenHKLM,
		(ndr_print_function_t) ndr_print_winreg_OpenHKLM,
		false,
	},
	{
		"winreg_OpenHKPD",
		sizeof(struct winreg_OpenHKPD),
		(ndr_push_flags_fn_t) ndr_push_winreg_OpenHKPD,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_OpenHKPD,
		(ndr_print_function_t) ndr_print_winreg_OpenHKPD,
		false,
	},
	{
		"winreg_OpenHKU",
		sizeof(struct winreg_OpenHKU),
		(ndr_push_flags_fn_t) ndr_push_winreg_OpenHKU,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_OpenHKU,
		(ndr_print_function_t) ndr_print_winreg_OpenHKU,
		false,
	},
	{
		"winreg_CloseKey",
		sizeof(struct winreg_CloseKey),
		(ndr_push_flags_fn_t) ndr_push_winreg_CloseKey,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_CloseKey,
		(ndr_print_function_t) ndr_print_winreg_CloseKey,
		false,
	},
	{
		"winreg_CreateKey",
		sizeof(struct winreg_CreateKey),
		(ndr_push_flags_fn_t) ndr_push_winreg_CreateKey,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_CreateKey,
		(ndr_print_function_t) ndr_print_winreg_CreateKey,
		false,
	},
	{
		"winreg_DeleteKey",
		sizeof(struct winreg_DeleteKey),
		(ndr_push_flags_fn_t) ndr_push_winreg_DeleteKey,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_DeleteKey,
		(ndr_print_function_t) ndr_print_winreg_DeleteKey,
		false,
	},
	{
		"winreg_DeleteValue",
		sizeof(struct winreg_DeleteValue),
		(ndr_push_flags_fn_t) ndr_push_winreg_DeleteValue,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_DeleteValue,
		(ndr_print_function_t) ndr_print_winreg_DeleteValue,
		false,
	},
	{
		"winreg_EnumKey",
		sizeof(struct winreg_EnumKey),
		(ndr_push_flags_fn_t) ndr_push_winreg_EnumKey,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_EnumKey,
		(ndr_print_function_t) ndr_print_winreg_EnumKey,
		false,
	},
	{
		"winreg_EnumValue",
		sizeof(struct winreg_EnumValue),
		(ndr_push_flags_fn_t) ndr_push_winreg_EnumValue,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_EnumValue,
		(ndr_print_function_t) ndr_print_winreg_EnumValue,
		false,
	},
	{
		"winreg_FlushKey",
		sizeof(struct winreg_FlushKey),
		(ndr_push_flags_fn_t) ndr_push_winreg_FlushKey,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_FlushKey,
		(ndr_print_function_t) ndr_print_winreg_FlushKey,
		false,
	},
	{
		"winreg_GetKeySecurity",
		sizeof(struct winreg_GetKeySecurity),
		(ndr_push_flags_fn_t) ndr_push_winreg_GetKeySecurity,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_GetKeySecurity,
		(ndr_print_function_t) ndr_print_winreg_GetKeySecurity,
		false,
	},
	{
		"winreg_LoadKey",
		sizeof(struct winreg_LoadKey),
		(ndr_push_flags_fn_t) ndr_push_winreg_LoadKey,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_LoadKey,
		(ndr_print_function_t) ndr_print_winreg_LoadKey,
		false,
	},
	{
		"winreg_NotifyChangeKeyValue",
		sizeof(struct winreg_NotifyChangeKeyValue),
		(ndr_push_flags_fn_t) ndr_push_winreg_NotifyChangeKeyValue,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_NotifyChangeKeyValue,
		(ndr_print_function_t) ndr_print_winreg_NotifyChangeKeyValue,
		false,
	},
	{
		"winreg_OpenKey",
		sizeof(struct winreg_OpenKey),
		(ndr_push_flags_fn_t) ndr_push_winreg_OpenKey,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_OpenKey,
		(ndr_print_function_t) ndr_print_winreg_OpenKey,
		false,
	},
	{
		"winreg_QueryInfoKey",
		sizeof(struct winreg_QueryInfoKey),
		(ndr_push_flags_fn_t) ndr_push_winreg_QueryInfoKey,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_QueryInfoKey,
		(ndr_print_function_t) ndr_print_winreg_QueryInfoKey,
		false,
	},
	{
		"winreg_QueryValue",
		sizeof(struct winreg_QueryValue),
		(ndr_push_flags_fn_t) ndr_push_winreg_QueryValue,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_QueryValue,
		(ndr_print_function_t) ndr_print_winreg_QueryValue,
		false,
	},
	{
		"winreg_ReplaceKey",
		sizeof(struct winreg_ReplaceKey),
		(ndr_push_flags_fn_t) ndr_push_winreg_ReplaceKey,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_ReplaceKey,
		(ndr_print_function_t) ndr_print_winreg_ReplaceKey,
		false,
	},
	{
		"winreg_RestoreKey",
		sizeof(struct winreg_RestoreKey),
		(ndr_push_flags_fn_t) ndr_push_winreg_RestoreKey,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_RestoreKey,
		(ndr_print_function_t) ndr_print_winreg_RestoreKey,
		false,
	},
	{
		"winreg_SaveKey",
		sizeof(struct winreg_SaveKey),
		(ndr_push_flags_fn_t) ndr_push_winreg_SaveKey,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_SaveKey,
		(ndr_print_function_t) ndr_print_winreg_SaveKey,
		false,
	},
	{
		"winreg_SetKeySecurity",
		sizeof(struct winreg_SetKeySecurity),
		(ndr_push_flags_fn_t) ndr_push_winreg_SetKeySecurity,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_SetKeySecurity,
		(ndr_print_function_t) ndr_print_winreg_SetKeySecurity,
		false,
	},
	{
		"winreg_SetValue",
		sizeof(struct winreg_SetValue),
		(ndr_push_flags_fn_t) ndr_push_winreg_SetValue,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_SetValue,
		(ndr_print_function_t) ndr_print_winreg_SetValue,
		false,
	},
	{
		"winreg_UnLoadKey",
		sizeof(struct winreg_UnLoadKey),
		(ndr_push_flags_fn_t) ndr_push_winreg_UnLoadKey,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_UnLoadKey,
		(ndr_print_function_t) ndr_print_winreg_UnLoadKey,
		false,
	},
	{
		"winreg_InitiateSystemShutdown",
		sizeof(struct winreg_InitiateSystemShutdown),
		(ndr_push_flags_fn_t) ndr_push_winreg_InitiateSystemShutdown,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_InitiateSystemShutdown,
		(ndr_print_function_t) ndr_print_winreg_InitiateSystemShutdown,
		false,
	},
	{
		"winreg_AbortSystemShutdown",
		sizeof(struct winreg_AbortSystemShutdown),
		(ndr_push_flags_fn_t) ndr_push_winreg_AbortSystemShutdown,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_AbortSystemShutdown,
		(ndr_print_function_t) ndr_print_winreg_AbortSystemShutdown,
		false,
	},
	{
		"winreg_GetVersion",
		sizeof(struct winreg_GetVersion),
		(ndr_push_flags_fn_t) ndr_push_winreg_GetVersion,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_GetVersion,
		(ndr_print_function_t) ndr_print_winreg_GetVersion,
		false,
	},
	{
		"winreg_OpenHKCC",
		sizeof(struct winreg_OpenHKCC),
		(ndr_push_flags_fn_t) ndr_push_winreg_OpenHKCC,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_OpenHKCC,
		(ndr_print_function_t) ndr_print_winreg_OpenHKCC,
		false,
	},
	{
		"winreg_OpenHKDD",
		sizeof(struct winreg_OpenHKDD),
		(ndr_push_flags_fn_t) ndr_push_winreg_OpenHKDD,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_OpenHKDD,
		(ndr_print_function_t) ndr_print_winreg_OpenHKDD,
		false,
	},
	{
		"winreg_QueryMultipleValues",
		sizeof(struct winreg_QueryMultipleValues),
		(ndr_push_flags_fn_t) ndr_push_winreg_QueryMultipleValues,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_QueryMultipleValues,
		(ndr_print_function_t) ndr_print_winreg_QueryMultipleValues,
		false,
	},
	{
		"winreg_InitiateSystemShutdownEx",
		sizeof(struct winreg_InitiateSystemShutdownEx),
		(ndr_push_flags_fn_t) ndr_push_winreg_InitiateSystemShutdownEx,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_InitiateSystemShutdownEx,
		(ndr_print_function_t) ndr_print_winreg_InitiateSystemShutdownEx,
		false,
	},
	{
		"winreg_SaveKeyEx",
		sizeof(struct winreg_SaveKeyEx),
		(ndr_push_flags_fn_t) ndr_push_winreg_SaveKeyEx,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_SaveKeyEx,
		(ndr_print_function_t) ndr_print_winreg_SaveKeyEx,
		false,
	},
	{
		"winreg_OpenHKPT",
		sizeof(struct winreg_OpenHKPT),
		(ndr_push_flags_fn_t) ndr_push_winreg_OpenHKPT,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_OpenHKPT,
		(ndr_print_function_t) ndr_print_winreg_OpenHKPT,
		false,
	},
	{
		"winreg_OpenHKPN",
		sizeof(struct winreg_OpenHKPN),
		(ndr_push_flags_fn_t) ndr_push_winreg_OpenHKPN,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_OpenHKPN,
		(ndr_print_function_t) ndr_print_winreg_OpenHKPN,
		false,
	},
	{
		"winreg_QueryMultipleValues2",
		sizeof(struct winreg_QueryMultipleValues2),
		(ndr_push_flags_fn_t) ndr_push_winreg_QueryMultipleValues2,
		(ndr_pull_flags_fn_t) ndr_pull_winreg_QueryMultipleValues2,
		(ndr_print_function_t) ndr_print_winreg_QueryMultipleValues2,
		false,
	},
	{ NULL, 0, NULL, NULL, NULL, false }
};

static const char * const winreg_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\winreg]", 
	"ncacn_ip_tcp:", 
	"ncalrpc:", 
};

static const struct ndr_interface_string_array winreg_endpoints = {
	.count	= 3,
	.names	= winreg_endpoint_strings
};

static const char * const winreg_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array winreg_authservices = {
	.count	= 1,
	.names	= winreg_authservice_strings
};


const struct ndr_interface_table ndr_table_winreg = {
	.name		= "winreg",
	.syntax_id	= {
		{0x338cd001,0x2244,0x31f1,{0xaa,0xaa},{0x90,0x00,0x38,0x00,0x10,0x03}},
		NDR_WINREG_VERSION
	},
	.helpstring	= NDR_WINREG_HELPSTRING,
	.num_calls	= 35,
	.calls		= winreg_calls,
	.endpoints	= &winreg_endpoints,
	.authservices	= &winreg_authservices
};

