/* torture_smb.c                                                            */
/* Copyright (C) Richard Sharpe, 1996                                       */
/*                                                                          */
/* We torture test SMB servers ...                                          */

/* A test for smblib that does nasty things ...... */

#include <sys/types.h>
#include <unistd.h>

#include "smblib.h"

#define DEFAULT "msfax"

char data[65536] = "Now is the time for all birds to roost.";
static char *SMB_Prots[] = {"PC NETWORK PROGRAM 1.0", 
			    "MICROSOFT NETWORKS 1.03",
			    "MICROSOFT NETWORKS 3.0",
			    "DOS LANMAN1.0",
			    "LANMAN1.0",
			    "DOS LM1.2X002",
			    "LM1.2X002",
			    "DOS LANMAN2.1",
			    "LANMAN2.1",
			    "Samba",
			    "NT LM 0.12",
			    "NT LANMAN 1.0",
			    NULL};

char * prots_to_use[1000];   /* We can pass these in ... */
int prot_count = 0;

int verbose = FALSE;

char *SMB_Prots2[] = {"PC NETWORK PROGRAM 1.0", 
			    "MICROSOFT NETWORKS 1.03",
			    "MICROSOFT NETWORKS 3.0",
			    "DOS LANMAN1.0",
			    "LANMAN1.0",
			    "DOS LM1.2X002",
			    "LM1.2X002",
			    "DOS LANMAN2.1",
			    "LANMAN2.1",
			    "NT LM 0.12",
			    "NT LANMAN 1.0",
                      NULL};

/* Some torture tests ... */
/* Torture_mult_neg connects to the server and then does multiple 
   negotiates                                                            */

int torture_mult_neg(char *server)

{ void *con; int prot, SMB_Error;
  char err_string[1024];
  char **use_prots;

  fprintf(stderr, "Test: Multiple Negotiates\n");
  fprintf(stderr, "Testing whether or not server %s can handle multiple negotiates\n", server);

  con = SMB_Connect_Server(NULL, server);

  if (con == NULL) { /* Error ... */

    fprintf(stderr, "Unable to connect to server \"%s\" ... \n", server);
    if (SMB_Get_Last_Error() == SMBlibE_Remote) {

      SMB_Error = SMB_Get_Last_SMB_Err();
      SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			    SMBlib_Error_Code(SMB_Error),
			    err_string,
			    sizeof(err_string) - 1);

    }
    else {
      SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
    }

    fprintf(stderr, "  %s ...\n", err_string);

    fprintf(stderr, "Since we could not connect to the server, no more tests will be run in this group.\n");

    return(-1);

  }

  /* Now we negotiate and negotiate again ... */

  if (prot_count > 0)
    use_prots = prots_to_use;
  else
    use_prots = SMB_Prots;


  fprintf(stderr, "Now we negotiate a protocol ... \n");

  if (SMB_Negotiate(con, use_prots) < 0) { /* Error */

    fprintf(stderr, "Unable to negotiate a protocol ...\n");
    if (SMB_Get_Last_Error() == SMBlibE_Remote) {

      SMB_Error = SMB_Get_Last_SMB_Err();
      SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			    SMBlib_Error_Code(SMB_Error),
			    err_string,
			    sizeof(err_string) - 1);

    }
    else {
      SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
    }

    printf("  %s ...\n", err_string);

    /* Well, it did not like that list of protocols, let's see if it likes
       a smaller list */

    if (SMB_Negotiate(con, SMB_Prots2) < 0){ /* an error */

      fprintf(stderr, "Unable to negotiate a protocol a from a smaller list...\n");
      if (SMB_Get_Last_Error() == SMBlibE_Remote) {

	SMB_Error = SMB_Get_Last_SMB_Err();
	SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			      SMBlib_Error_Code(SMB_Error),
			      err_string,
			      sizeof(err_string) - 1);

      }
      else {
	SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
      }

      fprintf(stderr, "  %s ...\n", err_string);
      fprintf(stderr, "Since they don't like our protocols, let's go home.\n");

      return(-1);
    }

  }

  prot = SMB_Get_Protocol_IDX(con);

  fprintf(stderr, "  The protocol accepted was %i, %s\n", prot, 
	  use_prots[prot]);
  fprintf(stderr, "  The Max Buffer Size is: %i\n", SMB_Get_Max_Buf_Siz(con));

  fprintf(stderr, "Now we negotiate a protocol again ... \n");

  if (SMB_Negotiate(con, use_prots) < 0) { /* An error */

    fprintf(stderr, "Unable to negotiate a protocol a second time...\n");
    if (SMB_Get_Last_Error() == SMBlibE_Remote) {

      SMB_Error = SMB_Get_Last_SMB_Err();
      SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			    SMBlib_Error_Code(SMB_Error),
			    err_string,
			    sizeof(err_string) - 1);

    }
    else {
      SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
    }

    fprintf(stderr, "  %s ...\n", err_string);

    /* Ignore any error ... */

  }
  else {

    prot = SMB_Get_Protocol_IDX(con);

    fprintf(stderr, "  The protocol accepted was %i, %s\n", prot, 
	           use_prots[prot]);

  }
  /* Now disconnect the connection etc ... */

  SMB_Discon(con, FALSE);

  fprintf(stderr, "Test: Multiple Negotiates complete.\n");

}

/* Now we send a long negotiate SMB and see what happens ... */

int torture_long_neg(char *server)

{ void *con; int prot, SMB_Error, i;
  char err_string[1024];
  char **prot_list;

  fprintf(stderr, "Test: Long Negotiate SMBs\n");
  fprintf(stderr, "Testing whether or not server %s can handle multiple negotiates\n", server);
  fprintf(stderr, "If we hang here for more than 10 seconds, or we timeout,");
  fprintf(stderr, " the server does\n not like long SMBs ");
  fprintf(stderr, "and stalled the connection.\n");

  con = SMB_Connect_Server(NULL, server);

  if (con == NULL) { /* Error ... */

    fprintf(stderr, "Unable to connect to server \"%s\" ... \n", server);
    if (SMB_Get_Last_Error() == SMBlibE_Remote) {

      SMB_Error = SMB_Get_Last_SMB_Err();
      SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			    SMBlib_Error_Code(SMB_Error),
			    err_string,
			    sizeof(err_string) - 1);

    }
    else {
      SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
    }

    fprintf(stderr, "  %s ...\n", err_string);

    fprintf(stderr, "Since we could not connect to the server, no more tests will be run in this group.\n");

    return(-1);

  }

  /* Now we negotiate a protocol ... */

  fprintf(stderr, "Now we negotiate a protocol with a long SMB ... \n");

  if ((prot_list = (char **)malloc(1001 * sizeof(char *))) == NULL){

    fprintf(stderr, "Could not allocate space for the protocols ...\n");
    exit(1);

  }

  prot_list[1000] = NULL;   /* Put in the guard */

  for (i = 0; i < 992; i++)
    prot_list[i] = "One really stupid protocol name";

  for (i = 992; i < 1000; i++)
    prot_list[i] = SMB_Prots[i - 992];

  if (SMB_Negotiate(con, prot_list) < 0) { /* An error */

    fprintf(stderr, "Unable to negotiate a protocol ...\n");
    if (SMB_Get_Last_Error() == SMBlibE_Remote) {

      SMB_Error = SMB_Get_Last_SMB_Err();
      SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			    SMBlib_Error_Code(SMB_Error),
			    err_string,
			    sizeof(err_string) - 1);

    }
    else {
      SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
    }

    printf("  %s ...\n", err_string);

    return(-1);

  }

  prot = SMB_Get_Protocol_IDX(con);

  fprintf(stderr, "  The protocol accepted was %i, %s\n", prot, 
	  prot_list[prot]);

  /* Now disconnect the connection etc ... */

  SMB_Discon(con, FALSE);

  fprintf(stderr, "Test: Long Negotiate SMBs complete.\n");


}

int torture_template(char *server)

{ void *con; int prot, SMB_Error;
  char err_string[1024];

  fprintf(stderr, "Test: Multiple Negotiates\n");
  fprintf(stderr, "Testing whether or not server %s can handle multiple negotiates\n", server);

  con = SMB_Connect_Server(NULL, server);

  if (con == NULL) { /* Error ... */

    fprintf(stderr, "Unable to connect to server \"%s\" ... \n", server);
    if (SMB_Get_Last_Error() == SMBlibE_Remote) {

      SMB_Error = SMB_Get_Last_SMB_Err();
      SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			    SMBlib_Error_Code(SMB_Error),
			    err_string,
			    sizeof(err_string) - 1);

    }
    else {
      SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
    }

    fprintf(stderr, "  %s ...\n", err_string);

    fprintf(stderr, "Since we could not connect to the server, no more tests will be run in this group.\n");

    return(-1);

  }


  /* Now disconnect the connection etc ... */

  SMB_Discon(con, FALSE);

  fprintf(stderr, "Test: Multiple Negotiates complete.\n");


}

void usage()

{

  fprintf(stderr, "torture_smb [-v -n <protocol>] server\n");
  fprintf(stderr, "Where: -v means verbose listing of info\n");
  fprintf(stderr, "       -n <protocol> means add protocol to the list.");
  fprintf(stderr, "                     If you use -n, then you have to\n");
  fprintf(stderr, "                     specify all the protocols to use.\n");

}

main(int argc, char *argv[])

{ void *con, *file;
  int opt;
  int written, actual_size, i, prot, SMB_Error;
  extern char *optarg;
  extern int optind;
  char server[80], service[80], called[80], err_string[1024];
  char password[80];

  actual_size = 8192;


  while ((opt = getopt(argc, argv, "n:b:e:s:p:u:lv")) != EOF) {

    switch (opt) {
    case 'n':     /* Pick up another protocol string to negotiate */
      prots_to_use[prot_count] = optarg;
      prot_count = prot_count + 1;
      break;

    case 'v':     /* Set verbose flag */
      verbose = TRUE;
      break;

    default:

      usage();
      exit(1);
      break;
    }

  }

  if (optind < argc) { /* Some more parameters, assume is the server */
    strncpy(server, argv[optind], sizeof(server) - 1);
    optind++;

    if (optind < argc) { /* Pick up password ... */
      strncpy(password, argv[optind], sizeof(password) -1);
    }
    else {
      strcpy(password, "nurk");
    }
  }
  else {
    strcpy(server, "nemesis");
  }

  fprintf(stderr, "Connecting to server \\\\%s ...\n", server);

  SMB_Init();

  RFCNB_Set_Timeout(10);  /* Set a 10 second timeout on each of these */

  if (torture_mult_neg(server) < 0) { /* What do we do? */

  }


  /* Now connect again, and try something really bizare ... large number 
     of bogus protocols ...      */


  if (torture_long_neg(server) < 0) {

  }

}
