/* UNIX SMBlib NetBIOS implementation

   Version 1.0
   SMBlib Routines

   Copyright (C) Richard Sharpe 1996

*/

/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "smblib-priv.h"

#include "rfcnb/rfcnb.h"

/* Initialize the SMBlib package     */

int SMB_Init()

{

  SMBlib_State = SMB_State_Started;

  return 0;

}

int SMB_Term()

{

  return 0;

}

/* SMB_Create: Create a connection structure and return for later use */
/* We have other helper routines to set variables                     */

SMB_Handle_Type SMB_Create()

{

}

/* SMB_Connect: Connect to the indicated server                       */
/* If Con_Handle == NULL then create a handle and connect, otherwise  */
/* use the handle passed                                              */

SMB_Handle_Type SMB_Connect(SMB_Handle_Type Con_Handle,
			    char *service, 
			    char *username, 
			    char *password)

{
  SMB_Handle_Type con;
  char *host;
  char temp[80];

  /* Get a connection structure if one does not exist */

  con = Con_Handle;

  if (Con_Handle == NULL) {

    if ((con = (struct SMB_Connect_Def *)malloc(sizeof(struct SMB_Connect_Def))) == NULL) {

      /* Some debugging output and a response somewhere? */

      return NULL;
    }

  }

  /* Init some things ... */

  strcpy(con -> service, service);
  strcpy(con -> username, username);
  strcpy(con -> password, password);
  strcpy(con -> sock_options, "");

  SMB_Get_My_Name(con -> myname, sizeof(con -> myname));

  con -> port = 0;                    /* No port selected */

  /* Get some things we need for the SMB Header */

  con -> pid = getpid();
  con -> mid = con -> pid;      /* This will do for now ... */
  con -> uid = getuid();    
  con -> gid = getgid();

  /* Now figure out the host portion of the service */

  strcpy(temp, service);
  host = strtok(temp, "/\\");     /* Separate host name portion */
  strcpy(con -> desthost, host);

  /* Now connect to the remote end */

  con -> Trans_Connect = RFCNB_Call(con -> desthost,
				    con -> myname,
				    con -> port);

  /* Did we get one? */

  if (con -> Trans_Connect == NULL) {

    /* We should pick up the error here ... and deallocate the con */

    return NULL;

  }

  /* Now, negotiate the protocol */

  if (SMB_Negotiate(con, SMB_Prots, &(con -> protocol)) < 0) {

    return NULL;

  }


}

int SMB_Discon(SMB_Handle_Type Con_Handle)

{

}
