/*
    Windows NT Security functions library.
    Copyright (C) 1995  Jeremy R. Allison

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Log:	priv.cpp,v $
// Revision 1.3  95/10/17  18:14:29  18:14:29  jra (Jeremy Allison)
// Added lsa code.
// 
// Revision 1.1  1995/06/30  18:32:55  jra
// Initial revision
//^M
*/

#include "secdesc.h"
#include "objhandle.h"
#include "seclib.h"

// Hack class to release handles
class closehands {
	HANDLE h_[3];
public:
	closehands(HANDLE h1 = 0, HANDLE h2 = 0, HANDLE h3 = 0) { 
		h_[0] = h1;
		h_[1] = h2;
		h_[2] = h3;
	}
	~closehands() {
		for(int i = 0; i < 3; i++) {
			if(h_[i] != 0)
				CloseHandle(h_[i]);
		}
	}
};

// Function to adjust a privilege
static BOOL AdjustPrivilege( const TCHAR *priv_name, DWORD flag) {

	HANDLE hproc = OpenProcess( PROCESS_QUERY_INFORMATION,
				FALSE, GetCurrentProcessId());
	if(hproc == 0)
		return FALSE;

	HANDLE htok;
	if(!OpenProcessToken( hproc, 
			TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY, &htok)) {
		CloseHandle(hproc);
		return FALSE;
	}

	closehands ch(hproc, htok);

	LUID priv_val;

	if(!LookupPrivilegeValue(0, priv_name, &priv_val))
		return FALSE;

	TOKEN_PRIVILEGES tok_priv;
	tok_priv.PrivilegeCount = 1;
    tok_priv.Privileges[0].Luid = priv_val;
    tok_priv.Privileges[0].Attributes = flag;

	AdjustTokenPrivileges( htok, FALSE, &tok_priv,
							sizeof(TOKEN_PRIVILEGES),
							0, 0);
	if(GetLastError() != NO_ERROR)
		return FALSE;
	return TRUE;
}

extern "C" {

// Function to take a privilege value

BOOL TakePrivilege( const TCHAR *priv_name) {
	return AdjustPrivilege( priv_name, SE_PRIVILEGE_ENABLED);
}

// Function to release a privilege value

BOOL ReleasePrivilege( const TCHAR *priv_name) {
	return AdjustPrivilege( priv_name, 0);
}

BOOL ChangeFileOwner( const TCHAR *file, const TCHAR *name, const TCHAR *mach) {
	DWORD err = 0;
	try {
		secDesc sd(name, 0, mach);
		file_obj_handle obj( file );
		/* Ensure we have SE_RESTORE_NAME privilege */
		if(!TakePrivilege( SE_RESTORE_NAME ))
			return FALSE;
		SECURITY_DESCRIPTOR *psd;
		if(!sd.createSD(&psd)) {
			ReleasePrivilege( SE_RESTORE_NAME );
			return FALSE;
		}
		if(!obj.SetObjectSecurity( OWNER_SECURITY_INFORMATION, psd)) {
			ReleasePrivilege( SE_RESTORE_NAME );
			return FALSE;
		}
		ReleasePrivilege( SE_RESTORE_NAME );
	} catch(DWORD caerr) {
		err = caerr;
	}
	if(err) {
		SetLastError(err);
		return FALSE;
	}
	return TRUE;
}

// Function to take ownership of a file. Makes current caller the owner.

BOOL TakeFileOwnership( const TCHAR *file) {
	DWORD err = 0;
	try {
		secDesc sd;
		file_obj_handle obj( file );
		SECURITY_DESCRIPTOR *psd;
		if(!sd.createSD(&psd))
			return FALSE;
		BOOL ret = obj.SetObjectSecurity( OWNER_SECURITY_INFORMATION, psd);
		if(!ret) {
			DWORD oldret = GetLastError();
			// Try asserting SE_TAKE_OWNERSHIP_NAME
			if(!TakePrivilege( SE_TAKE_OWNERSHIP_NAME )) {
				SetLastError(oldret);
				return FALSE;
			}
			if(!obj.SetObjectSecurity( OWNER_SECURITY_INFORMATION, psd)) {
				ReleasePrivilege( SE_TAKE_OWNERSHIP_NAME );
				return FALSE;
			}
			ReleasePrivilege( SE_TAKE_OWNERSHIP_NAME );
		}
	} catch(DWORD caerr) {
		err = caerr;	
	}
	if(err) {
		SetLastError(err);
		return FALSE;
	}
	return TRUE;
}

}
