#ifndef _SECDESC_H_
#define _SECDESC_H_

/*
    Windows NT Security functions library.
    Copyright (C) 1995  Jeremy R. Allison

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Log: secdesc.h,v $
 * Revision 1.3  1995/07/06  00:46:18  jra
 * *** empty log message ***
 *
 * Revision 1.2  1995/06/30  18:29:18  jra
 * Added const SID *getOwner() and const SID *getGroup() calls.
 *
 * Revision 1.1  95/06/30  18:32:55  18:32:55  jra (Jeremy Allison)
 * Initial revision
 * ^M
*/

#include <windows.h>
#include <tchar.h>
#include "list.h"
#include "acl.h"
#include "sidobj.h"

//
// Class to encapsulate a security descriptor.
//
class secDesc {
private:

	SECURITY_DESCRIPTOR sd_;
	SIDobj *psidown_;
	SIDobj *psidgrp_;
	aclList *pacl_list_;
	ACL *pacl_;	
	GENERIC_MAPPING *pgm_;
	CRITICAL_SECTION critsec_;

	secDesc(const secDesc& );
	secDesc& operator=(const secDesc& ); // No copying.

	void enter() { EnterCriticalSection(&critsec_); }
	void leave() { LeaveCriticalSection(&critsec_); }
	BOOL getThreadTokenOwnerInfo(SIDobj **);
	BOOL getThreadTokenGroupInfo(SIDobj **);
	BOOL validAclList();
	void mapMaskToGeneric(ACCESS_MASK, ACCESS_MASK *);

public:

	secDesc(const TCHAR *owner = 0, const TCHAR *group = 0, 
			const TCHAR *mach = 0);
	secDesc(const SID *owner, const SID *group);
	secDesc(const SECURITY_DESCRIPTOR *, const GENERIC_MAPPING *);

	~secDesc();

	BOOL setOwner(const TCHAR *owner = 0, const TCHAR *mach = 0);
	BOOL setGroup(const TCHAR *group = 0, const TCHAR *mach = 0);
	BOOL setOwner(const SID *owner);
	BOOL setGroup(const SID *group);
	const SID *getOwner() const { return *psidown_; }
	const SID *getGroup() const { return *psidgrp_; }

	BOOL AddAllowedAce(const TCHAR *name, const TCHAR *mach, ACCESS_MASK mask, BYTE flags = 0);
	BOOL AddAllowedAce(const SID *s, ACCESS_MASK mask, BYTE flags = 0);
	BOOL AddDeniedAce(const TCHAR *name, const TCHAR *mach, ACCESS_MASK mask, BYTE flags = 0);
	BOOL AddDeniedAce(const SID *s, ACCESS_MASK mask, BYTE flags = 0);
	BOOL RemoveAllowedAce(const TCHAR *name, const TCHAR *mach, ACCESS_MASK mask, BYTE flags = 0);
	BOOL RemoveAllowedAce(const SID *s, ACCESS_MASK mask, BYTE flags = 0);
	BOOL RemoveDeniedAce(const TCHAR *name, const TCHAR *mach, ACCESS_MASK mask, BYTE flags = 0);
	BOOL RemoveDeniedAce(const SID *s, ACCESS_MASK mask, BYTE flags = 0);
	
	BOOL noAccessACL(); // Make the secDesc have NO access.
	BOOL allAccessACL(); // Make the secDesc have ALL access.

	BOOL createSD(SECURITY_DESCRIPTOR **);
	void deleteSD();
};

#endif
