/*
    Windows NT Security functions library.
    Copyright (C) 1995  Jeremy R. Allison

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Log: objhand.cpp,v $
// Revision 1.1  1995/06/30  18:32:55  jra
// Initial revision
//^M
*/

#include "objhandle.h"

//
// Member function to present an orthoganal interface to the Get<XXX>Security
// API's in Win32
//

BOOL file_obj_handle::GetObjectSecurity(SECURITY_INFORMATION si,SECURITY_DESCRIPTOR *psd, 
		DWORD size, DWORD *psize)	
{
		return GetFileSecurity(file_, si, psd, size, psize);
}

BOOL kernel_obj_handle::GetObjectSecurity(SECURITY_INFORMATION si,SECURITY_DESCRIPTOR *psd, 
		DWORD size, DWORD *psize)	
{
		return GetKernelObjectSecurity( hand_, si, psd, size, psize);
}

BOOL user_obj_handle::GetObjectSecurity(SECURITY_INFORMATION si,SECURITY_DESCRIPTOR *psd, 
		DWORD size, DWORD *psize)	
{
		return GetUserObjectSecurity(hand_, &si, psd, size, psize);
}

BOOL reg_obj_handle::GetObjectSecurity(SECURITY_INFORMATION si,SECURITY_DESCRIPTOR *psd, 
		DWORD size, DWORD *psize)	
{
	*psize = size;
	LONG err;
	if((err = RegGetKeySecurity( hand_, si, psd, psize)) != ERROR_SUCCESS) 
		{
		SetLastError(err);
		return FALSE;
		}
	return TRUE;
}

//
// Member functions to present an orthoganal interface to the Set<XXX>Security
// API's in Win32
//

BOOL file_obj_handle::SetObjectSecurity(SECURITY_INFORMATION si, SECURITY_DESCRIPTOR *psd)	
{
		return SetFileSecurity(file_, si, psd);
}

BOOL kernel_obj_handle::SetObjectSecurity(SECURITY_INFORMATION si, SECURITY_DESCRIPTOR *psd)	
{
	return SetKernelObjectSecurity(hand_, si, psd);
}

BOOL user_obj_handle::SetObjectSecurity(SECURITY_INFORMATION si, SECURITY_DESCRIPTOR *psd)	
{
	return SetUserObjectSecurity(hand_, &si, psd);
}

BOOL reg_obj_handle::SetObjectSecurity(SECURITY_INFORMATION si, SECURITY_DESCRIPTOR *psd)	
{
	DWORD err;
	if((err = RegSetKeySecurity( hand_, si, psd)) != ERROR_SUCCESS)
		{
		SetLastError(err);
		return FALSE;
		}
	return TRUE;
}

