#ifndef _ACLCLASS_H_
#define _ACLCLASS_H_

/*
    Windows NT Security functions library.
    Copyright (C) 1995  Jeremy R. Allison

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Log: acl.h,v $
 * Revision 1.1  1995/06/30  18:32:55  jra
 * Initial revision
 *^M
*/

#include <windows.h>
#include <tchar.h>
#include "list.h"
#include "sidobj.h"

//
// Class to encapsulate an ACE entry in an ACL.
//
class aceEntry {
private:

	BYTE type_;
	union {
		ACCESS_ALLOWED_ACE *palAce_;
		ACCESS_DENIED_ACE *padAce_;
	} u_ace_;

	void deepcopy(const aceEntry&);
	BOOL makeAce(const SIDobj&, BYTE, ACCESS_MASK, BYTE);

public:

	aceEntry(const TCHAR *name, const TCHAR *mach, ACCESS_MASK mask, BYTE type, BYTE flags);
	aceEntry(const SIDobj& s, ACCESS_MASK mask, BYTE type, BYTE flags);
	~aceEntry();

	aceEntry(const aceEntry& ent) { deepcopy(ent); }
	aceEntry& operator=(const aceEntry& ); 
	int operator==(const aceEntry& );

	const SID *getSid() const;
	const ACCESS_MASK getMask() const;
	const BYTE getFlags()	const;
	const BYTE getType() const { return type_; }
	const void *getAce() const { return (type_ == ACCESS_ALLOWED_ACE_TYPE) ? (void *)u_ace_.palAce_ :
									(void *)u_ace_.padAce_; }
	const WORD getAceSize() const { return (type_ == ACCESS_ALLOWED_ACE_TYPE) ? u_ace_.palAce_->Header.AceSize :
									 u_ace_.padAce_->Header.AceSize; }
};

//
// Class to encapsulate an ACL. Contains a list of Access Allowed ACE's
// and Access Denied ACE's.
//
class aclList {
private:

	List<aceEntry> allowedList_;
	List<aceEntry> deniedList_;

	aclList(const aclList&);
	aclList& operator=(const aclList&); // No copying
	
	DWORD calculateACLSize() const;

public:

	aclList() {}
	~aclList();

	BOOL AddAllowedAce(const TCHAR *name, const TCHAR *mach, ACCESS_MASK mask, BYTE flags = 0);
	BOOL AddAllowedAce(const SIDobj& s, ACCESS_MASK mask, BYTE flags = 0);
	BOOL AddDeniedAce(const TCHAR *name, const TCHAR *mach, ACCESS_MASK mask, BYTE flags = 0);
	BOOL AddDeniedAce(const SIDobj& s, ACCESS_MASK mask, BYTE flags = 0);

	BOOL RemoveAllowedAce(const TCHAR *name, const TCHAR *mach, ACCESS_MASK mask, BYTE flags = 0);
	BOOL RemoveAllowedAce(const SIDobj& s, ACCESS_MASK mask, BYTE flags = 0);
	BOOL RemoveDeniedAce(const TCHAR *name, const TCHAR *mach, ACCESS_MASK mask, BYTE flags = 0);
	BOOL RemoveDeniedAce(const SIDobj& s, ACCESS_MASK mask, BYTE flags = 0);
	
	BOOL createACLfromList(ACL *, DWORD *) const;
	void clearACL() { allowedList_.RemoveAll(); deniedList_.RemoveAll(); }
};

#endif
