#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>

#include "seclib.h"

/*
 * Return a buffer containing an OS error description, or NULL.
 */

char *getoserr( TCHAR *buff, DWORD size, DWORD err)
{
	if(!FormatMessage( (DWORD)FORMAT_MESSAGE_FROM_SYSTEM,			
					(LPCVOID)NULL, 
					err, 
					(DWORD)MAKELANGID(LANG_NEUTRAL, SUBLANG_NEUTRAL),
					buff, (DWORD)size, NULL))
		_tcscpy(buff, _TEXT("Cannot format error\r\n"));
	buff[size -1] = '\0';
	return buff;
}

void usage(const char *progname)
{
	fprintf(stderr, _TEXT("%s: username filename\n"), progname);
	exit(1);
}

int main(int argc, char **argv)
{
	TCHAR error_buff[1024];

	if(argc != 3)
		usage(argv[0]);

	/* Adding the wildcard expansion, and recursive -R functionality
	   is left as an exercise to the reader :-). */

	if(!ChangeFileOwner( argv[2], argv[1], NULL)) {
		DWORD err = GetLastError();
		fprintf(stderr, _TEXT("%s: Failed to change file owner : %s\n"),
				argv[0], getoserr(error_buff, sizeof(error_buff), err));
		exit(err);
	}
	return 0;
}
