/* 
   Unix SMB/CIFS implementation.
   test suite for spoolss ndr operations

   Copyright (C) Jelmer Vernooij 2007
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "includes.h"
#include "torture/ndr/ndr.h"
#include "librpc/gen_ndr/ndr_spoolss.h"

static const uint8_t openprinterex_req_data[] = {
  0xf0, 0xa8, 0x39, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x09, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x5c, 0x00, 0x77, 0x00, 0x32, 0x00,
  0x6b, 0x00, 0x33, 0x00, 0x64, 0x00, 0x63, 0x00, 0x00, 0x00, 0xc9, 0x11,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x1c, 0xf5, 0x89, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x08, 0x66, 0x39, 0x00,
  0x78, 0xf5, 0x89, 0x00, 0x28, 0x0a, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x5c, 0x00,
  0x57, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x58, 0x00, 0x50, 0x00, 0x00, 0x00,
  0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00,
  0x41, 0x00, 0x64, 0x00, 0x6d, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x69, 0x00,
  0x73, 0x00, 0x74, 0x00, 0x72, 0x00, 0x61, 0x00, 0x74, 0x00, 0x6f, 0x00,
  0x72, 0x00, 0x00, 0x00
};

static const uint8_t openprinterex_resp_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x9f, 0xf8, 0xb9, 0x70, 0x9e, 0x14, 0x6b, 0x47,
  0xb1, 0x95, 0x57, 0xe2, 0x90, 0x94, 0xfb, 0xdc, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t closeprinter_req_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x9f, 0xf8, 0xb9, 0x70, 0x9e, 0x14, 0x6b, 0x47,
  0xb1, 0x95, 0x57, 0xe2, 0x90, 0x94, 0xfb, 0xdc
};

static const uint8_t closeprinter_resp_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t getprinter_req_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x1d, 0x7e, 0x6c, 0xfd, 0x7c, 0x90, 0x53, 0x4c,
  0xb8, 0x6f, 0x66, 0xb5, 0xff, 0x73, 0xd9, 0xac, 0x02, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t getprinter_resp_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x08, 0x06, 0x00, 0x00, 0x7a, 0x00, 0x00, 0x00
};

static const uint8_t getprinterdata_req_data[] = {
  0x00, 0x00, 0x00, 0x00, 0xbf, 0xee, 0x56, 0x27, 0x7f, 0xef, 0xf7, 0x42,
  0x84, 0x54, 0xd5, 0x7b, 0xec, 0xe3, 0xcc, 0x55, 0x18, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x55, 0x00, 0x49, 0x00,
  0x53, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x67, 0x00, 0x6c, 0x00, 0x65, 0x00,
  0x4a, 0x00, 0x6f, 0x00, 0x62, 0x00, 0x53, 0x00, 0x74, 0x00, 0x61, 0x00,
  0x74, 0x00, 0x75, 0x00, 0x73, 0x00, 0x53, 0x00, 0x74, 0x00, 0x72, 0x00,
  0x69, 0x00, 0x6e, 0x00, 0x67, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00
};

static const uint8_t getprinterdata_resp_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00
};

static const uint8_t replyopenprinter_req_data[] = {
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
  0x5c, 0x00, 0x5c, 0x00, 0x57, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x58, 0x00,
  0x50, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t replyopenprinter_resp_data[] = {
  0x00, 0x00, 0x00, 0x00, 0xef, 0x4a, 0x33, 0x05, 0x22, 0xf4, 0xc4, 0x4a,
  0xa2, 0xde, 0x52, 0x17, 0xa6, 0xc8, 0x19, 0xd0, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t RFFPCNEX_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0xbf, 0xee, 0x56, 0x27, 0x7f, 0xef, 0xf7, 0x42,
  0x84, 0x54, 0xd5, 0x7b, 0xec, 0xe3, 0xcc, 0x55, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xe0, 0x21, 0x26, 0x74, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x5c, 0x00,
  0x57, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x58, 0x00, 0x50, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x4c, 0x0d, 0x0b, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x60, 0x0d, 0x0b, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x78, 0x0d, 0x0b, 0x00,
  0x09, 0x00, 0x00, 0x00, 0x01, 0x00, 0x14, 0x00, 0x12, 0x00, 0x05, 0x00,
  0x06, 0x00, 0x04, 0x00, 0x03, 0x00, 0x0c, 0x00, 0x0d, 0x00
};

static const uint8_t RFFPCNEX_out_data[] = {
  0x00, 0x00, 0x00, 0x00
};

static const uint8_t RFNPCNEX_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x1e, 0x9b, 0x8b, 0xe5, 0x32, 0x9a, 0xd5, 0x45,
  0xa8, 0x0a, 0x10, 0x30, 0x5b, 0x87, 0x6f, 0x69, 0x01, 0x00, 0x00, 0x00,
  0x44, 0x0d, 0x0b, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t RFNPCNEX_out_data[] = {
  0x00, 0x00, 0x02, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x12, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x38, 0x00, 0x00, 0x00, 0x08, 0x00, 0x02, 0x00, 0x00, 0x00, 0x0d, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x08, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x02, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x1c, 0x00, 0x00, 0x00, 0x10, 0x00, 0x02, 0x00, 0x01, 0x00, 0x0a, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0b, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x14, 0x00, 0x02, 0x00, 0x01, 0x00, 0x0d, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x14, 0x00, 0x00, 0x00, 0x18, 0x00, 0x02, 0x00, 0x01, 0x00, 0x0f, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x02, 0x00, 0x01, 0x00, 0x14, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x15, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x16, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x8c, 0x22, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x17, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x02, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x20, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x1c, 0x00, 0x00, 0x00, 0x24, 0x00, 0x02, 0x00, 0x01, 0x00, 0x0a, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0b, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x28, 0x00, 0x02, 0x00, 0x01, 0x00, 0x0d, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x14, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x02, 0x00, 0x01, 0x00, 0x0f, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x30, 0x00, 0x02, 0x00, 0x01, 0x00, 0x14, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x15, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x16, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x8c, 0x22, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x17, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
  0x5c, 0x00, 0x5c, 0x00, 0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x33, 0x00,
  0x64, 0x00, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00,
  0x41, 0x00, 0x70, 0x00, 0x70, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x20, 0x00,
  0x4c, 0x00, 0x61, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x57, 0x00,
  0x72, 0x00, 0x69, 0x00, 0x74, 0x00, 0x65, 0x00, 0x72, 0x00, 0x20, 0x00,
  0x31, 0x00, 0x32, 0x00, 0x2f, 0x00, 0x36, 0x00, 0x34, 0x00, 0x30, 0x00,
  0x20, 0x00, 0x50, 0x00, 0x53, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x41, 0x00, 0x64, 0x00,
  0x6d, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x69, 0x00, 0x73, 0x00, 0x74, 0x00,
  0x72, 0x00, 0x61, 0x00, 0x74, 0x00, 0x6f, 0x00, 0x72, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00,
  0x54, 0x00, 0x65, 0x00, 0x73, 0x00, 0x74, 0x00, 0x73, 0x00, 0x65, 0x00,
  0x69, 0x00, 0x74, 0x00, 0x65, 0x00, 0x00, 0x00, 0xd6, 0x07, 0x07, 0x00,
  0x06, 0x00, 0x16, 0x00, 0x0b, 0x00, 0x11, 0x00, 0x01, 0x00, 0x60, 0x03,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00,
  0x41, 0x00, 0x64, 0x00, 0x6d, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x69, 0x00,
  0x73, 0x00, 0x74, 0x00, 0x72, 0x00, 0x61, 0x00, 0x74, 0x00, 0x6f, 0x00,
  0x72, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x00, 0x00, 0x54, 0x00, 0x65, 0x00, 0x73, 0x00, 0x74, 0x00,
  0x73, 0x00, 0x65, 0x00, 0x69, 0x00, 0x74, 0x00, 0x65, 0x00, 0x00, 0x00,
  0xd6, 0x07, 0x07, 0x00, 0x06, 0x00, 0x16, 0x00, 0x0b, 0x00, 0x11, 0x00,
  0x0b, 0x00, 0x85, 0x02, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t enumforms_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x22, 0x5c, 0x46, 0xe5, 0x74, 0xa1, 0x9e, 0x46,
  0x95, 0x80, 0x19, 0xf1, 0xaa, 0x63, 0xc9, 0x01, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t enumforms_out_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x6c, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7a, 0x00, 0x00, 0x00
};

static const uint8_t enumprinterdataex_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x22, 0x5c, 0x46, 0xe5, 0x74, 0xa1, 0x9e, 0x46,
  0x95, 0x80, 0x19, 0xf1, 0xaa, 0x63, 0xc9, 0x01, 0x09, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x44, 0x00, 0x73, 0x00,
  0x44, 0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x00, 0x65, 0x00, 0x72, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t enumprinterdataex_out_data[] = {
  0x00, 0x00, 0x00, 0x00, 0xe0, 0x06, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
  0xea, 0x00, 0x00, 0x00
};

static const uint8_t enumprinterkey_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x22, 0x5c, 0x46, 0xe5, 0x74, 0xa1, 0x9e, 0x46,
  0x95, 0x80, 0x19, 0xf1, 0xaa, 0x63, 0xc9, 0x01, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc9, 0x11,
  0x00, 0x00, 0x00, 0x00
};

static const uint8_t enumprinterkey_out_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x00, 0x00, 0xea, 0x00, 0x00, 0x00
};

static const uint8_t FCPN_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x03, 0xfc, 0xcf, 0xe5, 0x98, 0xfd, 0x15, 0x4b,
  0xba, 0x28, 0x03, 0x70, 0x74, 0x35, 0x8d, 0x14
};

static const uint8_t FCPN_out_data[] = {
  0x00, 0x00, 0x00, 0x00
};

static const uint8_t replycloseprinter_in_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x60, 0xe4, 0xdf, 0x77, 0xb1, 0xbf, 0x43, 0x4f,
  0xbf, 0xb4, 0x58, 0x5c, 0x44, 0xc6, 0x3e, 0x09
};

static const uint8_t replycloseprinter_out_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t getprinterdriverdir_in_data[] = {
  0x00, 0x00, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x5c, 0x00, 0x73, 0x00, 0x65, 0x00,
  0x72, 0x00, 0x6e, 0x00, 0x6f, 0x00, 0x78, 0x00, 0x34, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x02, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0f, 0x00, 0x00, 0x00, 0x57, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x64, 0x00,
  0x6f, 0x00, 0x77, 0x00, 0x73, 0x00, 0x20, 0x00, 0x4e, 0x00, 0x54, 0x00,
  0x20, 0x00, 0x78, 0x00, 0x38, 0x00, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x08, 0x00, 0x02, 0x00, 0x08, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x18, 0xac, 0x26, 0x00, 0x7f, 0xde, 0x15, 0x5f,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x69, 0x4d, 0x88, 0x7f, 0x94, 0xd2, 0xa9, 0x01,
  0xdb, 0xe4, 0x15, 0x5f, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
  0xfc, 0xd2, 0xa9, 0x01, 0x7f, 0xe5, 0x15, 0x5f, 0xfc, 0xdb, 0xa9, 0x01,
  0x18, 0xac, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x14, 0x01, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0xce, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xe8, 0xd2, 0xa9, 0x01, 0x00, 0x00, 0x00, 0x00, 0x97, 0x7c, 0xf3, 0x77,
  0x40, 0x9e, 0x0a, 0x00, 0xe1, 0x67, 0xf3, 0x77, 0x18, 0x07, 0x08, 0x00,
  0xf9, 0x67, 0xf3, 0x77, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x48, 0x9e, 0x0a, 0x00, 0x18, 0x00, 0x00, 0x00,
  0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
  0x98, 0xd0, 0xa9, 0x01, 0x00, 0x00, 0x00, 0x00, 0xe8, 0xd2, 0xa9, 0x01,
  0x34, 0x5a, 0xf3, 0x77, 0x70, 0x95, 0xf7, 0x77, 0xff, 0xff, 0xff, 0xff,
  0xf3, 0x73, 0xf3, 0x77, 0x08, 0x02, 0x00, 0x00
};

static const uint8_t getprinterdriverdir_out_data[] = {
  0x04, 0x00, 0x00, 0x00, 0x08, 0x02, 0x00, 0x00, 0x5c, 0x00, 0x5c, 0x00,
  0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x6e, 0x00, 0x6f, 0x00, 0x78, 0x00,
  0x34, 0x00, 0x5c, 0x00, 0x70, 0x00, 0x72, 0x00, 0x69, 0x00, 0x6e, 0x00,
  0x74, 0x00, 0x24, 0x00, 0x5c, 0x00, 0x57, 0x00, 0x33, 0x00, 0x32, 0x00,
  0x58, 0x00, 0x38, 0x00, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t addprinterdriverex_in_data[] = {
  0x00, 0x00, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0a, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x5c, 0x00, 0x73, 0x00, 0x65, 0x00,
  0x72, 0x00, 0x6e, 0x00, 0x6f, 0x00, 0x78, 0x00, 0x34, 0x00, 0x00, 0x00,
  0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x02, 0x00, 0x0c, 0x00, 0x02, 0x00,
  0x10, 0x00, 0x02, 0x00, 0x14, 0x00, 0x02, 0x00, 0x18, 0x00, 0x02, 0x00,
  0x1c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x20, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x24, 0x00, 0x02, 0x00, 0x00, 0x40, 0x2a, 0x7c, 0xdd, 0x68, 0xc2, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xce, 0x0e, 0x02, 0x00, 0x05, 0x00,
  0x28, 0x00, 0x02, 0x00, 0x2c, 0x00, 0x02, 0x00, 0x30, 0x00, 0x02, 0x00,
  0x34, 0x00, 0x02, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x48, 0x00, 0x65, 0x00, 0x77, 0x00, 0x6c, 0x00,
  0x65, 0x00, 0x74, 0x00, 0x74, 0x00, 0x2d, 0x00, 0x50, 0x00, 0x61, 0x00,
  0x63, 0x00, 0x6b, 0x00, 0x61, 0x00, 0x72, 0x00, 0x64, 0x00, 0x20, 0x00,
  0x48, 0x00, 0x50, 0x00, 0x2d, 0x00, 0x47, 0x00, 0x4c, 0x00, 0x2f, 0x00,
  0x32, 0x00, 0x20, 0x00, 0x50, 0x00, 0x6c, 0x00, 0x6f, 0x00, 0x74, 0x00,
  0x74, 0x00, 0x65, 0x00, 0x72, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x57, 0x00, 0x69, 0x00,
  0x6e, 0x00, 0x64, 0x00, 0x6f, 0x00, 0x77, 0x00, 0x73, 0x00, 0x20, 0x00,
  0x4e, 0x00, 0x54, 0x00, 0x20, 0x00, 0x78, 0x00, 0x38, 0x00, 0x36, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x2d, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x5c, 0x00, 0x73, 0x00, 0x65, 0x00,
  0x72, 0x00, 0x6e, 0x00, 0x6f, 0x00, 0x78, 0x00, 0x34, 0x00, 0x5c, 0x00,
  0x70, 0x00, 0x72, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x24, 0x00,
  0x5c, 0x00, 0x57, 0x00, 0x33, 0x00, 0x32, 0x00, 0x58, 0x00, 0x38, 0x00,
  0x36, 0x00, 0x5c, 0x00, 0x34, 0x00, 0x30, 0x00, 0x34, 0x00, 0x30, 0x00,
  0x33, 0x00, 0x31, 0x00, 0x31, 0x00, 0x36, 0x00, 0x5c, 0x00, 0x50, 0x00,
  0x4c, 0x00, 0x4f, 0x00, 0x54, 0x00, 0x54, 0x00, 0x45, 0x00, 0x52, 0x00,
  0x2e, 0x00, 0x44, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x00, 0x00, 0x00,
  0x5c, 0x00, 0x5c, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x6e, 0x00,
  0x6f, 0x00, 0x78, 0x00, 0x34, 0x00, 0x5c, 0x00, 0x70, 0x00, 0x72, 0x00,
  0x69, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x24, 0x00, 0x5c, 0x00, 0x57, 0x00,
  0x33, 0x00, 0x32, 0x00, 0x58, 0x00, 0x38, 0x00, 0x36, 0x00, 0x5c, 0x00,
  0x34, 0x00, 0x30, 0x00, 0x34, 0x00, 0x30, 0x00, 0x33, 0x00, 0x31, 0x00,
  0x31, 0x00, 0x36, 0x00, 0x5c, 0x00, 0x48, 0x00, 0x50, 0x00, 0x47, 0x00,
  0x4c, 0x00, 0x32, 0x00, 0x50, 0x00, 0x45, 0x00, 0x4e, 0x00, 0x2e, 0x00,
  0x50, 0x00, 0x43, 0x00, 0x44, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x5c, 0x00,
  0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x6e, 0x00, 0x6f, 0x00, 0x78, 0x00,
  0x34, 0x00, 0x5c, 0x00, 0x70, 0x00, 0x72, 0x00, 0x69, 0x00, 0x6e, 0x00,
  0x74, 0x00, 0x24, 0x00, 0x5c, 0x00, 0x57, 0x00, 0x33, 0x00, 0x32, 0x00,
  0x58, 0x00, 0x38, 0x00, 0x36, 0x00, 0x5c, 0x00, 0x34, 0x00, 0x30, 0x00,
  0x34, 0x00, 0x30, 0x00, 0x33, 0x00, 0x31, 0x00, 0x31, 0x00, 0x36, 0x00,
  0x5c, 0x00, 0x50, 0x00, 0x4c, 0x00, 0x4f, 0x00, 0x54, 0x00, 0x55, 0x00,
  0x49, 0x00, 0x2e, 0x00, 0x44, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x00, 0x00,
  0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x00, 0x00,
  0x5c, 0x00, 0x5c, 0x00, 0x73, 0x00, 0x65, 0x00, 0x72, 0x00, 0x6e, 0x00,
  0x6f, 0x00, 0x78, 0x00, 0x34, 0x00, 0x5c, 0x00, 0x70, 0x00, 0x72, 0x00,
  0x69, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x24, 0x00, 0x5c, 0x00, 0x57, 0x00,
  0x33, 0x00, 0x32, 0x00, 0x58, 0x00, 0x38, 0x00, 0x36, 0x00, 0x5c, 0x00,
  0x34, 0x00, 0x30, 0x00, 0x34, 0x00, 0x30, 0x00, 0x33, 0x00, 0x31, 0x00,
  0x31, 0x00, 0x36, 0x00, 0x5c, 0x00, 0x50, 0x00, 0x4c, 0x00, 0x4f, 0x00,
  0x54, 0x00, 0x55, 0x00, 0x49, 0x00, 0x2e, 0x00, 0x48, 0x00, 0x4c, 0x00,
  0x50, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x48, 0x00, 0x50, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x41, 0x00, 0x00, 0x00, 0x68, 0x00, 0x74, 0x00, 0x74, 0x00, 0x70, 0x00,
  0x3a, 0x00, 0x2f, 0x00, 0x2f, 0x00, 0x67, 0x00, 0x6f, 0x00, 0x2e, 0x00,
  0x6d, 0x00, 0x69, 0x00, 0x63, 0x00, 0x72, 0x00, 0x6f, 0x00, 0x73, 0x00,
  0x6f, 0x00, 0x66, 0x00, 0x74, 0x00, 0x2e, 0x00, 0x63, 0x00, 0x6f, 0x00,
  0x6d, 0x00, 0x2f, 0x00, 0x66, 0x00, 0x77, 0x00, 0x6c, 0x00, 0x69, 0x00,
  0x6e, 0x00, 0x6b, 0x00, 0x2f, 0x00, 0x3f, 0x00, 0x4c, 0x00, 0x69, 0x00,
  0x6e, 0x00, 0x6b, 0x00, 0x49, 0x00, 0x44, 0x00, 0x3d, 0x00, 0x33, 0x00,
  0x37, 0x00, 0x26, 0x00, 0x70, 0x00, 0x72, 0x00, 0x64, 0x00, 0x3d, 0x00,
  0x31, 0x00, 0x30, 0x00, 0x37, 0x00, 0x39, 0x00, 0x38, 0x00, 0x26, 0x00,
  0x73, 0x00, 0x62, 0x00, 0x70, 0x00, 0x3d, 0x00, 0x50, 0x00, 0x72, 0x00,
  0x69, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x19, 0x00, 0x00, 0x00, 0x68, 0x00, 0x70, 0x00, 0x68, 0x00, 0x65, 0x00,
  0x77, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x74, 0x00, 0x74, 0x00, 0x2d, 0x00,
  0x70, 0x00, 0x61, 0x00, 0x63, 0x00, 0x6b, 0x00, 0x61, 0x00, 0x72, 0x00,
  0x64, 0x00, 0x5f, 0x00, 0x68, 0x00, 0x70, 0x00, 0x37, 0x00, 0x33, 0x00,
  0x31, 0x00, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x4d, 0x00, 0x69, 0x00,
  0x63, 0x00, 0x72, 0x00, 0x6f, 0x00, 0x73, 0x00, 0x6f, 0x00, 0x66, 0x00,
  0x74, 0x00, 0x00, 0x00, 0x18, 0x00, 0x01, 0x00
};

struct torture_suite *ndr_spoolss_suite(TALLOC_CTX *ctx)
{
	struct torture_suite *suite = torture_suite_create(ctx, "spoolss");

	torture_suite_add_ndr_pull_fn_test(suite, spoolss_OpenPrinterEx, openprinterex_req_data, NDR_IN, NULL );
	torture_suite_add_ndr_pull_fn_test(suite, spoolss_OpenPrinterEx, openprinterex_resp_data, NDR_OUT, NULL );

	torture_suite_add_ndr_pull_fn_test(suite, spoolss_ClosePrinter, closeprinter_req_data, NDR_IN, NULL );
	torture_suite_add_ndr_pull_fn_test(suite, spoolss_ClosePrinter, closeprinter_resp_data, NDR_OUT, NULL );

	torture_suite_add_ndr_pull_fn_test(suite, spoolss_GetPrinter, getprinter_req_data, NDR_IN, NULL );
	torture_suite_add_ndr_pull_fn_test(suite, spoolss_GetPrinter, getprinter_resp_data, NDR_OUT, NULL );

	/*torture_suite_add_ndr_pull_fn_test(suite, spoolss_GetPrinterData, getprinterdata_req_data, NDR_IN, NULL );
	torture_suite_add_ndr_pull_fn_test(suite, spoolss_GetPrinterData, getprinterdata_resp_data, NDR_OUT, NULL );*/

	torture_suite_add_ndr_pull_fn_test(suite, spoolss_ReplyOpenPrinter, replyopenprinter_req_data, NDR_IN, NULL );
	torture_suite_add_ndr_pull_fn_test(suite, spoolss_ReplyOpenPrinter, replyopenprinter_resp_data, NDR_OUT, NULL );

	torture_suite_add_ndr_pull_fn_test(suite, spoolss_ReplyClosePrinter, replycloseprinter_in_data, NDR_IN, NULL );
	torture_suite_add_ndr_pull_fn_test(suite, spoolss_ReplyClosePrinter, replycloseprinter_out_data, NDR_OUT, NULL );

	torture_suite_add_ndr_pull_fn_test(suite, spoolss_RemoteFindFirstPrinterChangeNotifyEx, RFFPCNEX_in_data, NDR_IN, NULL );
	torture_suite_add_ndr_pull_fn_test(suite, spoolss_RemoteFindFirstPrinterChangeNotifyEx, RFFPCNEX_out_data, NDR_OUT, NULL );

	torture_suite_add_ndr_pull_fn_test(suite, spoolss_RemoteFindNextPrinterChangeNotifyEx, RFNPCNEX_in_data, NDR_IN, NULL );
	torture_suite_add_ndr_pull_fn_test(suite, spoolss_RemoteFindNextPrinterChangeNotifyEx, RFNPCNEX_out_data, NDR_OUT, NULL );

	torture_suite_add_ndr_pull_fn_test(suite, spoolss_EnumForms, enumforms_in_data, NDR_IN, NULL );
	torture_suite_add_ndr_pull_fn_test(suite, spoolss_EnumForms, enumforms_out_data, NDR_OUT, NULL );

	torture_suite_add_ndr_pull_fn_test(suite, spoolss_EnumPrinterDataEx, enumprinterdataex_in_data, NDR_IN, NULL );
	torture_suite_add_ndr_pull_fn_test(suite, spoolss_EnumPrinterDataEx, enumprinterdataex_out_data, NDR_OUT, NULL );

	torture_suite_add_ndr_pull_fn_test(suite, spoolss_EnumPrinterKey, enumprinterkey_in_data, NDR_IN, NULL );
	torture_suite_add_ndr_pull_fn_test(suite, spoolss_EnumPrinterKey, enumprinterkey_out_data, NDR_OUT, NULL );

	torture_suite_add_ndr_pull_fn_test(suite, spoolss_FindClosePrinterNotify, FCPN_in_data, NDR_IN, NULL );
	torture_suite_add_ndr_pull_fn_test(suite, spoolss_FindClosePrinterNotify, FCPN_out_data, NDR_OUT, NULL );

	torture_suite_add_ndr_pull_fn_test(suite, spoolss_GetPrinterDriverDirectory, getprinterdriverdir_in_data, NDR_IN, NULL );
	/* torture_suite_add_ndr_pull_fn_test(suite, spoolss_GetPrinterDriverDirectory, getprinterdriverdir_out_data, NDR_OUT, NULL ); */

/*	torture_suite_add_ndr_pull_fn_test(suite, spoolss_AddPrinterDriverEx, addprinterdriverex_in_data, NDR_IN, NULL );*/

	return suite;
}
