/*

This file is a modified version of the md5 driver from the 
"Strip" palmos program. Strip is licensed under the GPL, and this code
inherits Strip's license. For more information see below. 
--Stephen J Lombardo, 11/07/2000

//Begin old header 
Program : Strip (Secure Tool for Recalling Important Passwords) 
Description: A secure password and account manager for the Palm(t) Computing Platform 
Copyright (C) 1999  Stephen J Lombardo

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

Strip has been written and developed by Stephen J Lombardo (Zetetic Enterprises) 1999

Contact Info:
lombardos@zetetic.net
http://www.zetetic.net/
Zetetic Enterprises
348 Wasington Ave 
Clifton NJ, 07011

Bug reports and feature requests should be sent to bugs@zetetic.net.

*/

#include <strings.h>
#include "constants.h"
#include "md5.h"
#include "md5driver.h"


/******************************************************
 * Function: MDBlock
 * Description: computes a message digest for a memory
 * block. Assumes the out array is of the proper size
 * The non-US md5 implementation does not need the MDPack
 * function, it puts the digest directly into the 'out'
 * variable
 * ****************************************************/
void md5block(unsigned char * inblock, int len, unsigned char *out) {
  md5_state_t mdContext;
  md5_init (&mdContext);
  md5_append (&mdContext, inblock, len);
  md5_finish (&mdContext, out);
}


/******************************************************
 * Function: MD5String
 * Description: computes a message digest for a string.
 * Assumes out array is of the proper size.
 * ****************************************************/
unsigned char * md5string (char *inString) {
  static unsigned char out[16];
  unsigned int len;
  len = strlen(inString);
  md5block(inString, len, out);
  return out;
}


