/* queue_valid.c -- Queues requests to server

   Copyright (c) Dave Airlie 2000
   airlied@samba.org

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "config.h"
#ifdef PAM_SMB_DAEMON
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <unistd.h>
#include <syslog.h>
#include <time.h>
#include "smblib.h"
#include "constants.h"
#include "pam_smb_queue.h"

#include <errno.h>

/*
 * Queues a request to the server
 */
int queue_user(char *username,char *password, char *domain)
{
  key_t key=PAMSMBKEY;
  pid_t cli_pid;
  int mid, n;
  MESSAGE msg;
  time_t start_time, now_time;

  cli_pid = getpid();

  if ((mid=msgget(key, 0)) == -1)
    {
      syslog(LOG_AUTHPRIV | LOG_ERR, "pamsmbd is not running, no authentication possible");
      return 2;
    }

  msg.msg_to=SERVER;
  msg.msg_fm=cli_pid;
  msg.return_code=2;

  strncpy(msg.username, username, MAX_NT_LEN);
  strncpy(msg.password, password, MAX_PASS_LEN);
  strncpy(msg.domain, domain, MAX_NTDOM_LEN);

  if(msgsnd(mid, (struct msgbuf *)&msg, sizeof(msg),  0) == -1)
    {
    syslog(LOG_AUTHPRIV | LOG_ERR, "pamsmbd : msg_snd problem");
    return 2;
    }

  start_time=time(NULL);
  
  for(;;)
    {
      if((n=msgrcv(mid, (struct msgbuf *)&msg, sizeof(msg), cli_pid, IPC_NOWAIT)) != -1 )
	{
	  /* fprintf(stderr, "Got something back... %d", msg.return_code); */
	  strncpy(username, msg.username, 15);
	  return(msg.return_code);
	}
      else
	{
	  switch(errno)
	    {
	    case EIDRM:
	      syslog(LOG_AUTHPRIV | LOG_ERR, "pamsmbm: server finished..\n");
	      return 2;
	      break;
	    default:
	    case EINTR:
	      syslog(LOG_AUTHPRIV | LOG_ERR, "pamsmbm: caught signal..\n");
	      return 2;
	      break;
	    case ENOMSG:
	      now_time=time(NULL);
	      if ((now_time-start_time)>PAMSMB_SERVERTIMEOUT)
		{
		  syslog(LOG_AUTHPRIV | LOG_ERR, "pamsmbm: no server...\n");
		  return 2;
		}
	    }
	}
    }
}
#else
void dummy_function_queue_valid(void) { } /* stops some compilers complaining */
#endif
