/* 
   Unix SMB/Netbios implementation.
   Version 1.9.
   Copyright (C) Andrew Tridgell 1994
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * This program reports current SMB connections
 */

#include "includes.h"
#include "loadparm.h"

struct connect_record crec;
extern int DEBUGLEVEL;
extern FILE *dbf;

int main(int argc, char *argv[])
{
  FILE *f;
  pstring fname="";
  int uid, c;
  static pstring servicesf = CONFIGFILE;
  extern char *optarg;
  int verbose = 0;

  DEBUGLEVEL = 0;
  dbf = fopen("/dev/null","w");

  if (getuid() != geteuid()) {
    printf("smbstatus should not be run setuid\n");
    return(1);
  }

  while ((c = getopt(argc, argv, "ds:")) != EOF) {
    switch (c) {
    case 'd':
      verbose = 1;
      break;
    case 's':
      strcpy(servicesf, optarg);
      break;
    default:
      fprintf(stderr, "Usage: %s [-d] [-s configfile]\n", *argv);
      return (-1);
    }
  }

  if (!lp_load(servicesf)) {
    fprintf(stderr, "Can't load %s - run testparm to debug it\n", servicesf);
    return (-1);
  }

  if (verbose) {
    printf("using configfile = %s\n", servicesf);
    printf("lockdir = %s\n", *lp_lockdir() ? lp_lockdir() : "NULL");
  }

  strcpy(fname,lp_lockdir());
  standard_sub_basic(fname);
  trim_string(fname,"","/");
  strcat(fname,"/STATUS..LCK");

  f = fopen(fname,"r");
  if (!f) {
    printf("Couldn't open status file %s\n",fname);
    if (!lp_status(-1))
      printf("You need to have status=yes in your smb config file\n");
    return(0);
  }

  uid = getuid();

  printf("\nSamba version %s\n",VERSION);

  printf("Service      uid   gid   pid   machine\n");
  printf("--------------------------------------\n");

  while (!feof(f))
    {
      if (fread(&crec,sizeof(crec),1,f) != 1)
	break;
      if (crec.magic == 0x280267 && process_exists(crec.pid))
	printf("%-10.10s %5d %5d %5d   %s (%s) %s",
	       crec.name,crec.uid,crec.gid,crec.pid,
	       crec.machine,crec.addr,asctime(LocalTime(&crec.start,0)));
    }

  printf("\n");

  fclose(f);
  return (0);
}

