/* 
   Unix SMB/Netbios implementation.
   Version 0.1
   WINS server routines and daemon - version 3
   Copyright (C) Andrew Tridgell 1994-1996 Luke Leighton 1996
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
   Module name: nameservreply.c

   Revision History:

   14 jan 96: lkcl@pires.co.uk
   added multiple workgroup domain master support

   04 jul 96: lkcl@pires.co.uk
   created module nameservreply containing NetBIOS reply functions

*/

#include "includes.h"

extern int ServerNMB[];
extern int DEBUGLEVEL;

extern struct name_record *namelist;
extern time_t names_last_modified;


/****************************************************************************
  send a WAIT for ACKNOWLEDGEMENT packet.
  **************************************************************************/
void send_wait_ack(struct packet_struct *p, uint16 id, time_t ttl, int nb_flags)
{
	struct nmb_packet *nmb = &p->packet.nmb;
	struct nmb_name *question = &nmb->question.question_name;

	char rdata[2];

	/* XXXX all the other information is needed, too - nm_flags */
	rdata[0] = (nmb->header.opcode&0xf) << 1;

	/* XXXX mistake in rfc1002.txt? 4.2.16: NULL is 0xa see 4.2.1.3 
	  type  = 0x0a; see rfc1002.txt 4.2.1.3 
	  class = 0x01; see rfc1002.txt 4.2.16
	 */

	/* send WAIT ACKNOWLEDGEMENT see rfc1002.txt 4.2.16 */
	reply_netbios_packet(p,id,
					0,NMB_WAIT_ACK,NMB_WAIT_ACK,False,False,
					question, RR_TYPE_NULL, RR_CLASS_IP,
					ttl, 
					rdata, 2);
}

/***************************************************************************
  add a netbios entry. respond to the (possibly new) owner.
  **************************************************************************/
void add_name_respond(struct packet_struct *p, BOOL multi,
				uint16 response_id,
				struct nmb_name *name,
				struct nmb_ip *nb, int num_ips,
				BOOL success, BOOL new_owner, struct in_addr old_ip,
				struct in_addr reply_to_ip)
{
	int rcode;

	if (new_owner)
	{
		/* remove (not expire) name from records */
		remove_netbios_name(p->timestamp, &namelist, &names_last_modified,
		                     name, old_ip, False);
	}

	/* register the old or the new owners' ip */
	add_netbios_entry(p->timestamp, &namelist,&names_last_modified,
					name,nb,
					True,multi);

	/* see rfc1002.txt 4.2.11 for RCODEs */
    rcode = success ? RCODE_REG_OK : RCODE_REG_ACT_ERR;

	/* reply yes or no to the host that requested the name */
	send_name_response(p, response_id, multi ? NMB_REG_MULTI : NMB_REG,
				rcode, True, True, name, nb->nb_flags, nb->death_time,
				reply_to_ip);
}
