/* 
   Unix SMB/Netbios implementation.
   Version 1.9.
   NBT client - used to lookup netbios names
   Copyright (C) Andrew Tridgell 1994-1995
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
*/

#ifdef SYSLOG
#undef SYSLOG
#endif

#include "includes.h"

extern int DEBUGLEVEL;

static pstring client_scope;


/****************************************************************************
usage on the program
****************************************************************************/
static void usage(void)
{
  printf("Usage: nmblookup address [-B] [-M] [-d debuglevel] name\n");
  printf("Version %s\n",VERSION);
  printf("\t-d debuglevel         set the debuglevel\n");
  printf("\t-B broadcast address  the address to use for broadcasts\n");
  printf("\t-M                    searches for a master browser\n");
  printf("\t-S                    lookup node status as well\n");
  printf("\n");
}


/****************************************************************************
  main program
****************************************************************************/
int main(int argc,char *argv[])
{
  BOOL bcast = False;
  int opt;
  unsigned int lookup_type = 0x0;
  pstring lookup;
  extern int optind;
  extern char *optarg;
  BOOL find_master=False;
  BOOL find_status=False;
  struct in_addr search_ip;
  struct nmb_ip **ip_list;
  int i;
  
  DEBUGLEVEL = 1;

  *client_scope = 0;

  *lookup = 0;

  TimeInit();

  setup_logging(argv[0],True);

  charset_initialise();

  if (argc > 1)
  {
    search_ip.s_addr = interpret_addr(argv[1]);
  }

  while ((opt = getopt(argc, argv, "p:d:i:BSMh")) != EOF)
  {
    switch (opt)
    {
      case 'B':
        bcast = True;
        break;

      case 'i':
        strcpy(client_scope,optarg);
        strupper(client_scope);
        break;

      case 'M':
        find_master = True;
        break;

      case 'S':
        find_status = True;
        break;

      case 'h':
        usage();
        exit(0);
        break;

      case 'd':
        DEBUGLEVEL = atoi(optarg);
        break;

      default:
        if (optind == 1)
        {
          break;
        }
        else
        {
          usage();
          exit(1);
        }
    }
  }

  if (argc < 3)
  {
    usage();
    exit(1);
  }

  DEBUG(1,("Sending queries to %s bcast = %s\n",inet_ntoa(search_ip),
				BOOLSTR(bcast)));

  for (i=optind+1;i<argc;i++)
  {
    int retries = 2;
    char *p;
    struct in_addr ip;
    struct nmb_name nm;

    strcpy(lookup,argv[i]);

    if (find_master)
    {
      if (*lookup == '-')
      {
        strcpy(lookup,"\01\02__MSBROWSE__\02");
        lookup_type = 1;
      } else {
        lookup_type = 0x1b;
      }
    }

    p = strchr(lookup,'#');

    if (p)
    {
      *p = 0;
      sscanf(p+1,"%x",&lookup_type);
      retries = 1;
    }

    make_nmb_name(&nm, lookup, lookup_type, client_scope);

    printf("%s",namestr(&nm));

    if ((ip_list = name_query2(&nm,bcast,True,search_ip))!=NULL)
    {
      int j = 0;

      while (ip_list[j])
      {
        unsigned char nb_flags = ip_list[j]->nb_flags;
        putip(&ip,&ip_list[j]->ip);

        if (find_status) 
        { 
            printf("\nLooking up status at %s\n",inet_ntoa(ip));
            name_status(&nm,True,ip,NULL,NULL);
            printf("\n");
        }
        else
        {
          printf("%s (%2x) ",inet_ntoa(ip), nb_flags);
        }

        j++;
      }
      if (!find_status) printf("\n");
    }
    else
    {
      printf("not found\n");
    }
  }

  printf("\n");

  return(0);
}
