#!/bin/sh
# 
# Adds SMB-DFS (MS-DFS) functionality to the samba-2.0.7 source tree.
# To build with Dfs, use: ./configure --with-msdfs
#					- Shirish Kalele 2000.11.27
#
REQD_FILES="msdfs.patch msdfs.c msdfs.h"
REQD_DIRS="samba-2.0.7 samba-2.0.7/source samba-2.0.7/source/include"

if [ $# -ne 0 ]
then
	SRCBASE=$1
	echo "Setting samba source base to: $SRCBASE"
	echo
else
	SRCBASE=`pwd`
	echo "Assuming samba-2.0.7 source tree rooted at: $SRCBASE" 
	echo
fi

# Check for required files in pwd.
for file in $REQD_FILES
do
	if [ ! -r $file ]
	then
		echo "A required file ($file) is missing. Aborting." >&2
		echo 
		exit 1
	fi
done

# Check if needed directories are present and writable
for dir in $REQD_DIRS
do
	if [ ! -d $SRCBASE/$dir -o ! -w $SRCBASE/$dir ]
	then
		echo "A neede directory ($SRCBASE/$dir) is missing or not writable." >&2
		echo "Aborting." >&2
		echo >&2
		exit 1
	fi
done

# Create msdfs directory
msdfs_dir=$SRCBASE/samba-2.0.7/source/msdfs
if [ ! -d $msdfs_dir ]
then
	mkdir $msdfs_dir
	if [ $? -ne 0 ]
	then
		echo "Unable to create directory: $msdfs_dir" >&2
		exit 1
	fi
fi
echo "Copying msdfs.c and msdfs.h.."
cp -f msdfs.c $msdfs_dir
cp -f msdfs.h $SRCBASE/samba-2.0.7/source/include

[ ! -r $SRCBASE/msdfs.patch ] && cp -f msdfs.patch $SRCBASE

savedir=`pwd`
cd $SRCBASE
echo "Applying patch to add Dfs functionality.."
patch -p0 -i msdfs.patch 
if [ $? -ne 0 ] 
then
	echo "Patch failed. Aborting.." >&2
	echo
	exit 1
fi
	
cd $savedir
echo "Done."
echo "Configure using: ./configure --with-msdfs"
echo "Set up Dfs trees as per documentation."

