/* LinPopUp - A Linux enhanced port of Winpopup, running over Samba.
 * Coded by Jean-Marc Jacquet <jeanmarcj@usa.net>
 * Copyright (C) 1998 Little Igloo Org  http://www.chez.com/littleigloo
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtkstyle.h>
#include "protos.h"



void
clear_text (GtkWidget * text)
{
  gtk_text_freeze (GTK_TEXT (text));
  gtk_text_backward_delete (GTK_TEXT (text), gtk_text_get_length (GTK_TEXT (text)));
  gtk_text_thaw (GTK_TEXT (text));
}



void
realize_text (GtkWidget * text, gpointer data)
{
  gtk_text_freeze (GTK_TEXT (text));
  gtk_text_insert (GTK_TEXT (text), NULL, &text->style->black, NULL, data, -1);
  gtk_text_thaw (GTK_TEXT (text));
}



void
main_copy_to_clipboard (GtkWidget * widget, gpointer data)
{
  GtkWidget *this_text;

/*-- retrieving send_text data previously marqued with gtk_object_set_data(...) --*/
  this_text = gtk_object_get_data (GTK_OBJECT (window), "text");
  gtk_editable_copy_clipboard (GTK_EDITABLE (this_text), 0);
}



void
main_select_all (GtkWidget * widget, gpointer data)
{
  GtkWidget *this_text;

/*-- retrieving send_text data previously marqued with gtk_object_set_data(...) --*/
  this_text = gtk_object_get_data (GTK_OBJECT (window), "text");
  gtk_editable_select_region (GTK_EDITABLE (this_text), 0, gtk_text_get_length (GTK_TEXT (this_text)));
}



GtkWidget *
create_text (GtkWidget * vbox)
{
  GtkWidget *table;
  GtkWidget *text;
  GtkWidget *hscrollbar;
  GtkWidget *vscrollbar;
  static GdkColor text_bg =
  {0, 0xffec, 0xffec, 0xffec};


  table = gtk_table_new (2, 2, FALSE);
  text = gtk_text_new (NULL, NULL);

  gtk_table_attach (GTK_TABLE (table), text, 0, 1, 0, 1,
		    GTK_FILL | GTK_EXPAND,
		    GTK_FILL | GTK_EXPAND | GTK_SHRINK, 0, 0);
  gtk_widget_show (text);

  hscrollbar = gtk_hscrollbar_new (GTK_TEXT (text)->hadj);
  gtk_table_attach (GTK_TABLE (table), hscrollbar, 0, 1, 1, 2,
		    GTK_EXPAND | GTK_FILL, GTK_FILL, 0, 0);
  gtk_widget_show (hscrollbar);

  vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
  gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
		    GTK_FILL, GTK_EXPAND | GTK_FILL | GTK_SHRINK, 0, 0);
  gtk_widget_show (vscrollbar);

  gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, TRUE, 0);
  gtk_widget_show (table);

  text->style->base[0] = text_bg;

  return text;
}
