/* LinPopUp - A Linux enhanced port of Winpopup, running over Samba.
 * Coded by Jean-Marc Jacquet <jeanmarcj@usa.net>
 * Copyright (C) 1998 Little Igloo Org  http://www.chez.com/littleigloo
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "protos.h"



static void
separator (GtkWidget * menu, GtkWidget * menu_item)
{
  menu_item = gtk_menu_item_new ();
  gtk_menu_append (GTK_MENU (menu), menu_item);
  gtk_widget_show (menu_item);
}



void
create_menu (GtkWidget * vbox)
{
  GtkWidget *menu;
  GtkWidget *menu_bar;
  GtkWidget *file_menu;
  GtkWidget *menu_item;
  GtkAcceleratorTable *accel_table;


  /* -- create accelerator table -- */
  accel_table = gtk_accelerator_table_new ();
  gtk_window_add_accelerator_table (GTK_WINDOW (window), accel_table);

  /* -- create menu bar -- */
  menu_bar = gtk_menu_bar_new ();
  gtk_box_pack_start (GTK_BOX (vbox), menu_bar, FALSE, TRUE, 0);
  gtk_widget_show (menu_bar);

  /* -- Message Menu -- */
  file_menu = gtk_menu_item_new_with_label ("Message");
  gtk_menu_bar_append (GTK_MENU_BAR (menu_bar), file_menu);
  gtk_widget_show (file_menu);

  menu = gtk_menu_new ();
  gtk_menu_set_accelerator_table (GTK_MENU (menu), accel_table);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (file_menu), menu);

  menu_item = gtk_menu_item_new_with_label (" New ");
  gtk_menu_append (GTK_MENU (menu), menu_item);
  gtk_signal_connect_object (GTK_OBJECT (menu_item), "activate", GTK_SIGNAL_FUNC (send_message), NULL);
  gtk_widget_show (menu_item);

  menu_item = gtk_menu_item_new_with_label (" Reply ");
  gtk_menu_append (GTK_MENU (menu), menu_item);
  gtk_signal_connect_object (GTK_OBJECT (menu_item), "activate", GTK_SIGNAL_FUNC (reply_message), NULL);
  gtk_widget_show (menu_item);

  separator (menu, menu_item);

  menu_item = gtk_menu_item_new_with_label (" Next ");
  gtk_menu_append (GTK_MENU (menu), menu_item);
  gtk_signal_connect_object (GTK_OBJECT (menu_item), "activate", GTK_SIGNAL_FUNC (show_next_message), NULL);
  gtk_widget_install_accelerator (menu_item, accel_table, "activate", 'N', GDK_CONTROL_MASK);
  gtk_widget_show (menu_item);

  menu_item = gtk_menu_item_new_with_label (" Previous ");
  gtk_menu_append (GTK_MENU (menu), menu_item);
  gtk_signal_connect_object (GTK_OBJECT (menu_item), "activate", GTK_SIGNAL_FUNC (show_previous_message), NULL);
  gtk_widget_install_accelerator (menu_item, accel_table, "activate", 'P', GDK_CONTROL_MASK);
  gtk_widget_show (menu_item);

  separator (menu, menu_item);

  menu_item = gtk_menu_item_new_with_label (" Delete ");
  gtk_menu_append (GTK_MENU (menu), menu_item);
  gtk_signal_connect_object (GTK_OBJECT (menu_item), "activate", GTK_SIGNAL_FUNC (delete_showed_message), NULL);
  gtk_widget_show (menu_item);

  menu_item = gtk_menu_item_new_with_label (" Delete All");
  gtk_menu_append (GTK_MENU (menu), menu_item);
  gtk_signal_connect_object (GTK_OBJECT (menu_item), "activate", GTK_SIGNAL_FUNC (delete_all_messages), NULL);
  gtk_widget_show (menu_item);

  separator (menu, menu_item);

  menu_item = gtk_menu_item_new_with_label (" Quit ");
  gtk_menu_append (GTK_MENU (menu), menu_item);
  gtk_signal_connect_object (GTK_OBJECT (menu_item), "activate", GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
  gtk_widget_install_accelerator (menu_item, accel_table, "activate", 'Q', GDK_CONTROL_MASK);
  gtk_widget_show (menu_item);

  separator (menu, menu_item);
  separator (menu, menu_item);



  /* -- Edit Menu -- */
  file_menu = gtk_menu_item_new_with_label ("Edit");
  gtk_menu_bar_append (GTK_MENU_BAR (menu_bar), file_menu);
  gtk_widget_show (file_menu);

  menu = gtk_menu_new ();
  gtk_menu_set_accelerator_table (GTK_MENU (menu), accel_table);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (file_menu), menu);

  menu_item = gtk_menu_item_new_with_label (" Select All  ");
  gtk_menu_append (GTK_MENU (menu), menu_item);
  gtk_signal_connect_object (GTK_OBJECT (menu_item), "activate", GTK_SIGNAL_FUNC (main_select_all), NULL);
  gtk_widget_install_accelerator (menu_item, accel_table, "activate", 'A', GDK_CONTROL_MASK);
  gtk_widget_show (menu_item);

  menu_item = gtk_menu_item_new_with_label (" Copy to Clipboard  ");
  gtk_menu_append (GTK_MENU (menu), menu_item);
  gtk_signal_connect_object (GTK_OBJECT (menu_item), "activate", GTK_SIGNAL_FUNC (main_copy_to_clipboard), NULL);
  gtk_widget_install_accelerator (menu_item, accel_table, "activate", 'C', GDK_CONTROL_MASK);
  gtk_widget_show (menu_item);

  separator (menu, menu_item);

  menu_item = gtk_menu_item_new_with_label (" Preferences...  ");
  gtk_menu_append (GTK_MENU (menu), menu_item);
  gtk_signal_connect_object (GTK_OBJECT (menu_item), "activate", GTK_SIGNAL_FUNC (custom_notebook), NULL);
  gtk_widget_show (menu_item);

  separator (menu, menu_item);
  separator (menu, menu_item);



  /* -- Help Menu -- */
  file_menu = gtk_menu_item_new_with_label ("Help");
  gtk_menu_bar_append (GTK_MENU_BAR (menu_bar), file_menu);
  gtk_widget_show (file_menu);

  menu = gtk_menu_new ();
  gtk_menu_set_accelerator_table (GTK_MENU (menu), accel_table);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (file_menu), menu);
  gtk_menu_item_right_justify (GTK_MENU_ITEM (file_menu));

  menu_item = gtk_menu_item_new_with_label (" About LinPopUp...  ");
  gtk_menu_append (GTK_MENU (menu), menu_item);
  gtk_signal_connect_object (GTK_OBJECT (menu_item), "activate", GTK_SIGNAL_FUNC (about_dialog), NULL);
  gtk_widget_show (menu_item);

  separator (menu, menu_item);

  menu_item = gtk_menu_item_new_with_label (" User Guide  ");
  gtk_menu_append (GTK_MENU (menu), menu_item);
  gtk_signal_connect_object (GTK_OBJECT (menu_item), "activate", GTK_SIGNAL_FUNC (doc_dialog), GINT_TO_POINTER (1));
  gtk_widget_show (menu_item);

/* 
   menu_item = gtk_menu_item_new_with_label (" LinPopUp FAQ  ");
   gtk_menu_append (GTK_MENU (menu), menu_item);
   gtk_signal_connect_object (GTK_OBJECT (menu_item), "activate", GTK_SIGNAL_FUNC (doc_dialog), GINT_TO_POINTER (2));
   gtk_widget_show (menu_item);
 */

  menu_item = gtk_menu_item_new_with_label (" Changes ");
  gtk_menu_append (GTK_MENU (menu), menu_item);
  gtk_signal_connect_object (GTK_OBJECT (menu_item), "activate", GTK_SIGNAL_FUNC (doc_dialog), GINT_TO_POINTER (3));
  gtk_widget_show (menu_item);

  menu_item = gtk_menu_item_new_with_label (" License ");
  gtk_menu_append (GTK_MENU (menu), menu_item);
  gtk_signal_connect_object (GTK_OBJECT (menu_item), "activate", GTK_SIGNAL_FUNC (doc_dialog), GINT_TO_POINTER (4));
  gtk_widget_show (menu_item);

  separator (menu, menu_item);
  separator (menu, menu_item);
}
