H12265
s 00016/00010/00064
d D 1.3 03/02/15 16:10:23 stevef 4 3
c Improve error logging.  Missing new line in some calls to printk
cC
cK53063
cZ-06:00
e
s 00001/00001/00073
d D 1.2 02/10/12 02:51:51 stevef 3 2
c change name of debug function to not conflict with optional jfs debug function
cC
cK30515
e
s 00074/00000/00000
d D 1.1 02/10/10 14:16:09 stevef 2 1
cC
cF1
cK29999
cO-rw-rw-r--
e
s 00000/00000/00000
d D 1.0 02/10/10 14:16:09 stevef 1 0
c BitKeeper file /home/stevef/bk/linux-2.5-with-cifs/fs/cifs/cifs_debug.h
cBtorvalds@athlon.transmeta.com|ChangeSet|20020205173056|16047|c1d11a41ed024864
cHsmfhome1.austin.rr.com
cK54488
cPfs/cifs/cifs_debug.h
cR75ec2a72ddd7ddd0
cV4
cX0x821
cZ-05:00
e
u
U
f e 0
f x 0x821
t
T
I 2
/*
 *
 *   Copyright (c) International Business Machines  Corp., 2000,2002
 *   Modified by Steve French (sfrench@us.ibm.com)
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
*/
#define CIFS_DEBUG		/* BB temporary */

#ifndef _H_CIFS_DEBUG
#define _H_CIFS_DEBUG

D 3
void dump_mem(char *label, void *data, int length);
E 3
I 3
void cifs_dump_mem(char *label, void *data, int length);
E 3
extern int traceSMB;		/* flag which enables the function below */
void dump_smb(struct smb_hdr *, int);

/*
 *	debug ON
 *	--------
 */
#ifdef CIFS_DEBUG

I 4

E 4
/* information message: e.g., configuration, major event */
extern int cifsFYI;
D 4
#define cFYI(button,prspec)\
{ if (button && cifsFYI) printk prspec; }
E 4
I 4
#define cifsfyi(format,arg...) if (cifsFYI) printk(KERN_DEBUG " " __FILE__ ": " format "\n" "" , ## arg)

#define cFYI(button,prspec) if (button) cifsfyi prspec

#define cifswarn(format, arg...) printk(KERN_WARNING ": " format "\n" , ## arg)
E 4

/* debug event message: */
D 4
#define cEVENT(button,prspec)\
{ if (button) printk prspec; }
E 4
I 4
extern int cifsERROR;

#define cEVENT(format,arg...) if (cifsERROR) printk(KERN_EVENT __FILE__ ": " format "\n" , ## arg)
E 4

/* error event message: e.g., i/o error */
D 4
extern int cifsERROR;
#define cERROR(button, prspec)\
{ if (button && cifsERROR) { printk prspec; if (button > 1) BUG(); } }
E 4
I 4
#define cifserror(format,arg...) if (cifsERROR) printk(KERN_ERR " CIFS VFS: " format "\n" "" , ## arg)

#define cERROR(button, prspec) if (button) cifserror prspec
E 4

/*
 *	debug OFF
 *	---------
 */
D 4
#else				/* _CIFS_DEBUG */
E 4
I 4
#else		/* _CIFS_DEBUG */
E 4
#define cERROR(button,prspec)
D 4
#define cEVENT(button,prspec)
E 4
I 4
#define cEVENT(format,arg...)
E 4
#define cFYI(button, prspec)
D 4
#endif				/* _CIFS_DEBUG */
E 4
I 4
#define cifserror(format,arg...)
#endif		/* _CIFS_DEBUG */
E 4

/*
 *	statistics
 *	----------
 */
#ifdef	_CIFS_STATISTICS
#define	INCREMENT(x)	((x)++)
#define	DECREMENT(x)	((x)--)
#define	HIGHWATERMARK(x,y)	x = MAX((x), (y))
#else
#define	INCREMENT(x)
#define	DECREMENT(x)
#define	HIGHWATERMARK(x,y)
#endif				/* _CIFS_STATISTICS */

#endif				/* _H_CIFS_DEBUG */
E 2
I 1
E 1
