H56433
s 00013/00008/00088
d D 1.2 03/07/31 20:06:47 stevef 3 2
c Clean up NTLM flags and add missing flags
cC
cHstevef95.austin.ibm.com
cK51636
cZ-07:00
e
s 00096/00000/00000
d D 1.1 02/10/10 14:16:14 stevef 2 1
cC
cF1
cK41667
cO-rw-rw-r--
e
s 00000/00000/00000
d D 1.0 02/10/10 14:16:14 stevef 1 0
c BitKeeper file /home/stevef/bk/linux-2.5-with-cifs/fs/cifs/ntlmssp.h
cBtorvalds@athlon.transmeta.com|ChangeSet|20020205173056|16047|c1d11a41ed024864
cHsmfhome1.austin.rr.com
cK34220
cPfs/cifs/ntlmssp.h
cR40244d6a3a0efda
cV4
cX0x821
cZ-05:00
e
u
U
f e 0
f x 0x821
t
T
I 2
/*
 *   fs/cifs/ntlmssp.h
 *
 *   Copyright (c) International Business Machines  Corp., 2002
 *   Author(s): Steve French (sfrench@us.ibm.com)
 *
 *   This library is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published
 *   by the Free Software Foundation; either version 2.1 of the License, or
 *   (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */

#pragma pack(1)

#define NTLMSSP_SIGNATURE "NTLMSSP"
/* Message Types */
#define NtLmNegotiate     1
#define NtLmChallenge     2
#define NtLmAuthenticate  3
#define UnknownMessage    8
I 3

E 3
/* Negotiate Flags */
#define NTLMSSP_NEGOTIATE_UNICODE       0x01	// Text strings are in unicode
#define NTLMSSP_NEGOTIATE_OEM           0x02	// Text strings are in OEM
#define NTLMSSP_REQUEST_TARGET          0x04	// Server return its auth realm
#define NTLMSSP_NEGOTIATE_SIGN        0x0010	// Request signature capability
#define NTLMSSP_NEGOTIATE_SEAL        0x0020	// Request confidentiality
D 3
#define NTLMSSP_NEGOTIATE_DGRAM       0x0040
E 3
I 3
#define NTLMSSP_NEGOTIATE_DGRAM       0x0040
E 3
#define NTLMSSP_NEGOTIATE_LM_KEY      0x0080	// Use LM session key for sign/seal
#define NTLMSSP_NEGOTIATE_NTLM        0x0200	// NTLM authentication
#define NTLMSSP_NEGOTIATE_DOMAIN_SUPPLIED 0x1000
#define NTLMSSP_NEGOTIATE_WORKSTATION_SUPPLIED 0x2000
#define NTLMSSP_NEGOTIATE_LOCAL_CALL  0x4000	// client/server on same machine
#define NTLMSSP_NEGOTIATE_ALWAYS_SIGN 0x8000	// Sign for all security levels
D 3
#define NTLMSSP_NEGOTIATE_NTLMV2      0x80000
E 3
I 3
#define NTLMSSP_TARGET_TYPE_DOMAIN   0x10000
#define NTLMSSP_TARGET_TYPE_SERVER   0x20000
#define NTLMSSP_TARGET_TYPE_SHARE    0x40000
#define NTLMSSP_NEGOTIATE_NTLMV2     0x80000
#define NTLMSSP_REQUEST_INIT_RESP   0x100000
#define NTLMSSP_REQUEST_ACCEPT_RESP 0x200000
#define NTLMSSP_REQUEST_NOT_NT_KEY  0x400000
E 3
#define NTLMSSP_NEGOTIATE_TARGET_INFO 0x800000
#define NTLMSSP_NEGOTIATE_128     0x20000000
#define NTLMSSP_NEGOTIATE_KEY_XCH 0x40000000
D 3
/* server only negotiate flags */
#define NTLMSSP_TARGET_TYPE_DOMAIN  0x10000	/* NEGOTIATE_DOMAIN 0x1000 ? */
#define NTLMSSP_TARGET_TYPE_SERVER  0x20000	/* NEGOTIATE_WORKSTATION 0x2000 ? */
E 3
I 3
#define NTLMSSP_NEGOTIATE_56      0x80000000
E 3

/* Although typedefs are not commonly used for structure definitions */
/* in the Linux kernel, in this particular case they are useful      */
/* to more closely match the standards document for NTLMSSP from     */
/* OpenGroup and to make the code more closely match the standard in */
/* appearance */

typedef struct _SECURITY_BUFFER {
	__u16 Length;
	__u16 MaximumLength;
	__u32 Buffer;		/* offset to buffer */
} SECURITY_BUFFER;

typedef struct _NEGOTIATE_MESSAGE {
	__u8 Signature[sizeof (NTLMSSP_SIGNATURE)];
D 3
	__u32 MessageType;
E 3
I 3
	__u32 MessageType;     /* 1 */
E 3
	__u32 NegotiateFlags;
	SECURITY_BUFFER DomainName;	/* RFC 1001 style and ASCII */
	SECURITY_BUFFER WorkstationName;	/* RFC 1001 and ASCII */
	char DomainString[0];
	/* followed by WorkstationString */
} NEGOTIATE_MESSAGE, *PNEGOTIATE_MESSAGE;

typedef struct _CHALLENGE_MESSAGE {
	__u8 Signature[sizeof (NTLMSSP_SIGNATURE)];
D 3
	__u32 MessageType;
E 3
I 3
	__u32 MessageType;   /* 2 */
E 3
	SECURITY_BUFFER TargetName;
	__u32 NegotiateFlags;
	__u8 Challenge[CIFS_CRYPTO_KEY_SIZE];
	__u8 Reserved[8];
	SECURITY_BUFFER TargetInfoArray;
} CHALLENGE_MESSAGE, *PCHALLENGE_MESSAGE;

typedef struct _AUTHENTICATE_MESSAGE {
	__u8 Signature[sizeof (NTLMSSP_SIGNATURE)];
D 3
	__u32 MessageType;
E 3
I 3
	__u32 MessageType;  /* 3 */
E 3
	SECURITY_BUFFER LmChallengeResponse;
	SECURITY_BUFFER NtChallengeResponse;
	SECURITY_BUFFER DomainName;
	SECURITY_BUFFER UserName;
	SECURITY_BUFFER WorkstationName;
	SECURITY_BUFFER SessionKey;
	__u32 NegotiateFlags;
	char UserString[0];
} AUTHENTICATE_MESSAGE, *PAUTHENTICATE_MESSAGE;

#pragma pack()			/* resume default structure packing */
E 2
I 1
E 1
