H37000
s 00002/00002/00896
d D 1.29 03/11/14 16:41:54 stevef 30 29
c correct retry on remaining handles based calls
cC
cK54684
e
s 00024/00007/00874
d D 1.28 03/11/11 17:51:24 stevef 29 28
c have to reconnect open files safely, one at a time, as needed
cC
cHstevef95.austin.ibm.com
cK52111
e
s 00068/00026/00813
d D 1.27 03/11/02 23:44:42 stevef 28 27
c To avoid spurious oplock breaks from server, in the case
c of inodes that we already have open, avoid doing path
c based setting of file size if we can do it by handle.
c This keeps our caching token (oplock) and avoids
c timeouts when the local oplock break takes longer to flush
c writebehind data than the SMB timeout for the SetPathInfo 
c request would allow
cC
cHlinux.local
cK05318
e
s 00001/00000/00838
d D 1.26 03/10/30 16:36:52 stevef 27 26
c Fix invalid dentry when race in mkdir between two clients
cC
cHstevef95.austin.ibm.com
cK06843
cZ-06:00
e
s 00002/00002/00836
d D 1.25 03/09/05 04:31:50 viro 26 25
c large dev_t - second series (7/15)
cC
cF22931
cHwww.linux.org.uk[torvalds]
cK05162
cZ-07:00
e
s 00016/00004/00822
d D 1.24 03/09/01 05:41:02 stevef 25 24
c Return error correctly on revalidate so dentry will be dropped.
cC
cHsteveft21.ltcsamba
cK07880
cZ-05:00
e
s 00003/00001/00823
d D 1.23 03/08/29 01:50:52 stevef 24 23
c Drop dentry on file that has been rename out from under us.
cC
cHsmfhome2.austin.rr.com
cK44328
cZ-07:00
e
s 00017/00003/00807
d D 1.22 03/08/15 06:18:47 stevef 23 22
c fix rename of open files 
cC
cK40429
e
s 00017/00002/00793
d D 1.21 03/08/14 01:49:54 stevef 22 21
c Add ability to rename open file
cC
cHsteveft21.austin.ibm.com
cK06977
cZ-05:00
e
s 00003/00006/00792
d D 1.20 03/08/06 12:45:33 stevef 21 20
c Fix blocksize and allocation size mismatch
cC
cK36541
e
s 00014/00006/00784
d D 1.19 03/08/04 00:17:34 stevef 20 19
c Fix blocksize and allocation size miscalculation
cC
cHlinux.local
cK44485
e
s 00012/00001/00778
d D 1.18 03/07/31 20:06:47 stevef 19 18
c Fix for file size handling for locally cached files.
cC
cK14974
e
s 00002/00001/00777
d D 1.17 03/07/29 17:32:32 stevef 18 17
c Fix oops in cifs mkdir when server fails to return inode info after successful mkdir
cC
cK51458
e
s 00037/00025/00741
d D 1.16 03/07/21 22:32:20 stevef 17 16
c cifs enablement for lookup intents (new 2.5 create/lookup flags) final part
cC
cK49423
e
s 00002/00001/00764
d D 1.15 03/07/10 20:09:12 stevef 16 15
c Add mknod support
cC
cK25817
e
s 00003/00003/00762
d D 1.14 03/06/26 17:47:04 stevef 15 14
c Fix compiler warning
cC
cK24075
e
s 00002/00002/00763
d D 1.13 03/06/10 17:29:01 stevef 14 13
c Fix most cifs vfs sign/unsigned gcc 3.3 compile warnings
cC
cHstevef95.austin.ibm.com
cK23364
cZ-07:00
e
s 00014/00008/00751
d D 1.12 03/06/09 09:31:17 stevef 13 12
c Fix mode, uid and gid when set with corresponding mount option
cC
cK24764
e
s 00000/00009/00759
d D 1.11 03/05/13 13:00:11 stevef 12 11
c cleanup dead code
cC
cHsteveft21.ltcsamba
cK15476
e
s 00046/00020/00722
d D 1.10 03/04/27 00:25:27 stevef 11 10
c Fix delete of files with readonly attribute. Update read only
c dos attribute based on mode on setattr.  Update mode on get attr
c based on read only dos attribute.
cC
cHsmfhome1.austin.rr.com
cK38063
e
s 00026/00001/00716
d D 1.9 03/04/23 07:03:10 stevef 10 9
c fix hang in truncate (setting file size)
cC
cHsteveft21.ltcsamba
cK35917
cZ-05:00
e
s 00012/00012/00705
d D 1.8 03/03/31 21:52:27 stevef 9 8
c Code cleanup and fix dead code
cC
cHsmfhome1.austin.rr.com
cK52346
e
s 00006/00009/00711
d D 1.7 03/02/23 16:23:54 stevef 8 7
c Refresh local inode on setting uid/gid or other attributes
cC
cK51971
e
s 00014/00009/00706
d D 1.6 03/02/19 17:31:55 stevef 7 6
c Fix caching of directory inodes (was always querying server on directory inodes)
cC
cHsteveft21.ltcsamba
cK65029
e
s 00039/00037/00676
d D 1.5 03/02/15 16:10:24 stevef 6 5
c Add more missing pieces of the oplock (distributed caching) support, fix readahead, add support for readpages
cC
cHsmfhome1.austin.rr.com
cK55652
e
s 00017/00002/00696
d D 1.4 02/11/21 16:58:07 stevef 5 4
c Properly emulate POSIX semantics for deleting of open files and renaming over open files
cC
cK55088
e
s 00050/00040/00648
d D 1.3 02/10/31 16:10:07 stevef 4 3
c Merge fixes from version 0.58 of cifs vfs
cC
cHsteveft21.ltcsamba
cK19916
cZ-06:00
e
s 00000/00003/00688
d D 1.2 02/10/12 01:53:13 stevef 3 2
c Correct compiler warnings for 64 bit platforms and minor formatting cleanup
cC
cK10470
e
s 00691/00000/00000
d D 1.1 02/10/10 14:16:12 stevef 2 1
cC
cF1
cK16823
cO-rw-rw-r--
e
s 00000/00000/00000
d D 1.0 02/10/10 14:16:12 stevef 1 0
c BitKeeper file /home/stevef/bk/linux-2.5-with-cifs/fs/cifs/inode.c
cBtorvalds@athlon.transmeta.com|ChangeSet|20020205173056|16047|c1d11a41ed024864
cHsmfhome1.austin.rr.com
cK14894
cPfs/cifs/inode.c
cR215c466932f89364
cV4
cX0x821
cZ-05:00
e
u
U
f e 0
f x 0x821
t
T
I 2
/*
 *   fs/cifs/inode.c
 *
D 24
 *   Copyright (c) International Business Machines  Corp., 2002
E 24
I 24
 *   Copyright (C) International Business Machines  Corp., 2002,2003
E 24
 *   Author(s): Steve French (sfrench@us.ibm.com)
 *
 *   This library is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published
 *   by the Free Software Foundation; either version 2.1 of the License, or
 *   (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
#include <linux/fs.h>
I 6
#include <linux/buffer_head.h>
E 6
#include <linux/stat.h>
I 10
#include <linux/pagemap.h>
E 10
#include <asm/div64.h>
#include "cifsfs.h"
#include "cifspdu.h"
#include "cifsglob.h"
#include "cifsproto.h"
#include "cifs_debug.h"
#include "cifs_fs_sb.h"

int
cifs_get_inode_info_unix(struct inode **pinode,
			 const unsigned char *search_path,
			 struct super_block *sb)
{
	int xid;
	int rc = 0;
	FILE_UNIX_BASIC_INFO findData;
	struct cifsTconInfo *pTcon;
	struct inode *inode;
	struct cifs_sb_info *cifs_sb = CIFS_SB(sb);
	char *tmp_path;

I 19
/* BB add caching check so we do not go to server to overwrite inode info to cached file
	where the local file sizes are correct and the server info is stale  BB */

E 19
	xid = GetXid();

	pTcon = cifs_sb->tcon;
D 6
	cFYI(1, ("\nGetting info on %s ", search_path));
E 6
I 6
	cFYI(1, (" Getting info on %s ", search_path));
E 6
	/* we could have done a find first instead but this returns more info */
	rc = CIFSSMBUnixQPathInfo(xid, pTcon, search_path, &findData,
				  cifs_sb->local_nls);
	/* dump_mem("\nUnixQPathInfo return data", &findData, sizeof(findData)); */
	if (rc) {
		if (rc == -EREMOTE) {
D 12
/* rc = *//* CIFSGetDFSRefer(xid, pTcon->ses, search_path,
D 4
   &referrals,
   &num_referrals,
   cifs_sb->local_nls); */
E 4
I 4
	&referrals,
	&num_referrals,
	cifs_sb->local_nls); */
E 12
E 4
			tmp_path =
			    kmalloc(strnlen
				    (pTcon->treeName,
				     MAX_TREE_SIZE + 1) +
				    strnlen(search_path, MAX_PATHCONF) + 1,
				    GFP_KERNEL);
			if (tmp_path == NULL) {
				FreeXid(xid);
				return -ENOMEM;
			}
        /* have to skip first of the double backslash of UNC name */
			strncpy(tmp_path, pTcon->treeName, MAX_TREE_SIZE);	
			strncat(tmp_path, search_path, MAX_PATHCONF);
			rc = connect_to_dfs_path(xid, pTcon->ses,
						 /* treename + */ tmp_path,
						 cifs_sb->local_nls);
			kfree(tmp_path);

			/* BB fix up inode etc. */
		} else if (rc) {
			FreeXid(xid);
			return rc;
		}

	} else {
		struct cifsInodeInfo *cifsInfo;

		/* get new inode */
		if (*pinode == NULL) {
			*pinode = new_inode(sb);
D 6
			cFYI(1, ("\nAlloc new inode %p ", *pinode));
E 6
I 6
D 8
			cFYI(1, (" Alloc new inode %p ", *pinode));
E 8
E 6
		}
		inode = *pinode;
D 8
/*        new_inode = iget(parent_dir_inode->i_sb, findData.IndexNumber); */
        /* index number not reliable in response data */
E 8

		cifsInfo = CIFS_I(inode);

D 6
		cFYI(1, ("\nOld time %ld ", cifsInfo->time));
E 6
I 6
		cFYI(1, (" Old time %ld ", cifsInfo->time));
E 6
		cifsInfo->time = jiffies;
		cFYI(1, (" New time %ld ", cifsInfo->time));
		atomic_inc(&cifsInfo->inUse);	/* inc on every refresh of inode */

		inode->i_atime =
D 4
		    le64_to_cpu(cifs_NTtimeToUnix(findData.LastAccessTime));
E 4
I 4
		    cifs_NTtimeToUnix(le64_to_cpu(findData.LastAccessTime));
E 4
		inode->i_mtime =
D 4
		    le64_to_cpu(cifs_NTtimeToUnix
E 4
I 4
		    cifs_NTtimeToUnix(le64_to_cpu
E 4
				(findData.LastModificationTime));
		inode->i_ctime =
D 4
		    le64_to_cpu(cifs_NTtimeToUnix(findData.LastStatusChange));
E 4
I 4
		    cifs_NTtimeToUnix(le64_to_cpu(findData.LastStatusChange));
E 4
		inode->i_mode = le64_to_cpu(findData.Permissions);
		findData.Type = le32_to_cpu(findData.Type);
		if (findData.Type == UNIX_FILE) {
			inode->i_mode |= S_IFREG;
		} else if (findData.Type == UNIX_SYMLINK) {
			inode->i_mode |= S_IFLNK;
		} else if (findData.Type == UNIX_DIR) {
			inode->i_mode |= S_IFDIR;
		} else if (findData.Type == UNIX_CHARDEV) {
			inode->i_mode |= S_IFCHR;
		} else if (findData.Type == UNIX_BLOCKDEV) {
			inode->i_mode |= S_IFBLK;
		} else if (findData.Type == UNIX_FIFO) {
			inode->i_mode |= S_IFIFO;
		} else if (findData.Type == UNIX_SOCKET) {
			inode->i_mode |= S_IFSOCK;
		}
		inode->i_uid = le64_to_cpu(findData.Uid);
		inode->i_gid = le64_to_cpu(findData.Gid);
		inode->i_nlink = le64_to_cpu(findData.Nlinks);
		findData.NumOfBytes = le64_to_cpu(findData.NumOfBytes);
		findData.EndOfFile = le64_to_cpu(findData.EndOfFile);
		inode->i_size = findData.EndOfFile;
D 20
		inode->i_blksize =
D 6
		    (pTcon->ses->maxBuf - MAX_CIFS_HDR_SIZE) & 0xFFFFFE00;
E 6
I 6
		    (pTcon->ses->server->maxBuf - MAX_CIFS_HDR_SIZE) & 0xFFFFFE00;
E 6
		inode->i_blocks = do_div(findData.NumOfBytes, inode->i_blksize);
E 20
I 20
/* blksize needs to be multiple of two. So safer to default to blksize
	and blkbits set in superblock so 2**blkbits and blksize will match */
/*		inode->i_blksize =
		    (pTcon->ses->server->maxBuf - MAX_CIFS_HDR_SIZE) & 0xFFFFFE00;*/
		inode->i_blocks = 
	                (inode->i_blksize - 1 + findData.NumOfBytes) >> inode->i_blkbits;

E 20
D 3
		cFYI(1,
		     ("\nFinddata alloc size (from smb) %lld",
		      findData.NumOfBytes));
E 3
		if (findData.NumOfBytes < findData.EndOfFile)
D 6
			cFYI(1, ("\nServer inconsistency Error: it says allocation size less than end of file "));
E 6
I 6
			cFYI(1, ("Server inconsistency Error: it says allocation size less than end of file "));
E 6
		cFYI(1,
D 6
		     ("\nCIFS FFIRST: Size %ld and blocks %ld ",
E 6
I 6
		     ("Size %ld and blocks %ld ",
E 6
		      (unsigned long) inode->i_size, inode->i_blocks));
		if (S_ISREG(inode->i_mode)) {
			cFYI(1, (" File inode "));
			inode->i_op = &cifs_file_inode_ops;
			inode->i_fop = &cifs_file_ops;
I 4
			inode->i_data.a_ops = &cifs_addr_ops;
E 4
		} else if (S_ISDIR(inode->i_mode)) {
			cFYI(1, (" Directory inode"));
			inode->i_op = &cifs_dir_inode_ops;
			inode->i_fop = &cifs_dir_ops;
		} else if (S_ISLNK(inode->i_mode)) {
			cFYI(1, (" Symbolic Link inode "));
			inode->i_op = &cifs_symlink_inode_ops;
/* tmp_inode->i_fop = *//* do not need to set to anything */
		} else {
D 6
			cFYI(1, ("\nInit special inode "));
E 6
I 6
			cFYI(1, (" Init special inode "));
E 6
			init_special_inode(inode, inode->i_mode,
D 26
					   kdev_t_to_nr(inode->i_rdev));
E 26
I 26
					   inode->i_rdev);
E 26
		}
	}
	FreeXid(xid);
	return rc;
}

int
D 17
cifs_get_inode_info(struct inode **pinode,
		    const unsigned char *search_path, struct super_block *sb)
E 17
I 17
cifs_get_inode_info(struct inode **pinode, const unsigned char *search_path, 
		FILE_ALL_INFO * pfindData, struct super_block *sb)
E 17
{
	int xid;
	int rc = 0;
D 17
	FILE_ALL_INFO findData;
E 17
	struct cifsTconInfo *pTcon;
	struct inode *inode;
	struct cifs_sb_info *cifs_sb = CIFS_SB(sb);
	char *tmp_path;
I 17
	char *buf = NULL;
E 17

	xid = GetXid();

	pTcon = cifs_sb->tcon;
D 6
	cFYI(1, ("\nGetting info on %s ", search_path));
E 6
I 6
D 19
	cFYI(1, (" Getting info on %s ", search_path));
E 19
I 19
	cFYI(1,("Getting info on %s ", search_path));

	if((pfindData == NULL) && (*pinode != NULL)) {
		if(CIFS_I(*pinode)->clientCanCacheRead) {
			cFYI(1,("No need to revalidate inode sizes on cached file "));
			FreeXid(xid);
			return rc;
		}
	}
E 19
E 6
D 17
	/* we could have done a find first instead but this returns more info */
	rc = CIFSSMBQPathInfo(xid, pTcon, search_path, &findData,
E 17
I 17

	/* if file info not passed in then get it from server */
	if(pfindData == NULL) {
		buf = kmalloc(sizeof(FILE_ALL_INFO),GFP_KERNEL);
		pfindData = (FILE_ALL_INFO *)buf;
	/* could do find first instead but this returns more info */
		rc = CIFSSMBQPathInfo(xid, pTcon, search_path, pfindData,
E 17
			      cifs_sb->local_nls);
I 17
	}
E 17
	/* dump_mem("\nQPathInfo return data",&findData, sizeof(findData)); */
	if (rc) {
		if (rc == -EREMOTE) {
D 12
			/* BB add call to new func rc = GetDFSReferral(); */
/* rc = *//* CIFSGetDFSRefer(xid, pTcon->ses, search_path,
D 4
   &referrals,
   &num_referrals,
   cifs_sb->local_nls); */
E 4
I 4
	&referrals,
	&num_referrals,
	cifs_sb->local_nls); */
E 12
E 4
			tmp_path =
			    kmalloc(strnlen
				    (pTcon->treeName,
				     MAX_TREE_SIZE + 1) +
				    strnlen(search_path, MAX_PATHCONF) + 1,
				    GFP_KERNEL);
			if (tmp_path == NULL) {
D 17
				FreeXid(xid);
				return -ENOMEM;
E 17
I 17
			    if(buf)
				kfree(buf);
			    FreeXid(xid);
			    return -ENOMEM;
E 17
			}

			strncpy(tmp_path, pTcon->treeName, MAX_TREE_SIZE);
			strncat(tmp_path, search_path, MAX_PATHCONF);
			rc = connect_to_dfs_path(xid, pTcon->ses,
						 /* treename + */ tmp_path,
						 cifs_sb->local_nls);
			kfree(tmp_path);
			/* BB fix up inode etc. */
		} else if (rc) {
D 17
			FreeXid(xid);
			return rc;
E 17
I 17
		    if(buf)
			kfree(buf);
		    FreeXid(xid);
		    return rc;
E 17
		}
	} else {
		struct cifsInodeInfo *cifsInfo;

		/* get new inode */
		if (*pinode == NULL) {
			*pinode = new_inode(sb);
D 6
			cFYI(1, ("\nAlloc new inode %p ", *pinode));
E 6
I 6
D 8
			cFYI(1, (" Alloc new inode %p ", *pinode));
E 8
E 6
		}

		inode = *pinode;
		cifsInfo = CIFS_I(inode);
D 17
		findData.Attributes = le32_to_cpu(findData.Attributes);
		cifsInfo->cifsAttrs = findData.Attributes;
E 17
I 17
		pfindData->Attributes = le32_to_cpu(pfindData->Attributes);
		cifsInfo->cifsAttrs = pfindData->Attributes;
E 17
D 6
		cFYI(1, ("\nOld time %ld ", cifsInfo->time));
E 6
I 6
		cFYI(1, (" Old time %ld ", cifsInfo->time));
E 6
		cifsInfo->time = jiffies;
		cFYI(1, (" New time %ld ", cifsInfo->time));
		atomic_inc(&cifsInfo->inUse);	/* inc on every refresh of inode */

D 20
		inode->i_blksize =
D 6
		    (pTcon->ses->maxBuf - MAX_CIFS_HDR_SIZE) & 0xFFFFFE00;
E 6
I 6
		    (pTcon->ses->server->maxBuf - MAX_CIFS_HDR_SIZE) & 0xFFFFFE00;
E 20
I 20
/* blksize needs to be multiple of two. So safer to default to blksize
        and blkbits set in superblock so 2**blkbits and blksize will match */
/*		inode->i_blksize =
		    (pTcon->ses->server->maxBuf - MAX_CIFS_HDR_SIZE) & 0xFFFFFE00;*/

E 20
E 6
		/* Linux can not store file creation time unfortunately so we ignore it */
		inode->i_atime =
D 17
		    cifs_NTtimeToUnix(le64_to_cpu(findData.LastAccessTime));
E 17
I 17
		    cifs_NTtimeToUnix(le64_to_cpu(pfindData->LastAccessTime));
E 17
		inode->i_mtime =
D 17
		    cifs_NTtimeToUnix(le64_to_cpu(findData.LastWriteTime));
E 17
I 17
		    cifs_NTtimeToUnix(le64_to_cpu(pfindData->LastWriteTime));
E 17
		inode->i_ctime =
D 17
		    cifs_NTtimeToUnix(le64_to_cpu(findData.ChangeTime));
E 17
I 17
		    cifs_NTtimeToUnix(le64_to_cpu(pfindData->ChangeTime));
E 17
D 11
/* inode->i_mode = S_IRWXUGO;  *//* 777 perms */
		/* should we treat the dos attribute of read-only as read-only mode bit e.g. 555 */
E 11
D 13
		inode->i_mode = S_IALLUGO & ~(S_ISUID | S_IXGRP);	/* 2767 perms indicate mandatory locking - will override for dirs later */
E 13
		cFYI(0,
D 6
		     ("\nAttributes came in as 0x%x\n", findData.Attributes));
E 6
I 6
D 17
		     (" Attributes came in as 0x%x ", findData.Attributes));
E 17
I 17
		     (" Attributes came in as 0x%x ", pfindData->Attributes));
E 17
E 6
D 13
		if (findData.Attributes & ATTR_REPARSE) {	
   /* Can IFLNK be set as it basically is on windows with IFREG or IFDIR? */
E 13
I 13

		/* set default mode. will override for dirs below */
		inode->i_mode = cifs_sb->mnt_file_mode;

D 17
		if (findData.Attributes & ATTR_REPARSE) {
E 17
I 17
		if (pfindData->Attributes & ATTR_REPARSE) {
E 17
	/* Can IFLNK be set as it basically is on windows with IFREG or IFDIR? */
E 13
			inode->i_mode |= S_IFLNK;
D 17
		} else if (findData.Attributes & ATTR_DIRECTORY) {
E 17
I 17
		} else if (pfindData->Attributes & ATTR_DIRECTORY) {
E 17
D 13
   /* override default perms since we do not do byte range locking on dirs */
			inode->i_mode = S_IRWXUGO;	
            inode->i_mode |= S_IFDIR;
E 13
I 13
	/* override default perms since we do not do byte range locking on dirs */
			inode->i_mode = cifs_sb->mnt_dir_mode;
			inode->i_mode |= S_IFDIR;
E 13
		} else {
			inode->i_mode |= S_IFREG;
I 11
			/* treat the dos attribute of read-only as read-only mode e.g. 555 */
			if(cifsInfo->cifsAttrs & ATTR_READONLY)
				inode->i_mode &= ~(S_IWUGO);
E 11
   /* BB add code here - validate if device or weird share or device type? */
		}
D 17
		inode->i_size = le64_to_cpu(findData.EndOfFile);
		findData.AllocationSize = le64_to_cpu(findData.AllocationSize);
E 17
I 17
		inode->i_size = le64_to_cpu(pfindData->EndOfFile);
		pfindData->AllocationSize = le64_to_cpu(pfindData->AllocationSize);
E 17
		inode->i_blocks =
D 17
		    do_div(findData.AllocationSize, inode->i_blksize);
E 17
I 17
D 20
		    do_div(pfindData->AllocationSize, inode->i_blksize);
E 20
I 20
	                (inode->i_blksize - 1 + pfindData->AllocationSize) >> inode->i_blkbits;

E 20
E 17
D 21
		cFYI(1,
D 6
		     ("\n Size %ld and blocks %ld ",
E 6
I 6
		     (" Size %ld and blocks %ld ",
E 6
		      (unsigned long) inode->i_size, inode->i_blocks));
E 21
D 17
		inode->i_nlink = le32_to_cpu(findData.NumberOfLinks);
E 17
I 17
		inode->i_nlink = le32_to_cpu(pfindData->NumberOfLinks);
E 17

D 13
		/* BB fill in uid and gid here? with help from winbind? */

E 13
I 13
		/* BB fill in uid and gid here? with help from winbind? 
			or retrieve from NTFS stream extended attribute */
		inode->i_uid = cifs_sb->mnt_uid;
		inode->i_gid = cifs_sb->mnt_gid;
		
E 13
		if (S_ISREG(inode->i_mode)) {
			cFYI(1, (" File inode "));
			inode->i_op = &cifs_file_inode_ops;
			inode->i_fop = &cifs_file_ops;
I 4
			inode->i_data.a_ops = &cifs_addr_ops;
E 4
		} else if (S_ISDIR(inode->i_mode)) {
			cFYI(1, (" Directory inode "));
			inode->i_op = &cifs_dir_inode_ops;
			inode->i_fop = &cifs_dir_ops;
		} else if (S_ISLNK(inode->i_mode)) {
			cFYI(1, (" Symbolic Link inode "));
			inode->i_op = &cifs_symlink_inode_ops;
		} else {
			init_special_inode(inode, inode->i_mode,
D 26
					   kdev_t_to_nr(inode->i_rdev));
E 26
I 26
					   inode->i_rdev);
E 26
		}
	}
I 17
	if(buf)
	    kfree(buf);
E 17
	FreeXid(xid);
	return rc;
}

void
cifs_read_inode(struct inode *inode)
{				/* gets root inode */

	struct cifs_sb_info *cifs_sb;

	cifs_sb = CIFS_SB(inode->i_sb);

	if (cifs_sb->tcon->ses->capabilities & CAP_UNIX)
		cifs_get_inode_info_unix(&inode, "", inode->i_sb);
	else
D 17
		cifs_get_inode_info(&inode, "", inode->i_sb);
E 17
I 17
		cifs_get_inode_info(&inode, "", NULL, inode->i_sb);
E 17
}

int
cifs_unlink(struct inode *inode, struct dentry *direntry)
{
	int rc = 0;
	int xid;
	struct cifs_sb_info *cifs_sb;
	struct cifsTconInfo *pTcon;
	char *full_path = NULL;
	struct cifsInodeInfo *cifsInode;
I 11
	FILE_BASIC_INFO * pinfo_buf;
E 11

D 6
	cFYI(1, ("\n cifs_unlink, inode = 0x%p with ", inode));
E 6
I 6
	cFYI(1, (" cifs_unlink, inode = 0x%p with ", inode));
E 6

	xid = GetXid();

	cifs_sb = CIFS_SB(inode->i_sb);
	pTcon = cifs_sb->tcon;

D 5
	/* BB Should we close the file if it is already open from our client? */

E 5
	full_path = build_path_from_dentry(direntry);

	rc = CIFSSMBDelFile(xid, pTcon, full_path, cifs_sb->local_nls);

	if (!rc) {
		direntry->d_inode->i_nlink--;
I 24
	} else if (rc == -ENOENT) {
		d_drop(direntry);
E 24
I 5
	} else if (rc == -ETXTBSY) {
		int oplock = FALSE;
		__u16 netfid;

		rc = CIFSSMBOpen(xid, pTcon, full_path, FILE_OPEN, DELETE, 
				CREATE_NOT_DIR | CREATE_DELETE_ON_CLOSE,
D 17
				&netfid, &oplock, cifs_sb->local_nls);
E 17
I 17
				&netfid, &oplock, NULL, cifs_sb->local_nls);
E 17
		if(rc==0) {
I 22
D 23
			CIFSSMBDummyRenameOpenFile(xid,pTcon,netfid,
				cifs_sb->local_nls);
E 23
I 23
			CIFSSMBRenameOpenFile(xid,pTcon,netfid,
				NULL, cifs_sb->local_nls);
E 23
E 22
			CIFSSMBClose(xid, pTcon, netfid);
D 22
			/* BB In the future chain close with the NTCreateX to narrow window */
E 22
			direntry->d_inode->i_nlink--;
		}
I 11
	} else if (rc == -EACCES) {
		/* try only if r/o attribute set in local lookup data? */
		pinfo_buf = (FILE_BASIC_INFO *)kmalloc(sizeof(FILE_BASIC_INFO),GFP_KERNEL);
		if(pinfo_buf) {
			memset(pinfo_buf,0,sizeof(FILE_BASIC_INFO));        
		/* ATTRS set to normal clears r/o bit */
			pinfo_buf->Attributes = cpu_to_le32(ATTR_NORMAL);
			rc = CIFSSMBSetTimes(xid, pTcon, full_path, pinfo_buf,
				cifs_sb->local_nls);
			kfree(pinfo_buf);
		}
		if(rc==0) {
			rc = CIFSSMBDelFile(xid, pTcon, full_path, cifs_sb->local_nls);
D 22
			if (!rc)
E 22
I 22
			if (!rc) {
E 22
				direntry->d_inode->i_nlink--;
I 22
			} else if (rc == -ETXTBSY) {
				int oplock = FALSE;
				__u16 netfid;

				rc = CIFSSMBOpen(xid, pTcon, full_path, FILE_OPEN, DELETE,
                                	CREATE_NOT_DIR | CREATE_DELETE_ON_CLOSE,
	                                &netfid, &oplock, NULL, cifs_sb->local_nls);
				if(rc==0) {
D 23
					CIFSSMBDummyRenameOpenFile(xid,pTcon,netfid,cifs_sb->local_nls);
E 23
I 23
					CIFSSMBRenameOpenFile(xid,pTcon,netfid,NULL,cifs_sb->local_nls);
E 23
					CIFSSMBClose(xid, pTcon, netfid);
		                        direntry->d_inode->i_nlink--;
				}
			/* BB if rc = -ETXTBUSY goto the rename logic BB */
			}
E 22
		}
E 11
E 5
	}
	cifsInode = CIFS_I(direntry->d_inode);
	cifsInode->time = 0;	/* will force revalidate to get info when needed */
	direntry->d_inode->i_ctime = inode->i_ctime = inode->i_mtime =
	    CURRENT_TIME;
	cifsInode = CIFS_I(inode);
	cifsInode->time = 0;	/* force revalidate of dir as well */

	if (full_path)
		kfree(full_path);
	FreeXid(xid);
	return rc;
}

int
cifs_mkdir(struct inode *inode, struct dentry *direntry, int mode)
{
	int rc = 0;
	int xid;
	struct cifs_sb_info *cifs_sb;
	struct cifsTconInfo *pTcon;
	char *full_path = NULL;
	struct inode *newinode = NULL;

D 6
	cFYI(1, ("In cifs_mkdir, mode = 0x%x inode = 0x%p\n", mode, inode));
E 6
I 6
	cFYI(1, ("In cifs_mkdir, mode = 0x%x inode = 0x%p ", mode, inode));
E 6

	xid = GetXid();

	cifs_sb = CIFS_SB(inode->i_sb);
	pTcon = cifs_sb->tcon;

	full_path = build_path_from_dentry(direntry);
	/* BB add setting the equivalent of mode via CreateX w/ACLs */
	rc = CIFSSMBMkDir(xid, pTcon, full_path, cifs_sb->local_nls);
	if (rc) {
D 6
		cFYI(1, ("\ncifs_mkdir returned 0x%x ", rc));
E 6
I 6
		cFYI(1, ("cifs_mkdir returned 0x%x ", rc));
I 27
		d_drop(direntry);
E 27
E 6
	} else {
		inode->i_nlink++;
		if (pTcon->ses->capabilities & CAP_UNIX)
			rc = cifs_get_inode_info_unix(&newinode, full_path,
						      inode->i_sb);
		else
D 17
			rc = cifs_get_inode_info(&newinode, full_path,
E 17
I 17
			rc = cifs_get_inode_info(&newinode, full_path,NULL,
E 17
						 inode->i_sb);

		direntry->d_op = &cifs_dentry_ops;
		d_instantiate(direntry, newinode);
D 18
		direntry->d_inode->i_nlink = 2;
E 18
I 18
		if(direntry->d_inode)
			direntry->d_inode->i_nlink = 2;
E 18
D 11
        if (cifs_sb->tcon->ses->capabilities & CAP_UNIX)                
            CIFSSMBUnixSetPerms(xid, pTcon, full_path, mode,
                        0xFFFFFFFFFFFFFFFF,  
                        0xFFFFFFFFFFFFFFFF,
                        cifs_sb->local_nls);
        else { /* BB to be implemented via Windows secrty descriptors*/
        /* eg CIFSSMBWinSetPerms(xid,pTcon,full_path,mode,-1,-1,local_nls);*/
        }

E 11
I 11
		if (cifs_sb->tcon->ses->capabilities & CAP_UNIX)                
			CIFSSMBUnixSetPerms(xid, pTcon, full_path, mode,
D 14
				0xFFFFFFFFFFFFFFFF,  
				0xFFFFFFFFFFFFFFFF,
E 14
I 14
				(__u64)-1,  
				(__u64)-1,
I 16
				0 /* dev_t */,
E 16
E 14
				cifs_sb->local_nls);
		else { /* BB to be implemented via Windows secrty descriptors*/
		/* eg CIFSSMBWinSetPerms(xid,pTcon,full_path,mode,-1,-1,local_nls);*/
		}
E 11
	}
	if (full_path)
		kfree(full_path);
	FreeXid(xid);

	return rc;
}

int
cifs_rmdir(struct inode *inode, struct dentry *direntry)
{
	int rc = 0;
	int xid;
	struct cifs_sb_info *cifs_sb;
	struct cifsTconInfo *pTcon;
	char *full_path = NULL;
	struct cifsInodeInfo *cifsInode;

D 6
	cFYI(1, ("\nn cifs_rmdir, inode = 0x%p with ", inode));
E 6
I 6
	cFYI(1, (" cifs_rmdir, inode = 0x%p with ", inode));
E 6

	xid = GetXid();

	cifs_sb = CIFS_SB(inode->i_sb);
	pTcon = cifs_sb->tcon;

	full_path = build_path_from_dentry(direntry);

	rc = CIFSSMBRmDir(xid, pTcon, full_path, cifs_sb->local_nls);

	if (!rc) {
		inode->i_nlink--;
		direntry->d_inode->i_size = 0;
		direntry->d_inode->i_nlink = 0;
	}

	cifsInode = CIFS_I(direntry->d_inode);
	cifsInode->time = 0;	/* force revalidate to go get info when needed */
	direntry->d_inode->i_ctime = inode->i_ctime = inode->i_mtime =
	    CURRENT_TIME;

	if (full_path)
		kfree(full_path);
	FreeXid(xid);
	return rc;
}

int
cifs_rename(struct inode *source_inode, struct dentry *source_direntry,
	    struct inode *target_inode, struct dentry *target_direntry)
{
	char *fromName;
	char *toName;
	struct cifs_sb_info *cifs_sb_source;
	struct cifs_sb_info *cifs_sb_target;
	struct cifsTconInfo *pTcon;
	int xid;
	int rc = 0;

	xid = GetXid();

	cifs_sb_target = CIFS_SB(target_inode->i_sb);
	cifs_sb_source = CIFS_SB(source_inode->i_sb);
	pTcon = cifs_sb_source->tcon;

D 4
	if (pTcon != cifs_sb_target->tcon)
E 4
I 4
D 9
	if (pTcon != cifs_sb_target->tcon) {    
E 9
I 9
	if (pTcon != cifs_sb_target->tcon) {
		FreeXid(xid);    
E 9
E 4
		return -EXDEV;	/* BB actually could be allowed if same server, but
                     different share. Might eventually add support for this */
I 4
D 8
        FreeXid(xid);
    }
E 8
I 8
D 9
        	FreeXid(xid);
E 9
	}
E 8
E 4

	fromName = build_path_from_dentry(source_direntry);
	toName = build_path_from_dentry(target_direntry);

	rc = CIFSSMBRename(xid, pTcon, fromName, toName,
			   cifs_sb_source->local_nls);
I 5
	if(rc == -EEXIST) {
		cifs_unlink(target_inode, target_direntry);
		rc = CIFSSMBRename(xid, pTcon, fromName, toName,
				   cifs_sb_source->local_nls);
I 23
	}

	if((rc == -EIO)||(rc == -EEXIST)) {
                int oplock = FALSE;
                __u16 netfid;

                rc = CIFSSMBOpen(xid, pTcon, fromName, FILE_OPEN, GENERIC_READ,
                                CREATE_NOT_DIR,
                                &netfid, &oplock, NULL, cifs_sb_source->local_nls);
                if(rc==0) {
                        CIFSSMBRenameOpenFile(xid,pTcon,netfid,
                                toName, cifs_sb_source->local_nls);
                        CIFSSMBClose(xid, pTcon, netfid);
                }
E 23
	}
E 5
	if (fromName)
		kfree(fromName);
	if (toName)
		kfree(toName);

I 4
D 9
    FreeXid(xid);
E 9
I 9
	FreeXid(xid);
E 9
E 4
	return rc;
}

int
cifs_revalidate(struct dentry *direntry)
{
	int xid;
	int rc = 0;
	char *full_path;
	struct cifs_sb_info *cifs_sb;
	struct cifsInodeInfo *cifsInode;

	xid = GetXid();

	cifs_sb = CIFS_SB(direntry->d_sb);

	full_path = build_path_from_dentry(direntry);
	cFYI(1,
D 6
	     (" full path: %s for inode 0x%p with count %d dentry: 0x%p d_time %ld at time %ld \n",
E 6
I 6
D 7
	     (" full path: %s for inode 0x%p with count %d dentry: 0x%p d_time %ld at time %ld ",
E 7
I 7
	     ("Revalidate full path: %s for inode 0x%p with count %d dentry: 0x%p d_time %ld at time %ld ",
E 7
E 6
	      full_path, direntry->d_inode,
	      direntry->d_inode->i_count.counter, direntry,
	      direntry->d_time, jiffies));

I 21

E 21
	cifsInode = CIFS_I(direntry->d_inode);
D 4

E 4
I 4
D 7
/* BB add check - do not need to revalidate oplocked files */
E 4
	if ((time_before(jiffies, cifsInode->time + HZ))
	    && (direntry->d_inode->i_nlink == 1)) {
		cFYI(1, (" Do not need to revalidate "));
		if (full_path)
			kfree(full_path);
		FreeXid(xid);
		return rc;
E 7
I 7
	/* BB add check - do not need to revalidate oplocked files */

D 21
	if (time_before(jiffies, cifsInode->time + HZ)) {
E 21
I 21
	if (time_before(jiffies, cifsInode->time + HZ) && lookupCacheEnabled) {
E 21
	    if((S_ISREG(direntry->d_inode->i_mode) == 0) || 
D 8
           (direntry->d_inode->i_nlink == 1)) {
E 8
I 8
D 9
              (direntry->d_inode->i_nlink == 1)) {
E 8
		    if (full_path)
			    kfree(full_path);
		    FreeXid(xid);
		    return rc;
        } else {
            cFYI(1,("Have to revalidate file due to hardlinks"));
        }
            
E 9
I 9
D 21
			(direntry->d_inode->i_nlink == 1) || 
			(lookupCacheEnabled == 0)) {
E 21
I 21
			(direntry->d_inode->i_nlink == 1)) {  
E 21
			if (full_path)
				kfree(full_path);
			FreeXid(xid);
			return rc;
		} else {
			cFYI(1,("Have to revalidate file due to hardlinks"));
		}            
E 9
E 7
	}

D 25
	if (cifs_sb->tcon->ses->capabilities & CAP_UNIX)
		cifs_get_inode_info_unix(&direntry->d_inode, full_path,
E 25
I 25
	if (cifs_sb->tcon->ses->capabilities & CAP_UNIX) {
		rc = cifs_get_inode_info_unix(&direntry->d_inode, full_path,
E 25
					 direntry->d_sb);
D 25
	else
D 17
		cifs_get_inode_info(&direntry->d_inode, full_path,
E 17
I 17
		cifs_get_inode_info(&direntry->d_inode, full_path, NULL,
E 25
I 25
		if(rc) {
			cFYI(1,("error on getting revalidate info %d",rc));
/*			if(rc != -ENOENT)
				rc = 0; */ /* BB should we cache info on certain errors? */
		}
	} else {
		rc = cifs_get_inode_info(&direntry->d_inode, full_path, NULL,
E 25
E 17
				    direntry->d_sb);
I 25
		if(rc) {
			cFYI(1,("error on getting revalidate info %d",rc));
/*			if(rc != -ENOENT)
				rc = 0; */  /* BB should we cache info on certain errors? */
		}
	}
	/* should we remap certain errors, access denied?, to zero */
E 25

	/* BB if not oplocked, invalidate inode pages if mtime has changed */

	if (full_path)
		kfree(full_path);
	FreeXid(xid);

	return rc;
}

I 4
int cifs_getattr(struct vfsmount *mnt, struct dentry *dentry, struct kstat *stat)
{
	int err = cifs_revalidate(dentry);
	if (!err)
		generic_fillattr(dentry->d_inode, stat);
	return err;
}

E 4
void
cifs_truncate_file(struct inode *inode)
{				/* BB remove - may not need this function after all BB */
	int xid;
D 28
	int rc = 0;
E 28
I 28
	int rc = -EIO;
	int found = FALSE;
E 28
D 4
    struct cifsFileInfo *open_file = NULL;
E 4
I 4
	struct cifsFileInfo *open_file = NULL;
E 4
	struct cifs_sb_info *cifs_sb;
	struct cifsTconInfo *pTcon;
	struct cifsInodeInfo *cifsInode;
	struct dentry *dirent;
I 28
	struct list_head * tmp;
E 28
	char *full_path = NULL;   

	xid = GetXid();

	cifs_sb = CIFS_SB(inode->i_sb);
	pTcon = cifs_sb->tcon;

I 28
	/* To avoid spurious oplock breaks from server, in the case
		of inodes that we already have open, avoid doing path
		based setting of file size if we can do it by handle.
		This keeps our caching token (oplock) and avoids
		timeouts when the local oplock break takes longer to flush
		writebehind data than the SMB timeout for the SetPathInfo 
		request would allow */
	read_lock(&GlobalSMBSeslock); 
	cifsInode = CIFS_I(inode);
	list_for_each(tmp, &cifsInode->openFileList) {            
		open_file = list_entry(tmp,struct cifsFileInfo, flist);
		/* We check if file is open for writing first */
D 30
		if((open_file->pfile) && 
E 30
I 30
		if((open_file->pfile) && (!open_file->invalidHandle) &&
E 30
		   ((open_file->pfile->f_flags & O_RDWR) || 
			(open_file->pfile->f_flags & O_WRONLY))) {
			read_unlock(&GlobalSMBSeslock);
			found = TRUE;
			rc = CIFSSMBSetFileSize(xid, pTcon, inode->i_size,
			   open_file->netfid,open_file->pid,FALSE);
			if(rc == 0) {
				FreeXid(xid);
				return;
D 29
			}
E 29
I 29
			} 
			/* Do not need reopen and retry on EAGAIN since we will
				retry by pathname below */
			if(rc == -EAGAIN)
				rc = -EHOSTDOWN;

E 29
			break;  /* now that we found one valid file handle no
				sense continuing to loop trying others */
		}
	}
	if(found == FALSE)
		read_unlock(&GlobalSMBSeslock);

E 28
	if (list_empty(&inode->i_dentry)) {
		cERROR(1,
		       ("Can not get pathname from empty dentry in inode 0x%p ",
			inode));
		FreeXid(xid);
		return;
	}
I 28

E 28
	dirent = list_entry(inode->i_dentry.next, struct dentry, d_alias);
	if (dirent) {
		full_path = build_path_from_dentry(dirent);
		rc = CIFSSMBSetEOF(xid, pTcon, full_path, inode->i_size,FALSE,
				   cifs_sb->local_nls);
D 4
        cFYI(1,("\nSetEOF (truncate) rc = %d",rc));
        if(rc == -ETXTBSY) {        
            cifsInode = CIFS_I(inode);
            if(!list_empty(&(cifsInode->openFileList))) {            
	            open_file = list_entry(cifsInode->openFileList.next,
                                       struct cifsFileInfo, flist);           
                /* We could check if file is open for writing first and 
                   also we could also override the smb pid with the pid 
                   of the file opener when sending the CIFS request */
                rc = CIFSSMBSetFileSize(xid, pTcon, inode->i_size,
                                        open_file->netfid,open_file->pid,FALSE);
            } else {
                cFYI(1,("\nNo open files to get file handle from"));
            }
        }
E 4
I 4
D 6
		cFYI(1,("\nSetEOF (truncate) rc = %d",rc));
E 6
I 6
		cFYI(1,(" SetEOF (truncate) rc = %d",rc));
E 6
D 28
		if(rc == -ETXTBSY) {        
			cifsInode = CIFS_I(inode);
			if(!list_empty(&(cifsInode->openFileList))) {            
				open_file = list_entry(cifsInode->openFileList.next,
					struct cifsFileInfo, flist);           
            /* We could check if file is open for writing first */
				 rc = CIFSSMBSetFileSize(xid, pTcon, inode->i_size,
					open_file->netfid,open_file->pid,FALSE);
			} else {
D 6
				  cFYI(1,("\nNo open files to get file handle from"));
E 6
I 6
				  cFYI(1,(" No open files to get file handle from"));
E 6
			}
		}
E 28
E 4
		if (!rc)
			CIFSSMBSetEOF(xid,pTcon,full_path,inode->i_size,TRUE,cifs_sb->local_nls);
           /* allocation size setting seems optional so ignore return code */
	}
	if (full_path)
		kfree(full_path);
	FreeXid(xid);
	return;
}

I 10
static int cifs_trunc_page(struct address_space *mapping, loff_t from)
{
        pgoff_t index = from >> PAGE_CACHE_SHIFT;
        unsigned offset = from & (PAGE_CACHE_SIZE-1);
        struct page *page;
        char *kaddr;
        int rc = 0;

        page = grab_cache_page(mapping, index);
        if (!page)
                return -ENOMEM;

D 11

E 11
        kaddr = kmap_atomic(page, KM_USER0);
        memset(kaddr + offset, 0, PAGE_CACHE_SIZE - offset);
        flush_dcache_page(page);
        kunmap_atomic(kaddr, KM_USER0);
        set_page_dirty(page);
        unlock_page(page);
        page_cache_release(page);
        return rc;
}

E 10
int
cifs_setattr(struct dentry *direntry, struct iattr *attrs)
{
	int xid;
	struct cifs_sb_info *cifs_sb;
	struct cifsTconInfo *pTcon;
	char *full_path = NULL;
	int rc = -EACCES;
I 28
	int found = FALSE;
E 28
D 4
    struct cifsFileInfo *open_file = NULL;
E 4
I 4
	struct cifsFileInfo *open_file = NULL;
E 4
	FILE_BASIC_INFO time_buf;
	int set_time = FALSE;
D 15
	__u64 mode = 0xFFFFFFFFFFFFFFFF;
	__u64 uid = 0xFFFFFFFFFFFFFFFF;
	__u64 gid = 0xFFFFFFFFFFFFFFFF;
E 15
I 15
	__u64 mode = 0xFFFFFFFFFFFFFFFFULL;
	__u64 uid = 0xFFFFFFFFFFFFFFFFULL;
	__u64 gid = 0xFFFFFFFFFFFFFFFFULL;
E 15
	struct cifsInodeInfo *cifsInode;
I 28
	struct list_head * tmp;
E 28

	xid = GetXid();

	cFYI(1,
D 6
	     ("\nIn cifs_setattr, name = %s attrs->iavalid 0x%x\n",
E 6
I 6
	     (" In cifs_setattr, name = %s attrs->iavalid 0x%x ",
E 6
	      direntry->d_name.name, attrs->ia_valid));
	cifs_sb = CIFS_SB(direntry->d_inode->i_sb);
	pTcon = cifs_sb->tcon;

	full_path = build_path_from_dentry(direntry);
	cifsInode = CIFS_I(direntry->d_inode);

	/* BB check if we need to refresh inode from server now ? BB */

D 6
	cFYI(1, ("\nChanging attributes 0x%x", attrs->ia_valid));
E 6
I 6
	cFYI(1, (" Changing attributes 0x%x", attrs->ia_valid));
E 6

	if (attrs->ia_valid & ATTR_SIZE) {
D 28
		rc = CIFSSMBSetEOF(xid, pTcon, full_path, attrs->ia_size,FALSE,
				   cifs_sb->local_nls);
D 4
        cFYI(1,("\nSetEOF (setattrs) rc = %d",rc));
E 4
I 4
D 6
		cFYI(1,("\nSetEOF (setattrs) rc = %d",rc));
E 6
I 6
		cFYI(1,(" SetEOF (setattrs) rc = %d",rc));
E 6
E 4

D 4
        if(rc == -ETXTBSY) {
            if(!list_empty(&(cifsInode->openFileList))) {            
                open_file = list_entry(cifsInode->openFileList.next, 
                               struct cifsFileInfo, flist);           
E 4
I 4
		if(rc == -ETXTBSY) {
			if(!list_empty(&(cifsInode->openFileList))) {            
				open_file = list_entry(cifsInode->openFileList.next, 
					   struct cifsFileInfo, flist);           
E 4
    /* We could check if file is open for writing first */
E 28
I 28
		read_lock(&GlobalSMBSeslock); 
		/* To avoid spurious oplock breaks from server, in the case
			of inodes that we already have open, avoid doing path
			based setting of file size if we can do it by handle.
			This keeps our caching token (oplock) and avoids
			timeouts when the local oplock break takes longer to flush
			writebehind data than the SMB timeout for the SetPathInfo 
			request would allow */
		list_for_each(tmp, &cifsInode->openFileList) {            
			open_file = list_entry(tmp,struct cifsFileInfo, flist);
			/* We check if file is open for writing first */
D 30
			if((open_file->pfile) && 
E 30
I 30
			if((open_file->pfile) &&
E 30
				((open_file->pfile->f_flags & O_RDWR) || 
				 (open_file->pfile->f_flags & O_WRONLY))) {
D 29
				read_unlock(&GlobalSMBSeslock);
				found = TRUE;
E 28
D 4
                rc = CIFSSMBSetFileSize(xid, pTcon, attrs->ia_size,
                                        open_file->netfid,open_file->pid,FALSE);           
            } else {
                cFYI(1,("\nNo open files to get file handle from"));
            }
        }
E 4
I 4
				rc = CIFSSMBSetFileSize(xid, pTcon, attrs->ia_size,
D 28
					   open_file->netfid,open_file->pid,FALSE);           
			} else {
D 6
				cFYI(1,("\nNo open files to get file handle from"));
E 6
I 6
				cFYI(1,(" No open files to get file handle from"));
E 28
I 28
					   open_file->netfid,open_file->pid,FALSE);
				cFYI(1,("SetFileSize by handle (setattrs) rc = %d",rc));
				break;  /* now that we found one valid file handle no
E 29
I 29
				if(open_file->invalidHandle == FALSE) {
					/* we found a valid, writeable network file 
					handle to use to try to set the file size */
					__u16 nfid = open_file->netfid;
					__u32 npid = open_file->pid;
					read_unlock(&GlobalSMBSeslock);
					found = TRUE;
					rc = CIFSSMBSetFileSize(xid, pTcon, attrs->ia_size,
					   nfid,npid,FALSE);
					cFYI(1,("SetFileSize by handle (setattrs) rc = %d",rc));
				/* Do not need reopen and retry on EAGAIN since we will
					retry by pathname below */

					break;  /* now that we found one valid file handle no
E 29
						sense continuing to loop trying others */
I 29
				}
E 29
E 28
E 6
			}
		}
I 28
		if(found == FALSE)
			read_unlock(&GlobalSMBSeslock);

		if(rc != 0) {
I 29
			/* Set file size by pathname rather than by handle either
			because no valid, writeable file handle for it was found or
			because there was an error setting it by handle */
E 29
			rc = CIFSSMBSetEOF(xid, pTcon, full_path, attrs->ia_size,FALSE,
				   cifs_sb->local_nls);
			cFYI(1,(" SetEOF by path (setattrs) rc = %d",rc));
		}

E 28
E 4
D 6
        /*  Set Allocation Size of file - might not even need to call the
            following but might as well and it does not hurt if it fails */
		CIFSSMBSetEOF(xid, pTcon, full_path, attrs->ia_size, TRUE, cifs_sb->local_nls);
		if (rc == 0)
			vmtruncate(direntry->d_inode, attrs->ia_size);
		/* BB add special case to handle sharing violation (due to Samba bug)
		   by calling SetFileInfo to set the sizes */
E 6
I 6
        /*  For Allocation Size - do not need to call the following
            it did not hurt if it fails but why bother */
	/*	CIFSSMBSetEOF(xid, pTcon, full_path, attrs->ia_size, TRUE, cifs_sb->local_nls);*/
I 28

E 28
		if (rc == 0) {
			rc = vmtruncate(direntry->d_inode, attrs->ia_size);
D 10
			nobh_truncate_page(direntry->d_inode->i_mapping, direntry->d_inode->i_size);
E 10
I 10
			cifs_trunc_page(direntry->d_inode->i_mapping, direntry->d_inode->i_size); 
D 28

E 28
E 10
/*          cFYI(1,("truncate_page to 0x%lx \n",direntry->d_inode->i_size)); */
		}
E 6
	}
	if (attrs->ia_valid & ATTR_UID) {
D 6
		cFYI(1, ("\nCIFS - UID changed to %d", attrs->ia_uid));
E 6
I 6
		cFYI(1, (" CIFS - UID changed to %d", attrs->ia_uid));
E 6
		uid = attrs->ia_uid;
		/*        entry->uid = cpu_to_le16(attr->ia_uid); */
	}
	if (attrs->ia_valid & ATTR_GID) {
D 6
		cFYI(1, ("\nCIFS - GID changed to %d", attrs->ia_gid));
E 6
I 6
		cFYI(1, (" CIFS - GID changed to %d", attrs->ia_gid));
E 6
		gid = attrs->ia_gid;
		/*      entry->gid = cpu_to_le16(attr->ia_gid); */
	}
I 11

	time_buf.Attributes = 0;
E 11
	if (attrs->ia_valid & ATTR_MODE) {
D 6
		cFYI(1, ("\nCIFS - Mode changed to 0x%x", attrs->ia_mode));
E 6
I 6
		cFYI(1, (" CIFS - Mode changed to 0x%x", attrs->ia_mode));
E 6
		mode = attrs->ia_mode;
D 11
		/*      entry->mode = cpu_to_le16(attr->ia_mode); */
E 11
I 11
		/* entry->mode = cpu_to_le16(attr->ia_mode); */
E 11
	}

	if ((cifs_sb->tcon->ses->capabilities & CAP_UNIX)
	    && (attrs->ia_valid & (ATTR_MODE | ATTR_GID | ATTR_UID)))
D 8
		CIFSSMBUnixSetPerms(xid, pTcon, full_path, mode, uid, gid,
E 8
I 8
		rc = CIFSSMBUnixSetPerms(xid, pTcon, full_path, mode, uid, gid,
E 8
D 16
				    cifs_sb->local_nls);
E 16
I 16
				0 /* dev_t */, cifs_sb->local_nls);
E 16
D 11
	else {			/* BB to be implemented - via Windows security descriptors */
E 11
I 11
	else if (attrs->ia_valid & ATTR_MODE) {
		if((mode & S_IWUGO) == 0) /* not writeable */ {
			if((cifsInode->cifsAttrs & ATTR_READONLY) == 0)
				time_buf.Attributes = 
					cpu_to_le32(cifsInode->cifsAttrs | ATTR_READONLY);
		} else if((mode & S_IWUGO) == S_IWUGO) {
			if(cifsInode->cifsAttrs & ATTR_READONLY)
				time_buf.Attributes = 
					cpu_to_le32(cifsInode->cifsAttrs & (~ATTR_READONLY));
		}
		/* BB to be implemented - via Windows security descriptors or streams */
E 11
		/* CIFSSMBWinSetPerms(xid,pTcon,full_path,mode,uid,gid,cifs_sb->local_nls);*/
	}

	if (attrs->ia_valid & ATTR_ATIME) {
		set_time = TRUE;
		time_buf.LastAccessTime =
		    cpu_to_le64(cifs_UnixTimeToNT(attrs->ia_atime));
	} else
		time_buf.LastAccessTime = 0;

	if (attrs->ia_valid & ATTR_MTIME) {
		set_time = TRUE;
		time_buf.LastWriteTime =
		    cpu_to_le64(cifs_UnixTimeToNT(attrs->ia_mtime));
	} else
		time_buf.LastWriteTime = 0;

	if (attrs->ia_valid & ATTR_CTIME) {
		set_time = TRUE;
D 6
		cFYI(1, ("\nCIFS - CTIME changed ")); /* BB probably do not need */
E 6
I 6
		cFYI(1, (" CIFS - CTIME changed ")); /* BB probably do not need */
E 6
		time_buf.ChangeTime =
		    cpu_to_le64(cifs_UnixTimeToNT(attrs->ia_ctime));
	} else
		time_buf.ChangeTime = 0;

D 11
	if (set_time) {		
        /* BB handle errors better if one attribute not set 
            (such as size) but time setting works */
E 11
I 11
	if (set_time | time_buf.Attributes) {
		/* BB what if setting one attribute fails  
			(such as size) but time setting works */
E 11
		time_buf.CreationTime = 0;	/* do not change */
I 28
		/* In the future we should experiment - try setting timestamps
			 via Handle (SetFileInfo) instead of by path */
E 28
D 11
		time_buf.Attributes = 0;	/* BB is this ignored by server?  
                        or do I have to query and reset anyway BB */
E 11
		rc = CIFSSMBSetTimes(xid, pTcon, full_path, &time_buf,
D 11
				     cifs_sb->local_nls);
E 11
I 11
				cifs_sb->local_nls);
E 11
	}
D 6
	cifsInode->time = 0; /* force revalidate to get attributes when needed */
E 6
I 6
D 8
/*	cifsInode->time = 0; */ /* force revalidate to get attributes when needed */
E 8
E 6

I 8
	/* do not  need local check to inode_check_ok since the server does that */
	inode_setattr(direntry->d_inode, attrs);
E 8
	if (full_path)
		kfree(full_path);
	FreeXid(xid);
	return rc;
}

void
cifs_delete_inode(struct inode *inode)
{
	/* Note: called without the big kernel filelock - remember spinlocks! */
D 6
	cFYI(1, ("In cifs_delete_inode, inode = 0x%p\n", inode));
E 6
I 6
	cFYI(1, ("In cifs_delete_inode, inode = 0x%p ", inode));
E 6
	/* may have to add back in when safe distributed caching of
             directories via e.g. FindNotify added */
D 4

E 4
}
E 2
I 1
E 1
