/* $OpenLDAP: pkg/ldap/libraries/liblutil/nt_err.c,v 1.5.2.1 1999/09/10 20:25:28 kdz Exp $ */
#include "portable.h"

#ifdef HAVE_WINSOCK2
#include <winsock2.h>

#define __RETSTR( x ) case x: return #x;

char *WSAGetErrorString( int err )
{
	switch( err )
	{
		__RETSTR( WSAEINTR )
		__RETSTR( WSAEBADF )
		__RETSTR( WSAEACCES )
		__RETSTR( WSAEFAULT )
		__RETSTR( WSAEINVAL )
		__RETSTR( WSAEMFILE )
		__RETSTR( WSAEWOULDBLOCK )
		__RETSTR( WSAEINPROGRESS )
		__RETSTR( WSAEALREADY )
		__RETSTR( WSAENOTSOCK )
		__RETSTR( WSAEDESTADDRREQ )
		__RETSTR( WSAEMSGSIZE )
		__RETSTR( WSAEPROTOTYPE )
		__RETSTR( WSAENOPROTOOPT )
		__RETSTR( WSAEPROTONOSUPPORT )
		__RETSTR( WSAESOCKTNOSUPPORT )
		__RETSTR( WSAEOPNOTSUPP )
		__RETSTR( WSAEPFNOSUPPORT )
		__RETSTR( WSAEAFNOSUPPORT )
		__RETSTR( WSAEADDRINUSE )
		__RETSTR( WSAEADDRNOTAVAIL )
		__RETSTR( WSAENETDOWN )
		__RETSTR( WSAENETUNREACH )
		__RETSTR( WSAENETRESET )
		__RETSTR( WSAECONNABORTED )
		__RETSTR( WSAECONNRESET )
		__RETSTR( WSAENOBUFS )
		__RETSTR( WSAEISCONN )
		__RETSTR( WSAENOTCONN )
		__RETSTR( WSAESHUTDOWN )
		__RETSTR( WSAETOOMANYREFS )
		__RETSTR( WSAETIMEDOUT )
		__RETSTR( WSAECONNREFUSED )
		__RETSTR( WSAELOOP )
		__RETSTR( WSAENAMETOOLONG )
		__RETSTR( WSAEHOSTDOWN )
		__RETSTR( WSAEHOSTUNREACH )
		__RETSTR( WSAENOTEMPTY )
		__RETSTR( WSAEPROCLIM )
		__RETSTR( WSAEUSERS )
		__RETSTR( WSAEDQUOT )
		__RETSTR( WSAESTALE )
		__RETSTR( WSAEREMOTE )
		__RETSTR( WSASYSNOTREADY )
		__RETSTR( WSAVERNOTSUPPORTED )
		__RETSTR( WSANOTINITIALISED )
		__RETSTR( WSAEDISCON )
		__RETSTR( WSAENOMORE )
		__RETSTR( WSAECANCELLED )
		__RETSTR( WSAEINVALIDPROCTABLE )
		__RETSTR( WSAEINVALIDPROVIDER )
		__RETSTR( WSASYSCALLFAILURE )
		__RETSTR( WSASERVICE_NOT_FOUND )
		__RETSTR( WSATYPE_NOT_FOUND )
		__RETSTR( WSA_E_NO_MORE )
		__RETSTR( WSA_E_CANCELLED )
		__RETSTR( WSAEREFUSED )

		__RETSTR( WSAHOST_NOT_FOUND )
		__RETSTR( WSATRY_AGAIN )
		__RETSTR( WSANO_RECOVERY )
		__RETSTR( WSANO_DATA )
	}
	return "unknown";
}

char *WSAGetLastErrorString( void )
{
	return WSAGetErrorString( WSAGetLastError() );
}

#undef __RETSTR

#endif /* HAVE_WINSOCK2 */


char *GetErrorString( int err )
{
	static char msgBuf[1024];

	FormatMessage(
		FORMAT_MESSAGE_FROM_SYSTEM,
		NULL,
		err, MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
		msgBuf, 1024, NULL );

	return msgBuf;
}

char *GetLastErrorString( void )
{
	return GetErrorString( GetLastError() );
}



