/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_rsc.hxx"

/****************** I N C L U D E S **************************************/
// C and C++ Includes.
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <i18npool/mslangid.hxx>
#include <tools/rc.h>
#include <tools/color.hxx>

#include <vclrsc.hxx>
#include <rscconst.hxx>
#include <rscarray.hxx>
#include <rscclass.hxx>
#include <rsccont.hxx>
#include <rscdb.hxx>


#include "rsclex.hxx"
#include <yyrscyacc.hxx>

#include <hash_map>

/****************** M A C R O S ******************************************/
void RscTypCont::SETCONST( RscConst * pClass, const char * szString, UINT32 nVal )
{
#if OSL_DEBUG_LEVEL > 2
    fprintf( stderr, "setconst : %s\n", szString );
#endif
    pClass->SetConstant( aNmTb.Put( szString,
                         CONSTNAME, nVal ), nVal );
}

void RscTypCont::SETCONST( RscConst * pClass, Atom nName, UINT32 nVal )
{
#if OSL_DEBUG_LEVEL > 2
    fprintf( stderr, "setconst hash: %u\n", (unsigned int)nName );
#endif
    pClass->SetConstant( aNmTb.Put( nName,
                         CONSTNAME, nVal ), nVal );
}

/****************** C O D E **********************************************/
/*************************************************************************
|*	  RscTypCont::InitLangType()
|*
|*	  Beschreibung
*************************************************************************/

typedef std::hash_map< rtl::OString, sal_uInt32, rtl::OStringHash > langmap;
static langmap ULong_Iso_map;

sal_uInt32 GetLangId( const ByteString& aLang )
{
    langmap::iterator pIter = ULong_Iso_map.find( aLang );
    if ( pIter != ULong_Iso_map.end())
        return pIter->second;
    return 0;
}

void RscLangEnum::Init( RscNameTable& rNames )
{
    SetConstant( rNames.Put( "SYSTEM", CONSTNAME, (long)LANGUAGE_SYSTEM ), LANGUAGE_SYSTEM );
    SetConstant( rNames.Put( "DONTKNOW", CONSTNAME, LANGUAGE_DONTKNOW ), LANGUAGE_DONTKNOW );
    
    sal_Int32 nIndex = 0;
    mnLangId = 0x400; // stay away from selfdefined...
    char csep = '-';
    const MsLangId::IsoLangEntry* pLangEntry;
    ByteString aCountry, aLang;
    
    while ( NULL != ( pLangEntry = MsLangId::getIsoLangEntry( nIndex )) && ( pLangEntry->mnLang != LANGUAGE_DONTKNOW ))
    {
#if OSL_DEBUG_LEVEL > 2
        fprintf( stderr, "ISO Language in : %d %d %s\n",
                 (int)nIndex,
                 pLangEntry->mnLang,
                 MsLangId::convertLanguageToIsoByteString( pLangEntry->mnLang ).getStr() );
#endif
        aLang = pLangEntry->maLangStr;
        aCountry = pLangEntry->maCountry;
        if ( aLang.EqualsIgnoreCaseAscii( aCountry ) ||  ! aCountry.Len() )
        {
            SetConstant( rNames.Put( aLang.GetBuffer(), CONSTNAME, mnLangId ), mnLangId );
            if ( ! GetLangId( aLang ))
                ULong_Iso_map[ aLang ] = mnLangId;
#if OSL_DEBUG_LEVEL > 2
            fprintf( stderr, "ISO Language out: %s 0x%lx\n", aLang.GetBuffer(), mnLangId );
#endif
            mnLangId++;
        }
        else
        {
            SetConstant( rNames.Put( aLang.GetBuffer(), CONSTNAME, mnLangId ), mnLangId );
            if ( ! GetLangId( aLang ))
                ULong_Iso_map[ aLang ] = mnLangId;
#if OSL_DEBUG_LEVEL > 2
            fprintf( stderr, "ISO Language out: %s 0x%lx", aLang.GetBuffer(), mnLangId );
#endif
            mnLangId++;
            aLang += csep;
            aLang += aCountry.ToUpperAscii();
            SetConstant( rNames.Put( aLang.GetBuffer(), CONSTNAME, mnLangId ), mnLangId );
            if ( ! GetLangId( aLang ))
                ULong_Iso_map[ aLang ] = mnLangId;
#if OSL_DEBUG_LEVEL > 2
            fprintf( stderr, " %s 0x%lx\n", aLang.GetBuffer(), mnLangId );
#endif
            mnLangId++;
// hack - survive "x-no-translate"
            if ( aLang == "en-US" )
            {
//                SetConstant( rNames.Put( "x-no-translate", CONSTNAME, mnLangId ), mnLangId );
//                mnLangId++;
                SetConstant( rNames.Put( "x-comment", CONSTNAME, mnLangId ), mnLangId );
                mnLangId++;
            }
        }
        nIndex++;
    }

    ByteString aEnvIsoTokens = getenv( "RSC_LANG_ISO" );
    if ( aEnvIsoTokens.Len() )
    {
        ByteString aIsoToken;
        sal_uInt16 nTokenCounter = 0;
        sal_Bool bOneMore = 1;
        while ( bOneMore )
        {
            aIsoToken = aEnvIsoTokens.GetToken( nTokenCounter, ' ' );
            if ( aIsoToken.Len() )
            {
                SetConstant( rNames.Put( aIsoToken.GetBuffer(), CONSTNAME, mnLangId ), mnLangId );
                if ( ! GetLangId( aIsoToken ))
                    ULong_Iso_map[ aIsoToken ] = mnLangId;
#if OSL_DEBUG_LEVEL > 2
                fprintf( stderr, "Env ISO Language out: %s 0x%lx\n", aIsoToken.GetBuffer(), mnLangId );
#endif
                mnLangId++;
            }
            else
                bOneMore = 0;
            nTokenCounter++;
        }
    }
    
    SetConstant( rNames.Put( "LANGUAGE_USER1", CONSTNAME, LANGUAGE_USER1 ), LANGUAGE_USER1 );
    SetConstant( rNames.Put( "LANGUAGE_USER2", CONSTNAME, LANGUAGE_USER2 ), LANGUAGE_USER2 );
    SetConstant( rNames.Put( "LANGUAGE_USER3", CONSTNAME, LANGUAGE_USER3 ), LANGUAGE_USER3 );
    SetConstant( rNames.Put( "LANGUAGE_USER4", CONSTNAME, LANGUAGE_USER4 ), LANGUAGE_USER4 );
    SetConstant( rNames.Put( "LANGUAGE_USER5", CONSTNAME, LANGUAGE_USER5 ), LANGUAGE_USER5 );
    SetConstant( rNames.Put( "LANGUAGE_USER6", CONSTNAME, LANGUAGE_USER6 ), LANGUAGE_USER6 );
    SetConstant( rNames.Put( "LANGUAGE_USER7", CONSTNAME, LANGUAGE_USER7 ), LANGUAGE_USER7 );
    SetConstant( rNames.Put( "LANGUAGE_USER8", CONSTNAME, LANGUAGE_USER8 ), LANGUAGE_USER8 );
    SetConstant( rNames.Put( "EXTERN", CONSTNAME, LANGUAGE_USER9 ), LANGUAGE_USER9 );
}

Atom RscLangEnum::AddLanguage( const char* pLang, RscNameTable& rNames )
{
    Atom nResult = 0;
    KEY_STRUCT aStruct;
    if( ! rNames.Get( nResult = pHS->getID( pLang ), &aStruct ) )
    {
        SetConstant( nResult = rNames.Put( pLang, CONSTNAME, mnLangId ), mnLangId );
        // insert new lang to ULong_Iso_map
        rtl::OString aLang( pLang );
        if ( ! GetLangId( aLang ))
            ULong_Iso_map[ aLang ] = mnLangId;
        // increase id counter
        mnLangId++;
    }
    #if OSL_DEBUG_LEVEL > 2
    fprintf( stderr, "AddLanguage( %s ) = 0x%lx\n", pLang, nResult );
    #endif
    return nResult;
}

RscEnum * RscTypCont::InitLangType()
{
    aLangType.Init( aNmTb );
    return( &aLangType );
}

/*************************************************************************
|*
|*	  RscTypCont::InitFieldUnitsType()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.03.91
|*	  Letzte Aenderung	MM 27.06.91
|*
*************************************************************************/
RscEnum * RscTypCont::InitFieldUnitsType()
{
    RscEnum * pFieldUnits;
    pFieldUnits = new RscEnum( pHS->getID( "EnumFieldUnit" ), RSC_NOTYPE );

    SETCONST( pFieldUnits, "FUNIT_NONE", FUNIT_NONE );
    SETCONST( pFieldUnits, "FUNIT_MM", FUNIT_MM );
    SETCONST( pFieldUnits, "FUNIT_CM", FUNIT_CM );
    SETCONST( pFieldUnits, "FUNIT_M", FUNIT_M );
    SETCONST( pFieldUnits, "FUNIT_KM", FUNIT_KM );
    SETCONST( pFieldUnits, "FUNIT_TWIP", FUNIT_TWIP );
    SETCONST( pFieldUnits, "FUNIT_POINT", FUNIT_POINT );
    SETCONST( pFieldUnits, "FUNIT_PICA", FUNIT_PICA );
    SETCONST( pFieldUnits, "FUNIT_INCH", FUNIT_INCH );
    SETCONST( pFieldUnits, "FUNIT_FOOT", FUNIT_FOOT );
    SETCONST( pFieldUnits, "FUNIT_MILE", FUNIT_MILE );
    SETCONST( pFieldUnits, "FUNIT_CUSTOM", FUNIT_CUSTOM );
    // Amelia : adds two units ,"char" and "line"
    SETCONST( pFieldUnits, "FUNIT_CHAR", FUNIT_CHAR );
    SETCONST( pFieldUnits, "FUNIT_LINE", FUNIT_LINE );
    SETCONST( pFieldUnits, "FUNIT_PERCENT", FUNIT_PERCENT );

    return pFieldUnits;
}

/*************************************************************************
|*
|*	  RscTypCont::InitTimeFieldFormat()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 22.03.91
|*	  Letzte Aenderung	MM 27.06.91
|*
*************************************************************************/
RscEnum * RscTypCont::InitTimeFieldFormat()
{
    RscEnum * pTimeFieldFormat;
    pTimeFieldFormat = new RscEnum( pHS->getID( "EnumTimeFieldFormat" ),
                                    RSC_NOTYPE );

    SETCONST( pTimeFieldFormat, "TIMEF_NONE", TIMEF_NONE );
    SETCONST( pTimeFieldFormat, "TIMEF_SEC", TIMEF_SEC );
    SETCONST( pTimeFieldFormat, "TIMEF_100TH_SEC", TIMEF_100TH_SEC );

    return pTimeFieldFormat;
}

/*************************************************************************
|*
|*	  RscTypCont::InitColor()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 24.05.91
|*	  Letzte Aenderung	MM 24.05.91
|*
*************************************************************************/
RscEnum * RscTypCont::InitColor(){
    RscEnum * pColor;
    pColor = new RscEnum( pHS->getID( "EnumColor" ), RSC_NOTYPE );

    SETCONST( pColor, "COL_BLACK",                  COL_BLACK );
    SETCONST( pColor, "COL_BLUE",                   COL_BLUE );
    SETCONST( pColor, "COL_GREEN",                  COL_GREEN );
    SETCONST( pColor, "COL_CYAN",                   COL_CYAN );
    SETCONST( pColor, "COL_RED",                    COL_RED );
    SETCONST( pColor, "COL_MAGENTA",                COL_MAGENTA );
    SETCONST( pColor, "COL_BROWN",                  COL_BROWN );
    SETCONST( pColor, "COL_GRAY",                   COL_GRAY );
    SETCONST( pColor, "COL_LIGHTGRAY",              COL_LIGHTGRAY );
    SETCONST( pColor, "COL_LIGHTBLUE",              COL_LIGHTBLUE );
    SETCONST( pColor, "COL_LIGHTGREEN",             COL_LIGHTGREEN );
    SETCONST( pColor, "COL_LIGHTCYAN",              COL_LIGHTCYAN );
    SETCONST( pColor, "COL_LIGHTRED",               COL_LIGHTRED );
    SETCONST( pColor, "COL_LIGHTMAGENTA",           COL_LIGHTMAGENTA );
    SETCONST( pColor, "COL_YELLOW",                 COL_YELLOW );
    SETCONST( pColor, "COL_WHITE",                  COL_WHITE );

    return( pColor );
}

/*************************************************************************
|*
|*	  RscTypCont::InitMapUnit()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 24.05.91
|*	  Letzte Aenderung	MM 24.05.91
|*
*************************************************************************/
RscEnum * RscTypCont::InitMapUnit(){
    RscEnum * pMapUnit;
    pMapUnit = new RscEnum( pHS->getID( "EnumMapUnit" ), RSC_NOTYPE );

    SETCONST( pMapUnit, "MAP_PIXEL",                  MAP_PIXEL );
    SETCONST( pMapUnit, "MAP_SYSFONT",                MAP_SYSFONT );
    SETCONST( pMapUnit, "MAP_100TH_MM",               MAP_100TH_MM );
    SETCONST( pMapUnit, "MAP_10TH_MM",                MAP_10TH_MM );
    SETCONST( pMapUnit, "MAP_MM",                     MAP_MM );
    SETCONST( pMapUnit, "MAP_CM",                     MAP_CM );
    SETCONST( pMapUnit, "MAP_1000TH_INCH",            MAP_1000TH_INCH );
    SETCONST( pMapUnit, "MAP_100TH_INCH",             MAP_100TH_INCH );
    SETCONST( pMapUnit, "MAP_10TH_INCH",              MAP_10TH_INCH );
    SETCONST( pMapUnit, "MAP_INCH",                   MAP_INCH );
    SETCONST( pMapUnit, "MAP_POINT",                  MAP_POINT );
    SETCONST( pMapUnit, "MAP_TWIP",                   MAP_TWIP );
    SETCONST( pMapUnit, "MAP_APPFONT",                MAP_APPFONT );
    SETCONST( pMapUnit, "MAP_SV",                     RSC_EXTRAMAPUNIT );
    return( pMapUnit );
}

/*************************************************************************
|*
|*	  RscTypCont::InitKey()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 24.05.91
|*	  Letzte Aenderung	MM 24.05.91
|*
*************************************************************************/
RscEnum * RscTypCont::InitKey(){
    RscEnum * pKey;
    pKey = new RscEnum( pHS->getID( "EnumKey" ), RSC_NOTYPE );

    SETCONST( pKey, "KEY_0",                    com::sun::star::awt::Key::NUM0 );
    SETCONST( pKey, "KEY_1",                    com::sun::star::awt::Key::NUM1 );
    SETCONST( pKey, "KEY_2",                    com::sun::star::awt::Key::NUM2 );
    SETCONST( pKey, "KEY_3",                    com::sun::star::awt::Key::NUM3 );
    SETCONST( pKey, "KEY_4",                    com::sun::star::awt::Key::NUM4 );
    SETCONST( pKey, "KEY_5",                    com::sun::star::awt::Key::NUM5 );
    SETCONST( pKey, "KEY_6",                    com::sun::star::awt::Key::NUM6 );
    SETCONST( pKey, "KEY_7",                    com::sun::star::awt::Key::NUM7 );
    SETCONST( pKey, "KEY_8",                    com::sun::star::awt::Key::NUM8 );
    SETCONST( pKey, "KEY_9",                    com::sun::star::awt::Key::NUM9 );

    SETCONST( pKey, "KEY_A",                    com::sun::star::awt::Key::A );
    SETCONST( pKey, "KEY_B",                    com::sun::star::awt::Key::B );
    SETCONST( pKey, "KEY_C",                    com::sun::star::awt::Key::C );
    SETCONST( pKey, "KEY_D",                    com::sun::star::awt::Key::D );
    SETCONST( pKey, "KEY_E",                    com::sun::star::awt::Key::E );
    SETCONST( pKey, "KEY_F",                    com::sun::star::awt::Key::F );
    SETCONST( pKey, "KEY_G",                    com::sun::star::awt::Key::G );
    SETCONST( pKey, "KEY_H",                    com::sun::star::awt::Key::H );
    SETCONST( pKey, "KEY_I",                    com::sun::star::awt::Key::I );
    SETCONST( pKey, "KEY_J",                    com::sun::star::awt::Key::J );
    SETCONST( pKey, "KEY_K",                    com::sun::star::awt::Key::K );
    SETCONST( pKey, "KEY_L",                    com::sun::star::awt::Key::L );
    SETCONST( pKey, "KEY_M",                    com::sun::star::awt::Key::M );
    SETCONST( pKey, "KEY_N",                    com::sun::star::awt::Key::N );
    SETCONST( pKey, "KEY_O",                    com::sun::star::awt::Key::O );
    SETCONST( pKey, "KEY_P",                    com::sun::star::awt::Key::P );
    SETCONST( pKey, "KEY_Q",                    com::sun::star::awt::Key::Q );
    SETCONST( pKey, "KEY_R",                    com::sun::star::awt::Key::R );
    SETCONST( pKey, "KEY_S",                    com::sun::star::awt::Key::S );
    SETCONST( pKey, "KEY_T",                    com::sun::star::awt::Key::T );
    SETCONST( pKey, "KEY_U",                    com::sun::star::awt::Key::U );
    SETCONST( pKey, "KEY_V",                    com::sun::star::awt::Key::V );
    SETCONST( pKey, "KEY_W",                    com::sun::star::awt::Key::W );
    SETCONST( pKey, "KEY_X",                    com::sun::star::awt::Key::X );
    SETCONST( pKey, "KEY_Y",                    com::sun::star::awt::Key::Y );
    SETCONST( pKey, "KEY_Z",                    com::sun::star::awt::Key::Z );

    SETCONST( pKey, "KEY_F1",                   com::sun::star::awt::Key::F1 );
    SETCONST( pKey, "KEY_F2",                   com::sun::star::awt::Key::F2 );
    SETCONST( pKey, "KEY_F3",                   com::sun::star::awt::Key::F3 );
    SETCONST( pKey, "KEY_F4",                   com::sun::star::awt::Key::F4 );
    SETCONST( pKey, "KEY_F5",                   com::sun::star::awt::Key::F5 );
    SETCONST( pKey, "KEY_F6",                   com::sun::star::awt::Key::F6 );
    SETCONST( pKey, "KEY_F7",                   com::sun::star::awt::Key::F7 );
    SETCONST( pKey, "KEY_F8",                   com::sun::star::awt::Key::F8 );
    SETCONST( pKey, "KEY_F9",                   com::sun::star::awt::Key::F9 );
    SETCONST( pKey, "KEY_F10",                  com::sun::star::awt::Key::F10 );
    SETCONST( pKey, "KEY_F11",                  com::sun::star::awt::Key::F11 );
    SETCONST( pKey, "KEY_F12",                  com::sun::star::awt::Key::F12 );
    SETCONST( pKey, "KEY_F13",                  com::sun::star::awt::Key::F13 );
    SETCONST( pKey, "KEY_F14",                  com::sun::star::awt::Key::F14 );
    SETCONST( pKey, "KEY_F15",                  com::sun::star::awt::Key::F15 );
    SETCONST( pKey, "KEY_F16",                  com::sun::star::awt::Key::F16 );
    SETCONST( pKey, "KEY_F17",                  com::sun::star::awt::Key::F17 );
    SETCONST( pKey, "KEY_F18",                  com::sun::star::awt::Key::F18 );
    SETCONST( pKey, "KEY_F19",                  com::sun::star::awt::Key::F19 );
    SETCONST( pKey, "KEY_F20",                  com::sun::star::awt::Key::F20 );
    SETCONST( pKey, "KEY_F21",                  com::sun::star::awt::Key::F21 );
    SETCONST( pKey, "KEY_F22",                  com::sun::star::awt::Key::F22 );
    SETCONST( pKey, "KEY_F23",                  com::sun::star::awt::Key::F23 );
    SETCONST( pKey, "KEY_F24",                  com::sun::star::awt::Key::F24 );
    SETCONST( pKey, "KEY_F25",                  com::sun::star::awt::Key::F25 );
    SETCONST( pKey, "KEY_F26",                  com::sun::star::awt::Key::F26 );

    SETCONST( pKey, "KEY_DOWN",                 com::sun::star::awt::Key::DOWN );
    SETCONST( pKey, "KEY_UP",                   com::sun::star::awt::Key::UP );
    SETCONST( pKey, "KEY_LEFT",                 com::sun::star::awt::Key::LEFT );
    SETCONST( pKey, "KEY_RIGHT",                com::sun::star::awt::Key::RIGHT );
    SETCONST( pKey, "KEY_HOME",                 com::sun::star::awt::Key::HOME );
    SETCONST( pKey, "KEY_END",                  com::sun::star::awt::Key::END );
    SETCONST( pKey, "KEY_PAGEUP",               com::sun::star::awt::Key::PAGEUP );
    SETCONST( pKey, "KEY_PAGEDOWN",             com::sun::star::awt::Key::PAGEDOWN );

    SETCONST( pKey, "KEY_RETURN",               com::sun::star::awt::Key::RETURN );
    SETCONST( pKey, "KEY_ESCAPE",               com::sun::star::awt::Key::ESCAPE );
    SETCONST( pKey, "KEY_TAB",                  com::sun::star::awt::Key::TAB );
    SETCONST( pKey, "KEY_BACKSPACE",            com::sun::star::awt::Key::BACKSPACE );
    SETCONST( pKey, "KEY_SPACE",                com::sun::star::awt::Key::SPACE );
    SETCONST( pKey, "KEY_INSERT",               com::sun::star::awt::Key::INSERT );
    SETCONST( pKey, "KEY_DELETE",               com::sun::star::awt::Key::DELETE );

    SETCONST( pKey, "KEY_ADD",                  com::sun::star::awt::Key::ADD );
    SETCONST( pKey, "KEY_SUBTRACT",             com::sun::star::awt::Key::SUBTRACT );
    SETCONST( pKey, "KEY_MULTIPLY",             com::sun::star::awt::Key::MULTIPLY );
    SETCONST( pKey, "KEY_DIVIDE",               com::sun::star::awt::Key::DIVIDE );
    SETCONST( pKey, "KEY_POINT",                com::sun::star::awt::Key::POINT );
    SETCONST( pKey, "KEY_COMMA",                com::sun::star::awt::Key::COMMA );
    SETCONST( pKey, "KEY_LESS",                 com::sun::star::awt::Key::LESS );
    SETCONST( pKey, "KEY_GREATER",              com::sun::star::awt::Key::GREATER );
    SETCONST( pKey, "KEY_EQUAL",                com::sun::star::awt::Key::EQUAL );

    SETCONST( pKey, "KEY_OPEN",                 com::sun::star::awt::Key::OPEN );
    SETCONST( pKey, "KEY_CUT",                  com::sun::star::awt::Key::CUT );
    SETCONST( pKey, "KEY_COPY",                 com::sun::star::awt::Key::COPY );
    SETCONST( pKey, "KEY_PASTE",                com::sun::star::awt::Key::PASTE );
    SETCONST( pKey, "KEY_UNDO",                 com::sun::star::awt::Key::UNDO );
    SETCONST( pKey, "KEY_REPEAT",               com::sun::star::awt::Key::REPEAT );
    SETCONST( pKey, "KEY_FIND",                 com::sun::star::awt::Key::FIND );
    SETCONST( pKey, "KEY_PROPERTIES",           com::sun::star::awt::Key::PROPERTIES );
    SETCONST( pKey, "KEY_FRONT",                com::sun::star::awt::Key::FRONT );
    SETCONST( pKey, "KEY_CONTEXTMENU",          com::sun::star::awt::Key::CONTEXTMENU );
    SETCONST( pKey, "KEY_HELP",                 com::sun::star::awt::Key::HELP );
    SETCONST( pKey, "KEY_HANGUL_HANJA",         com::sun::star::awt::Key::HANGUL_HANJA );
    SETCONST( pKey, "KEY_DECIMAL",              com::sun::star::awt::Key::DECIMAL );
    SETCONST( pKey, "KEY_TILDE",                com::sun::star::awt::Key::TILDE );
    SETCONST( pKey, "KEY_QUOTELEFT",            com::sun::star::awt::Key::QUOTELEFT );

    return( pKey );
}

/*************************************************************************
|*
|*	  RscTypCont::InitTriState()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 26.11.91
|*	  Letzte Aenderung	MM 26.11.91
|*
*************************************************************************/
RscEnum * RscTypCont::InitTriState(){
    RscEnum * pTriState;
    pTriState = new RscEnum( pHS->getID( "EnumTriState" ), RSC_NOTYPE );

    SETCONST( pTriState, "STATE_NOCHECK",      STATE_NOCHECK  );
    SETCONST( pTriState, "STATE_CHECK",        STATE_CHECK    );
    SETCONST( pTriState, "STATE_DONTKNOW",     STATE_DONTKNOW );

    return( pTriState );
}

/*************************************************************************
|*
|*	  RscTypCont::InitMessButtons()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 24.05.91
|*	  Letzte Aenderung	MM 24.05.91
|*
*************************************************************************/
RscEnum * RscTypCont::InitMessButtons()
{
    RscEnum * pMessButtons;
    pMessButtons = new RscEnum( pHS->getID( "EnumMessButtons" ), RSC_NOTYPE );
    SETCONST( pMessButtons, "WB_OK",                      sal::static_int_cast<UINT32>(WB_OK) );
    SETCONST( pMessButtons, "WB_OK_CANCEL",               sal::static_int_cast<UINT32>(WB_OK_CANCEL) );
    SETCONST( pMessButtons, "WB_YES_NO",                  sal::static_int_cast<UINT32>(WB_YES_NO) );
    SETCONST( pMessButtons, "WB_YES_NO_CANCEL",           sal::static_int_cast<UINT32>(WB_YES_NO_CANCEL) );
    SETCONST( pMessButtons, "WB_RETRY_CANCEL",            sal::static_int_cast<UINT32>(WB_RETRY_CANCEL) );
    SETCONST( pMessButtons, "WB_ABORT_RETRY_IGNORE",      sal::static_int_cast<UINT32>(WB_ABORT_RETRY_IGNORE) );
    return( pMessButtons );
}

/*************************************************************************
|*
|*	  RscTypCont::InitMessDefButton()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 24.05.91
|*	  Letzte Aenderung	MM 24.05.91
|*
*************************************************************************/
RscEnum * RscTypCont::InitMessDefButton(){
    RscEnum * pMessDefButton;
    pMessDefButton = new RscEnum( pHS->getID( "EnumMessDefButton" ),
                                  RSC_NOTYPE );

    SETCONST( pMessDefButton, "WB_DEF_OK",                  sal::static_int_cast<UINT32>(WB_DEF_OK) );
    SETCONST( pMessDefButton, "WB_DEF_CANCEL",              sal::static_int_cast<UINT32>(WB_DEF_CANCEL) );
    SETCONST( pMessDefButton, "WB_DEF_RETRY",               sal::static_int_cast<UINT32>(WB_DEF_RETRY) );
    SETCONST( pMessDefButton, "WB_DEF_YES",                 sal::static_int_cast<UINT32>(WB_DEF_YES) );
    SETCONST( pMessDefButton, "WB_DEF_NO",                  sal::static_int_cast<UINT32>(WB_DEF_NO) );
    SETCONST( pMessDefButton, "WB_DEF_IGNORE",              sal::static_int_cast<UINT32>(WB_DEF_IGNORE) );
    return( pMessDefButton );
}

/*************************************************************************
|*
|*	  RscTypCont::InitGeometry()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 24.05.91
|*	  Letzte Aenderung	MM 24.05.91
|*
*************************************************************************/
RscTupel * RscTypCont::InitGeometry()
{
    RscTop *	pTupel;
    Atom		nId;

    // Clientvariablen einfuegen
    pTupel = new RscTupel( pHS->getID( "TupelDeltaSystem" ),
                                RSC_NOTYPE, NULL );
    nId = aNmTb.Put( "X", VARNAME );
    pTupel->SetVariable( nId, &aShort );
    nId = aNmTb.Put( "Y", VARNAME );
    pTupel->SetVariable( nId, &aShort );
    nId = aNmTb.Put( "WIDTH", VARNAME );
    pTupel->SetVariable( nId, &aShort );
    nId = aNmTb.Put( "HEIGHT", VARNAME );
    pTupel->SetVariable( nId, &aShort );

    return (RscTupel *)pTupel;
}

/*************************************************************************
|*
|*	  RscTypCont::InitLangGeometry()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 24.05.91
|*	  Letzte Aenderung	MM 24.05.91
|*
*************************************************************************/
RscArray * RscTypCont::InitLangGeometry( RscTupel * pGeo )
{
    return new RscArray( pHS->getID( "Lang_TupelGeometry" ), RSC_NOTYPE, pGeo, &aLangType );
}

/*************************************************************************
|*
|*	  RscTypCont::InitStringList()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 24.05.91
|*	  Letzte Aenderung	MM 24.05.91
|*
*************************************************************************/
RscCont * RscTypCont::InitStringList()
{
    RscCont * pCont;

    pCont = new RscCont( pHS->getID( "Chars[]" ), RSC_NOTYPE );
    pCont->SetTypeClass( &aString );

    return pCont;
}

/*************************************************************************
|*
|*	  RscTypCont::InitLangStringList()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 24.05.91
|*	  Letzte Aenderung	MM 24.05.91
|*
*************************************************************************/
RscArray * RscTypCont::InitLangStringList( RscCont * pStrLst )
{
    return new RscArray( pHS->getID( "Lang_CharsList" ),
                         RSC_NOTYPE, pStrLst, &aLangType );
}

/*************************************************************************
|*
|*	  RscTypCont::InitStringTupel()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 24.05.91
|*	  Letzte Aenderung	MM 24.05.91
|*
*************************************************************************/
RscTupel * RscTypCont::InitStringTupel()
{
    RscTop *	pTupel;
    Atom		nId;

    // Clientvariablen einfuegen
    pTupel = new RscTupel( pHS->getID( "CharsTupel" ), RSC_NOTYPE, NULL );
    nId = aNmTb.Put( "FILTER", VARNAME );
    pTupel->SetVariable( nId, &aString );
    nId = aNmTb.Put( "MASK", VARNAME );
    pTupel->SetVariable( nId, &aString );

    return (RscTupel *)pTupel;
}

/*************************************************************************
|*
|*	  RscTypCont::InitStringLongTupel()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 18.07.94
|*	  Letzte Aenderung	MM 18.07.94
|*
*************************************************************************/
RscTupel * RscTypCont::InitStringLongTupel()
{
    RscTop *	pTupel;
    Atom		nId;

    // Clientvariablen einfuegen
    pTupel = new RscTupel( pHS->getID( "CharsLongTupel" ), RSC_NOTYPE, NULL );
    nId = aNmTb.Put( "ItemText", VARNAME );
    pTupel->SetVariable( nId, &aString );
    nId = aNmTb.Put( "ItemId", VARNAME );
    pTupel->SetVariable( nId, &aEnumLong );

    return (RscTupel *)pTupel;
}

/*************************************************************************
|*
|*	  RscTypCont::InitStringTupelList()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 24.05.91
|*	  Letzte Aenderung	MM 24.05.91
|*
*************************************************************************/
RscCont * RscTypCont::InitStringTupelList( RscTupel * pTupelString )
{
    RscCont * pCont;

    pCont = new RscCont( pHS->getID( "CharsCharsTupel[]" ), RSC_NOTYPE );
    pCont->SetTypeClass( pTupelString );

    return pCont;
}

/*************************************************************************
|*
|*	  RscTypCont::InitStringLongTupelList()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 24.05.91
|*	  Letzte Aenderung	MM 24.05.91
|*
*************************************************************************/
RscCont * RscTypCont::InitStringLongTupelList( RscTupel * pStringLong )
{
    RscCont * pCont;

    pCont = new RscCont( pHS->getID( "CharsLongTupel[]" ), RSC_NOTYPE );
    pCont->SetTypeClass( pStringLong );

    return pCont;
}

/*************************************************************************
|*
|*	  RscTypCont::InitLangStringTupelList()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 24.05.91
|*	  Letzte Aenderung	MM 24.05.91
|*
*************************************************************************/
RscArray * RscTypCont::InitLangStringTupelList( RscCont * pStrTupelLst )
{
    return new RscArray( pHS->getID( "Lang_CharsCharsTupel" ),
                    RSC_NOTYPE, pStrTupelLst, &aLangType );
}

/*************************************************************************
|*
|*	  RscTypCont::InitLangStringLongTupelList()
|*
|*	  Beschreibung
|*	  Ersterstellung	MM 24.05.91
|*	  Letzte Aenderung	MM 24.05.91
|*
*************************************************************************/
RscArray * RscTypCont::InitLangStringLongTupelList( RscCont * pStrLongTupelLst )
{
    return new RscArray( pHS->getID( "Lang_CharsLongTupelList" ),
                         RSC_NOTYPE, pStrLongTupelLst, &aLangType );
}

