#!/bin/sh
# Run this to generate all the initial makefiles, etc.

if test "z$1" = "z--clean"; then
    echo "Cleaning"

    rm -Rf autom4te.cache bonobo/autom4te.cache
    rm -f missing install-sh mkinstalldirs libtool ltmain.sh
    exit 1;
fi

requote_args ()
{
    sed -e 's/.*configure //' -e 's/=\(\([^"'"'"'-]\|-[^-]\| \)*\)\( \|$\)/="\1" /g'
}

new_args=`echo $@ | requote_args`

old_args=""
if test $# -eq 0 && test -f config.log; then
    old_args=`grep '\$ ./configure' config.log | requote_args`
    echo "re-using arguments from last configure: $old_args";
fi

touch ChangeLog

aclocal $ACLOCAL_FLAGS || exit 1;
#automake --gnu --add-missing --copy || exit 1;
#intltoolize --copy --force --automake
autoconf || exit 1;
if test "x$NOCONFIGURE" = "x"; then
    eval `echo ./configure $new_args $old_args`
else
    echo "Skipping configure process."
fi
