names=radio_group
visibility=public
kind=defined

--- radio_group(name = "", *values) -> String
タイプが radio である input 要素のリストを生成します。

生成される input 要素の name 属性はすべて同じになり、
それぞれの input 要素の後ろにはラベルが続きます。

@param name name 属性の値を指定します。

@param values value 属性のリストを指定します。
              それぞれの引数が、単純な文字列の場合、value 属性の値とラベルに同じものが使用されます。
              それぞれの引数が、二要素または三要素の配列の場合、最終要素が true であれば、
              checked 属性をセットします。先頭の要素は value 属性の値になります。

例:
  radio_group("name", "foo", "bar", "baz")
    # <INPUT TYPE="radio" NAME="name" VALUE="foo">foo
    # <INPUT TYPE="radio" NAME="name" VALUE="bar">bar
    # <INPUT TYPE="radio" NAME="name" VALUE="baz">baz
  
  radio_group("name", ["foo&quot;], ["bar", true], "baz")
    # <INPUT TYPE="radio" NAME="name" VALUE="foo">foo
    # <INPUT TYPE=&quot;radio" CHECKED NAME="name" VALUE="bar">bar
    # <INPUT TYPE="radio" NAME="name" VALUE="baz">baz
  
  radio_group("name", ["1", "Foo"], ["2", "Bar", true], "Baz")
    # <INPUT TYPE="radio" NAME="name" VALUE="1">Foo
    # <INPUT TYPE="radio" CHECKED NAME="name" VALUE="2">Bar
    # <INPUT TYPE="radio" NAME="name" VALUE="Baz">Baz
  
--- radio_group(attributes) -> String
タイプが radio である input 要素のリストを生成します。

生成される input 要素の name 属性はすべて同じになり、
それぞれの input 要素の後ろにはラベルが続きます。

@param attributes 属性をハッシュで指定します。

例:
  radio_group({ "NAME" => "name",
                "VALUES" => ["foo", "bar", "baz"] })
  
  radio_group({ "NAME" => "name",
                "VALUES" => [["foo"], ["bar", true], "baz"] })
  
  radio_group({ "NAME" => "name",
                "VALUES" => [["1", "Foo"], ["2", "Bar", true], "Baz"] })

