names=popup_menu,scrolling_list
visibility=public
kind=defined

--- popup_menu(name = "", *values) -> String
--- scrolling_list(name = "", *values) -> String

select 要素を生成します。

@param name name 属性の値を指定します。

@param values option 要素を生成するための情報を一つ以上指定します。
              それぞれ、文字列、一要素、二要素、三要素の配列を指定することができます。
              文字列か一要素の配列である場合は、value 属性の値と option 要素の内容になります。
              三要素の配列である場合は、順に value 属性の値、option 要素の内容、その option 要素が
              選択状態かどうかを表す真偽値となります。
       
        例：
        popup_menu("name", "foo", "bar", "baz")
          # <SELECT NAME="name">
          #   <OPTION VALUE="foo">foo</OPTION>
          #   <OPTION VALUE="bar">bar</OPTION>
          #   <OPTION VALUE="baz">baz</OPTION>
          # </SELECT>

        popup_menu("name", ["foo"], ["bar", true], "baz")
          # <SELECT NAME="name">
          #   <OPTION VALUE="foo">foo</OPTION>
          #   <OPTION VALUE="bar" SELECTED>bar</OPTION>
          #   <OPTION VALUE="baz">baz</OPTION>
          # </SELECT>

        popup_menu("name", ["1", "Foo"], ["2", "Bar", true], "Baz")
          # <SELECT NAME="name">
          #   <OPTION VALUE="1">Foo</OPTION>
          #   <OPTION SELECTED VALUE="2">Bar</OPTION>
          #   <OPTION VALUE="Baz">Baz</OPTION>
          # </SELECT>

--- popup_menu(attributes) -> String
--- scrolling_list(attributes) -> String

select 要素を生成します。

@param attributes 属性をハッシュで指定します。

例:
        popup_menu({"NAME" => "name", "SIZE" => 2, "MULTIPLE" => true,
                    "VALUES" => [["1", "Foo"], ["2", "Bar", true], "Baz"] })
          # <SELECT NAME="name" MULTIPLE SIZE="2">
          #   <OPTION VALUE="1">Foo</OPTION>
          #   <OPTION SELECTED VALUE="2">Bar</OPTION>
          #   <OPTION VALUE="Baz">Baz</OPTION>
          # </SELECT>

