= profile.rb

Ruby プログラムのためのプロファイラです。プロファイラとは効率改善のた
めの調査に用いられるツールのことで、profile.rbは各メソッドの実行時間に
関する統計を出力します。((-profile.rb はそれ自身がオーバーヘッドになる
ためメソッド呼び出しあたりの処理時間がかなり遅くなります。
((<RAA:RbProf>)) というのがあり、こちらの方が速いようです-))

== 使い方:

  $ ruby -r profile foo.rb

実行が終ると標準エラー出力にプロファイルを出力します。

プロファイルは各メソッドの実行時間に関する統計からなりますが、この時間
には大きく分けて2種類あります。ひとつは、メソッドが呼び出されてから返
るまでの時間です。もうひとつは、全体の時間からそのメソッド内で行なわれ
た他の呼び出しに費やしたすべての時間を引いた時間です。以下の説明では前
者を((*全体時間*))、後者を((*正味時間*))と呼ぶことにします。

== 出力の意味

プロファイルの結果は例えば次のようになります。

    $ ruby -r profile sample/sieve.rb 1000
    2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47 … 略 …
      %   cumulative   self              self     total
     time   seconds   seconds    calls  ms/call  ms/call  name
     33.87     1.49      1.49       11   135.65   214.49  Fixnum#step
     31.38     2.88      1.38     2410     0.57     0.57  Array#[]=
     27.84     4.10      1.23        2   613.28  2070.31  Range#each
      4.26     4.29      0.19        1   187.50   234.38  Array#join
      1.06     4.34      0.05      168     0.28     0.28  Fixnum#to_s
      0.35     4.35      0.02       31     0.50     0.50  Fixnum#+
    … 以下略 …

おのおのの行に現れる各フィールドの意味は左から順に次の通りです。

  (1) 全体時間のパーセンテージ
  (2) 全体時間の総和(単位は秒)
  (3) 正味時間の総和(秒)
  (4) 呼び出された回数
  (5) 1回の呼び出し当たりの平均正味時間(ミリ秒)
  (6) 1回の呼び出し当たりの平均全体時間(ミリ秒)
  (7) メソッド名

