= curses.so

端末操作ライブラリ curses の Ruby インターフェイスです。

*((<curses.so/Curses モジュール>))
*((<curses.so/Curses::Window クラス>))

== Curses モジュール

=== モジュール関数

: init_screen
  スクリーンを curses のために初期化します。
  (({Curses})) モジュールのすべてのメソッドはこのメソッドを
  呼び出してからでないと使えません。

: close_screen
  curses スクリーンを閉じます。これ以後 (({Curses})) モジュール
  のメソッドを呼び出すとすべて例外になります。

: stdscr
  画面全体を表す (({Curses::Window})) オブジェクトを返します。

: refresh
  stdscr の表示を更新します。

: doupdate
  ？

: clear
  (({stdscr})) の文字を消去します。
  この消去は (({refresh})) を待たずにすぐ実行されます。

: echo
  入力のエコーを有効にします。

: noecho
  入力のエコーをやめます。

: cbreak
: crmode
  キーボード入力のバッファリングをやめます。

: nocbreak
: nocrmode
  キーボード入力のバッファリングを有効にします。

: nl
  cooked モードのとき、return キーの入力に対して
  LF (Ctrl-j) を返すようにします。

: nonl
  cooked モードのとき、return キーの入力に対して
  CR (Ctrl-m) を返すようにします。

: raw
  キーボード入力のバッファリングと Ctrl-C などの
  特殊キーの処理をやめます (raw モード)。

: noraw
  キーボード入力のバッファリングと Ctrl-C など
  特殊キーの処理を行うようにします (cooked モード)。

: beep
  音を出します。
  この機能がないところでは単に無視されます。

: flash
  画面を一瞬点滅させます。
  この機能がないところでは単に無視されます。

: getch
  標準入力から 1 バイト読み込みます。
  戻り値は ASCII コードを表す整数です。

: getstr
  標準入力から一行読み込みます。
  戻り値は文字列です。

  このメソッドは (({getnstr()})) が実装されていない
  プラットホームではバッファオーバーフローをおこす恐れが
  あります。

: ungetch(ch)
  文字 ((|ch|)) (ASCII コードを示す整数) をストリームに戻します。

: setpos(y, x)
  (({stdscr})) のカーソルを座標 (x,y) に移動します。
  座標はともに 0 が始点です。

  文字がない場所に (({setpos})) した場合の挙動は OS に依存します。

: standout
  以降書き込む文字を強調します。
  「強調」は反転であることが多いようですが、
  そう決められているわけではありません。

: standend
  強調する文字の書き込みを終えます。

: addch(ch)
  stdscr のカーソルの位置に ((|ch|)) (1 バイト) を上書きします。

: insch(ch)
  stdscr のカーソルの位置に ((|ch|)) (1 バイト) を挿入します。

: addstr(str)
  stdscr のカーソルの位置に文字列 str を挿入します。

: delch
  stdscr のカーソルの位置から 1 バイト削除します。

: deleteln
  stdscr のカーソルがある行を削除し、後の行を上に詰めます。

: lines
  画面に表示可能な行数を返します。

: cols
  画面に表示可能な桁数(バイト)を返します。
  ただし実際にはもう 1 バイト少なくしか表示できないライブラリが
  あるようです。

: inch
  stdscr のカーソル位置から 1 バイト読みとって返します。

== Curses::Window クラス

=== クラスメソッド

: new(height, width, y, x)
  画面の座標 (x,y) を左上端とし、幅 ((|width|))
  高さ ((|height|)) とする curses のトップレベルウィンドウを
  作成し、それを表現する (({Curses::Window})) オブジェクトを
  返します。

=== メソッド

: subwin(height, width, y, x)
  画面の座標 (x,y) を左上端とし、幅 ((|width|))
  高さ ((|height|)) とするサブウィンドウを作成し、
  それを表現する (({Curses::Window})) オブジェクトを返します。

: close
  ウィンドウを閉じます。以降のこのウィンドウオブジェクトに
  対する操作は例外を発生します。

: clear
  ウィンドウの表示を消去します。
  この操作は即座に実行されます。

: refresh
  ウィンドウの表示を更新します。

: box(ver_char, hor_char)
  縦の線に ((|ver_char|))、横の線に ((|hor_char|)) を使い
  ウィンドウに沿って箱を書きます。線は普通にウィンドウ内に
  書かれるだけなので上書きしないよう注意してください。

: move(y, x)
  ウィンドウを (x,y) に移動します。

  親ウィンドウからはみだす位置を指定すると無視されます。

: setpos(y, x)
  ウィンドウ内の (x,y) にカーソルを移動します。

: cury
  ウィンドウ内におけるカーソルの行番号を返します。
  一行目が 0 です。

: curx
  ウィンドウ内におけるカーソルの桁番号を返します。
  一桁目が 0 です。

: maxy
  移動可能な最大の y 座標を返します。
  表示可能な行 + 1 です。

: maxx
  移動可能な最大の x 座標を返します。
  表示可能なバイト数 + 1 です。

: begy
  親ウィンドウの中でウィンドウの左上がある y 座標を返します。
  始点は 0 です。

: begx
  親ウィンドウの中でウィンドウの左上がある x 座標を返します。
  始点は 0 です。

: standout
  以後書き込む文字を強調表示します。

: standend
  強調書き込みを終了します。

: inch
  ウィンドウのカーソル位置から 1 バイト読みとって返します。

: addch(ch)
  ウィンドウのカーソル位置に ((|ch|)) (1 バイト) を上書きします。

: insch(ch)
  ウィンドウのカーソル位置に ((|ch|)) (1 バイト) を挿入します。

: addstr(str)
: self << str
  ウィンドウのカーソル位置に文字列 ((|str|)) を上書きします。

: getch
  ウィンドウへの入力から 1 バイト読みこみます。

: getstr
  ウィンドウへの入力から一行読みこみます。

: delch
  ウィンドウのカーソル位置から 1 バイト消去します。

: deleteln
  ウィンドウの、カーソルがある行を消去します。
