= Zlib::GzipReader

((<zlib.so>))

gzip 形式の圧縮ファイルを読み込むラッパークラス。
IO クラスのインスタンス (又は IO クラスのインスタンスと同じメソッドを
持つオブジェクト) と関連付けて使用します。

    Zlib::GzipReader.open('hoge.gz') {|gz|
      print gz.read
    }

    f = File.open('hoge.gz')
    gz = Zlib::GzipReader.new(f)
    print gz.read
    gz.close

== スーパークラス:

* ((<Zlib::GzipFile>))

== インクルードしているモジュール:

* Enumerable

== クラスメソッド:

--- GzipReader.new(io)

    ((|io|)) と関連付けられた GzipReader オブジェクトを作成します。
    GzipReader オブジェクトは ((|io|)) からデータを逐次リードして
    解析/展開を行います。((|io|)) には少なくとも、IO#read と
    同じ動作をする read メソッドが定義されている必要があります。

    ヘッダーの解析に失敗した場合 Zlib::GzipFile::Error 例外が
    発生します。

--- GzipReader.wrap(io) {|gz| ... }

    ((|io|)) と関連付けられた GzipReader オブジェクトを作成し、
    それを引数としてブロックを実行します。
    ブロックの実行が終了すると、GzipReader オブジェクトは自動的に
    クローズされます。関連付けられている IO オブジェクトまで
    クローズしたくない時は、ブロック中で ((<Zlib::GzipFile#finish|Zlib::GzipFile/finish>))
    メソッドを呼び出して下さい。

--- GzipReader.open(filename)
--- GzipReader.open(filename) {|gz| ... }

    ((|filename|)) で指定されるファイルを gzip ファイルとして
    オープンします。GzipReader オブジェクトを返します。
    その他詳細は ((<Zlib::GzipReader.new|Zlib::GzipReader/new>)) や ((<Zlib::GzipReader.wrap|Zlib::GzipReader/wrap>)) と
    同じです。

== メソッド:

--- eof
--- eof?

    圧縮データの終端に達した場合真を返します。
    フッターが読み込まれていなくても真を返すことに注意して下さい。

--- pos
--- tell

    現在までに展開したデータの長さの合計を返します。
    ファイルポインタの位置ではないことに注意して下さい。

--- each([rs])
--- each_line([rs])
--- each_byte([rs])
--- gets([rs])
--- getc
--- lineno
--- lineno=
--- read([length])
--- readchar
--- readline([rs])
--- readlines([rs])
--- readpartial(maxlen[, outbuf])
--- ungetc(char)

    IO クラスの同名メソッドと同じですが、gzip ファイル中に
    エラーがあった場合 ((<Zlib::Error>)) 例外や
    Zlib::GzipFile::Error 例外が発生します。

    gzip ファイルのフッターの処理に注意して下さい。
    gzip ファイルのフッターには圧縮前データのチェックサムが
    記録されています。GzipReader オブジェクトは、次の時に展開した
    データとフッターの照合を行い、エラーがあった場合は
    Zlib::GzipFile::NoFooter, Zlib::GzipFile::CRCError,
    Zlib::GzipFile::LengthError 例外を発生させます。

    * EOF (圧縮データの最後) を越えて読み込み要求を受けた時。
      すなわち ((<Zlib::GzipReader/read>)),
      ((<Zlib::GzipReader/gets>)) メソッド等が nil を返す時。

    * EOF まで読み込んだ後、((<Zlib::GzipFile#close|Zlib::GzipFile/close>)) メソッドが
      呼び出された時。

    * EOF まで読み込んだ後、((<Zlib::GzipReader#unused|Zlib::GzipReader/unused>)) メソッドが
      呼び出された時。

--- rewind

    ファイルポインタを ((<Zlib::GzipReader/GzipReader.new>)) を呼び出した直後の
    時点に戻します。関連付けられている IO オブジェクトに
    seek メソッドが定義されている必要があります。

--- unused

    gzip フォーマットの解析のために読み込んだ余剰のデータを返します。
    gzip ファイルが最後まで解析されていない場合は nil を返します。

