= OptionParser

((<optparse.rb>))
((<optparse::チュートリアル>))
((<執筆者募集>))

コマンドラインのオプションを取り扱うためのクラスです。
オプションが指定された時に呼ばれるブロックを ((<OptionParser#on|OptionParser/on>)) メソッドで
登録していきます。つまり、
OptionParser を使う場合、基本的には

(1) OptionParser オブジェクト opt を生成する。
(2) オプションを取り扱うブロックを opt に登録する。
(3) opt.parse(ARGV) でコマンドラインを実際に parse する。

というような流れになります。

  require "optparse"
  ProgramConfig = Hash.new
  opts = OptionParser.new
  opts.on("-a"){|v| ProgramConfig[:a] = true } # -a オプションがコマンドラインで指定されていた場合の動作。
  opts.parse!(ARGV)                            # 実際にコマンドラインの parse を行う。

== デフォルトで利用可能なオプション
以下はデフォルトで利用可能なオプションです。オプションサマリには
出てきません。
--- --help
    オプションサマリを表示します。
--- --version
    定数 (({::Version})) が定義されていたら、それを表示します。

== クラスメソッド

--- OptionParser.new(banner=nil, width=32, indent = ' '*4)
--- OptionParser.new(banner=nil, width=32, indent = ' '*4) {|opt| ...}
    OptionParser オブジェクトを生成します。
    banner にはヘルプ(サマリ)の最初の部分に表示されるアプリケーションの説明
    などを文字列として与えます。
    width にはサマリの幅を数値で与えます。indent にはサマリのインデント
    を文字列として与えます。
    
    ブロックが与えられた場合、生成した OptionParser オブジェクトを引数としてブロックを評
    価します。つまり、以下のような書き方が可能です。
    
      require 'optparse'
      OptionParser.new do |opt|
      
        opt.on('-a') {|v| p v }
        opt.on('-b') {|v| p v }
        
        opt.parse!(ARGV)
      end

--- OptionParser.accept(klass, pat = /.*/){|str| ...}
    オプションの引数を文字列から Ruby のオブジェクトに変換するための
    ブロックを登録します。すべての OptionParser インスタンスに共通です。
    klass にはクラスオブジェクトを与えます。pat には match メソッドを持ったオブジェクト
    (Regexp オブジェクトなど)を与えます。
    
    ブロックには、文字列から klass のインスタンスを生成して返すものを指定します。
    
    ((<OptionParser#on|OptionParser/on>)) で klass を指定した場合、
    コマンドラインのオプションに与えられた引数はこの accept で登録したブロックで
    klass のインスタンスに変換されてから、
    OptionParser#on で登録したブロックに渡されます。
    
      require "optparse"
      OptionParser.accept(Time) do |s,|
        begin
          Time.parse(s) if s
        rescue
          raise OptionParser::InvalidArgument, s
        end
      end
      
      opts = OptionParser.new
      
      opts.on("-t", "--time [TIME]", Time) do |time|
        p time.class #=> Time
      end
      
      opts.parse!(ARGV) 

    いくつかのクラスに対しては変換用のブロックがデフォルトで登録されて
    います。((<OptionParser/デフォルトで利用可能な引数クラス>))を参照
    して下さい。

--- OptionParser.reject(klass)
    accept で登録したブロックを削除します。

== インスタンスメソッド

--- accept(klass, pat = /.*/){|str| ...}
    OptionParser.accept と同様ですが、登録したブロックはレシーバーに限定されます。

--- reject(klass)
    accept で登録したブロックを削除します。

--- banner
--- banner= heading
    サマリの最初の部分を設定します。

--- summary_width
--- summary_width= width
    サマリを表示するときの幅を数値で設定します。

--- summary_indent
--- summary_indent= indent
    サマリを表示する時のインデントを文字列で設定します。

--- program_name
--- program_name= name
    プログラムの名前を文字列で設定します。デフォルトは (({$0})) が使わ
    れます。

--- version
--- version= ver
    プログラムのバージョンを設定します。

--- release
--- release= rel
    Release code.

--- ver    
    (({program_name}))、(({version})) と (({release})) から生成したバー
    ジョンを表す文字列を返します。

--- summarize(to = [], width = @summary_width, max = width - 1, indent= @summary_indent) 
--- summarize(to = [], width = @summary_width, max = width - 1, indent= @summary_indent) {|line| ... }
    サマリを ((|to|)) へと加えていきます。
    ((|to|)) には ((|<<|)) メソッドが定義されたオブジェクトを与えます。
    デフォルトは (({[]})) です。
    ((|width|)) にはサマリの幅を数値で与えます。デフォルトは self.summary_width です。
    サマリの最大幅を数値で与えます。デフォルトは (({self.summary_width - 1}))です。
    ((|indent|)) にはサマリのインデントを文字列で与えます。デフォルトは 
    ((|self.summary_indent|)) です。
    
    ブロックが与えられた場合、サマリの各行を引数としてブロックを評価します。
    この場合、ブロックの中で明示的に ((|to|)) へと加えていかない限り、
    ((|to|)) にサマリが加えられることはありません。

--- help
--- to_s
    サマリの文字列を返します。

--- to_a
    サマリの各行を要素とした配列を返します。

--- separator(str)
    サマリを表示する時に、オプションを区切るためのメソッド。オプションにいくつかの種類がある場合に、サマリがわかりやすくなる。   
    区切りとして引数 str が表示される。サマリには on メソッドを呼んだ順にオプションが表示されるので、
    区切りを挿入したいところで separator を呼ぶ。((<例|optparse.rb/Example>))を参照。

--- on(short [, klass [, pat [, desc]]]) {|v| ...}
--- on(long  [, klass [, pat [, desc]]) {|v| ...}
--- on(short, long [, klass [, pat [, desc]]]) {|v| ...}

    オプションを取り扱うためのブロックを登録します。
    
    short にはショートオプションを表す文字列を与えます。
    そのオプションが引数をとらない場合は、
      on("-x"){|boolean| ...}
    となります。コマンドラインにオプションが存在した場合 true を引数と
    してブロックを評価します。
    ショートオプションが引数をとる場合は、
      on("-x MANDATORY"){|val| ...}
    となります。"MANDATORY" の部分は任意の文字列で構いません。
    オプションの引数が必須でない場合は [] をつけて、
      on("-x [OPTIONAL]"){|val| ...}
    となります。
    
    long にはロングオプションを表す文字列を与えます。ショートオプショ
    ンの時と同様に、
      on("--long"){|boolean| ...}
      on("--long MANDATORY"){|val| ...}
      on("--long [OPTIONAL]"){|val| ...}
    と指定できます。
    
    ショートオプションとロングオプションを同時に登録することもできます。
      opts.on("-r", "--require LIBRARY"){|lib| ...}
    これは以下と同値です。
      opts.on("-r LIBRARY"){|lib| ...}
      opts.on("--require LIBRARY"){|lib| ...}
      
    klass にはクラスを与えます。    
    どのようなクラスを受け付けるかは、
    ((<OptionParser/デフォルトで利用可能な引数クラス>))を参照して下さ
    い。OptionParser.accept や OptionParser#accept によって、受け付け
    るクラスを増やすことができます。登録されていないクラスが指定された
    場合、例外 ArgumentError を投げます。
    
    オプションの引数は accept で登録したブロックで klass のインスタンス
    に変換されてから、ブロックに渡されます。

      opts.on("-w", "--width N", Integer){|w| 
        p w.class #=> Integer
      }
      # ruby command --width=32

      opts.on("-o", "--overwrite VALUE", TrueClass){|boolean| ...}
      # ruby command --overwrite yes
      
    klass には可能な引数を列挙した配列やハッシュを
    与えることもできます。
      opts.on("--protocol VALUE", [:http, :ftp, :https]){|w| 
        p w
      }
      # ruby command --protocol=http #=> :http
      
      opts.on("-c", "--charset VALUE", {"jis" => "iso-2022-jp", "sjis" => "shift_jis"}){|w| 
        p w
      }
      # ruby command --charset=jis #=> "iso-2022-jp"
      
    コマンドに与えられた引数が配列やハッシュに含まれない場合、
    例外 OptionParser::InvalidArgument が parse 実行時に投げられます。
    
    pat にはオプションの引数に許すパターンを表す正規表現で与えます。
    コマンドに与えられた引数がパターンにマッチしない場合、
    例外 OptionParser::InvalidArgument が parse 実行時に投げられます。
      opts.on("--username VALUE", /[a-zA-Z0-9_]+/){|name| ...}
      # ruby command --username=ruby_user
      # ruby command --username=ruby.user #=> Error
      
    desc にはオプションの説明を文字列で与えます。
    サマリに表示されます。
    
--- on_head(short [, long [, klass [, pat [, desc]]]]) {...}
--- on_tail(short [, long [, klass [, pat [, desc]]]]) {...}
    
    ((<OptionParser#on|OptionParser/on>))と同様の働きをします。
    on メソッドと違う点は、OptionParser オブジェクトが保持している
    リストの最初かあるいは最後にブロックを登録する点です。
    
    --version や --help の説明をサマリの最後に表示したい時に便利です。
      
      opts.on_tail("-h", "--help", "Show this message") do
        puts opts
        exit
      end
      
      opts.on_tail("--version", "Show version") do
        puts OptionParser::Version.join('.')
        exit
      end

--- order(*argv)
--- order(*argv){|s| ...}
--- order!(argv = ARGV)
--- order!(argv = ARGV) {|s| ...}
    
    与えられた ((|argv|)) を順番にパースします。
    オプションではないコマンドの引数(下の例で言うと somefile)に出会うと、パースを中断します。
    ブロックが与えられている場合は、パースを中断せずに
    引数をブロックに渡してブロックを評価し、パースを継続します。argv を返します。
    
    order! は与えられた ((|argv|)) を破壊的にパースします。
    ((|argv|)) からオプションがすべて取り除かれます。
    
      $ cat opt.rb
      require 'optparse'
      opt = OptionParser.new
      
      opt.on('-a [VAL]') {|v| p :a }
      opt.on('-b') {|v| p :b }
      
      opt.order!(ARGV)
      p ARGV
      
      $ ruby opt2.rb -a foo somefile -b
      :a
      ["somefile", "-b"]
      
    コマンドの引数 somefile よりも後ろにオプションを置くことができま
    せん。-b もコマンドのオプションではない引数として扱われてしまいます。

--- permute(*argv)
--- permute!(argv = ARGV)
    
    与えられた ((|argv|)) をパースします。
    オプションではないコマンドの引数(下の例で言うと somefile)があってもパースを中断しません。
    オプションでない引数の配列を返します。
    
    permute! は与えられた ((|argv|)) を破壊的にパースします。
    ((|argv|)) からオプションがすべて取り除かれます

      $ cat opt.rb
      require 'optparse'
      opt = OptionParser.new
      
      opt.on('-a [VAL]') {|v| p :a }
      opt.on('-b ') {|v| p :b }
      
      opt.permute!(ARGV)
      p ARGV
      
      $ ruby opt2.rb -a foo somefile -b
      :a
      :b
      ["somefile"]
            
    order と違いコマンドの引数 somefile よりも後ろにオプションを置くことが
    できます。

--- parse(*argv)
--- parse!(argv = ARGV)
    
    与えられた ((|argv|)) をパースします。
    permute と同様に振舞います。しかし、
    環境変数に (({POSIXLY_CORRECT})) が設定されている場合は、
    order と同様に振舞います。
    
    parse! は permute! と同様に ((|argv|)) を破壊的にをパースします。
    環境変数に (({POSIXLY_CORRECT})) が設定されている場合は、
    order! と同様に振舞います。

--- load(filename)
    
    file を読み込んで各行に対して parse を行ないます。

--- environment(env)
    
    環境変数 env に対して
    ((<Shellwords.shellwords|Shellwords/Shellwords.shellwords>)) を呼
    んで配列にしてから parse を行ないます。

== デフォルトで利用可能な引数クラス


: Object
  any string, and no conversion. this is fall-back.

: String
  any none-empty string, and no conversion.

: Integer
  Ruby/C-like integer, octal for (({0-7})) sequence, binary for
  (({0b})), hexadecimal for (({0x})), and decimal for others; with
  optional sign prefix. Converts to (({Integer})).

: Float
  Float number format, and converts to (({Float})).

: Numeric
  Generic numeric format, and converts to (({Integer})) for integer
  format, (({Float})) for float format.

: OptionParser::DecimalInteger
  Decimal integer format, to be converted to (({Integer})).

: OptionParser::OctalInteger
  Ruby/C like octal/hexadecimal/binary integer format, to be converted
  to (({Integer})).

: OptionParser::DecimalNumeric
  Decimal integer/float number format, to be converted to
  (({Integer})) for integer format, (({Float})) for float format.

: TrueClass
  Boolean switch, which means whether it is present or not, whether it
  is absent or not with prefix (({no-})), or it takes an argument
  (({yes/no/true/false/+/-})).
: FalseClass
  Similar to ((<optparse.rb/TrueClass>)), but defaulted to (({false})).

: Array
  List of strings separated by ","

== 例外

=== OptionParser::ParseError
OptionParser の例外クラスの基底クラスです。

=== OptionParser::AmbiguousOption
補間が曖昧にしかできないオプションがあった場合に投げられます。
スーパークラスは OptionParser::ParseError です。

=== OptionParser::NeedlessArgument
引数を取らないはずのオプションに引数が与えられた場合に
投げられます。スーパークラスは OptionParser::ParseError です。

=== OptionParser::MissingArgument 
引数が必要なオプションに引数が与えられなかった場合に
投げられます。スーパークラスは OptionParser::ParseError です。

=== OptionParser::InvalidOption
定義されていないオプションが与えられた場合に、
投げられます。スーパークラスは OptionParser::ParseError です。

=== OptionParser::InvalidArgument
オプションの引数が指定されたパターンにマッチしない時に投げられます。
スーパークラスは OptionParser::ParseError です。

=== OptionParser::AmbiguousArgument
オプションの引数が曖昧にしか補間できない場合に投げられます。
スーパークラスは OptionParser::InvalidArgument です。



