= OpenSSL::X509::Certificate

X509 証明書クラス

== クラスメソッド:

--- Certificate.new()
--- Certificate.new(str)
--- Certificate.new(io)
    証明書オブジェクトを生成する。

== メソッド

--- to_der

    DER 形式に変換する。

--- to_pem
--- to_s
    PEM 形式に変換する。

--- to_text
    人間が読める形式に変換する。

--- version
--- version=
    X509 証明書の version。 v1の場合は 0 、v3 の場合は 2 となる。

--- signature_algorithm
    発行者(CA)が証明書に署名するのに使ったアルゴリズム。

--- serial
--- serial=
    発行者(CA)が証明書に付ける識別番号。

--- subject
--- subject=
    証明書の所有者の名前 ((<OpenSSL::X509::Name>)) オブジェクト。
    http://www.ipa.go.jp/security/pki/033.html#_Toc3020767

--- issuer
--- issuer=
    証明書の発行者(CA)の名前 ((<OpenSSL::X509::Name>)) オブジェクト。

--- not_before
--- not_before=
    証明書が有効になる時刻 ((<Time>)) オブジェクト。

--- not_after
--- not_after=
    証明書が無効になる時刻 ((<Time>)) オブジェクト。

--- extensions
--- extensions=
    証明書の拡張領域 ((<OpenSSL::X509::Extension>)) オブジェクトの ((<Array>))。

--- add_extension(ext)
    拡張領域に値を加える。ext は ((<OpenSSL::X509::Extension>)) オブジェクト。

--- public_key
--- public_key=
    証明書に記載された公開鍵 ((<OpenSSL::PKey::RSA>)) オブジェクト。

--- sign(pkey, digest)
    証明書に署名する。pkey は発行者の秘密鍵。digest は        
    ((<OpenSSL::Digest::Digest>)) オブジェクト。秘密鍵オブジェクトが   
    ((<OpenSSL::PKey::DSA>)) のインスタンスである場合、 digest は OpenSSL::Digest::DSS1 
    オブジェクトでなければいけない。逆も同じ。OpenSSL::Digest::DSS1 は 
    OpenSSL::PKey::DSA 以外のダイジェストとして使えない。

--- verify(key)
    key は証明書の発行者の公開鍵。 key で証明書の署名を検証する。

--- check_private_key(pkey)
    与えられた秘密鍵が証明書に記載されている subject の公開鍵と対応するものかを確かめる。
