= OpenSSL::PKCS7

PKCS #7 モジュール 

((<OpenSSL::PKCS7::PKCS7>)) も参照。

== モジュールメソッド

--- PKCS7.read_smime(str)
--- PKCS7.read_smime(io)
    S/MIME 形式を読み込み、PKCS7 オブジェクトを返す。

--- PKCS7.write_smime(p7sig)
--- PKCS7.write_smime(p7sig, data, flags=DETACHED)
    PKCS7 オブジェクトから S/MIME 形式の文字列を返す。
    multipart/signed による平文署名である場合、署名されたデータを data として与えなければいけない。

      data = "hoge"
      p7 = PKCS7.sign( X509::Certificate.new(File.read('cert.pem')), 
                       PKey::RSA.new(File.read('privkey.pem')), 
                       data)
      smime = PKCS7.write_smime(p7, data)

--- PKCS7.sign(cert, key, data, []=nil, flags=0)
    data に証明書 cert を付けて key で署名する。

--- PKCS7.encrypt([rcpt], smime)
    S/MIME 形式の文字列をメッセージの受け取り手の公開鍵 rcpt を使って暗号化する。

== 定数

--- DETACHED
    平文に署名を付ける形式(multipart/signed)で行う。 PKCS7.sign() において DETACHED がセットされていた時にだけ意味をもつ。

--- TEXT
    text/plain のためのコンテンツに MIME ヘッダーを加える。DETACHED ビットが立っている時だけ意味をもつ。

--- BINARY
    MIME canonical format への変換を行わない。

--- NOATTR
    署名した時間などの情報を省略。
--- NOCERTS
    署名者の証明書を署名に含めない。送り先がすでに証明書をもっている場合、データの量を減らすことができる。

--- NOCHAIN
--- NOINTERN
--- NOSIGS
--- NOSMIMECAP
    署名者が使用可能な暗号アルゴリズムの情報などを省略。
--- NOVERIFY
