= OpenSSL::Cipher::Cipher

対称鍵暗号のために抽象化されたインターフェースを提供するクラス。

以下が実装されているクラス。

* OpenSSL::Cipher::BF
* OpenSSL::Cipher::DES
* OpenSSL::Cipher::RC2
* OpenSSL::Cipher::RC4
* OpenSSL::Cipher::RC5

使用例。

   require 'openssl'
   
   p a123 = "0123456789"
   pass = "hogehoge"
   enc = OpenSSL::Cipher::DES.new
   enc.encrypt
   enc.pkcs5_keyivgen(pass)
   p a = enc.update(a123)
   p b = enc.final
   s = a + b
   
   dec = OpenSSL::Cipher::DES.new
   dec.decrypt
   dec.pkcs5_keyivgen(pass)
   p a = dec.update(s)
   p b = dec.final
   p a + b #=> "0123456789"

== クラスメソッド
--- Cipher.new(name)
--- Cipher.new()
    対称鍵暗号アルゴリズムの名前 name を与えると暗号オブジェクトを生成する。

  require 'openssl'
  include OpenSSL::Cipher
  c1 = Cipher.new("DES-EDE3-CBC")
  c2 = DES.new(:EDE3, "CBC")
  key = "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
  iv = key
  hexkey = "0000000000000000000000000000000000000000000000"
  hexiv = "0000000000000000"
  data = "DATA"
  c1.key = c2.key = key
  c1.iv = c2.iv = iv
  s1 = c1.encrypt.update(data) + c1.final
  s2 = c2.encrypt.update(data) + c2.final
  p(s1 == s2) #=> true

== メソッド
--- reset
    暗号、暗号鍵、暗号化復号化フラグを共にリセットする。

--- encrypt(pass, iv)
    暗号化の準備をする。iv は initialization vector、必要なら使用される。
    このAPIに引数を渡すのは推奨しない。パスワードから鍵を生成する場合は、
    pkcs5_keyivgenを使用すること。

--- decrypt(pass, iv)
    復号化の準備をする。iv は initialization vector、必要なら使用される。
    このAPIに引数を渡すのは推奨しない。パスワードから鍵を生成する場合は、
    pkcs5_keyivgenを使用すること。

--- update(data)
    与えられた文字列を暗号化あるいは復号化して文字列として返す。直前に呼ばれた encrypt あるいは decrypt により暗号化か復号化かが決まる。

--- final()
    ブロックに残っているデータを暗号化あるいは復号化する。final() を呼んだあとでは update を呼んではいけない。

--- key=
    暗号鍵。

--- key_len
--- key_len=
    暗号鍵の長さ。

--- iv=
    iv は initialization vector。

--- iv_len
    iv の長さを返す。

--- block_size
    ブロックのサイズを返す。

--- padding=
    パディングを設定する。

--- pkcs5_keyivgen(pass, salt=nil, num=2048, digest=OpenSSL::Digest::MD5.new())
    key と iv を生成し key= と iv= に設定する。
    salt は 8-octet string でないといけない。nil を返す。

== エラー

OpenSSL::Cipher::CipherError
