= Iconv

Iconv は UNIX 95 の (({iconv()})) 関数のラッパーで、
さまざまな文字コード体系間で文字列の変換を行ないます。

詳細は((<Open Group|URL:http://www.opengroup.org/>)) のオンラインドキュメントを
参照して下さい。
* ((<iconv.h|URL:http://www.opengroup.org/onlinepubs/007908799/xsh/iconv.h.html>))
* ((<iconv_open()|URL:http://www.opengroup.org/onlinepubs/007908799/xsh/iconv_open.html>))
* ((<iconv()|URL:http://www.opengroup.org/onlinepubs/007908799/xsh/iconv.html>))
* ((<iconv_close()|URL:http://www.opengroup.org/onlinepubs/007908799/xsh/iconv_close.html>))

どの文字コード体系が利用できるかはプラットフォーム依存です。さらにエンコーディング名をあらわす文字列もプラットフォーム依存です。日本語 EUC をあらわす文字列が EUC-JP, euc-jp, eucJP など異なる場合があります。このプラットフォームによる違いを吸収するために、
((<"ruby-src:ext/iconv/charset_alias.rb">)) が用意されています。 
GNU ソフトウェア ((<texinfo|URL:http://www.gnu.org/software/texinfo/>)) に含まれるファイル config.charset を以下のミラーサイトから手に入れて

((<URL:http://ring.pwd.ne.jp/archives/text/CTAN/macros/texinfo/texinfo/intl/config.charset>))

ext/iconv/ に置き、ext/iconv/ で次のように実行すると

 ruby extconf.rb
 make

iconv.rb が生成されます。この iconv.rb がプラットフォームによるエンコーディング名をあらわす文字列の違いを吸収します。

config.charset のライセンスは LGPL なので、生成された iconv.rb にも LGPL が適用されます。((-要調査-))

== 例

 require 'iconv'
 euc = ["a4a2a4a4a4a6a4a8a4aa"].pack("H*") # あいうえお
 sjis = ["82a082a282a482a682a8"].pack("H*")
 iconv = Iconv.new('SHIFT_JIS', 'EUC-JP')  # EUC-JP から SHIFT_JIS へ変換
 str = iconv.iconv(euc) 
 str << iconv.iconv(nil) 
 p( str == sjis )
 
(1) 新しく ((<Iconv>)) のインスタンスを作り, ((<Iconv/Iconv#iconv>)) メソッドを使う
      cd = Iconv.new(to, from)
      begin
        input.each {|s| output << cd.iconv(s)}
        output << cd.iconv(nil)      # don't forget this
      ensure
        cd.close
      end

(2) ((<Iconv/Iconv.open>)) をブロックつきで呼び出す
      Iconv.open(to, from) do |cd|
        input.each {|s| output << cd.iconv(s)}
        output << cd.iconv(nil)
      end

(3) (2) の短縮系
      Iconv.iconv(to, from, *input.to_a)

== Iconv クラス

=== クラスメソッド

--- Iconv.new(to, from)
    ((|from|)) から ((|to|)) への新しい変換器を作り、それを返します。
    ((|to|)) と ((|from|)) は変換先と変換前の文字コード体系です。

    このメソッドが起こす例外は次の通りです。
     *((|to|)) や ((|from|)) が String でないとき (({TypeError}))。
     *((|to|)) や ((|from|)) で指定された変換器が見つからないとき
      (({ArgumentError}))。
     *(({iconv_open(3)})) が失敗したとき(({SystemCallError}))。
        

--- Iconv.open(to, from) {|cd| ...}
    ブロックが与えられない場合は ((<Iconv/Iconv.new>)) と等価です。
    ブロックが与えられると、変換器を引数としてブロックを呼び、変換器を閉じて、
    ブロックの値を返します。

--- Iconv.iconv(to, from, *strs)
    次の省略形です。
      Iconv.open(to, from) {|cd| (strs + [nil]).collect {|s| cd.iconv(s)}}

    ((|to|)), ((|from|)) の意味は ((<Iconv/Iconv.new>)) と同じです。

    ((|strs|)) は変換される文字列です。

    このメソッドは
    ((<Iconv/Iconv.new>)), ((<Iconv/Iconv.open>)) および ((<Iconv/Iconv#iconv>)) の例外
    を起こします。

--- Iconv.conv(to, from, str)
    次の省略形です。
      Iconv.iconv(to, from, str).join

    ((<Iconv/Iconv.iconv>))参照。

--- Iconv.list {|*aliases| ... }    ((<ruby 1.9 feature>))
    Iterates each alias sets.
    ブロックが指定されていなければエンコーディング名のリストを返す。
    Iconv 標準の機能ではないのでサポートされるかはプラットフォームに依存する。
    サポートされていない場合は例外 NotImplementedError を投げる。

=== インスタンスメソッド

--- Iconv#close
    変換を終了します。

    このメソッドが呼ばれたあとで ((<Iconv/Iconv#iconv>)) が呼ばれると例外が
    起きますが、(({close})) 自体は繰返し呼ばれても成功します。

    値として、
    出力バッファを初期シフト状態に戻すためのバイト列を含む文字列を返します。

       i = Iconv.open("ISO-2022-JP", "EUC-JP")
       i.iconv("\264\301")     #=> "\e$B4A"
       i.iconv("\273\372")     #=> ";z"
       i.close                 #=> "\e(B"

--- Iconv#iconv(str, [ start = 0, [ length = -1 ] ])
    文字列の変換を開始し、変換後の文字列を返します。
    ((|str|)) が文字列の場合、(({str[start, length]})) を変換し、
    変換後の文字列を返します。

    ((|str|)) は変換される文字列または (({nil})) です。
    ((|start|)) は ((|str|)) のうち変換を開始するオフセットを指定します。
    ((|length|)) は ((|str|)) のうち変換する長さで、
    (({nil})) か (({-1})) のときは、(({start})) 以降全部を意味します。

    ((|str|)) が (({nil})) の場合、変換器をその初期シフト状態にし、
    出力バッファを初期シフト状態に戻すためのバイト列からなる文字列を返します。

    その他の場合は例外を起こします。

    このメソッドは起こす例外は
    ((<Iconv/Iconv::IllegalSequence>))、
    ((<Iconv/Iconv::InvalidCharacter>))、
    および ((<Iconv/Iconv::OutOfRange>))
    です。

== Iconv::Failure モジュール

((<Iconv>)) が起こす例外のためのモジュールです。

=== インスタンスメソッド

--- Iconv::Failure#success

    例外が起こるまでに変換に成功した文字列を返します。

    ((<Iconv/Iconv.iconv>)) でこの例外が起こったときに返される値は、
    以前の例外が例外が起こるまでに変換に成功した文字列を要素とする配列です。
    最後の要素は変換中の文字列です。

--- Iconv::Failure#failed

    ((<Iconv/Iconv>)) に渡された文字列のうち、
    例外が起こった位置からはじまる部分を返します。

--- Iconv::Failure#inspect

    #<(({type})): "(({success}))", "(({failed}))"> のような形をした
    文字列を返します。

== Iconv::IllegalSequence クラス

入力か出力の文字が指示された文字集合に含まれないために変換が停止したこと
を表します。

=== スーパークラス

(({ArgumentError}))

=== インクルードしているモジュール

((<Iconv/Iconv::Failure>))

== Iconv::InvalidCharacter クラス

入力の最後が不完全な文字かシフトで終っているために変換が停止したこと
を表します。

=== スーパークラス

(({ArgumentError}))

=== インクルードしているクラス

((<Iconv/Iconv::Failure>))

== Iconv::OutOfRange クラス

Iconv ライブラリの内部エラーです。この例外は起こらないはずです。

=== スーパークラス

(({RuntimeError}))

=== インクルードしているモジュール

((<Iconv/Iconv::Failure>))
