= Etc

(({/etc})) に存在するデータベースから情報を得るためのモジュール。
クラスにインクルードして使うこともできる。

== 使い方:

   require 'etc'
   p Etc.getlogin

== モジュール関数:

--- Etc.endgrent                ((<ruby 1.8 feature>))
--- Etc.endpwent                ((<ruby 1.8 feature>))
--- Etc.getgrent                ((<ruby 1.8 feature>))
--- Etc.getpwent                ((<ruby 1.8 feature>))
--- Etc.setgrent                ((<ruby 1.8 feature>))
--- Etc.setpwent                ((<ruby 1.8 feature>))

    ((<ruby 1.8 feature>))

--- Etc.getlogin
    自分の login 名を返す。得られなかった場合は nil を返す。

    このメソッドが失敗した場合は ((<Etc/Etc.getpwuid>)) に
    フォールバックするとよい。

--- Etc.getpwnam(name)
    passwd データベースを検索し、
    名前が ((|name|)) である passwd エントリを返す。
    戻り値は passwd 構造体で、以下のメンバを持つ。

      struct passwd
        name        # ユーザ名(文字列)
        passwd      # パスワード(文字列)
        uid         # ユーザID(整数)
        gid         # グループID(整数)
        gecos       # gecosフィールド(文字列)
        dir         # ホームディレクトリ(文字列)
        shell       # ログインシェル(文字列)
        # 以降のメンバはシステムによっては提供されない
        change      # パスワード変更時間(整数)
        quota       # クォータ(整数)
        age         # エージ(整数)
        class       # ユーザアクセスクラス(文字列)
        comment     # コメント(文字列)
        expire      # アカウント有効期限(整数)          
      end

    名前が ((|name|)) である passwd エントリがなかった場合、
    ArgumentError を発生する。

    詳細は ((<getpwnam(3)|manual page>)) を参照のこと。

--- Etc.getpwuid([uid])
    passwd データベースを検索し、
    ユーザ ID が ((|uid|)) である passwd エントリを返す。
    戻り値は ((<Etc/Etc.getpwnam>)) と同様である。
    引数を省略した場合には ((<getuid(2)|manual page>)) の値を用いる。

    詳細は ((<getpwuid(3)|manual page>)) を参照のこと。

--- Etc.getgrgid(gid)
    group データベースを検索し、グループ ID が ((|gid|))
    であるグループエントリを返す。
    戻り値は group 構造体で、以下のメンバを持つ。

      struct group
        name        # グループ名(文字列)
        passwd      # グループのパスワード(文字列)
        gid         # グループID(整数)
        mem         # グループメンバ名の配列
      end

    詳細は ((<getgrgid(3)|manual page>)) を参照のこと。

--- Etc.getgrnam(name)
    ((|name|)) という名前のグループエントリを返す。
    戻り値は ((<Etc/Etc.getgrgid>)) と同様である。

    詳細は((<getgrnam(3)|manual page>)) を参照のこと。

--- Etc.group
    全てのグループエントリを順にアクセスするためのイテレータ。

--- Etc.passwd
    全てのpasswdエントリを順にアクセスするためのイテレータ。
