= pathname.rb

== Pathname

パス名クラス

=== クラスメソッド:

--- Pathname.new(path)

    文字列 path を元に Pathname オブジェクトを生成する。

--- Pathname.getwd
--- Pathname.pwd

    Pathname.new(Dir.getwd)

--- Pathname.glob(*args)

    if block_given?
      Dir.glob(*args) {|f| yield Pathname.new(f) }
    else
      Dir.glob(*args).map {|f| Pathname.new(f) }
    end

=== メソッド:

--- self == other
--- self === other
--- eql?(other)

    パス名の比較。other と同じなら真を返す。大文字小文字は区別される。
    other は Pathname オブジェクトでなければならない。

    パス名の比較は単純にパス文字列の比較によって行われるので論理的に
    同じパスでも異なると判断される。

        require 'pathname'

        p Pathname.new("foo/bar") == Pathname.new("foo/bar")
        p Pathname.new("foo/bar") == Pathname.new("foo//bar")
        p Pathname.new("foo/../foo/bar") == Pathname.new("foo/bar")

        # => true
             false
             false

--- self <=> other

    パス名の比較。other と同じなら 0 を、ASCII順で self が大きい場合は
    正、other が大きい場合は負を返す。大文字小文字は区別される。

    other は Pathname オブジェクトでなければならない。

    パス名の比較は単純にパス文字列の比較によって行われるので論理的に
    同じパスでも異なると判断される。

        require 'pathname'

        p Pathname.new("foo/bar") <=> Pathname.new("foo/bar")
        p Pathname.new("foo/bar") <=> Pathname.new("foo//bar")
        p Pathname.new("foo/../foo/bar") <=> Pathname.new("foo/bar")
        => 0
           1
           -1

--- hash

    ハッシュ値を返す。

--- to_s
--- to_str

    パス名を文字列で返す。

    to_str は、File.open などの引数にそのまま Pathname オブジェクトを
    渡せるように用意してある。

        require 'pathname'

        path = Pathname.new("/tmp/hogehoge")
        File.open(path)

--- cleanpath(consider_symlink = false)

    余計な "."、".." や "/" を取り除いた新しい Pathname オブジェクトを返す。

        require "pathname"
        path = Pathname.new("//.././../")
        p path                  # => #<Pathname://.././../>
        p path.cleanpath        # => #<Pathname:/>

    consider_symlink が真ならパス要素にシンボリックリンクがあった場合
    にも問題ないように .. を残す。

    cleanpath は、実際にファイルシステムを参照することなく。文字列操作
    だけで処理を行う。

        require 'pathname'

        Dir.rmdir("/tmp/foo")      rescue nil
        File.unlink("/tmp/bar/foo") rescue nil
        Dir.rmdir("/tmp/bar")      rescue nil

        Dir.mkdir("/tmp/foo")
        Dir.mkdir("/tmp/bar")
        File.symlink("../foo", "/tmp/bar/foo")
        path = Pathname.new("bar/././//foo/../bar")

        Dir.chdir("/tmp")

        p path.cleanpath
        p path.cleanpath(true)

        => ruby 1.8.0 (2003-10-10) [i586-linux]
           #<Pathname:bar/bar>
           #<Pathname:bar/foo/../bar>

--- realpath(force_absolute = true)

    余計な "."、".." や "/" を取り除いた新しい Pathname オブジェクトを返す。

    ファイルシステムをアクセスし、実際に存在するパスを返す。
    シンボリックリンクも解決される。

    force_absolute が真の場合、絶対パスを返す。self が相対パスであれば、
    カレントディレクトリからの相対パスとして解釈される。

    self が指すパスが存在しない場合は例外 
    ((<Errno::ENOENT|Errno::EXXX>)) が発生する。

        require 'pathname'

        Dir.rmdir("/tmp/foo")      rescue nil
        File.unlink("/tmp/bar/foo") rescue nil
        Dir.rmdir("/tmp/bar")      rescue nil

        Dir.mkdir("/tmp/foo")
        Dir.mkdir("/tmp/bar")
        File.symlink("../foo", "/tmp/bar/foo")
        path = Pathname.new("bar/././//foo/../bar")

        Dir.chdir("/tmp")

        p path.realpath
        p path.realpath(false)

        => ruby 1.8.0 (2003-10-10) [i586-linux]
           #<Pathname:/tmp/bar>
           #<Pathname:bar>

--- parent

    self の親ディレクトリを指す新しい Pathname オブジェクトを返す。

--- mountpoint?

    self がマウントポイントであれば真を返す。

--- root?

    self がルートディレクトリであれば真を返す。判断は文字列操作によっ
    て行われ、ファイルシステムはアクセスされない。

--- absolute?

    self が絶対パス指定であれば真を返す。

--- relative?

    self が相対パス指定であれば真を返す。

--- each_filename {|v| ... ]

    self のパス名要素毎にブロックを実行する。

        require 'pathname'

        Pathname.new("/foo/../bar").each_filename {|v| p v}

        # => "foo"
             ".."
             "bar"

--- self + other

    パス名を連結する。つまり、other を self からの相対パスとした新しい 
    Pathname オブジェクトを生成して返す。

    other が絶対パスなら単に other を Pathname オブジェクトとして返す。

    other は文字列か Pathname オブジェクト。

--- children

    self 配下にあるパス名(Pathnameオブジェクト)の配列を返す。

        require 'pathname'

        p Pathname.new("/tmp").children
        => ruby 1.8.0 (2003-10-10) [i586-linux]
           [#<Pathname:.X11-unix>, #<Pathname:.iroha_unix>, ... ]

    ".", ".." は要素に含まれない。

    self が存在しないパスであったりディレクトリでなければ例外 
    ((<Errno::EXXX>)) が発生する。

--- relative_path_from(base_directory)

    base_direcoty から self への相対パスを求め Pathname オブジェクトを
    生成して返す。

    パス名の解決は文字列操作によって行われ、ファイルシステムをアクセス
    しない。

        require 'pathname'

        path = Pathname.new("/tmp/foo")
        base = Pathname.new("/tmp")

        p path.relative_path_from(base)

        # => ruby 1.8.0 (2003-10-10) [i586-linux]
             #<Pathname:foo>

    self が相対パスなら base_directory も相対パス、self が絶対パスなら 
    base_directory も絶対パスでなければならない。

    base_directory は Pathname オブジェクトでなければならない。

--- each_line(*args, &block)
    IO.foreach(self.to_s, *args, &block)

--- read(*args)
    IO.read(self.to_s, *args)

--- readlines(*args)
    IO.readlines(self.to_s, *args)

--- sysopen(*args)
    IO.sysopen(self.to_s, *args)

--- atime()
    File.atime(self.to_s)

--- ctime()
    File.ctime(self.to_s)

--- mtime()
    File.mtime(self.to_s)

--- chmod(mode)
    File.chmod(mode, self.to_s)

--- lchmod(mode)
    File.chmod(mode, self.to_s)

--- chown(owner, group)
    File.chown(owner, group, self.to_s)

--- lchown(owner, group)
    File.lchown(owner, group, self.to_s)

--- fnmatch(pattern, *args)
    File.fnmatch(pattern, self.to_s, *args)

--- fnmatch?(pattern, *args)
    File.fnmatch?(pattern, self.to_s, *args)

--- ftype()
    File.ftype(self.to_s)

--- link(old)
    File.link(old, self.to_s)

--- open(*args, &block)
    File.open(self.to_s, *args, &block)

--- readlink()
    Pathname.new(File.readlink(self.to_s))

--- rename(to)
    File.rename(self.to_s, to)

--- stat()
    File.stat(self.to_s)

--- lstat()
    File.lstat(self.to_s)

--- symlink(old)
    File.symlink(old, self.to_s)

--- truncate(length)
    File.truncate(self.to_s, length)

--- utime(atime, mtime)
    File.utime(atime, mtime, self.to_s)

--- basename(*args)
    Pathname.new(File.basename(self.to_s, *args))

--- dirname()
    Pathname.new(File.dirname(self.to_s))

--- extname()
    File.extname(self.to_s)

--- expand_path(*args)
    Pathname.new(File.expand_path(self.to_s, *args))

--- join(*args)
    Pathname.new(File.join(self.to_s, *args))

--- split()
    File.split(self.to_s)

--- blockdev?()
    FileTest.blockdev?(self.to_s)

--- chardev?()
    FileTest.chardev?(self.to_s)

--- executable?()
    FileTest.executable?(self.to_s)

--- executable_real?()
    FileTest.executable_real?(self.to_s)

--- exist?()
    FileTest.exist?(self.to_s)

--- grpowned?()
    FileTest.grpowned?(self.to_s)

--- directory?()
    FileTest.directory?(self.to_s)

--- file?()
    FileTest.file?(self.to_s)

--- pipe?()
    FileTest.pipe?(self.to_s)

--- socket?()
    FileTest.socket?(self.to_s)

--- owned?()
    FileTest.owned?(self.to_s)

--- readable?()
    FileTest.readable?(self.to_s)

--- readable_real?()
    FileTest.readable_real?(self.to_s)

--- setuid?()
    FileTest.setuid?(self.to_s)

--- setgid?()
    FileTest.setgid?(self.to_s)

--- size()
    FileTest.size(self.to_s)

--- size?()
    FileTest.size?(self.to_s)

--- sticky?()
    FileTest.sticky?(self.to_s)

--- symlink?()
    FileTest.symlink?(self.to_s)

--- writable?()
    FileTest.writable?(self.to_s)

--- writable_real?()
    FileTest.writable_real?(self.to_s)

--- zero?()
    FileTest.zero?(self.to_s)

--- rmdir()
    Dir.rmdir(self.to_s)

--- entries()
    Dir.entries(self.to_s)

--- each_entries(&block)
    Dir.foreach(self.to_s) {|f| yield Pathname.new(f) }

--- mkdir(*args)
    Dir.mkdir(self.to_s, *args)

--- opendir(&block)
    Dir.open(self.to_s, &block)

--- find(&block)

    require 'find'
    Find.find(self.to_s) {|f| yield Pathname.new(f) }

--- mkpath
    require 'fileutils'
    FileUtils.mkpath(self.to_s)

--- rmtree
    require 'fileutils'
    FileUtils.rm_r(self.to_s)

--- unlink
--- delete
    self が指すディレクトリあるいはファイルを削除する。
