= Process::UID

((<ruby 1.8 feature>))

ユーザ ID を操作するメソッドを集めたモジュール。
((<Process::GID>)) と同じメソッドが定義されています。

=== モジュール関数

--- rid

    現在の実ユーザ ID を返します。

--- eid

    現在の実効ユーザ ID を返します。

--- change_privilege(id)

    実ユーザ ID・実効ユーザ ID・保存ユーザ ID のすべてを
    放棄して他のユーザになります。成功したら id を返します。

    完全放棄できない場合 (一部ユーザ ID の変更ができない場合)
    は例外 ((<ArgumentError>)) が発生します。例外の発生時に
    このメソッドを呼び出す前の各ユーザ ID の値が保存されて
    いるかどうかは保証されません．

    ((<Process/Process.uid=>)) とは互換性がないことに注意してください．
    setreuid(id,-1) によって実装されていたものを用いていた場合、
    例えば次のように書き換える必要があります．

        Process::UID.re_exchange  # (r,e,s)==(u1,u2,??) ==> (u2,u1,??)
        Process::UID.eid = id     # (u2,u1,??) ==> (u2,id,??)
        Process::UID.re_exchange  # (u2,id,??) ==> (id,u2,??)

--- grant_privilege(id)
--- eid=(id)

    実効ユーザ ID を変更します。成功したら id を返します。

    保存ユーザ ID が変化するかどうかは Process::UID.re_exchangeable?
    が true を返すかどうかで決まります。re_exchangeable? が
    false の環境では保存ユーザ ID は変化しません。
    true の環境では、実ユーザ ID と異なる値を設定した場合、
    保存ユーザ ID は新しい実効ユーザ ID の値に設定されます。

    設定できない場合は例外 Errno::EPERM を発生します。

--- re_exchange

    実ユーザ ID と実効ユーザ ID とを入れ換えます。
    保存ユーザ ID は新しい実効ユーザ ID と同じになります。
    環境依存により実装されていない場合は例外を発生します。

    新しい実効ユーザ ID を返します。

--- re_exchangeable?

    実ユーザ ID と実効ユーザ ID との入れ換えが可能な環境かどうか
    (Process::UID.re_exchange が実装されているか) を真偽値で返します。
    入れ換え可能なら true を返します。

--- sid_available?

    保存ユーザ ID を持つ環境かどうかを真偽値で返します。
    保存ユーザ ID を持つなら true を返します。
    ただし、このメソッドの値には保証がありません。
    現在は次の条件のいずれかが満足される場合には
    保存ユーザ ID を持つものと判定しています。

      * setresuid() を持つ
      * seteuid() を持つ
      * _POSIX_SAVED_IDS が真として定義されている

--- switch
--- switch { .... }

    ユーザ権限を一時的に変更します。

    ブロックなしの場合は、呼び出すごとに実効ユーザ ID を
    実ユーザ ID または保存ユーザ ID に変更します。
    結果として、このメソッドを二回呼ぶと、その間だけ
    実効ユーザ ID が実ユーザ ID に変更されることにになります。

    ブロック付きの場合は、実効ユーザ ID を実ユーザ ID へ
    変更し、ブロックを実行したあとで実効ユーザ ID を元の
    値に戻します。

    ブロックなしの場合は元に戻せる (変更できる) ID を返します。
    ブロック付きの場合はブロックの値を返します。

    各ユーザ ID がこのメソッドを実行するのに適切な状態でない場合、
    つまり、実ユーザ ID・実効ユーザ ID・保存ユーザ ID が全て同じ
    場合には例外 Errno::EPERM を発生します。また、このメソッドを
    実装できない環境では例外 NotImplementedError が発生します。

    ブロック付きの場合は、なんらかの原因で元の権限に復帰できない
    ときにも例外 Errno::EPERM を発生します。原因としては例えば
    ブロック内でユーザ ID が変更されたなどの理由が挙げられます。

    なお、保存ユーザ ID を持たない環境でこのメソッドを実行すると
    実ユーザ ID が変化します。
